#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <dtwle.h>

/* #define DEBUGME */

extern int dtwExternal(dtw_lei_t * le_interface, dtw_parm_data_t *parmArray);

static void leDebug(dtw_lei_t * le_interface)
{
	int i;
	char *cp;
	dtw_parm_data_t *parmArray;

	fprintf(stdout, 
		"<pre>\n"
		"function_name        =%s\n"
		"flags                =%d\n>"
		"exec_statement       =%s\n"
	   	"dtw_parm_data_t      =%p\n"
	   	"default_error_message=%p\n"
	   	"row                  =%p\n",
	   		le_interface->function_name, 
	   		le_interface->flags,
	   		le_interface->exec_statement,
	   		parmArray = le_interface->parm_data_array,
	   		le_interface->default_error_message,
	   		le_interface->row);

	if (parmArray) {
		for (i = 0; parmArray->parm_descriptor != 0; i++, parmArray++) 
			fprintf(stdout,
				"parm_descriptor[%d]=%x<br>"
				"parm_name=%s<br>"
				"parm_value=%s<br>",
				i,
				parmArray->parm_descriptor,
				parmArray->parm_name,
				parmArray->parm_value);
	}

	fputs("</pre>", stdout);
}

#if 1 == 2
int main(int argc, char **argv)
{
	dtw_initialize((void *) 0);
	dtw_getFp((void *) 0);
	dtw_execute((void *) 0);
	dtw_cleanup((void *) 0);

	return 0;
}
#endif

int dtw_initialize(dtw_lei_t * le_interface)
{
	int rc = 0;

#ifdef DEBUGME
	FILE *fp;

	if (fp = fopen("/tmp/libdtw.log", "a")) {
		fprintf(fp, "dtw_initialize()\n");
		fflush(fp);
		fclose(fp);
	}
#endif

	return rc;
}

int dtw_execute(dtw_lei_t * le_interface)
{
	int rc = 0;
	char *cp;
	dtw_parm_data_t *parmArray;

#ifdef DEBUGME
   	leDebug(le_interface);
#endif

	parmArray = le_interface->parm_data_array;

	rc =  dtwExternal(le_interface, parmArray);

#ifdef DEBUGME
   	leDebug(le_interface);
#endif

	return rc;
}

int dtw_cleanup(dtw_lei_t * le_interface)
{
	int rc = 0;

	return rc;
}

int dtw_getFp(dtw_fp_t * functions)
{
	FILE *fp;

#ifdef DEBUGME
	if (fp = fopen("/tmp/libdtw.log", "a")) {
		fprintf(fp, "in dtw_getFp()\n");
		fflush(fp);
		fclose(fp);
	}
#endif

	functions->dtw_initialize_fp = dtw_initialize;
	functions->dtw_execute_fp = dtw_execute;
	functions->dtw_cleanup_fp = dtw_cleanup;
	functions->dtw_getNextRow_fp = NULL;

	return 0;
}

