#include <stdlib.h>
#include <errno.h>
#include <pthread.h>
#include "isdio.h"

int 
isdRecvAll(SOCKET socket, char *buffer, int len)
{
	int bytesSoFar, bytes;

	for (bytesSoFar = 0; bytesSoFar < len; bytesSoFar += bytes) {
		do {
			bytes = recv(socket, &buffer[bytesSoFar], len - bytesSoFar, 0);
		} while (bytes == -1 && 
			(errno == EINTR || errno == EWOULDBLOCK || errno == EAGAIN));

		if (bytes <= 0)
			break;
	}

	return (bytes == -1) ? -1:bytesSoFar;
}


int Xport 
isdRecvHeader(SOCKET socket, isdHeader * header)
{
	int bytes;

	bytes = isdRecvAll(socket, (char *) header, sizeof *header);

	if (bytes == sizeof *header)
		isdHeaderToH(header);

	return bytes == sizeof(*header) ? 1:0;
}

char *Xport 
isdRecv(SOCKET socket, isdHeader * header)
{
	int len, bytes;
	char *retbuf = NULL;
	static int size = 0;
	static char *buffer = NULL;

	if (buffer == NULL)
		buffer = (char *) malloc(size = 4096);

	if (isdRecvHeader(socket, header)) {

		if ((len = header->len) > size)
			buffer = (char *) realloc((void *) buffer, size = len);

		bytes = isdRecvAll(socket, buffer, len);

		if (bytes == len)
			retbuf = buffer;
	}

	return retbuf;
}

/*
This function provides a mechanism for programs that want to handle
memory management on their own (like Smalltalk VMs) or multi-threaded
programs that can't share an internal buffer.  

If the buffer supplied is large enough then the packet is read into
it.  If the buffer is not, the packet payload is discarded (for now).
*/

int Xport
isdRecvBuffer(SOCKET socket, isdHeader *header, char *buffer, int bufferLength)
{
	int bytes;
	char *localBuffer;

	if (isdRecvHeader(socket, header)) {
		localBuffer = buffer;
		if (bufferLength < header->len)
			localBuffer = malloc(header->len);

		bytes = isdRecvAll(socket, localBuffer, header->len);

		if (localBuffer != buffer)
			free(localBuffer);
	}

	return bytes;
}
