#include <stdlib.h>
#include <string.h>
#include <errno.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_WRITEV
#include <sys/uio.h>
#endif

#include "isdio.h"

int Xport 
isdSend(SOCKET socket, char *message, int len, isdHeader * header)
{
	int bytes;
	isdHeader myheader;
#ifdef HAVE_WRITEV
	struct iovec sendVec[2];
#endif

	header->len = len == -1 ? strlen(message) + 1 : len;

	myheader = *header;
	isdHeaderToN(&myheader);	/* convert header to network format */ 

#ifdef HAVE_WRITEV
	sendVec[0].iov_base = (void *) &myheader;
	sendVec[0].iov_len = sizeof myheader;

	sendVec[1].iov_base = (void *) message;
	sendVec[1].iov_len = header->len;

	do {
		bytes = writev(socket, sendVec, 2);
	} while (bytes == -1 && errno == EINTR);

	if (bytes > 0)
		bytes -= sizeof myheader;

#else
	if ((bytes = send(socket, (char *) &myheader, sizeof myheader, 0)) == sizeof myheader)
		bytes = send(socket, message, len, 0);
#endif

	return bytes;
}
