#include "isectd.h"

#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif

int 
isd1024(void)
{
#ifdef HAVE_STRUCT_RLIMIT
	int err;
	struct rlimit rlp;

	rlp.rlim_cur = rlp.rlim_max = FD_SETSIZE;

	if ((err = setrlimit(RLIMIT_NOFILE, &rlp)) != 0) {
		isdError("setrlimit()\n");
		isdLog("Unable to increase open files to 1024\n");
	}
	if ((err = getrlimit(RLIMIT_NOFILE, &rlp)) == 0)
		isdData.numberOfFiles = rlp.rlim_cur;
	else
		isdError("getrlimit()\n");
#else
#ifdef HAVE_ULIMIT
	isdLog("Using ulimit()\n");
	isdData.numberOfFiles = ulimit(4, 0);
#else
	isdLog("No ulimit()/get/setrlimit() not increasing RLIMIT_NOFILE\n");
	isdData.numberOfFiles = 256;
#endif
#endif
	isdLog("Using %d file descriptors\n", isdData.numberOfFiles);

	return 0;
}
