#ifndef ISECTD_H
#define ISECTD_H

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif


/*
#define FD_SETSIZE 256
*/
#include <stddef.h>
#include <string.h>

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#include "queues.h"
#include "libisect.h"
#include "isdio.h"

#define ADDBYTES
#ifdef _Windows
#include <dir.h>
#endif

#define DFLT_PO_CONFIG "./isectd.cfg"

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64		/* some hostnames get longer w/ domains attached */
#endif

#define ISDSECIPMASK 0			/* the quadruplet is a mask */
#define ISDSECIPADDR 1			/* the quadreplet is an address */
#define ISDSECIPALLOW 0			/* the address is allowed */
#define ISDSECIPDENY 1			/* the address is denied */

typedef struct {
	Node node;
	short addrType;				/* mask or address (above) */
	short action;				/* allow or deny (above) */
	struct in_addr sin_addr;
} isdSecureIP;

typedef struct {
	Node node;
	int id;
	Queue secureIP;
	char name[MAXSERVICENAMELEN];
} isdService;

typedef struct {
	Node node;
	int id;			/* must be directly after node */
	isdService *service;	/* id of the service I've requested (actually, the isdService *) */
	int service_id;	/* id of the service I've requested (actually, the isdService *) */
	int socket;		/* accept()ed socket or -1 if client is dead */
	int priority;	/* does this need an explanation? */
	int hostpid;	/* what you'd expect it to be */
	int ready;		/* has a request ready to go */
	void *worker;					/* if a worker has been assigned, this is it */
	int worker_id;
	time_t login_time;				/* when I logged into isectd */
	int Transactions;				/* updated after worker returns */
	ISDTIMETYPE AverageTime;				/* updated after worker returns */
	ISDTIMETYPE LastTime;				/* how long was the last transaction ? */
	struct sockaddr_in sockaddr;	/* the client's address */
	isdHeader header;				/* the client's message header */
	char *msgBuffer;				/* the buffer they sent */
	char loghost[MAXHOSTNAMELEN];	/* from gethostbyaddr() at login */
	short blocked;					/* TRUE if client process is blocked */
	short blockable;				/* Indicates whether isectd can block messages from this client */
	unsigned long  fromCount;		/* number of packets recevied from the client */
	unsigned long  toCount;			/* number of packets sent to the client */
} isdClient;

typedef struct {
	Node node;
	int id;							/* must be directly after node */
	isdService *service;			/* the service I work for */
	int service_id;	
	int socket;						/* accept()ed socket */
	int hostpid;					/* host process id */
	char name[MAXSERVICENAMELEN];	/* name of the worker (the service) */
	char host[MAXHOSTNAMELEN];		/* what host to start me on */
	char path[MAXPATHLEN];				/* where to find the worker-executable */
	char args[MAXPATHLEN];				/* additional arguments to the worker that I'll pass along */
	isdClient *client;				/* which client I'm working on or NULL if I'm idle */
	int client_id;
	isdHeader header;				/* the message header I'm working on */
	int Transactions;				/* updated after worker returns */
	ISDTIMETYPE AverageTime;		/* updated after worker returns */
	ISDTIMETYPE LastTime;		/* updated after worker returns */
	int restarts;					/* the number of times poServer has restarted me */
	int up_not_log_in;				/* Workers which have been started but not logged in */
	struct sockaddr_in sockaddr;	/* worker's sockaddr */
	short stopped;					/* don't restart if true */
	char loghost[MAXHOSTNAMELEN];	/* from gethostbyaddr() at login */
	int client_priority;			/* priority of the message I'm working on */
	int xoffs;						/* number of higher priority messages to clear before xoning me */
	unsigned long fromCount;		/* number of packets received from the worker */
	unsigned long toCount;			/* number of packets sent to the worker */
	short ready;					/* is the worker ready? */
	char *msgBuffer;				/* the message I'm working on */
} isdWorker;

typedef struct {
	Node node;
	char text[116];
} isdEvent;

struct isdData {
	int argc;
	char **argv;
	char configfile[MAXPATHLEN];	/* where is my config file? */
	char host[MAXHOSTNAMELEN];	/* which host am I on? */
	Queue ServiceList;	/* the ports I should open */
	Queue PriList;		/* all the poClient structs.. in priority order */
	Queue NewWorkers;	/* workers logging in */
	Queue LazyWorkers;	/* dead, unborn, or paused workers */
	Queue IdleWorkers;	/* waiting for something to do */
	Queue BusyWorkers;	/* busy doing something */
	fd_set allfds;		/* everybody including the workers and the roundezvous fd */
	fd_set writefds;	/* people on whom we're waiting to write to */
	SOCKET socket;		/* private socket used for callers to reply back to */
	int port;		/* private port, value passed to workers when started-up */
	int req_socket;		/* for client requests */
	int req_port;		/* for client requests */
	int NextClientID;	/* incremented sequentially - if I wrap I could get duplicates */
	int NextWorkerID;	/* incremented sequentially - if I wrap I could get duplicates */
	int NextServiceID;	/* incremented sequentially - if I wrap I could get duplicates */
	int MaxUsers;		/* The configurable allowable */
	char command_worker[MAXSERVICENAMELEN];	/* name of worker to use for poCommand */
	Queue Events;		/* what i've done - for debugging */
	int NumEvents;		/* how many events to keep */
	short NumBuckets;	/* how many buckets are there? */
	short BucketSecs;	/* how big is a bucket? */
	short PeakBucket;	/* largest since last reset */
	short *Buckets;		/* the last NumBuckets buckets */
	Queue OutBasket;	/* outgoing messages */
    unsigned long opid;	/* the service id for the ISDSERVICE */
	int numberOfFiles;	/* the value from getrlimit */
};

#ifndef SCOPE
#define SCOPE extern
#define SCOPE_CHEAT
#endif

SCOPE struct isdData isdData;

#ifdef SCOPE_CHEAT
#undef SCOPE_CHEAT
#undef SCOPE
#endif

#include "isectdproto.h"

#endif
