#include "isectd.h"

void 
isdWorkerBadge(fd_set readfds)
{
	fd_set myfds;
	int err = 1, address_len;
	isdWorker *newWorker, *worker;
	isdHeader header;
	isdBadge *badge;
	struct sockaddr_in sockaddr;
	struct timeval timeout;
	struct hostent *he;
	Node *node;

	for (node = isdData.NewWorkers.head; node != QNULL; node = node->next) {
		newWorker = (isdWorker *) node;

		if (FD_ISSET(newWorker->socket, &readfds)) {
			if (badge = (isdBadge *) isdRecv(newWorker->socket, &header)) {
				badge->hostpid = ntohl(badge->hostpid);
				badge->id = ntohl(badge->id);
				badge->priority = ntohl(badge->priority);
				badge->blockable = ntohl(badge->blockable);
				worker = (isdWorker *) QueueSearch(&isdData.LazyWorkers, QEQ, offsetof(isdWorker, id), badge->id, QNULL);
				if (worker != (isdWorker *) QNULL && worker->socket == -1) {
					worker->socket = newWorker->socket;
					worker->hostpid = badge->hostpid;
					memcpy((char *) &worker->sockaddr, (char *) &newWorker->sockaddr, sizeof worker->sockaddr);
					strcpy(worker->loghost, newWorker->loghost);
					isdLogEvent("worker=0x%x, hostpid=%d, loghost=%s", worker, worker->hostpid, worker->loghost);
					if (!FD_ISSET(worker->socket, &isdData.allfds))
						FD_SET(worker->socket, &isdData.allfds);
					isdLog("worker->id = %d, worker->hostpid = %d\n", worker->id, worker->hostpid);
					isdIdleWorker(worker);
					RemoveNode((Node *) newWorker);
					err = 0;
				}
				else
					isdLog("accept()'d more worker logins than there are workers!\n");
			}
			else
				isdError("isdRecv()ing worker login\n");
		}
	}
}
