#include <memory.h>
#include <stdlib.h>
#include <string.h>
#include "tabfuncs.h"

tabSpace *Xport 
tabAlloc(int hashsize)
{
	int i;
	tabSpace *ts;

	ts = (tabSpace *) calloc(hashsize, sizeof(*ts));

	ts[0].hashsize = hashsize;

	for (i = 0; i < hashsize; i++)
		QueueInit((Queue *) & ts[i]);

	return ts;
}

static int 
hash(tabSpace * ts, char *s)
{
	int hashval;

	for (hashval = 0; *s != 0;)
		hashval += *s++;

	return hashval % ts[0].hashsize;
}

tabEntry *Xport 
tabLookup(tabSpace * ts, char *s)
{
	Node *np;

	for (np = ts[hash(ts, s)].q.head; np != QNULL; np = np->next)
		if (strcmp(s, ((tabEntry *) np)->name) == 0)
			return (tabEntry *) np;

	return (tabEntry *) QNULL;
}
tabEntry *Xport 
tabInstallPtr(tabSpace * ts, char *name, char *def)
{
	tabEntry *np;
	int hashval;

	if ((np = tabLookup(ts, name)) == QNULL) {
		if (np = (tabEntry *) malloc(sizeof(*np))) {
			if (np->name = strdup(name)) {
				np->def = def;
				hashval = hash(ts, name);
				InsertTail((Queue *) & ts[hashval], (Node *) np);
			}
			else {
				free(np);
				np = NULL;
			}
		}
	}
	else {
		if (np->def)
			free(np->def);
		np->def = def;
	}
	return np;
}
tabEntry *Xport 
tabInstall(tabSpace * ts, char *name, char *def)
{
	tabEntry *np;
	int hashval;

	if ((np = tabLookup(ts, name)) == QNULL) {
		if (np = (tabEntry *) malloc(sizeof(*np))) {
			if (np->name = strdup(name))
				if (np->def = strdup(def)) {
					hashval = hash(ts, name);
					InsertTail((Queue *) & ts[hashval], (Node *) np);
				}
				else {
					free(np->name);
					free(np);
				}
			else
				free(np);
		}
	}
	else {
		if (np->def)
			free(np->def);
		np->def = strdup(def);
	}
	return np;
}

tabSpace *Xport 
tabFree(tabSpace * ts)
{
	int i, hashsize;
	Node *n;
	tabEntry *te;

	hashsize = ts[0].hashsize;

	for (i = 0; i < hashsize; i++) {
		while ((n = RemoveHead((Queue *) & ts[i])) != QNULL) {
			te = (tabEntry *) n;
			free(te->name);
			free(te->def);
			free(te);
		}
	}
	free((void *) ts);

	return (tabSpace *) NULL;
}

static void Xport 
tabDebugf(FILE * fp, char *format, tabSpace * ts)
{
	tabEntry *te;
	int i;

	for (i = 0; i < ts[0].hashsize; i++)
		for (te = (tabEntry *) ts[i].q.head; te != (tabEntry *) QNULL; te = (tabEntry *) te->n.next)
			fprintf(fp, format, te->name, te->def);
}

void Xport 
tabDebug(FILE * fp, tabSpace * ts)
{
	tabDebugf(fp, "%s=%s\n", ts);
}

void Xport
tabDebugPtr(FILE *fp, tabSpace *ts)
{
	tabDebugf(fp, "%s=%p\n", ts);
}

