#ifndef _RES_H
#define _RES_H

/*
** $Id: resource.h,v 1.3 2001/08/31 22:06:54 buytaert Exp $
*/


#include "jamjar.h"

typedef void (*j_it)(j_res res, void * arg);

typedef struct j_Res {
  unsigned int hash;             // hash value, it is calculated from the z_name field
  j_res next;                    // hashtable chain pointer
  j_res sorted;                  // sorted chain pointer  
  j_entry entry;                 // Could be NULL, if not, points to an entry
  j_class class;                 // Could be NULL, if not, points to a class structure
  j_class outer;                 // Could be NULL, if not, it's an inner class and 'outer' is the outer class
  char * r_name;                 // The name of the file from where we read its contents
  char * z_name;                 // The name of the file as it should appear in the jarfile
  j_byte * u_data;               // The uncompressed data of the resource
  j_size   u_size;               // The size of the uncompressed data
  j_crc crc;                     // The crc value of the uncompressed data
  j_byte * c_data;               // The compressed data of the resource
  j_size   c_size;               // The size of the compressed data
  time_t time;                   // Time of modification
  j_flags flags;                 // The RES_xxxxxx flags defined below
  j_arg arg;                     // The argument attached to this resource
  size_t offset;                 // Offset of local header in jar file
} j_Res;

#define RES_CLASS                0x00000001 // Resource is a class file
#define RES_WRITE                0x00000010 // Write this resource back to the output jar
#define RES_INNER                0x00000080 // Resource was added as inner class

void res_free(j_res res);
void res_attach_class(j_res res, j_arg arg, j_class class);
void res_attach_other(j_res res, j_arg arg);
j_res res_class(const char * name);
j_res res_entry(const char * name, size_t len);
j_res res_arg(j_arg arg);
j_res res_exists(j_res res);
j_res res_find(j_res res);
j_res res_sort(int (*cf)(const j_res * res1r, const j_res * res2r));
void res_hash(j_res res);
void res_add(j_res res);
void res_iterate(j_it it, void * arg);
const char * res_timefmt(j_res res);
const char * res_flagsfmt(j_res res);
void res_compress(j_res res);
void compress_cleanup(void);
time_t dos2unix(j_dosdate date, j_dostime time);
void unix2dos(time_t datetime, j_dosdate * date, j_dostime * time);

#endif /* _RES_H */
