/* -*- Mode: C; c-file-style: "gnu" -*-
   compiler.c -- native methods for java/lang/Compiler.
   Created: Chris Toshok <toshok@hungry.com>, 28-Jul-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "jni.h"

JNIEXPORT void JNICALL
Java_java_lang_Compiler_initialize(JNIEnv *env,
				   jclass cls)
{
}

JNIEXPORT jboolean JNICALL
Java_java_lang_Compiler_compileClass(JNIEnv *env,
				     jclass cls,
				     jclass target)
{
  return JNI_FALSE;
}

JNIEXPORT jboolean JNICALL
Java_java_lang_Compiler_compileClasses(JNIEnv *env,
				       jclass cls,
				       jstring string)
{
  return JNI_FALSE;
}

JNIEXPORT jobject JNICALL
Java_java_lang_Compiler_command(JNIEnv *env,
				jclass cls,
				jobject any)
{
  return NULL;
}

JNIEXPORT void JNICALL
Java_java_lang_Compiler_enable(JNIEnv *env,
			       jclass cls)
{
}

JNIEXPORT void JNICALL
Java_java_lang_Compiler_disable(JNIEnv *env,
				jclass cls)
{
}

/* JDK 1.2 uses registration of native methods... */
static JNINativeMethod compiler_native_methods[] = {
  { "initialize", "()V", (void*)Java_java_lang_Compiler_initialize },
  { "compileClass", "(Ljava/lang/Class;)Z", (void*)Java_java_lang_Compiler_compileClass },
  { "compileClasses", "(Ljava/lang/String;)Z", (void*)Java_java_lang_Compiler_compileClasses },
  { "command", "(Ljava/lang/Object;)Ljava/lang/Object;", (void*)Java_java_lang_Compiler_command },
  { "enable", "()V", (void*)Java_java_lang_Compiler_enable },
  { "disable", "()V", (void*)Java_java_lang_Compiler_disable }
};
static int num_compiler_native_methods = sizeof(compiler_native_methods) / sizeof(compiler_native_methods[0]);

/* JDK1.2 */
JNIEXPORT void JNICALL
Java_java_lang_Compiler_registerNatives(JNIEnv *env,
					jclass cls)
{
#ifdef HAVE_LIBFFI
  (*env)->RegisterNatives(env, cls,
			  compiler_native_methods,
			  num_compiler_native_methods);
#endif
}
