/* -*- Mode: C; c-file-style: "gnu" -*-
   math.c -- native methods for java/lang/Math.
   Created: Chris Toshok <toshok@hungry.com>, 28-Jul-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "jni.h"
#include <math.h>

JNIEXPORT jdouble JNICALL
Java_java_lang_Math_sin(JNIEnv *env,
			jclass cls,
			jdouble s)
{
  return sin(s);
}

JNIEXPORT jdouble JNICALL
Java_java_lang_Math_cos(JNIEnv *env,
			jclass cls,
			jdouble s)
{
  return cos(s);
}

JNIEXPORT jdouble JNICALL
Java_java_lang_Math_tan(JNIEnv *env,
			jclass cls,
			jdouble s)
{
  return tan(s);
}

JNIEXPORT jdouble JNICALL
Java_java_lang_Math_asin(JNIEnv *env,
			 jclass cls,
			 jdouble s)
{
  return asin(s);
}

JNIEXPORT jdouble JNICALL
Java_java_lang_Math_acos(JNIEnv *env,
			 jclass cls,
			 jdouble s)
{
  return acos(s);
}

JNIEXPORT jdouble JNICALL
Java_java_lang_Math_atan(JNIEnv *env,
			 jclass cls,
			 jdouble s)
{
  return atan(s);
}

JNIEXPORT jdouble JNICALL
Java_java_lang_Math_exp(JNIEnv *env,
			jclass cls,
			jdouble s)
{
  return exp(s);
}

JNIEXPORT jdouble JNICALL
Java_java_lang_Math_log(JNIEnv *env,
			jclass cls,
			jdouble s)
{
  return log(s);
}

JNIEXPORT jdouble JNICALL
Java_java_lang_Math_sqrt(JNIEnv *env,
			 jclass cls,
			 jdouble s)
{
  return sqrt(s);
}

JNIEXPORT jdouble JNICALL
Java_java_lang_Math_IEEEremainder(JNIEnv *env,
				  jclass cls,
				  jdouble f1,
				  jdouble f2)
{
  return fmod(f1, f2);
}

JNIEXPORT jdouble JNICALL
Java_java_lang_Math_ceil(JNIEnv *env,
			 jclass cls,
			 jdouble s)
{
  return ceil(s);
}

JNIEXPORT jdouble JNICALL
Java_java_lang_Math_floor(JNIEnv *env,
			  jclass cls,
			  jdouble s)
{
  return floor(s);
}

JNIEXPORT jdouble JNICALL
Java_java_lang_Math_rint(JNIEnv *env,
			 jclass cls,
			 jdouble s)
{
#ifdef HAVE_RINT
  return rint(s);
#else /* punt */
  return floor(s);
#endif
}

JNIEXPORT jdouble JNICALL
Java_java_lang_Math_atan2(JNIEnv *env,
			  jclass cls,
			  jdouble a,
			  jdouble b)
{
  return atan2(a,b);
}

JNIEXPORT jdouble JNICALL
Java_java_lang_Math_pow(JNIEnv *env,
			jclass cls,
			jdouble a,
			jdouble b)
{
  return pow(a,b);
}
