/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"

#include "dynamic_loading.h"

#if !defined HAVE_LIBFFI || !defined HAVE_DLL || defined PROFILING

#include "java_security_AccessController_stubs.c"

sym_mapping java_sec_mappings[] = {
  MAPPING( Java_java_security_AccessController_doPrivileged__Ljava_security_PrivilegedAction_2_stub ),
  MAPPING( Java_java_security_AccessController_doPrivileged__Ljava_security_PrivilegedAction_2Ljava_security_AccessControlContext_2_stub ),
  MAPPING( Java_java_security_AccessController_doPrivileged__Ljava_security_PrivilegedExceptionAction_2_stub ),
  MAPPING( Java_java_security_AccessController_doPrivileged__Ljava_security_PrivilegedExceptionAction_2Ljava_security_AccessControlContext_2_stub ),
  MAPPING( Java_java_security_AccessController_getInheritedAccessControlContext_stub ),
  MAPPING( Java_java_security_AccessController_getStackAccessControlContext_stub )
};

int num_java_sec_mappings = sizeof(java_sec_mappings) / sizeof(java_sec_mappings[0]);
#endif
