/* -*- Mode: C; c-file-style: "gnu" -*-
   resbundle.c -- native methods for java/util/ResourceBundle.c
   Created: Chris Toshok <toshok@hungry.com>, 25-Aug-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "jni.h"
#include "interp.h"
#include "native-threads.h"

JNIEXPORT jobjectArray JNICALL
Java_java_util_ResourceBundle_getClassContext(JNIEnv *env,
					      jclass cls)
{
  JThreadInfo *info = THREAD_getJavaInfo();
  StackFrame *f;
  int num_java_frames = 0;
  int i;
  jarray cls_array;
  jclass cls_cls = (*env)->FindClass(env, "java/lang/Class");

  f = info->top_frame;
  while (f != info->stack_highwater)
    {
      if (!(f->flags & FRAME_NATIVE))
	num_java_frames ++;
      
      f = get_frame_parent(f);
    }
  
  cls_array = (*env)->NewObjectArray(env, num_java_frames,
				     cls_cls, NULL);
  
  i = 0;
  f = info->top_frame;
  while (f != info->stack_highwater)
    {
      if (!(f->flags & FRAME_NATIVE))
	(*env)->SetObjectArrayElement(env, cls_array,
				      i++,
				      clazzfile_to_jclass(env, f->method->clazz));
      f = get_frame_parent(f);
    }
  
  cls_array = (*env)->NewGlobalRef(env, cls_array);
  return cls_array;
}
