/* -*- Mode: C; c-file-style: "gnu" -*-
   audiodev.c -- native methods for sun/audio/AudioDevice.
   Created: Chris Toshok <toshok@hungry.com>, 13-Mar-1998
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "jni.h"

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <fcntl.h>

#ifdef USE_DEV_AUDIO
int fd = -1;
#endif

JNIEXPORT jint JNICALL
Java_sun_audio_AudioDevice_audioOpen(JNIEnv *env,
				     jobject obj)
{
#ifdef USE_DEV_AUDIO
  fd = open("/dev/audio", O_WRONLY);

  return fd;
#else
  /* no audio device */
  return -1;
#endif
}

JNIEXPORT void JNICALL
Java_sun_audio_AudioDevice_audioClose(JNIEnv *env,
				      jobject obj)
{
#ifdef USE_DEV_AUDIO
  close(fd);
#endif
}

JNIEXPORT void JNICALL
Java_sun_audio_AudioDevice_audioWrite(JNIEnv *env,
				      jobject obj,
				      jbyteArray arr,
				      int len)
{
  jbyte *bytes;

  bytes = (*env)->GetByteArrayElements(env, arr, NULL);

#ifdef USE_DEV_AUDIO
  write(fd, bytes, len);
#endif

  (*env)->ReleaseByteArrayElements(env, arr, bytes, JNI_ABORT);
}
