/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "config.h"

#ifndef HAVE_LIBFFI

#include "sun_awt_motif_InputThread_stubs.c"
#include "sun_awt_motif_MButtonPeer_stubs.c"
#include "sun_awt_motif_MCanvasPeer_stubs.c"
#include "sun_awt_motif_MCheckboxMenuItemPeer_stubs.c"
#include "sun_awt_motif_MCheckboxPeer_stubs.c"
#include "sun_awt_motif_MChoicePeer_stubs.c"
#include "sun_awt_motif_MComponentPeer_stubs.c"
#include "sun_awt_motif_MDialogPeer_stubs.c"
#include "sun_awt_motif_MDrawingSurfaceInfo_stubs.c"
#include "sun_awt_motif_MFileDialogPeer_stubs.c"
#include "sun_awt_motif_MFramePeer_stubs.c"
#include "sun_awt_motif_MLabelPeer_stubs.c"
#include "sun_awt_motif_MListPeer_stubs.c"
#include "sun_awt_motif_MMenuBarPeer_stubs.c"
#include "sun_awt_motif_MMenuItemPeer_stubs.c"
#include "sun_awt_motif_MMenuPeer_stubs.c"
#include "sun_awt_motif_MPopupMenuPeer_stubs.c"
#include "sun_awt_motif_MScrollPanePeer_stubs.c"
#include "sun_awt_motif_MScrollbarPeer_stubs.c"
#include "sun_awt_motif_MTextAreaPeer_stubs.c"
#include "sun_awt_motif_MTextFieldPeer_stubs.c"
#include "sun_awt_motif_MToolkit_stubs.c"
#include "sun_awt_motif_MWindowPeer_stubs.c"
#include "sun_awt_motif_X11FontMetrics_stubs.c"
#include "sun_awt_motif_X11Graphics_stubs.c"
#include "sun_awt_motif_X11Selection_stubs.c"

#include "dynamic_loading.h"
#if (!defined HAVE_DLL) || defined PROFILING
sym_mapping sun_awt_motif_mappings[] = {
  MAPPING(Java_sun_awt_motif_InputThread_run_stub),
  MAPPING(Java_sun_awt_motif_MButtonPeer_create_stub),
  MAPPING(Java_sun_awt_motif_MButtonPeer_setLabel_stub),
  MAPPING(Java_sun_awt_motif_MCanvasPeer_create_stub),
  MAPPING(Java_sun_awt_motif_MCheckboxMenuItemPeer_pSetState_stub),
  MAPPING(Java_sun_awt_motif_MCheckboxPeer_create_stub),
  MAPPING(Java_sun_awt_motif_MCheckboxPeer_setLabel_stub),
  MAPPING(Java_sun_awt_motif_MCheckboxPeer_setState_stub),
  MAPPING(Java_sun_awt_motif_MCheckboxPeer_setCheckboxGroup_stub),
  MAPPING(Java_sun_awt_motif_MChoicePeer_create_stub),
  MAPPING(Java_sun_awt_motif_MChoicePeer_pReshape_stub),
  MAPPING(Java_sun_awt_motif_MChoicePeer_select_stub),
  MAPPING(Java_sun_awt_motif_MChoicePeer_setFont_stub),
  MAPPING(Java_sun_awt_motif_MChoicePeer_remove_stub),
  MAPPING(Java_sun_awt_motif_MChoicePeer_addItem_stub),
  MAPPING(Java_sun_awt_motif_MChoicePeer_setBackground_stub),
  MAPPING(Java_sun_awt_motif_MChoicePeer_setForeground_stub),
  MAPPING(Java_sun_awt_motif_MComponentPeer_pInitialize_stub),
  MAPPING(Java_sun_awt_motif_MComponentPeer_pShow_stub),
  MAPPING(Java_sun_awt_motif_MComponentPeer_pHide_stub),
  MAPPING(Java_sun_awt_motif_MComponentPeer_pEnable_stub),
  MAPPING(Java_sun_awt_motif_MComponentPeer_pDisable_stub),
  MAPPING(Java_sun_awt_motif_MComponentPeer_pReshape_stub),
  MAPPING(Java_sun_awt_motif_MComponentPeer_pAddRepaint_stub),
  MAPPING(Java_sun_awt_motif_MComponentPeer_pTriggerRepaint_stub),
  MAPPING(Java_sun_awt_motif_MComponentPeer_pDispose_stub),
  MAPPING(Java_sun_awt_motif_MComponentPeer_pMakeCursorVisible_stub),
  MAPPING(Java_sun_awt_motif_MComponentPeer_pGetLocationOnScreen_stub),
#ifdef JDK_11
  MAPPING(Java_sun_awt_motif_MComponentPeer_setForeground_stub),
  MAPPING(Java_sun_awt_motif_MComponentPeer_setBackground_stub),
#endif
  MAPPING(Java_sun_awt_motif_MComponentPeer_setFont_stub),
  MAPPING(Java_sun_awt_motif_MComponentPeer_setCursor_stub),
#ifdef JDK_11
  MAPPING(Java_sun_awt_motif_MComponentPeer_handleEvent_stub),
#endif
  MAPPING(Java_sun_awt_motif_MComponentPeer_requestFocus_stub),
  MAPPING(Java_sun_awt_motif_MDialogPeer_create_stub),
  MAPPING(Java_sun_awt_motif_MDialogPeer_pSetTitle_stub),
  MAPPING(Java_sun_awt_motif_MDialogPeer_pShow_stub),
  MAPPING(Java_sun_awt_motif_MDialogPeer_pHide_stub),
  MAPPING(Java_sun_awt_motif_MDialogPeer_pReshape_stub),
  MAPPING(Java_sun_awt_motif_MDialogPeer_pDispose_stub),
  MAPPING(Java_sun_awt_motif_MDialogPeer_setResizable_stub),
  MAPPING(Java_sun_awt_motif_MDialogPeer_toBack_stub),
  MAPPING(Java_sun_awt_motif_MDrawingSurfaceInfo_lock_stub),
  MAPPING(Java_sun_awt_motif_MDrawingSurfaceInfo_unlock_stub),
  MAPPING(Java_sun_awt_motif_MDrawingSurfaceInfo_getDisplay_stub),
  MAPPING(Java_sun_awt_motif_MDrawingSurfaceInfo_getDrawable_stub),
  MAPPING(Java_sun_awt_motif_MDrawingSurfaceInfo_getDepth_stub),
  MAPPING(Java_sun_awt_motif_MDrawingSurfaceInfo_getVisualID_stub),
  MAPPING(Java_sun_awt_motif_MDrawingSurfaceInfo_getColormapID_stub),
  MAPPING(Java_sun_awt_motif_MFileDialogPeer_create_stub),
  MAPPING(Java_sun_awt_motif_MFileDialogPeer_pReshape_stub),
  MAPPING(Java_sun_awt_motif_MFileDialogPeer_pDispose_stub),
  MAPPING(Java_sun_awt_motif_MFileDialogPeer_pShow_stub),
  MAPPING(Java_sun_awt_motif_MFileDialogPeer_pHide_stub),
  MAPPING(Java_sun_awt_motif_MFileDialogPeer_setFileEntry_stub),
  MAPPING(Java_sun_awt_motif_MFileDialogPeer_setFont_stub),
  MAPPING(Java_sun_awt_motif_MFramePeer_create_stub),
  MAPPING(Java_sun_awt_motif_MFramePeer_pSetTitle_stub),
  MAPPING(Java_sun_awt_motif_MFramePeer_pShow_stub),
  MAPPING(Java_sun_awt_motif_MFramePeer_pHide_stub),
  MAPPING(Java_sun_awt_motif_MFramePeer_pReshape_stub),
  MAPPING(Java_sun_awt_motif_MFramePeer_pDispose_stub),
  MAPPING(Java_sun_awt_motif_MFramePeer_pSetIconImage_stub),
  MAPPING(Java_sun_awt_motif_MFramePeer_setResizable_stub),
  MAPPING(Java_sun_awt_motif_MFramePeer_pSetMenuBar_stub),
  MAPPING(Java_sun_awt_motif_MFramePeer_toBack_stub),
  MAPPING(Java_sun_awt_motif_MLabelPeer_create_stub),
  MAPPING(Java_sun_awt_motif_MLabelPeer_setText_stub),
  MAPPING(Java_sun_awt_motif_MLabelPeer_setAlignment_stub),
  MAPPING(Java_sun_awt_motif_MListPeer_create_stub),
  MAPPING(Java_sun_awt_motif_MListPeer_setMultipleSelections_stub),
  MAPPING(Java_sun_awt_motif_MListPeer_isSelected_stub),
  MAPPING(Java_sun_awt_motif_MListPeer_addItem_stub),
  MAPPING(Java_sun_awt_motif_MListPeer_delItems_stub),
  MAPPING(Java_sun_awt_motif_MListPeer_select_stub),
  MAPPING(Java_sun_awt_motif_MListPeer_deselect_stub),
  MAPPING(Java_sun_awt_motif_MListPeer_makeVisible_stub),
  MAPPING(Java_sun_awt_motif_MMenuBarPeer_create_stub),
#ifdef JDK_11
  MAPPING(Java_sun_awt_motif_MMenuBarPeer_dispose_stub),
#endif
  MAPPING(Java_sun_awt_motif_MMenuItemPeer_createMenuItem_stub),
  MAPPING(Java_sun_awt_motif_MMenuItemPeer_pSetLabel_stub),
  MAPPING(Java_sun_awt_motif_MMenuItemPeer_pEnable_stub),
  MAPPING(Java_sun_awt_motif_MMenuItemPeer_pDisable_stub),
  MAPPING(Java_sun_awt_motif_MMenuItemPeer_pDispose_stub),
  MAPPING(Java_sun_awt_motif_MMenuPeer_createMenu_stub),
  MAPPING(Java_sun_awt_motif_MMenuPeer_createSubMenu_stub),
  MAPPING(Java_sun_awt_motif_MMenuPeer_pDispose_stub),
  MAPPING(Java_sun_awt_motif_MPopupMenuPeer_createMenu_stub),
  MAPPING(Java_sun_awt_motif_MPopupMenuPeer_pShow_stub),
  MAPPING(Java_sun_awt_motif_MPopupMenuPeer_pDispose_stub),
  MAPPING(Java_sun_awt_motif_MScrollPanePeer_create_stub),
  MAPPING(Java_sun_awt_motif_MScrollPanePeer_pSetScrollChild_stub),
  MAPPING(Java_sun_awt_motif_MScrollPanePeer_pSetIncrement_stub),
  MAPPING(Java_sun_awt_motif_MScrollPanePeer_pGetScrollbarSpace_stub),
  MAPPING(Java_sun_awt_motif_MScrollPanePeer_pGetBlockIncrement_stub),
  MAPPING(Java_sun_awt_motif_MScrollPanePeer_pInsets_stub),
  MAPPING(Java_sun_awt_motif_MScrollPanePeer_setScrollPosition_stub),
  MAPPING(Java_sun_awt_motif_MScrollbarPeer_create_stub),
#ifdef JDK_11
  MAPPING(Java_sun_awt_motif_MScrollbarPeer_pSetValues_stub),
#endif
  MAPPING(Java_sun_awt_motif_MScrollbarPeer_setLineIncrement_stub),
  MAPPING(Java_sun_awt_motif_MScrollbarPeer_setPageIncrement_stub),
  MAPPING(Java_sun_awt_motif_MTextAreaPeer_create_stub),
  MAPPING(Java_sun_awt_motif_MTextAreaPeer_getExtraWidth_stub),
  MAPPING(Java_sun_awt_motif_MTextAreaPeer_getExtraHeight_stub),
  MAPPING(Java_sun_awt_motif_MTextAreaPeer_setTextBackground_stub),
  MAPPING(Java_sun_awt_motif_MTextAreaPeer_pSetEditable_stub),
  MAPPING(Java_sun_awt_motif_MTextAreaPeer_select_stub),
  MAPPING(Java_sun_awt_motif_MTextAreaPeer_getSelectionStart_stub),
  MAPPING(Java_sun_awt_motif_MTextAreaPeer_getSelectionEnd_stub),
  MAPPING(Java_sun_awt_motif_MTextAreaPeer_setText_stub),
  MAPPING(Java_sun_awt_motif_MTextAreaPeer_getText_stub),
  MAPPING(Java_sun_awt_motif_MTextAreaPeer_insert_stub),
  MAPPING(Java_sun_awt_motif_MTextAreaPeer_replaceRange_stub),
  MAPPING(Java_sun_awt_motif_MTextAreaPeer_setFont_stub),
  MAPPING(Java_sun_awt_motif_MTextAreaPeer_setCaretPosition_stub),
  MAPPING(Java_sun_awt_motif_MTextAreaPeer_getCaretPosition_stub),
  MAPPING(Java_sun_awt_motif_MTextFieldPeer_create_stub),
  MAPPING(Java_sun_awt_motif_MTextFieldPeer_pSetEditable_stub),
  MAPPING(Java_sun_awt_motif_MTextFieldPeer_select_stub),
  MAPPING(Java_sun_awt_motif_MTextFieldPeer_getSelectionStart_stub),
  MAPPING(Java_sun_awt_motif_MTextFieldPeer_getSelectionEnd_stub),
  MAPPING(Java_sun_awt_motif_MTextFieldPeer_setText_stub),
  MAPPING(Java_sun_awt_motif_MTextFieldPeer_insertReplaceText_stub),
  MAPPING(Java_sun_awt_motif_MTextFieldPeer_preDispose_stub),
  MAPPING(Java_sun_awt_motif_MTextFieldPeer_getText_stub),
  MAPPING(Java_sun_awt_motif_MTextFieldPeer_setEchoChar_stub),
  MAPPING(Java_sun_awt_motif_MTextFieldPeer_setFont_stub),
  MAPPING(Java_sun_awt_motif_MTextFieldPeer_setCaretPosition_stub),
  MAPPING(Java_sun_awt_motif_MTextFieldPeer_getCaretPosition_stub),
  MAPPING(Java_sun_awt_motif_MToolkit_init_stub),
  MAPPING(Java_sun_awt_motif_MToolkit_run_stub),
  MAPPING(Java_sun_awt_motif_MToolkit_makeColorModel_stub),
  MAPPING(Java_sun_awt_motif_MToolkit_getScreenResolution_stub),
  MAPPING(Java_sun_awt_motif_MToolkit_getScreenWidth_stub),
  MAPPING(Java_sun_awt_motif_MToolkit_getScreenHeight_stub),
  MAPPING(Java_sun_awt_motif_MToolkit_sync_stub),
  MAPPING(Java_sun_awt_motif_MToolkit_beep_stub),
  MAPPING(Java_sun_awt_motif_MToolkit_loadSystemColors_stub),
  MAPPING(Java_sun_awt_motif_MWindowPeer_create_stub),
  MAPPING(Java_sun_awt_motif_MWindowPeer_pShow_stub),
  MAPPING(Java_sun_awt_motif_MWindowPeer_pHide_stub),
  MAPPING(Java_sun_awt_motif_MWindowPeer_pReshape_stub),
  MAPPING(Java_sun_awt_motif_MWindowPeer_pDispose_stub),
  MAPPING(Java_sun_awt_motif_MWindowPeer_toBack_stub),
#ifdef JDK_11
  MAPPING(Java_sun_awt_motif_X11FontMetrics_getMFCharSegmentWidth_stub),
#endif
  MAPPING(Java_sun_awt_motif_X11FontMetrics_bytesWidth_stub),
  MAPPING(Java_sun_awt_motif_X11FontMetrics_init_stub),

  MAPPING( Java_sun_awt_motif_X11Graphics_createFromComponent_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_createFromGraphics_stub ),
#ifdef JDK_11
  MAPPING( Java_sun_awt_motif_X11Graphics_imageCreate_stub ),
#endif
  MAPPING( Java_sun_awt_motif_X11Graphics_pSetFont_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_pSetForeground_stub ),
#ifdef JDK_11
  MAPPING( Java_sun_awt_motif_X11Graphics_dispose_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_setPaintMode_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_setXORMode_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_getClipBounds_stub ),
#endif
  MAPPING( Java_sun_awt_motif_X11Graphics_changeClip_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_removeClip_stub ),
#ifdef JDK_11
  MAPPING( Java_sun_awt_motif_X11Graphics_clearRect_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_fillRect_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_drawRect_stub ),
#endif
  MAPPING( Java_sun_awt_motif_X11Graphics_drawSFChars_stub ),
#ifdef JDK_11
  MAPPING( Java_sun_awt_motif_X11Graphics_drawMFCharsSegment_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_drawBytes_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_drawLine_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_copyArea_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_drawRoundRect_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_fillRoundRect_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_drawPoly_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_fillPolygon_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_drawOval_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_fillOval_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_drawArc_stub ),
  MAPPING( Java_sun_awt_motif_X11Graphics_fillArc_stub ),
#endif

  MAPPING(Java_sun_awt_motif_X11Selection_init_stub),
  MAPPING(Java_sun_awt_motif_X11Selection_getAtomForTarget_stub),
  MAPPING(Java_sun_awt_motif_X11Selection_registerTargetForFlavor_stub),
  MAPPING(Java_sun_awt_motif_X11Selection_create_stub),
  MAPPING(Java_sun_awt_motif_X11Selection_pDispose_stub),
  MAPPING(Java_sun_awt_motif_X11Selection_pGetSelectionOwnership_stub),
  MAPPING(Java_sun_awt_motif_X11Selection_pGetTransferTargets_stub),
  MAPPING(Java_sun_awt_motif_X11Selection_pGetTransferData_stub)
};

int num_sun_awt_motif_mappings = sizeof(sun_awt_motif_mappings) / sizeof(sun_awt_motif_mappings[0]);

#endif

#endif /* !HAVE_LIBFFI */
