/* -*- Mode: C; c-file-style: "gnu" -*-
   canvas.c -- native methods for sun.awt.motif.MCanvasPeer
   Created: Chris Toshok <toshok@hungry.com>, 9-Mar-1998.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "config.h"

#include "jni.h"

#include "common.h"
#include <Xm/Xm.h>
#include <Xm/DrawingA.h>

void
Java_sun_awt_motif_MCanvasPeer_create(JNIEnv *env,
				      jobject peer,
				      jobject parent_peer)
{
  Widget canvas_widget, parent_widget;
  Arg av[10];
  int ac;

  if (parent_peer != NULL)
    parent_widget = get_component_widget(env, parent_peer);
  else
    parent_widget = _awt_toplevelWidget;

  LOCK_AWT();

  ac = 0;
  XtSetArg(av[ac], XmNmarginHeight, 0); ac++;
  XtSetArg(av[ac], XmNmarginWidth, 0); ac++;

  canvas_widget = XmCreateDrawingArea(parent_widget,
				      "canvas",
				      av, ac);

  add_canvas_exposure_handler(canvas_widget, peer);

  inherit_background_from(parent_widget, canvas_widget);

  UNLOCK_AWT();

  set_component_widget(env, peer, canvas_widget);
}
