/* -*- Mode: C; c-file-style: "gnu" -*-
   image.c -- native methods for sun/awt/image/ImageRepresentation...
   Created: Chris Toshok <toshok@hungry.com>, 11-Oct-1998
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#include "jni.h"

#include "common.h"

void
Java_sun_awt_image_ImageRepresentation_offscreenInit(JNIEnv *env,
						     jobject obj,
						     jobject color)
{
  Pixmap pixmap;
  jclass cls = (*env)->GetObjectClass(env, obj);
  jfieldID width_field, height_field;
  jint width, height;

  width_field = (*env)->GetFieldID(env, cls, "width", "I");
  height_field = (*env)->GetFieldID(env, cls, "height", "I");

  width = (*env)->GetIntField(env, obj, width_field);
  height = (*env)->GetIntField(env, obj, height_field);

  printf ("ImageRepresentation_offscreenInit(this = %p, width = %d, height = %d)\n", obj);

  LOCK_AWT();
  pixmap = XCreatePixmap(_awt_Display,
			 RootWindowOfScreen(_awt_Screen),
			 width, height, 16 /*depth*/);
  UNLOCK_AWT();

  printf ("    pixmap = %d\n", pixmap);
  NSA_SetNativeState(obj, pixmap);
}

jboolean
Java_sun_awt_image_ImageRepresentation_setBytePixels(JNIEnv *env,
						     jobject obj,
						     jint i1,
						     jint i2,
						     jint i3,
						     jint i4,
						     jint i5,
						     jobject color_model,
						     jbyteArray bytes,
						     jint i6, jint i7)
{
  printf ("i1 = %d\ni2 = %d\ni3 = %d\ni4 = %d\ni5 = %d\ni6 = %d\ni7=%d\n",
	  i1, i2, i3, i4, i5, i6, i7);

  /*  (*env)->FatalError(env, "Java_sun_awt_image_ImageRepresentation_setBytePixels not implemented");*/
  return JNI_TRUE;
}

jboolean
Java_sun_awt_image_ImageRepresentation_setIntPixels(JNIEnv *env,
						    jobject obj,
						    jint i1,
						    jint i2,
						    jint i3,
						    jint i4,
						    jint i5,
						    jobject color_model,
						    jintArray ints,
						    jint i6, jint i7)
{
  /*  (*env)->FatalError(env, "Java_sun_awt_image_ImageRepresentation_setIntPixels not implemented");*/
  return JNI_FALSE;
}

jboolean
Java_sun_awt_image_ImageRepresentation_finish(JNIEnv *env,
					      jobject obj)
{
  /*  (*env)->FatalError(env, "Java_sun_awt_image_ImageRepresentation_finish not implemented");*/
  return JNI_TRUE;
}

void
Java_sun_awt_image_ImageRepresentation_disposeImage(JNIEnv *env,
						    jobject obj)
{
  Pixmap pixmap = (Pixmap)NSA_GetNativeState(obj);

  LOCK_AWT();
  XFreePixmap(_awt_Display, pixmap);
  UNLOCK_AWT();
}

void
Java_sun_awt_image_ImageRepresentation_imageDraw(JNIEnv *env,
						 jobject obj,
						 jobject graphics,
						 int x, int y,
						 jobject color)
{
  Pixmap pixmap = (Pixmap)NSA_GetNativeState(obj);
  GraphicsData* data = get_graphics_data(env, graphics);
  jclass cls = (*env)->GetObjectClass(env, obj);
  jfieldID width_field, height_field;
  jint width, height;
  jfieldID originX_field, originY_field;
  jint originX, originY;

  width_field = (*env)->GetFieldID(env, cls, "width", "I");
  height_field = (*env)->GetFieldID(env, cls, "height", "I");
  width = (*env)->GetIntField(env, obj, width_field);
  height = (*env)->GetIntField(env, obj, height_field);

  originX_field = (*env)->GetFieldID(env, (*env)->GetObjectClass(env, graphics), "originX", "I");
  originY_field = (*env)->GetFieldID(env, (*env)->GetObjectClass(env, graphics), "originY", "I");
  originX = (*env)->GetIntField(env, graphics, originX_field);
  originY = (*env)->GetIntField(env, graphics, originY_field);

  printf ("ImageRepresentation_imageDraw(x = %d, y = %d, width = %d, height = %d)\n",
	  x + originX, y + originY, width, height);

  if (pixmap != None
      && data->drawable != None)
    {
      LOCK_AWT();
      XCopyArea(_awt_Display, pixmap, data->drawable, data->gc, 0, 0, width, height, x + originX, y + originY);
      UNLOCK_AWT();
    }
}

void
Java_sun_awt_image_ImageRepresentation_imageStretch(JNIEnv *env,
						    jobject obj,
						    jobject graphics,
						    int x1, int y1,
						    int width1, int height1,
						    int x2, int y2,
						    int width2, int height2,
						    jobject color)
{
  Pixmap pixmap = (Pixmap)NSA_GetNativeState(obj);
  GraphicsData* data = get_graphics_data(env, graphics);
  jclass cls = (*env)->GetObjectClass(env, obj);

  printf ("ImageRepresentation_imageStretch(x1 = %d, y1 = %d, width1 = %d, height1 = %d, x2 = %d, y2 = %d, width2 = %d, height2  =%d)\n",
	  x1, y1, width1, height1, x2, y2, width2, height2);

  if (pixmap != None
      && data->drawable != None)
    {
      LOCK_AWT();
      XCopyArea(_awt_Display, pixmap, data->drawable, data->gc, x1, y1, width2, height2, x2, y2);
      UNLOCK_AWT();
    }
}
