/* -*- Mode: C; c-file-style: "gnu" -*-
   break.c -- breakpoints for the debugger.
   Created: Chris Toshok <toshok@hungry.com>, 31-Nov-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998 The Hungry Programmers

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _japhard_break_h
#define _japhard_break_h

#include "jvmdi.h"
#include "ClazzFile.h"

extern void BREAK_listBreakpoints(void);

extern void BREAK_addMethodBreakpoint(char *classname, char *methodname);
extern void BREAK_addPCBreakpoint(char *classname, char *methodname,
				  char *typesig, int pc);
extern void BREAK_addPCBreakpoint2(ClazzFile *clazz,
				   MethodStruct *method,
				   int pc);
extern void BREAK_addPCBreakpoint3(char *classname, char *methodname,
				   int pc);
extern void BREAK_addLineBreakpoint(char *filename, int line);

extern void BREAK_disableBreakpoint(int bp_num);
extern void BREAK_enableBreakpoint(int bp_num);
extern void BREAK_removeBreakpoint(int bp_num);

extern int BREAK_getBreakpointNum(jclass cls,
				  jmethodID method,
				  jlocation loc);

extern jboolean BREAK_isBreakpointEnabled(int bp_num);
extern jbyte BREAK_getRealOpcode(int bp_num);

#endif /* _japhard_break_h */
