/* -*- Mode: C; c-file-style: "gnu" -*-
   stack.c -- functions dealing with stack frames.
   Created: Chris Toshok <toshok@hungry.com>, 5-Feb-1998.
 */

#include "jniint.h"
#include "jvmdi.h"
#include "stack.h"

/* The JNIEnv* for the debugger thread. */
extern JNIEnv *debugger_env;

/* The thread where we're currently stepping (if we're stepping), or
   the thread which hit a breakpoint. */
jthread current_thread;

/* The frame we're interested in. */
jframeID current_frame;

/* The frame the breakpoint was in. */
jframeID break_frame;

int current_bpnum;

void
print_backtrace()
{
  /* we don't use current_frame here, since that is modified by
     up/down commands, and we want to print the entire backtrace. */
  jframeID frame;
  int depth = 0;

  if (JVMDI_GetCurrentFrame(debugger_env, current_thread, &frame) 
      != JVMDI_ERROR_NONE)
    {
      fprintf (stderr, "error getting current frame\n");
    }
  else
    {
      while (frame)
	{
	  jlocation loc;
	  jmethodID method;
	  jclass clazz;

	  if (JVMDI_GetFrameLocation(debugger_env,
				     frame, &clazz, &method, &loc)
	      != JVMDI_ERROR_NONE)
	    {
	      frame = NULL;
	    }
	  else
	    {
	      jframeID new_frame;

	      printf ("#%d, %s\n", depth++, method->name);
	      
	      if (JVMDI_GetCallerFrame(debugger_env,
				       frame, &new_frame) != JVMDI_ERROR_NONE)
		frame = NULL;
	      else
		frame = new_frame;
	    }
	}
    }
}

void
print_current_frame()
{
  jlocation loc;
  jmethodID method;
  jclass class;

  if (JVMDI_GetFrameLocation(debugger_env,
			     current_frame, &class, &method, &loc)
      != JVMDI_ERROR_NONE)
    {
      fprintf (stderr, "error getting current location\n");
    }

  printf ("Breakpoint %d, %s\n", current_bpnum, method->name);
}

void
up_frame(int num_levels)
{
  printf ("up_frame()\n");
}

void
down_frame(int num_levels)
{
  printf ("down_frame()\n");
}
