/* -*- Mode: C; c-file-style: "gnu" -*-
   clazz.c -- spew dealing with classes.
   Created: Chris Toshok <toshok@hungry.com>, 5-Dec-1997.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "config.h"
#include "japharh.h"

#include <stdlib.h>

void
spew_clazz(FILE *fp, ClazzFile *clazz)
{
  int i;
  char *ename;

  output_begin_type(fp);
  output_begin_access_flags(fp);
  spew_access_flags_pretty(fp, clazz->access_flags);
  output_end_access_flags(fp);

  ename = output_escape_name(clazz->class_name);
  if (clazz->access_flags & ACC_INTERFACE)
    fprintf (fp, " interface %s", ename);
  else
    fprintf (fp, " class %s", ename);
  free(ename);

  output_end_type(fp);

  if (getSuperClass(THREAD_getEnv(), clazz))
    {
      output_newline(fp);
      fprintf (fp, " extends ");

      output_begin_type(fp);

      output_begin_link_to_class(fp, getSuperClass(THREAD_getEnv(), clazz));
      ename = output_escape_name(getSuperClassName(THREAD_getEnv(), clazz));
      fprintf (fp, " %s", ename);
      free(ename);
      output_end_link(fp);

      output_end_type(fp);
    }
  if (clazz->num_interfaces)
    {
      output_newline(fp);
      fprintf (fp, "implements");

      for (i = 0; i < clazz->num_interfaces; i ++)
	{
	  ClazzFile *interface = clazz->interfaces[i];
	  char *interface_name = getClassName(THREAD_getEnv(),
					      interface);

	  output_begin_type(fp);

	  output_begin_link_to_class(fp, interface);
	  ename = output_escape_name(interface_name);
	  fprintf (fp, " %s", ename);
	  free(ename);
	  output_end_link(fp);

	  output_end_type(fp);

	  if (i < clazz->num_interfaces - 1)
	    fprintf (fp, ",");
	}

      output_newline(fp);
    }

  fprintf (fp, " {");

  output_newline(fp);
  output_newline(fp);

  if (clazz->num_fields > 0)
    {
      output_begin_comment(fp);
      fprintf (fp, "/* fields */");
      output_end_comment(fp);
      output_newline(fp);
    }
  output_begin_fields(fp);
  for (i = 0; i < clazz->num_fields; i ++)
    {
      if (clazz->fields[i]->clazz == clazz)
	spew_field(fp, clazz->fields[i]);
    }
  output_end_fields(fp);

  output_newline(fp);

  if (clazz->num_methods > 0)
    {
      output_begin_comment(fp);
      fprintf (fp, "/* methods */");
      output_end_comment(fp);
      output_newline(fp);
    }
  output_begin_methods(fp);
  for (i = 0; i < clazz->num_methods; i ++)
    {
      if (clazz->methods[i]->clazz == clazz)
	spew_method(fp, clazz->methods[i]);
    }
  output_end_methods(fp);


  output_newline(fp);
  fprintf (fp, "}");
  output_newline(fp);
}
