/* -*- Mode: C; c-file-style: "gnu" -*-
   japharh.h -- Javah header.
   Created: Chris Toshok <toshok@hungry.com>
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef javah_h
#define javah_h

#include "ClazzFile.h"
#include <stdio.h>

extern void spew_header(ClazzFile*, char*);
extern void spew_stubs(ClazzFile*, char*);
extern void spew_dump(ClazzFile*, char*);

void output_method_prototypes(ClazzFile *cf, FILE *fp);
void output_method_prototype(FILE *fp,
			     const char *prefix,
			     const char *class_name,
			     const char *method_name,
			     char *sig_str, int isStatic);
char *slashes_to_bars(char *clazzname);

/* in clazz.c */
extern void spew_clazz(FILE *fp, ClazzFile *cls);

/* in method.c */
extern void spew_method(FILE *fp, MethodStruct *method);

/* in field.c */
extern void spew_field(FILE *fp, FieldStruct *field);

/* in misc.c */
extern void spew_access_flags(FILE *fp, int access_flags);
extern void spew_access_flags_pretty(FILE *fp, int access_flags);

/* in html.c */
extern void html_begin_access_flags(FILE *fp);
extern void html_end_access_flags(FILE *fp);
extern void html_begin_comment(FILE *fp);
extern void html_end_comment(FILE *fp);
extern void html_begin_type(FILE *fp);
extern void html_end_type(FILE *fp);
extern void html_begin_method_name(FILE *fp);
extern void html_end_method_name(FILE *fp);
extern void html_begin_field_name(FILE *fp);
extern void html_end_field_name(FILE *fp);
extern void html_header(FILE *fp, char *classname);
extern void html_footer(FILE *fp);
extern void html_newline(FILE *fp);
extern void html_begin_opcodes(FILE *fp);
extern void html_end_opcodes(FILE *fp);
extern void html_begin_methods(FILE *fp);
extern void html_end_methods(FILE *fp);
extern void html_begin_fields(FILE *fp);
extern void html_end_fields(FILE *fp);
extern void html_begin_link_to_class(FILE *fp, ClazzFile *clazz);
extern void html_begin_link_to_method(FILE *fp, MethodStruct *method);
extern void html_begin_link_to_field(FILE *fp, FieldStruct *field);
extern void html_end_link(FILE *fp);
extern void html_location_for_method(FILE *fp, MethodStruct *method);
extern void html_location_for_field(FILE *fp, FieldStruct *field);
extern char *html_escape_name(char *name);
extern void html_begin_exception_style(FILE *fp);
extern void html_end_exception_style(FILE *fp);

/* in output.c */
extern void output_begin_access_flags(FILE *fp);
extern void output_end_access_flags(FILE *fp);
extern void output_begin_comment(FILE *fp);
extern void output_end_comment(FILE *fp);
extern void output_begin_type(FILE *fp);
extern void output_end_type(FILE *fp);
extern void output_begin_method_name(FILE *fp);
extern void output_end_method_name(FILE *fp);
extern void output_begin_field_name(FILE *fp);
extern void output_end_field_name(FILE *fp);
extern void output_header(FILE *fp, char *classname);
extern void output_footer(FILE *fp);
extern void output_newline(FILE *fp);
extern void output_begin_opcodes(FILE *fp);
extern void output_end_opcodes(FILE *fp);
extern void output_begin_methods(FILE *fp);
extern void output_end_methods(FILE *fp);
extern void output_begin_fields(FILE *fp);
extern void output_end_fields(FILE *fp);
extern void output_begin_link_to_class(FILE *fp, ClazzFile *clazz);
extern void output_begin_link_to_method(FILE *fp, MethodStruct *method);
extern void output_begin_link_to_field(FILE *fp, FieldStruct *field);
extern void output_end_link(FILE *fp);
extern void output_location_for_method(FILE *fp, MethodStruct *method);
extern void output_location_for_field(FILE *fp, FieldStruct *field);
extern char *output_escape_name(char *name);
extern void output_begin_exception_style(FILE *fp);
extern void output_end_exception_style(FILE *fp);
#endif
