/* -*- Mode: C; c-file-style: "gnu" -*-
   misc.c -- misc spew
   Created: Chris Toshok <toshok@hungry.com>, 5-Dec-1997.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "config.h"
#include "japharh.h"

#define CHECK_FLAG(flag, text, sep) \
  do {\
	if ((flag) & access_flags) \
	  { \
	    if (need_sep) \
	      fprintf (fp, sep); \
	    fprintf (fp, text); \
	    need_sep = JNI_TRUE; \
	  } \
  } while (0)

void
spew_access_flags(FILE *fp, int access_flags)
{
  jboolean need_sep = JNI_FALSE;

  CHECK_FLAG(ACC_PUBLIC,     "ACC_PUBLIC", " | ");
  CHECK_FLAG(ACC_PRIVATE,    "ACC_PRIVATE", " | ");
  CHECK_FLAG(ACC_PROTECTED,  "ACC_PROTECTED", " | ");
  CHECK_FLAG(ACC_STATIC,     "ACC_STATIC", " | ");
  CHECK_FLAG(ACC_FINAL,      "ACC_FINAL", " | ");
  CHECK_FLAG(ACC_SYNCHRONIZED, "ACC_SYNCHRONIZED", " | ");
  CHECK_FLAG(ACC_VOLATILE,    "ACC_VOLATILE", " | ");
  CHECK_FLAG(ACC_TRANSIENT,  "ACC_TRANSIENT", " | ");
  CHECK_FLAG(ACC_NATIVE,     "ACC_NATIVE", " | ");
  CHECK_FLAG(ACC_INTERFACE,  "ACC_INTERFACE", " | ");
  CHECK_FLAG(ACC_ABSTRACT,   "ACC_ABSTRACT", " | ");
}

void
spew_access_flags_pretty(FILE *fp, int access_flags)
{
  jboolean need_sep = JNI_FALSE;

  CHECK_FLAG(ACC_PUBLIC,     "public", " ");
  CHECK_FLAG(ACC_PRIVATE,    "private", " ");
  CHECK_FLAG(ACC_PROTECTED,  "protected", " ");
  CHECK_FLAG(ACC_STATIC,     "static", " ");
  CHECK_FLAG(ACC_FINAL,      "final", " ");
  CHECK_FLAG(ACC_SYNCHRONIZED, "synchronized", " ");
  CHECK_FLAG(ACC_VOLATILE,    "volatile", " ");
  CHECK_FLAG(ACC_TRANSIENT,  "transient", " ");
  CHECK_FLAG(ACC_NATIVE,     "native", " ");
  CHECK_FLAG(ACC_INTERFACE,  "interface", " ");
  CHECK_FLAG(ACC_ABSTRACT,   "abstract", " ");
}
