/* -*- Mode: C; c-file-style: "gnu" -*-
   output.c -- spew stuff, independant of output format.
   Created: Chris Toshok <toshok@hungry.com>, 5-Dec-1997.
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1998 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "config.h"
#include "japharh.h"

#include <string.h>

extern jboolean as_html;

void
output_begin_access_flags(FILE *fp)
{
  if (as_html)
    html_begin_access_flags(fp);
}

void
output_end_access_flags(FILE *fp)
{
  if (as_html)
    html_end_access_flags(fp);
}

void
output_begin_comment(FILE *fp)
{
  if (as_html)
    html_begin_comment(fp);
}

void
output_end_comment(FILE *fp)
{
  if (as_html)
    html_end_comment(fp);
}

void
output_begin_type(FILE *fp)
{
  if (as_html)
    html_begin_type(fp);
}

void
output_end_type(FILE *fp)
{
  if (as_html)
    html_end_type(fp);
}

void
output_begin_method_name(FILE *fp)
{
  if (as_html)
    html_begin_method_name(fp);
}

void
output_end_method_name(FILE *fp)
{
  if (as_html)
    html_end_method_name(fp);
}

void
output_begin_field_name(FILE *fp)
{
  if (as_html)
    html_begin_field_name(fp);
}

void
output_end_field_name(FILE *fp)
{
  if (as_html)
    html_end_field_name(fp);
}

void
output_header(FILE *fp, char *classname)
{
  if (as_html)
    html_header(fp, classname);
}

void
output_footer(FILE *fp)
{
  if (as_html)
    html_footer(fp);
}

void
output_newline(FILE *fp)
{
  if (as_html)
    html_newline(fp);
  else
    fprintf(fp, "\n");
}

void
output_begin_opcodes(FILE *fp)
{
  if (as_html)
    html_begin_opcodes(fp);
}

void
output_end_opcodes(FILE *fp)
{
  if (as_html)
    html_end_opcodes(fp);
}

void
output_begin_methods(FILE *fp)
{
  if (as_html)
    html_begin_methods(fp);
}

void
output_end_methods(FILE *fp)
{
  if (as_html)
    html_end_methods(fp);
}

void
output_begin_fields(FILE *fp)
{
  if (as_html)
    html_begin_fields(fp);
}

void
output_end_fields(FILE *fp)
{
  if (as_html)
    html_end_fields(fp);
}

void
output_begin_link_to_class(FILE *fp,
			   ClazzFile *clazz)
{
  if (as_html)
    html_begin_link_to_class(fp, clazz);
}

void
output_begin_link_to_method(FILE *fp,
			    MethodStruct *method)
{
  if (as_html)
    html_begin_link_to_method(fp, method);
}

void
output_begin_link_to_field(FILE *fp,
			   FieldStruct *field)
{
  if (as_html)
    html_begin_link_to_field(fp, field);
}

void
output_end_link(FILE *fp)
{
  if (as_html)
    html_end_link(fp);
}

void
output_location_for_method(FILE *fp, MethodStruct *method)
{
  if (as_html)
    html_location_for_method(fp, method);
}

void
output_location_for_field(FILE *fp, FieldStruct *field)
{
  if (as_html)
    html_location_for_field(fp, field);
}

char *
output_escape_name(char *name)
{
  if (as_html)
    return html_escape_name(name);
  else
    return strdup(name);
}

void
output_begin_exception_style(FILE *fp)
{
  if (as_html)
    html_begin_exception_style(fp);
}

void
output_end_exception_style(FILE *fp)
{
  if (as_html)
    html_end_exception_style(fp);
}
