/*
 * Test if parameter transfered arrays are recognized as such.\
 */
public class ArrayCastTest
{

  public static void testInstanceOf(Object param)
    {
      if (param instanceof Object[])
	System.out.println("PASSED: String[][] instanceof Object[]");
      else
	System.out.println("FAILED: String[][] !instanceof Object[]");
    }

  public static void testNotInstanceOf(Object param)
    {
      if (param instanceof Float[])
	System.out.println("FAILED: String[][] instanceof Float[]");
      else
	System.out.println("PASSED: String[][] !instanceof Float[]");
    }


  public static void testCastOk(Object param)
    {
      try {
	Object[] newval = (Object[])param;
	System.out.println("PASSED: String[][] castable to Object[]");
      } catch (ClassCastException e){
	System.out.println("FAILED: ClassCastException: " + e.getMessage() );
      }
    }

  public static void testCastNotOk(Object param)
    {
      try {
	Integer[] newval = (Integer[])param;
	System.out.println("FAILED: String[][] castable to Integer[]");
      } catch (ClassCastException e){
	System.out.println("PASSED: ClassCastException: " + e.getMessage());
      }
    }

  public static void testPrimitiveCastOk(Object param)
    {
      try {
	int[][] newval = (int[][])param;
	System.out.println("PASSED: int[][] castable to int[][]");
      } catch (ClassCastException e){
	System.out.println("FAILED: ClassCastException: " + e.getMessage());
      }
    }

  public static void testPrimitiveCastNotOk(Object param)
    {
      try {
	char[][] newval = (char[][])param;
	System.out.println("FAILED: int[][] castable to char[][]");
      } catch (ClassCastException e){
	System.out.println("PASSED: ClassCastException: " + e.getMessage());
      }
    }

  public static void main(String args[]) {
    try {
      String[][] strarray = new String[10][2];

      testInstanceOf(strarray);
      testNotInstanceOf(strarray);

      testCastOk(strarray);
      testCastNotOk(strarray);

      int[][] intarray = new int[5][10];

      testPrimitiveCastOk(intarray);
      testPrimitiveCastNotOk(intarray);

    } catch (Exception e) {
      System.out.println("FAILED: caught Exception: " + e.getMessage());
    }
  }
}
