import java.net.*;
import java.io.*;

/*
 * Connect to www.hungry.com:smtp and make sure something is returned
 */

public class SocketReceiveTest
{
  public static final String host = "www.hungry.com";
  public static final int port = 25;
  public static String received;

  public static void receive()
    throws Exception
    {
      InetAddress address = InetAddress.getByName(host);
      Socket receiver = new Socket(address, port);
      DataInputStream in = new DataInputStream(receiver.getInputStream());

      byte[] buffer = new byte[100];
      int length = in.read(buffer);
      receiver.close();

      received = new String(buffer, 0, length);
    }
  public static void main(String args[])
    {
      try {
	receive();

	if ( received.startsWith(" 220") )
		throw new Exception("Wrong answer: message="+received);

	System.out.println("PASSED: Socket receive message="+received);
	System.exit(0);
      } catch (Exception e) {
	System.out.println("FAILED: " + e);
	System.exit(0);
      }
    }
}
