#ifndef _parse_h_
#define _parse_h_

/*
 *  This file is part of jcabc2ps,
 *  Copyright(C) 1996,1997,1998  Michael Methfessel
 *  See file jcabc2ps.c for details.
 */

#include "jcabc2ps.h"

extern int oldks;
extern int dtype[30];		/* Decoration types */
extern int decos;		/* Number of decorations on current symbol */

int  add_sym(int type);
int  find_voice(char vid[], int *new);
int  get_halftones(struct KEYSTR key, char transpose[]);
int  get_line(FILE *fp, Str *lp);
int  get_xref(char str[]);
int  info_field(char str[]);
int  insert_sym(int type, int k);
int  is_comment(char str[]);
int  is_end_line(char str[]);
int  is_info_field(char str[]);
int  is_pseudocomment(char str[]);
int  is_selected( char xref_str[], int npat, char pat[][STRL1], int select_all, int search_field);
int  isnote(char c);
int  numeric_pitch(char note);
int  prsBar(void);
int  parse_basic_note(int *pitch, int *length, int *accidental);
int  parse_esc(void);
int  prsGrSeq(int pgr[], int agr[]);
int  prsLen(void);
int  parse_nl(void);
int  parse_space(void);
int  prsSym(void);
int  parse_vocals(char line[]);
int  prsAch(void);
int  prsAnn(void);
int  prsDeco(void);
int  prsMusLine(char line[]);
int  prsNote(void);
int  prsUInt(void);
int  read_line(FILE *fp, int do_music, Str* line);
int  rehash_selectors(char sel_str[], char xref_str[], char pat[][STRL1]);
int  set_keysig(char s[], struct KEYSTR *ks, int init);
int  switch_voice(char str[]);
int  symbolic_pitch(int pit, char str[]);
Ksig * newKsig(char *C);
char *add_wd(char str[]);
void ach_transpose(struct KEYSTR *key);
void add_text(char str[], int type);
void append_key_change(struct KEYSTR *oldkey, struct KEYSTR *newkey);
void append_meter(struct METERSTR meter);
void decomment_line(char ln[]);
void do_index(FILE *fp, char xref_str[], int npat, char pat[][STRL1], int select_all, int search_field);
void do_transpose(struct KEYSTR *key, int *pitch, int *acc);
void double_note(int i, int num, int sign, char *q);
void get_default_info(void);
void handle_inside_field(int type);
void identify_note(struct SYMBOL *s, char *q);
void init_parse_params(void);
void reset_info(struct ISTRUCT *inf);
void set_dlen(char str[], struct METERSTR *meter);
void set_meter(char str[], struct METERSTR *meter);
void set_transtab(int nht, struct KEYSTR *key);
void shift_key(int sf_old, int nht, int *sfnew, int *addt);
void syntax(char msg[], char *q);
void trim_title(char s[], char s0[]);
void zeroSym(Sym*s, char*d);

#endif
