/* jumpgate -- jumpgate.h
 * Patroklos G. Argyroudis <argp@cs.tcd.ie>
 *
 * $Id: jumpgate.h,v 1.18 2002/10/17 08:59:39 argp Exp $
 */

#ifndef _JUMPGATE_H_
#define _JUMPGATE_H_

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdarg.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/wait.h>
#include <signal.h>
#include <syslog.h>
#include <errno.h>

#define VERSION		"0.7"

#define MYMAXFDS	23
#define MAXLINE		81
#define BUFSIZE		4096
#define BACKLOG		1024

#ifndef	INADDR_NONE
#define	INADDR_NONE	((unsigned long) -1)
#endif

struct jump
{
 int cfd;			/* socket descriptor */
 int rport;			/* remote port */
 useconds_t latency;		/* latency in microseconds */
 char *hostname;		/* remote host name */
 in_addr_t hostaddr;		/* remote host address */
 int log_flag;
 int latency_flag;
 char *logfile;			/* name of the logfile */
};

void	usage(char *name);
void	help(char *name);
void	chld_reap(int signo);
int	daemonize(const char *path);
void	query(struct jump *jmp);
void	tcp_jumpgate(struct jump *jmp);
void	fixfile(char *file, FILE *pf);
void	error_exit(int errno_flag, char *msg);
void	error_log(int errno_flag, int exit_flag, int priority, char *msg);

#endif /* _JUMPGATE_H_ */

/* EOF */
