/*
 * Java core library component.
 *
 * Copyright (c) 2002
 *      Dalibor Topic <robilad@yahoo.com>.  All rights reserved.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file.
 */

package org.kaffe.util.locale;

import java.util.ListResourceBundle;

public class Language_de extends ListResourceBundle {
    public Object [] [] getContents() {
	return contents;
    }

    private Object [] [] contents = {
	{ "ab", "Abchasisch" }, // ABKHAZIAN
	{ "aa", "Afar" }, // AFAR
	{ "af", "Afrikaans" }, // AFRIKAANS
	{ "sq", "Albanisch" }, // ALBANIAN
	{ "am", "Amharisch" }, // AMHARIC
	{ "ar", "Arabisch" }, // ARABIC
	{ "hy", "Armenisch" }, // ARMENIAN
	{ "as", "Assami" }, // ASSAMESE
	{ "ae", "Avestan" }, // AVESTAN
	{ "ay", "Aymara" }, // AYMARA
	{ "az", "Aserbaidschanisch" }, // AZERBAIJANI

	{ "ba", "Baschkirisch" }, // BASHKIR
	{ "eu", "Baskisch" }, // BASQUE
	{ "be", "Belarussisch" }, // BELARUSIAN
	{ "bn", "Bengali" }, // BENGALI
	{ "bh", "Bihari" }, // BIHARI
	{ "bi", "Bislama" }, // BISLAMA
	{ "nb", "Norwegisches Bokm\u00E5l" }, // NORWEGIAN BOKMAL
	{ "bs", "Bosnisch" }, // BOSNIAN
	{ "br", "Bretonisch" }, // BRETON
	{ "bg", "Bulgarisch" }, // BULGARIAN
	{ "my", "Burmanisch" }, // BURMESE

	{ "es", "Spanisch" }, // CASTILLIAN; SPANISH
	{ "ca", "Katalanisch" }, // CATALAN
	{ "ch", "Chamorro" }, // CHAMORRO
	{ "ce", "Tschetschenisch" }, // CHECHEN
	{ "ny", "Nyanja" }, // CHEWA; CHICHEWA; NYANJA
	{ "zh", "Chinesisch" }, // CHINESE
	{ "za", "Zhuang" }, // CHUANG; ZHUANG
	{ "cu", "Kirchenslawisch" }, // CHURCH SLAVIC; SLAVONIC; CHURCH SLAVONIC; OLD BULGARIAN; OLD CHURCH SLAVONIC
	{ "cv", "Chuvash" }, // CHUVASH
	{ "kw", "Kornisch" }, // CORNISH
	{ "co", "Korsisch" }, // CORSICAN
	{ "hr", "Kroatisch" }, // CROATIAN
	{ "cs", "Tschechisch" }, // CZECH

	{ "da", "D\u00E4nisch" }, // DANISH
	{ "nl", "Niederl\u00E4ndisch" }, // DUTCH
	{ "dz", "Bhutanisch" }, // DZONGKHA

	{ "en", "Englisch" }, // ENGLISH
	{ "eo", "Esperanto" }, // ESPERANTO
	{ "et", "Estnisch" }, // ESTONIAN

	{ "fo", "F\u00E4r\u00F6isch" }, // FAROESE
	{ "fj", "Fidschianisch" }, // FIJIAN
	{ "fi", "Finnisch" }, // FINNISH
	{ "fr", "Franz\u00F6sisch" }, // FRENCH
	{ "fy", "Friesisch" }, // FRISIAN

	{ "gd", "Schottisch" }, // GAELIC; SCOTTISH GAELIC
	{ "gl", "Galicisch" }, // GALLEGAN
	{ "ka", "Georgisch" }, // GEORGIAN
	{ "de", "Deutsch" }, // GERMAN
	{ "ki", "Kikuyu" }, // GIKUYU; KIKUYU
	{ "el", "Griechisch" }, // MODERN GREEK
	{ "gn", "Guarani" }, // GUARANI
	{ "gu", "Gujarati" }, // GUJARATI

	{ "ha", "Hausa" }, // HAUSA
	{ "he", "Hebr\u00E4isch" }, // HEBREW
	{ "iw", "Hebr\u00E4isch" }, // HEBREW (WITHDRAWN)
	{ "hz", "Herero" }, // HERERO
	{ "hi", "Hindi" }, // HINDI
	{ "ho", "Hiri Motu" }, // HIRI MOTU
	{ "hu", "Ungarisch" }, // HUNGARIAN

	{ "is", "Isl\u00E4ndisch" }, // ICELANDIC
	{ "io", "Ido" }, // IDO
	{ "id", "Indonesisch" }, // INDONESIAN
	{ "in", "Indonesisch" }, // INDONESIAN (WITHDRAWN)
	{ "ia", "Interlingua" }, // INTERLINGUA
	{ "ie", "Interlingue" }, // INTERLINGUE
	{ "iu", "Inuktitut" }, // INUKTITUT
	{ "ik", "Inupiak" }, // INUPIAQ
	{ "ga", "Irisch" }, // IRISH
	{ "it", "Italienisch" }, // ITALIAN

	{ "ja", "Japanisch" }, // JAPANESE
	{ "jv", "Javanisch" }, // JAVANESE

	{ "kl", "Gr\u00F6nl\u00E4ndisch" }, // KALAALLISUT
	{ "kn", "Kannada" }, // KANNADA
	{ "ks", "Kaschmirisch" }, // KASHMIRI
	{ "kk", "Kasachisch" }, // KAZAKH
	{ "km", "Kambodschanisch" }, // KHMER
	{ "rw", "Kinyarwanda" }, // KINYARWANDA
	{ "ky", "Kirgisisch" }, // KIRGHIZ
	{ "kv", "Komi" }, // KOMI
	{ "ko", "Koreanisch" }, // KOREAN
	{ "kj", "Kuanyama" }, // KUANYAMA; KWANYAMA
	{ "ku", "Kurdisch" }, // KURDISH

	{ "lo", "Laotisch" }, // LAO
	{ "la", "Latein" }, // LATIN
	{ "lv", "Lettisch" }, // LATVIAN
	{ "lb", "Luxemburgisch" }, // LETZEBURGESCH; LUXEMBOURGISH
	{ "li", "Limburgish" }, // LIMBURGAN; LIMBURGER; LIMBURGISH
	{ "ln", "Lingala" }, // LINGALA
	{ "lt", "Litauisch" }, // LITHUANIAN

	{ "mk", "Mazedonisch" }, // MACEDONIAN
	{ "mg", "Malagassi" }, // MALAGASY
	{ "ms", "Malaysisch" }, // MALAY
	{ "ml", "Malayalam" }, // MALAYALAM
	{ "mt", "Maltesisch" }, // MALTESE
	{ "gv", "Manx" }, // MANX
	{ "mi", "Maori" }, // MAORI
	{ "mr", "Marathi" }, // MARATHI
	{ "mh", "Marshallese" }, // MARSHALLESE
	{ "mo", "Moldavisch" }, // MOLDAVIAN
	{ "mn", "Mongolisch" }, // MONGOLIAN

	{ "na", "Nauruisch" }, // NAURU
	{ "nv", "Navajo" }, // NAVAHO; NAVAJO
	{ "nd", "Nord Debele" }, // NORTH NDEBELE
	{ "nr", "S\u00FCd Debele" }, // SOUTH NDEBELE
	{ "ng", "Ndonga" }, // NDONGA
	{ "ne", "Nepalesisch" }, // NEPALI
	{ "se", "Nordsamisch" }, // NORTHERN SAMI
	{ "no", "Norwegisch" }, // NORWEGIAN
	{ "nn", "Norwegisches Nynorsk" }, // NORWEGIAN NYNORSK

	{ "oc", "Okzitanisch" }, // OCCITAN; PROVENCAL
	{ "or", "Oriya" }, // ORIYA
	{ "om", "Oromo" }, // OROMO
	{ "os", "Ossetisch" }, // OSSETIAN; OSSETIC

	{ "pi", "Pali" }, // PALI
	{ "pa", "Pandschabi" }, // PANJABI
	{ "fa", "Persisch" }, // PERSIAN
	{ "pl", "Polnisch" }, // POLISH
	{ "pt", "Portugiesisch" }, // PORTUGUESE
	{ "ps", "Puschto" }, // PUSHTO

	{ "qu", "Quechua" }, // QUECHUA

	{ "rm", "R\u00E4toromanisch" }, // RAETO-ROMANCE
	{ "ro", "Rum\u00E4nisch" }, // ROMANIAN
	{ "rn", "Rundi" }, // RUNDI
	{ "ru", "Russisch" }, // RUSSIAN

	{ "sm", "Samoanisch" }, // SAMOAN
	{ "sg", "Sango" }, // SANGO
	{ "sa", "Sanskrit" }, // SANSKRIT
	{ "sc", "Sardisch" }, // SARDINIAN
	{ "sr", "Serbisch" }, // SERBIAN
	{ "sh", "Serbokroatisch" }, // SERBO-CROATIAN (WITHDRAWN)
	{ "sn", "Shona" }, // SHONA
	{ "ii", "Sichuan Yi" }, // SICHUAN YI
	{ "sd", "Sindhi" }, // SINDHI
	{ "si", "Sinhalese" }, // SINHALESE
	{ "sk", "Slowakisch" }, // SLOVAK
	{ "sl", "Slowenisch" }, // SLOVENIAN
	{ "so", "Somali" }, // SOMALI
	{ "st", "Sesotho" }, // SOUTHERN SOTHO
	{ "su", "Sundanesisch" }, // SUNDANESE
	{ "sw", "Swahili" }, // SWAHILI
	{ "ss", "Swati" }, // SWATI
	{ "sv", "Schwedisch" }, // SWEDISH

	{ "tl", "Tagalog" }, // TAGALOG
	{ "ty", "Tahitian" }, // TAHITIAN
	{ "tg", "Tadschikisch" }, // TAJIK
	{ "ta", "Tamil" }, // TAMIL
	{ "tt", "Tatarisch" }, // TATAR
	{ "te", "Telugu" }, // TELUGU
	{ "th", "Thai" }, // THAI
	{ "bo", "Tibetisch" }, // TIBETAN
	{ "ti", "Tigrinja" }, // TIGRINYA
	{ "to", "Tongaisch" }, // TONGA (TONGA ISLANDS)
	{ "ts", "Tsonga" }, // TSONGA
	{ "tn", "Tswana" }, // TSWANA
	{ "tr", "T\u00FCrkisch" }, // TURKISH
	{ "tk", "Turkmenisch" }, // TURKMEN
	{ "tw", "Twi" }, // TWI

	{ "ug", "Uigurisch" }, // UIGHUR
	{ "uk", "Ukrainisch" }, // UKRAINIAN
	{ "ur", "Urdu" }, // URDU
	{ "uz", "Usbekisch" }, // UZBEK

	{ "vi", "Vietnamesisch" }, // VIETNAMESE
	{ "vo", "Volap\u00FCk" }, // VOLAPUK

	{ "wa", "Wallonisch" }, // WALLOON
	{ "cy", "Walisisch" }, // WELSH
	{ "wo", "Wolof" }, // WOLOF

	{ "xh", "Xhosa" }, // XHOSA

	{ "yi", "Jiddish" }, // YIDDISH
	{ "ji", "Jiddish" }, // YIDDISH (WITHDRAWN)
	{ "yo", "Yoruba" }, // YORUBA

	{ "zu", "Zulu" }, // ZULU
    };
}
