#include <qt4.hpp>

using namespace std;

#ifdef __cplusplus
extern "C" {
#endif

extern bool exec_flag;

#ifdef K_USING_WINDOWS_
#ifdef interface
#undef interface
#endif
#endif

//
//boolean QAbstractButton.getAutoExclusive();
KMETHOD QAbstractButton_getAutoExclusive(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		bool ret_v = qp->autoExclusive();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAbstractButton.getAutoRepeat();
KMETHOD QAbstractButton_getAutoRepeat(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		bool ret_v = qp->autoRepeat();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//int QAbstractButton.getAutoRepeatDelay();
KMETHOD QAbstractButton_getAutoRepeatDelay(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		int ret_v = qp->autoRepeatDelay();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAbstractButton.getAutoRepeatInterval();
KMETHOD QAbstractButton_getAutoRepeatInterval(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		int ret_v = qp->autoRepeatInterval();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QButtonGroup QAbstractButton.group();
KMETHOD QAbstractButton_group(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		QButtonGroup* ret_v = qp->group();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QButtonGroup*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QIcon QAbstractButton.getIcon();
KMETHOD QAbstractButton_getIcon(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		QIcon ret_v = qp->icon();
		QIcon *ret_v_ = new QIcon(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QSize QAbstractButton.getIconSize();
KMETHOD QAbstractButton_getIconSize(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->iconSize();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QAbstractButton.isCheckable();
KMETHOD QAbstractButton_isCheckable(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isCheckable();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAbstractButton.isChecked();
KMETHOD QAbstractButton_isChecked(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isChecked();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAbstractButton.isDown();
KMETHOD QAbstractButton_isDown(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isDown();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QAbstractButton.setAutoExclusive(boolean arg0);
KMETHOD QAbstractButton_setAutoExclusive(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setAutoExclusive(arg0);
	}
	RETURNvoid_();
}

//void QAbstractButton.setAutoRepeat(boolean arg0);
KMETHOD QAbstractButton_setAutoRepeat(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setAutoRepeat(arg0);
	}
	RETURNvoid_();
}

//void QAbstractButton.setAutoRepeatDelay(int arg0);
KMETHOD QAbstractButton_setAutoRepeatDelay(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		int arg0 = Int_to(int, sfp[1]);
		qp->setAutoRepeatDelay(arg0);
	}
	RETURNvoid_();
}

//void QAbstractButton.setAutoRepeatInterval(int arg0);
KMETHOD QAbstractButton_setAutoRepeatInterval(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		int arg0 = Int_to(int, sfp[1]);
		qp->setAutoRepeatInterval(arg0);
	}
	RETURNvoid_();
}

//void QAbstractButton.setCheckable(boolean arg0);
KMETHOD QAbstractButton_setCheckable(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setCheckable(arg0);
	}
	RETURNvoid_();
}

//void QAbstractButton.setDown(boolean arg0);
KMETHOD QAbstractButton_setDown(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setDown(arg0);
	}
	RETURNvoid_();
}

//void QAbstractButton.setIcon(QIcon icon);
KMETHOD QAbstractButton_setIcon(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		const QIcon  icon = *RawPtr_to(const QIcon *, sfp[1]);
		qp->setIcon(icon);
	}
	RETURNvoid_();
}

//void QAbstractButton.setShortcut(QKeySequence key);
KMETHOD QAbstractButton_setShortcut(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		const QKeySequence  key = *RawPtr_to(const QKeySequence *, sfp[1]);
		qp->setShortcut(key);
	}
	RETURNvoid_();
}

//void QAbstractButton.setText(String text);
KMETHOD QAbstractButton_setText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		const QString text = String_to(const QString, sfp[1]);
		qp->setText(text);
	}
	RETURNvoid_();
}

//QKeySequence QAbstractButton.getShortcut();
KMETHOD QAbstractButton_getShortcut(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		QKeySequence ret_v = qp->shortcut();
		QKeySequence *ret_v_ = new QKeySequence(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QAbstractButton.getText();
KMETHOD QAbstractButton_getText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		QString ret_v = qp->text();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QAbstractButton.animateClick(int msec);
KMETHOD QAbstractButton_animateClick(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		int msec = Int_to(int, sfp[1]);
		qp->animateClick(msec);
	}
	RETURNvoid_();
}

//void QAbstractButton.click();
KMETHOD QAbstractButton_click(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		qp->click();
	}
	RETURNvoid_();
}

//void QAbstractButton.setChecked(boolean arg0);
KMETHOD QAbstractButton_setChecked(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setChecked(arg0);
	}
	RETURNvoid_();
}

//void QAbstractButton.setIconSize(QSize size);
KMETHOD QAbstractButton_setIconSize(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		const QSize  size = *RawPtr_to(const QSize *, sfp[1]);
		qp->setIconSize(size);
	}
	RETURNvoid_();
}

//void QAbstractButton.toggle();
KMETHOD QAbstractButton_toggle(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractButton *  qp = RawPtr_to(QAbstractButton *, sfp[0]);
	if (qp) {
		qp->toggle();
	}
	RETURNvoid_();
}


DummyQAbstractButton::DummyQAbstractButton()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	clicked_func = NULL;
	pressed_func = NULL;
	released_func = NULL;
	toggled_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("clicked", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("pressed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("released", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("toggled", NULL));
}
DummyQAbstractButton::~DummyQAbstractButton()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractButton::setSelf(kRawPtr *ptr)
{
	DummyQAbstractButton::self = ptr;
	DummyQWidget::setSelf(ptr);
}

bool DummyQAbstractButton::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQWidget::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAbstractButton::clickedSlot(bool checked)
{
	if (clicked_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].bvalue = checked;
		knh_Func_invoke(lctx, clicked_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractButton::pressedSlot()
{
	if (pressed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, pressed_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAbstractButton::releasedSlot()
{
	if (released_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, released_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAbstractButton::toggledSlot(bool checked)
{
	if (toggled_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].bvalue = checked;
		knh_Func_invoke(lctx, toggled_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractButton::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractButton::event_map->bigin();
	if ((itr = DummyQAbstractButton::event_map->find(str)) == DummyQAbstractButton::event_map->end()) {
		bool ret = false;
		ret = DummyQWidget::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAbstractButton::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractButton::slot_map->bigin();
	if ((itr = DummyQAbstractButton::slot_map->find(str)) == DummyQAbstractButton::slot_map->end()) {
		bool ret = false;
		ret = DummyQWidget::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		clicked_func = (*slot_map)["clicked"];
		pressed_func = (*slot_map)["pressed"];
		released_func = (*slot_map)["released"];
		toggled_func = (*slot_map)["toggled"];
		return true;
	}
}

kObject** DummyQAbstractButton::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractButton::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 5;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, clicked_func);
	KNH_ADDNNREF(ctx, pressed_func);
	KNH_ADDNNREF(ctx, released_func);
	KNH_ADDNNREF(ctx, toggled_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQWidget::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAbstractButton::connection(QObject *o)
{
	QAbstractButton *p = dynamic_cast<QAbstractButton*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(clicked(bool)), this, SLOT(clickedSlot(bool)));
		connect(p, SIGNAL(pressed()), this, SLOT(pressedSlot()));
		connect(p, SIGNAL(released()), this, SLOT(releasedSlot()));
		connect(p, SIGNAL(toggled(bool)), this, SLOT(toggledSlot(bool)));
	}
	DummyQWidget::connection(o);
}

KQAbstractButton::KQAbstractButton(QWidget* parent) : QAbstractButton(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAbstractButton();
	dummy->connection((QObject*)this);
}

KQAbstractButton::~KQAbstractButton()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractButton_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractButton *qp = RawPtr_to(KQAbstractButton *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractButton]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractButton]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractButton_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractButton *qp = RawPtr_to(KQAbstractButton *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractButton]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractButton]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractButton_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractButton *qp = (KQAbstractButton *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractButton*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractButton_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractButton *qp = (KQAbstractButton *)p->rawptr;
		KQAbstractButton *qp = static_cast<KQAbstractButton*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractButton_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractButton::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAbstractButton::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAbstractButton::event(event);
		return false;
	}
//	QAbstractButton::event(event);
	return true;
}



DEFAPI(void) defQAbstractButton(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractButton";
	cdef->free = QAbstractButton_free;
	cdef->reftrace = QAbstractButton_reftrace;
	cdef->compareTo = QAbstractButton_compareTo;
}


//
//boolean QAbstractEventDispatcher.filterEvent(void message);
KMETHOD QAbstractEventDispatcher_filterEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractEventDispatcher *  qp = RawPtr_to(QAbstractEventDispatcher *, sfp[0]);
	if (qp) {
		void*  message = RawPtr_to(void*, sfp[1]);
		bool ret_v = qp->filterEvent(message);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual void QAbstractEventDispatcher.flush();
KMETHOD QAbstractEventDispatcher_flush(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractEventDispatcher *  qp = RawPtr_to(QAbstractEventDispatcher *, sfp[0]);
	if (qp) {
		qp->flush();
	}
	RETURNvoid_();
}

//@Virtual boolean QAbstractEventDispatcher.hasPendingEvents();
KMETHOD QAbstractEventDispatcher_hasPendingEvents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractEventDispatcher *  qp = RawPtr_to(QAbstractEventDispatcher *, sfp[0]);
	if (qp) {
		bool ret_v = qp->hasPendingEvents();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual void QAbstractEventDispatcher.interrupt();
KMETHOD QAbstractEventDispatcher_interrupt(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractEventDispatcher *  qp = RawPtr_to(QAbstractEventDispatcher *, sfp[0]);
	if (qp) {
		qp->interrupt();
	}
	RETURNvoid_();
}

//@Virtual boolean QAbstractEventDispatcher.processEvents(int flags);
KMETHOD QAbstractEventDispatcher_processEvents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractEventDispatcher *  qp = RawPtr_to(QAbstractEventDispatcher *, sfp[0]);
	if (qp) {
		QEventLoop::ProcessEventsFlags flags = Int_to(QEventLoop::ProcessEventsFlags, sfp[1]);
		bool ret_v = qp->processEvents(flags);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual void QAbstractEventDispatcher.registerSocketNotifier(QSocketNotifier notifier);
KMETHOD QAbstractEventDispatcher_registerSocketNotifier(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractEventDispatcher *  qp = RawPtr_to(QAbstractEventDispatcher *, sfp[0]);
	if (qp) {
		QSocketNotifier*  notifier = RawPtr_to(QSocketNotifier*, sfp[1]);
		qp->registerSocketNotifier(notifier);
	}
	RETURNvoid_();
}

//int QAbstractEventDispatcher.registerTimer(int interval, QObject object);
KMETHOD QAbstractEventDispatcher_registerTimer(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractEventDispatcher *  qp = RawPtr_to(QAbstractEventDispatcher *, sfp[0]);
	if (qp) {
		int interval = Int_to(int, sfp[1]);
		QObject*  object = RawPtr_to(QObject*, sfp[2]);
		int ret_v = qp->registerTimer(interval, object);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

/*
//@Virtual void QAbstractEventDispatcher.registerTimer(int timerId, int interval, QObject object);
KMETHOD QAbstractEventDispatcher_registerTimer(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractEventDispatcher *  qp = RawPtr_to(QAbstractEventDispatcher *, sfp[0]);
	if (qp) {
		int timerId = Int_to(int, sfp[1]);
		int interval = Int_to(int, sfp[2]);
		QObject*  object = RawPtr_to(QObject*, sfp[3]);
		qp->registerTimer(timerId, interval, object);
	}
	RETURNvoid_();
}
*/
//@Virtual void QAbstractEventDispatcher.unregisterSocketNotifier(QSocketNotifier notifier);
KMETHOD QAbstractEventDispatcher_unregisterSocketNotifier(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractEventDispatcher *  qp = RawPtr_to(QAbstractEventDispatcher *, sfp[0]);
	if (qp) {
		QSocketNotifier*  notifier = RawPtr_to(QSocketNotifier*, sfp[1]);
		qp->unregisterSocketNotifier(notifier);
	}
	RETURNvoid_();
}

//@Virtual boolean QAbstractEventDispatcher.unregisterTimer(int timerId);
KMETHOD QAbstractEventDispatcher_unregisterTimer(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractEventDispatcher *  qp = RawPtr_to(QAbstractEventDispatcher *, sfp[0]);
	if (qp) {
		int timerId = Int_to(int, sfp[1]);
		bool ret_v = qp->unregisterTimer(timerId);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual boolean QAbstractEventDispatcher.unregisterTimers(QObject object);
KMETHOD QAbstractEventDispatcher_unregisterTimers(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractEventDispatcher *  qp = RawPtr_to(QAbstractEventDispatcher *, sfp[0]);
	if (qp) {
		QObject*  object = RawPtr_to(QObject*, sfp[1]);
		bool ret_v = qp->unregisterTimers(object);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual void QAbstractEventDispatcher.wakeUp();
KMETHOD QAbstractEventDispatcher_wakeUp(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractEventDispatcher *  qp = RawPtr_to(QAbstractEventDispatcher *, sfp[0]);
	if (qp) {
		qp->wakeUp();
	}
	RETURNvoid_();
}

//QAbstractEventDispatcher QAbstractEventDispatcher.instance(QThread thread);
KMETHOD QAbstractEventDispatcher_instance(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QThread*  thread = RawPtr_to(QThread*, sfp[1]);
		QAbstractEventDispatcher* ret_v = QAbstractEventDispatcher::instance(thread);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractEventDispatcher*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}


DummyQAbstractEventDispatcher::DummyQAbstractEventDispatcher()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	about_to_block_func = NULL;
	awake_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("about-to-block", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("awake", NULL));
}
DummyQAbstractEventDispatcher::~DummyQAbstractEventDispatcher()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractEventDispatcher::setSelf(kRawPtr *ptr)
{
	DummyQAbstractEventDispatcher::self = ptr;
	DummyQObject::setSelf(ptr);
}

bool DummyQAbstractEventDispatcher::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQObject::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAbstractEventDispatcher::aboutToBlockSlot()
{
	if (about_to_block_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, about_to_block_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAbstractEventDispatcher::awakeSlot()
{
	if (awake_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, awake_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAbstractEventDispatcher::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractEventDispatcher::event_map->bigin();
	if ((itr = DummyQAbstractEventDispatcher::event_map->find(str)) == DummyQAbstractEventDispatcher::event_map->end()) {
		bool ret = false;
		ret = DummyQObject::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAbstractEventDispatcher::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractEventDispatcher::slot_map->bigin();
	if ((itr = DummyQAbstractEventDispatcher::slot_map->find(str)) == DummyQAbstractEventDispatcher::slot_map->end()) {
		bool ret = false;
		ret = DummyQObject::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		about_to_block_func = (*slot_map)["about-to-block"];
		awake_func = (*slot_map)["awake"];
		return true;
	}
}

kObject** DummyQAbstractEventDispatcher::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractEventDispatcher::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 3;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, about_to_block_func);
	KNH_ADDNNREF(ctx, awake_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQObject::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAbstractEventDispatcher::connection(QObject *o)
{
	QAbstractEventDispatcher *p = dynamic_cast<QAbstractEventDispatcher*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(aboutToBlock()), this, SLOT(aboutToBlockSlot()));
		connect(p, SIGNAL(awake()), this, SLOT(awakeSlot()));
	}
	DummyQObject::connection(o);
}

KQAbstractEventDispatcher::KQAbstractEventDispatcher(QObject* parent) : QAbstractEventDispatcher(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAbstractEventDispatcher();
	dummy->connection((QObject*)this);
}

KQAbstractEventDispatcher::~KQAbstractEventDispatcher()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractEventDispatcher_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractEventDispatcher *qp = RawPtr_to(KQAbstractEventDispatcher *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractEventDispatcher]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractEventDispatcher]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractEventDispatcher_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractEventDispatcher *qp = RawPtr_to(KQAbstractEventDispatcher *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractEventDispatcher]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractEventDispatcher]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractEventDispatcher_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractEventDispatcher *qp = (KQAbstractEventDispatcher *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractEventDispatcher*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractEventDispatcher_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractEventDispatcher *qp = (KQAbstractEventDispatcher *)p->rawptr;
		KQAbstractEventDispatcher *qp = static_cast<KQAbstractEventDispatcher*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractEventDispatcher_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractEventDispatcher::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAbstractEventDispatcher::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAbstractEventDispatcher::event(event);
		return false;
	}
//	QAbstractEventDispatcher::event(event);
	return true;
}



DEFAPI(void) defQAbstractEventDispatcher(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractEventDispatcher";
	cdef->free = QAbstractEventDispatcher_free;
	cdef->reftrace = QAbstractEventDispatcher_reftrace;
	cdef->compareTo = QAbstractEventDispatcher_compareTo;
}


//boolean QAbstractFileEngine.atEnd();
KMETHOD QAbstractFileEngine_atEnd(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		bool ret_v = qp->atEnd();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual boolean QAbstractFileEngine.caseSensitive();
KMETHOD QAbstractFileEngine_caseSensitive(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		bool ret_v = qp->caseSensitive();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual boolean QAbstractFileEngine.close();
KMETHOD QAbstractFileEngine_close(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		bool ret_v = qp->close();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual boolean QAbstractFileEngine.copy(String new_Name);
KMETHOD QAbstractFileEngine_copy(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		const QString new_Name = String_to(const QString, sfp[1]);
		bool ret_v = qp->copy(new_Name);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//String QAbstractFileEngine.errorString();
KMETHOD QAbstractFileEngine_errorString(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		QString ret_v = qp->errorString();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual QAbstractFileEngineFileFlags QAbstractFileEngine.fileFlags(QAbstractFileEngineFileFlags type);
KMETHOD QAbstractFileEngine_fileFlags(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		initFlag(type, QAbstractFileEngine::FileFlags, sfp[1]);
		QAbstractFileEngine::FileFlags ret_v = qp->fileFlags(type);
		QAbstractFileEngine::FileFlags *ret_v_ = new QAbstractFileEngine::FileFlags(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual String QAbstractFileEngine.getFileName(int file);
KMETHOD QAbstractFileEngine_getFileName(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		QAbstractFileEngine::FileName file = Int_to(QAbstractFileEngine::FileName, sfp[1]);
		QString ret_v = qp->fileName(file);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual QDateTime QAbstractFileEngine.fileTime(int time);
KMETHOD QAbstractFileEngine_fileTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		QAbstractFileEngine::FileTime time = Int_to(QAbstractFileEngine::FileTime, sfp[1]);
		QDateTime ret_v = qp->fileTime(time);
		QDateTime *ret_v_ = new QDateTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual boolean QAbstractFileEngine.flush();
KMETHOD QAbstractFileEngine_flush(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		bool ret_v = qp->flush();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual int QAbstractFileEngine.handle();
KMETHOD QAbstractFileEngine_handle(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		int ret_v = qp->handle();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual boolean QAbstractFileEngine.isRelativePath();
KMETHOD QAbstractFileEngine_isRelativePath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isRelativePath();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual boolean QAbstractFileEngine.isSequential();
KMETHOD QAbstractFileEngine_isSequential(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isSequential();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual boolean QAbstractFileEngine.link(String new_Name);
KMETHOD QAbstractFileEngine_link(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		const QString new_Name = String_to(const QString, sfp[1]);
		bool ret_v = qp->link(new_Name);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual boolean QAbstractFileEngine.mkdir(String dirName, boolean createParentDirectories);
KMETHOD QAbstractFileEngine_mkdir(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		const QString dirName = String_to(const QString, sfp[1]);
		bool createParentDirectories = Boolean_to(bool, sfp[2]);
		bool ret_v = qp->mkdir(dirName, createParentDirectories);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual boolean QAbstractFileEngine.open(int mode);
KMETHOD QAbstractFileEngine_open(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		QIODevice::OpenMode mode = Int_to(QIODevice::OpenMode, sfp[1]);
		bool ret_v = qp->open(mode);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual String QAbstractFileEngine.owner(int owner);
KMETHOD QAbstractFileEngine_owner(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		QAbstractFileEngine::FileOwner owner = Int_to(QAbstractFileEngine::FileOwner, sfp[1]);
		QString ret_v = qp->owner(owner);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual int QAbstractFileEngine.ownerId(int owner);
KMETHOD QAbstractFileEngine_ownerId(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		QAbstractFileEngine::FileOwner owner = Int_to(QAbstractFileEngine::FileOwner, sfp[1]);
		uint ret_v = qp->ownerId(owner);
		uint *ret_v_ = new uint(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual int QAbstractFileEngine.pos();
KMETHOD QAbstractFileEngine_pos(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		qint64 ret_v = qp->pos();
		qint64 *ret_v_ = new qint64(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual int QAbstractFileEngine.read(String data, int maxlen);
KMETHOD QAbstractFileEngine_read(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		char*  data = RawPtr_to(char*, sfp[1]);
		qint64 maxlen = Int_to(qint64, sfp[2]);
		qint64 ret_v = qp->read(data, maxlen);
		qint64 *ret_v_ = new qint64(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual int QAbstractFileEngine.readLine(String data, int maxlen);
KMETHOD QAbstractFileEngine_readLine(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		char*  data = RawPtr_to(char*, sfp[1]);
		qint64 maxlen = Int_to(qint64, sfp[2]);
		qint64 ret_v = qp->readLine(data, maxlen);
		qint64 *ret_v_ = new qint64(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual boolean QAbstractFileEngine.remove();
KMETHOD QAbstractFileEngine_remove(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		bool ret_v = qp->remove();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual boolean QAbstractFileEngine.rename(String new_Name);
KMETHOD QAbstractFileEngine_rename(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		const QString new_Name = String_to(const QString, sfp[1]);
		bool ret_v = qp->rename(new_Name);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual boolean QAbstractFileEngine.rmdir(String dirName, boolean recurseParentDirectories);
KMETHOD QAbstractFileEngine_rmdir(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		const QString dirName = String_to(const QString, sfp[1]);
		bool recurseParentDirectories = Boolean_to(bool, sfp[2]);
		bool ret_v = qp->rmdir(dirName, recurseParentDirectories);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual boolean QAbstractFileEngine.seek(int offset);
KMETHOD QAbstractFileEngine_seek(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		qint64 offset = Int_to(qint64, sfp[1]);
		bool ret_v = qp->seek(offset);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual void QAbstractFileEngine.setFileName(String file);
KMETHOD QAbstractFileEngine_setFileName(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		const QString file = String_to(const QString, sfp[1]);
		qp->setFileName(file);
	}
	RETURNvoid_();
}

//@Virtual boolean QAbstractFileEngine.setPermissions(int perms);
KMETHOD QAbstractFileEngine_setPermissions(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		uint  perms = *RawPtr_to(uint *, sfp[1]);
		bool ret_v = qp->setPermissions(perms);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual boolean QAbstractFileEngine.setSize(int size);
KMETHOD QAbstractFileEngine_setSize(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		qint64 size = Int_to(qint64, sfp[1]);
		bool ret_v = qp->setSize(size);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual int QAbstractFileEngine.getSize();
KMETHOD QAbstractFileEngine_getSize(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		qint64 ret_v = qp->size();
		qint64 *ret_v_ = new qint64(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual boolean QAbstractFileEngine.supportsExtension(int extension);
KMETHOD QAbstractFileEngine_supportsExtension(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		QAbstractFileEngine::Extension extension = Int_to(QAbstractFileEngine::Extension, sfp[1]);
		bool ret_v = qp->supportsExtension(extension);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAbstractFileEngine.unmap(String address);
KMETHOD QAbstractFileEngine_unmap(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		uchar*  address = RawPtr_to(uchar*, sfp[1]);
		bool ret_v = qp->unmap(address);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual int QAbstractFileEngine.write(String data, int len);
KMETHOD QAbstractFileEngine_write(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *  qp = RawPtr_to(QAbstractFileEngine *, sfp[0]);
	if (qp) {
		const char*  data = RawPtr_to(const char*, sfp[1]);
		qint64 len = Int_to(qint64, sfp[2]);
		qint64 ret_v = qp->write(data, len);
		qint64 *ret_v_ = new qint64(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QAbstractFileEngine QAbstractFileEngine.create(String fileName);
KMETHOD QAbstractFileEngine_create(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString fileName = String_to(const QString, sfp[1]);
		QAbstractFileEngine* ret_v = QAbstractFileEngine::create(fileName);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractFileEngine*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//Array<String> QAbstractFileEngine.parents();
KMETHOD QAbstractFileEngine_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine *qp = RawPtr_to(QAbstractFileEngine*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQAbstractFileEngine::DummyQAbstractFileEngine()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQAbstractFileEngine::~DummyQAbstractFileEngine()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractFileEngine::setSelf(kRawPtr *ptr)
{
	DummyQAbstractFileEngine::self = ptr;
}

bool DummyQAbstractFileEngine::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQAbstractFileEngine::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractFileEngine::event_map->bigin();
	if ((itr = DummyQAbstractFileEngine::event_map->find(str)) == DummyQAbstractFileEngine::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAbstractFileEngine::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractFileEngine::slot_map->bigin();
	if ((itr = DummyQAbstractFileEngine::slot_map->find(str)) == DummyQAbstractFileEngine::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQAbstractFileEngine::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractFileEngine::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQAbstractFileEngine::connection(QObject *o)
{
	QAbstractFileEngine *p = dynamic_cast<QAbstractFileEngine*>(o);
	if (p != NULL) {
	}
}

KQAbstractFileEngine::~KQAbstractFileEngine()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractFileEngine_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractFileEngine *qp = RawPtr_to(KQAbstractFileEngine *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractFileEngine]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractFileEngine]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractFileEngine_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractFileEngine *qp = RawPtr_to(KQAbstractFileEngine *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractFileEngine]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractFileEngine]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractFileEngine_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractFileEngine *qp = (KQAbstractFileEngine *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractFileEngine*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractFileEngine_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractFileEngine *qp = (KQAbstractFileEngine *)p->rawptr;
		KQAbstractFileEngine *qp = static_cast<KQAbstractFileEngine*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractFileEngine_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractFileEngine::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

static knh_IntData_t QAbstractFileEngineConstInt[] = {
	{"AtEndExtension", QAbstractFileEngine::AtEndExtension},
	{"FastReadLineExtension", QAbstractFileEngine::FastReadLineExtension},
	{"MapExtension", QAbstractFileEngine::MapExtension},
	{"UnMapExtension", QAbstractFileEngine::UnMapExtension},
	{"ReadOwnerPerm", QAbstractFileEngine::ReadOwnerPerm},
	{"WriteOwnerPerm", QAbstractFileEngine::WriteOwnerPerm},
	{"ExeOwnerPerm", QAbstractFileEngine::ExeOwnerPerm},
	{"ReadUserPerm", QAbstractFileEngine::ReadUserPerm},
	{"WriteUserPerm", QAbstractFileEngine::WriteUserPerm},
	{"ExeUserPerm", QAbstractFileEngine::ExeUserPerm},
	{"ReadGroupPerm", QAbstractFileEngine::ReadGroupPerm},
	{"WriteGroupPerm", QAbstractFileEngine::WriteGroupPerm},
	{"ExeGroupPerm", QAbstractFileEngine::ExeGroupPerm},
	{"ReadOtherPerm", QAbstractFileEngine::ReadOtherPerm},
	{"WriteOtherPerm", QAbstractFileEngine::WriteOtherPerm},
	{"ExeOtherPerm", QAbstractFileEngine::ExeOtherPerm},
	{"LinkType", QAbstractFileEngine::LinkType},
	{"FileType", QAbstractFileEngine::FileType},
	{"BundleType", QAbstractFileEngine::BundleType},
	{"DirectoryType", QAbstractFileEngine::DirectoryType},
	{"HiddenFlag", QAbstractFileEngine::HiddenFlag},
	{"ExistsFlag", QAbstractFileEngine::ExistsFlag},
	{"RootFlag", QAbstractFileEngine::RootFlag},
	{"LocalDiskFlag", QAbstractFileEngine::LocalDiskFlag},
	{"Refresh", QAbstractFileEngine::Refresh},
	{"DefaultName", QAbstractFileEngine::DefaultName},
	{"BaseName", QAbstractFileEngine::BaseName},
	{"PathName", QAbstractFileEngine::PathName},
	{"AbsoluteName", QAbstractFileEngine::AbsoluteName},
	{"AbsolutePathName", QAbstractFileEngine::AbsolutePathName},
	{"LinkName", QAbstractFileEngine::LinkName},
	{"CanonicalName", QAbstractFileEngine::CanonicalName},
	{"CanonicalPathName", QAbstractFileEngine::CanonicalPathName},
	{"BundleName", QAbstractFileEngine::BundleName},
	{"OwnerUser", QAbstractFileEngine::OwnerUser},
	{"OwnerGroup", QAbstractFileEngine::OwnerGroup},
	{"CreationTime", QAbstractFileEngine::CreationTime},
	{"ModificationTime", QAbstractFileEngine::ModificationTime},
	{"AccessTime", QAbstractFileEngine::AccessTime},
	{NULL, 0}
};

DEFAPI(void) constQAbstractFileEngine(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QAbstractFileEngineConstInt);
}


DEFAPI(void) defQAbstractFileEngine(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractFileEngine";
	cdef->free = QAbstractFileEngine_free;
	cdef->reftrace = QAbstractFileEngine_reftrace;
	cdef->compareTo = QAbstractFileEngine_compareTo;
}

//## QAbstractFileEngineFileFlags QAbstractFileEngineFileFlags.new(int value);
KMETHOD QAbstractFileEngineFileFlags_new(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractFileEngine::FileFlag i = Int_to(QAbstractFileEngine::FileFlag, sfp[1]);
	QAbstractFileEngine::FileFlags *ret_v = new QAbstractFileEngine::FileFlags(i);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	RETURN_(rptr);
}

//## QAbstractFileEngineFileFlags QAbstractFileEngineFileFlags.and(int mask);
KMETHOD QAbstractFileEngineFileFlags_and(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractFileEngine::FileFlags *qp = RawPtr_to(QAbstractFileEngine::FileFlags*, sfp[0]);
	if (qp != NULL) {
		int i = Int_to(int, sfp[1]);
		QAbstractFileEngine::FileFlags ret = ((*qp) & i);
		QAbstractFileEngine::FileFlags *ret_ = new QAbstractFileEngine::FileFlags(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractFileEngineFileFlags QAbstractFileEngineFileFlags.iand(QAbstractFileEngine::QAbstractFileEngineFileFlags other);
KMETHOD QAbstractFileEngineFileFlags_iand(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractFileEngine::FileFlags *qp = RawPtr_to(QAbstractFileEngine::FileFlags*, sfp[0]);
	if (qp != NULL) {
		QAbstractFileEngine::FileFlags *other = RawPtr_to(QAbstractFileEngine::FileFlags *, sfp[1]);
		*qp = ((*qp) & (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractFileEngineFileFlags QAbstractFileEngineFileFlags.or(QAbstractFileEngineFileFlags f);
KMETHOD QAbstractFileEngineFileFlags_or(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine::FileFlags *qp = RawPtr_to(QAbstractFileEngine::FileFlags*, sfp[0]);
	if (qp != NULL) {
		QAbstractFileEngine::FileFlags *f = RawPtr_to(QAbstractFileEngine::FileFlags*, sfp[1]);
		QAbstractFileEngine::FileFlags ret = ((*qp) | (*f));
		QAbstractFileEngine::FileFlags *ret_ = new QAbstractFileEngine::FileFlags(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractFileEngineFileFlags QAbstractFileEngineFileFlags.ior(QAbstractFileEngine::QAbstractFileEngineFileFlags other);
KMETHOD QAbstractFileEngineFileFlags_ior(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractFileEngine::FileFlags *qp = RawPtr_to(QAbstractFileEngine::FileFlags*, sfp[0]);
	if (qp != NULL) {
		QAbstractFileEngine::FileFlags *other = RawPtr_to(QAbstractFileEngine::FileFlags *, sfp[1]);
		*qp = ((*qp) | (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractFileEngineFileFlags QAbstractFileEngineFileFlags.xor(QAbstractFileEngineFileFlags f);
KMETHOD QAbstractFileEngineFileFlags_xor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngine::FileFlags *qp = RawPtr_to(QAbstractFileEngine::FileFlags*, sfp[0]);
	if (qp != NULL) {
		QAbstractFileEngine::FileFlags *f = RawPtr_to(QAbstractFileEngine::FileFlags*, sfp[1]);
		QAbstractFileEngine::FileFlags ret = ((*qp) ^ (*f));
		QAbstractFileEngine::FileFlags *ret_ = new QAbstractFileEngine::FileFlags(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractFileEngineFileFlags QAbstractFileEngineFileFlags.ixor(QAbstractFileEngine::QAbstractFileEngineFileFlags other);
KMETHOD QAbstractFileEngineFileFlags_ixor(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractFileEngine::FileFlags *qp = RawPtr_to(QAbstractFileEngine::FileFlags*, sfp[0]);
	if (qp != NULL) {
		QAbstractFileEngine::FileFlags *other = RawPtr_to(QAbstractFileEngine::FileFlags *, sfp[1]);
		*qp = ((*qp) ^ (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## boolean QAbstractFileEngineFileFlags.testFlag(int flag);
KMETHOD QAbstractFileEngineFileFlags_testFlag(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractFileEngine::FileFlags *qp = RawPtr_to(QAbstractFileEngine::FileFlags *, sfp[0]);
	if (qp != NULL) {
		QAbstractFileEngine::FileFlag flag = Int_to(QAbstractFileEngine::FileFlag, sfp[1]);
		bool ret = qp->testFlag(flag);
		RETURNb_(ret);
	} else {
		RETURNb_(false);
	}
}

//## int QAbstractFileEngineFileFlags.value();
KMETHOD QAbstractFileEngineFileFlags_value(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractFileEngine::FileFlags *qp = RawPtr_to(QAbstractFileEngine::FileFlags *, sfp[0]);
	if (qp != NULL) {
		int ret = int(*qp);
		RETURNi_(ret);
	} else {
		RETURNi_(0);
	}
}

static void QAbstractFileEngineFileFlags_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (p->rawptr != NULL) {
		QAbstractFileEngine::FileFlags *qp = (QAbstractFileEngine::FileFlags *)p->rawptr;
		(void)qp;
		delete qp;
		p->rawptr = NULL;
	}
}

static void QAbstractFileEngineFileFlags_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
	if (p->rawptr != NULL) {
		QAbstractFileEngine::FileFlags *qp = (QAbstractFileEngine::FileFlags *)p->rawptr;
		(void)qp;
	}
}

static int QAbstractFileEngineFileFlags_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	if (p1->rawptr == NULL || p2->rawptr == NULL) {
		return 1;
	} else {
//		int v1 = int(*(QAbstractFileEngine::FileFlags*)p1->rawptr);
//		int v2 = int(*(QAbstractFileEngine::FileFlags*)p2->rawptr);
//		return (v1 == v2 ? 0 : 1);
		QAbstractFileEngine::FileFlags v1 = *(QAbstractFileEngine::FileFlags*)p1->rawptr;
		QAbstractFileEngine::FileFlags v2 = *(QAbstractFileEngine::FileFlags*)p2->rawptr;
//		return (v1 == v2 ? 0 : 1);
		return (v1 == v2 ? 0 : 1);

	}
}

DEFAPI(void) defQAbstractFileEngineFileFlags(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractFileEngineFileFlags";
	cdef->free = QAbstractFileEngineFileFlags_free;
	cdef->reftrace = QAbstractFileEngineFileFlags_reftrace;
	cdef->compareTo = QAbstractFileEngineFileFlags_compareTo;
}

//
//@Virtual QAbstractFileEngine QAbstractFileEngineHandler.create(String fileName);
KMETHOD QAbstractFileEngineHandler_create(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngineHandler *  qp = RawPtr_to(QAbstractFileEngineHandler *, sfp[0]);
	if (qp) {
		const QString fileName = String_to(const QString, sfp[1]);
		QAbstractFileEngine* ret_v = qp->create(fileName);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractFileEngine*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//Array<String> QAbstractFileEngineHandler.parents();
KMETHOD QAbstractFileEngineHandler_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractFileEngineHandler *qp = RawPtr_to(QAbstractFileEngineHandler*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQAbstractFileEngineHandler::DummyQAbstractFileEngineHandler()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQAbstractFileEngineHandler::~DummyQAbstractFileEngineHandler()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractFileEngineHandler::setSelf(kRawPtr *ptr)
{
	DummyQAbstractFileEngineHandler::self = ptr;
}

bool DummyQAbstractFileEngineHandler::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQAbstractFileEngineHandler::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractFileEngineHandler::event_map->bigin();
	if ((itr = DummyQAbstractFileEngineHandler::event_map->find(str)) == DummyQAbstractFileEngineHandler::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAbstractFileEngineHandler::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractFileEngineHandler::slot_map->bigin();
	if ((itr = DummyQAbstractFileEngineHandler::slot_map->find(str)) == DummyQAbstractFileEngineHandler::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQAbstractFileEngineHandler::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractFileEngineHandler::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQAbstractFileEngineHandler::connection(QObject *o)
{
	QAbstractFileEngineHandler *p = dynamic_cast<QAbstractFileEngineHandler*>(o);
	if (p != NULL) {
	}
}

KQAbstractFileEngineHandler::KQAbstractFileEngineHandler() : QAbstractFileEngineHandler()
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAbstractFileEngineHandler();
}

KQAbstractFileEngineHandler::~KQAbstractFileEngineHandler()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractFileEngineHandler_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractFileEngineHandler *qp = RawPtr_to(KQAbstractFileEngineHandler *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractFileEngineHandler]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractFileEngineHandler]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractFileEngineHandler_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractFileEngineHandler *qp = RawPtr_to(KQAbstractFileEngineHandler *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractFileEngineHandler]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractFileEngineHandler]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractFileEngineHandler_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractFileEngineHandler *qp = (KQAbstractFileEngineHandler *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractFileEngineHandler*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractFileEngineHandler_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractFileEngineHandler *qp = (KQAbstractFileEngineHandler *)p->rawptr;
		KQAbstractFileEngineHandler *qp = static_cast<KQAbstractFileEngineHandler*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractFileEngineHandler_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractFileEngineHandler::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQAbstractFileEngineHandler(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractFileEngineHandler";
	cdef->free = QAbstractFileEngineHandler_free;
	cdef->reftrace = QAbstractFileEngineHandler_reftrace;
	cdef->compareTo = QAbstractFileEngineHandler_compareTo;
}


//@Virtual @Override boolean QAbstractGraphicsShapeItem.isObscuredBy(QGraphicsItem item);
KMETHOD QAbstractGraphicsShapeItem_isObscuredBy(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractGraphicsShapeItem *  qp = RawPtr_to(QAbstractGraphicsShapeItem *, sfp[0]);
	if (qp) {
		const QGraphicsItem*  item = RawPtr_to(const QGraphicsItem*, sfp[1]);
		bool ret_v = qp->isObscuredBy(item);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override QPainterPath QAbstractGraphicsShapeItem.opaqueArea();
KMETHOD QAbstractGraphicsShapeItem_opaqueArea(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractGraphicsShapeItem *  qp = RawPtr_to(QAbstractGraphicsShapeItem *, sfp[0]);
	if (qp) {
		QPainterPath ret_v = qp->opaqueArea();
		QPainterPath *ret_v_ = new QPainterPath(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//
//QBrush QAbstractGraphicsShapeItem.getBrush();
KMETHOD QAbstractGraphicsShapeItem_getBrush(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractGraphicsShapeItem *  qp = RawPtr_to(QAbstractGraphicsShapeItem *, sfp[0]);
	if (qp) {
		QBrush ret_v = qp->brush();
		QBrush *ret_v_ = new QBrush(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QPen QAbstractGraphicsShapeItem.getPen();
KMETHOD QAbstractGraphicsShapeItem_getPen(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractGraphicsShapeItem *  qp = RawPtr_to(QAbstractGraphicsShapeItem *, sfp[0]);
	if (qp) {
		QPen ret_v = qp->pen();
		QPen *ret_v_ = new QPen(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QAbstractGraphicsShapeItem.setBrush(QBrush brush);
KMETHOD QAbstractGraphicsShapeItem_setBrush(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractGraphicsShapeItem *  qp = RawPtr_to(QAbstractGraphicsShapeItem *, sfp[0]);
	if (qp) {
		const QBrush  brush = *RawPtr_to(const QBrush *, sfp[1]);
		qp->setBrush(brush);
	}
	RETURNvoid_();
}

//void QAbstractGraphicsShapeItem.setPen(QPen pen);
KMETHOD QAbstractGraphicsShapeItem_setPen(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractGraphicsShapeItem *  qp = RawPtr_to(QAbstractGraphicsShapeItem *, sfp[0]);
	if (qp) {
		const QPen  pen = *RawPtr_to(const QPen *, sfp[1]);
		qp->setPen(pen);
	}
	RETURNvoid_();
}

// //@Virtual void QAbstractGraphicsShapeItem.paint(QPainter painter, QStyleOptionGraphicsItem option, QWidget widget);
// KMETHOD QAbstractGraphicsShapeItem_paint(CTX ctx, ksfp_t *sfp _RIX)
// {
// 	(void)ctx;
// 	KQAbstractGraphicsShapeItem *  qp = RawPtr_to(KQAbstractGraphicsShapeItem *, sfp[0]);
// 	if (qp) {
// 		if (qp->dummy->paint_func != NULL) {
// 			knh_Func_invoke(ctx, qp->dummy->paint_func, sfp, 4);
// 		}
// 	}
// 	RETURNvoid_();
// }

//@Virtual void QAbstractGraphicsShapeItem.paint(QPainter painter, QStyleOptionGraphicsItem option, QWidget widget);
KMETHOD QAbstractGraphicsShapeItem_paint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractGraphicsShapeItem *  qp = RawPtr_to(KQAbstractGraphicsShapeItem *, sfp[0]);
	if (qp) {
		QPainter*  painter = RawPtr_to(QPainter*, sfp[1]);
		const QStyleOptionGraphicsItem*  option = RawPtr_to(const QStyleOptionGraphicsItem*, sfp[2]);
		QWidget*  widget = RawPtr_to(QWidget*, sfp[3]);
		qp->paint(painter, option, widget);
	}
	RETURNvoid_();
}

void KQAbstractGraphicsShapeItem::paint(QPainter *painter, const QStyleOptionGraphicsItem * option, QWidget * widget)
{
	if (dummy->paint_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QPainter, painter);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		kRawPtr *p2 = new_QRawPtr(lctx, QStyleOptionGraphicsItem, option);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+3].o, UPCAST(p2));
		kRawPtr *p3 = new_QRawPtr(lctx, QWidget, widget);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+4].o, UPCAST(p3));
		knh_Func_invoke(lctx, dummy->paint_func, lsfp, 4);
	} else {
//		QAbstractGraphicsShapeItem::paint(painter, option, widget);
	}
}

DummyQAbstractGraphicsShapeItem::DummyQAbstractGraphicsShapeItem()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	paint_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	event_map->insert(map<string, kFunc *>::value_type("paint", NULL));
}
DummyQAbstractGraphicsShapeItem::~DummyQAbstractGraphicsShapeItem()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractGraphicsShapeItem::setSelf(kRawPtr *ptr)
{
	DummyQAbstractGraphicsShapeItem::self = ptr;
	DummyQGraphicsItem::setSelf(ptr);
}

bool DummyQAbstractGraphicsShapeItem::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQGraphicsItem::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAbstractGraphicsShapeItem::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractGraphicsShapeItem::event_map->bigin();
	if ((itr = DummyQAbstractGraphicsShapeItem::event_map->find(str)) == DummyQAbstractGraphicsShapeItem::event_map->end()) {
		bool ret = false;
		ret = DummyQGraphicsItem::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		paint_func = (*event_map)["paint"];
		return true;
	}
}

bool DummyQAbstractGraphicsShapeItem::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractGraphicsShapeItem::slot_map->bigin();
	if ((itr = DummyQAbstractGraphicsShapeItem::slot_map->find(str)) == DummyQAbstractGraphicsShapeItem::slot_map->end()) {
		bool ret = false;
		ret = DummyQGraphicsItem::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQAbstractGraphicsShapeItem::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractGraphicsShapeItem::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQGraphicsItem::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAbstractGraphicsShapeItem::connection(QObject *o)
{
	QAbstractGraphicsShapeItem *p = dynamic_cast<QAbstractGraphicsShapeItem*>(o);
	if (p != NULL) {
	}
	DummyQGraphicsItem::connection(o);
}

KQAbstractGraphicsShapeItem::KQAbstractGraphicsShapeItem(QGraphicsItem* parent) : QAbstractGraphicsShapeItem(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAbstractGraphicsShapeItem();
}

KQAbstractGraphicsShapeItem::~KQAbstractGraphicsShapeItem()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractGraphicsShapeItem_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractGraphicsShapeItem *qp = RawPtr_to(KQAbstractGraphicsShapeItem *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractGraphicsShapeItem]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractGraphicsShapeItem]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractGraphicsShapeItem_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractGraphicsShapeItem *qp = RawPtr_to(KQAbstractGraphicsShapeItem *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractGraphicsShapeItem]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractGraphicsShapeItem]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractGraphicsShapeItem_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractGraphicsShapeItem *qp = (KQAbstractGraphicsShapeItem *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractGraphicsShapeItem*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractGraphicsShapeItem_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractGraphicsShapeItem *qp = (KQAbstractGraphicsShapeItem *)p->rawptr;
		KQAbstractGraphicsShapeItem *qp = static_cast<KQAbstractGraphicsShapeItem*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractGraphicsShapeItem_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractGraphicsShapeItem::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAbstractGraphicsShapeItem::sceneEvent(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAbstractGraphicsShapeItem::sceneEvent(event);
		return false;
	}
//	QAbstractGraphicsShapeItem::sceneEvent(event);
	return true;
}



DEFAPI(void) defQAbstractGraphicsShapeItem(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractGraphicsShapeItem";
	cdef->free = QAbstractGraphicsShapeItem_free;
	cdef->reftrace = QAbstractGraphicsShapeItem_reftrace;
	cdef->compareTo = QAbstractGraphicsShapeItem_compareTo;
}


//
//@Virtual QWidget QAbstractItemDelegate.createEditor(QWidget parent, QStyleOptionViewItem option, QModelIndex index);
KMETHOD QAbstractItemDelegate_createEditor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemDelegate *  qp = RawPtr_to(QAbstractItemDelegate *, sfp[0]);
	if (qp) {
		QWidget*  parent = RawPtr_to(QWidget*, sfp[1]);
		const QStyleOptionViewItem  option = *RawPtr_to(const QStyleOptionViewItem *, sfp[2]);
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[3]);
		QWidget* ret_v = qp->createEditor(parent, option, index);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QWidget*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual boolean QAbstractItemDelegate.editorEvent(QEvent event, QAbstractItemModel model, QStyleOptionViewItem option, QModelIndex index);
KMETHOD QAbstractItemDelegate_editorEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemDelegate *  qp = RawPtr_to(QAbstractItemDelegate *, sfp[0]);
	if (qp) {
		QEvent*  event = RawPtr_to(QEvent*, sfp[1]);
		QAbstractItemModel*  model = RawPtr_to(QAbstractItemModel*, sfp[2]);
		const QStyleOptionViewItem  option = *RawPtr_to(const QStyleOptionViewItem *, sfp[3]);
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[4]);
		bool ret_v = qp->editorEvent(event, model, option, index);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual void QAbstractItemDelegate.paint(QPainter painter, QStyleOptionViewItem option, QModelIndex index);
KMETHOD QAbstractItemDelegate_paint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemDelegate *  qp = RawPtr_to(QAbstractItemDelegate *, sfp[0]);
	if (qp) {
		QPainter*  painter = RawPtr_to(QPainter*, sfp[1]);
		const QStyleOptionViewItem  option = *RawPtr_to(const QStyleOptionViewItem *, sfp[2]);
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[3]);
		qp->paint(painter, option, index);
	}
	RETURNvoid_();
}

//@Virtual void QAbstractItemDelegate.setEditorData(QWidget editor, QModelIndex index);
KMETHOD QAbstractItemDelegate_setEditorData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemDelegate *  qp = RawPtr_to(QAbstractItemDelegate *, sfp[0]);
	if (qp) {
		QWidget*  editor = RawPtr_to(QWidget*, sfp[1]);
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[2]);
		qp->setEditorData(editor, index);
	}
	RETURNvoid_();
}

//@Virtual void QAbstractItemDelegate.setModelData(QWidget editor, QAbstractItemModel model, QModelIndex index);
KMETHOD QAbstractItemDelegate_setModelData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemDelegate *  qp = RawPtr_to(QAbstractItemDelegate *, sfp[0]);
	if (qp) {
		QWidget*  editor = RawPtr_to(QWidget*, sfp[1]);
		QAbstractItemModel*  model = RawPtr_to(QAbstractItemModel*, sfp[2]);
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[3]);
		qp->setModelData(editor, model, index);
	}
	RETURNvoid_();
}

//@Virtual QSize QAbstractItemDelegate.sizeHint(QStyleOptionViewItem option, QModelIndex index);
KMETHOD QAbstractItemDelegate_sizeHint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemDelegate *  qp = RawPtr_to(QAbstractItemDelegate *, sfp[0]);
	if (qp) {
		const QStyleOptionViewItem  option = *RawPtr_to(const QStyleOptionViewItem *, sfp[1]);
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[2]);
		QSize ret_v = qp->sizeHint(option, index);
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual void QAbstractItemDelegate.updateEditorGeometry(QWidget editor, QStyleOptionViewItem option, QModelIndex index);
KMETHOD QAbstractItemDelegate_updateEditorGeometry(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemDelegate *  qp = RawPtr_to(QAbstractItemDelegate *, sfp[0]);
	if (qp) {
		QWidget*  editor = RawPtr_to(QWidget*, sfp[1]);
		const QStyleOptionViewItem  option = *RawPtr_to(const QStyleOptionViewItem *, sfp[2]);
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[3]);
		qp->updateEditorGeometry(editor, option, index);
	}
	RETURNvoid_();
}

//boolean QAbstractItemDelegate.helpEvent(QHelpEvent event, QAbstractItemView view, QStyleOptionViewItem option, QModelIndex index);
KMETHOD QAbstractItemDelegate_helpEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemDelegate *  qp = RawPtr_to(QAbstractItemDelegate *, sfp[0]);
	if (qp) {
		QHelpEvent*  event = RawPtr_to(QHelpEvent*, sfp[1]);
		QAbstractItemView*  view = RawPtr_to(QAbstractItemView*, sfp[2]);
		const QStyleOptionViewItem  option = *RawPtr_to(const QStyleOptionViewItem *, sfp[3]);
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[4]);
		bool ret_v = qp->helpEvent(event, view, option, index);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}


DummyQAbstractItemDelegate::DummyQAbstractItemDelegate()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	close_editor_func = NULL;
	commit_data_func = NULL;
	size_hint_changed_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("close-editor", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("commit-data", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("size-hint-changed", NULL));
}
DummyQAbstractItemDelegate::~DummyQAbstractItemDelegate()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractItemDelegate::setSelf(kRawPtr *ptr)
{
	DummyQAbstractItemDelegate::self = ptr;
	DummyQObject::setSelf(ptr);
}

bool DummyQAbstractItemDelegate::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQObject::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAbstractItemDelegate::closeEditorSlot(QWidget* editor, QAbstractItemDelegate::EndEditHint hint)
{
	if (close_editor_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QWidget, editor);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		lsfp[K_CALLDELTA+3].ivalue = hint;
		knh_Func_invoke(lctx, close_editor_func, lsfp, 3);
		return true;
	}
	return false;
}

bool DummyQAbstractItemDelegate::commitDataSlot(QWidget* editor)
{
	if (commit_data_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QWidget, editor);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, commit_data_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractItemDelegate::sizeHintChangedSlot(const QModelIndex index)
{
	if (size_hint_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, index);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, size_hint_changed_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractItemDelegate::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractItemDelegate::event_map->bigin();
	if ((itr = DummyQAbstractItemDelegate::event_map->find(str)) == DummyQAbstractItemDelegate::event_map->end()) {
		bool ret = false;
		ret = DummyQObject::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAbstractItemDelegate::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractItemDelegate::slot_map->bigin();
	if ((itr = DummyQAbstractItemDelegate::slot_map->find(str)) == DummyQAbstractItemDelegate::slot_map->end()) {
		bool ret = false;
		ret = DummyQObject::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		close_editor_func = (*slot_map)["close-editor"];
		commit_data_func = (*slot_map)["commit-data"];
		size_hint_changed_func = (*slot_map)["size-hint-changed"];
		return true;
	}
}

kObject** DummyQAbstractItemDelegate::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractItemDelegate::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 4;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, close_editor_func);
	KNH_ADDNNREF(ctx, commit_data_func);
	KNH_ADDNNREF(ctx, size_hint_changed_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQObject::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAbstractItemDelegate::connection(QObject *o)
{
	QAbstractItemDelegate *p = dynamic_cast<QAbstractItemDelegate*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(closeEditor(QWidget*, QAbstractItemDelegate::EndEditHint)), this, SLOT(closeEditorSlot(QWidget*, QAbstractItemDelegate::EndEditHint)));
		connect(p, SIGNAL(commitData(QWidget*)), this, SLOT(commitDataSlot(QWidget*)));
		connect(p, SIGNAL(sizeHintChanged(const QModelIndex)), this, SLOT(sizeHintChangedSlot(const QModelIndex)));
	}
	DummyQObject::connection(o);
}

KQAbstractItemDelegate::KQAbstractItemDelegate(QObject* parent) : QAbstractItemDelegate(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAbstractItemDelegate();
	dummy->connection((QObject*)this);
}

KQAbstractItemDelegate::~KQAbstractItemDelegate()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractItemDelegate_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractItemDelegate *qp = RawPtr_to(KQAbstractItemDelegate *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractItemDelegate]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractItemDelegate]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractItemDelegate_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractItemDelegate *qp = RawPtr_to(KQAbstractItemDelegate *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractItemDelegate]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractItemDelegate]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractItemDelegate_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractItemDelegate *qp = (KQAbstractItemDelegate *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractItemDelegate*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractItemDelegate_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractItemDelegate *qp = (KQAbstractItemDelegate *)p->rawptr;
		KQAbstractItemDelegate *qp = static_cast<KQAbstractItemDelegate*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractItemDelegate_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractItemDelegate::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAbstractItemDelegate::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAbstractItemDelegate::event(event);
		return false;
	}
//	QAbstractItemDelegate::event(event);
	return true;
}

static knh_IntData_t QAbstractItemDelegateConstInt[] = {
	{"NoHint", QAbstractItemDelegate::NoHint},
	{"EditNextItem", QAbstractItemDelegate::EditNextItem},
	{"EditPreviousItem", QAbstractItemDelegate::EditPreviousItem},
	{"SubmitModelCache", QAbstractItemDelegate::SubmitModelCache},
	{"RevertModelCache", QAbstractItemDelegate::RevertModelCache},
	{NULL, 0}
};

DEFAPI(void) constQAbstractItemDelegate(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QAbstractItemDelegateConstInt);
}


DEFAPI(void) defQAbstractItemDelegate(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractItemDelegate";
	cdef->free = QAbstractItemDelegate_free;
	cdef->reftrace = QAbstractItemDelegate_reftrace;
	cdef->compareTo = QAbstractItemDelegate_compareTo;
}


//
//@Virtual QModelIndex QAbstractItemModel.buddy(QModelIndex index);
KMETHOD QAbstractItemModel_buddy(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		QModelIndex ret_v = qp->buddy(index);
		QModelIndex *ret_v_ = new QModelIndex(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual boolean QAbstractItemModel.canFetchMore(QModelIndex parent);
KMETHOD QAbstractItemModel_canFetchMore(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		const QModelIndex  parent = *RawPtr_to(const QModelIndex *, sfp[1]);
		bool ret_v = qp->canFetchMore(parent);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual QVariant QAbstractItemModel.getData(QModelIndex index, int role);
KMETHOD QAbstractItemModel_getData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		int role = Int_to(int, sfp[2]);
		QVariant ret_v = qp->data(index, role);
		QVariant *ret_v_ = new QVariant(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual boolean QAbstractItemModel.dropMimeData(QMimeData data, int action, int row, int column, QModelIndex parent);
KMETHOD QAbstractItemModel_dropMimeData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		const QMimeData*  data = RawPtr_to(const QMimeData*, sfp[1]);
		Qt::DropAction action = Int_to(Qt::DropAction, sfp[2]);
		int row = Int_to(int, sfp[3]);
		int column = Int_to(int, sfp[4]);
		const QModelIndex  parent = *RawPtr_to(const QModelIndex *, sfp[5]);
		bool ret_v = qp->dropMimeData(data, action, row, column, parent);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual void QAbstractItemModel.fetchMore(QModelIndex parent);
KMETHOD QAbstractItemModel_fetchMore(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		const QModelIndex  parent = *RawPtr_to(const QModelIndex *, sfp[1]);
		qp->fetchMore(parent);
	}
	RETURNvoid_();
}

//@Virtual QtItemFlags QAbstractItemModel.flags(QModelIndex index);
KMETHOD QAbstractItemModel_flags(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		Qt::ItemFlags ret_v = qp->flags(index);
		Qt::ItemFlags *ret_v_ = new Qt::ItemFlags(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual boolean QAbstractItemModel.hasChildren(QModelIndex parent);
KMETHOD QAbstractItemModel_hasChildren(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		const QModelIndex  parent = *RawPtr_to(const QModelIndex *, sfp[1]);
		bool ret_v = qp->hasChildren(parent);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAbstractItemModel.hasIndex(int row, int column, QModelIndex parent);
KMETHOD QAbstractItemModel_hasIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		int row = Int_to(int, sfp[1]);
		int column = Int_to(int, sfp[2]);
		const QModelIndex  parent = *RawPtr_to(const QModelIndex *, sfp[3]);
		bool ret_v = qp->hasIndex(row, column, parent);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual QVariant QAbstractItemModel.getHeaderData(int section, int orientation, int role);
KMETHOD QAbstractItemModel_getHeaderData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		int section = Int_to(int, sfp[1]);
		Qt::Orientation orientation = Int_to(Qt::Orientation, sfp[2]);
		int role = Int_to(int, sfp[3]);
		QVariant ret_v = qp->headerData(section, orientation, role);
		QVariant *ret_v_ = new QVariant(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual boolean QAbstractItemModel.insertColumns(int column, int count, QModelIndex parent);
KMETHOD QAbstractItemModel_insertColumns(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		int column = Int_to(int, sfp[1]);
		int count = Int_to(int, sfp[2]);
		const QModelIndex  parent = *RawPtr_to(const QModelIndex *, sfp[3]);
		bool ret_v = qp->insertColumns(column, count, parent);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual boolean QAbstractItemModel.insertRows(int row, int count, QModelIndex parent);
KMETHOD QAbstractItemModel_insertRows(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		int row = Int_to(int, sfp[1]);
		int count = Int_to(int, sfp[2]);
		const QModelIndex  parent = *RawPtr_to(const QModelIndex *, sfp[3]);
		bool ret_v = qp->insertRows(row, count, parent);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual QModelIndexList QAbstractItemModel.match(QModelIndex start, int role, QVariant value, int hits, QtMatchFlags flags);
KMETHOD QAbstractItemModel_match(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		const QModelIndex  start = *RawPtr_to(const QModelIndex *, sfp[1]);
		int role = Int_to(int, sfp[2]);
		const QVariant  value = *RawPtr_to(const QVariant *, sfp[3]);
		int hits = Int_to(int, sfp[4]);
		initFlag(flags, Qt::MatchFlags, sfp[5]);
		QModelIndexList ret_v = qp->match(start, role, value, hits, flags);
		QModelIndexList *ret_v_ = new QModelIndexList(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual QMimeData QAbstractItemModel.mimeData(QModelIndexList indexes);
KMETHOD QAbstractItemModel_mimeData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		const QModelIndexList  indexes = *RawPtr_to(const QModelIndexList *, sfp[1]);
		QMimeData* ret_v = qp->mimeData(indexes);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QMimeData*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual QModelIndex QAbstractItemModel.parent(QModelIndex index);
KMETHOD QAbstractItemModel_parent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		QModelIndex ret_v = qp->parent(index);
		QModelIndex *ret_v_ = new QModelIndex(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QAbstractItemModel.removeColumn(int column, QModelIndex parent);
KMETHOD QAbstractItemModel_removeColumn(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		int column = Int_to(int, sfp[1]);
		const QModelIndex  parent = *RawPtr_to(const QModelIndex *, sfp[2]);
		bool ret_v = qp->removeColumn(column, parent);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual boolean QAbstractItemModel.removeColumns(int column, int count, QModelIndex parent);
KMETHOD QAbstractItemModel_removeColumns(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		int column = Int_to(int, sfp[1]);
		int count = Int_to(int, sfp[2]);
		const QModelIndex  parent = *RawPtr_to(const QModelIndex *, sfp[3]);
		bool ret_v = qp->removeColumns(column, count, parent);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAbstractItemModel.removeRow(int row, QModelIndex parent);
KMETHOD QAbstractItemModel_removeRow(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		int row = Int_to(int, sfp[1]);
		const QModelIndex  parent = *RawPtr_to(const QModelIndex *, sfp[2]);
		bool ret_v = qp->removeRow(row, parent);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual boolean QAbstractItemModel.removeRows(int row, int count, QModelIndex parent);
KMETHOD QAbstractItemModel_removeRows(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		int row = Int_to(int, sfp[1]);
		int count = Int_to(int, sfp[2]);
		const QModelIndex  parent = *RawPtr_to(const QModelIndex *, sfp[3]);
		bool ret_v = qp->removeRows(row, count, parent);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual boolean QAbstractItemModel.setData(QModelIndex index, QVariant value, int role);
KMETHOD QAbstractItemModel_setData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		const QVariant  value = *RawPtr_to(const QVariant *, sfp[2]);
		int role = Int_to(int, sfp[3]);
		bool ret_v = qp->setData(index, value, role);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual boolean QAbstractItemModel.setHeaderData(int section, int orientation, QVariant value, int role);
KMETHOD QAbstractItemModel_setHeaderData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		int section = Int_to(int, sfp[1]);
		Qt::Orientation orientation = Int_to(Qt::Orientation, sfp[2]);
		const QVariant  value = *RawPtr_to(const QVariant *, sfp[3]);
		int role = Int_to(int, sfp[4]);
		bool ret_v = qp->setHeaderData(section, orientation, value, role);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QAbstractItemModel.setSupportedDragActions(QtDropActions actions);
KMETHOD QAbstractItemModel_setSupportedDragActions(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		initFlag(actions, Qt::DropActions, sfp[1]);
		qp->setSupportedDragActions(actions);
	}
	RETURNvoid_();
}

//QModelIndex QAbstractItemModel.sibling(int row, int column, QModelIndex index);
KMETHOD QAbstractItemModel_sibling(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		int row = Int_to(int, sfp[1]);
		int column = Int_to(int, sfp[2]);
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[3]);
		QModelIndex ret_v = qp->sibling(row, column, index);
		QModelIndex *ret_v_ = new QModelIndex(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual void QAbstractItemModel.sort(int column, int order);
KMETHOD QAbstractItemModel_sort(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		int column = Int_to(int, sfp[1]);
		Qt::SortOrder order = Int_to(Qt::SortOrder, sfp[2]);
		qp->sort(column, order);
	}
	RETURNvoid_();
}

//@Virtual QSize QAbstractItemModel.span(QModelIndex index);
KMETHOD QAbstractItemModel_span(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		QSize ret_v = qp->span(index);
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QtDropActions QAbstractItemModel.getSupportedDragActions();
KMETHOD QAbstractItemModel_getSupportedDragActions(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		Qt::DropActions ret_v = qp->supportedDragActions();
		Qt::DropActions *ret_v_ = new Qt::DropActions(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual QtDropActions QAbstractItemModel.supportedDropActions();
KMETHOD QAbstractItemModel_supportedDropActions(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		Qt::DropActions ret_v = qp->supportedDropActions();
		Qt::DropActions *ret_v_ = new Qt::DropActions(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual void QAbstractItemModel.revert();
KMETHOD QAbstractItemModel_revert(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		qp->revert();
	}
	RETURNvoid_();
}

//@Virtual boolean QAbstractItemModel.submit();
KMETHOD QAbstractItemModel_submit(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel *  qp = RawPtr_to(QAbstractItemModel *, sfp[0]);
	if (qp) {
		bool ret_v = qp->submit();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}


DummyQAbstractItemModel::DummyQAbstractItemModel()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	columns_about_to_be_inserted_func = NULL;
	columns_about_to_be_moved_func = NULL;
	columns_about_to_be_removed_func = NULL;
	columns_inserted_func = NULL;
	columns_moved_func = NULL;
	columns_removed_func = NULL;
	data_changed_func = NULL;
	header_data_changed_func = NULL;
	layout_about_to_be_changed_func = NULL;
	layout_changed_func = NULL;
	model_about_to_be_reset_func = NULL;
	model_reset_func = NULL;
	rows_about_to_be_inserted_func = NULL;
	rows_about_to_be_moved_func = NULL;
	rows_about_to_be_removed_func = NULL;
	rows_inserted_func = NULL;
	rows_moved_func = NULL;
	rows_removed_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("columns-about-to-be-inserted", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("columns-about-to-be-moved", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("columns-about-to-be-removed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("columns-inserted", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("columns-moved", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("columns-removed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("data-changed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("header-data-changed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("layout-about-to-be-changed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("layout-changed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("model-about-to-be-reset", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("model-reset", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("rows-about-to-be-inserted", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("rows-about-to-be-moved", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("rows-about-to-be-removed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("rows-inserted", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("rows-moved", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("rows-removed", NULL));
}
DummyQAbstractItemModel::~DummyQAbstractItemModel()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractItemModel::setSelf(kRawPtr *ptr)
{
	DummyQAbstractItemModel::self = ptr;
	DummyQObject::setSelf(ptr);
}

bool DummyQAbstractItemModel::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQObject::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAbstractItemModel::columnsAboutToBeInsertedSlot(const QModelIndex parent, int start, int end)
{
	if (columns_about_to_be_inserted_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, parent);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		lsfp[K_CALLDELTA+3].ivalue = start;
		lsfp[K_CALLDELTA+4].ivalue = end;
		knh_Func_invoke(lctx, columns_about_to_be_inserted_func, lsfp, 4);
		return true;
	}
	return false;
}

bool DummyQAbstractItemModel::columnsAboutToBeMovedSlot(const QModelIndex sourceParent, int sourceStart, int sourceEnd, const QModelIndex destinationParent, int destinationColumn)
{
	if (columns_about_to_be_moved_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, sourceParent);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		lsfp[K_CALLDELTA+3].ivalue = sourceStart;
		lsfp[K_CALLDELTA+4].ivalue = sourceEnd;
		kRawPtr *p4 = new_QRawPtr(lctx, QModelIndex, destinationParent);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+5].o, UPCAST(p4));
		lsfp[K_CALLDELTA+6].ivalue = destinationColumn;
		knh_Func_invoke(lctx, columns_about_to_be_moved_func, lsfp, 6);
		return true;
	}
	return false;
}

bool DummyQAbstractItemModel::columnsAboutToBeRemovedSlot(const QModelIndex parent, int start, int end)
{
	if (columns_about_to_be_removed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, parent);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		lsfp[K_CALLDELTA+3].ivalue = start;
		lsfp[K_CALLDELTA+4].ivalue = end;
		knh_Func_invoke(lctx, columns_about_to_be_removed_func, lsfp, 4);
		return true;
	}
	return false;
}

bool DummyQAbstractItemModel::columnsInsertedSlot(const QModelIndex parent, int start, int end)
{
	if (columns_inserted_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, parent);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		lsfp[K_CALLDELTA+3].ivalue = start;
		lsfp[K_CALLDELTA+4].ivalue = end;
		knh_Func_invoke(lctx, columns_inserted_func, lsfp, 4);
		return true;
	}
	return false;
}

bool DummyQAbstractItemModel::columnsMovedSlot(const QModelIndex sourceParent, int sourceStart, int sourceEnd, const QModelIndex destinationParent, int destinationColumn)
{
	if (columns_moved_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, sourceParent);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		lsfp[K_CALLDELTA+3].ivalue = sourceStart;
		lsfp[K_CALLDELTA+4].ivalue = sourceEnd;
		kRawPtr *p4 = new_QRawPtr(lctx, QModelIndex, destinationParent);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+5].o, UPCAST(p4));
		lsfp[K_CALLDELTA+6].ivalue = destinationColumn;
		knh_Func_invoke(lctx, columns_moved_func, lsfp, 6);
		return true;
	}
	return false;
}

bool DummyQAbstractItemModel::columnsRemovedSlot(const QModelIndex parent, int start, int end)
{
	if (columns_removed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, parent);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		lsfp[K_CALLDELTA+3].ivalue = start;
		lsfp[K_CALLDELTA+4].ivalue = end;
		knh_Func_invoke(lctx, columns_removed_func, lsfp, 4);
		return true;
	}
	return false;
}

bool DummyQAbstractItemModel::dataChangedSlot(const QModelIndex topLeft, const QModelIndex bottomRight)
{
	if (data_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, topLeft);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		kRawPtr *p2 = new_QRawPtr(lctx, QModelIndex, bottomRight);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+3].o, UPCAST(p2));
		knh_Func_invoke(lctx, data_changed_func, lsfp, 3);
		return true;
	}
	return false;
}

bool DummyQAbstractItemModel::headerDataChangedSlot(Qt::Orientation orientation, int first, int last)
{
	if (header_data_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].ivalue = orientation;
		lsfp[K_CALLDELTA+3].ivalue = first;
		lsfp[K_CALLDELTA+4].ivalue = last;
		knh_Func_invoke(lctx, header_data_changed_func, lsfp, 4);
		return true;
	}
	return false;
}

bool DummyQAbstractItemModel::layoutAboutToBeChangedSlot()
{
	if (layout_about_to_be_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, layout_about_to_be_changed_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAbstractItemModel::layoutChangedSlot()
{
	if (layout_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, layout_changed_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAbstractItemModel::modelAboutToBeResetSlot()
{
	if (model_about_to_be_reset_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, model_about_to_be_reset_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAbstractItemModel::modelResetSlot()
{
	if (model_reset_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, model_reset_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAbstractItemModel::rowsAboutToBeInsertedSlot(const QModelIndex parent, int start, int end)
{
	if (rows_about_to_be_inserted_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, parent);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		lsfp[K_CALLDELTA+3].ivalue = start;
		lsfp[K_CALLDELTA+4].ivalue = end;
		knh_Func_invoke(lctx, rows_about_to_be_inserted_func, lsfp, 4);
		return true;
	}
	return false;
}

bool DummyQAbstractItemModel::rowsAboutToBeMovedSlot(const QModelIndex sourceParent, int sourceStart, int sourceEnd, const QModelIndex destinationParent, int destinationRow)
{
	if (rows_about_to_be_moved_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, sourceParent);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		lsfp[K_CALLDELTA+3].ivalue = sourceStart;
		lsfp[K_CALLDELTA+4].ivalue = sourceEnd;
		kRawPtr *p4 = new_QRawPtr(lctx, QModelIndex, destinationParent);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+5].o, UPCAST(p4));
		lsfp[K_CALLDELTA+6].ivalue = destinationRow;
		knh_Func_invoke(lctx, rows_about_to_be_moved_func, lsfp, 6);
		return true;
	}
	return false;
}

bool DummyQAbstractItemModel::rowsAboutToBeRemovedSlot(const QModelIndex parent, int start, int end)
{
	if (rows_about_to_be_removed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, parent);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		lsfp[K_CALLDELTA+3].ivalue = start;
		lsfp[K_CALLDELTA+4].ivalue = end;
		knh_Func_invoke(lctx, rows_about_to_be_removed_func, lsfp, 4);
		return true;
	}
	return false;
}

bool DummyQAbstractItemModel::rowsInsertedSlot(const QModelIndex parent, int start, int end)
{
	if (rows_inserted_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, parent);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		lsfp[K_CALLDELTA+3].ivalue = start;
		lsfp[K_CALLDELTA+4].ivalue = end;
		knh_Func_invoke(lctx, rows_inserted_func, lsfp, 4);
		return true;
	}
	return false;
}

bool DummyQAbstractItemModel::rowsMovedSlot(const QModelIndex sourceParent, int sourceStart, int sourceEnd, const QModelIndex destinationParent, int destinationRow)
{
	if (rows_moved_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, sourceParent);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		lsfp[K_CALLDELTA+3].ivalue = sourceStart;
		lsfp[K_CALLDELTA+4].ivalue = sourceEnd;
		kRawPtr *p4 = new_QRawPtr(lctx, QModelIndex, destinationParent);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+5].o, UPCAST(p4));
		lsfp[K_CALLDELTA+6].ivalue = destinationRow;
		knh_Func_invoke(lctx, rows_moved_func, lsfp, 6);
		return true;
	}
	return false;
}

bool DummyQAbstractItemModel::rowsRemovedSlot(const QModelIndex parent, int start, int end)
{
	if (rows_removed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, parent);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		lsfp[K_CALLDELTA+3].ivalue = start;
		lsfp[K_CALLDELTA+4].ivalue = end;
		knh_Func_invoke(lctx, rows_removed_func, lsfp, 4);
		return true;
	}
	return false;
}

bool DummyQAbstractItemModel::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractItemModel::event_map->bigin();
	if ((itr = DummyQAbstractItemModel::event_map->find(str)) == DummyQAbstractItemModel::event_map->end()) {
		bool ret = false;
		ret = DummyQObject::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAbstractItemModel::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractItemModel::slot_map->bigin();
	if ((itr = DummyQAbstractItemModel::slot_map->find(str)) == DummyQAbstractItemModel::slot_map->end()) {
		bool ret = false;
		ret = DummyQObject::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		columns_about_to_be_inserted_func = (*slot_map)["columns-about-to-be-inserted"];
		columns_about_to_be_moved_func = (*slot_map)["columns-about-to-be-moved"];
		columns_about_to_be_removed_func = (*slot_map)["columns-about-to-be-removed"];
		columns_inserted_func = (*slot_map)["columns-inserted"];
		columns_moved_func = (*slot_map)["columns-moved"];
		columns_removed_func = (*slot_map)["columns-removed"];
		data_changed_func = (*slot_map)["data-changed"];
		header_data_changed_func = (*slot_map)["header-data-changed"];
		layout_about_to_be_changed_func = (*slot_map)["layout-about-to-be-changed"];
		layout_changed_func = (*slot_map)["layout-changed"];
		model_about_to_be_reset_func = (*slot_map)["model-about-to-be-reset"];
		model_reset_func = (*slot_map)["model-reset"];
		rows_about_to_be_inserted_func = (*slot_map)["rows-about-to-be-inserted"];
		rows_about_to_be_moved_func = (*slot_map)["rows-about-to-be-moved"];
		rows_about_to_be_removed_func = (*slot_map)["rows-about-to-be-removed"];
		rows_inserted_func = (*slot_map)["rows-inserted"];
		rows_moved_func = (*slot_map)["rows-moved"];
		rows_removed_func = (*slot_map)["rows-removed"];
		return true;
	}
}

kObject** DummyQAbstractItemModel::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractItemModel::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 19;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, columns_about_to_be_inserted_func);
	KNH_ADDNNREF(ctx, columns_about_to_be_moved_func);
	KNH_ADDNNREF(ctx, columns_about_to_be_removed_func);
	KNH_ADDNNREF(ctx, columns_inserted_func);
	KNH_ADDNNREF(ctx, columns_moved_func);
	KNH_ADDNNREF(ctx, columns_removed_func);
	KNH_ADDNNREF(ctx, data_changed_func);
	KNH_ADDNNREF(ctx, header_data_changed_func);
	KNH_ADDNNREF(ctx, layout_about_to_be_changed_func);
	KNH_ADDNNREF(ctx, layout_changed_func);
	KNH_ADDNNREF(ctx, model_about_to_be_reset_func);
	KNH_ADDNNREF(ctx, model_reset_func);
	KNH_ADDNNREF(ctx, rows_about_to_be_inserted_func);
	KNH_ADDNNREF(ctx, rows_about_to_be_moved_func);
	KNH_ADDNNREF(ctx, rows_about_to_be_removed_func);
	KNH_ADDNNREF(ctx, rows_inserted_func);
	KNH_ADDNNREF(ctx, rows_moved_func);
	KNH_ADDNNREF(ctx, rows_removed_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQObject::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAbstractItemModel::connection(QObject *o)
{
	QAbstractItemModel *p = dynamic_cast<QAbstractItemModel*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(columnsAboutToBeInserted(const QModelIndex, int, int)), this, SLOT(columnsAboutToBeInsertedSlot(const QModelIndex, int, int)));
		connect(p, SIGNAL(columnsAboutToBeMoved(const QModelIndex, int, int, const QModelIndex, int)), this, SLOT(columnsAboutToBeMovedSlot(const QModelIndex, int, int, const QModelIndex, int)));
		connect(p, SIGNAL(columnsAboutToBeRemoved(const QModelIndex, int, int)), this, SLOT(columnsAboutToBeRemovedSlot(const QModelIndex, int, int)));
		connect(p, SIGNAL(columnsInserted(const QModelIndex, int, int)), this, SLOT(columnsInsertedSlot(const QModelIndex, int, int)));
		connect(p, SIGNAL(columnsMoved(const QModelIndex, int, int, const QModelIndex, int)), this, SLOT(columnsMovedSlot(const QModelIndex, int, int, const QModelIndex, int)));
		connect(p, SIGNAL(columnsRemoved(const QModelIndex, int, int)), this, SLOT(columnsRemovedSlot(const QModelIndex, int, int)));
		connect(p, SIGNAL(dataChanged(const QModelIndex, const QModelIndex)), this, SLOT(dataChangedSlot(const QModelIndex, const QModelIndex)));
		connect(p, SIGNAL(headerDataChanged(Qt::Orientation, int, int)), this, SLOT(headerDataChangedSlot(Qt::Orientation, int, int)));
		connect(p, SIGNAL(layoutAboutToBeChanged()), this, SLOT(layoutAboutToBeChangedSlot()));
		connect(p, SIGNAL(layoutChanged()), this, SLOT(layoutChangedSlot()));
		connect(p, SIGNAL(modelAboutToBeReset()), this, SLOT(modelAboutToBeResetSlot()));
		connect(p, SIGNAL(modelReset()), this, SLOT(modelResetSlot()));
		connect(p, SIGNAL(rowsAboutToBeInserted(const QModelIndex, int, int)), this, SLOT(rowsAboutToBeInsertedSlot(const QModelIndex, int, int)));
		connect(p, SIGNAL(rowsAboutToBeMoved(const QModelIndex, int, int, const QModelIndex, int)), this, SLOT(rowsAboutToBeMovedSlot(const QModelIndex, int, int, const QModelIndex, int)));
		connect(p, SIGNAL(rowsAboutToBeRemoved(const QModelIndex, int, int)), this, SLOT(rowsAboutToBeRemovedSlot(const QModelIndex, int, int)));
		connect(p, SIGNAL(rowsInserted(const QModelIndex, int, int)), this, SLOT(rowsInsertedSlot(const QModelIndex, int, int)));
		connect(p, SIGNAL(rowsMoved(const QModelIndex, int, int, const QModelIndex, int)), this, SLOT(rowsMovedSlot(const QModelIndex, int, int, const QModelIndex, int)));
		connect(p, SIGNAL(rowsRemoved(const QModelIndex, int, int)), this, SLOT(rowsRemovedSlot(const QModelIndex, int, int)));
	}
	DummyQObject::connection(o);
}

KQAbstractItemModel::KQAbstractItemModel(QObject* parent) : QAbstractItemModel(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAbstractItemModel();
	dummy->connection((QObject*)this);
}

KQAbstractItemModel::~KQAbstractItemModel()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractItemModel_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractItemModel *qp = RawPtr_to(KQAbstractItemModel *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractItemModel]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractItemModel]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractItemModel_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractItemModel *qp = RawPtr_to(KQAbstractItemModel *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractItemModel]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractItemModel]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractItemModel_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractItemModel *qp = (KQAbstractItemModel *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractItemModel*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractItemModel_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractItemModel *qp = (KQAbstractItemModel *)p->rawptr;
		KQAbstractItemModel *qp = static_cast<KQAbstractItemModel*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractItemModel_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractItemModel::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAbstractItemModel::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAbstractItemModel::event(event);
		return false;
	}
//	QAbstractItemModel::event(event);
	return true;
}



DEFAPI(void) defQAbstractItemModel(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractItemModel";
	cdef->free = QAbstractItemModel_free;
	cdef->reftrace = QAbstractItemModel_reftrace;
	cdef->compareTo = QAbstractItemModel_compareTo;
}


//@Virtual @Override QVariant QAbstractItemView.inputMethodQuery(int query);
KMETHOD QAbstractItemView_inputMethodQuery(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		Qt::InputMethodQuery query = Int_to(Qt::InputMethodQuery, sfp[1]);
		QVariant ret_v = qp->inputMethodQuery(query);
		QVariant *ret_v_ = new QVariant(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//
//boolean QAbstractItemView.getAlternatingRowColors();
KMETHOD QAbstractItemView_getAlternatingRowColors(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		bool ret_v = qp->alternatingRowColors();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//int QAbstractItemView.getAutoScrollMargin();
KMETHOD QAbstractItemView_getAutoScrollMargin(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		int ret_v = qp->autoScrollMargin();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QAbstractItemView.closePersistentEditor(QModelIndex index);
KMETHOD QAbstractItemView_closePersistentEditor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		qp->closePersistentEditor(index);
	}
	RETURNvoid_();
}

//QModelIndex QAbstractItemView.getCurrentIndex();
KMETHOD QAbstractItemView_getCurrentIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QModelIndex ret_v = qp->currentIndex();
		QModelIndex *ret_v_ = new QModelIndex(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QAbstractItemView.getDefaultDropAction();
KMETHOD QAbstractItemView_getDefaultDropAction(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		Qt::DropAction ret_v = qp->defaultDropAction();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAbstractItemView.getDragDropMode();
KMETHOD QAbstractItemView_getDragDropMode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QAbstractItemView::DragDropMode ret_v = qp->dragDropMode();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//boolean QAbstractItemView.getDragDropOverwriteMode();
KMETHOD QAbstractItemView_getDragDropOverwriteMode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		bool ret_v = qp->dragDropOverwriteMode();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAbstractItemView.getDragEnabled();
KMETHOD QAbstractItemView_getDragEnabled(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		bool ret_v = qp->dragEnabled();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//QAbstractItemViewEditTriggers QAbstractItemView.getEditTriggers();
KMETHOD QAbstractItemView_getEditTriggers(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QAbstractItemView::EditTriggers ret_v = qp->editTriggers();
		QAbstractItemView::EditTriggers *ret_v_ = new QAbstractItemView::EditTriggers(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QAbstractItemView.hasAutoScroll();
KMETHOD QAbstractItemView_hasAutoScroll(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		bool ret_v = qp->hasAutoScroll();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//int QAbstractItemView.getHorizontalScrollMode();
KMETHOD QAbstractItemView_getHorizontalScrollMode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QAbstractItemView::ScrollMode ret_v = qp->horizontalScrollMode();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QSize QAbstractItemView.getIconSize();
KMETHOD QAbstractItemView_getIconSize(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->iconSize();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual QModelIndex QAbstractItemView.indexAt(QPoint point);
KMETHOD QAbstractItemView_indexAt(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		const QPoint  point = *RawPtr_to(const QPoint *, sfp[1]);
		QModelIndex ret_v = qp->indexAt(point);
		QModelIndex *ret_v_ = new QModelIndex(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QWidget QAbstractItemView.getIndexWidget(QModelIndex index);
KMETHOD QAbstractItemView_getIndexWidget(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		QWidget* ret_v = qp->indexWidget(index);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QWidget*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QAbstractItemDelegate QAbstractItemView.getItemDelegate();
KMETHOD QAbstractItemView_getItemDelegate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QAbstractItemDelegate* ret_v = qp->itemDelegate();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractItemDelegate*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//QAbstractItemDelegate QAbstractItemView.getItemDelegate(QModelIndex index);
KMETHOD QAbstractItemView_getItemDelegate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		QAbstractItemDelegate* ret_v = qp->itemDelegate(index);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractItemDelegate*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//QAbstractItemDelegate QAbstractItemView.getItemDelegateForColumn(int column);
KMETHOD QAbstractItemView_getItemDelegateForColumn(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		int column = Int_to(int, sfp[1]);
		QAbstractItemDelegate* ret_v = qp->itemDelegateForColumn(column);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractItemDelegate*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QAbstractItemDelegate QAbstractItemView.getItemDelegateForRow(int row);
KMETHOD QAbstractItemView_getItemDelegateForRow(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		int row = Int_to(int, sfp[1]);
		QAbstractItemDelegate* ret_v = qp->itemDelegateForRow(row);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractItemDelegate*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual void QAbstractItemView.keyboardSearch(String search);
KMETHOD QAbstractItemView_keyboardSearch(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		const QString search = String_to(const QString, sfp[1]);
		qp->keyboardSearch(search);
	}
	RETURNvoid_();
}

//QAbstractItemModel QAbstractItemView.getModel();
KMETHOD QAbstractItemView_getModel(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QAbstractItemModel* ret_v = qp->model();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractItemModel*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QAbstractItemView.openPersistentEditor(QModelIndex index);
KMETHOD QAbstractItemView_openPersistentEditor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		qp->openPersistentEditor(index);
	}
	RETURNvoid_();
}

//QModelIndex QAbstractItemView.getRootIndex();
KMETHOD QAbstractItemView_getRootIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QModelIndex ret_v = qp->rootIndex();
		QModelIndex *ret_v_ = new QModelIndex(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual void QAbstractItemView.scrollTo(QModelIndex index, int hint);
KMETHOD QAbstractItemView_scrollTo(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		QAbstractItemView::ScrollHint hint = Int_to(QAbstractItemView::ScrollHint, sfp[2]);
		qp->scrollTo(index, hint);
	}
	RETURNvoid_();
}

//int QAbstractItemView.getSelectionBehavior();
KMETHOD QAbstractItemView_getSelectionBehavior(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QAbstractItemView::SelectionBehavior ret_v = qp->selectionBehavior();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAbstractItemView.getSelectionMode();
KMETHOD QAbstractItemView_getSelectionMode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QAbstractItemView::SelectionMode ret_v = qp->selectionMode();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QItemSelectionModel QAbstractItemView.getSelectionModel();
KMETHOD QAbstractItemView_getSelectionModel(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QItemSelectionModel* ret_v = qp->selectionModel();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QItemSelectionModel*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QAbstractItemView.setAlternatingRowColors(boolean enable);
KMETHOD QAbstractItemView_setAlternatingRowColors(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		bool enable = Boolean_to(bool, sfp[1]);
		qp->setAlternatingRowColors(enable);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setAutoScroll(boolean enable);
KMETHOD QAbstractItemView_setAutoScroll(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		bool enable = Boolean_to(bool, sfp[1]);
		qp->setAutoScroll(enable);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setAutoScrollMargin(int margin);
KMETHOD QAbstractItemView_setAutoScrollMargin(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		int margin = Int_to(int, sfp[1]);
		qp->setAutoScrollMargin(margin);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setDefaultDropAction(int dropAction);
KMETHOD QAbstractItemView_setDefaultDropAction(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		Qt::DropAction dropAction = Int_to(Qt::DropAction, sfp[1]);
		qp->setDefaultDropAction(dropAction);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setDragDropMode(int behavior);
KMETHOD QAbstractItemView_setDragDropMode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QAbstractItemView::DragDropMode behavior = Int_to(QAbstractItemView::DragDropMode, sfp[1]);
		qp->setDragDropMode(behavior);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setDragDropOverwriteMode(boolean overwrite);
KMETHOD QAbstractItemView_setDragDropOverwriteMode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		bool overwrite = Boolean_to(bool, sfp[1]);
		qp->setDragDropOverwriteMode(overwrite);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setDragEnabled(boolean enable);
KMETHOD QAbstractItemView_setDragEnabled(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		bool enable = Boolean_to(bool, sfp[1]);
		qp->setDragEnabled(enable);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setDropIndicatorShown(boolean enable);
KMETHOD QAbstractItemView_setDropIndicatorShown(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		bool enable = Boolean_to(bool, sfp[1]);
		qp->setDropIndicatorShown(enable);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setEditTriggers(QAbstractItemViewEditTriggers triggers);
KMETHOD QAbstractItemView_setEditTriggers(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		initFlag(triggers, QAbstractItemView::EditTriggers, sfp[1]);
		qp->setEditTriggers(triggers);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setHorizontalScrollMode(int mode);
KMETHOD QAbstractItemView_setHorizontalScrollMode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QAbstractItemView::ScrollMode mode = Int_to(QAbstractItemView::ScrollMode, sfp[1]);
		qp->setHorizontalScrollMode(mode);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setIconSize(QSize size);
KMETHOD QAbstractItemView_setIconSize(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		const QSize  size = *RawPtr_to(const QSize *, sfp[1]);
		qp->setIconSize(size);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setIndexWidget(QModelIndex index, QWidget widget);
KMETHOD QAbstractItemView_setIndexWidget(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		QWidget*  widget = RawPtr_to(QWidget*, sfp[2]);
		qp->setIndexWidget(index, widget);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setItemDelegate(QAbstractItemDelegate delegate);
KMETHOD QAbstractItemView_setItemDelegate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QAbstractItemDelegate*  delegate = RawPtr_to(QAbstractItemDelegate*, sfp[1]);
		qp->setItemDelegate(delegate);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setItemDelegateForColumn(int column, QAbstractItemDelegate delegate);
KMETHOD QAbstractItemView_setItemDelegateForColumn(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		int column = Int_to(int, sfp[1]);
		QAbstractItemDelegate*  delegate = RawPtr_to(QAbstractItemDelegate*, sfp[2]);
		qp->setItemDelegateForColumn(column, delegate);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setItemDelegateForRow(int row, QAbstractItemDelegate delegate);
KMETHOD QAbstractItemView_setItemDelegateForRow(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		int row = Int_to(int, sfp[1]);
		QAbstractItemDelegate*  delegate = RawPtr_to(QAbstractItemDelegate*, sfp[2]);
		qp->setItemDelegateForRow(row, delegate);
	}
	RETURNvoid_();
}

//@Virtual void QAbstractItemView.setModel(QAbstractItemModel model);
KMETHOD QAbstractItemView_setModel(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QAbstractItemModel*  model = RawPtr_to(QAbstractItemModel*, sfp[1]);
		qp->setModel(model);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setSelectionBehavior(int behavior);
KMETHOD QAbstractItemView_setSelectionBehavior(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QAbstractItemView::SelectionBehavior behavior = Int_to(QAbstractItemView::SelectionBehavior, sfp[1]);
		qp->setSelectionBehavior(behavior);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setSelectionMode(int mode);
KMETHOD QAbstractItemView_setSelectionMode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QAbstractItemView::SelectionMode mode = Int_to(QAbstractItemView::SelectionMode, sfp[1]);
		qp->setSelectionMode(mode);
	}
	RETURNvoid_();
}

//@Virtual void QAbstractItemView.setSelectionModel(QItemSelectionModel selectionModel);
KMETHOD QAbstractItemView_setSelectionModel(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QItemSelectionModel*  selectionModel = RawPtr_to(QItemSelectionModel*, sfp[1]);
		qp->setSelectionModel(selectionModel);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setTabKeyNavigation(boolean enable);
KMETHOD QAbstractItemView_setTabKeyNavigation(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		bool enable = Boolean_to(bool, sfp[1]);
		qp->setTabKeyNavigation(enable);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setTextElideMode(int mode);
KMETHOD QAbstractItemView_setTextElideMode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		Qt::TextElideMode mode = Int_to(Qt::TextElideMode, sfp[1]);
		qp->setTextElideMode(mode);
	}
	RETURNvoid_();
}

//void QAbstractItemView.setVerticalScrollMode(int mode);
KMETHOD QAbstractItemView_setVerticalScrollMode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QAbstractItemView::ScrollMode mode = Int_to(QAbstractItemView::ScrollMode, sfp[1]);
		qp->setVerticalScrollMode(mode);
	}
	RETURNvoid_();
}

//boolean QAbstractItemView.showDropIndicator();
KMETHOD QAbstractItemView_showDropIndicator(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		bool ret_v = qp->showDropIndicator();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual int QAbstractItemView.sizeHintForColumn(int column);
KMETHOD QAbstractItemView_sizeHintForColumn(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		int column = Int_to(int, sfp[1]);
		int ret_v = qp->sizeHintForColumn(column);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QSize QAbstractItemView.sizeHintForIndex(QModelIndex index);
KMETHOD QAbstractItemView_sizeHintForIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		QSize ret_v = qp->sizeHintForIndex(index);
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual int QAbstractItemView.sizeHintForRow(int row);
KMETHOD QAbstractItemView_sizeHintForRow(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		int row = Int_to(int, sfp[1]);
		int ret_v = qp->sizeHintForRow(row);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//boolean QAbstractItemView.getTabKeyNavigation();
KMETHOD QAbstractItemView_getTabKeyNavigation(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		bool ret_v = qp->tabKeyNavigation();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//int QAbstractItemView.getTextElideMode();
KMETHOD QAbstractItemView_getTextElideMode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		Qt::TextElideMode ret_v = qp->textElideMode();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAbstractItemView.getVerticalScrollMode();
KMETHOD QAbstractItemView_getVerticalScrollMode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		QAbstractItemView::ScrollMode ret_v = qp->verticalScrollMode();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual QRect QAbstractItemView.visualRect(QModelIndex index);
KMETHOD QAbstractItemView_visualRect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		QRect ret_v = qp->visualRect(index);
		QRect *ret_v_ = new QRect(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QAbstractItemView.clearSelection();
KMETHOD QAbstractItemView_clearSelection(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		qp->clearSelection();
	}
	RETURNvoid_();
}

//void QAbstractItemView.edit(QModelIndex index);
KMETHOD QAbstractItemView_edit(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		qp->edit(index);
	}
	RETURNvoid_();
}

//@Virtual void QAbstractItemView.reset();
KMETHOD QAbstractItemView_reset(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		qp->reset();
	}
	RETURNvoid_();
}

//void QAbstractItemView.scrollToBottom();
KMETHOD QAbstractItemView_scrollToBottom(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		qp->scrollToBottom();
	}
	RETURNvoid_();
}

//void QAbstractItemView.scrollToTop();
KMETHOD QAbstractItemView_scrollToTop(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		qp->scrollToTop();
	}
	RETURNvoid_();
}

//@Virtual void QAbstractItemView.selectAll();
KMETHOD QAbstractItemView_selectAll(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		qp->selectAll();
	}
	RETURNvoid_();
}

//void QAbstractItemView.setCurrentIndex(QModelIndex index);
KMETHOD QAbstractItemView_setCurrentIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		qp->setCurrentIndex(index);
	}
	RETURNvoid_();
}

//@Virtual void QAbstractItemView.setRootIndex(QModelIndex index);
KMETHOD QAbstractItemView_setRootIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		qp->setRootIndex(index);
	}
	RETURNvoid_();
}

//void QAbstractItemView.update(QModelIndex index);
KMETHOD QAbstractItemView_update(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView *  qp = RawPtr_to(QAbstractItemView *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		qp->update(index);
	}
	RETURNvoid_();
}


DummyQAbstractItemView::DummyQAbstractItemView()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	activated_func = NULL;
	clicked_func = NULL;
	double_clicked_func = NULL;
	entered_func = NULL;
	pressed_func = NULL;
	viewport_entered_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("activated", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("clicked", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("double-clicked", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("entered", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("pressed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("viewport-entered", NULL));
}
DummyQAbstractItemView::~DummyQAbstractItemView()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractItemView::setSelf(kRawPtr *ptr)
{
	DummyQAbstractItemView::self = ptr;
	DummyQAbstractScrollArea::setSelf(ptr);
}

bool DummyQAbstractItemView::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQAbstractScrollArea::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAbstractItemView::activatedSlot(const QModelIndex index)
{
	if (activated_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, index);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, activated_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractItemView::clickedSlot(const QModelIndex index)
{
	if (clicked_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, index);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, clicked_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractItemView::doubleClickedSlot(const QModelIndex index)
{
	if (double_clicked_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, index);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, double_clicked_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractItemView::enteredSlot(const QModelIndex index)
{
	if (entered_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, index);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, entered_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractItemView::pressedSlot(const QModelIndex index)
{
	if (pressed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, index);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, pressed_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractItemView::viewportEnteredSlot()
{
	if (viewport_entered_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, viewport_entered_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAbstractItemView::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractItemView::event_map->bigin();
	if ((itr = DummyQAbstractItemView::event_map->find(str)) == DummyQAbstractItemView::event_map->end()) {
		bool ret = false;
		ret = DummyQAbstractScrollArea::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAbstractItemView::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractItemView::slot_map->bigin();
	if ((itr = DummyQAbstractItemView::slot_map->find(str)) == DummyQAbstractItemView::slot_map->end()) {
		bool ret = false;
		ret = DummyQAbstractScrollArea::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		activated_func = (*slot_map)["activated"];
		clicked_func = (*slot_map)["clicked"];
		double_clicked_func = (*slot_map)["double-clicked"];
		entered_func = (*slot_map)["entered"];
		pressed_func = (*slot_map)["pressed"];
		viewport_entered_func = (*slot_map)["viewport-entered"];
		return true;
	}
}

kObject** DummyQAbstractItemView::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractItemView::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 7;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, activated_func);
	KNH_ADDNNREF(ctx, clicked_func);
	KNH_ADDNNREF(ctx, double_clicked_func);
	KNH_ADDNNREF(ctx, entered_func);
	KNH_ADDNNREF(ctx, pressed_func);
	KNH_ADDNNREF(ctx, viewport_entered_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQAbstractScrollArea::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAbstractItemView::connection(QObject *o)
{
	QAbstractItemView *p = dynamic_cast<QAbstractItemView*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(activated(const QModelIndex)), this, SLOT(activatedSlot(const QModelIndex)));
		connect(p, SIGNAL(clicked(const QModelIndex)), this, SLOT(clickedSlot(const QModelIndex)));
		connect(p, SIGNAL(doubleClicked(const QModelIndex)), this, SLOT(doubleClickedSlot(const QModelIndex)));
		connect(p, SIGNAL(entered(const QModelIndex)), this, SLOT(enteredSlot(const QModelIndex)));
		connect(p, SIGNAL(pressed(const QModelIndex)), this, SLOT(pressedSlot(const QModelIndex)));
		connect(p, SIGNAL(viewportEntered()), this, SLOT(viewportEnteredSlot()));
	}
	DummyQAbstractScrollArea::connection(o);
}

KQAbstractItemView::KQAbstractItemView(QWidget* parent) : QAbstractItemView(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAbstractItemView();
	dummy->connection((QObject*)this);
}

KQAbstractItemView::~KQAbstractItemView()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractItemView_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractItemView *qp = RawPtr_to(KQAbstractItemView *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractItemView]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractItemView]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractItemView_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractItemView *qp = RawPtr_to(KQAbstractItemView *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractItemView]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractItemView]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractItemView_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractItemView *qp = (KQAbstractItemView *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractItemView*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractItemView_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractItemView *qp = (KQAbstractItemView *)p->rawptr;
		KQAbstractItemView *qp = static_cast<KQAbstractItemView*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractItemView_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractItemView::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAbstractItemView::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAbstractItemView::event(event);
		return false;
	}
//	QAbstractItemView::event(event);
	return true;
}

static knh_IntData_t QAbstractItemViewConstInt[] = {
	{"NoDragDrop", QAbstractItemView::NoDragDrop},
	{"DragOnly", QAbstractItemView::DragOnly},
	{"DropOnly", QAbstractItemView::DropOnly},
	{"DragDrop", QAbstractItemView::DragDrop},
	{"InternalMove", QAbstractItemView::InternalMove},
	{"NoEditTriggers", QAbstractItemView::NoEditTriggers},
	{"CurrentChanged", QAbstractItemView::CurrentChanged},
	{"DoubleClicked", QAbstractItemView::DoubleClicked},
	{"SelectedClicked", QAbstractItemView::SelectedClicked},
	{"EditKeyPressed", QAbstractItemView::EditKeyPressed},
	{"AnyKeyPressed", QAbstractItemView::AnyKeyPressed},
	{"AllEditTriggers", QAbstractItemView::AllEditTriggers},
	{"EnsureVisible", QAbstractItemView::EnsureVisible},
	{"PositionAtTop", QAbstractItemView::PositionAtTop},
	{"PositionAtBottom", QAbstractItemView::PositionAtBottom},
	{"PositionAtCenter", QAbstractItemView::PositionAtCenter},
	{"ScrollPerItem", QAbstractItemView::ScrollPerItem},
	{"ScrollPerPixel", QAbstractItemView::ScrollPerPixel},
	{"SelectItems", QAbstractItemView::SelectItems},
	{"SelectRows", QAbstractItemView::SelectRows},
	{"SelectColumns", QAbstractItemView::SelectColumns},
	{"SingleSelection", QAbstractItemView::SingleSelection},
	{"ContiguousSelection", QAbstractItemView::ContiguousSelection},
	{"ExtendedSelection", QAbstractItemView::ExtendedSelection},
	{"MultiSelection", QAbstractItemView::MultiSelection},
	{"NoSelection", QAbstractItemView::NoSelection},
	{NULL, 0}
};

DEFAPI(void) constQAbstractItemView(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QAbstractItemViewConstInt);
}


DEFAPI(void) defQAbstractItemView(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractItemView";
	cdef->free = QAbstractItemView_free;
	cdef->reftrace = QAbstractItemView_reftrace;
	cdef->compareTo = QAbstractItemView_compareTo;
}

//## QAbstractItemViewEditTriggers QAbstractItemViewEditTriggers.new(int value);
KMETHOD QAbstractItemViewEditTriggers_new(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractItemView::EditTrigger i = Int_to(QAbstractItemView::EditTrigger, sfp[1]);
	QAbstractItemView::EditTriggers *ret_v = new QAbstractItemView::EditTriggers(i);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	RETURN_(rptr);
}

//## QAbstractItemViewEditTriggers QAbstractItemViewEditTriggers.and(int mask);
KMETHOD QAbstractItemViewEditTriggers_and(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractItemView::EditTriggers *qp = RawPtr_to(QAbstractItemView::EditTriggers*, sfp[0]);
	if (qp != NULL) {
		int i = Int_to(int, sfp[1]);
		QAbstractItemView::EditTriggers ret = ((*qp) & i);
		QAbstractItemView::EditTriggers *ret_ = new QAbstractItemView::EditTriggers(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractItemViewEditTriggers QAbstractItemViewEditTriggers.iand(QAbstractItemView::QAbstractItemViewEditTriggers other);
KMETHOD QAbstractItemViewEditTriggers_iand(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractItemView::EditTriggers *qp = RawPtr_to(QAbstractItemView::EditTriggers*, sfp[0]);
	if (qp != NULL) {
		QAbstractItemView::EditTriggers *other = RawPtr_to(QAbstractItemView::EditTriggers *, sfp[1]);
		*qp = ((*qp) & (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractItemViewEditTriggers QAbstractItemViewEditTriggers.or(QAbstractItemViewEditTriggers f);
KMETHOD QAbstractItemViewEditTriggers_or(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView::EditTriggers *qp = RawPtr_to(QAbstractItemView::EditTriggers*, sfp[0]);
	if (qp != NULL) {
		QAbstractItemView::EditTriggers *f = RawPtr_to(QAbstractItemView::EditTriggers*, sfp[1]);
		QAbstractItemView::EditTriggers ret = ((*qp) | (*f));
		QAbstractItemView::EditTriggers *ret_ = new QAbstractItemView::EditTriggers(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractItemViewEditTriggers QAbstractItemViewEditTriggers.ior(QAbstractItemView::QAbstractItemViewEditTriggers other);
KMETHOD QAbstractItemViewEditTriggers_ior(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractItemView::EditTriggers *qp = RawPtr_to(QAbstractItemView::EditTriggers*, sfp[0]);
	if (qp != NULL) {
		QAbstractItemView::EditTriggers *other = RawPtr_to(QAbstractItemView::EditTriggers *, sfp[1]);
		*qp = ((*qp) | (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractItemViewEditTriggers QAbstractItemViewEditTriggers.xor(QAbstractItemViewEditTriggers f);
KMETHOD QAbstractItemViewEditTriggers_xor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemView::EditTriggers *qp = RawPtr_to(QAbstractItemView::EditTriggers*, sfp[0]);
	if (qp != NULL) {
		QAbstractItemView::EditTriggers *f = RawPtr_to(QAbstractItemView::EditTriggers*, sfp[1]);
		QAbstractItemView::EditTriggers ret = ((*qp) ^ (*f));
		QAbstractItemView::EditTriggers *ret_ = new QAbstractItemView::EditTriggers(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractItemViewEditTriggers QAbstractItemViewEditTriggers.ixor(QAbstractItemView::QAbstractItemViewEditTriggers other);
KMETHOD QAbstractItemViewEditTriggers_ixor(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractItemView::EditTriggers *qp = RawPtr_to(QAbstractItemView::EditTriggers*, sfp[0]);
	if (qp != NULL) {
		QAbstractItemView::EditTriggers *other = RawPtr_to(QAbstractItemView::EditTriggers *, sfp[1]);
		*qp = ((*qp) ^ (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## boolean QAbstractItemViewEditTriggers.testFlag(int flag);
KMETHOD QAbstractItemViewEditTriggers_testFlag(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractItemView::EditTriggers *qp = RawPtr_to(QAbstractItemView::EditTriggers *, sfp[0]);
	if (qp != NULL) {
		QAbstractItemView::EditTrigger flag = Int_to(QAbstractItemView::EditTrigger, sfp[1]);
		bool ret = qp->testFlag(flag);
		RETURNb_(ret);
	} else {
		RETURNb_(false);
	}
}

//## int QAbstractItemViewEditTriggers.value();
KMETHOD QAbstractItemViewEditTriggers_value(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractItemView::EditTriggers *qp = RawPtr_to(QAbstractItemView::EditTriggers *, sfp[0]);
	if (qp != NULL) {
		int ret = int(*qp);
		RETURNi_(ret);
	} else {
		RETURNi_(0);
	}
}

static void QAbstractItemViewEditTriggers_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (p->rawptr != NULL) {
		QAbstractItemView::EditTriggers *qp = (QAbstractItemView::EditTriggers *)p->rawptr;
		(void)qp;
		delete qp;
		p->rawptr = NULL;
	}
}

static void QAbstractItemViewEditTriggers_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
	if (p->rawptr != NULL) {
		QAbstractItemView::EditTriggers *qp = (QAbstractItemView::EditTriggers *)p->rawptr;
		(void)qp;
	}
}

static int QAbstractItemViewEditTriggers_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	if (p1->rawptr == NULL || p2->rawptr == NULL) {
		return 1;
	} else {
//		int v1 = int(*(QAbstractItemView::EditTriggers*)p1->rawptr);
//		int v2 = int(*(QAbstractItemView::EditTriggers*)p2->rawptr);
//		return (v1 == v2 ? 0 : 1);
		QAbstractItemView::EditTriggers v1 = *(QAbstractItemView::EditTriggers*)p1->rawptr;
		QAbstractItemView::EditTriggers v2 = *(QAbstractItemView::EditTriggers*)p2->rawptr;
//		return (v1 == v2 ? 0 : 1);
		return (v1 == v2 ? 0 : 1);

	}
}

DEFAPI(void) defQAbstractItemViewEditTriggers(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractItemViewEditTriggers";
	cdef->free = QAbstractItemViewEditTriggers_free;
	cdef->reftrace = QAbstractItemViewEditTriggers_reftrace;
	cdef->compareTo = QAbstractItemViewEditTriggers_compareTo;
}

//@Virtual @Override boolean QAbstractListModel.dropMimeData(QMimeData data, int action, int row, int column, QModelIndex parent);
KMETHOD QAbstractListModel_dropMimeData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractListModel *  qp = RawPtr_to(QAbstractListModel *, sfp[0]);
	if (qp) {
		const QMimeData*  data = RawPtr_to(const QMimeData*, sfp[1]);
		Qt::DropAction action = Int_to(Qt::DropAction, sfp[2]);
		int row = Int_to(int, sfp[3]);
		int column = Int_to(int, sfp[4]);
		const QModelIndex  parent = *RawPtr_to(const QModelIndex *, sfp[5]);
		bool ret_v = qp->dropMimeData(data, action, row, column, parent);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override QModelIndex QAbstractListModel.index(int row, int column, QModelIndex parent);
KMETHOD QAbstractListModel_index(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractListModel *  qp = RawPtr_to(QAbstractListModel *, sfp[0]);
	if (qp) {
		int row = Int_to(int, sfp[1]);
		int column = Int_to(int, sfp[2]);
		const QModelIndex  parent = *RawPtr_to(const QModelIndex *, sfp[3]);
		QModelIndex ret_v = qp->index(row, column, parent);
		QModelIndex *ret_v_ = new QModelIndex(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//

DummyQAbstractListModel::DummyQAbstractListModel()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQAbstractListModel::~DummyQAbstractListModel()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractListModel::setSelf(kRawPtr *ptr)
{
	DummyQAbstractListModel::self = ptr;
	DummyQAbstractItemModel::setSelf(ptr);
}

bool DummyQAbstractListModel::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQAbstractItemModel::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAbstractListModel::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractListModel::event_map->bigin();
	if ((itr = DummyQAbstractListModel::event_map->find(str)) == DummyQAbstractListModel::event_map->end()) {
		bool ret = false;
		ret = DummyQAbstractItemModel::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAbstractListModel::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractListModel::slot_map->bigin();
	if ((itr = DummyQAbstractListModel::slot_map->find(str)) == DummyQAbstractListModel::slot_map->end()) {
		bool ret = false;
		ret = DummyQAbstractItemModel::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQAbstractListModel::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractListModel::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQAbstractItemModel::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAbstractListModel::connection(QObject *o)
{
	QAbstractListModel *p = dynamic_cast<QAbstractListModel*>(o);
	if (p != NULL) {
	}
	DummyQAbstractItemModel::connection(o);
}

KQAbstractListModel::KQAbstractListModel(QObject* parent) : QAbstractListModel(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAbstractListModel();
	dummy->connection((QObject*)this);
}

KQAbstractListModel::~KQAbstractListModel()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractListModel_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractListModel *qp = RawPtr_to(KQAbstractListModel *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractListModel]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractListModel]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractListModel_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractListModel *qp = RawPtr_to(KQAbstractListModel *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractListModel]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractListModel]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractListModel_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractListModel *qp = (KQAbstractListModel *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractListModel*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractListModel_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractListModel *qp = (KQAbstractListModel *)p->rawptr;
		KQAbstractListModel *qp = static_cast<KQAbstractListModel*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractListModel_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractListModel::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAbstractListModel::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAbstractListModel::event(event);
		return false;
	}
//	QAbstractListModel::event(event);
	return true;
}



DEFAPI(void) defQAbstractListModel(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractListModel";
	cdef->free = QAbstractListModel_free;
	cdef->reftrace = QAbstractListModel_reftrace;
	cdef->compareTo = QAbstractListModel_compareTo;
}


//@Virtual int QAbstractNetworkCache.cacheSize();
KMETHOD QAbstractNetworkCache_cacheSize(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractNetworkCache *  qp = RawPtr_to(QAbstractNetworkCache *, sfp[0]);
	if (qp) {
		qint64 ret_v = qp->cacheSize();
		qint64 *ret_v_ = new qint64(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual QIODevice QAbstractNetworkCache.data(QUrl url);
KMETHOD QAbstractNetworkCache_data(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractNetworkCache *  qp = RawPtr_to(QAbstractNetworkCache *, sfp[0]);
	if (qp) {
		const QUrl  url = *RawPtr_to(const QUrl *, sfp[1]);
		QIODevice* ret_v = qp->data(url);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QIODevice*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual void QAbstractNetworkCache.insert(QIODevice device);
KMETHOD QAbstractNetworkCache_insert(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractNetworkCache *  qp = RawPtr_to(QAbstractNetworkCache *, sfp[0]);
	if (qp) {
		QIODevice*  device = RawPtr_to(QIODevice*, sfp[1]);
		qp->insert(device);
	}
	RETURNvoid_();
}

//@Virtual QNetworkCacheMetaData QAbstractNetworkCache.metaData(QUrl url);
KMETHOD QAbstractNetworkCache_metaData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractNetworkCache *  qp = RawPtr_to(QAbstractNetworkCache *, sfp[0]);
	if (qp) {
		const QUrl  url = *RawPtr_to(const QUrl *, sfp[1]);
		QNetworkCacheMetaData ret_v = qp->metaData(url);
		QNetworkCacheMetaData *ret_v_ = new QNetworkCacheMetaData(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual QIODevice QAbstractNetworkCache.prepare(QNetworkCacheMetaData metaData);
KMETHOD QAbstractNetworkCache_prepare(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractNetworkCache *  qp = RawPtr_to(QAbstractNetworkCache *, sfp[0]);
	if (qp) {
		const QNetworkCacheMetaData  metaData = *RawPtr_to(const QNetworkCacheMetaData *, sfp[1]);
		QIODevice* ret_v = qp->prepare(metaData);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QIODevice*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual boolean QAbstractNetworkCache.remove(QUrl url);
KMETHOD QAbstractNetworkCache_remove(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractNetworkCache *  qp = RawPtr_to(QAbstractNetworkCache *, sfp[0]);
	if (qp) {
		const QUrl  url = *RawPtr_to(const QUrl *, sfp[1]);
		bool ret_v = qp->remove(url);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual void QAbstractNetworkCache.updateMetaData(QNetworkCacheMetaData metaData);
KMETHOD QAbstractNetworkCache_updateMetaData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractNetworkCache *  qp = RawPtr_to(QAbstractNetworkCache *, sfp[0]);
	if (qp) {
		const QNetworkCacheMetaData  metaData = *RawPtr_to(const QNetworkCacheMetaData *, sfp[1]);
		qp->updateMetaData(metaData);
	}
	RETURNvoid_();
}

//@Virtual void QAbstractNetworkCache.clear();
KMETHOD QAbstractNetworkCache_clear(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractNetworkCache *  qp = RawPtr_to(QAbstractNetworkCache *, sfp[0]);
	if (qp) {
		qp->clear();
	}
	RETURNvoid_();
}


DummyQAbstractNetworkCache::DummyQAbstractNetworkCache()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQAbstractNetworkCache::~DummyQAbstractNetworkCache()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractNetworkCache::setSelf(kRawPtr *ptr)
{
	DummyQAbstractNetworkCache::self = ptr;
	DummyQObject::setSelf(ptr);
}

bool DummyQAbstractNetworkCache::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQObject::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAbstractNetworkCache::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractNetworkCache::event_map->bigin();
	if ((itr = DummyQAbstractNetworkCache::event_map->find(str)) == DummyQAbstractNetworkCache::event_map->end()) {
		bool ret = false;
		ret = DummyQObject::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAbstractNetworkCache::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractNetworkCache::slot_map->bigin();
	if ((itr = DummyQAbstractNetworkCache::slot_map->find(str)) == DummyQAbstractNetworkCache::slot_map->end()) {
		bool ret = false;
		ret = DummyQObject::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQAbstractNetworkCache::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractNetworkCache::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQObject::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAbstractNetworkCache::connection(QObject *o)
{
	QAbstractNetworkCache *p = dynamic_cast<QAbstractNetworkCache*>(o);
	if (p != NULL) {
	}
	DummyQObject::connection(o);
}

KQAbstractNetworkCache::~KQAbstractNetworkCache()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractNetworkCache_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractNetworkCache *qp = RawPtr_to(KQAbstractNetworkCache *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractNetworkCache]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractNetworkCache]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractNetworkCache_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractNetworkCache *qp = RawPtr_to(KQAbstractNetworkCache *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractNetworkCache]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractNetworkCache]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractNetworkCache_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractNetworkCache *qp = (KQAbstractNetworkCache *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractNetworkCache*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractNetworkCache_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractNetworkCache *qp = (KQAbstractNetworkCache *)p->rawptr;
		KQAbstractNetworkCache *qp = static_cast<KQAbstractNetworkCache*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractNetworkCache_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractNetworkCache::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAbstractNetworkCache::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAbstractNetworkCache::event(event);
		return false;
	}
//	QAbstractNetworkCache::event(event);
	return true;
}



DEFAPI(void) defQAbstractNetworkCache(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractNetworkCache";
	cdef->free = QAbstractNetworkCache_free;
	cdef->reftrace = QAbstractNetworkCache_reftrace;
	cdef->compareTo = QAbstractNetworkCache_compareTo;
}


//
//@Virtual int QAbstractPrintDialog.exec();
KMETHOD QAbstractPrintDialog_exec(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractPrintDialog *  qp = RawPtr_to(QAbstractPrintDialog *, sfp[0]);
	if (qp) {
		int ret_v = qp->exec();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAbstractPrintDialog.fromPage();
KMETHOD QAbstractPrintDialog_fromPage(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractPrintDialog *  qp = RawPtr_to(QAbstractPrintDialog *, sfp[0]);
	if (qp) {
		int ret_v = qp->fromPage();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAbstractPrintDialog.maxPage();
KMETHOD QAbstractPrintDialog_maxPage(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractPrintDialog *  qp = RawPtr_to(QAbstractPrintDialog *, sfp[0]);
	if (qp) {
		int ret_v = qp->maxPage();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAbstractPrintDialog.minPage();
KMETHOD QAbstractPrintDialog_minPage(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractPrintDialog *  qp = RawPtr_to(QAbstractPrintDialog *, sfp[0]);
	if (qp) {
		int ret_v = qp->minPage();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAbstractPrintDialog.getPrintRange();
KMETHOD QAbstractPrintDialog_getPrintRange(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractPrintDialog *  qp = RawPtr_to(QAbstractPrintDialog *, sfp[0]);
	if (qp) {
		QAbstractPrintDialog::PrintRange ret_v = qp->printRange();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual QPrinter QAbstractPrintDialog.printer();
KMETHOD QAbstractPrintDialog_printer(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractPrintDialog *  qp = RawPtr_to(QAbstractPrintDialog *, sfp[0]);
	if (qp) {
		QPrinter* ret_v = qp->printer();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QPrinter*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QAbstractPrintDialog.setFromTo(int from_, int to_);
KMETHOD QAbstractPrintDialog_setFromTo(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractPrintDialog *  qp = RawPtr_to(QAbstractPrintDialog *, sfp[0]);
	if (qp) {
		int from = Int_to(int, sfp[1]);
		int to = Int_to(int, sfp[2]);
		qp->setFromTo(from, to);
	}
	RETURNvoid_();
}

//void QAbstractPrintDialog.setMinMax(int min, int max);
KMETHOD QAbstractPrintDialog_setMinMax(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractPrintDialog *  qp = RawPtr_to(QAbstractPrintDialog *, sfp[0]);
	if (qp) {
		int min = Int_to(int, sfp[1]);
		int max = Int_to(int, sfp[2]);
		qp->setMinMax(min, max);
	}
	RETURNvoid_();
}

//void QAbstractPrintDialog.setOptionTabs(Array<QWidget> tabs);
KMETHOD QAbstractPrintDialog_setOptionTabs(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractPrintDialog *  qp = RawPtr_to(QAbstractPrintDialog *, sfp[0]);
	if (qp) {
		kArray *a = sfp[1].a;
		int asize = knh_Array_size(a);
		QList<QWidget*> tabs;
		for (int n = 0; n < asize; n++) {
			kRawPtr *p = (kRawPtr*)(a->list[n]);
			tabs.append((QWidget*)p->rawptr);
		}
		qp->setOptionTabs(tabs);
	}
	RETURNvoid_();
}

//void QAbstractPrintDialog.setPrintRange(int range);
KMETHOD QAbstractPrintDialog_setPrintRange(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractPrintDialog *  qp = RawPtr_to(QAbstractPrintDialog *, sfp[0]);
	if (qp) {
		QAbstractPrintDialog::PrintRange range = Int_to(QAbstractPrintDialog::PrintRange, sfp[1]);
		qp->setPrintRange(range);
	}
	RETURNvoid_();
}

//int QAbstractPrintDialog.toPage();
KMETHOD QAbstractPrintDialog_toPage(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractPrintDialog *  qp = RawPtr_to(QAbstractPrintDialog *, sfp[0]);
	if (qp) {
		int ret_v = qp->toPage();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}


DummyQAbstractPrintDialog::DummyQAbstractPrintDialog()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQAbstractPrintDialog::~DummyQAbstractPrintDialog()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractPrintDialog::setSelf(kRawPtr *ptr)
{
	DummyQAbstractPrintDialog::self = ptr;
	DummyQDialog::setSelf(ptr);
}

bool DummyQAbstractPrintDialog::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQDialog::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAbstractPrintDialog::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractPrintDialog::event_map->bigin();
	if ((itr = DummyQAbstractPrintDialog::event_map->find(str)) == DummyQAbstractPrintDialog::event_map->end()) {
		bool ret = false;
		ret = DummyQDialog::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAbstractPrintDialog::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractPrintDialog::slot_map->bigin();
	if ((itr = DummyQAbstractPrintDialog::slot_map->find(str)) == DummyQAbstractPrintDialog::slot_map->end()) {
		bool ret = false;
		ret = DummyQDialog::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQAbstractPrintDialog::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractPrintDialog::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQDialog::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAbstractPrintDialog::connection(QObject *o)
{
	QAbstractPrintDialog *p = dynamic_cast<QAbstractPrintDialog*>(o);
	if (p != NULL) {
	}
	DummyQDialog::connection(o);
}

KQAbstractPrintDialog::KQAbstractPrintDialog(QPrinter* printer, QWidget* parent) : QAbstractPrintDialog(printer, parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAbstractPrintDialog();
	dummy->connection((QObject*)this);
}

KQAbstractPrintDialog::~KQAbstractPrintDialog()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractPrintDialog_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractPrintDialog *qp = RawPtr_to(KQAbstractPrintDialog *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractPrintDialog]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractPrintDialog]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractPrintDialog_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractPrintDialog *qp = RawPtr_to(KQAbstractPrintDialog *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractPrintDialog]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractPrintDialog]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractPrintDialog_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractPrintDialog *qp = (KQAbstractPrintDialog *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractPrintDialog*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractPrintDialog_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractPrintDialog *qp = (KQAbstractPrintDialog *)p->rawptr;
		KQAbstractPrintDialog *qp = static_cast<KQAbstractPrintDialog*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractPrintDialog_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractPrintDialog::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAbstractPrintDialog::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAbstractPrintDialog::event(event);
		return false;
	}
//	QAbstractPrintDialog::event(event);
	return true;
}

static knh_IntData_t QAbstractPrintDialogConstInt[] = {
	{"None", QAbstractPrintDialog::None},
	{"PrintToFile", QAbstractPrintDialog::PrintToFile},
	{"PrintSelection", QAbstractPrintDialog::PrintSelection},
	{"PrintPageRange", QAbstractPrintDialog::PrintPageRange},
	{"PrintShowPageSize", QAbstractPrintDialog::PrintShowPageSize},
	{"PrintCollateCopies", QAbstractPrintDialog::PrintCollateCopies},
	{"PrintCurrentPage", QAbstractPrintDialog::PrintCurrentPage},
	{"DontUseSheet", QAbstractPrintDialog::DontUseSheet},
	{"AllPages", QAbstractPrintDialog::AllPages},
	{"Selection", QAbstractPrintDialog::Selection},
	{"PageRange", QAbstractPrintDialog::PageRange},
	{"CurrentPage", QAbstractPrintDialog::CurrentPage},
	{NULL, 0}
};

DEFAPI(void) constQAbstractPrintDialog(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QAbstractPrintDialogConstInt);
}


DEFAPI(void) defQAbstractPrintDialog(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractPrintDialog";
	cdef->free = QAbstractPrintDialog_free;
	cdef->reftrace = QAbstractPrintDialog_reftrace;
	cdef->compareTo = QAbstractPrintDialog_compareTo;
}

//## QAbstractPrintDialogPrintDialogOptions QAbstractPrintDialogPrintDialogOptions.new(int value);
KMETHOD QAbstractPrintDialogPrintDialogOptions_new(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractPrintDialog::PrintDialogOption i = Int_to(QAbstractPrintDialog::PrintDialogOption, sfp[1]);
	QAbstractPrintDialog::PrintDialogOptions *ret_v = new QAbstractPrintDialog::PrintDialogOptions(i);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	RETURN_(rptr);
}

//## QAbstractPrintDialogPrintDialogOptions QAbstractPrintDialogPrintDialogOptions.and(int mask);
KMETHOD QAbstractPrintDialogPrintDialogOptions_and(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractPrintDialog::PrintDialogOptions *qp = RawPtr_to(QAbstractPrintDialog::PrintDialogOptions*, sfp[0]);
	if (qp != NULL) {
		int i = Int_to(int, sfp[1]);
		QAbstractPrintDialog::PrintDialogOptions ret = ((*qp) & i);
		QAbstractPrintDialog::PrintDialogOptions *ret_ = new QAbstractPrintDialog::PrintDialogOptions(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractPrintDialogPrintDialogOptions QAbstractPrintDialogPrintDialogOptions.iand(QAbstractPrintDialog::QAbstractPrintDialogPrintDialogOptions other);
KMETHOD QAbstractPrintDialogPrintDialogOptions_iand(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractPrintDialog::PrintDialogOptions *qp = RawPtr_to(QAbstractPrintDialog::PrintDialogOptions*, sfp[0]);
	if (qp != NULL) {
		QAbstractPrintDialog::PrintDialogOptions *other = RawPtr_to(QAbstractPrintDialog::PrintDialogOptions *, sfp[1]);
		*qp = ((*qp) & (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractPrintDialogPrintDialogOptions QAbstractPrintDialogPrintDialogOptions.or(QAbstractPrintDialogPrintDialogOptions f);
KMETHOD QAbstractPrintDialogPrintDialogOptions_or(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractPrintDialog::PrintDialogOptions *qp = RawPtr_to(QAbstractPrintDialog::PrintDialogOptions*, sfp[0]);
	if (qp != NULL) {
		QAbstractPrintDialog::PrintDialogOptions *f = RawPtr_to(QAbstractPrintDialog::PrintDialogOptions*, sfp[1]);
		QAbstractPrintDialog::PrintDialogOptions ret = ((*qp) | (*f));
		QAbstractPrintDialog::PrintDialogOptions *ret_ = new QAbstractPrintDialog::PrintDialogOptions(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractPrintDialogPrintDialogOptions QAbstractPrintDialogPrintDialogOptions.ior(QAbstractPrintDialog::QAbstractPrintDialogPrintDialogOptions other);
KMETHOD QAbstractPrintDialogPrintDialogOptions_ior(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractPrintDialog::PrintDialogOptions *qp = RawPtr_to(QAbstractPrintDialog::PrintDialogOptions*, sfp[0]);
	if (qp != NULL) {
		QAbstractPrintDialog::PrintDialogOptions *other = RawPtr_to(QAbstractPrintDialog::PrintDialogOptions *, sfp[1]);
		*qp = ((*qp) | (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractPrintDialogPrintDialogOptions QAbstractPrintDialogPrintDialogOptions.xor(QAbstractPrintDialogPrintDialogOptions f);
KMETHOD QAbstractPrintDialogPrintDialogOptions_xor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractPrintDialog::PrintDialogOptions *qp = RawPtr_to(QAbstractPrintDialog::PrintDialogOptions*, sfp[0]);
	if (qp != NULL) {
		QAbstractPrintDialog::PrintDialogOptions *f = RawPtr_to(QAbstractPrintDialog::PrintDialogOptions*, sfp[1]);
		QAbstractPrintDialog::PrintDialogOptions ret = ((*qp) ^ (*f));
		QAbstractPrintDialog::PrintDialogOptions *ret_ = new QAbstractPrintDialog::PrintDialogOptions(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractPrintDialogPrintDialogOptions QAbstractPrintDialogPrintDialogOptions.ixor(QAbstractPrintDialog::QAbstractPrintDialogPrintDialogOptions other);
KMETHOD QAbstractPrintDialogPrintDialogOptions_ixor(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractPrintDialog::PrintDialogOptions *qp = RawPtr_to(QAbstractPrintDialog::PrintDialogOptions*, sfp[0]);
	if (qp != NULL) {
		QAbstractPrintDialog::PrintDialogOptions *other = RawPtr_to(QAbstractPrintDialog::PrintDialogOptions *, sfp[1]);
		*qp = ((*qp) ^ (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## boolean QAbstractPrintDialogPrintDialogOptions.testFlag(int flag);
KMETHOD QAbstractPrintDialogPrintDialogOptions_testFlag(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractPrintDialog::PrintDialogOptions *qp = RawPtr_to(QAbstractPrintDialog::PrintDialogOptions *, sfp[0]);
	if (qp != NULL) {
		QAbstractPrintDialog::PrintDialogOption flag = Int_to(QAbstractPrintDialog::PrintDialogOption, sfp[1]);
		bool ret = qp->testFlag(flag);
		RETURNb_(ret);
	} else {
		RETURNb_(false);
	}
}

//## int QAbstractPrintDialogPrintDialogOptions.value();
KMETHOD QAbstractPrintDialogPrintDialogOptions_value(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractPrintDialog::PrintDialogOptions *qp = RawPtr_to(QAbstractPrintDialog::PrintDialogOptions *, sfp[0]);
	if (qp != NULL) {
		int ret = int(*qp);
		RETURNi_(ret);
	} else {
		RETURNi_(0);
	}
}

static void QAbstractPrintDialogPrintDialogOptions_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (p->rawptr != NULL) {
		QAbstractPrintDialog::PrintDialogOptions *qp = (QAbstractPrintDialog::PrintDialogOptions *)p->rawptr;
		(void)qp;
		delete qp;
		p->rawptr = NULL;
	}
}

static void QAbstractPrintDialogPrintDialogOptions_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
	if (p->rawptr != NULL) {
		QAbstractPrintDialog::PrintDialogOptions *qp = (QAbstractPrintDialog::PrintDialogOptions *)p->rawptr;
		(void)qp;
	}
}

static int QAbstractPrintDialogPrintDialogOptions_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	if (p1->rawptr == NULL || p2->rawptr == NULL) {
		return 1;
	} else {
//		int v1 = int(*(QAbstractPrintDialog::PrintDialogOptions*)p1->rawptr);
//		int v2 = int(*(QAbstractPrintDialog::PrintDialogOptions*)p2->rawptr);
//		return (v1 == v2 ? 0 : 1);
		QAbstractPrintDialog::PrintDialogOptions v1 = *(QAbstractPrintDialog::PrintDialogOptions*)p1->rawptr;
		QAbstractPrintDialog::PrintDialogOptions v2 = *(QAbstractPrintDialog::PrintDialogOptions*)p2->rawptr;
//		return (v1 == v2 ? 0 : 1);
		return (v1 == v2 ? 0 : 1);

	}
}

DEFAPI(void) defQAbstractPrintDialogPrintDialogOptions(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractPrintDialogPrintDialogOptions";
	cdef->free = QAbstractPrintDialogPrintDialogOptions_free;
	cdef->reftrace = QAbstractPrintDialogPrintDialogOptions_reftrace;
	cdef->compareTo = QAbstractPrintDialogPrintDialogOptions_compareTo;
}

//@Virtual @Override QVariant QAbstractProxyModel.getData(QModelIndex proxyIndex, int role);
KMETHOD QAbstractProxyModel_getData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractProxyModel *  qp = RawPtr_to(QAbstractProxyModel *, sfp[0]);
	if (qp) {
		const QModelIndex  proxyIndex = *RawPtr_to(const QModelIndex *, sfp[1]);
		int role = Int_to(int, sfp[2]);
		QVariant ret_v = qp->data(proxyIndex, role);
		QVariant *ret_v_ = new QVariant(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override QtItemFlags QAbstractProxyModel.flags(QModelIndex index);
KMETHOD QAbstractProxyModel_flags(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractProxyModel *  qp = RawPtr_to(QAbstractProxyModel *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		Qt::ItemFlags ret_v = qp->flags(index);
		Qt::ItemFlags *ret_v_ = new Qt::ItemFlags(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override QVariant QAbstractProxyModel.getHeaderData(int section, int orientation, int role);
KMETHOD QAbstractProxyModel_getHeaderData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractProxyModel *  qp = RawPtr_to(QAbstractProxyModel *, sfp[0]);
	if (qp) {
		int section = Int_to(int, sfp[1]);
		Qt::Orientation orientation = Int_to(Qt::Orientation, sfp[2]);
		int role = Int_to(int, sfp[3]);
		QVariant ret_v = qp->headerData(section, orientation, role);
		QVariant *ret_v_ = new QVariant(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override void QAbstractProxyModel.revert();
KMETHOD QAbstractProxyModel_revert(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractProxyModel *  qp = RawPtr_to(QAbstractProxyModel *, sfp[0]);
	if (qp) {
		qp->revert();
	}
	RETURNvoid_();
}

//@Virtual @Override boolean QAbstractProxyModel.setData(QModelIndex index, QVariant value, int role);
KMETHOD QAbstractProxyModel_setData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractProxyModel *  qp = RawPtr_to(QAbstractProxyModel *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		const QVariant  value = *RawPtr_to(const QVariant *, sfp[2]);
		int role = Int_to(int, sfp[3]);
		bool ret_v = qp->setData(index, value, role);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override boolean QAbstractProxyModel.setHeaderData(int section, int orientation, QVariant value, int role);
KMETHOD QAbstractProxyModel_setHeaderData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractProxyModel *  qp = RawPtr_to(QAbstractProxyModel *, sfp[0]);
	if (qp) {
		int section = Int_to(int, sfp[1]);
		Qt::Orientation orientation = Int_to(Qt::Orientation, sfp[2]);
		const QVariant  value = *RawPtr_to(const QVariant *, sfp[3]);
		int role = Int_to(int, sfp[4]);
		bool ret_v = qp->setHeaderData(section, orientation, value, role);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override boolean QAbstractProxyModel.submit();
KMETHOD QAbstractProxyModel_submit(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractProxyModel *  qp = RawPtr_to(QAbstractProxyModel *, sfp[0]);
	if (qp) {
		bool ret_v = qp->submit();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//
//@Virtual QModelIndex QAbstractProxyModel.mapFromSource(QModelIndex sourceIndex);
KMETHOD QAbstractProxyModel_mapFromSource(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractProxyModel *  qp = RawPtr_to(QAbstractProxyModel *, sfp[0]);
	if (qp) {
		const QModelIndex  sourceIndex = *RawPtr_to(const QModelIndex *, sfp[1]);
		QModelIndex ret_v = qp->mapFromSource(sourceIndex);
		QModelIndex *ret_v_ = new QModelIndex(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual QItemSelection QAbstractProxyModel.mapSelectionFromSource(QItemSelection sourceSelection);
KMETHOD QAbstractProxyModel_mapSelectionFromSource(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractProxyModel *  qp = RawPtr_to(QAbstractProxyModel *, sfp[0]);
	if (qp) {
		const QItemSelection  sourceSelection = *RawPtr_to(const QItemSelection *, sfp[1]);
		QItemSelection ret_v = qp->mapSelectionFromSource(sourceSelection);
		QItemSelection *ret_v_ = new QItemSelection(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual QItemSelection QAbstractProxyModel.mapSelectionToSource(QItemSelection proxySelection);
KMETHOD QAbstractProxyModel_mapSelectionToSource(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractProxyModel *  qp = RawPtr_to(QAbstractProxyModel *, sfp[0]);
	if (qp) {
		const QItemSelection  proxySelection = *RawPtr_to(const QItemSelection *, sfp[1]);
		QItemSelection ret_v = qp->mapSelectionToSource(proxySelection);
		QItemSelection *ret_v_ = new QItemSelection(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual QModelIndex QAbstractProxyModel.mapToSource(QModelIndex proxyIndex);
KMETHOD QAbstractProxyModel_mapToSource(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractProxyModel *  qp = RawPtr_to(QAbstractProxyModel *, sfp[0]);
	if (qp) {
		const QModelIndex  proxyIndex = *RawPtr_to(const QModelIndex *, sfp[1]);
		QModelIndex ret_v = qp->mapToSource(proxyIndex);
		QModelIndex *ret_v_ = new QModelIndex(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual void QAbstractProxyModel.setSourceModel(QAbstractItemModel sourceModel);
KMETHOD QAbstractProxyModel_setSourceModel(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractProxyModel *  qp = RawPtr_to(QAbstractProxyModel *, sfp[0]);
	if (qp) {
		QAbstractItemModel*  sourceModel = RawPtr_to(QAbstractItemModel*, sfp[1]);
		qp->setSourceModel(sourceModel);
	}
	RETURNvoid_();
}

//QAbstractItemModel QAbstractProxyModel.getSourceModel();
KMETHOD QAbstractProxyModel_getSourceModel(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractProxyModel *  qp = RawPtr_to(QAbstractProxyModel *, sfp[0]);
	if (qp) {
		QAbstractItemModel* ret_v = qp->sourceModel();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractItemModel*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}


DummyQAbstractProxyModel::DummyQAbstractProxyModel()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQAbstractProxyModel::~DummyQAbstractProxyModel()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractProxyModel::setSelf(kRawPtr *ptr)
{
	DummyQAbstractProxyModel::self = ptr;
	DummyQAbstractItemModel::setSelf(ptr);
}

bool DummyQAbstractProxyModel::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQAbstractItemModel::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAbstractProxyModel::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractProxyModel::event_map->bigin();
	if ((itr = DummyQAbstractProxyModel::event_map->find(str)) == DummyQAbstractProxyModel::event_map->end()) {
		bool ret = false;
		ret = DummyQAbstractItemModel::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAbstractProxyModel::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractProxyModel::slot_map->bigin();
	if ((itr = DummyQAbstractProxyModel::slot_map->find(str)) == DummyQAbstractProxyModel::slot_map->end()) {
		bool ret = false;
		ret = DummyQAbstractItemModel::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQAbstractProxyModel::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractProxyModel::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQAbstractItemModel::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAbstractProxyModel::connection(QObject *o)
{
	QAbstractProxyModel *p = dynamic_cast<QAbstractProxyModel*>(o);
	if (p != NULL) {
	}
	DummyQAbstractItemModel::connection(o);
}

KQAbstractProxyModel::KQAbstractProxyModel(QObject* parent) : QAbstractProxyModel(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAbstractProxyModel();
	dummy->connection((QObject*)this);
}

KQAbstractProxyModel::~KQAbstractProxyModel()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractProxyModel_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractProxyModel *qp = RawPtr_to(KQAbstractProxyModel *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractProxyModel]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractProxyModel]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractProxyModel_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractProxyModel *qp = RawPtr_to(KQAbstractProxyModel *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractProxyModel]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractProxyModel]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractProxyModel_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractProxyModel *qp = (KQAbstractProxyModel *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractProxyModel*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractProxyModel_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractProxyModel *qp = (KQAbstractProxyModel *)p->rawptr;
		KQAbstractProxyModel *qp = static_cast<KQAbstractProxyModel*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractProxyModel_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractProxyModel::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAbstractProxyModel::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAbstractProxyModel::event(event);
		return false;
	}
//	QAbstractProxyModel::event(event);
	return true;
}



DEFAPI(void) defQAbstractProxyModel(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractProxyModel";
	cdef->free = QAbstractProxyModel_free;
	cdef->reftrace = QAbstractProxyModel_reftrace;
	cdef->compareTo = QAbstractProxyModel_compareTo;
}


//@Virtual @Override QSize QAbstractScrollArea.minimumSizeHint();
KMETHOD QAbstractScrollArea_minimumSizeHint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractScrollArea *  qp = RawPtr_to(QAbstractScrollArea *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->minimumSizeHint();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override QSize QAbstractScrollArea.sizeHint();
KMETHOD QAbstractScrollArea_sizeHint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractScrollArea *  qp = RawPtr_to(QAbstractScrollArea *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->sizeHint();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//
//void QAbstractScrollArea.addScrollBarWidget(QWidget widget, QtAlignment alignment);
KMETHOD QAbstractScrollArea_addScrollBarWidget(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractScrollArea *  qp = RawPtr_to(QAbstractScrollArea *, sfp[0]);
	if (qp) {
		QWidget*  widget = RawPtr_to(QWidget*, sfp[1]);
		initFlag(alignment, Qt::Alignment, sfp[2]);
		qp->addScrollBarWidget(widget, alignment);
	}
	RETURNvoid_();
}

//QWidget QAbstractScrollArea.getCornerWidget();
KMETHOD QAbstractScrollArea_getCornerWidget(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractScrollArea *  qp = RawPtr_to(QAbstractScrollArea *, sfp[0]);
	if (qp) {
		QWidget* ret_v = qp->cornerWidget();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QWidget*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QScrollBar QAbstractScrollArea.getHorizontalScrollBar();
KMETHOD QAbstractScrollArea_getHorizontalScrollBar(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractScrollArea *  qp = RawPtr_to(QAbstractScrollArea *, sfp[0]);
	if (qp) {
		QScrollBar* ret_v = qp->horizontalScrollBar();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QScrollBar*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QAbstractScrollArea.getHorizontalScrollBarPolicy();
KMETHOD QAbstractScrollArea_getHorizontalScrollBarPolicy(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractScrollArea *  qp = RawPtr_to(QAbstractScrollArea *, sfp[0]);
	if (qp) {
		Qt::ScrollBarPolicy ret_v = qp->horizontalScrollBarPolicy();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QSize QAbstractScrollArea.maximumViewportSize();
KMETHOD QAbstractScrollArea_maximumViewportSize(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractScrollArea *  qp = RawPtr_to(QAbstractScrollArea *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->maximumViewportSize();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QWidgetList QAbstractScrollArea.scrollBarWidgets(QtAlignment alignment);
KMETHOD QAbstractScrollArea_scrollBarWidgets(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractScrollArea *  qp = RawPtr_to(QAbstractScrollArea *, sfp[0]);
	if (qp) {
		initFlag(alignment, Qt::Alignment, sfp[1]);
		QWidgetList ret_v = qp->scrollBarWidgets(alignment);
		QWidgetList *ret_v_ = new QWidgetList(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QAbstractScrollArea.setCornerWidget(QWidget widget);
KMETHOD QAbstractScrollArea_setCornerWidget(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractScrollArea *  qp = RawPtr_to(QAbstractScrollArea *, sfp[0]);
	if (qp) {
		QWidget*  widget = RawPtr_to(QWidget*, sfp[1]);
		qp->setCornerWidget(widget);
	}
	RETURNvoid_();
}

//void QAbstractScrollArea.setHorizontalScrollBar(QScrollBar scrollBar);
KMETHOD QAbstractScrollArea_setHorizontalScrollBar(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractScrollArea *  qp = RawPtr_to(QAbstractScrollArea *, sfp[0]);
	if (qp) {
		QScrollBar*  scrollBar = RawPtr_to(QScrollBar*, sfp[1]);
		qp->setHorizontalScrollBar(scrollBar);
	}
	RETURNvoid_();
}

//void QAbstractScrollArea.setHorizontalScrollBarPolicy(int arg0);
KMETHOD QAbstractScrollArea_setHorizontalScrollBarPolicy(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractScrollArea *  qp = RawPtr_to(QAbstractScrollArea *, sfp[0]);
	if (qp) {
		Qt::ScrollBarPolicy arg0 = Int_to(Qt::ScrollBarPolicy, sfp[1]);
		qp->setHorizontalScrollBarPolicy(arg0);
	}
	RETURNvoid_();
}

//void QAbstractScrollArea.setVerticalScrollBar(QScrollBar scrollBar);
KMETHOD QAbstractScrollArea_setVerticalScrollBar(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractScrollArea *  qp = RawPtr_to(QAbstractScrollArea *, sfp[0]);
	if (qp) {
		QScrollBar*  scrollBar = RawPtr_to(QScrollBar*, sfp[1]);
		qp->setVerticalScrollBar(scrollBar);
	}
	RETURNvoid_();
}

//void QAbstractScrollArea.setVerticalScrollBarPolicy(int arg0);
KMETHOD QAbstractScrollArea_setVerticalScrollBarPolicy(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractScrollArea *  qp = RawPtr_to(QAbstractScrollArea *, sfp[0]);
	if (qp) {
		Qt::ScrollBarPolicy arg0 = Int_to(Qt::ScrollBarPolicy, sfp[1]);
		qp->setVerticalScrollBarPolicy(arg0);
	}
	RETURNvoid_();
}

//void QAbstractScrollArea.setViewport(QWidget widget);
KMETHOD QAbstractScrollArea_setViewport(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractScrollArea *  qp = RawPtr_to(QAbstractScrollArea *, sfp[0]);
	if (qp) {
		QWidget*  widget = RawPtr_to(QWidget*, sfp[1]);
		qp->setViewport(widget);
	}
	RETURNvoid_();
}

//QScrollBar QAbstractScrollArea.getVerticalScrollBar();
KMETHOD QAbstractScrollArea_getVerticalScrollBar(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractScrollArea *  qp = RawPtr_to(QAbstractScrollArea *, sfp[0]);
	if (qp) {
		QScrollBar* ret_v = qp->verticalScrollBar();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QScrollBar*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QAbstractScrollArea.getVerticalScrollBarPolicy();
KMETHOD QAbstractScrollArea_getVerticalScrollBarPolicy(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractScrollArea *  qp = RawPtr_to(QAbstractScrollArea *, sfp[0]);
	if (qp) {
		Qt::ScrollBarPolicy ret_v = qp->verticalScrollBarPolicy();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QWidget QAbstractScrollArea.getViewport();
KMETHOD QAbstractScrollArea_getViewport(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractScrollArea *  qp = RawPtr_to(QAbstractScrollArea *, sfp[0]);
	if (qp) {
		QWidget* ret_v = qp->viewport();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QWidget*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}


DummyQAbstractScrollArea::DummyQAbstractScrollArea()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	viewportEventPtr = new_empty_QRawPtr(lctx, QEvent);
	viewport_event_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	event_map->insert(map<string, kFunc *>::value_type("viewport-event", NULL));
}
DummyQAbstractScrollArea::~DummyQAbstractScrollArea()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractScrollArea::setSelf(kRawPtr *ptr)
{
	DummyQAbstractScrollArea::self = ptr;
	DummyQFrame::setSelf(ptr);
}

bool DummyQAbstractScrollArea::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
		ret = viewportEventDummy(dynamic_cast<QEvent*>(event));
		break;
	default:
		ret = DummyQFrame::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAbstractScrollArea::viewportEventDummy(QEvent* event)
{
	if (viewport_event_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		viewportEventPtr->rawptr = event;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, (UPCAST(viewportEventPtr)));
		knh_Func_invoke(lctx, viewport_event_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractScrollArea::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractScrollArea::event_map->bigin();
	if ((itr = DummyQAbstractScrollArea::event_map->find(str)) == DummyQAbstractScrollArea::event_map->end()) {
		bool ret = false;
		ret = DummyQFrame::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		viewport_event_func = (*event_map)["viewport-event"];
		return true;
	}
}

bool DummyQAbstractScrollArea::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractScrollArea::slot_map->bigin();
	if ((itr = DummyQAbstractScrollArea::slot_map->find(str)) == DummyQAbstractScrollArea::slot_map->end()) {
		bool ret = false;
		ret = DummyQFrame::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQAbstractScrollArea::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractScrollArea::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 3;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, viewport_event_func);
	KNH_ADDNNREF(ctx, viewportEventPtr);

	KNH_SIZEREF(ctx);

	tail_ = DummyQFrame::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAbstractScrollArea::connection(QObject *o)
{
	QAbstractScrollArea *p = dynamic_cast<QAbstractScrollArea*>(o);
	if (p != NULL) {
	}
	DummyQFrame::connection(o);
}

KQAbstractScrollArea::KQAbstractScrollArea(QWidget* parent) : QAbstractScrollArea(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAbstractScrollArea();
	dummy->connection((QObject*)this);
}

KQAbstractScrollArea::~KQAbstractScrollArea()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractScrollArea_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractScrollArea *qp = RawPtr_to(KQAbstractScrollArea *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractScrollArea]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractScrollArea]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractScrollArea_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractScrollArea *qp = RawPtr_to(KQAbstractScrollArea *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractScrollArea]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractScrollArea]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractScrollArea_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractScrollArea *qp = (KQAbstractScrollArea *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractScrollArea*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractScrollArea_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractScrollArea *qp = (KQAbstractScrollArea *)p->rawptr;
		KQAbstractScrollArea *qp = static_cast<KQAbstractScrollArea*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractScrollArea_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractScrollArea::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAbstractScrollArea::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAbstractScrollArea::event(event);
		return false;
	}
//	QAbstractScrollArea::event(event);
	return true;
}



DEFAPI(void) defQAbstractScrollArea(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractScrollArea";
	cdef->free = QAbstractScrollArea_free;
	cdef->reftrace = QAbstractScrollArea_reftrace;
	cdef->compareTo = QAbstractScrollArea_compareTo;
}


//
//boolean QAbstractSlider.hasTracking();
KMETHOD QAbstractSlider_hasTracking(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		bool ret_v = qp->hasTracking();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAbstractSlider.getInvertedAppearance();
KMETHOD QAbstractSlider_getInvertedAppearance(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		bool ret_v = qp->invertedAppearance();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAbstractSlider.getInvertedControls();
KMETHOD QAbstractSlider_getInvertedControls(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		bool ret_v = qp->invertedControls();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAbstractSlider.isSliderDown();
KMETHOD QAbstractSlider_isSliderDown(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isSliderDown();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//int QAbstractSlider.getMaximum();
KMETHOD QAbstractSlider_getMaximum(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		int ret_v = qp->maximum();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAbstractSlider.getMinimum();
KMETHOD QAbstractSlider_getMinimum(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		int ret_v = qp->minimum();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAbstractSlider.getOrientation();
KMETHOD QAbstractSlider_getOrientation(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		Qt::Orientation ret_v = qp->orientation();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAbstractSlider.getPageStep();
KMETHOD QAbstractSlider_getPageStep(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		int ret_v = qp->pageStep();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QAbstractSlider.setInvertedAppearance(boolean arg0);
KMETHOD QAbstractSlider_setInvertedAppearance(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setInvertedAppearance(arg0);
	}
	RETURNvoid_();
}

//void QAbstractSlider.setInvertedControls(boolean arg0);
KMETHOD QAbstractSlider_setInvertedControls(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setInvertedControls(arg0);
	}
	RETURNvoid_();
}

//void QAbstractSlider.setMaximum(int arg0);
KMETHOD QAbstractSlider_setMaximum(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		int arg0 = Int_to(int, sfp[1]);
		qp->setMaximum(arg0);
	}
	RETURNvoid_();
}

//void QAbstractSlider.setMinimum(int arg0);
KMETHOD QAbstractSlider_setMinimum(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		int arg0 = Int_to(int, sfp[1]);
		qp->setMinimum(arg0);
	}
	RETURNvoid_();
}

//void QAbstractSlider.setPageStep(int arg0);
KMETHOD QAbstractSlider_setPageStep(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		int arg0 = Int_to(int, sfp[1]);
		qp->setPageStep(arg0);
	}
	RETURNvoid_();
}

//void QAbstractSlider.setRange(int min, int max);
KMETHOD QAbstractSlider_setRange(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		int min = Int_to(int, sfp[1]);
		int max = Int_to(int, sfp[2]);
		qp->setRange(min, max);
	}
	RETURNvoid_();
}

//void QAbstractSlider.setSingleStep(int arg0);
KMETHOD QAbstractSlider_setSingleStep(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		int arg0 = Int_to(int, sfp[1]);
		qp->setSingleStep(arg0);
	}
	RETURNvoid_();
}

//void QAbstractSlider.setSliderDown(boolean arg0);
KMETHOD QAbstractSlider_setSliderDown(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setSliderDown(arg0);
	}
	RETURNvoid_();
}

//void QAbstractSlider.setSliderPosition(int arg0);
KMETHOD QAbstractSlider_setSliderPosition(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		int arg0 = Int_to(int, sfp[1]);
		qp->setSliderPosition(arg0);
	}
	RETURNvoid_();
}

//void QAbstractSlider.setTracking(boolean enable);
KMETHOD QAbstractSlider_setTracking(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		bool enable = Boolean_to(bool, sfp[1]);
		qp->setTracking(enable);
	}
	RETURNvoid_();
}

//int QAbstractSlider.getSingleStep();
KMETHOD QAbstractSlider_getSingleStep(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		int ret_v = qp->singleStep();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAbstractSlider.getSliderPosition();
KMETHOD QAbstractSlider_getSliderPosition(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		int ret_v = qp->sliderPosition();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QAbstractSlider.triggerAction(int action);
KMETHOD QAbstractSlider_triggerAction(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		QAbstractSlider::SliderAction action = Int_to(QAbstractSlider::SliderAction, sfp[1]);
		qp->triggerAction(action);
	}
	RETURNvoid_();
}

//int QAbstractSlider.getValue();
KMETHOD QAbstractSlider_getValue(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		int ret_v = qp->value();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QAbstractSlider.setOrientation(int arg0);
KMETHOD QAbstractSlider_setOrientation(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		Qt::Orientation arg0 = Int_to(Qt::Orientation, sfp[1]);
		qp->setOrientation(arg0);
	}
	RETURNvoid_();
}

//void QAbstractSlider.setValue(int arg0);
KMETHOD QAbstractSlider_setValue(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSlider *  qp = RawPtr_to(QAbstractSlider *, sfp[0]);
	if (qp) {
		int arg0 = Int_to(int, sfp[1]);
		qp->setValue(arg0);
	}
	RETURNvoid_();
}


DummyQAbstractSlider::DummyQAbstractSlider()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	action_triggered_func = NULL;
	range_changed_func = NULL;
	slider_moved_func = NULL;
	slider_pressed_func = NULL;
	slider_released_func = NULL;
	value_changed_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("action-triggered", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("range-changed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("slider-moved", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("slider-pressed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("slider-released", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("value-changed", NULL));
}
DummyQAbstractSlider::~DummyQAbstractSlider()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractSlider::setSelf(kRawPtr *ptr)
{
	DummyQAbstractSlider::self = ptr;
	DummyQWidget::setSelf(ptr);
}

bool DummyQAbstractSlider::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQWidget::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAbstractSlider::actionTriggeredSlot(int action)
{
	if (action_triggered_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].ivalue = action;
		knh_Func_invoke(lctx, action_triggered_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractSlider::rangeChangedSlot(int min, int max)
{
	if (range_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].ivalue = min;
		lsfp[K_CALLDELTA+3].ivalue = max;
		knh_Func_invoke(lctx, range_changed_func, lsfp, 3);
		return true;
	}
	return false;
}

bool DummyQAbstractSlider::sliderMovedSlot(int value)
{
	if (slider_moved_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].ivalue = value;
		knh_Func_invoke(lctx, slider_moved_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractSlider::sliderPressedSlot()
{
	if (slider_pressed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, slider_pressed_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAbstractSlider::sliderReleasedSlot()
{
	if (slider_released_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, slider_released_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAbstractSlider::valueChangedSlot(int value)
{
	if (value_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].ivalue = value;
		knh_Func_invoke(lctx, value_changed_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractSlider::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractSlider::event_map->bigin();
	if ((itr = DummyQAbstractSlider::event_map->find(str)) == DummyQAbstractSlider::event_map->end()) {
		bool ret = false;
		ret = DummyQWidget::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAbstractSlider::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractSlider::slot_map->bigin();
	if ((itr = DummyQAbstractSlider::slot_map->find(str)) == DummyQAbstractSlider::slot_map->end()) {
		bool ret = false;
		ret = DummyQWidget::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		action_triggered_func = (*slot_map)["action-triggered"];
		range_changed_func = (*slot_map)["range-changed"];
		slider_moved_func = (*slot_map)["slider-moved"];
		slider_pressed_func = (*slot_map)["slider-pressed"];
		slider_released_func = (*slot_map)["slider-released"];
		value_changed_func = (*slot_map)["value-changed"];
		return true;
	}
}

kObject** DummyQAbstractSlider::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractSlider::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 7;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, action_triggered_func);
	KNH_ADDNNREF(ctx, range_changed_func);
	KNH_ADDNNREF(ctx, slider_moved_func);
	KNH_ADDNNREF(ctx, slider_pressed_func);
	KNH_ADDNNREF(ctx, slider_released_func);
	KNH_ADDNNREF(ctx, value_changed_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQWidget::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAbstractSlider::connection(QObject *o)
{
	QAbstractSlider *p = dynamic_cast<QAbstractSlider*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(actionTriggered(int)), this, SLOT(actionTriggeredSlot(int)));
		connect(p, SIGNAL(rangeChanged(int, int)), this, SLOT(rangeChangedSlot(int, int)));
		connect(p, SIGNAL(sliderMoved(int)), this, SLOT(sliderMovedSlot(int)));
		connect(p, SIGNAL(sliderPressed()), this, SLOT(sliderPressedSlot()));
		connect(p, SIGNAL(sliderReleased()), this, SLOT(sliderReleasedSlot()));
		connect(p, SIGNAL(valueChanged(int)), this, SLOT(valueChangedSlot(int)));
	}
	DummyQWidget::connection(o);
}

KQAbstractSlider::KQAbstractSlider(QWidget* parent) : QAbstractSlider(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAbstractSlider();
	dummy->connection((QObject*)this);
}

KQAbstractSlider::~KQAbstractSlider()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractSlider_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractSlider *qp = RawPtr_to(KQAbstractSlider *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractSlider]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractSlider]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractSlider_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractSlider *qp = RawPtr_to(KQAbstractSlider *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractSlider]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractSlider]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractSlider_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractSlider *qp = (KQAbstractSlider *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractSlider*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractSlider_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractSlider *qp = (KQAbstractSlider *)p->rawptr;
		KQAbstractSlider *qp = static_cast<KQAbstractSlider*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractSlider_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractSlider::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAbstractSlider::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAbstractSlider::event(event);
		return false;
	}
//	QAbstractSlider::event(event);
	return true;
}

static knh_IntData_t QAbstractSliderConstInt[] = {
	{"SliderNoAction", QAbstractSlider::SliderNoAction},
	{"SliderSingleStepAdd", QAbstractSlider::SliderSingleStepAdd},
	{"SliderSingleStepSub", QAbstractSlider::SliderSingleStepSub},
	{"SliderPageStepAdd", QAbstractSlider::SliderPageStepAdd},
	{"SliderPageStepSub", QAbstractSlider::SliderPageStepSub},
	{"SliderToMinimum", QAbstractSlider::SliderToMinimum},
	{"SliderToMaximum", QAbstractSlider::SliderToMaximum},
	{"SliderMove", QAbstractSlider::SliderMove},
	{NULL, 0}
};

DEFAPI(void) constQAbstractSlider(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QAbstractSliderConstInt);
}


DEFAPI(void) defQAbstractSlider(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractSlider";
	cdef->free = QAbstractSlider_free;
	cdef->reftrace = QAbstractSlider_reftrace;
	cdef->compareTo = QAbstractSlider_compareTo;
}


//@Virtual @Override boolean QAbstractSocket.atEnd();
KMETHOD QAbstractSocket_atEnd(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		bool ret_v = qp->atEnd();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override int QAbstractSocket.bytesAvailable();
KMETHOD QAbstractSocket_bytesAvailable(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		qint64 ret_v = qp->bytesAvailable();
		qint64 *ret_v_ = new qint64(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override int QAbstractSocket.bytesToWrite();
KMETHOD QAbstractSocket_bytesToWrite(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		qint64 ret_v = qp->bytesToWrite();
		qint64 *ret_v_ = new qint64(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override boolean QAbstractSocket.canReadLine();
KMETHOD QAbstractSocket_canReadLine(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		bool ret_v = qp->canReadLine();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override void QAbstractSocket.close();
KMETHOD QAbstractSocket_close(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		qp->close();
	}
	RETURNvoid_();
}

//@Virtual @Override boolean QAbstractSocket.isSequential();
KMETHOD QAbstractSocket_isSequential(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isSequential();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override boolean QAbstractSocket.waitForBytesWritten(int msecs);
KMETHOD QAbstractSocket_waitForBytesWritten(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		int msecs = Int_to(int, sfp[1]);
		bool ret_v = qp->waitForBytesWritten(msecs);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override boolean QAbstractSocket.waitForReadyRead(int msecs);
KMETHOD QAbstractSocket_waitForReadyRead(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		int msecs = Int_to(int, sfp[1]);
		bool ret_v = qp->waitForReadyRead(msecs);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//
//void QAbstractSocket.abort();
KMETHOD QAbstractSocket_abort(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		qp->abort();
	}
	RETURNvoid_();
}

//void QAbstractSocket.connectToHost(String hostName, int port, QIODeviceOpenMode openMode);
KMETHOD QAbstractSocket_connectToHost(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		const QString hostName = String_to(const QString, sfp[1]);
		quint16 port = Int_to(quint16, sfp[2]);
		initFlag(openMode, QIODevice::OpenMode, sfp[3]);
		qp->connectToHost(hostName, port, openMode);
	}
	RETURNvoid_();
}

/*
//void QAbstractSocket.connectToHost(QHostAddress address, int port, QIODeviceOpenMode openMode);
KMETHOD QAbstractSocket_connectToHost(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		const QHostAddress  address = *RawPtr_to(const QHostAddress *, sfp[1]);
		quint16 port = Int_to(quint16, sfp[2]);
		initFlag(openMode, QIODevice::OpenMode, sfp[3]);
		qp->connectToHost(address, port, openMode);
	}
	RETURNvoid_();
}
*/
//void QAbstractSocket.disconnectFromHost();
KMETHOD QAbstractSocket_disconnectFromHost(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		qp->disconnectFromHost();
	}
	RETURNvoid_();
}

//int QAbstractSocket.error();
KMETHOD QAbstractSocket_error(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		QAbstractSocket::SocketError ret_v = qp->error();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//boolean QAbstractSocket.flush();
KMETHOD QAbstractSocket_flush(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		bool ret_v = qp->flush();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//QHostAddress QAbstractSocket.localAddress();
KMETHOD QAbstractSocket_localAddress(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		QHostAddress ret_v = qp->localAddress();
		QHostAddress *ret_v_ = new QHostAddress(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QAbstractSocket.localPort();
KMETHOD QAbstractSocket_localPort(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		quint16 ret_v = qp->localPort();
		quint16 *ret_v_ = new quint16(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QHostAddress QAbstractSocket.peerAddress();
KMETHOD QAbstractSocket_peerAddress(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		QHostAddress ret_v = qp->peerAddress();
		QHostAddress *ret_v_ = new QHostAddress(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QAbstractSocket.peerName();
KMETHOD QAbstractSocket_peerName(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		QString ret_v = qp->peerName();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QAbstractSocket.peerPort();
KMETHOD QAbstractSocket_peerPort(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		quint16 ret_v = qp->peerPort();
		quint16 *ret_v_ = new quint16(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QNetworkProxy QAbstractSocket.getProxy();
KMETHOD QAbstractSocket_getProxy(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		QNetworkProxy ret_v = qp->proxy();
		QNetworkProxy *ret_v_ = new QNetworkProxy(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QAbstractSocket.getReadBufferSize();
KMETHOD QAbstractSocket_getReadBufferSize(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		qint64 ret_v = qp->readBufferSize();
		qint64 *ret_v_ = new qint64(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QAbstractSocket.setProxy(QNetworkProxy networkProxy);
KMETHOD QAbstractSocket_setProxy(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		const QNetworkProxy  networkProxy = *RawPtr_to(const QNetworkProxy *, sfp[1]);
		qp->setProxy(networkProxy);
	}
	RETURNvoid_();
}

//void QAbstractSocket.setReadBufferSize(int size);
KMETHOD QAbstractSocket_setReadBufferSize(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		qint64 size = Int_to(qint64, sfp[1]);
		qp->setReadBufferSize(size);
	}
	RETURNvoid_();
}

//boolean QAbstractSocket.setSocketDescriptor(int socketDescriptor, int socketState, QIODeviceOpenMode openMode);
KMETHOD QAbstractSocket_setSocketDescriptor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		int socketDescriptor = Int_to(int, sfp[1]);
		QAbstractSocket::SocketState socketState = Int_to(QAbstractSocket::SocketState, sfp[2]);
		initFlag(openMode, QIODevice::OpenMode, sfp[3]);
		bool ret_v = qp->setSocketDescriptor(socketDescriptor, socketState, openMode);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QAbstractSocket.setSocketOption(int option, QVariant value);
KMETHOD QAbstractSocket_setSocketOption(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		QAbstractSocket::SocketOption option = Int_to(QAbstractSocket::SocketOption, sfp[1]);
		const QVariant  value = *RawPtr_to(const QVariant *, sfp[2]);
		qp->setSocketOption(option, value);
	}
	RETURNvoid_();
}

//int QAbstractSocket.getSocketDescriptor();
KMETHOD QAbstractSocket_getSocketDescriptor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		int ret_v = qp->socketDescriptor();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QVariant QAbstractSocket.getSocketOption(int option);
KMETHOD QAbstractSocket_getSocketOption(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		QAbstractSocket::SocketOption option = Int_to(QAbstractSocket::SocketOption, sfp[1]);
		QVariant ret_v = qp->socketOption(option);
		QVariant *ret_v_ = new QVariant(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QAbstractSocket.socketType();
KMETHOD QAbstractSocket_socketType(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		QAbstractSocket::SocketType ret_v = qp->socketType();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAbstractSocket.state();
KMETHOD QAbstractSocket_state(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		QAbstractSocket::SocketState ret_v = qp->state();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//boolean QAbstractSocket.waitForConnected(int msecs);
KMETHOD QAbstractSocket_waitForConnected(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		int msecs = Int_to(int, sfp[1]);
		bool ret_v = qp->waitForConnected(msecs);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAbstractSocket.waitForDisconnected(int msecs);
KMETHOD QAbstractSocket_waitForDisconnected(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSocket *  qp = RawPtr_to(QAbstractSocket *, sfp[0]);
	if (qp) {
		int msecs = Int_to(int, sfp[1]);
		bool ret_v = qp->waitForDisconnected(msecs);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}


DummyQAbstractSocket::DummyQAbstractSocket()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	connected_func = NULL;
	disconnected_func = NULL;
	error_func = NULL;
	host_found_func = NULL;
	proxy_authentication_required_func = NULL;
	state_changed_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("connected", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("disconnected", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("error", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("host-found", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("proxy-authentication-required", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("state-changed", NULL));
}
DummyQAbstractSocket::~DummyQAbstractSocket()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractSocket::setSelf(kRawPtr *ptr)
{
	DummyQAbstractSocket::self = ptr;
	DummyQIODevice::setSelf(ptr);
}

bool DummyQAbstractSocket::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQIODevice::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAbstractSocket::connectedSlot()
{
	if (connected_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, connected_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAbstractSocket::disconnectedSlot()
{
	if (disconnected_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, disconnected_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAbstractSocket::errorSlot(QAbstractSocket::SocketError socketError)
{
	if (error_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].ivalue = socketError;
		knh_Func_invoke(lctx, error_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractSocket::hostFoundSlot()
{
	if (host_found_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, host_found_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAbstractSocket::proxyAuthenticationRequiredSlot(const QNetworkProxy proxy, QAuthenticator* authenticator)
{
	if (proxy_authentication_required_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QNetworkProxy, proxy);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		kRawPtr *p2 = new_QRawPtr(lctx, QAuthenticator, authenticator);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+3].o, UPCAST(p2));
		knh_Func_invoke(lctx, proxy_authentication_required_func, lsfp, 3);
		return true;
	}
	return false;
}

bool DummyQAbstractSocket::stateChangedSlot(QAbstractSocket::SocketState socketState)
{
	if (state_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].ivalue = socketState;
		knh_Func_invoke(lctx, state_changed_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractSocket::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractSocket::event_map->bigin();
	if ((itr = DummyQAbstractSocket::event_map->find(str)) == DummyQAbstractSocket::event_map->end()) {
		bool ret = false;
		ret = DummyQIODevice::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAbstractSocket::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractSocket::slot_map->bigin();
	if ((itr = DummyQAbstractSocket::slot_map->find(str)) == DummyQAbstractSocket::slot_map->end()) {
		bool ret = false;
		ret = DummyQIODevice::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		connected_func = (*slot_map)["connected"];
		disconnected_func = (*slot_map)["disconnected"];
		error_func = (*slot_map)["error"];
		host_found_func = (*slot_map)["host-found"];
		proxy_authentication_required_func = (*slot_map)["proxy-authentication-required"];
		state_changed_func = (*slot_map)["state-changed"];
		return true;
	}
}

kObject** DummyQAbstractSocket::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractSocket::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 7;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, connected_func);
	KNH_ADDNNREF(ctx, disconnected_func);
	KNH_ADDNNREF(ctx, error_func);
	KNH_ADDNNREF(ctx, host_found_func);
	KNH_ADDNNREF(ctx, proxy_authentication_required_func);
	KNH_ADDNNREF(ctx, state_changed_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQIODevice::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAbstractSocket::connection(QObject *o)
{
	QAbstractSocket *p = dynamic_cast<QAbstractSocket*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(connected()), this, SLOT(connectedSlot()));
		connect(p, SIGNAL(disconnected()), this, SLOT(disconnectedSlot()));
		connect(p, SIGNAL(error(QAbstractSocket::SocketError)), this, SLOT(errorSlot(QAbstractSocket::SocketError)));
		connect(p, SIGNAL(hostFound()), this, SLOT(hostFoundSlot()));
		connect(p, SIGNAL(proxyAuthenticationRequired(const QNetworkProxy, QAuthenticator*)), this, SLOT(proxyAuthenticationRequiredSlot(const QNetworkProxy, QAuthenticator*)));
		connect(p, SIGNAL(stateChanged(QAbstractSocket::SocketState)), this, SLOT(stateChangedSlot(QAbstractSocket::SocketState)));
	}
	DummyQIODevice::connection(o);
}

KQAbstractSocket::KQAbstractSocket(QAbstractSocket::SocketType socketType, QObject* parent) : QAbstractSocket(socketType, parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAbstractSocket();
	dummy->connection((QObject*)this);
}

KQAbstractSocket::~KQAbstractSocket()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractSocket_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractSocket *qp = RawPtr_to(KQAbstractSocket *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractSocket]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractSocket]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractSocket_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractSocket *qp = RawPtr_to(KQAbstractSocket *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractSocket]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractSocket]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractSocket_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractSocket *qp = (KQAbstractSocket *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractSocket*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractSocket_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractSocket *qp = (KQAbstractSocket *)p->rawptr;
		KQAbstractSocket *qp = static_cast<KQAbstractSocket*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractSocket_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractSocket::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAbstractSocket::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAbstractSocket::event(event);
		return false;
	}
//	QAbstractSocket::event(event);
	return true;
}

static knh_IntData_t QAbstractSocketConstInt[] = {
	{"IPv4Protocol", QAbstractSocket::IPv4Protocol},
	{"IPv6Protocol", QAbstractSocket::IPv6Protocol},
	{"UnknownNetworkLayerProtocol", QAbstractSocket::UnknownNetworkLayerProtocol},
	{"ConnectionRefusedError", QAbstractSocket::ConnectionRefusedError},
	{"RemoteHostClosedError", QAbstractSocket::RemoteHostClosedError},
	{"HostNotFoundError", QAbstractSocket::HostNotFoundError},
	{"SocketAccessError", QAbstractSocket::SocketAccessError},
	{"SocketResourceError", QAbstractSocket::SocketResourceError},
	{"SocketTimeoutError", QAbstractSocket::SocketTimeoutError},
	{"DatagramTooLargeError", QAbstractSocket::DatagramTooLargeError},
	{"NetworkError", QAbstractSocket::NetworkError},
	{"AddressInUseError", QAbstractSocket::AddressInUseError},
	{"SocketAddressNotAvailableError", QAbstractSocket::SocketAddressNotAvailableError},
	{"UnsupportedSocketOperationError", QAbstractSocket::UnsupportedSocketOperationError},
	{"ProxyAuthenticationRequiredError", QAbstractSocket::ProxyAuthenticationRequiredError},
	{"SslHandshakeFailedError", QAbstractSocket::SslHandshakeFailedError},
	{"UnfinishedSocketOperationError", QAbstractSocket::UnfinishedSocketOperationError},
	{"ProxyConnectionRefusedError", QAbstractSocket::ProxyConnectionRefusedError},
	{"ProxyConnectionClosedError", QAbstractSocket::ProxyConnectionClosedError},
	{"ProxyConnectionTimeoutError", QAbstractSocket::ProxyConnectionTimeoutError},
	{"ProxyNotFoundError", QAbstractSocket::ProxyNotFoundError},
	{"ProxyProtocolError", QAbstractSocket::ProxyProtocolError},
	{"UnknownSocketError", QAbstractSocket::UnknownSocketError},
	{"LowDelayOption", QAbstractSocket::LowDelayOption},
	{"KeepAliveOption", QAbstractSocket::KeepAliveOption},
	{"UnconnectedState", QAbstractSocket::UnconnectedState},
	{"HostLookupState", QAbstractSocket::HostLookupState},
	{"ConnectingState", QAbstractSocket::ConnectingState},
	{"ConnectedState", QAbstractSocket::ConnectedState},
	{"BoundState", QAbstractSocket::BoundState},
	{"ClosingState", QAbstractSocket::ClosingState},
	{"ListeningState", QAbstractSocket::ListeningState},
	{"TcpSocket", QAbstractSocket::TcpSocket},
	{"UdpSocket", QAbstractSocket::UdpSocket},
	{"UnknownSocketType", QAbstractSocket::UnknownSocketType},
	{NULL, 0}
};

DEFAPI(void) constQAbstractSocket(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QAbstractSocketConstInt);
}


DEFAPI(void) defQAbstractSocket(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractSocket";
	cdef->free = QAbstractSocket_free;
	cdef->reftrace = QAbstractSocket_reftrace;
	cdef->compareTo = QAbstractSocket_compareTo;
}


//@Virtual @Override boolean QAbstractSpinBox.event(QEvent event);
KMETHOD QAbstractSpinBox_event(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		QEvent*  event = RawPtr_to(QEvent*, sfp[1]);
		bool ret_v = qp->event(event);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override QVariant QAbstractSpinBox.inputMethodQuery(int query);
KMETHOD QAbstractSpinBox_inputMethodQuery(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		Qt::InputMethodQuery query = Int_to(Qt::InputMethodQuery, sfp[1]);
		QVariant ret_v = qp->inputMethodQuery(query);
		QVariant *ret_v_ = new QVariant(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override QSize QAbstractSpinBox.minimumSizeHint();
KMETHOD QAbstractSpinBox_minimumSizeHint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->minimumSizeHint();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override QSize QAbstractSpinBox.sizeHint();
KMETHOD QAbstractSpinBox_sizeHint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->sizeHint();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//
//QtAlignment QAbstractSpinBox.getAlignment();
KMETHOD QAbstractSpinBox_getAlignment(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		Qt::Alignment ret_v = qp->alignment();
		Qt::Alignment *ret_v_ = new Qt::Alignment(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QAbstractSpinBox.getButtonSymbols();
KMETHOD QAbstractSpinBox_getButtonSymbols(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		QAbstractSpinBox::ButtonSymbols ret_v = qp->buttonSymbols();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAbstractSpinBox.getCorrectionMode();
KMETHOD QAbstractSpinBox_getCorrectionMode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		QAbstractSpinBox::CorrectionMode ret_v = qp->correctionMode();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual void QAbstractSpinBox.fixup(String input);
KMETHOD QAbstractSpinBox_fixup(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		QString input = String_to(QString, sfp[1]);
		qp->fixup(input);
	}
	RETURNvoid_();
}

//boolean QAbstractSpinBox.hasAcceptableInput();
KMETHOD QAbstractSpinBox_hasAcceptableInput(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		bool ret_v = qp->hasAcceptableInput();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAbstractSpinBox.hasFrame();
KMETHOD QAbstractSpinBox_hasFrame(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		bool ret_v = qp->hasFrame();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QAbstractSpinBox.interpretText();
KMETHOD QAbstractSpinBox_interpretText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		qp->interpretText();
	}
	RETURNvoid_();
}

//boolean QAbstractSpinBox.isAccelerated();
KMETHOD QAbstractSpinBox_isAccelerated(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isAccelerated();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAbstractSpinBox.isReadOnly();
KMETHOD QAbstractSpinBox_isReadOnly(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isReadOnly();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAbstractSpinBox.getKeyboardTracking();
KMETHOD QAbstractSpinBox_getKeyboardTracking(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		bool ret_v = qp->keyboardTracking();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QAbstractSpinBox.setAccelerated(boolean on);
KMETHOD QAbstractSpinBox_setAccelerated(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		bool on = Boolean_to(bool, sfp[1]);
		qp->setAccelerated(on);
	}
	RETURNvoid_();
}

//void QAbstractSpinBox.setAlignment(QtAlignment flag);
KMETHOD QAbstractSpinBox_setAlignment(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		initFlag(flag, Qt::Alignment, sfp[1]);
		qp->setAlignment(flag);
	}
	RETURNvoid_();
}

//void QAbstractSpinBox.setButtonSymbols(int bs);
KMETHOD QAbstractSpinBox_setButtonSymbols(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		QAbstractSpinBox::ButtonSymbols bs = Int_to(QAbstractSpinBox::ButtonSymbols, sfp[1]);
		qp->setButtonSymbols(bs);
	}
	RETURNvoid_();
}

//void QAbstractSpinBox.setCorrectionMode(int cm);
KMETHOD QAbstractSpinBox_setCorrectionMode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		QAbstractSpinBox::CorrectionMode cm = Int_to(QAbstractSpinBox::CorrectionMode, sfp[1]);
		qp->setCorrectionMode(cm);
	}
	RETURNvoid_();
}

//void QAbstractSpinBox.setFrame(boolean arg0);
KMETHOD QAbstractSpinBox_setFrame(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setFrame(arg0);
	}
	RETURNvoid_();
}

//void QAbstractSpinBox.setKeyboardTracking(boolean kt);
KMETHOD QAbstractSpinBox_setKeyboardTracking(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		bool kt = Boolean_to(bool, sfp[1]);
		qp->setKeyboardTracking(kt);
	}
	RETURNvoid_();
}

//void QAbstractSpinBox.setReadOnly(boolean r);
KMETHOD QAbstractSpinBox_setReadOnly(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		bool r = Boolean_to(bool, sfp[1]);
		qp->setReadOnly(r);
	}
	RETURNvoid_();
}

//void QAbstractSpinBox.setSpecialValueText(String txt);
KMETHOD QAbstractSpinBox_setSpecialValueText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		const QString txt = String_to(const QString, sfp[1]);
		qp->setSpecialValueText(txt);
	}
	RETURNvoid_();
}

//void QAbstractSpinBox.setWrapping(boolean w);
KMETHOD QAbstractSpinBox_setWrapping(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		bool w = Boolean_to(bool, sfp[1]);
		qp->setWrapping(w);
	}
	RETURNvoid_();
}

//String QAbstractSpinBox.getSpecialValueText();
KMETHOD QAbstractSpinBox_getSpecialValueText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		QString ret_v = qp->specialValueText();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual void QAbstractSpinBox.stepBy(int steps);
KMETHOD QAbstractSpinBox_stepBy(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		int steps = Int_to(int, sfp[1]);
		qp->stepBy(steps);
	}
	RETURNvoid_();
}

//String QAbstractSpinBox.text();
KMETHOD QAbstractSpinBox_text(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		QString ret_v = qp->text();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual int QAbstractSpinBox.validate(String input, int pos);
KMETHOD QAbstractSpinBox_validate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		QString input = String_to(QString, sfp[1]);
		int pos = Int_to(int, sfp[2]);
		QValidator::State ret_v = qp->validate(input, pos);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//boolean QAbstractSpinBox.getWrapping();
KMETHOD QAbstractSpinBox_getWrapping(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		bool ret_v = qp->wrapping();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual void QAbstractSpinBox.clear();
KMETHOD QAbstractSpinBox_clear(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		qp->clear();
	}
	RETURNvoid_();
}

//void QAbstractSpinBox.selectAll();
KMETHOD QAbstractSpinBox_selectAll(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		qp->selectAll();
	}
	RETURNvoid_();
}

//void QAbstractSpinBox.stepDown();
KMETHOD QAbstractSpinBox_stepDown(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		qp->stepDown();
	}
	RETURNvoid_();
}

//void QAbstractSpinBox.stepUp();
KMETHOD QAbstractSpinBox_stepUp(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox *  qp = RawPtr_to(QAbstractSpinBox *, sfp[0]);
	if (qp) {
		qp->stepUp();
	}
	RETURNvoid_();
}


DummyQAbstractSpinBox::DummyQAbstractSpinBox()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	editing_finished_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("editing-finished", NULL));
}
DummyQAbstractSpinBox::~DummyQAbstractSpinBox()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractSpinBox::setSelf(kRawPtr *ptr)
{
	DummyQAbstractSpinBox::self = ptr;
	DummyQWidget::setSelf(ptr);
}

bool DummyQAbstractSpinBox::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQWidget::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAbstractSpinBox::editingFinishedSlot()
{
	if (editing_finished_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, editing_finished_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAbstractSpinBox::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractSpinBox::event_map->bigin();
	if ((itr = DummyQAbstractSpinBox::event_map->find(str)) == DummyQAbstractSpinBox::event_map->end()) {
		bool ret = false;
		ret = DummyQWidget::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAbstractSpinBox::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractSpinBox::slot_map->bigin();
	if ((itr = DummyQAbstractSpinBox::slot_map->find(str)) == DummyQAbstractSpinBox::slot_map->end()) {
		bool ret = false;
		ret = DummyQWidget::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		editing_finished_func = (*slot_map)["editing-finished"];
		return true;
	}
}

kObject** DummyQAbstractSpinBox::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractSpinBox::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 2;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, editing_finished_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQWidget::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAbstractSpinBox::connection(QObject *o)
{
	QAbstractSpinBox *p = dynamic_cast<QAbstractSpinBox*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(editingFinished()), this, SLOT(editingFinishedSlot()));
	}
	DummyQWidget::connection(o);
}

KQAbstractSpinBox::KQAbstractSpinBox(QWidget* parent) : QAbstractSpinBox(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAbstractSpinBox();
	dummy->connection((QObject*)this);
}

KQAbstractSpinBox::~KQAbstractSpinBox()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractSpinBox_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractSpinBox *qp = RawPtr_to(KQAbstractSpinBox *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractSpinBox]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractSpinBox]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractSpinBox_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractSpinBox *qp = RawPtr_to(KQAbstractSpinBox *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractSpinBox]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractSpinBox]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractSpinBox_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractSpinBox *qp = (KQAbstractSpinBox *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractSpinBox*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractSpinBox_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractSpinBox *qp = (KQAbstractSpinBox *)p->rawptr;
		KQAbstractSpinBox *qp = static_cast<KQAbstractSpinBox*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractSpinBox_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractSpinBox::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAbstractSpinBox::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAbstractSpinBox::event(event);
		return false;
	}
//	QAbstractSpinBox::event(event);
	return true;
}

static knh_IntData_t QAbstractSpinBoxConstInt[] = {
	{"UpDownArrows", QAbstractSpinBox::UpDownArrows},
	{"PlusMinus", QAbstractSpinBox::PlusMinus},
	{"NoButtons", QAbstractSpinBox::NoButtons},
	{"CorrectToPreviousValue", QAbstractSpinBox::CorrectToPreviousValue},
	{"CorrectToNearestValue", QAbstractSpinBox::CorrectToNearestValue},
	{"StepNone", QAbstractSpinBox::StepNone},
	{"StepUpEnabled", QAbstractSpinBox::StepUpEnabled},
	{"StepDownEnabled", QAbstractSpinBox::StepDownEnabled},
	{NULL, 0}
};

DEFAPI(void) constQAbstractSpinBox(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QAbstractSpinBoxConstInt);
}


DEFAPI(void) defQAbstractSpinBox(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractSpinBox";
	cdef->free = QAbstractSpinBox_free;
	cdef->reftrace = QAbstractSpinBox_reftrace;
	cdef->compareTo = QAbstractSpinBox_compareTo;
}

//## QAbstractSpinBoxStepEnabled QAbstractSpinBoxStepEnabled.new(int value);
KMETHOD QAbstractSpinBoxStepEnabled_new(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractSpinBox::StepEnabledFlag i = Int_to(QAbstractSpinBox::StepEnabledFlag, sfp[1]);
	QAbstractSpinBox::StepEnabled *ret_v = new QAbstractSpinBox::StepEnabled(i);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	RETURN_(rptr);
}

//## QAbstractSpinBoxStepEnabled QAbstractSpinBoxStepEnabled.and(int mask);
KMETHOD QAbstractSpinBoxStepEnabled_and(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractSpinBox::StepEnabled *qp = RawPtr_to(QAbstractSpinBox::StepEnabled*, sfp[0]);
	if (qp != NULL) {
		int i = Int_to(int, sfp[1]);
		QAbstractSpinBox::StepEnabled ret = ((*qp) & i);
		QAbstractSpinBox::StepEnabled *ret_ = new QAbstractSpinBox::StepEnabled(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractSpinBoxStepEnabled QAbstractSpinBoxStepEnabled.iand(QAbstractSpinBox::QAbstractSpinBoxStepEnabled other);
KMETHOD QAbstractSpinBoxStepEnabled_iand(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractSpinBox::StepEnabled *qp = RawPtr_to(QAbstractSpinBox::StepEnabled*, sfp[0]);
	if (qp != NULL) {
		QAbstractSpinBox::StepEnabled *other = RawPtr_to(QAbstractSpinBox::StepEnabled *, sfp[1]);
		*qp = ((*qp) & (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractSpinBoxStepEnabled QAbstractSpinBoxStepEnabled.or(QAbstractSpinBoxStepEnabled f);
KMETHOD QAbstractSpinBoxStepEnabled_or(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox::StepEnabled *qp = RawPtr_to(QAbstractSpinBox::StepEnabled*, sfp[0]);
	if (qp != NULL) {
		QAbstractSpinBox::StepEnabled *f = RawPtr_to(QAbstractSpinBox::StepEnabled*, sfp[1]);
		QAbstractSpinBox::StepEnabled ret = ((*qp) | (*f));
		QAbstractSpinBox::StepEnabled *ret_ = new QAbstractSpinBox::StepEnabled(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractSpinBoxStepEnabled QAbstractSpinBoxStepEnabled.ior(QAbstractSpinBox::QAbstractSpinBoxStepEnabled other);
KMETHOD QAbstractSpinBoxStepEnabled_ior(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractSpinBox::StepEnabled *qp = RawPtr_to(QAbstractSpinBox::StepEnabled*, sfp[0]);
	if (qp != NULL) {
		QAbstractSpinBox::StepEnabled *other = RawPtr_to(QAbstractSpinBox::StepEnabled *, sfp[1]);
		*qp = ((*qp) | (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractSpinBoxStepEnabled QAbstractSpinBoxStepEnabled.xor(QAbstractSpinBoxStepEnabled f);
KMETHOD QAbstractSpinBoxStepEnabled_xor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractSpinBox::StepEnabled *qp = RawPtr_to(QAbstractSpinBox::StepEnabled*, sfp[0]);
	if (qp != NULL) {
		QAbstractSpinBox::StepEnabled *f = RawPtr_to(QAbstractSpinBox::StepEnabled*, sfp[1]);
		QAbstractSpinBox::StepEnabled ret = ((*qp) ^ (*f));
		QAbstractSpinBox::StepEnabled *ret_ = new QAbstractSpinBox::StepEnabled(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAbstractSpinBoxStepEnabled QAbstractSpinBoxStepEnabled.ixor(QAbstractSpinBox::QAbstractSpinBoxStepEnabled other);
KMETHOD QAbstractSpinBoxStepEnabled_ixor(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractSpinBox::StepEnabled *qp = RawPtr_to(QAbstractSpinBox::StepEnabled*, sfp[0]);
	if (qp != NULL) {
		QAbstractSpinBox::StepEnabled *other = RawPtr_to(QAbstractSpinBox::StepEnabled *, sfp[1]);
		*qp = ((*qp) ^ (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## boolean QAbstractSpinBoxStepEnabled.testFlag(int flag);
KMETHOD QAbstractSpinBoxStepEnabled_testFlag(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractSpinBox::StepEnabled *qp = RawPtr_to(QAbstractSpinBox::StepEnabled *, sfp[0]);
	if (qp != NULL) {
		QAbstractSpinBox::StepEnabledFlag flag = Int_to(QAbstractSpinBox::StepEnabledFlag, sfp[1]);
		bool ret = qp->testFlag(flag);
		RETURNb_(ret);
	} else {
		RETURNb_(false);
	}
}

//## int QAbstractSpinBoxStepEnabled.value();
KMETHOD QAbstractSpinBoxStepEnabled_value(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAbstractSpinBox::StepEnabled *qp = RawPtr_to(QAbstractSpinBox::StepEnabled *, sfp[0]);
	if (qp != NULL) {
		int ret = int(*qp);
		RETURNi_(ret);
	} else {
		RETURNi_(0);
	}
}

static void QAbstractSpinBoxStepEnabled_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (p->rawptr != NULL) {
		QAbstractSpinBox::StepEnabled *qp = (QAbstractSpinBox::StepEnabled *)p->rawptr;
		(void)qp;
		delete qp;
		p->rawptr = NULL;
	}
}

static void QAbstractSpinBoxStepEnabled_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
	if (p->rawptr != NULL) {
		QAbstractSpinBox::StepEnabled *qp = (QAbstractSpinBox::StepEnabled *)p->rawptr;
		(void)qp;
	}
}

static int QAbstractSpinBoxStepEnabled_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	if (p1->rawptr == NULL || p2->rawptr == NULL) {
		return 1;
	} else {
//		int v1 = int(*(QAbstractSpinBox::StepEnabled*)p1->rawptr);
//		int v2 = int(*(QAbstractSpinBox::StepEnabled*)p2->rawptr);
//		return (v1 == v2 ? 0 : 1);
		QAbstractSpinBox::StepEnabled v1 = *(QAbstractSpinBox::StepEnabled*)p1->rawptr;
		QAbstractSpinBox::StepEnabled v2 = *(QAbstractSpinBox::StepEnabled*)p2->rawptr;
//		return (v1 == v2 ? 0 : 1);
		return (v1 == v2 ? 0 : 1);

	}
}

DEFAPI(void) defQAbstractSpinBoxStepEnabled(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractSpinBoxStepEnabled";
	cdef->free = QAbstractSpinBoxStepEnabled_free;
	cdef->reftrace = QAbstractSpinBoxStepEnabled_reftrace;
	cdef->compareTo = QAbstractSpinBoxStepEnabled_compareTo;
}

//QStateMachine QAbstractState.machine();
KMETHOD QAbstractState_machine(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractState *  qp = RawPtr_to(QAbstractState *, sfp[0]);
	if (qp) {
		QStateMachine* ret_v = qp->machine();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QStateMachine*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QState QAbstractState.parentState();
KMETHOD QAbstractState_parentState(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractState *  qp = RawPtr_to(QAbstractState *, sfp[0]);
	if (qp) {
		QState* ret_v = qp->parentState();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QState*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}


DummyQAbstractState::DummyQAbstractState()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	entered_func = NULL;
	exited_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("entered", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("exited", NULL));
}
DummyQAbstractState::~DummyQAbstractState()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractState::setSelf(kRawPtr *ptr)
{
	DummyQAbstractState::self = ptr;
	DummyQObject::setSelf(ptr);
}

bool DummyQAbstractState::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQObject::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAbstractState::enteredSlot()
{
	if (entered_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, entered_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAbstractState::exitedSlot()
{
	if (exited_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, exited_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAbstractState::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractState::event_map->bigin();
	if ((itr = DummyQAbstractState::event_map->find(str)) == DummyQAbstractState::event_map->end()) {
		bool ret = false;
		ret = DummyQObject::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAbstractState::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractState::slot_map->bigin();
	if ((itr = DummyQAbstractState::slot_map->find(str)) == DummyQAbstractState::slot_map->end()) {
		bool ret = false;
		ret = DummyQObject::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		entered_func = (*slot_map)["entered"];
		exited_func = (*slot_map)["exited"];
		return true;
	}
}

kObject** DummyQAbstractState::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractState::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 3;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, entered_func);
	KNH_ADDNNREF(ctx, exited_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQObject::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAbstractState::connection(QObject *o)
{
	QAbstractState *p = dynamic_cast<QAbstractState*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(entered()), this, SLOT(enteredSlot()));
		connect(p, SIGNAL(exited()), this, SLOT(exitedSlot()));
	}
	DummyQObject::connection(o);
}

KQAbstractState::~KQAbstractState()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractState_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractState *qp = RawPtr_to(KQAbstractState *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractState]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractState]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractState_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractState *qp = RawPtr_to(KQAbstractState *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractState]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractState]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractState_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractState *qp = (KQAbstractState *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractState*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractState_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractState *qp = (KQAbstractState *)p->rawptr;
		KQAbstractState *qp = static_cast<KQAbstractState*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractState_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractState::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAbstractState::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAbstractState::event(event);
		return false;
	}
//	QAbstractState::event(event);
	return true;
}



DEFAPI(void) defQAbstractState(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractState";
	cdef->free = QAbstractState_free;
	cdef->reftrace = QAbstractState_reftrace;
	cdef->compareTo = QAbstractState_compareTo;
}


//@Virtual @Override boolean QAbstractTableModel.dropMimeData(QMimeData data, int action, int row, int column, QModelIndex parent);
KMETHOD QAbstractTableModel_dropMimeData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTableModel *  qp = RawPtr_to(QAbstractTableModel *, sfp[0]);
	if (qp) {
		const QMimeData*  data = RawPtr_to(const QMimeData*, sfp[1]);
		Qt::DropAction action = Int_to(Qt::DropAction, sfp[2]);
		int row = Int_to(int, sfp[3]);
		int column = Int_to(int, sfp[4]);
		const QModelIndex  parent = *RawPtr_to(const QModelIndex *, sfp[5]);
		bool ret_v = qp->dropMimeData(data, action, row, column, parent);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override QModelIndex QAbstractTableModel.index(int row, int column, QModelIndex parent);
KMETHOD QAbstractTableModel_index(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTableModel *  qp = RawPtr_to(QAbstractTableModel *, sfp[0]);
	if (qp) {
		int row = Int_to(int, sfp[1]);
		int column = Int_to(int, sfp[2]);
		const QModelIndex  parent = *RawPtr_to(const QModelIndex *, sfp[3]);
		QModelIndex ret_v = qp->index(row, column, parent);
		QModelIndex *ret_v_ = new QModelIndex(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//

DummyQAbstractTableModel::DummyQAbstractTableModel()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQAbstractTableModel::~DummyQAbstractTableModel()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractTableModel::setSelf(kRawPtr *ptr)
{
	DummyQAbstractTableModel::self = ptr;
	DummyQAbstractItemModel::setSelf(ptr);
}

bool DummyQAbstractTableModel::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQAbstractItemModel::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAbstractTableModel::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractTableModel::event_map->bigin();
	if ((itr = DummyQAbstractTableModel::event_map->find(str)) == DummyQAbstractTableModel::event_map->end()) {
		bool ret = false;
		ret = DummyQAbstractItemModel::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAbstractTableModel::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractTableModel::slot_map->bigin();
	if ((itr = DummyQAbstractTableModel::slot_map->find(str)) == DummyQAbstractTableModel::slot_map->end()) {
		bool ret = false;
		ret = DummyQAbstractItemModel::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQAbstractTableModel::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractTableModel::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQAbstractItemModel::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAbstractTableModel::connection(QObject *o)
{
	QAbstractTableModel *p = dynamic_cast<QAbstractTableModel*>(o);
	if (p != NULL) {
	}
	DummyQAbstractItemModel::connection(o);
}

KQAbstractTableModel::KQAbstractTableModel(QObject* parent) : QAbstractTableModel(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAbstractTableModel();
	dummy->connection((QObject*)this);
}

KQAbstractTableModel::~KQAbstractTableModel()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractTableModel_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractTableModel *qp = RawPtr_to(KQAbstractTableModel *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractTableModel]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractTableModel]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractTableModel_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractTableModel *qp = RawPtr_to(KQAbstractTableModel *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractTableModel]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractTableModel]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractTableModel_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractTableModel *qp = (KQAbstractTableModel *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractTableModel*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractTableModel_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractTableModel *qp = (KQAbstractTableModel *)p->rawptr;
		KQAbstractTableModel *qp = static_cast<KQAbstractTableModel*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractTableModel_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractTableModel::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAbstractTableModel::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAbstractTableModel::event(event);
		return false;
	}
//	QAbstractTableModel::event(event);
	return true;
}



DEFAPI(void) defQAbstractTableModel(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractTableModel";
	cdef->free = QAbstractTableModel_free;
	cdef->reftrace = QAbstractTableModel_reftrace;
	cdef->compareTo = QAbstractTableModel_compareTo;
}


//
//String QAbstractTextDocumentLayout.anchorAt(QPointF position);
KMETHOD QAbstractTextDocumentLayout_anchorAt(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTextDocumentLayout *  qp = RawPtr_to(QAbstractTextDocumentLayout *, sfp[0]);
	if (qp) {
		const QPointF  position = *RawPtr_to(const QPointF *, sfp[1]);
		QString ret_v = qp->anchorAt(position);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual QRectF QAbstractTextDocumentLayout.blockBoundingRect(QTextBlock block);
KMETHOD QAbstractTextDocumentLayout_blockBoundingRect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTextDocumentLayout *  qp = RawPtr_to(QAbstractTextDocumentLayout *, sfp[0]);
	if (qp) {
		const QTextBlock  block = *RawPtr_to(const QTextBlock *, sfp[1]);
		QRectF ret_v = qp->blockBoundingRect(block);
		QRectF *ret_v_ = new QRectF(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QTextDocument QAbstractTextDocumentLayout.document();
KMETHOD QAbstractTextDocumentLayout_document(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTextDocumentLayout *  qp = RawPtr_to(QAbstractTextDocumentLayout *, sfp[0]);
	if (qp) {
		QTextDocument* ret_v = qp->document();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QTextDocument*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual QSizeF QAbstractTextDocumentLayout.documentSize();
KMETHOD QAbstractTextDocumentLayout_documentSize(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTextDocumentLayout *  qp = RawPtr_to(QAbstractTextDocumentLayout *, sfp[0]);
	if (qp) {
		QSizeF ret_v = qp->documentSize();
		QSizeF *ret_v_ = new QSizeF(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual QRectF QAbstractTextDocumentLayout.frameBoundingRect(QTextFrame frame);
KMETHOD QAbstractTextDocumentLayout_frameBoundingRect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTextDocumentLayout *  qp = RawPtr_to(QAbstractTextDocumentLayout *, sfp[0]);
	if (qp) {
		QTextFrame*  frame = RawPtr_to(QTextFrame*, sfp[1]);
		QRectF ret_v = qp->frameBoundingRect(frame);
		QRectF *ret_v_ = new QRectF(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QTextObjectInterface QAbstractTextDocumentLayout.handlerForObject(int objectType);
KMETHOD QAbstractTextDocumentLayout_handlerForObject(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTextDocumentLayout *  qp = RawPtr_to(QAbstractTextDocumentLayout *, sfp[0]);
	if (qp) {
		int objectType = Int_to(int, sfp[1]);
		QTextObjectInterface* ret_v = qp->handlerForObject(objectType);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QTextObjectInterface*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual int QAbstractTextDocumentLayout.hitTest(QPointF point, int accuracy);
KMETHOD QAbstractTextDocumentLayout_hitTest(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTextDocumentLayout *  qp = RawPtr_to(QAbstractTextDocumentLayout *, sfp[0]);
	if (qp) {
		const QPointF  point = *RawPtr_to(const QPointF *, sfp[1]);
		Qt::HitTestAccuracy accuracy = Int_to(Qt::HitTestAccuracy, sfp[2]);
		int ret_v = qp->hitTest(point, accuracy);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual int QAbstractTextDocumentLayout.pageCount();
KMETHOD QAbstractTextDocumentLayout_pageCount(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTextDocumentLayout *  qp = RawPtr_to(QAbstractTextDocumentLayout *, sfp[0]);
	if (qp) {
		int ret_v = qp->pageCount();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QPaintDevice QAbstractTextDocumentLayout.getPaintDevice();
KMETHOD QAbstractTextDocumentLayout_getPaintDevice(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTextDocumentLayout *  qp = RawPtr_to(QAbstractTextDocumentLayout *, sfp[0]);
	if (qp) {
		QPaintDevice* ret_v = qp->paintDevice();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QPaintDevice*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QAbstractTextDocumentLayout.registerHandler(int objectType, QObject component);
KMETHOD QAbstractTextDocumentLayout_registerHandler(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTextDocumentLayout *  qp = RawPtr_to(QAbstractTextDocumentLayout *, sfp[0]);
	if (qp) {
		int objectType = Int_to(int, sfp[1]);
		QObject*  component = RawPtr_to(QObject*, sfp[2]);
		qp->registerHandler(objectType, component);
	}
	RETURNvoid_();
}

//void QAbstractTextDocumentLayout.setPaintDevice(QPaintDevice device);
KMETHOD QAbstractTextDocumentLayout_setPaintDevice(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTextDocumentLayout *  qp = RawPtr_to(QAbstractTextDocumentLayout *, sfp[0]);
	if (qp) {
		QPaintDevice*  device = RawPtr_to(QPaintDevice*, sfp[1]);
		qp->setPaintDevice(device);
	}
	RETURNvoid_();
}


DummyQAbstractTextDocumentLayout::DummyQAbstractTextDocumentLayout()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	document_size_changed_func = NULL;
	page_count_changed_func = NULL;
	update_func = NULL;
	update_block_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("document-size-changed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("page-count-changed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("update", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("update-block", NULL));
}
DummyQAbstractTextDocumentLayout::~DummyQAbstractTextDocumentLayout()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractTextDocumentLayout::setSelf(kRawPtr *ptr)
{
	DummyQAbstractTextDocumentLayout::self = ptr;
	DummyQObject::setSelf(ptr);
}

bool DummyQAbstractTextDocumentLayout::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQObject::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAbstractTextDocumentLayout::documentSizeChangedSlot(const QSizeF new_Size)
{
	if (document_size_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QSizeF, new_Size);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, document_size_changed_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractTextDocumentLayout::pageCountChangedSlot(int new_Pages)
{
	if (page_count_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].ivalue = new_Pages;
		knh_Func_invoke(lctx, page_count_changed_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractTextDocumentLayout::updateSlot(const QRectF rect)
{
	if (update_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QRectF, rect);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, update_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractTextDocumentLayout::updateBlockSlot(const QTextBlock block)
{
	if (update_block_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QTextBlock, block);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, update_block_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAbstractTextDocumentLayout::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractTextDocumentLayout::event_map->bigin();
	if ((itr = DummyQAbstractTextDocumentLayout::event_map->find(str)) == DummyQAbstractTextDocumentLayout::event_map->end()) {
		bool ret = false;
		ret = DummyQObject::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAbstractTextDocumentLayout::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractTextDocumentLayout::slot_map->bigin();
	if ((itr = DummyQAbstractTextDocumentLayout::slot_map->find(str)) == DummyQAbstractTextDocumentLayout::slot_map->end()) {
		bool ret = false;
		ret = DummyQObject::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		document_size_changed_func = (*slot_map)["document-size-changed"];
		page_count_changed_func = (*slot_map)["page-count-changed"];
		update_func = (*slot_map)["update"];
		update_block_func = (*slot_map)["update-block"];
		return true;
	}
}

kObject** DummyQAbstractTextDocumentLayout::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractTextDocumentLayout::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 5;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, document_size_changed_func);
	KNH_ADDNNREF(ctx, page_count_changed_func);
	KNH_ADDNNREF(ctx, update_func);
	KNH_ADDNNREF(ctx, update_block_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQObject::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAbstractTextDocumentLayout::connection(QObject *o)
{
	QAbstractTextDocumentLayout *p = dynamic_cast<QAbstractTextDocumentLayout*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(documentSizeChanged(const QSizeF)), this, SLOT(documentSizeChangedSlot(const QSizeF)));
		connect(p, SIGNAL(pageCountChanged(int)), this, SLOT(pageCountChangedSlot(int)));
		connect(p, SIGNAL(update(const QRectF)), this, SLOT(updateSlot(const QRectF)));
		connect(p, SIGNAL(updateBlock(const QTextBlock)), this, SLOT(updateBlockSlot(const QTextBlock)));
	}
	DummyQObject::connection(o);
}

KQAbstractTextDocumentLayout::KQAbstractTextDocumentLayout(QTextDocument* document) : QAbstractTextDocumentLayout(document)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAbstractTextDocumentLayout();
	dummy->connection((QObject*)this);
}

KQAbstractTextDocumentLayout::~KQAbstractTextDocumentLayout()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractTextDocumentLayout_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractTextDocumentLayout *qp = RawPtr_to(KQAbstractTextDocumentLayout *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractTextDocumentLayout]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractTextDocumentLayout]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractTextDocumentLayout_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractTextDocumentLayout *qp = RawPtr_to(KQAbstractTextDocumentLayout *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractTextDocumentLayout]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractTextDocumentLayout]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractTextDocumentLayout_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractTextDocumentLayout *qp = (KQAbstractTextDocumentLayout *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractTextDocumentLayout*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractTextDocumentLayout_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractTextDocumentLayout *qp = (KQAbstractTextDocumentLayout *)p->rawptr;
		KQAbstractTextDocumentLayout *qp = static_cast<KQAbstractTextDocumentLayout*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractTextDocumentLayout_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractTextDocumentLayout::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAbstractTextDocumentLayout::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAbstractTextDocumentLayout::event(event);
		return false;
	}
//	QAbstractTextDocumentLayout::event(event);
	return true;
}



DEFAPI(void) defQAbstractTextDocumentLayout(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractTextDocumentLayout";
	cdef->free = QAbstractTextDocumentLayout_free;
	cdef->reftrace = QAbstractTextDocumentLayout_reftrace;
	cdef->compareTo = QAbstractTextDocumentLayout_compareTo;
}


//
//void QAbstractTransition.addAnimation(QAbstractAnimation animation);
KMETHOD QAbstractTransition_addAnimation(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTransition *  qp = RawPtr_to(QAbstractTransition *, sfp[0]);
	if (qp) {
		QAbstractAnimation*  animation = RawPtr_to(QAbstractAnimation*, sfp[1]);
		qp->addAnimation(animation);
	}
	RETURNvoid_();
}

//Array<QAbstractAnimation> QAbstractTransition.animations();
KMETHOD QAbstractTransition_animations(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTransition *  qp = RawPtr_to(QAbstractTransition *, sfp[0]);
	if (qp) {
		QList<QAbstractAnimation*> ret_v = qp->animations();
		int list_size = ret_v.size();
		kArray *a = new_Array0(ctx, list_size);
		kclass_t cid = knh_getcid(ctx, STEXT("QAbstractAnimation"));
		for (int n = 0; n < list_size; n++) {
			kRawPtr *p = new_RawPtr(ctx, ClassTBL(cid), ret_v[n]);
			knh_Array_add(ctx, a, (kObject *)p);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}
	

//QStateMachine QAbstractTransition.machine();
KMETHOD QAbstractTransition_machine(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTransition *  qp = RawPtr_to(QAbstractTransition *, sfp[0]);
	if (qp) {
		QStateMachine* ret_v = qp->machine();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QStateMachine*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QAbstractTransition.removeAnimation(QAbstractAnimation animation);
KMETHOD QAbstractTransition_removeAnimation(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTransition *  qp = RawPtr_to(QAbstractTransition *, sfp[0]);
	if (qp) {
		QAbstractAnimation*  animation = RawPtr_to(QAbstractAnimation*, sfp[1]);
		qp->removeAnimation(animation);
	}
	RETURNvoid_();
}

//void QAbstractTransition.setTargetState(QAbstractState target);
KMETHOD QAbstractTransition_setTargetState(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTransition *  qp = RawPtr_to(QAbstractTransition *, sfp[0]);
	if (qp) {
		QAbstractState*  target = RawPtr_to(QAbstractState*, sfp[1]);
		qp->setTargetState(target);
	}
	RETURNvoid_();
}

//void QAbstractTransition.setTargetStates(Array<QAbstractState> targets);
KMETHOD QAbstractTransition_setTargetStates(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTransition *  qp = RawPtr_to(QAbstractTransition *, sfp[0]);
	if (qp) {
		kArray *a = sfp[1].a;
		int asize = knh_Array_size(a);
		QList<QAbstractState*> targets;
		for (int n = 0; n < asize; n++) {
			kRawPtr *p = (kRawPtr*)(a->list[n]);
			targets.append((QAbstractState*)p->rawptr);
		}
		qp->setTargetStates(targets);
	}
	RETURNvoid_();
}

//QState QAbstractTransition.sourceState();
KMETHOD QAbstractTransition_sourceState(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTransition *  qp = RawPtr_to(QAbstractTransition *, sfp[0]);
	if (qp) {
		QState* ret_v = qp->sourceState();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QState*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QAbstractState QAbstractTransition.getTargetState();
KMETHOD QAbstractTransition_getTargetState(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTransition *  qp = RawPtr_to(QAbstractTransition *, sfp[0]);
	if (qp) {
		QAbstractState* ret_v = qp->targetState();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractState*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//Array<QAbstractState> QAbstractTransition.getTargetStates();
KMETHOD QAbstractTransition_getTargetStates(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractTransition *  qp = RawPtr_to(QAbstractTransition *, sfp[0]);
	if (qp) {
		QList<QAbstractState*> ret_v = qp->targetStates();
		int list_size = ret_v.size();
		kArray *a = new_Array0(ctx, list_size);
		kclass_t cid = knh_getcid(ctx, STEXT("QAbstractState"));
		for (int n = 0; n < list_size; n++) {
			kRawPtr *p = new_RawPtr(ctx, ClassTBL(cid), ret_v[n]);
			knh_Array_add(ctx, a, (kObject *)p);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}
	


DummyQAbstractTransition::DummyQAbstractTransition()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	triggered_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("triggered", NULL));
}
DummyQAbstractTransition::~DummyQAbstractTransition()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAbstractTransition::setSelf(kRawPtr *ptr)
{
	DummyQAbstractTransition::self = ptr;
	DummyQObject::setSelf(ptr);
}

bool DummyQAbstractTransition::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQObject::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAbstractTransition::triggeredSlot()
{
	if (triggered_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, triggered_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAbstractTransition::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractTransition::event_map->bigin();
	if ((itr = DummyQAbstractTransition::event_map->find(str)) == DummyQAbstractTransition::event_map->end()) {
		bool ret = false;
		ret = DummyQObject::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAbstractTransition::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAbstractTransition::slot_map->bigin();
	if ((itr = DummyQAbstractTransition::slot_map->find(str)) == DummyQAbstractTransition::slot_map->end()) {
		bool ret = false;
		ret = DummyQObject::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		triggered_func = (*slot_map)["triggered"];
		return true;
	}
}

kObject** DummyQAbstractTransition::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAbstractTransition::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 2;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, triggered_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQObject::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAbstractTransition::connection(QObject *o)
{
	QAbstractTransition *p = dynamic_cast<QAbstractTransition*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(triggered()), this, SLOT(triggeredSlot()));
	}
	DummyQObject::connection(o);
}

KQAbstractTransition::KQAbstractTransition(QState* sourceState) : QAbstractTransition(sourceState)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAbstractTransition();
	dummy->connection((QObject*)this);
}

KQAbstractTransition::~KQAbstractTransition()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAbstractTransition_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractTransition *qp = RawPtr_to(KQAbstractTransition *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractTransition]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractTransition]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAbstractTransition_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAbstractTransition *qp = RawPtr_to(KQAbstractTransition *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAbstractTransition]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAbstractTransition]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAbstractTransition_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAbstractTransition *qp = (KQAbstractTransition *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAbstractTransition*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAbstractTransition_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAbstractTransition *qp = (KQAbstractTransition *)p->rawptr;
		KQAbstractTransition *qp = static_cast<KQAbstractTransition*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAbstractTransition_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAbstractTransition::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAbstractTransition::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAbstractTransition::event(event);
		return false;
	}
//	QAbstractTransition::event(event);
	return true;
}



DEFAPI(void) defQAbstractTransition(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAbstractTransition";
	cdef->free = QAbstractTransition_free;
	cdef->reftrace = QAbstractTransition_reftrace;
	cdef->compareTo = QAbstractTransition_compareTo;
}


//boolean QAccessible.isActive();
KMETHOD QAccessible_isActive(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		bool ret_v = QAccessible::isActive();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//QAccessibleInterface QAccessible.queryAccessibleInterface(QObject object);
KMETHOD QAccessible_queryAccessibleInterface(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QObject*  object = RawPtr_to(QObject*, sfp[1]);
		QAccessibleInterface* ret_v = QAccessible::queryAccessibleInterface(object);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAccessibleInterface*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QAccessible.setRootObject(QObject object);
KMETHOD QAccessible_setRootObject(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QObject*  object = RawPtr_to(QObject*, sfp[1]);
		QAccessible::setRootObject(object);
	}
	RETURNvoid_();
}

//void QAccessible.updateAccessibility(QObject object, int child, int reason);
KMETHOD QAccessible_updateAccessibility(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QObject*  object = RawPtr_to(QObject*, sfp[1]);
		int child = Int_to(int, sfp[2]);
		QAccessible::Event reason = Int_to(QAccessible::Event, sfp[3]);
		QAccessible::updateAccessibility(object, child, reason);
	}
	RETURNvoid_();
}

//Array<String> QAccessible.parents();
KMETHOD QAccessible_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessible *qp = RawPtr_to(QAccessible*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQAccessible::DummyQAccessible()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQAccessible::~DummyQAccessible()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAccessible::setSelf(kRawPtr *ptr)
{
	DummyQAccessible::self = ptr;
}

bool DummyQAccessible::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQAccessible::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAccessible::event_map->bigin();
	if ((itr = DummyQAccessible::event_map->find(str)) == DummyQAccessible::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAccessible::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAccessible::slot_map->bigin();
	if ((itr = DummyQAccessible::slot_map->find(str)) == DummyQAccessible::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQAccessible::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAccessible::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQAccessible::connection(QObject *o)
{
	QAccessible *p = dynamic_cast<QAccessible*>(o);
	if (p != NULL) {
	}
}

KQAccessible::~KQAccessible()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAccessible_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAccessible *qp = RawPtr_to(KQAccessible *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAccessible]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAccessible]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAccessible_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAccessible *qp = RawPtr_to(KQAccessible *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAccessible]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAccessible]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAccessible_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAccessible *qp = (KQAccessible *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAccessible*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAccessible_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAccessible *qp = (KQAccessible *)p->rawptr;
		KQAccessible *qp = static_cast<KQAccessible*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAccessible_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAccessible::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

static knh_IntData_t QAccessibleConstInt[] = {
	{"DefaultAction", QAccessible::DefaultAction},
	{"Press", QAccessible::Press},
	{"SetFocus", QAccessible::SetFocus},
	{"Increase", QAccessible::Increase},
	{"Decrease", QAccessible::Decrease},
	{"Accept", QAccessible::Accept},
	{"Cancel", QAccessible::Cancel},
	{"Select", QAccessible::Select},
	{"ClearSelection", QAccessible::ClearSelection},
	{"RemoveSelection", QAccessible::RemoveSelection},
	{"ExtendSelection", QAccessible::ExtendSelection},
	{"AddToSelection", QAccessible::AddToSelection},
	{"FirstStandardAction", QAccessible::FirstStandardAction},
	{"LastStandardAction", QAccessible::LastStandardAction},
	{"AcceleratorChanged", QAccessible::AcceleratorChanged},
	{"Alert", QAccessible::Alert},
	{"ContextHelpEnd", QAccessible::ContextHelpEnd},
	{"ContextHelpStart", QAccessible::ContextHelpStart},
	{"DefaultActionChanged", QAccessible::DefaultActionChanged},
	{"DescriptionChanged", QAccessible::DescriptionChanged},
	{"DialogEnd", QAccessible::DialogEnd},
	{"DialogStart", QAccessible::DialogStart},
	{"DragDropEnd", QAccessible::DragDropEnd},
	{"DragDropStart", QAccessible::DragDropStart},
	{"Focus", QAccessible::Focus},
	{"ForegroundChanged", QAccessible::ForegroundChanged},
	{"HelpChanged", QAccessible::HelpChanged},
	{"LocationChanged", QAccessible::LocationChanged},
	{"MenuCommand", QAccessible::MenuCommand},
	{"MenuEnd", QAccessible::MenuEnd},
	{"MenuStart", QAccessible::MenuStart},
	{"NameChanged", QAccessible::NameChanged},
	{"ObjectCreated", QAccessible::ObjectCreated},
	{"ObjectDestroyed", QAccessible::ObjectDestroyed},
	{"ObjectHide", QAccessible::ObjectHide},
	{"ObjectReorder", QAccessible::ObjectReorder},
	{"ObjectShow", QAccessible::ObjectShow},
	{"ParentChanged", QAccessible::ParentChanged},
	{"PopupMenuEnd", QAccessible::PopupMenuEnd},
	{"PopupMenuStart", QAccessible::PopupMenuStart},
	{"ScrollingEnd", QAccessible::ScrollingEnd},
	{"ScrollingStart", QAccessible::ScrollingStart},
	{"Selection", QAccessible::Selection},
	{"SelectionAdd", QAccessible::SelectionAdd},
	{"SelectionRemove", QAccessible::SelectionRemove},
	{"SelectionWithin", QAccessible::SelectionWithin},
	{"SoundPlayed", QAccessible::SoundPlayed},
	{"StateChanged", QAccessible::StateChanged},
	{"ValueChanged", QAccessible::ValueChanged},
	{"ListSupportedMethods", QAccessible::ListSupportedMethods},
	{"SetCursorPosition", QAccessible::SetCursorPosition},
	{"GetCursorPosition", QAccessible::GetCursorPosition},
	{"Unrelated", QAccessible::Unrelated},
	{"Self", QAccessible::Self},
	{"Ancestor", QAccessible::Ancestor},
	{"Child", QAccessible::Child},
	{"Descendent", QAccessible::Descendent},
	{"Sibling", QAccessible::Sibling},
	{"Up", QAccessible::Up},
	{"Down", QAccessible::Down},
	{"Left", QAccessible::Left},
	{"Right", QAccessible::Right},
	{"Covers", QAccessible::Covers},
	{"Covered", QAccessible::Covered},
	{"FocusChild", QAccessible::FocusChild},
	{"Label", QAccessible::Label},
	{"Labelled", QAccessible::Labelled},
	{"Controller", QAccessible::Controller},
	{"Controlled", QAccessible::Controlled},
	{"AlertMessage", QAccessible::AlertMessage},
	{"Animation", QAccessible::Animation},
	{"Application", QAccessible::Application},
	{"Assistant", QAccessible::Assistant},
	{"Border", QAccessible::Border},
	{"ButtonDropDown", QAccessible::ButtonDropDown},
	{"ButtonDropGrid", QAccessible::ButtonDropGrid},
	{"ButtonMenu", QAccessible::ButtonMenu},
	{"Canvas", QAccessible::Canvas},
	{"Caret", QAccessible::Caret},
	{"Cell", QAccessible::Cell},
	{"Chart", QAccessible::Chart},
	{"CheckBox", QAccessible::CheckBox},
	{"Client", QAccessible::Client},
	{"Clock", QAccessible::Clock},
	{"Column", QAccessible::Column},
	{"ColumnHeader", QAccessible::ColumnHeader},
	{"ComboBox", QAccessible::ComboBox},
	{"Cursor", QAccessible::Cursor},
	{"Dial", QAccessible::Dial},
	{"Dialog", QAccessible::Dialog},
	{"Document", QAccessible::Document},
	{"EditableText", QAccessible::EditableText},
	{"Equation", QAccessible::Equation},
	{"Graphic", QAccessible::Graphic},
	{"Grip", QAccessible::Grip},
	{"Grouping", QAccessible::Grouping},
	{"HelpBalloon", QAccessible::HelpBalloon},
	{"HotkeyField", QAccessible::HotkeyField},
	{"Indicator", QAccessible::Indicator},
	{"LayeredPane", QAccessible::LayeredPane},
	{"Link", QAccessible::Link},
	{"List", QAccessible::List},
	{"ListItem", QAccessible::ListItem},
	{"MenuBar", QAccessible::MenuBar},
	{"MenuItem", QAccessible::MenuItem},
	{"NoRole", QAccessible::NoRole},
	{"PageTab", QAccessible::PageTab},
	{"PageTabList", QAccessible::PageTabList},
	{"Pane", QAccessible::Pane},
	{"PopupMenu", QAccessible::PopupMenu},
	{"ProgressBar", QAccessible::ProgressBar},
	{"PropertyPage", QAccessible::PropertyPage},
	{"PushButton", QAccessible::PushButton},
	{"RadioButton", QAccessible::RadioButton},
	{"Row", QAccessible::Row},
	{"RowHeader", QAccessible::RowHeader},
	{"ScrollBar", QAccessible::ScrollBar},
	{"Separator", QAccessible::Separator},
	{"Slider", QAccessible::Slider},
	{"Sound", QAccessible::Sound},
	{"SpinBox", QAccessible::SpinBox},
	{"Splitter", QAccessible::Splitter},
	{"StaticText", QAccessible::StaticText},
	{"StatusBar", QAccessible::StatusBar},
	{"Table", QAccessible::Table},
	{"TitleBar", QAccessible::TitleBar},
	{"ToolBar", QAccessible::ToolBar},
	{"ToolTip", QAccessible::ToolTip},
	{"Tree", QAccessible::Tree},
	{"TreeItem", QAccessible::TreeItem},
	{"UserRole", QAccessible::UserRole},
	{"Whitespace", QAccessible::Whitespace},
	{"Window", QAccessible::Window},
	{"Animated", QAccessible::Animated},
	{"Busy", QAccessible::Busy},
	{"Checked", QAccessible::Checked},
	{"Collapsed", QAccessible::Collapsed},
	{"DefaultButton", QAccessible::DefaultButton},
	{"Expanded", QAccessible::Expanded},
	{"ExtSelectable", QAccessible::ExtSelectable},
	{"Focusable", QAccessible::Focusable},
	{"Focused", QAccessible::Focused},
	{"HasPopup", QAccessible::HasPopup},
	{"HotTracked", QAccessible::HotTracked},
	{"Invisible", QAccessible::Invisible},
	{"Linked", QAccessible::Linked},
	{"Marqueed", QAccessible::Marqueed},
	{"Mixed", QAccessible::Mixed},
	{"Modal", QAccessible::Modal},
	{"Movable", QAccessible::Movable},
	{"MultiSelectable", QAccessible::MultiSelectable},
	{"Normal", QAccessible::Normal},
	{"Offscreen", QAccessible::Offscreen},
	{"Pressed", QAccessible::Pressed},
	{"Protected", QAccessible::Protected},
	{"ReadOnly", QAccessible::ReadOnly},
	{"Selectable", QAccessible::Selectable},
	{"Selected", QAccessible::Selected},
	{"SelfVoicing", QAccessible::SelfVoicing},
	{"Sizeable", QAccessible::Sizeable},
	{"Traversed", QAccessible::Traversed},
	{"Unavailable", QAccessible::Unavailable},
	{"Name", QAccessible::Name},
	{"Description", QAccessible::Description},
	{"Value", QAccessible::Value},
	{"Help", QAccessible::Help},
	{"Accelerator", QAccessible::Accelerator},
	{"UserText", QAccessible::UserText},
	{NULL, 0}
};

DEFAPI(void) constQAccessible(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QAccessibleConstInt);
}


DEFAPI(void) defQAccessible(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAccessible";
	cdef->free = QAccessible_free;
	cdef->reftrace = QAccessible_reftrace;
	cdef->compareTo = QAccessible_compareTo;
}

//## QAccessibleRelation QAccessibleRelation.new(int value);
KMETHOD QAccessibleRelation_new(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAccessible::RelationFlag i = Int_to(QAccessible::RelationFlag, sfp[1]);
	QAccessible::Relation *ret_v = new QAccessible::Relation(i);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	RETURN_(rptr);
}

//## QAccessibleRelation QAccessibleRelation.and(int mask);
KMETHOD QAccessibleRelation_and(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAccessible::Relation *qp = RawPtr_to(QAccessible::Relation*, sfp[0]);
	if (qp != NULL) {
		int i = Int_to(int, sfp[1]);
		QAccessible::Relation ret = ((*qp) & i);
		QAccessible::Relation *ret_ = new QAccessible::Relation(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAccessibleRelation QAccessibleRelation.iand(QAccessible::QAccessibleRelation other);
KMETHOD QAccessibleRelation_iand(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAccessible::Relation *qp = RawPtr_to(QAccessible::Relation*, sfp[0]);
	if (qp != NULL) {
		QAccessible::Relation *other = RawPtr_to(QAccessible::Relation *, sfp[1]);
		*qp = ((*qp) & (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAccessibleRelation QAccessibleRelation.or(QAccessibleRelation f);
KMETHOD QAccessibleRelation_or(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessible::Relation *qp = RawPtr_to(QAccessible::Relation*, sfp[0]);
	if (qp != NULL) {
		QAccessible::Relation *f = RawPtr_to(QAccessible::Relation*, sfp[1]);
		QAccessible::Relation ret = ((*qp) | (*f));
		QAccessible::Relation *ret_ = new QAccessible::Relation(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAccessibleRelation QAccessibleRelation.ior(QAccessible::QAccessibleRelation other);
KMETHOD QAccessibleRelation_ior(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAccessible::Relation *qp = RawPtr_to(QAccessible::Relation*, sfp[0]);
	if (qp != NULL) {
		QAccessible::Relation *other = RawPtr_to(QAccessible::Relation *, sfp[1]);
		*qp = ((*qp) | (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAccessibleRelation QAccessibleRelation.xor(QAccessibleRelation f);
KMETHOD QAccessibleRelation_xor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessible::Relation *qp = RawPtr_to(QAccessible::Relation*, sfp[0]);
	if (qp != NULL) {
		QAccessible::Relation *f = RawPtr_to(QAccessible::Relation*, sfp[1]);
		QAccessible::Relation ret = ((*qp) ^ (*f));
		QAccessible::Relation *ret_ = new QAccessible::Relation(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAccessibleRelation QAccessibleRelation.ixor(QAccessible::QAccessibleRelation other);
KMETHOD QAccessibleRelation_ixor(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAccessible::Relation *qp = RawPtr_to(QAccessible::Relation*, sfp[0]);
	if (qp != NULL) {
		QAccessible::Relation *other = RawPtr_to(QAccessible::Relation *, sfp[1]);
		*qp = ((*qp) ^ (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## boolean QAccessibleRelation.testFlag(int flag);
KMETHOD QAccessibleRelation_testFlag(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAccessible::Relation *qp = RawPtr_to(QAccessible::Relation *, sfp[0]);
	if (qp != NULL) {
		QAccessible::RelationFlag flag = Int_to(QAccessible::RelationFlag, sfp[1]);
		bool ret = qp->testFlag(flag);
		RETURNb_(ret);
	} else {
		RETURNb_(false);
	}
}

//## int QAccessibleRelation.value();
KMETHOD QAccessibleRelation_value(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAccessible::Relation *qp = RawPtr_to(QAccessible::Relation *, sfp[0]);
	if (qp != NULL) {
		int ret = int(*qp);
		RETURNi_(ret);
	} else {
		RETURNi_(0);
	}
}

static void QAccessibleRelation_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (p->rawptr != NULL) {
		QAccessible::Relation *qp = (QAccessible::Relation *)p->rawptr;
		(void)qp;
		delete qp;
		p->rawptr = NULL;
	}
}

static void QAccessibleRelation_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
	if (p->rawptr != NULL) {
		QAccessible::Relation *qp = (QAccessible::Relation *)p->rawptr;
		(void)qp;
	}
}

static int QAccessibleRelation_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	if (p1->rawptr == NULL || p2->rawptr == NULL) {
		return 1;
	} else {
//		int v1 = int(*(QAccessible::Relation*)p1->rawptr);
//		int v2 = int(*(QAccessible::Relation*)p2->rawptr);
//		return (v1 == v2 ? 0 : 1);
		QAccessible::Relation v1 = *(QAccessible::Relation*)p1->rawptr;
		QAccessible::Relation v2 = *(QAccessible::Relation*)p2->rawptr;
//		return (v1 == v2 ? 0 : 1);
		return (v1 == v2 ? 0 : 1);

	}
}

DEFAPI(void) defQAccessibleRelation(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAccessibleRelation";
	cdef->free = QAccessibleRelation_free;
	cdef->reftrace = QAccessibleRelation_reftrace;
	cdef->compareTo = QAccessibleRelation_compareTo;
}
//## QAccessibleState QAccessibleState.new(int value);
KMETHOD QAccessibleState_new(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAccessible::StateFlag i = Int_to(QAccessible::StateFlag, sfp[1]);
	QAccessible::State *ret_v = new QAccessible::State(i);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	RETURN_(rptr);
}

//## QAccessibleState QAccessibleState.and(int mask);
KMETHOD QAccessibleState_and(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAccessible::State *qp = RawPtr_to(QAccessible::State*, sfp[0]);
	if (qp != NULL) {
		int i = Int_to(int, sfp[1]);
		QAccessible::State ret = ((*qp) & i);
		QAccessible::State *ret_ = new QAccessible::State(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAccessibleState QAccessibleState.iand(QAccessible::QAccessibleState other);
KMETHOD QAccessibleState_iand(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAccessible::State *qp = RawPtr_to(QAccessible::State*, sfp[0]);
	if (qp != NULL) {
		QAccessible::State *other = RawPtr_to(QAccessible::State *, sfp[1]);
		*qp = ((*qp) & (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAccessibleState QAccessibleState.or(QAccessibleState f);
KMETHOD QAccessibleState_or(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessible::State *qp = RawPtr_to(QAccessible::State*, sfp[0]);
	if (qp != NULL) {
		QAccessible::State *f = RawPtr_to(QAccessible::State*, sfp[1]);
		QAccessible::State ret = ((*qp) | (*f));
		QAccessible::State *ret_ = new QAccessible::State(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAccessibleState QAccessibleState.ior(QAccessible::QAccessibleState other);
KMETHOD QAccessibleState_ior(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAccessible::State *qp = RawPtr_to(QAccessible::State*, sfp[0]);
	if (qp != NULL) {
		QAccessible::State *other = RawPtr_to(QAccessible::State *, sfp[1]);
		*qp = ((*qp) | (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAccessibleState QAccessibleState.xor(QAccessibleState f);
KMETHOD QAccessibleState_xor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessible::State *qp = RawPtr_to(QAccessible::State*, sfp[0]);
	if (qp != NULL) {
		QAccessible::State *f = RawPtr_to(QAccessible::State*, sfp[1]);
		QAccessible::State ret = ((*qp) ^ (*f));
		QAccessible::State *ret_ = new QAccessible::State(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QAccessibleState QAccessibleState.ixor(QAccessible::QAccessibleState other);
KMETHOD QAccessibleState_ixor(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAccessible::State *qp = RawPtr_to(QAccessible::State*, sfp[0]);
	if (qp != NULL) {
		QAccessible::State *other = RawPtr_to(QAccessible::State *, sfp[1]);
		*qp = ((*qp) ^ (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## boolean QAccessibleState.testFlag(int flag);
KMETHOD QAccessibleState_testFlag(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAccessible::State *qp = RawPtr_to(QAccessible::State *, sfp[0]);
	if (qp != NULL) {
		QAccessible::StateFlag flag = Int_to(QAccessible::StateFlag, sfp[1]);
		bool ret = qp->testFlag(flag);
		RETURNb_(ret);
	} else {
		RETURNb_(false);
	}
}

//## int QAccessibleState.value();
KMETHOD QAccessibleState_value(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QAccessible::State *qp = RawPtr_to(QAccessible::State *, sfp[0]);
	if (qp != NULL) {
		int ret = int(*qp);
		RETURNi_(ret);
	} else {
		RETURNi_(0);
	}
}

static void QAccessibleState_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (p->rawptr != NULL) {
		QAccessible::State *qp = (QAccessible::State *)p->rawptr;
		(void)qp;
		delete qp;
		p->rawptr = NULL;
	}
}

static void QAccessibleState_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
	if (p->rawptr != NULL) {
		QAccessible::State *qp = (QAccessible::State *)p->rawptr;
		(void)qp;
	}
}

static int QAccessibleState_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	if (p1->rawptr == NULL || p2->rawptr == NULL) {
		return 1;
	} else {
//		int v1 = int(*(QAccessible::State*)p1->rawptr);
//		int v2 = int(*(QAccessible::State*)p2->rawptr);
//		return (v1 == v2 ? 0 : 1);
		QAccessible::State v1 = *(QAccessible::State*)p1->rawptr;
		QAccessible::State v2 = *(QAccessible::State*)p2->rawptr;
//		return (v1 == v2 ? 0 : 1);
		return (v1 == v2 ? 0 : 1);

	}
}

DEFAPI(void) defQAccessibleState(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAccessibleState";
	cdef->free = QAccessibleState_free;
	cdef->reftrace = QAccessibleState_reftrace;
	cdef->compareTo = QAccessibleState_compareTo;
}

//@Virtual void QAccessibleBridge.notifyAccessibilityUpdate(int reason, QAccessibleInterface interface, int child);
KMETHOD QAccessibleBridge_notifyAccessibilityUpdate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleBridge *  qp = RawPtr_to(QAccessibleBridge *, sfp[0]);
	if (qp) {
		int reason = Int_to(int, sfp[1]);
		QAccessibleInterface*  interface = RawPtr_to(QAccessibleInterface*, sfp[2]);
		int child = Int_to(int, sfp[3]);
		qp->notifyAccessibilityUpdate(reason, interface, child);
	}
	RETURNvoid_();
}

//@Virtual void QAccessibleBridge.setRootObject(QAccessibleInterface object);
KMETHOD QAccessibleBridge_setRootObject(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleBridge *  qp = RawPtr_to(QAccessibleBridge *, sfp[0]);
	if (qp) {
		QAccessibleInterface*  object = RawPtr_to(QAccessibleInterface*, sfp[1]);
		qp->setRootObject(object);
	}
	RETURNvoid_();
}

//Array<String> QAccessibleBridge.parents();
KMETHOD QAccessibleBridge_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleBridge *qp = RawPtr_to(QAccessibleBridge*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQAccessibleBridge::DummyQAccessibleBridge()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQAccessibleBridge::~DummyQAccessibleBridge()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAccessibleBridge::setSelf(kRawPtr *ptr)
{
	DummyQAccessibleBridge::self = ptr;
}

bool DummyQAccessibleBridge::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQAccessibleBridge::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAccessibleBridge::event_map->bigin();
	if ((itr = DummyQAccessibleBridge::event_map->find(str)) == DummyQAccessibleBridge::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAccessibleBridge::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAccessibleBridge::slot_map->bigin();
	if ((itr = DummyQAccessibleBridge::slot_map->find(str)) == DummyQAccessibleBridge::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQAccessibleBridge::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAccessibleBridge::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQAccessibleBridge::connection(QObject *o)
{
	QAccessibleBridge *p = dynamic_cast<QAccessibleBridge*>(o);
	if (p != NULL) {
	}
}

KQAccessibleBridge::~KQAccessibleBridge()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAccessibleBridge_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAccessibleBridge *qp = RawPtr_to(KQAccessibleBridge *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAccessibleBridge]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAccessibleBridge]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAccessibleBridge_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAccessibleBridge *qp = RawPtr_to(KQAccessibleBridge *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAccessibleBridge]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAccessibleBridge]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAccessibleBridge_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAccessibleBridge *qp = (KQAccessibleBridge *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAccessibleBridge*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAccessibleBridge_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAccessibleBridge *qp = (KQAccessibleBridge *)p->rawptr;
		KQAccessibleBridge *qp = static_cast<KQAccessibleBridge*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAccessibleBridge_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAccessibleBridge::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQAccessibleBridge(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAccessibleBridge";
	cdef->free = QAccessibleBridge_free;
	cdef->reftrace = QAccessibleBridge_reftrace;
	cdef->compareTo = QAccessibleBridge_compareTo;
}


//QAccessibleEvent QAccessibleEvent.new(int type, int child);
KMETHOD QAccessibleEvent_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleEvent::Type type = Int_to(QAccessibleEvent::Type, sfp[1]);
	int child = Int_to(int, sfp[2]);
	KQAccessibleEvent *ret_v = new KQAccessibleEvent(type, child);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

//int QAccessibleEvent.child();
KMETHOD QAccessibleEvent_child(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleEvent *  qp = RawPtr_to(QAccessibleEvent *, sfp[0]);
	if (qp) {
		int ret_v = qp->child();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QAccessibleEvent.setValue(String text);
KMETHOD QAccessibleEvent_setValue(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleEvent *  qp = RawPtr_to(QAccessibleEvent *, sfp[0]);
	if (qp) {
		const QString text = String_to(const QString, sfp[1]);
		qp->setValue(text);
	}
	RETURNvoid_();
}

//String QAccessibleEvent.getValue();
KMETHOD QAccessibleEvent_getValue(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleEvent *  qp = RawPtr_to(QAccessibleEvent *, sfp[0]);
	if (qp) {
		QString ret_v = qp->value();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}


DummyQAccessibleEvent::DummyQAccessibleEvent()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQAccessibleEvent::~DummyQAccessibleEvent()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAccessibleEvent::setSelf(kRawPtr *ptr)
{
	DummyQAccessibleEvent::self = ptr;
	DummyQEvent::setSelf(ptr);
}

bool DummyQAccessibleEvent::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQEvent::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAccessibleEvent::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAccessibleEvent::event_map->bigin();
	if ((itr = DummyQAccessibleEvent::event_map->find(str)) == DummyQAccessibleEvent::event_map->end()) {
		bool ret = false;
		ret = DummyQEvent::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAccessibleEvent::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAccessibleEvent::slot_map->bigin();
	if ((itr = DummyQAccessibleEvent::slot_map->find(str)) == DummyQAccessibleEvent::slot_map->end()) {
		bool ret = false;
		ret = DummyQEvent::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQAccessibleEvent::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAccessibleEvent::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQEvent::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAccessibleEvent::connection(QObject *o)
{
	QAccessibleEvent *p = dynamic_cast<QAccessibleEvent*>(o);
	if (p != NULL) {
	}
	DummyQEvent::connection(o);
}

KQAccessibleEvent::KQAccessibleEvent(QAccessibleEvent::Type type, int child) : QAccessibleEvent(type, child)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAccessibleEvent();
}

KQAccessibleEvent::~KQAccessibleEvent()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAccessibleEvent_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAccessibleEvent *qp = RawPtr_to(KQAccessibleEvent *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAccessibleEvent]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAccessibleEvent]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAccessibleEvent_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAccessibleEvent *qp = RawPtr_to(KQAccessibleEvent *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAccessibleEvent]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAccessibleEvent]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAccessibleEvent_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAccessibleEvent *qp = (KQAccessibleEvent *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAccessibleEvent*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAccessibleEvent_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAccessibleEvent *qp = (KQAccessibleEvent *)p->rawptr;
		KQAccessibleEvent *qp = static_cast<KQAccessibleEvent*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAccessibleEvent_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAccessibleEvent::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQAccessibleEvent(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAccessibleEvent";
	cdef->free = QAccessibleEvent_free;
	cdef->reftrace = QAccessibleEvent_reftrace;
	cdef->compareTo = QAccessibleEvent_compareTo;
}


//@Virtual String QAccessibleInterface.actionText(int action, int t, int child);
KMETHOD QAccessibleInterface_actionText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleInterface *  qp = RawPtr_to(QAccessibleInterface *, sfp[0]);
	if (qp) {
		int action = Int_to(int, sfp[1]);
		QAccessibleInterface::Text t = Int_to(QAccessibleInterface::Text, sfp[2]);
		int child = Int_to(int, sfp[3]);
		QString ret_v = qp->actionText(action, t, child);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual int QAccessibleInterface.childAt(int x, int y);
KMETHOD QAccessibleInterface_childAt(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleInterface *  qp = RawPtr_to(QAccessibleInterface *, sfp[0]);
	if (qp) {
		int x = Int_to(int, sfp[1]);
		int y = Int_to(int, sfp[2]);
		int ret_v = qp->childAt(x, y);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual int QAccessibleInterface.childCount();
KMETHOD QAccessibleInterface_childCount(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleInterface *  qp = RawPtr_to(QAccessibleInterface *, sfp[0]);
	if (qp) {
		int ret_v = qp->childCount();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual boolean QAccessibleInterface.doAction(int action, int child, QVariantList params);
KMETHOD QAccessibleInterface_doAction(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleInterface *  qp = RawPtr_to(QAccessibleInterface *, sfp[0]);
	if (qp) {
		int action = Int_to(int, sfp[1]);
		int child = Int_to(int, sfp[2]);
		const QVariantList  params = *RawPtr_to(const QVariantList *, sfp[3]);
		bool ret_v = qp->doAction(action, child, params);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual int QAccessibleInterface.indexOfChild(QAccessibleInterface child);
KMETHOD QAccessibleInterface_indexOfChild(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleInterface *  qp = RawPtr_to(QAccessibleInterface *, sfp[0]);
	if (qp) {
		const QAccessibleInterface*  child = RawPtr_to(const QAccessibleInterface*, sfp[1]);
		int ret_v = qp->indexOfChild(child);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QVariant QAccessibleInterface.invokeMethod(int method, int child, QVariantList params);
KMETHOD QAccessibleInterface_invokeMethod(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleInterface *  qp = RawPtr_to(QAccessibleInterface *, sfp[0]);
	if (qp) {
		QAccessibleInterface::Method method = Int_to(QAccessibleInterface::Method, sfp[1]);
		int child = Int_to(int, sfp[2]);
		const QVariantList  params = *RawPtr_to(const QVariantList *, sfp[3]);
		QVariant ret_v = qp->invokeMethod(method, child, params);
		QVariant *ret_v_ = new QVariant(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual int QAccessibleInterface.navigate(int relation, int entry, QAccessibleInterface target);
KMETHOD QAccessibleInterface_navigate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleInterface *  qp = RawPtr_to(QAccessibleInterface *, sfp[0]);
	if (qp) {
		QAccessibleInterface::RelationFlag relation = Int_to(QAccessibleInterface::RelationFlag, sfp[1]);
		int entry = Int_to(int, sfp[2]);
		QAccessibleInterface**  target = RawPtr_to(QAccessibleInterface**, sfp[3]);
		int ret_v = qp->navigate(relation, entry, target);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual QObject QAccessibleInterface.object();
KMETHOD QAccessibleInterface_object(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleInterface *  qp = RawPtr_to(QAccessibleInterface *, sfp[0]);
	if (qp) {
		QObject* ret_v = qp->object();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QObject*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual QRect QAccessibleInterface.rect(int child);
KMETHOD QAccessibleInterface_rect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleInterface *  qp = RawPtr_to(QAccessibleInterface *, sfp[0]);
	if (qp) {
		int child = Int_to(int, sfp[1]);
		QRect ret_v = qp->rect(child);
		QRect *ret_v_ = new QRect(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual QAccessibleRelation QAccessibleInterface.relationTo(int child, QAccessibleInterface other, int otherChild);
KMETHOD QAccessibleInterface_relationTo(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleInterface *  qp = RawPtr_to(QAccessibleInterface *, sfp[0]);
	if (qp) {
		int child = Int_to(int, sfp[1]);
		const QAccessibleInterface*  other = RawPtr_to(const QAccessibleInterface*, sfp[2]);
		int otherChild = Int_to(int, sfp[3]);
		QAccessible::Relation ret_v = qp->relationTo(child, other, otherChild);
		QAccessible::Relation *ret_v_ = new QAccessible::Relation(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual int QAccessibleInterface.role(int child);
KMETHOD QAccessibleInterface_role(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleInterface *  qp = RawPtr_to(QAccessibleInterface *, sfp[0]);
	if (qp) {
		int child = Int_to(int, sfp[1]);
		QAccessibleInterface::Role ret_v = qp->role(child);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual void QAccessibleInterface.setText(int t, int child, String text);
KMETHOD QAccessibleInterface_setText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleInterface *  qp = RawPtr_to(QAccessibleInterface *, sfp[0]);
	if (qp) {
		QAccessibleInterface::Text t = Int_to(QAccessibleInterface::Text, sfp[1]);
		int child = Int_to(int, sfp[2]);
		const QString text = String_to(const QString, sfp[3]);
		qp->setText(t, child, text);
	}
	RETURNvoid_();
}

//@Virtual QAccessibleState QAccessibleInterface.state(int child);
KMETHOD QAccessibleInterface_state(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleInterface *  qp = RawPtr_to(QAccessibleInterface *, sfp[0]);
	if (qp) {
		int child = Int_to(int, sfp[1]);
		QAccessible::State ret_v = qp->state(child);
		QAccessible::State *ret_v_ = new QAccessible::State(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual String QAccessibleInterface.getText(int t, int child);
KMETHOD QAccessibleInterface_getText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleInterface *  qp = RawPtr_to(QAccessibleInterface *, sfp[0]);
	if (qp) {
		QAccessibleInterface::Text t = Int_to(QAccessibleInterface::Text, sfp[1]);
		int child = Int_to(int, sfp[2]);
		QString ret_v = qp->text(t, child);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual int QAccessibleInterface.userActionCount(int child);
KMETHOD QAccessibleInterface_userActionCount(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleInterface *  qp = RawPtr_to(QAccessibleInterface *, sfp[0]);
	if (qp) {
		int child = Int_to(int, sfp[1]);
		int ret_v = qp->userActionCount(child);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}


DummyQAccessibleInterface::DummyQAccessibleInterface()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQAccessibleInterface::~DummyQAccessibleInterface()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAccessibleInterface::setSelf(kRawPtr *ptr)
{
	DummyQAccessibleInterface::self = ptr;
	DummyQAccessible::setSelf(ptr);
}

bool DummyQAccessibleInterface::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQAccessible::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAccessibleInterface::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAccessibleInterface::event_map->bigin();
	if ((itr = DummyQAccessibleInterface::event_map->find(str)) == DummyQAccessibleInterface::event_map->end()) {
		bool ret = false;
		ret = DummyQAccessible::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAccessibleInterface::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAccessibleInterface::slot_map->bigin();
	if ((itr = DummyQAccessibleInterface::slot_map->find(str)) == DummyQAccessibleInterface::slot_map->end()) {
		bool ret = false;
		ret = DummyQAccessible::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQAccessibleInterface::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAccessibleInterface::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQAccessible::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAccessibleInterface::connection(QObject *o)
{
	QAccessibleInterface *p = dynamic_cast<QAccessibleInterface*>(o);
	if (p != NULL) {
	}
	DummyQAccessible::connection(o);
}

KQAccessibleInterface::~KQAccessibleInterface()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAccessibleInterface_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAccessibleInterface *qp = RawPtr_to(KQAccessibleInterface *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAccessibleInterface]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAccessibleInterface]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAccessibleInterface_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAccessibleInterface *qp = RawPtr_to(KQAccessibleInterface *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAccessibleInterface]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAccessibleInterface]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAccessibleInterface_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAccessibleInterface *qp = (KQAccessibleInterface *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAccessibleInterface*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAccessibleInterface_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAccessibleInterface *qp = (KQAccessibleInterface *)p->rawptr;
		KQAccessibleInterface *qp = static_cast<KQAccessibleInterface*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAccessibleInterface_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAccessibleInterface::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQAccessibleInterface(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAccessibleInterface";
	cdef->free = QAccessibleInterface_free;
	cdef->reftrace = QAccessibleInterface_reftrace;
	cdef->compareTo = QAccessibleInterface_compareTo;
}


//@Virtual @Override String QAccessibleObject.actionText(int action, int t, int child);
KMETHOD QAccessibleObject_actionText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleObject *  qp = RawPtr_to(QAccessibleObject *, sfp[0]);
	if (qp) {
		int action = Int_to(int, sfp[1]);
		QAccessibleObject::Text t = Int_to(QAccessibleObject::Text, sfp[2]);
		int child = Int_to(int, sfp[3]);
		QString ret_v = qp->actionText(action, t, child);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override boolean QAccessibleObject.doAction(int action, int child, QVariantList params);
KMETHOD QAccessibleObject_doAction(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleObject *  qp = RawPtr_to(QAccessibleObject *, sfp[0]);
	if (qp) {
		int action = Int_to(int, sfp[1]);
		int child = Int_to(int, sfp[2]);
		const QVariantList  params = *RawPtr_to(const QVariantList *, sfp[3]);
		bool ret_v = qp->doAction(action, child, params);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override QObject QAccessibleObject.object();
KMETHOD QAccessibleObject_object(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleObject *  qp = RawPtr_to(QAccessibleObject *, sfp[0]);
	if (qp) {
		QObject* ret_v = qp->object();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QObject*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override QRect QAccessibleObject.rect(int child);
KMETHOD QAccessibleObject_rect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleObject *  qp = RawPtr_to(QAccessibleObject *, sfp[0]);
	if (qp) {
		int child = Int_to(int, sfp[1]);
		QRect ret_v = qp->rect(child);
		QRect *ret_v_ = new QRect(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override void QAccessibleObject.setText(int t, int child, String text);
KMETHOD QAccessibleObject_setText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleObject *  qp = RawPtr_to(QAccessibleObject *, sfp[0]);
	if (qp) {
		QAccessibleObject::Text t = Int_to(QAccessibleObject::Text, sfp[1]);
		int child = Int_to(int, sfp[2]);
		const QString text = String_to(const QString, sfp[3]);
		qp->setText(t, child, text);
	}
	RETURNvoid_();
}

//@Virtual @Override int QAccessibleObject.userActionCount(int child);
KMETHOD QAccessibleObject_userActionCount(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleObject *  qp = RawPtr_to(QAccessibleObject *, sfp[0]);
	if (qp) {
		int child = Int_to(int, sfp[1]);
		int ret_v = qp->userActionCount(child);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//

DummyQAccessibleObject::DummyQAccessibleObject()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQAccessibleObject::~DummyQAccessibleObject()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAccessibleObject::setSelf(kRawPtr *ptr)
{
	DummyQAccessibleObject::self = ptr;
	DummyQAccessibleInterface::setSelf(ptr);
}

bool DummyQAccessibleObject::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQAccessibleInterface::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAccessibleObject::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAccessibleObject::event_map->bigin();
	if ((itr = DummyQAccessibleObject::event_map->find(str)) == DummyQAccessibleObject::event_map->end()) {
		bool ret = false;
		ret = DummyQAccessibleInterface::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAccessibleObject::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAccessibleObject::slot_map->bigin();
	if ((itr = DummyQAccessibleObject::slot_map->find(str)) == DummyQAccessibleObject::slot_map->end()) {
		bool ret = false;
		ret = DummyQAccessibleInterface::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQAccessibleObject::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAccessibleObject::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQAccessibleInterface::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAccessibleObject::connection(QObject *o)
{
	QAccessibleObject *p = dynamic_cast<QAccessibleObject*>(o);
	if (p != NULL) {
	}
	DummyQAccessibleInterface::connection(o);
}

KQAccessibleObject::KQAccessibleObject(QObject* object) : QAccessibleObject(object)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAccessibleObject();
}

KQAccessibleObject::~KQAccessibleObject()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAccessibleObject_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAccessibleObject *qp = RawPtr_to(KQAccessibleObject *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAccessibleObject]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAccessibleObject]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAccessibleObject_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAccessibleObject *qp = RawPtr_to(KQAccessibleObject *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAccessibleObject]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAccessibleObject]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAccessibleObject_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAccessibleObject *qp = (KQAccessibleObject *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
//			delete (QAccessibleObject*)qp;
//			p->rawptr = NULL;
		}
	}
}
static void QAccessibleObject_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAccessibleObject *qp = (KQAccessibleObject *)p->rawptr;
		KQAccessibleObject *qp = static_cast<KQAccessibleObject*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAccessibleObject_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAccessibleObject::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQAccessibleObject(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAccessibleObject";
	cdef->free = QAccessibleObject_free;
	cdef->reftrace = QAccessibleObject_reftrace;
	cdef->compareTo = QAccessibleObject_compareTo;
}


//@Virtual @Override String QAccessibleWidget.actionText(int action, int t, int child);
KMETHOD QAccessibleWidget_actionText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleWidget *  qp = RawPtr_to(QAccessibleWidget *, sfp[0]);
	if (qp) {
		int action = Int_to(int, sfp[1]);
		QAccessibleWidget::Text t = Int_to(QAccessibleWidget::Text, sfp[2]);
		int child = Int_to(int, sfp[3]);
		QString ret_v = qp->actionText(action, t, child);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override int QAccessibleWidget.childAt(int x, int y);
KMETHOD QAccessibleWidget_childAt(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleWidget *  qp = RawPtr_to(QAccessibleWidget *, sfp[0]);
	if (qp) {
		int x = Int_to(int, sfp[1]);
		int y = Int_to(int, sfp[2]);
		int ret_v = qp->childAt(x, y);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual @Override int QAccessibleWidget.childCount();
KMETHOD QAccessibleWidget_childCount(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleWidget *  qp = RawPtr_to(QAccessibleWidget *, sfp[0]);
	if (qp) {
		int ret_v = qp->childCount();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual @Override boolean QAccessibleWidget.doAction(int action, int child, QVariantList params);
KMETHOD QAccessibleWidget_doAction(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleWidget *  qp = RawPtr_to(QAccessibleWidget *, sfp[0]);
	if (qp) {
		int action = Int_to(int, sfp[1]);
		int child = Int_to(int, sfp[2]);
		const QVariantList  params = *RawPtr_to(const QVariantList *, sfp[3]);
		bool ret_v = qp->doAction(action, child, params);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override int QAccessibleWidget.indexOfChild(QAccessibleInterface child);
KMETHOD QAccessibleWidget_indexOfChild(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleWidget *  qp = RawPtr_to(QAccessibleWidget *, sfp[0]);
	if (qp) {
		const QAccessibleInterface*  child = RawPtr_to(const QAccessibleInterface*, sfp[1]);
		int ret_v = qp->indexOfChild(child);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual @Override int QAccessibleWidget.navigate(int relation, int entry, QAccessibleInterface target);
KMETHOD QAccessibleWidget_navigate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleWidget *  qp = RawPtr_to(QAccessibleWidget *, sfp[0]);
	if (qp) {
		QAccessibleWidget::RelationFlag relation = Int_to(QAccessibleWidget::RelationFlag, sfp[1]);
		int entry = Int_to(int, sfp[2]);
		QAccessibleInterface**  target = RawPtr_to(QAccessibleInterface**, sfp[3]);
		int ret_v = qp->navigate(relation, entry, target);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual @Override QRect QAccessibleWidget.rect(int child);
KMETHOD QAccessibleWidget_rect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleWidget *  qp = RawPtr_to(QAccessibleWidget *, sfp[0]);
	if (qp) {
		int child = Int_to(int, sfp[1]);
		QRect ret_v = qp->rect(child);
		QRect *ret_v_ = new QRect(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override QAccessibleRelation QAccessibleWidget.relationTo(int child, QAccessibleInterface other, int otherChild);
KMETHOD QAccessibleWidget_relationTo(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleWidget *  qp = RawPtr_to(QAccessibleWidget *, sfp[0]);
	if (qp) {
		int child = Int_to(int, sfp[1]);
		const QAccessibleInterface*  other = RawPtr_to(const QAccessibleInterface*, sfp[2]);
		int otherChild = Int_to(int, sfp[3]);
		QAccessible::Relation ret_v = qp->relationTo(child, other, otherChild);
		QAccessible::Relation *ret_v_ = new QAccessible::Relation(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override int QAccessibleWidget.role(int child);
KMETHOD QAccessibleWidget_role(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleWidget *  qp = RawPtr_to(QAccessibleWidget *, sfp[0]);
	if (qp) {
		int child = Int_to(int, sfp[1]);
		QAccessibleWidget::Role ret_v = qp->role(child);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual @Override QAccessibleState QAccessibleWidget.state(int child);
KMETHOD QAccessibleWidget_state(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleWidget *  qp = RawPtr_to(QAccessibleWidget *, sfp[0]);
	if (qp) {
		int child = Int_to(int, sfp[1]);
		QAccessible::State ret_v = qp->state(child);
		QAccessible::State *ret_v_ = new QAccessible::State(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override String QAccessibleWidget.text(int t, int child);
KMETHOD QAccessibleWidget_text(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleWidget *  qp = RawPtr_to(QAccessibleWidget *, sfp[0]);
	if (qp) {
		QAccessibleWidget::Text t = Int_to(QAccessibleWidget::Text, sfp[1]);
		int child = Int_to(int, sfp[2]);
		QString ret_v = qp->text(t, child);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override int QAccessibleWidget.userActionCount(int child);
KMETHOD QAccessibleWidget_userActionCount(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAccessibleWidget *  qp = RawPtr_to(QAccessibleWidget *, sfp[0]);
	if (qp) {
		int child = Int_to(int, sfp[1]);
		int ret_v = qp->userActionCount(child);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QAccessibleWidget QAccessibleWidget.new(QWidget w, int role, String name);
KMETHOD QAccessibleWidget_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QWidget*  w = RawPtr_to(QWidget*, sfp[1]);
	QAccessibleWidget::Role role = Int_to(QAccessibleWidget::Role, sfp[2]);
	const QString name = String_to(const QString, sfp[3]);
	KQAccessibleWidget *ret_v = new KQAccessibleWidget(w, role, name);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}


DummyQAccessibleWidget::DummyQAccessibleWidget()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQAccessibleWidget::~DummyQAccessibleWidget()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAccessibleWidget::setSelf(kRawPtr *ptr)
{
	DummyQAccessibleWidget::self = ptr;
	DummyQAccessibleObject::setSelf(ptr);
}

bool DummyQAccessibleWidget::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQAccessibleObject::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAccessibleWidget::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAccessibleWidget::event_map->bigin();
	if ((itr = DummyQAccessibleWidget::event_map->find(str)) == DummyQAccessibleWidget::event_map->end()) {
		bool ret = false;
		ret = DummyQAccessibleObject::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAccessibleWidget::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAccessibleWidget::slot_map->bigin();
	if ((itr = DummyQAccessibleWidget::slot_map->find(str)) == DummyQAccessibleWidget::slot_map->end()) {
		bool ret = false;
		ret = DummyQAccessibleObject::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQAccessibleWidget::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAccessibleWidget::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQAccessibleObject::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAccessibleWidget::connection(QObject *o)
{
	QAccessibleWidget *p = dynamic_cast<QAccessibleWidget*>(o);
	if (p != NULL) {
	}
	DummyQAccessibleObject::connection(o);
}

KQAccessibleWidget::KQAccessibleWidget(QWidget* w, QAccessibleWidget::Role role, const QString name) : QAccessibleWidget(w, role, name)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAccessibleWidget();
}

KQAccessibleWidget::~KQAccessibleWidget()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAccessibleWidget_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAccessibleWidget *qp = RawPtr_to(KQAccessibleWidget *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAccessibleWidget]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAccessibleWidget]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAccessibleWidget_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAccessibleWidget *qp = RawPtr_to(KQAccessibleWidget *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAccessibleWidget]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAccessibleWidget]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAccessibleWidget_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAccessibleWidget *qp = (KQAccessibleWidget *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
//			delete (QAccessibleWidget*)qp;
//			p->rawptr = NULL;
		}
	}
}
static void QAccessibleWidget_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAccessibleWidget *qp = (KQAccessibleWidget *)p->rawptr;
		KQAccessibleWidget *qp = static_cast<KQAccessibleWidget*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAccessibleWidget_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAccessibleWidget::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQAccessibleWidget(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAccessibleWidget";
	cdef->free = QAccessibleWidget_free;
	cdef->reftrace = QAccessibleWidget_reftrace;
	cdef->compareTo = QAccessibleWidget_compareTo;
}


//QAction QAction.new(QObject parent);
KMETHOD QAction_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QObject*  parent = RawPtr_to(QObject*, sfp[1]);
	KQAction *ret_v = new KQAction(parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QAction QAction.new(String text, QObject parent);
KMETHOD QAction_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QString text = String_to(const QString, sfp[1]);
	QObject*  parent = RawPtr_to(QObject*, sfp[2]);
	KQAction *ret_v = new KQAction(text, parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QAction QAction.new(QIcon icon, String text, QObject parent);
KMETHOD QAction_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QIcon  icon = *RawPtr_to(const QIcon *, sfp[1]);
	const QString text = String_to(const QString, sfp[2]);
	QObject*  parent = RawPtr_to(QObject*, sfp[3]);
	KQAction *ret_v = new KQAction(icon, text, parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//QActionGroup QAction.getActionGroup();
KMETHOD QAction_getActionGroup(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QActionGroup* ret_v = qp->actionGroup();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QActionGroup*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QAction.activate(int event);
KMETHOD QAction_activate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QAction::ActionEvent event = Int_to(QAction::ActionEvent, sfp[1]);
		qp->activate(event);
	}
	RETURNvoid_();
}

//Array<QGraphicsWidget> QAction.associatedGraphicsWidgets();
KMETHOD QAction_associatedGraphicsWidgets(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QList<QGraphicsWidget*> ret_v = qp->associatedGraphicsWidgets();
		int list_size = ret_v.size();
		kArray *a = new_Array0(ctx, list_size);
		kclass_t cid = knh_getcid(ctx, STEXT("QGraphicsWidget"));
		for (int n = 0; n < list_size; n++) {
			kRawPtr *p = new_RawPtr(ctx, ClassTBL(cid), ret_v[n]);
			knh_Array_add(ctx, a, (kObject *)p);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}
	

//Array<QWidget> QAction.associatedWidgets();
KMETHOD QAction_associatedWidgets(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QList<QWidget*> ret_v = qp->associatedWidgets();
		int list_size = ret_v.size();
		kArray *a = new_Array0(ctx, list_size);
		kclass_t cid = knh_getcid(ctx, STEXT("QWidget"));
		for (int n = 0; n < list_size; n++) {
			kRawPtr *p = new_RawPtr(ctx, ClassTBL(cid), ret_v[n]);
			knh_Array_add(ctx, a, (kObject *)p);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}
	

//boolean QAction.getAutoRepeat();
KMETHOD QAction_getAutoRepeat(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		bool ret_v = qp->autoRepeat();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//QVariant QAction.getData();
KMETHOD QAction_getData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QVariant ret_v = qp->data();
		QVariant *ret_v_ = new QVariant(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QFont QAction.getFont();
KMETHOD QAction_getFont(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QFont ret_v = qp->font();
		QFont *ret_v_ = new QFont(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QIcon QAction.getIcon();
KMETHOD QAction_getIcon(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QIcon ret_v = qp->icon();
		QIcon *ret_v_ = new QIcon(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QAction.getIconText();
KMETHOD QAction_getIconText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QString ret_v = qp->iconText();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QAction.isCheckable();
KMETHOD QAction_isCheckable(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isCheckable();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAction.isChecked();
KMETHOD QAction_isChecked(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isChecked();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAction.isEnabled();
KMETHOD QAction_isEnabled(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isEnabled();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAction.isIconVisibleInMenu();
KMETHOD QAction_isIconVisibleInMenu(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isIconVisibleInMenu();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAction.isSeparator();
KMETHOD QAction_isSeparator(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isSeparator();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAction.isVisible();
KMETHOD QAction_isVisible(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isVisible();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//QMenu QAction.getMenu();
KMETHOD QAction_getMenu(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QMenu* ret_v = qp->menu();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QMenu*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QAction.getMenuRole();
KMETHOD QAction_getMenuRole(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QAction::MenuRole ret_v = qp->menuRole();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QWidget QAction.parentWidget();
KMETHOD QAction_parentWidget(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QWidget* ret_v = qp->parentWidget();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QWidget*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QAction.getPriority();
KMETHOD QAction_getPriority(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QAction::Priority ret_v = qp->priority();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QAction.setActionGroup(QActionGroup group);
KMETHOD QAction_setActionGroup(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QActionGroup*  group = RawPtr_to(QActionGroup*, sfp[1]);
		qp->setActionGroup(group);
	}
	RETURNvoid_();
}

//void QAction.setAutoRepeat(boolean arg0);
KMETHOD QAction_setAutoRepeat(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setAutoRepeat(arg0);
	}
	RETURNvoid_();
}

//void QAction.setCheckable(boolean arg0);
KMETHOD QAction_setCheckable(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setCheckable(arg0);
	}
	RETURNvoid_();
}

//void QAction.setData(QVariant userData);
KMETHOD QAction_setData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		const QVariant  userData = *RawPtr_to(const QVariant *, sfp[1]);
		qp->setData(userData);
	}
	RETURNvoid_();
}

//void QAction.setFont(QFont font);
KMETHOD QAction_setFont(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		const QFont  font = *RawPtr_to(const QFont *, sfp[1]);
		qp->setFont(font);
	}
	RETURNvoid_();
}

//void QAction.setIcon(QIcon icon);
KMETHOD QAction_setIcon(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		const QIcon  icon = *RawPtr_to(const QIcon *, sfp[1]);
		qp->setIcon(icon);
	}
	RETURNvoid_();
}

//void QAction.setIconText(String text);
KMETHOD QAction_setIconText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		const QString text = String_to(const QString, sfp[1]);
		qp->setIconText(text);
	}
	RETURNvoid_();
}

//void QAction.setIconVisibleInMenu(boolean visible);
KMETHOD QAction_setIconVisibleInMenu(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		bool visible = Boolean_to(bool, sfp[1]);
		qp->setIconVisibleInMenu(visible);
	}
	RETURNvoid_();
}

//void QAction.setMenu(QMenu menu);
KMETHOD QAction_setMenu(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QMenu*  menu = RawPtr_to(QMenu*, sfp[1]);
		qp->setMenu(menu);
	}
	RETURNvoid_();
}

//void QAction.setMenuRole(int menuRole);
KMETHOD QAction_setMenuRole(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QAction::MenuRole menuRole = Int_to(QAction::MenuRole, sfp[1]);
		qp->setMenuRole(menuRole);
	}
	RETURNvoid_();
}

//void QAction.setPriority(int priority);
KMETHOD QAction_setPriority(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QAction::Priority priority = Int_to(QAction::Priority, sfp[1]);
		qp->setPriority(priority);
	}
	RETURNvoid_();
}

//void QAction.setSeparator(boolean b);
KMETHOD QAction_setSeparator(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		bool b = Boolean_to(bool, sfp[1]);
		qp->setSeparator(b);
	}
	RETURNvoid_();
}

//void QAction.setShortcut(QKeySequence shortcut);
KMETHOD QAction_setShortcut(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		const QKeySequence  shortcut = *RawPtr_to(const QKeySequence *, sfp[1]);
		qp->setShortcut(shortcut);
	}
	RETURNvoid_();
}

//void QAction.setShortcutContext(int context);
KMETHOD QAction_setShortcutContext(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		Qt::ShortcutContext context = Int_to(Qt::ShortcutContext, sfp[1]);
		qp->setShortcutContext(context);
	}
	RETURNvoid_();
}

//void QAction.setShortcuts(Array<QKeySequence> shortcuts);
KMETHOD QAction_setShortcuts(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		kArray *a = sfp[1].a;
		int asize = knh_Array_size(a);
		QList<QKeySequence> shortcuts;
		for (int n = 0; n < asize; n++) {
			kRawPtr *p = (kRawPtr*)(a->list[n]);
			shortcuts.append(*(QKeySequence*)p->rawptr);
		}
		qp->setShortcuts(shortcuts);
	}
	RETURNvoid_();
}

/*
//void QAction.setShortcuts(int key);
KMETHOD QAction_setShortcuts(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QKeySequence::StandardKey key = Int_to(QKeySequence::StandardKey, sfp[1]);
		qp->setShortcuts(key);
	}
	RETURNvoid_();
}
*/
//void QAction.setSoftKeyRole(int softKeyRole);
KMETHOD QAction_setSoftKeyRole(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QAction::SoftKeyRole softKeyRole = Int_to(QAction::SoftKeyRole, sfp[1]);
		qp->setSoftKeyRole(softKeyRole);
	}
	RETURNvoid_();
}

//void QAction.setStatusTip(String statusTip);
KMETHOD QAction_setStatusTip(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		const QString statusTip = String_to(const QString, sfp[1]);
		qp->setStatusTip(statusTip);
	}
	RETURNvoid_();
}

//void QAction.setText(String text);
KMETHOD QAction_setText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		const QString text = String_to(const QString, sfp[1]);
		qp->setText(text);
	}
	RETURNvoid_();
}

//void QAction.setToolTip(String tip);
KMETHOD QAction_setToolTip(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		const QString tip = String_to(const QString, sfp[1]);
		qp->setToolTip(tip);
	}
	RETURNvoid_();
}

//void QAction.setWhatsThis(String what);
KMETHOD QAction_setWhatsThis(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		const QString what = String_to(const QString, sfp[1]);
		qp->setWhatsThis(what);
	}
	RETURNvoid_();
}

//QKeySequence QAction.getShortcut();
KMETHOD QAction_getShortcut(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QKeySequence ret_v = qp->shortcut();
		QKeySequence *ret_v_ = new QKeySequence(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QAction.getShortcutContext();
KMETHOD QAction_getShortcutContext(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		Qt::ShortcutContext ret_v = qp->shortcutContext();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//Array<QKeySequence> QAction.getShortcuts();
KMETHOD QAction_getShortcuts(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QList<QKeySequence> ret_v = qp->shortcuts();
		int list_size = ret_v.size();
		kArray *a = new_Array0(ctx, list_size);
		kclass_t cid = knh_getcid(ctx, STEXT("QKeySequence"));
		for (int n = 0; n < list_size; n++) {
			QKeySequence *ret_v_ = new QKeySequence(ret_v[n]);
			kRawPtr *p = new_RawPtr(ctx, ClassTBL(cid), ret_v_);
			knh_Array_add(ctx, a, (kObject *)p);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}
	

//boolean QAction.showStatusText(QWidget widget);
KMETHOD QAction_showStatusText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QWidget*  widget = RawPtr_to(QWidget*, sfp[1]);
		bool ret_v = qp->showStatusText(widget);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//int QAction.getSoftKeyRole();
KMETHOD QAction_getSoftKeyRole(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QAction::SoftKeyRole ret_v = qp->softKeyRole();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//String QAction.getStatusTip();
KMETHOD QAction_getStatusTip(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QString ret_v = qp->statusTip();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QAction.getText();
KMETHOD QAction_getText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QString ret_v = qp->text();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QAction.getToolTip();
KMETHOD QAction_getToolTip(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QString ret_v = qp->toolTip();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QAction.getWhatsThis();
KMETHOD QAction_getWhatsThis(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		QString ret_v = qp->whatsThis();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QAction.hover();
KMETHOD QAction_hover(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		qp->hover();
	}
	RETURNvoid_();
}

//void QAction.setChecked(boolean arg0);
KMETHOD QAction_setChecked(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setChecked(arg0);
	}
	RETURNvoid_();
}

//void QAction.setDisabled(boolean b);
KMETHOD QAction_setDisabled(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		bool b = Boolean_to(bool, sfp[1]);
		qp->setDisabled(b);
	}
	RETURNvoid_();
}

//void QAction.setEnabled(boolean arg0);
KMETHOD QAction_setEnabled(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setEnabled(arg0);
	}
	RETURNvoid_();
}

//void QAction.setVisible(boolean arg0);
KMETHOD QAction_setVisible(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setVisible(arg0);
	}
	RETURNvoid_();
}

//void QAction.toggle();
KMETHOD QAction_toggle(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		qp->toggle();
	}
	RETURNvoid_();
}

//void QAction.trigger();
KMETHOD QAction_trigger(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAction *  qp = RawPtr_to(QAction *, sfp[0]);
	if (qp) {
		qp->trigger();
	}
	RETURNvoid_();
}


DummyQAction::DummyQAction()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	changed_func = NULL;
	hovered_func = NULL;
	toggled_func = NULL;
	triggered_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("changed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("hovered", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("toggled", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("triggered", NULL));
}
DummyQAction::~DummyQAction()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAction::setSelf(kRawPtr *ptr)
{
	DummyQAction::self = ptr;
	DummyQObject::setSelf(ptr);
}

bool DummyQAction::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQObject::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQAction::changedSlot()
{
	if (changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, changed_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAction::hoveredSlot()
{
	if (hovered_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, hovered_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQAction::toggledSlot(bool checked)
{
	if (toggled_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].bvalue = checked;
		knh_Func_invoke(lctx, toggled_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAction::triggeredSlot(bool checked)
{
	if (triggered_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].bvalue = checked;
		knh_Func_invoke(lctx, triggered_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQAction::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAction::event_map->bigin();
	if ((itr = DummyQAction::event_map->find(str)) == DummyQAction::event_map->end()) {
		bool ret = false;
		ret = DummyQObject::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAction::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAction::slot_map->bigin();
	if ((itr = DummyQAction::slot_map->find(str)) == DummyQAction::slot_map->end()) {
		bool ret = false;
		ret = DummyQObject::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		changed_func = (*slot_map)["changed"];
		hovered_func = (*slot_map)["hovered"];
		toggled_func = (*slot_map)["toggled"];
		triggered_func = (*slot_map)["triggered"];
		return true;
	}
}

kObject** DummyQAction::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAction::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 5;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, changed_func);
	KNH_ADDNNREF(ctx, hovered_func);
	KNH_ADDNNREF(ctx, toggled_func);
	KNH_ADDNNREF(ctx, triggered_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQObject::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQAction::connection(QObject *o)
{
	QAction *p = dynamic_cast<QAction*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(changed()), this, SLOT(changedSlot()));
		connect(p, SIGNAL(hovered()), this, SLOT(hoveredSlot()));
		connect(p, SIGNAL(toggled(bool)), this, SLOT(toggledSlot(bool)));
		connect(p, SIGNAL(triggered(bool)), this, SLOT(triggeredSlot(bool)));
	}
	DummyQObject::connection(o);
}

KQAction::KQAction(QObject* parent) : QAction(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAction();
	dummy->connection((QObject*)this);
}

KQAction::~KQAction()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAction_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAction *qp = RawPtr_to(KQAction *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAction]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAction]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAction_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAction *qp = RawPtr_to(KQAction *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAction]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAction]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAction_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAction *qp = (KQAction *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAction*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAction_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAction *qp = (KQAction *)p->rawptr;
		KQAction *qp = static_cast<KQAction*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAction_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQAction::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQAction::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QAction::event(event);
		return false;
	}
//	QAction::event(event);
	return true;
}

static knh_IntData_t QActionConstInt[] = {
	{"Trigger", QAction::Trigger},
	{"Hover", QAction::Hover},
	{"NoRole", QAction::NoRole},
	{"TextHeuristicRole", QAction::TextHeuristicRole},
	{"ApplicationSpecificRole", QAction::ApplicationSpecificRole},
	{"AboutQtRole", QAction::AboutQtRole},
	{"AboutRole", QAction::AboutRole},
	{"PreferencesRole", QAction::PreferencesRole},
	{"QuitRole", QAction::QuitRole},
	{"LowPriority", QAction::LowPriority},
	{"NormalPriority", QAction::NormalPriority},
	{"HighPriority", QAction::HighPriority},
	{"NoSoftKey", QAction::NoSoftKey},
	{"PositiveSoftKey", QAction::PositiveSoftKey},
	{"NegativeSoftKey", QAction::NegativeSoftKey},
	{"SelectSoftKey", QAction::SelectSoftKey},
	{NULL, 0}
};

DEFAPI(void) constQAction(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QActionConstInt);
}


DEFAPI(void) defQAction(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAction";
	cdef->free = QAction_free;
	cdef->reftrace = QAction_reftrace;
	cdef->compareTo = QAction_compareTo;
}


//QActionEvent QActionEvent.new(int type, QAction action, QAction before);
KMETHOD QActionEvent_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	int type = Int_to(int, sfp[1]);
	QAction*  action = RawPtr_to(QAction*, sfp[2]);
	QAction*  before = RawPtr_to(QAction*, sfp[3]);
	KQActionEvent *ret_v = new KQActionEvent(type, action, before);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

//QAction QActionEvent.action();
KMETHOD QActionEvent_action(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QActionEvent *  qp = RawPtr_to(QActionEvent *, sfp[0]);
	if (qp) {
		QAction* ret_v = qp->action();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAction*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QAction QActionEvent.before();
KMETHOD QActionEvent_before(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QActionEvent *  qp = RawPtr_to(QActionEvent *, sfp[0]);
	if (qp) {
		QAction* ret_v = qp->before();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAction*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}


DummyQActionEvent::DummyQActionEvent()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQActionEvent::~DummyQActionEvent()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQActionEvent::setSelf(kRawPtr *ptr)
{
	DummyQActionEvent::self = ptr;
	DummyQEvent::setSelf(ptr);
}

bool DummyQActionEvent::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQEvent::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQActionEvent::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQActionEvent::event_map->bigin();
	if ((itr = DummyQActionEvent::event_map->find(str)) == DummyQActionEvent::event_map->end()) {
		bool ret = false;
		ret = DummyQEvent::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQActionEvent::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQActionEvent::slot_map->bigin();
	if ((itr = DummyQActionEvent::slot_map->find(str)) == DummyQActionEvent::slot_map->end()) {
		bool ret = false;
		ret = DummyQEvent::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQActionEvent::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQActionEvent::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQEvent::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQActionEvent::connection(QObject *o)
{
	QActionEvent *p = dynamic_cast<QActionEvent*>(o);
	if (p != NULL) {
	}
	DummyQEvent::connection(o);
}

KQActionEvent::KQActionEvent(int type, QAction* action, QAction* before) : QActionEvent(type, action, before)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQActionEvent();
}

KQActionEvent::~KQActionEvent()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QActionEvent_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQActionEvent *qp = RawPtr_to(KQActionEvent *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QActionEvent]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QActionEvent]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QActionEvent_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQActionEvent *qp = RawPtr_to(KQActionEvent *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QActionEvent]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QActionEvent]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QActionEvent_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQActionEvent *qp = (KQActionEvent *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QActionEvent*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QActionEvent_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQActionEvent *qp = (KQActionEvent *)p->rawptr;
		KQActionEvent *qp = static_cast<KQActionEvent*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QActionEvent_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQActionEvent::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQActionEvent(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QActionEvent";
	cdef->free = QActionEvent_free;
	cdef->reftrace = QActionEvent_reftrace;
	cdef->compareTo = QActionEvent_compareTo;
}


//QActionGroup QActionGroup.new(QObject parent);
KMETHOD QActionGroup_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QObject*  parent = RawPtr_to(QObject*, sfp[1]);
	KQActionGroup *ret_v = new KQActionGroup(parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

//Array<QAction> QActionGroup.actions();
KMETHOD QActionGroup_actions(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QActionGroup *  qp = RawPtr_to(QActionGroup *, sfp[0]);
	if (qp) {
		QList<QAction*> ret_v = qp->actions();
		int list_size = ret_v.size();
		kArray *a = new_Array0(ctx, list_size);
		kclass_t cid = knh_getcid(ctx, STEXT("QAction"));
		for (int n = 0; n < list_size; n++) {
			kRawPtr *p = new_RawPtr(ctx, ClassTBL(cid), ret_v[n]);
			knh_Array_add(ctx, a, (kObject *)p);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}
	

//QAction QActionGroup.checkedAction();
KMETHOD QActionGroup_checkedAction(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QActionGroup *  qp = RawPtr_to(QActionGroup *, sfp[0]);
	if (qp) {
		QAction* ret_v = qp->checkedAction();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAction*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QActionGroup.isEnabled();
KMETHOD QActionGroup_isEnabled(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QActionGroup *  qp = RawPtr_to(QActionGroup *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isEnabled();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QActionGroup.isExclusive();
KMETHOD QActionGroup_isExclusive(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QActionGroup *  qp = RawPtr_to(QActionGroup *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isExclusive();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QActionGroup.isVisible();
KMETHOD QActionGroup_isVisible(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QActionGroup *  qp = RawPtr_to(QActionGroup *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isVisible();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QActionGroup.removeAction(QAction action);
KMETHOD QActionGroup_removeAction(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QActionGroup *  qp = RawPtr_to(QActionGroup *, sfp[0]);
	if (qp) {
		QAction*  action = RawPtr_to(QAction*, sfp[1]);
		qp->removeAction(action);
	}
	RETURNvoid_();
}

//void QActionGroup.setDisabled(boolean b);
KMETHOD QActionGroup_setDisabled(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QActionGroup *  qp = RawPtr_to(QActionGroup *, sfp[0]);
	if (qp) {
		bool b = Boolean_to(bool, sfp[1]);
		qp->setDisabled(b);
	}
	RETURNvoid_();
}

//void QActionGroup.setEnabled(boolean arg0);
KMETHOD QActionGroup_setEnabled(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QActionGroup *  qp = RawPtr_to(QActionGroup *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setEnabled(arg0);
	}
	RETURNvoid_();
}

//void QActionGroup.setExclusive(boolean arg0);
KMETHOD QActionGroup_setExclusive(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QActionGroup *  qp = RawPtr_to(QActionGroup *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setExclusive(arg0);
	}
	RETURNvoid_();
}

//void QActionGroup.setVisible(boolean arg0);
KMETHOD QActionGroup_setVisible(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QActionGroup *  qp = RawPtr_to(QActionGroup *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setVisible(arg0);
	}
	RETURNvoid_();
}


DummyQActionGroup::DummyQActionGroup()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	hovered_func = NULL;
	triggered_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("hovered", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("triggered", NULL));
}
DummyQActionGroup::~DummyQActionGroup()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQActionGroup::setSelf(kRawPtr *ptr)
{
	DummyQActionGroup::self = ptr;
	DummyQObject::setSelf(ptr);
}

bool DummyQActionGroup::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQObject::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQActionGroup::hoveredSlot(QAction* action)
{
	if (hovered_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QAction, action);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, hovered_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQActionGroup::triggeredSlot(QAction* action)
{
	if (triggered_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QAction, action);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, triggered_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQActionGroup::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQActionGroup::event_map->bigin();
	if ((itr = DummyQActionGroup::event_map->find(str)) == DummyQActionGroup::event_map->end()) {
		bool ret = false;
		ret = DummyQObject::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQActionGroup::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQActionGroup::slot_map->bigin();
	if ((itr = DummyQActionGroup::slot_map->find(str)) == DummyQActionGroup::slot_map->end()) {
		bool ret = false;
		ret = DummyQObject::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		hovered_func = (*slot_map)["hovered"];
		triggered_func = (*slot_map)["triggered"];
		return true;
	}
}

kObject** DummyQActionGroup::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQActionGroup::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 3;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, hovered_func);
	KNH_ADDNNREF(ctx, triggered_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQObject::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQActionGroup::connection(QObject *o)
{
	QActionGroup *p = dynamic_cast<QActionGroup*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(hovered(QAction*)), this, SLOT(hoveredSlot(QAction*)));
		connect(p, SIGNAL(triggered(QAction*)), this, SLOT(triggeredSlot(QAction*)));
	}
	DummyQObject::connection(o);
}

KQActionGroup::KQActionGroup(QObject* parent) : QActionGroup(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQActionGroup();
	dummy->connection((QObject*)this);
}

KQActionGroup::~KQActionGroup()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QActionGroup_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQActionGroup *qp = RawPtr_to(KQActionGroup *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QActionGroup]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QActionGroup]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QActionGroup_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQActionGroup *qp = RawPtr_to(KQActionGroup *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QActionGroup]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QActionGroup]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QActionGroup_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQActionGroup *qp = (KQActionGroup *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QActionGroup*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QActionGroup_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQActionGroup *qp = (KQActionGroup *)p->rawptr;
		KQActionGroup *qp = static_cast<KQActionGroup*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QActionGroup_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQActionGroup::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQActionGroup::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QActionGroup::event(event);
		return false;
	}
//	QActionGroup::event(event);
	return true;
}



DEFAPI(void) defQActionGroup(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QActionGroup";
	cdef->free = QActionGroup_free;
	cdef->reftrace = QActionGroup_reftrace;
	cdef->compareTo = QActionGroup_compareTo;
}


//@Virtual @Override boolean QApplication.notify(QObject receiver, QEvent e);

//QApplication QApplication.new(int argc, String argv);
KMETHOD QApplication_new(CTX ctx, ksfp_t *sfp _RIX)
{
	int dummy = 0;
	char **argv = (char **)malloc(1 * sizeof(char *));
	memset(argv, 0, sizeof(char *));
//	QApplication *app = new QApplication(dummy, argv);
	KQApplication *app = new KQApplication(dummy, argv);
	QTextCodec::setCodecForCStrings(QTextCodec::codecForName("UTF-8"));
	kRawPtr *p = new_ReturnCppObject(ctx, sfp, app, NULL);
	app->setSelf(p);
	RETURN_(p);
}

/*
//QApplication QApplication.new(int argc, String argv, boolean GUIenabled);
KMETHOD QApplication_new(CTX ctx, ksfp_t *sfp _RIX)
{
	int dummy = 0;
	char **argv = (char **)malloc(1 * sizeof(char *));
	memset(argv, 0, sizeof(char *));
//	QApplication *app = new QApplication(dummy, argv);
	KQApplication *app = new KQApplication(dummy, argv);
	QTextCodec::setCodecForCStrings(QTextCodec::codecForName("UTF-8"));
	kRawPtr *p = new_ReturnCppObject(ctx, sfp, app, NULL);
	app->setSelf(p);
	RETURN_(p);
}
*/
/*
//QApplication QApplication.new(int argc, String argv, int type);
KMETHOD QApplication_new(CTX ctx, ksfp_t *sfp _RIX)
{
	int dummy = 0;
	char **argv = (char **)malloc(1 * sizeof(char *));
	memset(argv, 0, sizeof(char *));
//	QApplication *app = new QApplication(dummy, argv);
	KQApplication *app = new KQApplication(dummy, argv);
	QTextCodec::setCodecForCStrings(QTextCodec::codecForName("UTF-8"));
	kRawPtr *p = new_ReturnCppObject(ctx, sfp, app, NULL);
	app->setSelf(p);
	RETURN_(p);
}
*/
//QInputContext QApplication.getInputContext();

//boolean QApplication.isSessionRestored();

//String QApplication.sessionId();

//String QApplication.sessionKey();

//void QApplication.setInputContext(QInputContext inputContext);

//String QApplication.getStyleSheet();

//QWidget QApplication.activeModalWidget();

//QWidget QApplication.activePopupWidget();

//QWidget QApplication.getActiveWindow();

//void QApplication.alert(QWidget widget, int msec);

//QWidgetList QApplication.allWidgets();

//void QApplication.beep();

//void QApplication.changeOverrideCursor(QCursor cursor);

//QClipboard QApplication.clipboard();

//int QApplication.getColorSpec();

//int QApplication.getCursorFlashTime();

//QDesktopWidget QApplication.desktop();

//boolean QApplication.getDesktopSettingsAware();

//int QApplication.getDoubleClickInterval();

//int QApplication.exec();
KMETHOD QApplication_exec(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		exec_flag = true;
		int ret_v = QApplication::exec();
//		fprintf(stderr, "exec end\n");
		exec_flag = false;
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QWidget QApplication.focusWidget();

//QFont QApplication.getFont();

/*
//QFont QApplication.getFont(QWidget widget);
*/
/*
//QFont QApplication.getFont(String className);
*/
//QFontMetrics QApplication.fontMetrics();

//QSize QApplication.getGlobalStrut();

//boolean QApplication.isEffectEnabled(int effect);

//boolean QApplication.isLeftToRight();

//boolean QApplication.isRightToLeft();

//int QApplication.keyboardInputDirection();

//int QApplication.getKeyboardInputInterval();

//QLocale QApplication.keyboardInputLocale();

//QtKeyboardModifiers QApplication.keyboardModifiers();

//int QApplication.getLayoutDirection();

//QtMouseButtons QApplication.mouseButtons();

//QCursor QApplication.getOverrideCursor();

//QPalette QApplication.getPalette();

/*
//QPalette QApplication.getPalette(QWidget widget);
*/
/*
//QPalette QApplication.getPalette(String className);
*/
//boolean QApplication.getQuitOnLastWindowClosed();

//void QApplication.restoreOverrideCursor();

//void QApplication.setActiveWindow(QWidget active);

//void QApplication.setColorSpec(int spec);

//void QApplication.setCursorFlashTime(int arg0);

//void QApplication.setDesktopSettingsAware(boolean on);

//void QApplication.setDoubleClickInterval(int arg0);

//void QApplication.setEffectEnabled(int effect, boolean enable);

//void QApplication.setFont(QFont font, String className);

//void QApplication.setGlobalStrut(QSize arg0);

//void QApplication.setGraphicsSystem(String system);

//void QApplication.setKeyboardInputInterval(int arg0);

//void QApplication.setLayoutDirection(int direction);

//void QApplication.setOverrideCursor(QCursor cursor);

//void QApplication.setPalette(QPalette palette, String className);

//void QApplication.setQuitOnLastWindowClosed(boolean quit);

//void QApplication.setStartDragDistance(int l);

//void QApplication.setStartDragTime(int ms);

//void QApplication.setStyle(QStyle style);

/*
//QStyle QApplication.setStyle(String style);
*/
//void QApplication.setWheelScrollLines(int arg0);

//void QApplication.setWindowIcon(QIcon icon);

//int QApplication.getStartDragDistance();

//int QApplication.getStartDragTime();

//QStyle QApplication.getStyle();

//void QApplication.syncX();

//QWidget QApplication.topLevelAt(QPoint point);

/*
//QWidget QApplication.topLevelAt(int x, int y);
*/
//QWidgetList QApplication.topLevelWidgets();

//int QApplication.type();

//int QApplication.getWheelScrollLines();

//QWidget QApplication.widgetAt(QPoint point);

/*
//QWidget QApplication.widgetAt(int x, int y);
*/
//QIcon QApplication.getWindowIcon();

//void QApplication.aboutQt();

//boolean QApplication.getAutoSipEnabled();

//void QApplication.closeAllWindows();

//void QApplication.setAutoSipEnabled(boolean enabled);

//void QApplication.setStyleSheet(String sheet);


DummyQApplication::DummyQApplication()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	focus_changed_func = NULL;
	font_database_changed_func = NULL;
	last_window_closed_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("focus-changed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("font-database-changed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("last-window-closed", NULL));
}
DummyQApplication::~DummyQApplication()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQApplication::setSelf(kRawPtr *ptr)
{
	DummyQApplication::self = ptr;
	DummyQCoreApplication::setSelf(ptr);
}

bool DummyQApplication::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQCoreApplication::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQApplication::focusChangedSlot(QWidget* old, QWidget* now)
{
	if (focus_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QWidget, old);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		kRawPtr *p2 = new_QRawPtr(lctx, QWidget, now);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+3].o, UPCAST(p2));
		knh_Func_invoke(lctx, focus_changed_func, lsfp, 3);
		return true;
	}
	return false;
}

bool DummyQApplication::fontDatabaseChangedSlot()
{
	if (font_database_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, font_database_changed_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQApplication::lastWindowClosedSlot()
{
	if (last_window_closed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, last_window_closed_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQApplication::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQApplication::event_map->bigin();
	if ((itr = DummyQApplication::event_map->find(str)) == DummyQApplication::event_map->end()) {
		bool ret = false;
		ret = DummyQCoreApplication::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQApplication::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQApplication::slot_map->bigin();
	if ((itr = DummyQApplication::slot_map->find(str)) == DummyQApplication::slot_map->end()) {
		bool ret = false;
		ret = DummyQCoreApplication::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		focus_changed_func = (*slot_map)["focus-changed"];
		font_database_changed_func = (*slot_map)["font-database-changed"];
		last_window_closed_func = (*slot_map)["last-window-closed"];
		return true;
	}
}

kObject** DummyQApplication::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQApplication::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 4;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, focus_changed_func);
	KNH_ADDNNREF(ctx, font_database_changed_func);
	KNH_ADDNNREF(ctx, last_window_closed_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQCoreApplication::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQApplication::connection(QObject *o)
{
	QApplication *p = dynamic_cast<QApplication*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(focusChanged(QWidget*, QWidget*)), this, SLOT(focusChangedSlot(QWidget*, QWidget*)));
		connect(p, SIGNAL(fontDatabaseChanged()), this, SLOT(fontDatabaseChangedSlot()));
		connect(p, SIGNAL(lastWindowClosed()), this, SLOT(lastWindowClosedSlot()));
	}
	DummyQCoreApplication::connection(o);
}

KQApplication::KQApplication(int argc, char** argv) : QApplication(argc, argv)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQApplication();
	dummy->connection((QObject*)this);
}

KQApplication::~KQApplication()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QApplication_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQApplication *qp = RawPtr_to(KQApplication *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QApplication]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QApplication]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QApplication_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQApplication *qp = RawPtr_to(KQApplication *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QApplication]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QApplication]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QApplication_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQApplication *qp = (KQApplication *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QApplication*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QApplication_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQApplication *qp = (KQApplication *)p->rawptr;
		KQApplication *qp = static_cast<KQApplication*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QApplication_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQApplication::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQApplication::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QApplication::event(event);
		return false;
	}
//	QApplication::event(event);
	return true;
}

static knh_IntData_t QApplicationConstInt[] = {
	{"NormalColor", QApplication::NormalColor},
	{"CustomColor", QApplication::CustomColor},
	{"ManyColor", QApplication::ManyColor},
	{"Tty", QApplication::Tty},
	{"GuiClient", QApplication::GuiClient},
	{"GuiServer", QApplication::GuiServer},
	{NULL, 0}
};

DEFAPI(void) constQApplication(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QApplicationConstInt);
}


DEFAPI(void) defQApplication(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QApplication";
	cdef->free = QApplication_free;
	cdef->reftrace = QApplication_reftrace;
	cdef->compareTo = QApplication_compareTo;
}


//QAtomicInt QAtomicInt.new(int value);
KMETHOD QAtomicInt_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	int value = Int_to(int, sfp[1]);
	KQAtomicInt *ret_v = new KQAtomicInt(value);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QAtomicInt QAtomicInt.new(QAtomicInt other);
KMETHOD QAtomicInt_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QAtomicInt  other = *RawPtr_to(const QAtomicInt *, sfp[1]);
	KQAtomicInt *ret_v = new KQAtomicInt(other);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//boolean QAtomicInt.deref();
KMETHOD QAtomicInt_deref(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAtomicInt *  qp = RawPtr_to(QAtomicInt *, sfp[0]);
	if (qp) {
		bool ret_v = qp->deref();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//int QAtomicInt.fetchAndAddAcquire(int valueToAdd);
KMETHOD QAtomicInt_fetchAndAddAcquire(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAtomicInt *  qp = RawPtr_to(QAtomicInt *, sfp[0]);
	if (qp) {
		int valueToAdd = Int_to(int, sfp[1]);
		int ret_v = qp->fetchAndAddAcquire(valueToAdd);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAtomicInt.fetchAndAddOrdered(int valueToAdd);
KMETHOD QAtomicInt_fetchAndAddOrdered(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAtomicInt *  qp = RawPtr_to(QAtomicInt *, sfp[0]);
	if (qp) {
		int valueToAdd = Int_to(int, sfp[1]);
		int ret_v = qp->fetchAndAddOrdered(valueToAdd);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAtomicInt.fetchAndAddRelaxed(int valueToAdd);
KMETHOD QAtomicInt_fetchAndAddRelaxed(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAtomicInt *  qp = RawPtr_to(QAtomicInt *, sfp[0]);
	if (qp) {
		int valueToAdd = Int_to(int, sfp[1]);
		int ret_v = qp->fetchAndAddRelaxed(valueToAdd);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAtomicInt.fetchAndAddRelease(int valueToAdd);
KMETHOD QAtomicInt_fetchAndAddRelease(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAtomicInt *  qp = RawPtr_to(QAtomicInt *, sfp[0]);
	if (qp) {
		int valueToAdd = Int_to(int, sfp[1]);
		int ret_v = qp->fetchAndAddRelease(valueToAdd);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAtomicInt.fetchAndStoreAcquire(int new_Value);
KMETHOD QAtomicInt_fetchAndStoreAcquire(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAtomicInt *  qp = RawPtr_to(QAtomicInt *, sfp[0]);
	if (qp) {
		int new_Value = Int_to(int, sfp[1]);
		int ret_v = qp->fetchAndStoreAcquire(new_Value);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAtomicInt.fetchAndStoreOrdered(int new_Value);
KMETHOD QAtomicInt_fetchAndStoreOrdered(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAtomicInt *  qp = RawPtr_to(QAtomicInt *, sfp[0]);
	if (qp) {
		int new_Value = Int_to(int, sfp[1]);
		int ret_v = qp->fetchAndStoreOrdered(new_Value);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAtomicInt.fetchAndStoreRelaxed(int new_Value);
KMETHOD QAtomicInt_fetchAndStoreRelaxed(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAtomicInt *  qp = RawPtr_to(QAtomicInt *, sfp[0]);
	if (qp) {
		int new_Value = Int_to(int, sfp[1]);
		int ret_v = qp->fetchAndStoreRelaxed(new_Value);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QAtomicInt.fetchAndStoreRelease(int new_Value);
KMETHOD QAtomicInt_fetchAndStoreRelease(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAtomicInt *  qp = RawPtr_to(QAtomicInt *, sfp[0]);
	if (qp) {
		int new_Value = Int_to(int, sfp[1]);
		int ret_v = qp->fetchAndStoreRelease(new_Value);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//boolean QAtomicInt.ref();
KMETHOD QAtomicInt_ref(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAtomicInt *  qp = RawPtr_to(QAtomicInt *, sfp[0]);
	if (qp) {
		bool ret_v = qp->ref();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAtomicInt.testAndSetAcquire(int expectedValue, int new_Value);
KMETHOD QAtomicInt_testAndSetAcquire(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAtomicInt *  qp = RawPtr_to(QAtomicInt *, sfp[0]);
	if (qp) {
		int expectedValue = Int_to(int, sfp[1]);
		int new_Value = Int_to(int, sfp[2]);
		bool ret_v = qp->testAndSetAcquire(expectedValue, new_Value);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAtomicInt.testAndSetOrdered(int expectedValue, int new_Value);
KMETHOD QAtomicInt_testAndSetOrdered(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAtomicInt *  qp = RawPtr_to(QAtomicInt *, sfp[0]);
	if (qp) {
		int expectedValue = Int_to(int, sfp[1]);
		int new_Value = Int_to(int, sfp[2]);
		bool ret_v = qp->testAndSetOrdered(expectedValue, new_Value);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAtomicInt.testAndSetRelaxed(int expectedValue, int new_Value);
KMETHOD QAtomicInt_testAndSetRelaxed(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAtomicInt *  qp = RawPtr_to(QAtomicInt *, sfp[0]);
	if (qp) {
		int expectedValue = Int_to(int, sfp[1]);
		int new_Value = Int_to(int, sfp[2]);
		bool ret_v = qp->testAndSetRelaxed(expectedValue, new_Value);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAtomicInt.testAndSetRelease(int expectedValue, int new_Value);
KMETHOD QAtomicInt_testAndSetRelease(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAtomicInt *  qp = RawPtr_to(QAtomicInt *, sfp[0]);
	if (qp) {
		int expectedValue = Int_to(int, sfp[1]);
		int new_Value = Int_to(int, sfp[2]);
		bool ret_v = qp->testAndSetRelease(expectedValue, new_Value);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAtomicInt.isFetchAndAddNative();
KMETHOD QAtomicInt_isFetchAndAddNative(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		bool ret_v = QAtomicInt::isFetchAndAddNative();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAtomicInt.isFetchAndAddWaitFree();
KMETHOD QAtomicInt_isFetchAndAddWaitFree(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		bool ret_v = QAtomicInt::isFetchAndAddWaitFree();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAtomicInt.isFetchAndStoreNative();
KMETHOD QAtomicInt_isFetchAndStoreNative(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		bool ret_v = QAtomicInt::isFetchAndStoreNative();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAtomicInt.isFetchAndStoreWaitFree();
KMETHOD QAtomicInt_isFetchAndStoreWaitFree(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		bool ret_v = QAtomicInt::isFetchAndStoreWaitFree();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAtomicInt.isReferenceCountingNative();
KMETHOD QAtomicInt_isReferenceCountingNative(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		bool ret_v = QAtomicInt::isReferenceCountingNative();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAtomicInt.isReferenceCountingWaitFree();
KMETHOD QAtomicInt_isReferenceCountingWaitFree(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		bool ret_v = QAtomicInt::isReferenceCountingWaitFree();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAtomicInt.isTestAndSetNative();
KMETHOD QAtomicInt_isTestAndSetNative(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		bool ret_v = QAtomicInt::isTestAndSetNative();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QAtomicInt.isTestAndSetWaitFree();
KMETHOD QAtomicInt_isTestAndSetWaitFree(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		bool ret_v = QAtomicInt::isTestAndSetWaitFree();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//Array<String> QAtomicInt.parents();
KMETHOD QAtomicInt_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAtomicInt *qp = RawPtr_to(QAtomicInt*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQAtomicInt::DummyQAtomicInt()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQAtomicInt::~DummyQAtomicInt()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAtomicInt::setSelf(kRawPtr *ptr)
{
	DummyQAtomicInt::self = ptr;
}

bool DummyQAtomicInt::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQAtomicInt::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAtomicInt::event_map->bigin();
	if ((itr = DummyQAtomicInt::event_map->find(str)) == DummyQAtomicInt::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAtomicInt::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAtomicInt::slot_map->bigin();
	if ((itr = DummyQAtomicInt::slot_map->find(str)) == DummyQAtomicInt::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQAtomicInt::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAtomicInt::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQAtomicInt::connection(QObject *o)
{
	QAtomicInt *p = dynamic_cast<QAtomicInt*>(o);
	if (p != NULL) {
	}
}

KQAtomicInt::KQAtomicInt(int value) : QAtomicInt(value)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAtomicInt();
}

KQAtomicInt::~KQAtomicInt()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAtomicInt_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAtomicInt *qp = RawPtr_to(KQAtomicInt *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAtomicInt]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAtomicInt]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAtomicInt_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAtomicInt *qp = RawPtr_to(KQAtomicInt *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAtomicInt]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAtomicInt]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAtomicInt_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAtomicInt *qp = (KQAtomicInt *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAtomicInt*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAtomicInt_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAtomicInt *qp = (KQAtomicInt *)p->rawptr;
		KQAtomicInt *qp = static_cast<KQAtomicInt*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAtomicInt_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (*static_cast<QAtomicInt*>(p1->rawptr) == *static_cast<QAtomicInt*>(p2->rawptr) ? 0 : 1);
}

void KQAtomicInt::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQAtomicInt(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAtomicInt";
	cdef->free = QAtomicInt_free;
	cdef->reftrace = QAtomicInt_reftrace;
	cdef->compareTo = QAtomicInt_compareTo;
}


//QAuthenticator QAuthenticator.new();
KMETHOD QAuthenticator_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAuthenticator *ret_v = new KQAuthenticator();
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QAuthenticator QAuthenticator.new(QAuthenticator other);
KMETHOD QAuthenticator_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QAuthenticator  other = *RawPtr_to(const QAuthenticator *, sfp[1]);
	KQAuthenticator *ret_v = new KQAuthenticator(other);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//QVariant QAuthenticator.getOption(String opt);
KMETHOD QAuthenticator_getOption(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAuthenticator *  qp = RawPtr_to(QAuthenticator *, sfp[0]);
	if (qp) {
		const QString opt = String_to(const QString, sfp[1]);
		QVariant ret_v = qp->option(opt);
		QVariant *ret_v_ = new QVariant(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QVariantHash QAuthenticator.options();
KMETHOD QAuthenticator_options(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAuthenticator *  qp = RawPtr_to(QAuthenticator *, sfp[0]);
	if (qp) {
		QVariantHash ret_v = qp->options();
		QVariantHash *ret_v_ = new QVariantHash(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QAuthenticator.getPassword();
KMETHOD QAuthenticator_getPassword(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAuthenticator *  qp = RawPtr_to(QAuthenticator *, sfp[0]);
	if (qp) {
		QString ret_v = qp->password();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QAuthenticator.realm();
KMETHOD QAuthenticator_realm(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAuthenticator *  qp = RawPtr_to(QAuthenticator *, sfp[0]);
	if (qp) {
		QString ret_v = qp->realm();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QAuthenticator.setOption(String opt, QVariant value);
KMETHOD QAuthenticator_setOption(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAuthenticator *  qp = RawPtr_to(QAuthenticator *, sfp[0]);
	if (qp) {
		const QString opt = String_to(const QString, sfp[1]);
		const QVariant  value = *RawPtr_to(const QVariant *, sfp[2]);
		qp->setOption(opt, value);
	}
	RETURNvoid_();
}

//void QAuthenticator.setPassword(String password);
KMETHOD QAuthenticator_setPassword(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAuthenticator *  qp = RawPtr_to(QAuthenticator *, sfp[0]);
	if (qp) {
		const QString password = String_to(const QString, sfp[1]);
		qp->setPassword(password);
	}
	RETURNvoid_();
}

//void QAuthenticator.setUser(String user);
KMETHOD QAuthenticator_setUser(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAuthenticator *  qp = RawPtr_to(QAuthenticator *, sfp[0]);
	if (qp) {
		const QString user = String_to(const QString, sfp[1]);
		qp->setUser(user);
	}
	RETURNvoid_();
}

//String QAuthenticator.getUser();
KMETHOD QAuthenticator_getUser(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAuthenticator *  qp = RawPtr_to(QAuthenticator *, sfp[0]);
	if (qp) {
		QString ret_v = qp->user();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//Array<String> QAuthenticator.parents();
KMETHOD QAuthenticator_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAuthenticator *qp = RawPtr_to(QAuthenticator*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQAuthenticator::DummyQAuthenticator()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQAuthenticator::~DummyQAuthenticator()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQAuthenticator::setSelf(kRawPtr *ptr)
{
	DummyQAuthenticator::self = ptr;
}

bool DummyQAuthenticator::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQAuthenticator::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAuthenticator::event_map->bigin();
	if ((itr = DummyQAuthenticator::event_map->find(str)) == DummyQAuthenticator::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQAuthenticator::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQAuthenticator::slot_map->bigin();
	if ((itr = DummyQAuthenticator::slot_map->find(str)) == DummyQAuthenticator::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQAuthenticator::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQAuthenticator::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQAuthenticator::connection(QObject *o)
{
	QAuthenticator *p = dynamic_cast<QAuthenticator*>(o);
	if (p != NULL) {
	}
}

KQAuthenticator::KQAuthenticator() : QAuthenticator()
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQAuthenticator();
}

KQAuthenticator::~KQAuthenticator()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QAuthenticator_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAuthenticator *qp = RawPtr_to(KQAuthenticator *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QAuthenticator]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAuthenticator]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QAuthenticator_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQAuthenticator *qp = RawPtr_to(KQAuthenticator *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QAuthenticator]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QAuthenticator]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QAuthenticator_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQAuthenticator *qp = (KQAuthenticator *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QAuthenticator*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QAuthenticator_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQAuthenticator *qp = (KQAuthenticator *)p->rawptr;
		KQAuthenticator *qp = static_cast<KQAuthenticator*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QAuthenticator_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (*static_cast<QAuthenticator*>(p1->rawptr) == *static_cast<QAuthenticator*>(p2->rawptr) ? 0 : 1);
}

void KQAuthenticator::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQAuthenticator(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QAuthenticator";
	cdef->free = QAuthenticator_free;
	cdef->reftrace = QAuthenticator_reftrace;
	cdef->compareTo = QAuthenticator_compareTo;
}


//QBasicTimer QBasicTimer.new();
KMETHOD QBasicTimer_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQBasicTimer *ret_v = new KQBasicTimer();
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

//boolean QBasicTimer.isActive();
KMETHOD QBasicTimer_isActive(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBasicTimer *  qp = RawPtr_to(QBasicTimer *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isActive();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QBasicTimer.start(int msec, QObject object);
KMETHOD QBasicTimer_start(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBasicTimer *  qp = RawPtr_to(QBasicTimer *, sfp[0]);
	if (qp) {
		int msec = Int_to(int, sfp[1]);
		QObject*  object = RawPtr_to(QObject*, sfp[2]);
		qp->start(msec, object);
	}
	RETURNvoid_();
}

//void QBasicTimer.stop();
KMETHOD QBasicTimer_stop(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBasicTimer *  qp = RawPtr_to(QBasicTimer *, sfp[0]);
	if (qp) {
		qp->stop();
	}
	RETURNvoid_();
}

//int QBasicTimer.timerId();
KMETHOD QBasicTimer_timerId(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBasicTimer *  qp = RawPtr_to(QBasicTimer *, sfp[0]);
	if (qp) {
		int ret_v = qp->timerId();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//Array<String> QBasicTimer.parents();
KMETHOD QBasicTimer_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBasicTimer *qp = RawPtr_to(QBasicTimer*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQBasicTimer::DummyQBasicTimer()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQBasicTimer::~DummyQBasicTimer()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQBasicTimer::setSelf(kRawPtr *ptr)
{
	DummyQBasicTimer::self = ptr;
}

bool DummyQBasicTimer::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQBasicTimer::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQBasicTimer::event_map->bigin();
	if ((itr = DummyQBasicTimer::event_map->find(str)) == DummyQBasicTimer::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQBasicTimer::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQBasicTimer::slot_map->bigin();
	if ((itr = DummyQBasicTimer::slot_map->find(str)) == DummyQBasicTimer::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQBasicTimer::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQBasicTimer::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQBasicTimer::connection(QObject *o)
{
	QBasicTimer *p = dynamic_cast<QBasicTimer*>(o);
	if (p != NULL) {
	}
}

KQBasicTimer::KQBasicTimer() : QBasicTimer()
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQBasicTimer();
}

KQBasicTimer::~KQBasicTimer()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QBasicTimer_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQBasicTimer *qp = RawPtr_to(KQBasicTimer *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QBasicTimer]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QBasicTimer]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QBasicTimer_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQBasicTimer *qp = RawPtr_to(KQBasicTimer *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QBasicTimer]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QBasicTimer]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QBasicTimer_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQBasicTimer *qp = (KQBasicTimer *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QBasicTimer*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QBasicTimer_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQBasicTimer *qp = (KQBasicTimer *)p->rawptr;
		KQBasicTimer *qp = static_cast<KQBasicTimer*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QBasicTimer_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQBasicTimer::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQBasicTimer(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QBasicTimer";
	cdef->free = QBasicTimer_free;
	cdef->reftrace = QBasicTimer_reftrace;
	cdef->compareTo = QBasicTimer_compareTo;
}


//QBitArray QBitArray.new();
KMETHOD QBitArray_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQBitArray *ret_v = new KQBitArray();
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QBitArray QBitArray.new(int size, boolean value);
KMETHOD QBitArray_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	int size = Int_to(int, sfp[1]);
	bool value = Boolean_to(bool, sfp[2]);
	KQBitArray *ret_v = new KQBitArray(size, value);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QBitArray QBitArray.new(QBitArray other);
KMETHOD QBitArray_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QBitArray  other = *RawPtr_to(const QBitArray *, sfp[1]);
	KQBitArray *ret_v = new KQBitArray(other);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//boolean QBitArray.at(int i);
KMETHOD QBitArray_at(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBitArray *  qp = RawPtr_to(QBitArray *, sfp[0]);
	if (qp) {
		int i = Int_to(int, sfp[1]);
		bool ret_v = qp->at(i);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QBitArray.clear();
KMETHOD QBitArray_clear(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBitArray *  qp = RawPtr_to(QBitArray *, sfp[0]);
	if (qp) {
		qp->clear();
	}
	RETURNvoid_();
}

//void QBitArray.clearBit(int i);
KMETHOD QBitArray_clearBit(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBitArray *  qp = RawPtr_to(QBitArray *, sfp[0]);
	if (qp) {
		int i = Int_to(int, sfp[1]);
		qp->clearBit(i);
	}
	RETURNvoid_();
}

//int QBitArray.count();
KMETHOD QBitArray_count(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBitArray *  qp = RawPtr_to(QBitArray *, sfp[0]);
	if (qp) {
		int ret_v = qp->count();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

/*
//int QBitArray.count(boolean on);
KMETHOD QBitArray_count(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBitArray *  qp = RawPtr_to(QBitArray *, sfp[0]);
	if (qp) {
		bool on = Boolean_to(bool, sfp[1]);
		int ret_v = qp->count(on);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
//boolean QBitArray.fill(boolean value, int size);
KMETHOD QBitArray_fill(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBitArray *  qp = RawPtr_to(QBitArray *, sfp[0]);
	if (qp) {
		bool value = Boolean_to(bool, sfp[1]);
		int size = Int_to(int, sfp[2]);
		bool ret_v = qp->fill(value, size);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

/*
//void QBitArray.fill(boolean value, int begin, int end);
KMETHOD QBitArray_fill(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBitArray *  qp = RawPtr_to(QBitArray *, sfp[0]);
	if (qp) {
		bool value = Boolean_to(bool, sfp[1]);
		int begin = Int_to(int, sfp[2]);
		int end = Int_to(int, sfp[3]);
		qp->fill(value, begin, end);
	}
	RETURNvoid_();
}
*/
//boolean QBitArray.isEmpty();
KMETHOD QBitArray_isEmpty(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBitArray *  qp = RawPtr_to(QBitArray *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isEmpty();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QBitArray.resize(int size);
KMETHOD QBitArray_resize(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBitArray *  qp = RawPtr_to(QBitArray *, sfp[0]);
	if (qp) {
		int size = Int_to(int, sfp[1]);
		qp->resize(size);
	}
	RETURNvoid_();
}

//void QBitArray.setBit(int i);
KMETHOD QBitArray_setBit(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBitArray *  qp = RawPtr_to(QBitArray *, sfp[0]);
	if (qp) {
		int i = Int_to(int, sfp[1]);
		qp->setBit(i);
	}
	RETURNvoid_();
}

/*
//void QBitArray.setBit(int i, boolean value);
KMETHOD QBitArray_setBit(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBitArray *  qp = RawPtr_to(QBitArray *, sfp[0]);
	if (qp) {
		int i = Int_to(int, sfp[1]);
		bool value = Boolean_to(bool, sfp[2]);
		qp->setBit(i, value);
	}
	RETURNvoid_();
}
*/
//int QBitArray.size();
KMETHOD QBitArray_size(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBitArray *  qp = RawPtr_to(QBitArray *, sfp[0]);
	if (qp) {
		int ret_v = qp->size();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//boolean QBitArray.testBit(int i);
KMETHOD QBitArray_testBit(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBitArray *  qp = RawPtr_to(QBitArray *, sfp[0]);
	if (qp) {
		int i = Int_to(int, sfp[1]);
		bool ret_v = qp->testBit(i);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QBitArray.toggleBit(int i);
KMETHOD QBitArray_toggleBit(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBitArray *  qp = RawPtr_to(QBitArray *, sfp[0]);
	if (qp) {
		int i = Int_to(int, sfp[1]);
		bool ret_v = qp->toggleBit(i);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QBitArray.truncate(int pos);
KMETHOD QBitArray_truncate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBitArray *  qp = RawPtr_to(QBitArray *, sfp[0]);
	if (qp) {
		int pos = Int_to(int, sfp[1]);
		qp->truncate(pos);
	}
	RETURNvoid_();
}

//Array<String> QBitArray.parents();
KMETHOD QBitArray_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBitArray *qp = RawPtr_to(QBitArray*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQBitArray::DummyQBitArray()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQBitArray::~DummyQBitArray()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQBitArray::setSelf(kRawPtr *ptr)
{
	DummyQBitArray::self = ptr;
}

bool DummyQBitArray::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQBitArray::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQBitArray::event_map->bigin();
	if ((itr = DummyQBitArray::event_map->find(str)) == DummyQBitArray::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQBitArray::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQBitArray::slot_map->bigin();
	if ((itr = DummyQBitArray::slot_map->find(str)) == DummyQBitArray::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQBitArray::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQBitArray::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQBitArray::connection(QObject *o)
{
	QBitArray *p = dynamic_cast<QBitArray*>(o);
	if (p != NULL) {
	}
}

KQBitArray::KQBitArray() : QBitArray()
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQBitArray();
}

KQBitArray::~KQBitArray()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QBitArray_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQBitArray *qp = RawPtr_to(KQBitArray *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QBitArray]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QBitArray]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QBitArray_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQBitArray *qp = RawPtr_to(KQBitArray *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QBitArray]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QBitArray]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QBitArray_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQBitArray *qp = (KQBitArray *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QBitArray*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QBitArray_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQBitArray *qp = (KQBitArray *)p->rawptr;
		KQBitArray *qp = static_cast<KQBitArray*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QBitArray_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (*static_cast<QBitArray*>(p1->rawptr) == *static_cast<QBitArray*>(p2->rawptr) ? 0 : 1);
}

void KQBitArray::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQBitArray(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QBitArray";
	cdef->free = QBitArray_free;
	cdef->reftrace = QBitArray_reftrace;
	cdef->compareTo = QBitArray_compareTo;
}


//QBitmap QBitmap.new();
KMETHOD QBitmap_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQBitmap *ret_v = new KQBitmap();
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QBitmap QBitmap.new(QPixmap pixmap);
KMETHOD QBitmap_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QPixmap  pixmap = *RawPtr_to(const QPixmap *, sfp[1]);
	KQBitmap *ret_v = new KQBitmap(pixmap);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QBitmap QBitmap.new(int width, int height);
KMETHOD QBitmap_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	int width = Int_to(int, sfp[1]);
	int height = Int_to(int, sfp[2]);
	KQBitmap *ret_v = new KQBitmap(width, height);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QBitmap QBitmap.new(QSize size);
KMETHOD QBitmap_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QSize  size = *RawPtr_to(const QSize *, sfp[1]);
	KQBitmap *ret_v = new KQBitmap(size);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QBitmap QBitmap.new(String fileName, String fmt);
KMETHOD QBitmap_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QString fileName = String_to(const QString, sfp[1]);
	const char*  format = RawPtr_to(const char*, sfp[2]);
	KQBitmap *ret_v = new KQBitmap(fileName, format);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//void QBitmap.clear();
KMETHOD QBitmap_clear(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBitmap *  qp = RawPtr_to(QBitmap *, sfp[0]);
	if (qp) {
		qp->clear();
	}
	RETURNvoid_();
}

//QBitmap QBitmap.fromData(QSize size, String bits, int monoFormat);
KMETHOD QBitmap_fromData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QSize  size = *RawPtr_to(const QSize *, sfp[1]);
		const uchar*  bits = RawPtr_to(const uchar*, sfp[2]);
		QImage::Format monoFormat = Int_to(QImage::Format, sfp[3]);
		QBitmap ret_v = QBitmap::fromData(size, bits, monoFormat);
		QBitmap *ret_v_ = new QBitmap(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QBitmap QBitmap.fromImage(QImage image, QtImageConversionFlags flags);
KMETHOD QBitmap_fromImage(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QImage  image = *RawPtr_to(const QImage *, sfp[1]);
		initFlag(flags, Qt::ImageConversionFlags, sfp[2]);
		QBitmap ret_v = QBitmap::fromImage(image, flags);
		QBitmap *ret_v_ = new QBitmap(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}


DummyQBitmap::DummyQBitmap()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQBitmap::~DummyQBitmap()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQBitmap::setSelf(kRawPtr *ptr)
{
	DummyQBitmap::self = ptr;
	DummyQPixmap::setSelf(ptr);
}

bool DummyQBitmap::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQPixmap::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQBitmap::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQBitmap::event_map->bigin();
	if ((itr = DummyQBitmap::event_map->find(str)) == DummyQBitmap::event_map->end()) {
		bool ret = false;
		ret = DummyQPixmap::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQBitmap::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQBitmap::slot_map->bigin();
	if ((itr = DummyQBitmap::slot_map->find(str)) == DummyQBitmap::slot_map->end()) {
		bool ret = false;
		ret = DummyQPixmap::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQBitmap::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQBitmap::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQPixmap::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQBitmap::connection(QObject *o)
{
	QBitmap *p = dynamic_cast<QBitmap*>(o);
	if (p != NULL) {
	}
	DummyQPixmap::connection(o);
}

KQBitmap::KQBitmap() : QBitmap()
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQBitmap();
}

KQBitmap::~KQBitmap()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QBitmap_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQBitmap *qp = RawPtr_to(KQBitmap *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QBitmap]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QBitmap]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QBitmap_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQBitmap *qp = RawPtr_to(KQBitmap *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QBitmap]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QBitmap]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QBitmap_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQBitmap *qp = (KQBitmap *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QBitmap*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QBitmap_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQBitmap *qp = (KQBitmap *)p->rawptr;
		KQBitmap *qp = static_cast<KQBitmap*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QBitmap_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQBitmap::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQBitmap(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QBitmap";
	cdef->free = QBitmap_free;
	cdef->reftrace = QBitmap_reftrace;
	cdef->compareTo = QBitmap_compareTo;
}


//@Virtual @Override void QBoxLayout.addItem(QLayoutItem item);
KMETHOD QBoxLayout_addItem(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		QLayoutItem*  item = RawPtr_to(QLayoutItem*, sfp[1]);
		qp->addItem(item);
	}
	RETURNvoid_();
}

//@Virtual @Override int QBoxLayout.count();
KMETHOD QBoxLayout_count(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		int ret_v = qp->count();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual @Override QtOrientations QBoxLayout.expandingDirections();
KMETHOD QBoxLayout_expandingDirections(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		Qt::Orientations ret_v = qp->expandingDirections();
		Qt::Orientations *ret_v_ = new Qt::Orientations(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override boolean QBoxLayout.hasHeightForWidth();
KMETHOD QBoxLayout_hasHeightForWidth(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		bool ret_v = qp->hasHeightForWidth();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override int QBoxLayout.heightForWidth(int w);
KMETHOD QBoxLayout_heightForWidth(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		int w = Int_to(int, sfp[1]);
		int ret_v = qp->heightForWidth(w);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual @Override void QBoxLayout.invalidate();
KMETHOD QBoxLayout_invalidate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		qp->invalidate();
	}
	RETURNvoid_();
}

//@Virtual @Override QLayoutItem QBoxLayout.itemAt(int index);
KMETHOD QBoxLayout_itemAt(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		QLayoutItem* ret_v = qp->itemAt(index);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QLayoutItem*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override QSize QBoxLayout.maximumSize();
KMETHOD QBoxLayout_maximumSize(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->maximumSize();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override int QBoxLayout.minimumHeightForWidth(int w);
KMETHOD QBoxLayout_minimumHeightForWidth(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		int w = Int_to(int, sfp[1]);
		int ret_v = qp->minimumHeightForWidth(w);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual @Override QSize QBoxLayout.minimumSize();
KMETHOD QBoxLayout_minimumSize(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->minimumSize();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override void QBoxLayout.setGeometry(QRect r);
KMETHOD QBoxLayout_setGeometry(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		const QRect  r = *RawPtr_to(const QRect *, sfp[1]);
		qp->setGeometry(r);
	}
	RETURNvoid_();
}

//@Virtual @Override QSize QBoxLayout.sizeHint();
KMETHOD QBoxLayout_sizeHint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->sizeHint();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override QLayoutItem QBoxLayout.takeAt(int index);
KMETHOD QBoxLayout_takeAt(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		QLayoutItem* ret_v = qp->takeAt(index);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QLayoutItem*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QBoxLayout QBoxLayout.new(int dir, QWidget parent);
KMETHOD QBoxLayout_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout::Direction dir = Int_to(QBoxLayout::Direction, sfp[1]);
	QWidget*  parent = RawPtr_to(QWidget*, sfp[2]);
	KQBoxLayout *ret_v = new KQBoxLayout(dir, parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

//void QBoxLayout.addLayout(QLayout layout, int stretch);
KMETHOD QBoxLayout_addLayout(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		QLayout*  layout = RawPtr_to(QLayout*, sfp[1]);
		int stretch = Int_to(int, sfp[2]);
		qp->addLayout(layout, stretch);
	}
	RETURNvoid_();
}

//void QBoxLayout.addSpacerItem(QSpacerItem spacerItem);
KMETHOD QBoxLayout_addSpacerItem(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		QSpacerItem*  spacerItem = RawPtr_to(QSpacerItem*, sfp[1]);
		qp->addSpacerItem(spacerItem);
	}
	RETURNvoid_();
}

//void QBoxLayout.addSpacing(int size);
KMETHOD QBoxLayout_addSpacing(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		int size = Int_to(int, sfp[1]);
		qp->addSpacing(size);
	}
	RETURNvoid_();
}

//void QBoxLayout.addStretch(int stretch);
KMETHOD QBoxLayout_addStretch(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		int stretch = Int_to(int, sfp[1]);
		qp->addStretch(stretch);
	}
	RETURNvoid_();
}

//void QBoxLayout.addStrut(int size);
KMETHOD QBoxLayout_addStrut(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		int size = Int_to(int, sfp[1]);
		qp->addStrut(size);
	}
	RETURNvoid_();
}

//void QBoxLayout.addWidget(QWidget widget, int stretch, QtAlignment alignment);
KMETHOD QBoxLayout_addWidget(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		QWidget*  widget = RawPtr_to(QWidget*, sfp[1]);
		int stretch = Int_to(int, sfp[2]);
		initFlag(alignment, Qt::Alignment, sfp[3]);
		qp->addWidget(widget, stretch, alignment);
	}
	RETURNvoid_();
}

//int QBoxLayout.getDirection();
KMETHOD QBoxLayout_getDirection(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		QBoxLayout::Direction ret_v = qp->direction();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QBoxLayout.insertLayout(int index, QLayout layout, int stretch);
KMETHOD QBoxLayout_insertLayout(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		QLayout*  layout = RawPtr_to(QLayout*, sfp[2]);
		int stretch = Int_to(int, sfp[3]);
		qp->insertLayout(index, layout, stretch);
	}
	RETURNvoid_();
}

//void QBoxLayout.insertSpacerItem(int index, QSpacerItem spacerItem);
KMETHOD QBoxLayout_insertSpacerItem(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		QSpacerItem*  spacerItem = RawPtr_to(QSpacerItem*, sfp[2]);
		qp->insertSpacerItem(index, spacerItem);
	}
	RETURNvoid_();
}

//void QBoxLayout.insertSpacing(int index, int size);
KMETHOD QBoxLayout_insertSpacing(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		int size = Int_to(int, sfp[2]);
		qp->insertSpacing(index, size);
	}
	RETURNvoid_();
}

//void QBoxLayout.insertStretch(int index, int stretch);
KMETHOD QBoxLayout_insertStretch(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		int stretch = Int_to(int, sfp[2]);
		qp->insertStretch(index, stretch);
	}
	RETURNvoid_();
}

//void QBoxLayout.insertWidget(int index, QWidget widget, int stretch, QtAlignment alignment);
KMETHOD QBoxLayout_insertWidget(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		QWidget*  widget = RawPtr_to(QWidget*, sfp[2]);
		int stretch = Int_to(int, sfp[3]);
		initFlag(alignment, Qt::Alignment, sfp[4]);
		qp->insertWidget(index, widget, stretch, alignment);
	}
	RETURNvoid_();
}

//void QBoxLayout.setDirection(int direction);
KMETHOD QBoxLayout_setDirection(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		QBoxLayout::Direction direction = Int_to(QBoxLayout::Direction, sfp[1]);
		qp->setDirection(direction);
	}
	RETURNvoid_();
}

//void QBoxLayout.setSpacing(int spacing);
KMETHOD QBoxLayout_setSpacing(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		int spacing = Int_to(int, sfp[1]);
		qp->setSpacing(spacing);
	}
	RETURNvoid_();
}

//void QBoxLayout.setStretch(int index, int stretch);
KMETHOD QBoxLayout_setStretch(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		int stretch = Int_to(int, sfp[2]);
		qp->setStretch(index, stretch);
	}
	RETURNvoid_();
}

//boolean QBoxLayout.setStretchFactor(QWidget widget, int stretch);
KMETHOD QBoxLayout_setStretchFactor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		QWidget*  widget = RawPtr_to(QWidget*, sfp[1]);
		int stretch = Int_to(int, sfp[2]);
		bool ret_v = qp->setStretchFactor(widget, stretch);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

/*
//boolean QBoxLayout.setStretchFactor(QLayout layout, int stretch);
KMETHOD QBoxLayout_setStretchFactor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		QLayout*  layout = RawPtr_to(QLayout*, sfp[1]);
		int stretch = Int_to(int, sfp[2]);
		bool ret_v = qp->setStretchFactor(layout, stretch);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}
*/
//int QBoxLayout.getSpacing();
KMETHOD QBoxLayout_getSpacing(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		int ret_v = qp->spacing();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QBoxLayout.getStretch(int index);
KMETHOD QBoxLayout_getStretch(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBoxLayout *  qp = RawPtr_to(QBoxLayout *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		int ret_v = qp->stretch(index);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}


DummyQBoxLayout::DummyQBoxLayout()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQBoxLayout::~DummyQBoxLayout()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQBoxLayout::setSelf(kRawPtr *ptr)
{
	DummyQBoxLayout::self = ptr;
	DummyQLayout::setSelf(ptr);
}

bool DummyQBoxLayout::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQLayout::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQBoxLayout::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQBoxLayout::event_map->bigin();
	if ((itr = DummyQBoxLayout::event_map->find(str)) == DummyQBoxLayout::event_map->end()) {
		bool ret = false;
		ret = DummyQLayout::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQBoxLayout::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQBoxLayout::slot_map->bigin();
	if ((itr = DummyQBoxLayout::slot_map->find(str)) == DummyQBoxLayout::slot_map->end()) {
		bool ret = false;
		ret = DummyQLayout::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQBoxLayout::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQBoxLayout::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQLayout::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQBoxLayout::connection(QObject *o)
{
	QBoxLayout *p = dynamic_cast<QBoxLayout*>(o);
	if (p != NULL) {
	}
	DummyQLayout::connection(o);
}

KQBoxLayout::KQBoxLayout(QBoxLayout::Direction dir, QWidget* parent) : QBoxLayout(dir, parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQBoxLayout();
	dummy->connection((QObject*)this);
}

KQBoxLayout::~KQBoxLayout()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QBoxLayout_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQBoxLayout *qp = RawPtr_to(KQBoxLayout *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QBoxLayout]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QBoxLayout]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QBoxLayout_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQBoxLayout *qp = RawPtr_to(KQBoxLayout *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QBoxLayout]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QBoxLayout]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QBoxLayout_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQBoxLayout *qp = (KQBoxLayout *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QBoxLayout*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QBoxLayout_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQBoxLayout *qp = (KQBoxLayout *)p->rawptr;
		KQBoxLayout *qp = static_cast<KQBoxLayout*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QBoxLayout_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQBoxLayout::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQBoxLayout::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QBoxLayout::event(event);
		return false;
	}
//	QBoxLayout::event(event);
	return true;
}

static knh_IntData_t QBoxLayoutConstInt[] = {
	{"LeftToRight", QBoxLayout::LeftToRight},
	{"RightToLeft", QBoxLayout::RightToLeft},
	{"TopToBottom", QBoxLayout::TopToBottom},
	{"BottomToTop", QBoxLayout::BottomToTop},
	{NULL, 0}
};

DEFAPI(void) constQBoxLayout(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QBoxLayoutConstInt);
}


DEFAPI(void) defQBoxLayout(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QBoxLayout";
	cdef->free = QBoxLayout_free;
	cdef->reftrace = QBoxLayout_reftrace;
	cdef->compareTo = QBoxLayout_compareTo;
}


//QBrush QBrush.new();
KMETHOD QBrush_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQBrush *ret_v = new KQBrush();
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

KMETHOD QBrush_newWithGradient(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QGradient *g = RawPtr_to(QGradient *, sfp[1]);
	KQBrush *ret_v = new KQBrush(*g);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}


/*
//QBrush QBrush.new(int style);
KMETHOD QBrush_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	Qt::BrushStyle style = Int_to(Qt::BrushStyle, sfp[1]);
	KQBrush *ret_v = new KQBrush(style);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QBrush QBrush.new(QColor color, int style);
KMETHOD QBrush_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QColor  color = *RawPtr_to(const QColor *, sfp[1]);
	Qt::BrushStyle style = Int_to(Qt::BrushStyle, sfp[2]);
	KQBrush *ret_v = new KQBrush(color, style);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QBrush QBrush.new(int color, int style);
KMETHOD QBrush_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	Qt::GlobalColor color = Int_to(Qt::GlobalColor, sfp[1]);
	Qt::BrushStyle style = Int_to(Qt::BrushStyle, sfp[2]);
	KQBrush *ret_v = new KQBrush(color, style);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QBrush QBrush.new(QColor color, QPixmap pixmap);
KMETHOD QBrush_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QColor  color = *RawPtr_to(const QColor *, sfp[1]);
	const QPixmap  pixmap = *RawPtr_to(const QPixmap *, sfp[2]);
	KQBrush *ret_v = new KQBrush(color, pixmap);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QBrush QBrush.new(int color, QPixmap pixmap);
KMETHOD QBrush_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	Qt::GlobalColor color = Int_to(Qt::GlobalColor, sfp[1]);
	const QPixmap  pixmap = *RawPtr_to(const QPixmap *, sfp[2]);
	KQBrush *ret_v = new KQBrush(color, pixmap);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QBrush QBrush.new(QPixmap pixmap);
KMETHOD QBrush_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QPixmap  pixmap = *RawPtr_to(const QPixmap *, sfp[1]);
	KQBrush *ret_v = new KQBrush(pixmap);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QBrush QBrush.new(QImage image);
KMETHOD QBrush_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QImage  image = *RawPtr_to(const QImage *, sfp[1]);
	KQBrush *ret_v = new KQBrush(image);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QBrush QBrush.new(QBrush other);
KMETHOD QBrush_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QBrush  other = *RawPtr_to(const QBrush *, sfp[1]);
	KQBrush *ret_v = new KQBrush(other);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QBrush QBrush.new(QGradient gradient);
KMETHOD QBrush_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QGradient  gradient = *RawPtr_to(const QGradient *, sfp[1]);
	KQBrush *ret_v = new KQBrush(gradient);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//QColor QBrush.getColor();
KMETHOD QBrush_getColor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBrush *  qp = RawPtr_to(QBrush *, sfp[0]);
	if (qp) {
		const QColor ret_v = qp->color();
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QGradient QBrush.gradient();
KMETHOD QBrush_gradient(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBrush *  qp = RawPtr_to(QBrush *, sfp[0]);
	if (qp) {
		const QGradient* ret_v = qp->gradient();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QGradient*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QBrush.isOpaque();
KMETHOD QBrush_isOpaque(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBrush *  qp = RawPtr_to(QBrush *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isOpaque();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//QMatrix QBrush.getMatrix();
KMETHOD QBrush_getMatrix(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBrush *  qp = RawPtr_to(QBrush *, sfp[0]);
	if (qp) {
		const QMatrix ret_v = qp->matrix();
		QMatrix *ret_v_ = new QMatrix(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QBrush.setColor(QColor color);
KMETHOD QBrush_setColor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBrush *  qp = RawPtr_to(QBrush *, sfp[0]);
	if (qp) {
		const QColor  color = *RawPtr_to(const QColor *, sfp[1]);
		qp->setColor(color);
	}
	RETURNvoid_();
}

/*
//void QBrush.setColor(int color);
KMETHOD QBrush_setColor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBrush *  qp = RawPtr_to(QBrush *, sfp[0]);
	if (qp) {
		Qt::GlobalColor color = Int_to(Qt::GlobalColor, sfp[1]);
		qp->setColor(color);
	}
	RETURNvoid_();
}
*/
//void QBrush.setMatrix(QMatrix matrix);
KMETHOD QBrush_setMatrix(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBrush *  qp = RawPtr_to(QBrush *, sfp[0]);
	if (qp) {
		const QMatrix  matrix = *RawPtr_to(const QMatrix *, sfp[1]);
		qp->setMatrix(matrix);
	}
	RETURNvoid_();
}

//void QBrush.setStyle(int style);
KMETHOD QBrush_setStyle(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBrush *  qp = RawPtr_to(QBrush *, sfp[0]);
	if (qp) {
		Qt::BrushStyle style = Int_to(Qt::BrushStyle, sfp[1]);
		qp->setStyle(style);
	}
	RETURNvoid_();
}

//void QBrush.setTexture(QPixmap pixmap);
KMETHOD QBrush_setTexture(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBrush *  qp = RawPtr_to(QBrush *, sfp[0]);
	if (qp) {
		const QPixmap  pixmap = *RawPtr_to(const QPixmap *, sfp[1]);
		qp->setTexture(pixmap);
	}
	RETURNvoid_();
}

//void QBrush.setTextureImage(QImage image);
KMETHOD QBrush_setTextureImage(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBrush *  qp = RawPtr_to(QBrush *, sfp[0]);
	if (qp) {
		const QImage  image = *RawPtr_to(const QImage *, sfp[1]);
		qp->setTextureImage(image);
	}
	RETURNvoid_();
}

//void QBrush.setTransform(QTransform matrix);
KMETHOD QBrush_setTransform(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBrush *  qp = RawPtr_to(QBrush *, sfp[0]);
	if (qp) {
		const QTransform  matrix = *RawPtr_to(const QTransform *, sfp[1]);
		qp->setTransform(matrix);
	}
	RETURNvoid_();
}

//int QBrush.getStyle();
KMETHOD QBrush_getStyle(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBrush *  qp = RawPtr_to(QBrush *, sfp[0]);
	if (qp) {
		Qt::BrushStyle ret_v = qp->style();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QPixmap QBrush.getTexture();
KMETHOD QBrush_getTexture(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBrush *  qp = RawPtr_to(QBrush *, sfp[0]);
	if (qp) {
		QPixmap ret_v = qp->texture();
		QPixmap *ret_v_ = new QPixmap(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QImage QBrush.getTextureImage();
KMETHOD QBrush_getTextureImage(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBrush *  qp = RawPtr_to(QBrush *, sfp[0]);
	if (qp) {
		QImage ret_v = qp->textureImage();
		QImage *ret_v_ = new QImage(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QTransform QBrush.getTransform();
KMETHOD QBrush_getTransform(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBrush *  qp = RawPtr_to(QBrush *, sfp[0]);
	if (qp) {
		QTransform ret_v = qp->transform();
		QTransform *ret_v_ = new QTransform(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//Array<String> QBrush.parents();
KMETHOD QBrush_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBrush *qp = RawPtr_to(QBrush*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQBrush::DummyQBrush()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQBrush::~DummyQBrush()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQBrush::setSelf(kRawPtr *ptr)
{
	DummyQBrush::self = ptr;
}

bool DummyQBrush::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQBrush::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQBrush::event_map->bigin();
	if ((itr = DummyQBrush::event_map->find(str)) == DummyQBrush::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQBrush::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQBrush::slot_map->bigin();
	if ((itr = DummyQBrush::slot_map->find(str)) == DummyQBrush::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQBrush::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQBrush::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQBrush::connection(QObject *o)
{
	QBrush *p = dynamic_cast<QBrush*>(o);
	if (p != NULL) {
	}
}

KQBrush::KQBrush() : QBrush()
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQBrush();
}

KQBrush::KQBrush(const QGradient &g) : QBrush(g)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQBrush();
}

KQBrush::~KQBrush()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QBrush_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQBrush *qp = RawPtr_to(KQBrush *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QBrush]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QBrush]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QBrush_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQBrush *qp = RawPtr_to(KQBrush *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QBrush]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QBrush]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QBrush_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQBrush *qp = (KQBrush *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QBrush*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QBrush_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQBrush *qp = (KQBrush *)p->rawptr;
		KQBrush *qp = static_cast<KQBrush*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QBrush_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (*static_cast<QBrush*>(p1->rawptr) == *static_cast<QBrush*>(p2->rawptr) ? 0 : 1);
}

void KQBrush::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQBrush(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QBrush";
	cdef->free = QBrush_free;
	cdef->reftrace = QBrush_reftrace;
	cdef->compareTo = QBrush_compareTo;
}


//@Virtual @Override boolean QBuffer.atEnd();
KMETHOD QBuffer_atEnd(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBuffer *  qp = RawPtr_to(QBuffer *, sfp[0]);
	if (qp) {
		bool ret_v = qp->atEnd();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override boolean QBuffer.canReadLine();
KMETHOD QBuffer_canReadLine(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBuffer *  qp = RawPtr_to(QBuffer *, sfp[0]);
	if (qp) {
		bool ret_v = qp->canReadLine();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override void QBuffer.close();
KMETHOD QBuffer_close(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBuffer *  qp = RawPtr_to(QBuffer *, sfp[0]);
	if (qp) {
		qp->close();
	}
	RETURNvoid_();
}

//@Virtual @Override boolean QBuffer.open(QIODeviceOpenMode flags);
KMETHOD QBuffer_open(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBuffer *  qp = RawPtr_to(QBuffer *, sfp[0]);
	if (qp) {
		initFlag(flags, QIODevice::OpenMode, sfp[1]);
		bool ret_v = qp->open(flags);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override int QBuffer.pos();
KMETHOD QBuffer_pos(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBuffer *  qp = RawPtr_to(QBuffer *, sfp[0]);
	if (qp) {
		qint64 ret_v = qp->pos();
		qint64 *ret_v_ = new qint64(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override boolean QBuffer.seek(int pos);
KMETHOD QBuffer_seek(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBuffer *  qp = RawPtr_to(QBuffer *, sfp[0]);
	if (qp) {
		qint64 pos = Int_to(qint64, sfp[1]);
		bool ret_v = qp->seek(pos);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override int QBuffer.size();
KMETHOD QBuffer_size(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBuffer *  qp = RawPtr_to(QBuffer *, sfp[0]);
	if (qp) {
		qint64 ret_v = qp->size();
		qint64 *ret_v_ = new qint64(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QBuffer QBuffer.new(QObject parent);
KMETHOD QBuffer_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QObject*  parent = RawPtr_to(QObject*, sfp[1]);
	KQBuffer *ret_v = new KQBuffer(parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QBuffer QBuffer.new(QByteArray byteArray, QObject parent);
KMETHOD QBuffer_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray*  byteArray = RawPtr_to(QByteArray*, sfp[1]);
	QObject*  parent = RawPtr_to(QObject*, sfp[2]);
	KQBuffer *ret_v = new KQBuffer(byteArray, parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//QByteArray QBuffer.getBuffer();
KMETHOD QBuffer_getBuffer(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBuffer *  qp = RawPtr_to(QBuffer *, sfp[0]);
	if (qp) {
		QByteArray ret_v = qp->buffer();
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//QByteArray QBuffer.getBuffer();
KMETHOD QBuffer_getBuffer(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBuffer *  qp = RawPtr_to(QBuffer *, sfp[0]);
	if (qp) {
		const QByteArray ret_v = qp->buffer();
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//QByteArray QBuffer.getData();
KMETHOD QBuffer_getData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBuffer *  qp = RawPtr_to(QBuffer *, sfp[0]);
	if (qp) {
		const QByteArray ret_v = qp->data();
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QBuffer.setBuffer(QByteArray byteArray);
KMETHOD QBuffer_setBuffer(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBuffer *  qp = RawPtr_to(QBuffer *, sfp[0]);
	if (qp) {
		QByteArray*  byteArray = RawPtr_to(QByteArray*, sfp[1]);
		qp->setBuffer(byteArray);
	}
	RETURNvoid_();
}

//void QBuffer.setData(QByteArray data);
KMETHOD QBuffer_setData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBuffer *  qp = RawPtr_to(QBuffer *, sfp[0]);
	if (qp) {
		const QByteArray  data = *RawPtr_to(const QByteArray *, sfp[1]);
		qp->setData(data);
	}
	RETURNvoid_();
}

/*
//void QBuffer.setData(String data, int size);
KMETHOD QBuffer_setData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QBuffer *  qp = RawPtr_to(QBuffer *, sfp[0]);
	if (qp) {
		const char*  data = RawPtr_to(const char*, sfp[1]);
		int size = Int_to(int, sfp[2]);
		qp->setData(data, size);
	}
	RETURNvoid_();
}
*/

DummyQBuffer::DummyQBuffer()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQBuffer::~DummyQBuffer()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQBuffer::setSelf(kRawPtr *ptr)
{
	DummyQBuffer::self = ptr;
	DummyQIODevice::setSelf(ptr);
}

bool DummyQBuffer::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQIODevice::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQBuffer::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQBuffer::event_map->bigin();
	if ((itr = DummyQBuffer::event_map->find(str)) == DummyQBuffer::event_map->end()) {
		bool ret = false;
		ret = DummyQIODevice::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQBuffer::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQBuffer::slot_map->bigin();
	if ((itr = DummyQBuffer::slot_map->find(str)) == DummyQBuffer::slot_map->end()) {
		bool ret = false;
		ret = DummyQIODevice::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQBuffer::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQBuffer::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQIODevice::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQBuffer::connection(QObject *o)
{
	QBuffer *p = dynamic_cast<QBuffer*>(o);
	if (p != NULL) {
	}
	DummyQIODevice::connection(o);
}

KQBuffer::KQBuffer(QObject* parent) : QBuffer(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQBuffer();
	dummy->connection((QObject*)this);
}

KQBuffer::~KQBuffer()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QBuffer_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQBuffer *qp = RawPtr_to(KQBuffer *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QBuffer]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QBuffer]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QBuffer_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQBuffer *qp = RawPtr_to(KQBuffer *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QBuffer]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QBuffer]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QBuffer_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQBuffer *qp = (KQBuffer *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QBuffer*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QBuffer_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQBuffer *qp = (KQBuffer *)p->rawptr;
		KQBuffer *qp = static_cast<KQBuffer*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QBuffer_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQBuffer::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQBuffer::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QBuffer::event(event);
		return false;
	}
//	QBuffer::event(event);
	return true;
}



DEFAPI(void) defQBuffer(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QBuffer";
	cdef->free = QBuffer_free;
	cdef->reftrace = QBuffer_reftrace;
	cdef->compareTo = QBuffer_compareTo;
}


//QButtonGroup QButtonGroup.new(QObject parent);
KMETHOD QButtonGroup_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QObject*  parent = RawPtr_to(QObject*, sfp[1]);
	KQButtonGroup *ret_v = new KQButtonGroup(parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

//void QButtonGroup.addButton(QAbstractButton button);
KMETHOD QButtonGroup_addButton(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QButtonGroup *  qp = RawPtr_to(QButtonGroup *, sfp[0]);
	if (qp) {
		QAbstractButton*  button = RawPtr_to(QAbstractButton*, sfp[1]);
		qp->addButton(button);
	}
	RETURNvoid_();
}

/*
//void QButtonGroup.addButton(QAbstractButton button, int id);
KMETHOD QButtonGroup_addButton(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QButtonGroup *  qp = RawPtr_to(QButtonGroup *, sfp[0]);
	if (qp) {
		QAbstractButton*  button = RawPtr_to(QAbstractButton*, sfp[1]);
		int id = Int_to(int, sfp[2]);
		qp->addButton(button, id);
	}
	RETURNvoid_();
}
*/
//QAbstractButton QButtonGroup.button(int id);
KMETHOD QButtonGroup_button(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QButtonGroup *  qp = RawPtr_to(QButtonGroup *, sfp[0]);
	if (qp) {
		int id = Int_to(int, sfp[1]);
		QAbstractButton* ret_v = qp->button(id);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractButton*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//Array<QAbstractButton> QButtonGroup.buttons();
KMETHOD QButtonGroup_buttons(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QButtonGroup *  qp = RawPtr_to(QButtonGroup *, sfp[0]);
	if (qp) {
		QList<QAbstractButton*> ret_v = qp->buttons();
		int list_size = ret_v.size();
		kArray *a = new_Array0(ctx, list_size);
		kclass_t cid = knh_getcid(ctx, STEXT("QAbstractButton"));
		for (int n = 0; n < list_size; n++) {
			kRawPtr *p = new_RawPtr(ctx, ClassTBL(cid), ret_v[n]);
			knh_Array_add(ctx, a, (kObject *)p);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}
	

//QAbstractButton QButtonGroup.checkedButton();
KMETHOD QButtonGroup_checkedButton(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QButtonGroup *  qp = RawPtr_to(QButtonGroup *, sfp[0]);
	if (qp) {
		QAbstractButton* ret_v = qp->checkedButton();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractButton*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QButtonGroup.checkedId();
KMETHOD QButtonGroup_checkedId(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QButtonGroup *  qp = RawPtr_to(QButtonGroup *, sfp[0]);
	if (qp) {
		int ret_v = qp->checkedId();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//boolean QButtonGroup.getExclusive();
KMETHOD QButtonGroup_getExclusive(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QButtonGroup *  qp = RawPtr_to(QButtonGroup *, sfp[0]);
	if (qp) {
		bool ret_v = qp->exclusive();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//int QButtonGroup.getId(QAbstractButton button);
KMETHOD QButtonGroup_getId(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QButtonGroup *  qp = RawPtr_to(QButtonGroup *, sfp[0]);
	if (qp) {
		QAbstractButton*  button = RawPtr_to(QAbstractButton*, sfp[1]);
		int ret_v = qp->id(button);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QButtonGroup.removeButton(QAbstractButton button);
KMETHOD QButtonGroup_removeButton(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QButtonGroup *  qp = RawPtr_to(QButtonGroup *, sfp[0]);
	if (qp) {
		QAbstractButton*  button = RawPtr_to(QAbstractButton*, sfp[1]);
		qp->removeButton(button);
	}
	RETURNvoid_();
}

//void QButtonGroup.setExclusive(boolean arg0);
KMETHOD QButtonGroup_setExclusive(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QButtonGroup *  qp = RawPtr_to(QButtonGroup *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setExclusive(arg0);
	}
	RETURNvoid_();
}

//void QButtonGroup.setId(QAbstractButton button, int id);
KMETHOD QButtonGroup_setId(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QButtonGroup *  qp = RawPtr_to(QButtonGroup *, sfp[0]);
	if (qp) {
		QAbstractButton*  button = RawPtr_to(QAbstractButton*, sfp[1]);
		int id = Int_to(int, sfp[2]);
		qp->setId(button, id);
	}
	RETURNvoid_();
}


DummyQButtonGroup::DummyQButtonGroup()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQButtonGroup::~DummyQButtonGroup()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQButtonGroup::setSelf(kRawPtr *ptr)
{
	DummyQButtonGroup::self = ptr;
	DummyQObject::setSelf(ptr);
}

bool DummyQButtonGroup::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQObject::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQButtonGroup::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQButtonGroup::event_map->bigin();
	if ((itr = DummyQButtonGroup::event_map->find(str)) == DummyQButtonGroup::event_map->end()) {
		bool ret = false;
		ret = DummyQObject::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQButtonGroup::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQButtonGroup::slot_map->bigin();
	if ((itr = DummyQButtonGroup::slot_map->find(str)) == DummyQButtonGroup::slot_map->end()) {
		bool ret = false;
		ret = DummyQObject::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQButtonGroup::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQButtonGroup::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQObject::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQButtonGroup::connection(QObject *o)
{
	QButtonGroup *p = dynamic_cast<QButtonGroup*>(o);
	if (p != NULL) {
	}
	DummyQObject::connection(o);
}

KQButtonGroup::KQButtonGroup(QObject* parent) : QButtonGroup(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQButtonGroup();
	dummy->connection((QObject*)this);
}

KQButtonGroup::~KQButtonGroup()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QButtonGroup_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQButtonGroup *qp = RawPtr_to(KQButtonGroup *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QButtonGroup]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QButtonGroup]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QButtonGroup_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQButtonGroup *qp = RawPtr_to(KQButtonGroup *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QButtonGroup]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QButtonGroup]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QButtonGroup_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQButtonGroup *qp = (KQButtonGroup *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QButtonGroup*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QButtonGroup_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQButtonGroup *qp = (KQButtonGroup *)p->rawptr;
		KQButtonGroup *qp = static_cast<KQButtonGroup*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QButtonGroup_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQButtonGroup::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQButtonGroup::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QButtonGroup::event(event);
		return false;
	}
//	QButtonGroup::event(event);
	return true;
}



DEFAPI(void) defQButtonGroup(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QButtonGroup";
	cdef->free = QButtonGroup_free;
	cdef->reftrace = QButtonGroup_reftrace;
	cdef->compareTo = QButtonGroup_compareTo;
}


//QByteArray QByteArray.new();
KMETHOD QByteArray_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQByteArray *ret_v = new KQByteArray();
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QByteArray QByteArray.new(String str);
KMETHOD QByteArray_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const char*  str = RawPtr_to(const char*, sfp[1]);
	KQByteArray *ret_v = new KQByteArray(str);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QByteArray QByteArray.new(String data, int size);
KMETHOD QByteArray_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const char*  data = RawPtr_to(const char*, sfp[1]);
	int size = Int_to(int, sfp[2]);
	KQByteArray *ret_v = new KQByteArray(data, size);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QByteArray QByteArray.new(int size, String ch);
KMETHOD QByteArray_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	int size = Int_to(int, sfp[1]);
	char  ch = *RawPtr_to(char *, sfp[2]);
	KQByteArray *ret_v = new KQByteArray(size, ch);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QByteArray QByteArray.new(QByteArray other);
KMETHOD QByteArray_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QByteArray  other = *RawPtr_to(const QByteArray *, sfp[1]);
	KQByteArray *ret_v = new KQByteArray(other);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//QByteArray QByteArray.append(QByteArray ba);
KMETHOD QByteArray_append(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const QByteArray  ba = *RawPtr_to(const QByteArray *, sfp[1]);
		QByteArray ret_v = qp->append(ba);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//QByteArray QByteArray.append(String str);
KMETHOD QByteArray_append(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const QString str = String_to(const QString, sfp[1]);
		QByteArray ret_v = qp->append(str);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.append(String str);
KMETHOD QByteArray_append(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const char*  str = RawPtr_to(const char*, sfp[1]);
		QByteArray ret_v = qp->append(str);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.append(String str, int len);
KMETHOD QByteArray_append(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const char*  str = RawPtr_to(const char*, sfp[1]);
		int len = Int_to(int, sfp[2]);
		QByteArray ret_v = qp->append(str, len);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.append(String ch);
KMETHOD QByteArray_append(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		char  ch = *RawPtr_to(char *, sfp[1]);
		QByteArray ret_v = qp->append(ch);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//String QByteArray.at(int i);
KMETHOD QByteArray_at(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int i = Int_to(int, sfp[1]);
		char ret_v = qp->at(i);
		char *ret_v_ = new char(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QByteArray.capacity();
KMETHOD QByteArray_capacity(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int ret_v = qp->capacity();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QByteArray.chop(int n);
KMETHOD QByteArray_chop(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int n = Int_to(int, sfp[1]);
		qp->chop(n);
	}
	RETURNvoid_();
}

//void QByteArray.clear();
KMETHOD QByteArray_clear(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		qp->clear();
	}
	RETURNvoid_();
}

//String QByteArray.constData();
KMETHOD QByteArray_constData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const char* ret_v = qp->constData();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (char*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QByteArray.contains(QByteArray ba);
KMETHOD QByteArray_contains(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const QByteArray  ba = *RawPtr_to(const QByteArray *, sfp[1]);
		bool ret_v = qp->contains(ba);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

/*
//boolean QByteArray.contains(String str);
KMETHOD QByteArray_contains(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const char*  str = RawPtr_to(const char*, sfp[1]);
		bool ret_v = qp->contains(str);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}
*/
/*
//boolean QByteArray.contains(String ch);
KMETHOD QByteArray_contains(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		char  ch = *RawPtr_to(char *, sfp[1]);
		bool ret_v = qp->contains(ch);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}
*/
//int QByteArray.count(QByteArray ba);
KMETHOD QByteArray_count(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const QByteArray  ba = *RawPtr_to(const QByteArray *, sfp[1]);
		int ret_v = qp->count(ba);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

/*
//int QByteArray.count(String str);
KMETHOD QByteArray_count(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const char*  str = RawPtr_to(const char*, sfp[1]);
		int ret_v = qp->count(str);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
/*
//int QByteArray.count(String ch);
KMETHOD QByteArray_count(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		char  ch = *RawPtr_to(char *, sfp[1]);
		int ret_v = qp->count(ch);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
/*
//int QByteArray.count();
KMETHOD QByteArray_count(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int ret_v = qp->count();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
//String QByteArray.data();
KMETHOD QByteArray_data(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		char* ret_v = qp->data();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (char*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//String QByteArray.data();
KMETHOD QByteArray_data(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const char* ret_v = qp->data();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (char*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//boolean QByteArray.endsWith(QByteArray ba);
KMETHOD QByteArray_endsWith(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const QByteArray  ba = *RawPtr_to(const QByteArray *, sfp[1]);
		bool ret_v = qp->endsWith(ba);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

/*
//boolean QByteArray.endsWith(String str);
KMETHOD QByteArray_endsWith(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const char*  str = RawPtr_to(const char*, sfp[1]);
		bool ret_v = qp->endsWith(str);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}
*/
/*
//boolean QByteArray.endsWith(String ch);
KMETHOD QByteArray_endsWith(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		char  ch = *RawPtr_to(char *, sfp[1]);
		bool ret_v = qp->endsWith(ch);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}
*/
//QByteArray QByteArray.fill(String ch, int size);
KMETHOD QByteArray_fill(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		char  ch = *RawPtr_to(char *, sfp[1]);
		int size = Int_to(int, sfp[2]);
		QByteArray ret_v = qp->fill(ch, size);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QByteArray.indexOf(QByteArray ba, int from_);
KMETHOD QByteArray_indexOf(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const QByteArray  ba = *RawPtr_to(const QByteArray *, sfp[1]);
		int from = Int_to(int, sfp[2]);
		int ret_v = qp->indexOf(ba, from);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

/*
//int QByteArray.indexOf(String str, int from_);
KMETHOD QByteArray_indexOf(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const QString str = String_to(const QString, sfp[1]);
		int from = Int_to(int, sfp[2]);
		int ret_v = qp->indexOf(str, from);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
/*
//int QByteArray.indexOf(String str, int from_);
KMETHOD QByteArray_indexOf(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const char*  str = RawPtr_to(const char*, sfp[1]);
		int from = Int_to(int, sfp[2]);
		int ret_v = qp->indexOf(str, from);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
/*
//int QByteArray.indexOf(String ch, int from_);
KMETHOD QByteArray_indexOf(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		char  ch = *RawPtr_to(char *, sfp[1]);
		int from = Int_to(int, sfp[2]);
		int ret_v = qp->indexOf(ch, from);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
//QByteArray QByteArray.insert(int i, QByteArray ba);
KMETHOD QByteArray_insert(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int i = Int_to(int, sfp[1]);
		const QByteArray  ba = *RawPtr_to(const QByteArray *, sfp[2]);
		QByteArray ret_v = qp->insert(i, ba);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//QByteArray QByteArray.insert(int i, String str);
KMETHOD QByteArray_insert(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int i = Int_to(int, sfp[1]);
		const QString str = String_to(const QString, sfp[2]);
		QByteArray ret_v = qp->insert(i, str);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.insert(int i, String str);
KMETHOD QByteArray_insert(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int i = Int_to(int, sfp[1]);
		const char*  str = RawPtr_to(const char*, sfp[2]);
		QByteArray ret_v = qp->insert(i, str);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.insert(int i, String str, int len);
KMETHOD QByteArray_insert(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int i = Int_to(int, sfp[1]);
		const char*  str = RawPtr_to(const char*, sfp[2]);
		int len = Int_to(int, sfp[3]);
		QByteArray ret_v = qp->insert(i, str, len);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.insert(int i, String ch);
KMETHOD QByteArray_insert(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int i = Int_to(int, sfp[1]);
		char  ch = *RawPtr_to(char *, sfp[2]);
		QByteArray ret_v = qp->insert(i, ch);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//boolean QByteArray.isEmpty();
KMETHOD QByteArray_isEmpty(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isEmpty();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//int QByteArray.lastIndexOf(QByteArray ba, int from_);
KMETHOD QByteArray_lastIndexOf(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const QByteArray  ba = *RawPtr_to(const QByteArray *, sfp[1]);
		int from = Int_to(int, sfp[2]);
		int ret_v = qp->lastIndexOf(ba, from);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

/*
//int QByteArray.lastIndexOf(String str, int from_);
KMETHOD QByteArray_lastIndexOf(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const QString str = String_to(const QString, sfp[1]);
		int from = Int_to(int, sfp[2]);
		int ret_v = qp->lastIndexOf(str, from);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
/*
//int QByteArray.lastIndexOf(String str, int from_);
KMETHOD QByteArray_lastIndexOf(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const char*  str = RawPtr_to(const char*, sfp[1]);
		int from = Int_to(int, sfp[2]);
		int ret_v = qp->lastIndexOf(str, from);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
/*
//int QByteArray.lastIndexOf(String ch, int from_);
KMETHOD QByteArray_lastIndexOf(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		char  ch = *RawPtr_to(char *, sfp[1]);
		int from = Int_to(int, sfp[2]);
		int ret_v = qp->lastIndexOf(ch, from);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
//QByteArray QByteArray.left(int len);
KMETHOD QByteArray_left(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int len = Int_to(int, sfp[1]);
		QByteArray ret_v = qp->left(len);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QByteArray QByteArray.leftJustified(int width, String fill, boolean truncate);
KMETHOD QByteArray_leftJustified(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int width = Int_to(int, sfp[1]);
		char  fill = *RawPtr_to(char *, sfp[2]);
		bool truncate = Boolean_to(bool, sfp[3]);
		QByteArray ret_v = qp->leftJustified(width, fill, truncate);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QByteArray.length();
KMETHOD QByteArray_length(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int ret_v = qp->length();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QByteArray QByteArray.mid(int pos, int len);
KMETHOD QByteArray_mid(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int pos = Int_to(int, sfp[1]);
		int len = Int_to(int, sfp[2]);
		QByteArray ret_v = qp->mid(pos, len);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QByteArray QByteArray.prepend(QByteArray ba);
KMETHOD QByteArray_prepend(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const QByteArray  ba = *RawPtr_to(const QByteArray *, sfp[1]);
		QByteArray ret_v = qp->prepend(ba);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//QByteArray QByteArray.prepend(String str);
KMETHOD QByteArray_prepend(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const char*  str = RawPtr_to(const char*, sfp[1]);
		QByteArray ret_v = qp->prepend(str);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.prepend(String str, int len);
KMETHOD QByteArray_prepend(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const char*  str = RawPtr_to(const char*, sfp[1]);
		int len = Int_to(int, sfp[2]);
		QByteArray ret_v = qp->prepend(str, len);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.prepend(String ch);
KMETHOD QByteArray_prepend(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		char  ch = *RawPtr_to(char *, sfp[1]);
		QByteArray ret_v = qp->prepend(ch);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//void QByteArray.push_back(QByteArray other);
KMETHOD QByteArray_push_back(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const QByteArray  other = *RawPtr_to(const QByteArray *, sfp[1]);
		qp->push_back(other);
	}
	RETURNvoid_();
}

/*
//void QByteArray.push_back(String str);
KMETHOD QByteArray_push_back(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const char*  str = RawPtr_to(const char*, sfp[1]);
		qp->push_back(str);
	}
	RETURNvoid_();
}
*/
/*
//void QByteArray.push_back(String ch);
KMETHOD QByteArray_push_back(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		char  ch = *RawPtr_to(char *, sfp[1]);
		qp->push_back(ch);
	}
	RETURNvoid_();
}
*/
//void QByteArray.push_front(QByteArray other);
KMETHOD QByteArray_push_front(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const QByteArray  other = *RawPtr_to(const QByteArray *, sfp[1]);
		qp->push_front(other);
	}
	RETURNvoid_();
}

/*
//void QByteArray.push_front(String str);
KMETHOD QByteArray_push_front(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const char*  str = RawPtr_to(const char*, sfp[1]);
		qp->push_front(str);
	}
	RETURNvoid_();
}
*/
/*
//void QByteArray.push_front(String ch);
KMETHOD QByteArray_push_front(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		char  ch = *RawPtr_to(char *, sfp[1]);
		qp->push_front(ch);
	}
	RETURNvoid_();
}
*/
//QByteArray QByteArray.remove(int pos, int len);
KMETHOD QByteArray_remove(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int pos = Int_to(int, sfp[1]);
		int len = Int_to(int, sfp[2]);
		QByteArray ret_v = qp->remove(pos, len);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QByteArray QByteArray.repeated(int times);
KMETHOD QByteArray_repeated(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int times = Int_to(int, sfp[1]);
		QByteArray ret_v = qp->repeated(times);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QByteArray QByteArray.replace(int pos, int len, QByteArray after);
KMETHOD QByteArray_replace(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int pos = Int_to(int, sfp[1]);
		int len = Int_to(int, sfp[2]);
		const QByteArray  after = *RawPtr_to(const QByteArray *, sfp[3]);
		QByteArray ret_v = qp->replace(pos, len, after);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//QByteArray QByteArray.replace(int pos, int len, String after);
KMETHOD QByteArray_replace(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int pos = Int_to(int, sfp[1]);
		int len = Int_to(int, sfp[2]);
		const char*  after = RawPtr_to(const char*, sfp[3]);
		QByteArray ret_v = qp->replace(pos, len, after);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.replace(int pos, int len, String after, int alen);
KMETHOD QByteArray_replace(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int pos = Int_to(int, sfp[1]);
		int len = Int_to(int, sfp[2]);
		const char*  after = RawPtr_to(const char*, sfp[3]);
		int alen = Int_to(int, sfp[4]);
		QByteArray ret_v = qp->replace(pos, len, after, alen);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.replace(QByteArray before, QByteArray after);
KMETHOD QByteArray_replace(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const QByteArray  before = *RawPtr_to(const QByteArray *, sfp[1]);
		const QByteArray  after = *RawPtr_to(const QByteArray *, sfp[2]);
		QByteArray ret_v = qp->replace(before, after);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.replace(String before, QByteArray after);
KMETHOD QByteArray_replace(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const char*  before = RawPtr_to(const char*, sfp[1]);
		const QByteArray  after = *RawPtr_to(const QByteArray *, sfp[2]);
		QByteArray ret_v = qp->replace(before, after);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.replace(String before, int bsize, String after, int asize);
KMETHOD QByteArray_replace(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const char*  before = RawPtr_to(const char*, sfp[1]);
		int bsize = Int_to(int, sfp[2]);
		const char*  after = RawPtr_to(const char*, sfp[3]);
		int asize = Int_to(int, sfp[4]);
		QByteArray ret_v = qp->replace(before, bsize, after, asize);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.replace(QByteArray before, String after);
KMETHOD QByteArray_replace(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const QByteArray  before = *RawPtr_to(const QByteArray *, sfp[1]);
		const char*  after = RawPtr_to(const char*, sfp[2]);
		QByteArray ret_v = qp->replace(before, after);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.replace(String before, QByteArray after);
KMETHOD QByteArray_replace(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const QString before = String_to(const QString, sfp[1]);
		const QByteArray  after = *RawPtr_to(const QByteArray *, sfp[2]);
		QByteArray ret_v = qp->replace(before, after);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.replace(String before, String after);
KMETHOD QByteArray_replace(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const QString before = String_to(const QString, sfp[1]);
		const char*  after = RawPtr_to(const char*, sfp[2]);
		QByteArray ret_v = qp->replace(before, after);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.replace(String before, String after);
KMETHOD QByteArray_replace(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const char*  before = RawPtr_to(const char*, sfp[1]);
		const char*  after = RawPtr_to(const char*, sfp[2]);
		QByteArray ret_v = qp->replace(before, after);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.replace(String before, QByteArray after);
KMETHOD QByteArray_replace(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		char  before = *RawPtr_to(char *, sfp[1]);
		const QByteArray  after = *RawPtr_to(const QByteArray *, sfp[2]);
		QByteArray ret_v = qp->replace(before, after);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.replace(String before, String after);
KMETHOD QByteArray_replace(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		char  before = *RawPtr_to(char *, sfp[1]);
		const QString after = String_to(const QString, sfp[2]);
		QByteArray ret_v = qp->replace(before, after);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.replace(String before, String after);
KMETHOD QByteArray_replace(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		char  before = *RawPtr_to(char *, sfp[1]);
		const char*  after = RawPtr_to(const char*, sfp[2]);
		QByteArray ret_v = qp->replace(before, after);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.replace(String before, String after);
KMETHOD QByteArray_replace(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		char  before = *RawPtr_to(char *, sfp[1]);
		char  after = *RawPtr_to(char *, sfp[2]);
		QByteArray ret_v = qp->replace(before, after);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//void QByteArray.reserve(int size);
KMETHOD QByteArray_reserve(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int size = Int_to(int, sfp[1]);
		qp->reserve(size);
	}
	RETURNvoid_();
}

//void QByteArray.resize(int size);
KMETHOD QByteArray_resize(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int size = Int_to(int, sfp[1]);
		qp->resize(size);
	}
	RETURNvoid_();
}

//QByteArray QByteArray.right(int len);
KMETHOD QByteArray_right(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int len = Int_to(int, sfp[1]);
		QByteArray ret_v = qp->right(len);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QByteArray QByteArray.rightJustified(int width, String fill, boolean truncate);
KMETHOD QByteArray_rightJustified(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int width = Int_to(int, sfp[1]);
		char  fill = *RawPtr_to(char *, sfp[2]);
		bool truncate = Boolean_to(bool, sfp[3]);
		QByteArray ret_v = qp->rightJustified(width, fill, truncate);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QByteArray QByteArray.setNum(int n, int base);
KMETHOD QByteArray_setNum(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int n = Int_to(int, sfp[1]);
		int base = Int_to(int, sfp[2]);
		QByteArray ret_v = qp->setNum(n, base);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//QByteArray QByteArray.setNum(int n, int base);
KMETHOD QByteArray_setNum(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		uint  n = *RawPtr_to(uint *, sfp[1]);
		int base = Int_to(int, sfp[2]);
		QByteArray ret_v = qp->setNum(n, base);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.setNum(short n, int base);
KMETHOD QByteArray_setNum(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		short  n = *RawPtr_to(short *, sfp[1]);
		int base = Int_to(int, sfp[2]);
		QByteArray ret_v = qp->setNum(n, base);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.setNum(int n, int base);
KMETHOD QByteArray_setNum(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		ushort  n = *RawPtr_to(ushort *, sfp[1]);
		int base = Int_to(int, sfp[2]);
		QByteArray ret_v = qp->setNum(n, base);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.setNum(int n, int base);
KMETHOD QByteArray_setNum(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		qlonglong  n = *RawPtr_to(qlonglong *, sfp[1]);
		int base = Int_to(int, sfp[2]);
		QByteArray ret_v = qp->setNum(n, base);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.setNum(int n, int base);
KMETHOD QByteArray_setNum(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		qulonglong  n = *RawPtr_to(qulonglong *, sfp[1]);
		int base = Int_to(int, sfp[2]);
		QByteArray ret_v = qp->setNum(n, base);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.setNum(double n, String f, int prec);
KMETHOD QByteArray_setNum(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		double  n = *RawPtr_to(double *, sfp[1]);
		char  f = *RawPtr_to(char *, sfp[2]);
		int prec = Int_to(int, sfp[3]);
		QByteArray ret_v = qp->setNum(n, f, prec);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.setNum(float n, String f, int prec);
KMETHOD QByteArray_setNum(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		float n = Float_to(float, sfp[1]);
		char  f = *RawPtr_to(char *, sfp[2]);
		int prec = Int_to(int, sfp[3]);
		QByteArray ret_v = qp->setNum(n, f, prec);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//QByteArray QByteArray.setRawData(String data, int size);
KMETHOD QByteArray_setRawData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const char*  data = RawPtr_to(const char*, sfp[1]);
		uint  size = *RawPtr_to(uint *, sfp[2]);
		QByteArray ret_v = qp->setRawData(data, size);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QByteArray QByteArray.simplified();
KMETHOD QByteArray_simplified(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		QByteArray ret_v = qp->simplified();
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QByteArray.size();
KMETHOD QByteArray_size(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int ret_v = qp->size();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//Array<QByteArray> QByteArray.split(String sep);
KMETHOD QByteArray_split(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		char  sep = *RawPtr_to(char *, sfp[1]);
		QList<QByteArray> ret_v = qp->split(sep);
		int list_size = ret_v.size();
		kArray *a = new_Array0(ctx, list_size);
		kclass_t cid = knh_getcid(ctx, STEXT("QByteArray"));
		for (int n = 0; n < list_size; n++) {
			QByteArray *ret_v_ = new QByteArray(ret_v[n]);
			kRawPtr *p = new_RawPtr(ctx, ClassTBL(cid), ret_v_);
			knh_Array_add(ctx, a, (kObject *)p);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}
	

//void QByteArray.squeeze();
KMETHOD QByteArray_squeeze(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		qp->squeeze();
	}
	RETURNvoid_();
}

//boolean QByteArray.startsWith(QByteArray ba);
KMETHOD QByteArray_startsWith(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const QByteArray  ba = *RawPtr_to(const QByteArray *, sfp[1]);
		bool ret_v = qp->startsWith(ba);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

/*
//boolean QByteArray.startsWith(String str);
KMETHOD QByteArray_startsWith(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const char*  str = RawPtr_to(const char*, sfp[1]);
		bool ret_v = qp->startsWith(str);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}
*/
/*
//boolean QByteArray.startsWith(String ch);
KMETHOD QByteArray_startsWith(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		char  ch = *RawPtr_to(char *, sfp[1]);
		bool ret_v = qp->startsWith(ch);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}
*/
//QByteArray QByteArray.toBase64();
KMETHOD QByteArray_toBase64(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		QByteArray ret_v = qp->toBase64();
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//double QByteArray.toDouble(boolean ok);
KMETHOD QByteArray_toDouble(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		bool* ok = Boolean_to(bool*, sfp[1]);
		double ret_v = qp->toDouble(ok);
		double *ret_v_ = new double(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//float QByteArray.toFloat(boolean ok);
KMETHOD QByteArray_toFloat(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		bool* ok = Boolean_to(bool*, sfp[1]);
		float ret_v = qp->toFloat(ok);
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//QByteArray QByteArray.toHex();
KMETHOD QByteArray_toHex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		QByteArray ret_v = qp->toHex();
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QByteArray.toInt(boolean ok, int base);
KMETHOD QByteArray_toInt(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		bool* ok = Boolean_to(bool*, sfp[1]);
		int base = Int_to(int, sfp[2]);
		int ret_v = qp->toInt(ok, base);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//long QByteArray.toLong(boolean ok, int base);
KMETHOD QByteArray_toLong(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		bool* ok = Boolean_to(bool*, sfp[1]);
		int base = Int_to(int, sfp[2]);
		long ret_v = qp->toLong(ok, base);
		long *ret_v_ = new long(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QByteArray.toLongLong(boolean ok, int base);
KMETHOD QByteArray_toLongLong(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		bool* ok = Boolean_to(bool*, sfp[1]);
		int base = Int_to(int, sfp[2]);
		qlonglong ret_v = qp->toLongLong(ok, base);
		qlonglong *ret_v_ = new qlonglong(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QByteArray QByteArray.toLower();
KMETHOD QByteArray_toLower(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		QByteArray ret_v = qp->toLower();
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QByteArray QByteArray.toPercentEncoding(QByteArray exclude, QByteArray inc, String percent);
KMETHOD QByteArray_toPercentEncoding(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		const QByteArray  exclude = *RawPtr_to(const QByteArray *, sfp[1]);
		const QByteArray  include = *RawPtr_to(const QByteArray *, sfp[2]);
		char  percent = *RawPtr_to(char *, sfp[3]);
		QByteArray ret_v = qp->toPercentEncoding(exclude, include, percent);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//short QByteArray.toShort(boolean ok, int base);
KMETHOD QByteArray_toShort(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		bool* ok = Boolean_to(bool*, sfp[1]);
		int base = Int_to(int, sfp[2]);
		short ret_v = qp->toShort(ok, base);
		short *ret_v_ = new short(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QByteArray.toUInt(boolean ok, int base);
KMETHOD QByteArray_toUInt(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		bool* ok = Boolean_to(bool*, sfp[1]);
		int base = Int_to(int, sfp[2]);
		uint ret_v = qp->toUInt(ok, base);
		uint *ret_v_ = new uint(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QByteArray.toULong(boolean ok, int base);
KMETHOD QByteArray_toULong(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		bool* ok = Boolean_to(bool*, sfp[1]);
		int base = Int_to(int, sfp[2]);
		ulong ret_v = qp->toULong(ok, base);
		ulong *ret_v_ = new ulong(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QByteArray.toULongLong(boolean ok, int base);
KMETHOD QByteArray_toULongLong(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		bool* ok = Boolean_to(bool*, sfp[1]);
		int base = Int_to(int, sfp[2]);
		qulonglong ret_v = qp->toULongLong(ok, base);
		qulonglong *ret_v_ = new qulonglong(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QByteArray.toUShort(boolean ok, int base);
KMETHOD QByteArray_toUShort(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		bool* ok = Boolean_to(bool*, sfp[1]);
		int base = Int_to(int, sfp[2]);
		ushort ret_v = qp->toUShort(ok, base);
		ushort *ret_v_ = new ushort(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QByteArray QByteArray.toUpper();
KMETHOD QByteArray_toUpper(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		QByteArray ret_v = qp->toUpper();
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QByteArray QByteArray.trimmed();
KMETHOD QByteArray_trimmed(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		QByteArray ret_v = qp->trimmed();
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QByteArray.truncate(int pos);
KMETHOD QByteArray_truncate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *  qp = RawPtr_to(QByteArray *, sfp[0]);
	if (qp) {
		int pos = Int_to(int, sfp[1]);
		qp->truncate(pos);
	}
	RETURNvoid_();
}

//QByteArray QByteArray.fromBase64(QByteArray base64);
KMETHOD QByteArray_fromBase64(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QByteArray  base64 = *RawPtr_to(const QByteArray *, sfp[1]);
		QByteArray ret_v = QByteArray::fromBase64(base64);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QByteArray QByteArray.fromHex(QByteArray hexEncoded);
KMETHOD QByteArray_fromHex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QByteArray  hexEncoded = *RawPtr_to(const QByteArray *, sfp[1]);
		QByteArray ret_v = QByteArray::fromHex(hexEncoded);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QByteArray QByteArray.fromPercentEncoding(QByteArray input, String percent);
KMETHOD QByteArray_fromPercentEncoding(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QByteArray  input = *RawPtr_to(const QByteArray *, sfp[1]);
		char  percent = *RawPtr_to(char *, sfp[2]);
		QByteArray ret_v = QByteArray::fromPercentEncoding(input, percent);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QByteArray QByteArray.fromRawData(String data, int size);
KMETHOD QByteArray_fromRawData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const char*  data = RawPtr_to(const char*, sfp[1]);
		int size = Int_to(int, sfp[2]);
		QByteArray ret_v = QByteArray::fromRawData(data, size);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QByteArray QByteArray.number(int n, int base);
KMETHOD QByteArray_number(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int n = Int_to(int, sfp[1]);
		int base = Int_to(int, sfp[2]);
		QByteArray ret_v = QByteArray::number(n, base);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//QByteArray QByteArray.number(int n, int base);
KMETHOD QByteArray_number(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  n = *RawPtr_to(uint *, sfp[1]);
		int base = Int_to(int, sfp[2]);
		QByteArray ret_v = QByteArray::number(n, base);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.number(int n, int base);
KMETHOD QByteArray_number(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		qlonglong  n = *RawPtr_to(qlonglong *, sfp[1]);
		int base = Int_to(int, sfp[2]);
		QByteArray ret_v = QByteArray::number(n, base);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.number(int n, int base);
KMETHOD QByteArray_number(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		qulonglong  n = *RawPtr_to(qulonglong *, sfp[1]);
		int base = Int_to(int, sfp[2]);
		QByteArray ret_v = QByteArray::number(n, base);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QByteArray QByteArray.number(double n, String f, int prec);
KMETHOD QByteArray_number(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		double  n = *RawPtr_to(double *, sfp[1]);
		char  f = *RawPtr_to(char *, sfp[2]);
		int prec = Int_to(int, sfp[3]);
		QByteArray ret_v = QByteArray::number(n, f, prec);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//Array<String> QByteArray.parents();
KMETHOD QByteArray_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArray *qp = RawPtr_to(QByteArray*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQByteArray::DummyQByteArray()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQByteArray::~DummyQByteArray()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQByteArray::setSelf(kRawPtr *ptr)
{
	DummyQByteArray::self = ptr;
}

bool DummyQByteArray::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQByteArray::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQByteArray::event_map->bigin();
	if ((itr = DummyQByteArray::event_map->find(str)) == DummyQByteArray::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQByteArray::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQByteArray::slot_map->bigin();
	if ((itr = DummyQByteArray::slot_map->find(str)) == DummyQByteArray::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQByteArray::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQByteArray::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQByteArray::connection(QObject *o)
{
	QByteArray *p = dynamic_cast<QByteArray*>(o);
	if (p != NULL) {
	}
}

KQByteArray::KQByteArray() : QByteArray()
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQByteArray();
}

KQByteArray::~KQByteArray()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QByteArray_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQByteArray *qp = RawPtr_to(KQByteArray *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QByteArray]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QByteArray]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QByteArray_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQByteArray *qp = RawPtr_to(KQByteArray *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QByteArray]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QByteArray]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QByteArray_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQByteArray *qp = (KQByteArray *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QByteArray*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QByteArray_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQByteArray *qp = (KQByteArray *)p->rawptr;
		KQByteArray *qp = static_cast<KQByteArray*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QByteArray_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (*static_cast<QByteArray*>(p1->rawptr) == *static_cast<QByteArray*>(p2->rawptr) ? 0 : 1);
}

void KQByteArray::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQByteArray(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QByteArray";
	cdef->free = QByteArray_free;
	cdef->reftrace = QByteArray_reftrace;
	cdef->compareTo = QByteArray_compareTo;
}


//QByteArrayMatcher QByteArrayMatcher.new();
KMETHOD QByteArrayMatcher_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQByteArrayMatcher *ret_v = new KQByteArrayMatcher();
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QByteArrayMatcher QByteArrayMatcher.new(QByteArray pattern);
KMETHOD QByteArrayMatcher_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QByteArray  pattern = *RawPtr_to(const QByteArray *, sfp[1]);
	KQByteArrayMatcher *ret_v = new KQByteArrayMatcher(pattern);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QByteArrayMatcher QByteArrayMatcher.new(String pattern, int length);
KMETHOD QByteArrayMatcher_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const char*  pattern = RawPtr_to(const char*, sfp[1]);
	int length = Int_to(int, sfp[2]);
	KQByteArrayMatcher *ret_v = new KQByteArrayMatcher(pattern, length);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QByteArrayMatcher QByteArrayMatcher.new(QByteArrayMatcher other);
KMETHOD QByteArrayMatcher_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QByteArrayMatcher  other = *RawPtr_to(const QByteArrayMatcher *, sfp[1]);
	KQByteArrayMatcher *ret_v = new KQByteArrayMatcher(other);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//int QByteArrayMatcher.indexIn(QByteArray ba, int from_);
KMETHOD QByteArrayMatcher_indexIn(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArrayMatcher *  qp = RawPtr_to(QByteArrayMatcher *, sfp[0]);
	if (qp) {
		const QByteArray  ba = *RawPtr_to(const QByteArray *, sfp[1]);
		int from = Int_to(int, sfp[2]);
		int ret_v = qp->indexIn(ba, from);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

/*
//int QByteArrayMatcher.indexIn(String str, int len, int from_);
KMETHOD QByteArrayMatcher_indexIn(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArrayMatcher *  qp = RawPtr_to(QByteArrayMatcher *, sfp[0]);
	if (qp) {
		const char*  str = RawPtr_to(const char*, sfp[1]);
		int len = Int_to(int, sfp[2]);
		int from = Int_to(int, sfp[3]);
		int ret_v = qp->indexIn(str, len, from);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
//QByteArray QByteArrayMatcher.getPattern();
KMETHOD QByteArrayMatcher_getPattern(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArrayMatcher *  qp = RawPtr_to(QByteArrayMatcher *, sfp[0]);
	if (qp) {
		QByteArray ret_v = qp->pattern();
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QByteArrayMatcher.setPattern(QByteArray pattern);
KMETHOD QByteArrayMatcher_setPattern(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArrayMatcher *  qp = RawPtr_to(QByteArrayMatcher *, sfp[0]);
	if (qp) {
		const QByteArray  pattern = *RawPtr_to(const QByteArray *, sfp[1]);
		qp->setPattern(pattern);
	}
	RETURNvoid_();
}

//Array<String> QByteArrayMatcher.parents();
KMETHOD QByteArrayMatcher_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QByteArrayMatcher *qp = RawPtr_to(QByteArrayMatcher*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQByteArrayMatcher::DummyQByteArrayMatcher()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQByteArrayMatcher::~DummyQByteArrayMatcher()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQByteArrayMatcher::setSelf(kRawPtr *ptr)
{
	DummyQByteArrayMatcher::self = ptr;
}

bool DummyQByteArrayMatcher::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQByteArrayMatcher::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQByteArrayMatcher::event_map->bigin();
	if ((itr = DummyQByteArrayMatcher::event_map->find(str)) == DummyQByteArrayMatcher::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQByteArrayMatcher::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQByteArrayMatcher::slot_map->bigin();
	if ((itr = DummyQByteArrayMatcher::slot_map->find(str)) == DummyQByteArrayMatcher::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQByteArrayMatcher::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQByteArrayMatcher::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQByteArrayMatcher::connection(QObject *o)
{
	QByteArrayMatcher *p = dynamic_cast<QByteArrayMatcher*>(o);
	if (p != NULL) {
	}
}

KQByteArrayMatcher::KQByteArrayMatcher() : QByteArrayMatcher()
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQByteArrayMatcher();
}

KQByteArrayMatcher::~KQByteArrayMatcher()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QByteArrayMatcher_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQByteArrayMatcher *qp = RawPtr_to(KQByteArrayMatcher *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QByteArrayMatcher]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QByteArrayMatcher]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QByteArrayMatcher_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQByteArrayMatcher *qp = RawPtr_to(KQByteArrayMatcher *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QByteArrayMatcher]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QByteArrayMatcher]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QByteArrayMatcher_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQByteArrayMatcher *qp = (KQByteArrayMatcher *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QByteArrayMatcher*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QByteArrayMatcher_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQByteArrayMatcher *qp = (KQByteArrayMatcher *)p->rawptr;
		KQByteArrayMatcher *qp = static_cast<KQByteArrayMatcher*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QByteArrayMatcher_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQByteArrayMatcher::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQByteArrayMatcher(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QByteArrayMatcher";
	cdef->free = QByteArrayMatcher_free;
	cdef->reftrace = QByteArrayMatcher_reftrace;
	cdef->compareTo = QByteArrayMatcher_compareTo;
}


//@Virtual @Override void QCDEStyle.drawControl(int element, QStyleOption opt, QPainter p, QWidget widget);
KMETHOD QCDEStyle_drawControl(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCDEStyle *  qp = RawPtr_to(QCDEStyle *, sfp[0]);
	if (qp) {
		QCDEStyle::ControlElement element = Int_to(QCDEStyle::ControlElement, sfp[1]);
		const QStyleOption*  opt = RawPtr_to(const QStyleOption*, sfp[2]);
		QPainter*  p = RawPtr_to(QPainter*, sfp[3]);
		const QWidget*  widget = RawPtr_to(const QWidget*, sfp[4]);
		qp->drawControl(element, opt, p, widget);
	}
	RETURNvoid_();
}

//@Virtual @Override void QCDEStyle.drawPrimitive(int pe, QStyleOption opt, QPainter p, QWidget widget);
KMETHOD QCDEStyle_drawPrimitive(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCDEStyle *  qp = RawPtr_to(QCDEStyle *, sfp[0]);
	if (qp) {
		QCDEStyle::PrimitiveElement pe = Int_to(QCDEStyle::PrimitiveElement, sfp[1]);
		const QStyleOption*  opt = RawPtr_to(const QStyleOption*, sfp[2]);
		QPainter*  p = RawPtr_to(QPainter*, sfp[3]);
		const QWidget*  widget = RawPtr_to(const QWidget*, sfp[4]);
		qp->drawPrimitive(pe, opt, p, widget);
	}
	RETURNvoid_();
}

//@Virtual @Override int QCDEStyle.pixelMetric(int metric, QStyleOption option, QWidget widget);
KMETHOD QCDEStyle_pixelMetric(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCDEStyle *  qp = RawPtr_to(QCDEStyle *, sfp[0]);
	if (qp) {
		QCDEStyle::PixelMetric metric = Int_to(QCDEStyle::PixelMetric, sfp[1]);
		const QStyleOption*  option = RawPtr_to(const QStyleOption*, sfp[2]);
		const QWidget*  widget = RawPtr_to(const QWidget*, sfp[3]);
		int ret_v = qp->pixelMetric(metric, option, widget);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual @Override QPalette QCDEStyle.standardPalette();
KMETHOD QCDEStyle_standardPalette(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCDEStyle *  qp = RawPtr_to(QCDEStyle *, sfp[0]);
	if (qp) {
		QPalette ret_v = qp->standardPalette();
		QPalette *ret_v_ = new QPalette(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QCDEStyle QCDEStyle.new(boolean useHighlightCols);
KMETHOD QCDEStyle_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	bool useHighlightCols = Boolean_to(bool, sfp[1]);
	KQCDEStyle *ret_v = new KQCDEStyle(useHighlightCols);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}


DummyQCDEStyle::DummyQCDEStyle()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQCDEStyle::~DummyQCDEStyle()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQCDEStyle::setSelf(kRawPtr *ptr)
{
	DummyQCDEStyle::self = ptr;
	DummyQMotifStyle::setSelf(ptr);
}

bool DummyQCDEStyle::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQMotifStyle::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQCDEStyle::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCDEStyle::event_map->bigin();
	if ((itr = DummyQCDEStyle::event_map->find(str)) == DummyQCDEStyle::event_map->end()) {
		bool ret = false;
		ret = DummyQMotifStyle::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQCDEStyle::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCDEStyle::slot_map->bigin();
	if ((itr = DummyQCDEStyle::slot_map->find(str)) == DummyQCDEStyle::slot_map->end()) {
		bool ret = false;
		ret = DummyQMotifStyle::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQCDEStyle::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQCDEStyle::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQMotifStyle::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQCDEStyle::connection(QObject *o)
{
	QCDEStyle *p = dynamic_cast<QCDEStyle*>(o);
	if (p != NULL) {
	}
	DummyQMotifStyle::connection(o);
}

KQCDEStyle::KQCDEStyle(bool useHighlightCols) : QCDEStyle(useHighlightCols)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQCDEStyle();
	dummy->connection((QObject*)this);
}

KQCDEStyle::~KQCDEStyle()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QCDEStyle_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCDEStyle *qp = RawPtr_to(KQCDEStyle *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QCDEStyle]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCDEStyle]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QCDEStyle_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCDEStyle *qp = RawPtr_to(KQCDEStyle *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QCDEStyle]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCDEStyle]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QCDEStyle_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQCDEStyle *qp = (KQCDEStyle *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QCDEStyle*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QCDEStyle_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQCDEStyle *qp = (KQCDEStyle *)p->rawptr;
		KQCDEStyle *qp = static_cast<KQCDEStyle*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QCDEStyle_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQCDEStyle::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQCDEStyle::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QCDEStyle::event(event);
		return false;
	}
//	QCDEStyle::event(event);
	return true;
}



DEFAPI(void) defQCDEStyle(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QCDEStyle";
	cdef->free = QCDEStyle_free;
	cdef->reftrace = QCDEStyle_reftrace;
	cdef->compareTo = QCDEStyle_compareTo;
}


//@Virtual @Override QSize QCalendarWidget.minimumSizeHint();
KMETHOD QCalendarWidget_minimumSizeHint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->minimumSizeHint();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override QSize QCalendarWidget.sizeHint();
KMETHOD QCalendarWidget_sizeHint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->sizeHint();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QCalendarWidget QCalendarWidget.new(QWidget parent);
KMETHOD QCalendarWidget_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QWidget*  parent = RawPtr_to(QWidget*, sfp[1]);
	KQCalendarWidget *ret_v = new KQCalendarWidget(parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

//int QCalendarWidget.getDateEditAcceptDelay();
KMETHOD QCalendarWidget_getDateEditAcceptDelay(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		int ret_v = qp->dateEditAcceptDelay();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QTextCharFormat QCalendarWidget.getDateTextFormat(QDate date);
KMETHOD QCalendarWidget_getDateTextFormat(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		const QDate  date = *RawPtr_to(const QDate *, sfp[1]);
		QTextCharFormat ret_v = qp->dateTextFormat(date);
		QTextCharFormat *ret_v_ = new QTextCharFormat(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QCalendarWidget.getFirstDayOfWeek();
KMETHOD QCalendarWidget_getFirstDayOfWeek(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		Qt::DayOfWeek ret_v = qp->firstDayOfWeek();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QTextCharFormat QCalendarWidget.getHeaderTextFormat();
KMETHOD QCalendarWidget_getHeaderTextFormat(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		QTextCharFormat ret_v = qp->headerTextFormat();
		QTextCharFormat *ret_v_ = new QTextCharFormat(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QCalendarWidget.getHorizontalHeaderFormat();
KMETHOD QCalendarWidget_getHorizontalHeaderFormat(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		QCalendarWidget::HorizontalHeaderFormat ret_v = qp->horizontalHeaderFormat();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//boolean QCalendarWidget.isDateEditEnabled();
KMETHOD QCalendarWidget_isDateEditEnabled(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isDateEditEnabled();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QCalendarWidget.isGridVisible();
KMETHOD QCalendarWidget_isGridVisible(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isGridVisible();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QCalendarWidget.isNavigationBarVisible();
KMETHOD QCalendarWidget_isNavigationBarVisible(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isNavigationBarVisible();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//QDate QCalendarWidget.getMaximumDate();
KMETHOD QCalendarWidget_getMaximumDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		QDate ret_v = qp->maximumDate();
		QDate *ret_v_ = new QDate(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDate QCalendarWidget.getMinimumDate();
KMETHOD QCalendarWidget_getMinimumDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		QDate ret_v = qp->minimumDate();
		QDate *ret_v_ = new QDate(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QCalendarWidget.monthShown();
KMETHOD QCalendarWidget_monthShown(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		int ret_v = qp->monthShown();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QDate QCalendarWidget.getSelectedDate();
KMETHOD QCalendarWidget_getSelectedDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		QDate ret_v = qp->selectedDate();
		QDate *ret_v_ = new QDate(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QCalendarWidget.getSelectionMode();
KMETHOD QCalendarWidget_getSelectionMode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		QCalendarWidget::SelectionMode ret_v = qp->selectionMode();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QCalendarWidget.setDateEditAcceptDelay(int delay);
KMETHOD QCalendarWidget_setDateEditAcceptDelay(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		int delay = Int_to(int, sfp[1]);
		qp->setDateEditAcceptDelay(delay);
	}
	RETURNvoid_();
}

//void QCalendarWidget.setDateEditEnabled(boolean enable);
KMETHOD QCalendarWidget_setDateEditEnabled(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		bool enable = Boolean_to(bool, sfp[1]);
		qp->setDateEditEnabled(enable);
	}
	RETURNvoid_();
}

//void QCalendarWidget.setDateTextFormat(QDate date, QTextCharFormat fmt);
KMETHOD QCalendarWidget_setDateTextFormat(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		const QDate  date = *RawPtr_to(const QDate *, sfp[1]);
		const QTextCharFormat  format = *RawPtr_to(const QTextCharFormat *, sfp[2]);
		qp->setDateTextFormat(date, format);
	}
	RETURNvoid_();
}

//void QCalendarWidget.setFirstDayOfWeek(int dayOfWeek);
KMETHOD QCalendarWidget_setFirstDayOfWeek(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		Qt::DayOfWeek dayOfWeek = Int_to(Qt::DayOfWeek, sfp[1]);
		qp->setFirstDayOfWeek(dayOfWeek);
	}
	RETURNvoid_();
}

//void QCalendarWidget.setHeaderTextFormat(QTextCharFormat fmt);
KMETHOD QCalendarWidget_setHeaderTextFormat(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		const QTextCharFormat  format = *RawPtr_to(const QTextCharFormat *, sfp[1]);
		qp->setHeaderTextFormat(format);
	}
	RETURNvoid_();
}

//void QCalendarWidget.setHorizontalHeaderFormat(int fmt);
KMETHOD QCalendarWidget_setHorizontalHeaderFormat(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		QCalendarWidget::HorizontalHeaderFormat format = Int_to(QCalendarWidget::HorizontalHeaderFormat, sfp[1]);
		qp->setHorizontalHeaderFormat(format);
	}
	RETURNvoid_();
}

//void QCalendarWidget.setMaximumDate(QDate date);
KMETHOD QCalendarWidget_setMaximumDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		const QDate  date = *RawPtr_to(const QDate *, sfp[1]);
		qp->setMaximumDate(date);
	}
	RETURNvoid_();
}

//void QCalendarWidget.setMinimumDate(QDate date);
KMETHOD QCalendarWidget_setMinimumDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		const QDate  date = *RawPtr_to(const QDate *, sfp[1]);
		qp->setMinimumDate(date);
	}
	RETURNvoid_();
}

//void QCalendarWidget.setSelectionMode(int mode);
KMETHOD QCalendarWidget_setSelectionMode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		QCalendarWidget::SelectionMode mode = Int_to(QCalendarWidget::SelectionMode, sfp[1]);
		qp->setSelectionMode(mode);
	}
	RETURNvoid_();
}

//void QCalendarWidget.setVerticalHeaderFormat(int fmt);
KMETHOD QCalendarWidget_setVerticalHeaderFormat(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		QCalendarWidget::VerticalHeaderFormat format = Int_to(QCalendarWidget::VerticalHeaderFormat, sfp[1]);
		qp->setVerticalHeaderFormat(format);
	}
	RETURNvoid_();
}

//void QCalendarWidget.setWeekdayTextFormat(int dayOfWeek, QTextCharFormat fmt);
KMETHOD QCalendarWidget_setWeekdayTextFormat(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		Qt::DayOfWeek dayOfWeek = Int_to(Qt::DayOfWeek, sfp[1]);
		const QTextCharFormat  format = *RawPtr_to(const QTextCharFormat *, sfp[2]);
		qp->setWeekdayTextFormat(dayOfWeek, format);
	}
	RETURNvoid_();
}

//int QCalendarWidget.getVerticalHeaderFormat();
KMETHOD QCalendarWidget_getVerticalHeaderFormat(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		QCalendarWidget::VerticalHeaderFormat ret_v = qp->verticalHeaderFormat();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QTextCharFormat QCalendarWidget.getWeekdayTextFormat(int dayOfWeek);
KMETHOD QCalendarWidget_getWeekdayTextFormat(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		Qt::DayOfWeek dayOfWeek = Int_to(Qt::DayOfWeek, sfp[1]);
		QTextCharFormat ret_v = qp->weekdayTextFormat(dayOfWeek);
		QTextCharFormat *ret_v_ = new QTextCharFormat(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QCalendarWidget.yearShown();
KMETHOD QCalendarWidget_yearShown(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		int ret_v = qp->yearShown();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QCalendarWidget.setCurrentPage(int year, int month);
KMETHOD QCalendarWidget_setCurrentPage(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		int year = Int_to(int, sfp[1]);
		int month = Int_to(int, sfp[2]);
		qp->setCurrentPage(year, month);
	}
	RETURNvoid_();
}

//void QCalendarWidget.setDateRange(QDate min, QDate max);
KMETHOD QCalendarWidget_setDateRange(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		const QDate  min = *RawPtr_to(const QDate *, sfp[1]);
		const QDate  max = *RawPtr_to(const QDate *, sfp[2]);
		qp->setDateRange(min, max);
	}
	RETURNvoid_();
}

//void QCalendarWidget.setGridVisible(boolean show);
KMETHOD QCalendarWidget_setGridVisible(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		bool show = Boolean_to(bool, sfp[1]);
		qp->setGridVisible(show);
	}
	RETURNvoid_();
}

//void QCalendarWidget.setNavigationBarVisible(boolean visible);
KMETHOD QCalendarWidget_setNavigationBarVisible(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		bool visible = Boolean_to(bool, sfp[1]);
		qp->setNavigationBarVisible(visible);
	}
	RETURNvoid_();
}

//void QCalendarWidget.setSelectedDate(QDate date);
KMETHOD QCalendarWidget_setSelectedDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		const QDate  date = *RawPtr_to(const QDate *, sfp[1]);
		qp->setSelectedDate(date);
	}
	RETURNvoid_();
}

//void QCalendarWidget.showNextMonth();
KMETHOD QCalendarWidget_showNextMonth(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		qp->showNextMonth();
	}
	RETURNvoid_();
}

//void QCalendarWidget.showNextYear();
KMETHOD QCalendarWidget_showNextYear(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		qp->showNextYear();
	}
	RETURNvoid_();
}

//void QCalendarWidget.showPreviousMonth();
KMETHOD QCalendarWidget_showPreviousMonth(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		qp->showPreviousMonth();
	}
	RETURNvoid_();
}

//void QCalendarWidget.showPreviousYear();
KMETHOD QCalendarWidget_showPreviousYear(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		qp->showPreviousYear();
	}
	RETURNvoid_();
}

//void QCalendarWidget.showSelectedDate();
KMETHOD QCalendarWidget_showSelectedDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		qp->showSelectedDate();
	}
	RETURNvoid_();
}

//void QCalendarWidget.showToday();
KMETHOD QCalendarWidget_showToday(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCalendarWidget *  qp = RawPtr_to(QCalendarWidget *, sfp[0]);
	if (qp) {
		qp->showToday();
	}
	RETURNvoid_();
}


DummyQCalendarWidget::DummyQCalendarWidget()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	activated_func = NULL;
	clicked_func = NULL;
	current_page_changed_func = NULL;
	selection_changed_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("activated", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("clicked", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("current-page-changed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("selection-changed", NULL));
}
DummyQCalendarWidget::~DummyQCalendarWidget()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQCalendarWidget::setSelf(kRawPtr *ptr)
{
	DummyQCalendarWidget::self = ptr;
	DummyQWidget::setSelf(ptr);
}

bool DummyQCalendarWidget::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQWidget::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQCalendarWidget::activatedSlot(const QDate date)
{
	if (activated_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QDate, date);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, activated_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQCalendarWidget::clickedSlot(const QDate date)
{
	if (clicked_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QDate, date);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, clicked_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQCalendarWidget::currentPageChangedSlot(int year, int month)
{
	if (current_page_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].ivalue = year;
		lsfp[K_CALLDELTA+3].ivalue = month;
		knh_Func_invoke(lctx, current_page_changed_func, lsfp, 3);
		return true;
	}
	return false;
}

bool DummyQCalendarWidget::selectionChangedSlot()
{
	if (selection_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, selection_changed_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQCalendarWidget::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCalendarWidget::event_map->bigin();
	if ((itr = DummyQCalendarWidget::event_map->find(str)) == DummyQCalendarWidget::event_map->end()) {
		bool ret = false;
		ret = DummyQWidget::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQCalendarWidget::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCalendarWidget::slot_map->bigin();
	if ((itr = DummyQCalendarWidget::slot_map->find(str)) == DummyQCalendarWidget::slot_map->end()) {
		bool ret = false;
		ret = DummyQWidget::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		activated_func = (*slot_map)["activated"];
		clicked_func = (*slot_map)["clicked"];
		current_page_changed_func = (*slot_map)["current-page-changed"];
		selection_changed_func = (*slot_map)["selection-changed"];
		return true;
	}
}

kObject** DummyQCalendarWidget::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQCalendarWidget::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 5;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, activated_func);
	KNH_ADDNNREF(ctx, clicked_func);
	KNH_ADDNNREF(ctx, current_page_changed_func);
	KNH_ADDNNREF(ctx, selection_changed_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQWidget::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQCalendarWidget::connection(QObject *o)
{
	QCalendarWidget *p = dynamic_cast<QCalendarWidget*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(activated(const QDate)), this, SLOT(activatedSlot(const QDate)));
		connect(p, SIGNAL(clicked(const QDate)), this, SLOT(clickedSlot(const QDate)));
		connect(p, SIGNAL(currentPageChanged(int, int)), this, SLOT(currentPageChangedSlot(int, int)));
		connect(p, SIGNAL(selectionChanged()), this, SLOT(selectionChangedSlot()));
	}
	DummyQWidget::connection(o);
}

KQCalendarWidget::KQCalendarWidget(QWidget* parent) : QCalendarWidget(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQCalendarWidget();
	dummy->connection((QObject*)this);
}

KQCalendarWidget::~KQCalendarWidget()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QCalendarWidget_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCalendarWidget *qp = RawPtr_to(KQCalendarWidget *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QCalendarWidget]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCalendarWidget]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QCalendarWidget_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCalendarWidget *qp = RawPtr_to(KQCalendarWidget *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QCalendarWidget]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCalendarWidget]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QCalendarWidget_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQCalendarWidget *qp = (KQCalendarWidget *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QCalendarWidget*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QCalendarWidget_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQCalendarWidget *qp = (KQCalendarWidget *)p->rawptr;
		KQCalendarWidget *qp = static_cast<KQCalendarWidget*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QCalendarWidget_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQCalendarWidget::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQCalendarWidget::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QCalendarWidget::event(event);
		return false;
	}
//	QCalendarWidget::event(event);
	return true;
}

static knh_IntData_t QCalendarWidgetConstInt[] = {
	{"SingleLetterDayNames", QCalendarWidget::SingleLetterDayNames},
	{"ShortDayNames", QCalendarWidget::ShortDayNames},
	{"LongDayNames", QCalendarWidget::LongDayNames},
	{"NoHorizontalHeader", QCalendarWidget::NoHorizontalHeader},
	{"NoSelection", QCalendarWidget::NoSelection},
	{"SingleSelection", QCalendarWidget::SingleSelection},
	{"ISOWeekNumbers", QCalendarWidget::ISOWeekNumbers},
	{"NoVerticalHeader", QCalendarWidget::NoVerticalHeader},
	{NULL, 0}
};

DEFAPI(void) constQCalendarWidget(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QCalendarWidgetConstInt);
}


DEFAPI(void) defQCalendarWidget(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QCalendarWidget";
	cdef->free = QCalendarWidget_free;
	cdef->reftrace = QCalendarWidget_reftrace;
	cdef->compareTo = QCalendarWidget_compareTo;
}


//QChar QChar.new();
KMETHOD QChar_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQChar *ret_v = new KQChar();
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QChar QChar.new(String ch);
KMETHOD QChar_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	char  ch = *RawPtr_to(char *, sfp[1]);
	KQChar *ret_v = new KQChar(ch);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QChar QChar.new(String ch);
KMETHOD QChar_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	uchar  ch = *RawPtr_to(uchar *, sfp[1]);
	KQChar *ret_v = new KQChar(ch);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QChar QChar.new(QLatin1Char ch);
KMETHOD QChar_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QLatin1Char  ch = *RawPtr_to(QLatin1Char *, sfp[1]);
	KQChar *ret_v = new KQChar(ch);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QChar QChar.new(String cell, String row);
KMETHOD QChar_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	uchar  cell = *RawPtr_to(uchar *, sfp[1]);
	uchar  row = *RawPtr_to(uchar *, sfp[2]);
	KQChar *ret_v = new KQChar(cell, row);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QChar QChar.new(int code);
KMETHOD QChar_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	ushort  code = *RawPtr_to(ushort *, sfp[1]);
	KQChar *ret_v = new KQChar(code);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QChar QChar.new(short code);
KMETHOD QChar_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	short  code = *RawPtr_to(short *, sfp[1]);
	KQChar *ret_v = new KQChar(code);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QChar QChar.new(int code);
KMETHOD QChar_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	uint  code = *RawPtr_to(uint *, sfp[1]);
	KQChar *ret_v = new KQChar(code);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QChar QChar.new(int code);
KMETHOD QChar_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	int code = Int_to(int, sfp[1]);
	KQChar *ret_v = new KQChar(code);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QChar QChar.new(int ch);
KMETHOD QChar_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar::SpecialCharacter ch = Int_to(QChar::SpecialCharacter, sfp[1]);
	KQChar *ret_v = new KQChar(ch);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//int QChar.category();
KMETHOD QChar_category(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		QChar::Category ret_v = qp->category();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//String QChar.cell();
KMETHOD QChar_cell(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		uchar ret_v = qp->cell();
		uchar *ret_v_ = new uchar(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QChar.combiningClass();
KMETHOD QChar_combiningClass(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		unsigned char ret_v = qp->combiningClass();
		unsigned char *ret_v_ = new unsigned char(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QChar.decomposition();
KMETHOD QChar_decomposition(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		QString ret_v = qp->decomposition();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QChar.decompositionTag();
KMETHOD QChar_decompositionTag(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		QChar::Decomposition ret_v = qp->decompositionTag();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QChar.digitValue();
KMETHOD QChar_digitValue(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		int ret_v = qp->digitValue();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QChar.direction();
KMETHOD QChar_direction(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		QChar::Direction ret_v = qp->direction();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//boolean QChar.hasMirrored();
KMETHOD QChar_hasMirrored(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		bool ret_v = qp->hasMirrored();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QChar.isDigit();
KMETHOD QChar_isDigit(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isDigit();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QChar.isHighSurrogate();
KMETHOD QChar_isHighSurrogate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isHighSurrogate();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QChar.isLetter();
KMETHOD QChar_isLetter(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isLetter();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QChar.isLetterOrNumber();
KMETHOD QChar_isLetterOrNumber(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isLetterOrNumber();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QChar.isLowSurrogate();
KMETHOD QChar_isLowSurrogate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isLowSurrogate();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QChar.isLower();
KMETHOD QChar_isLower(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isLower();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QChar.isMark();
KMETHOD QChar_isMark(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isMark();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QChar.isNumber();
KMETHOD QChar_isNumber(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isNumber();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QChar.isPrint();
KMETHOD QChar_isPrint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isPrint();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QChar.isPunct();
KMETHOD QChar_isPunct(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isPunct();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QChar.isSpace();
KMETHOD QChar_isSpace(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isSpace();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QChar.isSymbol();
KMETHOD QChar_isSymbol(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isSymbol();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QChar.isTitleCase();
KMETHOD QChar_isTitleCase(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isTitleCase();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QChar.isUpper();
KMETHOD QChar_isUpper(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isUpper();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//int QChar.joining();
KMETHOD QChar_joining(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		QChar::Joining ret_v = qp->joining();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QChar QChar.mirroredChar();
KMETHOD QChar_mirroredChar(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		QChar ret_v = qp->mirroredChar();
		QChar *ret_v_ = new QChar(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QChar.row();
KMETHOD QChar_row(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		uchar ret_v = qp->row();
		uchar *ret_v_ = new uchar(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QChar.toAscii();
KMETHOD QChar_toAscii(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		char ret_v = qp->toAscii();
		char *ret_v_ = new char(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QChar QChar.toCaseFolded();
KMETHOD QChar_toCaseFolded(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		QChar ret_v = qp->toCaseFolded();
		QChar *ret_v_ = new QChar(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QChar.toLatin1();
KMETHOD QChar_toLatin1(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		char ret_v = qp->toLatin1();
		char *ret_v_ = new char(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QChar QChar.toLower();
KMETHOD QChar_toLower(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		QChar ret_v = qp->toLower();
		QChar *ret_v_ = new QChar(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QChar QChar.toTitleCase();
KMETHOD QChar_toTitleCase(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		QChar ret_v = qp->toTitleCase();
		QChar *ret_v_ = new QChar(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QChar QChar.toUpper();
KMETHOD QChar_toUpper(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		QChar ret_v = qp->toUpper();
		QChar *ret_v_ = new QChar(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QChar.unicode();
KMETHOD QChar_unicode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		ushort ret_v = qp->unicode();
		ushort *ret_v_ = new ushort(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//int QChar.unicode();
KMETHOD QChar_unicode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		ushort ret_v = qp->unicode();
		ushort *ret_v_ = new ushort(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//int QChar.unicodeVersion();
KMETHOD QChar_unicodeVersion(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *  qp = RawPtr_to(QChar *, sfp[0]);
	if (qp) {
		QChar::UnicodeVersion ret_v = qp->unicodeVersion();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

/*
//int QChar.category(int ucs4);
KMETHOD QChar_category(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  ucs4 = *RawPtr_to(uint *, sfp[1]);
		QChar::Category ret_v = QChar::category(ucs4);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
/*
//int QChar.category(int ucs2);
KMETHOD QChar_category(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		ushort  ucs2 = *RawPtr_to(ushort *, sfp[1]);
		QChar::Category ret_v = QChar::category(ucs2);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
/*
//String QChar.combiningClass(int ucs4);
KMETHOD QChar_combiningClass(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  ucs4 = *RawPtr_to(uint *, sfp[1]);
		unsigned char ret_v = QChar::combiningClass(ucs4);
		unsigned char *ret_v_ = new unsigned char(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//String QChar.combiningClass(int ucs2);
KMETHOD QChar_combiningClass(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		ushort  ucs2 = *RawPtr_to(ushort *, sfp[1]);
		unsigned char ret_v = QChar::combiningClass(ucs2);
		unsigned char *ret_v_ = new unsigned char(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//String QChar.decomposition(int ucs4);
KMETHOD QChar_decomposition(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  ucs4 = *RawPtr_to(uint *, sfp[1]);
		QString ret_v = QChar::decomposition(ucs4);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//int QChar.decompositionTag(int ucs4);
KMETHOD QChar_decompositionTag(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  ucs4 = *RawPtr_to(uint *, sfp[1]);
		QChar::Decomposition ret_v = QChar::decompositionTag(ucs4);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
/*
//int QChar.digitValue(int ucs2);
KMETHOD QChar_digitValue(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		ushort  ucs2 = *RawPtr_to(ushort *, sfp[1]);
		int ret_v = QChar::digitValue(ucs2);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
/*
//int QChar.digitValue(int ucs4);
KMETHOD QChar_digitValue(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  ucs4 = *RawPtr_to(uint *, sfp[1]);
		int ret_v = QChar::digitValue(ucs4);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
/*
//int QChar.direction(int ucs4);
KMETHOD QChar_direction(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  ucs4 = *RawPtr_to(uint *, sfp[1]);
		QChar::Direction ret_v = QChar::direction(ucs4);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
/*
//int QChar.direction(int ucs2);
KMETHOD QChar_direction(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		ushort  ucs2 = *RawPtr_to(ushort *, sfp[1]);
		QChar::Direction ret_v = QChar::direction(ucs2);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
//QChar QChar.fromAscii(String c);
KMETHOD QChar_fromAscii(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		char  c = *RawPtr_to(char *, sfp[1]);
		QChar ret_v = QChar::fromAscii(c);
		QChar *ret_v_ = new QChar(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QChar QChar.fromLatin1(String c);
KMETHOD QChar_fromLatin1(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		char  c = *RawPtr_to(char *, sfp[1]);
		QChar ret_v = QChar::fromLatin1(c);
		QChar *ret_v_ = new QChar(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QChar.highSurrogate(int ucs4);
KMETHOD QChar_highSurrogate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  ucs4 = *RawPtr_to(uint *, sfp[1]);
		ushort ret_v = QChar::highSurrogate(ucs4);
		ushort *ret_v_ = new ushort(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//boolean QChar.isHighSurrogate(int ucs4);
KMETHOD QChar_isHighSurrogate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  ucs4 = *RawPtr_to(uint *, sfp[1]);
		bool ret_v = QChar::isHighSurrogate(ucs4);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}
*/
/*
//boolean QChar.isLowSurrogate(int ucs4);
KMETHOD QChar_isLowSurrogate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  ucs4 = *RawPtr_to(uint *, sfp[1]);
		bool ret_v = QChar::isLowSurrogate(ucs4);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}
*/
/*
//int QChar.joining(int ucs4);
KMETHOD QChar_joining(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  ucs4 = *RawPtr_to(uint *, sfp[1]);
		QChar::Joining ret_v = QChar::joining(ucs4);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
/*
//int QChar.joining(int ucs2);
KMETHOD QChar_joining(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		ushort  ucs2 = *RawPtr_to(ushort *, sfp[1]);
		QChar::Joining ret_v = QChar::joining(ucs2);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
//int QChar.lowSurrogate(int ucs4);
KMETHOD QChar_lowSurrogate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  ucs4 = *RawPtr_to(uint *, sfp[1]);
		ushort ret_v = QChar::lowSurrogate(ucs4);
		ushort *ret_v_ = new ushort(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//int QChar.mirroredChar(int ucs4);
KMETHOD QChar_mirroredChar(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  ucs4 = *RawPtr_to(uint *, sfp[1]);
		uint ret_v = QChar::mirroredChar(ucs4);
		uint *ret_v_ = new uint(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//int QChar.mirroredChar(int ucs2);
KMETHOD QChar_mirroredChar(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		ushort  ucs2 = *RawPtr_to(ushort *, sfp[1]);
		ushort ret_v = QChar::mirroredChar(ucs2);
		ushort *ret_v_ = new ushort(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//boolean QChar.requiresSurrogates(int ucs4);
KMETHOD QChar_requiresSurrogates(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  ucs4 = *RawPtr_to(uint *, sfp[1]);
		bool ret_v = QChar::requiresSurrogates(ucs4);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//int QChar.surrogateToUcs4(int high, int low);
KMETHOD QChar_surrogateToUcs4(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		ushort  high = *RawPtr_to(ushort *, sfp[1]);
		ushort  low = *RawPtr_to(ushort *, sfp[2]);
		uint ret_v = QChar::surrogateToUcs4(high, low);
		uint *ret_v_ = new uint(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//int QChar.surrogateToUcs4(QChar high, QChar low);
KMETHOD QChar_surrogateToUcs4(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QChar  high = *RawPtr_to(QChar *, sfp[1]);
		QChar  low = *RawPtr_to(QChar *, sfp[2]);
		uint ret_v = QChar::surrogateToUcs4(high, low);
		uint *ret_v_ = new uint(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//int QChar.toCaseFolded(int ucs4);
KMETHOD QChar_toCaseFolded(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  ucs4 = *RawPtr_to(uint *, sfp[1]);
		uint ret_v = QChar::toCaseFolded(ucs4);
		uint *ret_v_ = new uint(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//int QChar.toCaseFolded(int ucs2);
KMETHOD QChar_toCaseFolded(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		ushort  ucs2 = *RawPtr_to(ushort *, sfp[1]);
		ushort ret_v = QChar::toCaseFolded(ucs2);
		ushort *ret_v_ = new ushort(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//int QChar.toLower(int ucs4);
KMETHOD QChar_toLower(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  ucs4 = *RawPtr_to(uint *, sfp[1]);
		uint ret_v = QChar::toLower(ucs4);
		uint *ret_v_ = new uint(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//int QChar.toLower(int ucs2);
KMETHOD QChar_toLower(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		ushort  ucs2 = *RawPtr_to(ushort *, sfp[1]);
		ushort ret_v = QChar::toLower(ucs2);
		ushort *ret_v_ = new ushort(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//int QChar.toTitleCase(int ucs4);
KMETHOD QChar_toTitleCase(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  ucs4 = *RawPtr_to(uint *, sfp[1]);
		uint ret_v = QChar::toTitleCase(ucs4);
		uint *ret_v_ = new uint(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//int QChar.toTitleCase(int ucs2);
KMETHOD QChar_toTitleCase(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		ushort  ucs2 = *RawPtr_to(ushort *, sfp[1]);
		ushort ret_v = QChar::toTitleCase(ucs2);
		ushort *ret_v_ = new ushort(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//int QChar.toUpper(int ucs4);
KMETHOD QChar_toUpper(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  ucs4 = *RawPtr_to(uint *, sfp[1]);
		uint ret_v = QChar::toUpper(ucs4);
		uint *ret_v_ = new uint(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//int QChar.toUpper(int ucs2);
KMETHOD QChar_toUpper(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		ushort  ucs2 = *RawPtr_to(ushort *, sfp[1]);
		ushort ret_v = QChar::toUpper(ucs2);
		ushort *ret_v_ = new ushort(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//int QChar.unicodeVersion(int ucs4);
KMETHOD QChar_unicodeVersion(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  ucs4 = *RawPtr_to(uint *, sfp[1]);
		QChar::UnicodeVersion ret_v = QChar::unicodeVersion(ucs4);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
/*
//int QChar.unicodeVersion(int ucs2);
KMETHOD QChar_unicodeVersion(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		ushort  ucs2 = *RawPtr_to(ushort *, sfp[1]);
		QChar::UnicodeVersion ret_v = QChar::unicodeVersion(ucs2);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/
//Array<String> QChar.parents();
KMETHOD QChar_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChar *qp = RawPtr_to(QChar*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQChar::DummyQChar()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQChar::~DummyQChar()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQChar::setSelf(kRawPtr *ptr)
{
	DummyQChar::self = ptr;
}

bool DummyQChar::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQChar::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQChar::event_map->bigin();
	if ((itr = DummyQChar::event_map->find(str)) == DummyQChar::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQChar::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQChar::slot_map->bigin();
	if ((itr = DummyQChar::slot_map->find(str)) == DummyQChar::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQChar::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQChar::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQChar::connection(QObject *o)
{
	QChar *p = dynamic_cast<QChar*>(o);
	if (p != NULL) {
	}
}

KQChar::KQChar() : QChar()
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQChar();
}

KQChar::~KQChar()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QChar_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQChar *qp = RawPtr_to(KQChar *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QChar]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QChar]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QChar_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQChar *qp = RawPtr_to(KQChar *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QChar]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QChar]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QChar_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQChar *qp = (KQChar *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QChar*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QChar_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQChar *qp = (KQChar *)p->rawptr;
		KQChar *qp = static_cast<KQChar*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QChar_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (*static_cast<QChar*>(p1->rawptr) == *static_cast<QChar*>(p2->rawptr) ? 0 : 1);
}

void KQChar::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

static knh_IntData_t QCharConstInt[] = {
	{"Mark_NonSpacing", QChar::Mark_NonSpacing},
	{"Mark_SpacingCombining", QChar::Mark_SpacingCombining},
	{"Mark_Enclosing", QChar::Mark_Enclosing},
	{"Number_DecimalDigit", QChar::Number_DecimalDigit},
	{"Number_Letter", QChar::Number_Letter},
	{"Number_Other", QChar::Number_Other},
	{"Separator_Space", QChar::Separator_Space},
	{"Separator_Line", QChar::Separator_Line},
	{"Separator_Paragraph", QChar::Separator_Paragraph},
	{"Other_Control", QChar::Other_Control},
	{"Other_Format", QChar::Other_Format},
	{"Other_Surrogate", QChar::Other_Surrogate},
	{"Other_PrivateUse", QChar::Other_PrivateUse},
	{"Other_NotAssigned", QChar::Other_NotAssigned},
	{"Letter_Uppercase", QChar::Letter_Uppercase},
	{"Letter_Lowercase", QChar::Letter_Lowercase},
	{"Letter_Titlecase", QChar::Letter_Titlecase},
	{"Letter_Modifier", QChar::Letter_Modifier},
	{"Letter_Other", QChar::Letter_Other},
	{"Punctuation_Connector", QChar::Punctuation_Connector},
	{"Punctuation_Dash", QChar::Punctuation_Dash},
	{"Punctuation_Open", QChar::Punctuation_Open},
	{"Punctuation_Close", QChar::Punctuation_Close},
	{"Punctuation_InitialQuote", QChar::Punctuation_InitialQuote},
	{"Punctuation_FinalQuote", QChar::Punctuation_FinalQuote},
	{"Punctuation_Other", QChar::Punctuation_Other},
	{"Symbol_Math", QChar::Symbol_Math},
	{"Symbol_Currency", QChar::Symbol_Currency},
	{"Symbol_Modifier", QChar::Symbol_Modifier},
	{"Symbol_Other", QChar::Symbol_Other},
	{"NoCategory", QChar::NoCategory},
	{"NoDecomposition", QChar::NoDecomposition},
	{"Canonical", QChar::Canonical},
	{"Circle", QChar::Circle},
	{"Compat", QChar::Compat},
	{"Final", QChar::Final},
	{"Font", QChar::Font},
	{"Fraction", QChar::Fraction},
	{"Initial", QChar::Initial},
	{"Isolated", QChar::Isolated},
	{"Medial", QChar::Medial},
	{"Narrow", QChar::Narrow},
	{"NoBreak", QChar::NoBreak},
	{"Small", QChar::Small},
	{"Square", QChar::Square},
	{"Sub", QChar::Sub},
	{"Super", QChar::Super},
	{"Vertical", QChar::Vertical},
	{"Wide", QChar::Wide},
	{"DirAL", QChar::DirAL},
	{"DirAN", QChar::DirAN},
	{"DirB", QChar::DirB},
	{"DirBN", QChar::DirBN},
	{"DirCS", QChar::DirCS},
	{"DirEN", QChar::DirEN},
	{"DirES", QChar::DirES},
	{"DirET", QChar::DirET},
	{"DirL", QChar::DirL},
	{"DirLRE", QChar::DirLRE},
	{"DirLRO", QChar::DirLRO},
	{"DirNSM", QChar::DirNSM},
	{"DirON", QChar::DirON},
	{"DirPDF", QChar::DirPDF},
	{"DirR", QChar::DirR},
	{"DirRLE", QChar::DirRLE},
	{"DirRLO", QChar::DirRLO},
	{"DirS", QChar::DirS},
	{"DirWS", QChar::DirWS},
	{"Center", QChar::Center},
	{"Dual", QChar::Dual},
	{"OtherJoining", QChar::OtherJoining},
	{"Right", QChar::Right},
	{"Null", QChar::Null},
	{"Nbsp", QChar::Nbsp},
	{"ReplacementCharacter", QChar::ReplacementCharacter},
	{"ObjectReplacementCharacter", QChar::ObjectReplacementCharacter},
	{"ByteOrderMark", QChar::ByteOrderMark},
	{"ByteOrderSwapped", QChar::ByteOrderSwapped},
	{"ParagraphSeparator", QChar::ParagraphSeparator},
	{"LineSeparator", QChar::LineSeparator},
	{"Unicode_1_1", QChar::Unicode_1_1},
	{"Unicode_2_0", QChar::Unicode_2_0},
	{"Unicode_2_1_2", QChar::Unicode_2_1_2},
	{"Unicode_3_0", QChar::Unicode_3_0},
	{"Unicode_3_1", QChar::Unicode_3_1},
	{"Unicode_3_2", QChar::Unicode_3_2},
	{"Unicode_4_0", QChar::Unicode_4_0},
	{"Unicode_4_1", QChar::Unicode_4_1},
	{"Unicode_5_0", QChar::Unicode_5_0},
	{"Unicode_Unassigned", QChar::Unicode_Unassigned},
	{NULL, 0}
};

DEFAPI(void) constQChar(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QCharConstInt);
}


DEFAPI(void) defQChar(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QChar";
	cdef->free = QChar_free;
	cdef->reftrace = QChar_reftrace;
	cdef->compareTo = QChar_compareTo;
}


//@Virtual @Override QSize QCheckBox.sizeHint();
KMETHOD QCheckBox_sizeHint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCheckBox *  qp = RawPtr_to(QCheckBox *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->sizeHint();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QCheckBox QCheckBox.new(QWidget parent);
KMETHOD QCheckBox_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QWidget*  parent = RawPtr_to(QWidget*, sfp[1]);
	KQCheckBox *ret_v = new KQCheckBox(parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QCheckBox QCheckBox.new(String text, QWidget parent);
KMETHOD QCheckBox_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QString text = String_to(const QString, sfp[1]);
	QWidget*  parent = RawPtr_to(QWidget*, sfp[2]);
	KQCheckBox *ret_v = new KQCheckBox(text, parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//int QCheckBox.getCheckState();
KMETHOD QCheckBox_getCheckState(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCheckBox *  qp = RawPtr_to(QCheckBox *, sfp[0]);
	if (qp) {
		Qt::CheckState ret_v = qp->checkState();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//boolean QCheckBox.isTristate();
KMETHOD QCheckBox_isTristate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCheckBox *  qp = RawPtr_to(QCheckBox *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isTristate();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QCheckBox.setCheckState(int state);
KMETHOD QCheckBox_setCheckState(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCheckBox *  qp = RawPtr_to(QCheckBox *, sfp[0]);
	if (qp) {
		Qt::CheckState state = Int_to(Qt::CheckState, sfp[1]);
		qp->setCheckState(state);
	}
	RETURNvoid_();
}

//void QCheckBox.setTristate(boolean y);
KMETHOD QCheckBox_setTristate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCheckBox *  qp = RawPtr_to(QCheckBox *, sfp[0]);
	if (qp) {
		bool y = Boolean_to(bool, sfp[1]);
		qp->setTristate(y);
	}
	RETURNvoid_();
}


DummyQCheckBox::DummyQCheckBox()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	state_changed_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("state-changed", NULL));
}
DummyQCheckBox::~DummyQCheckBox()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQCheckBox::setSelf(kRawPtr *ptr)
{
	DummyQCheckBox::self = ptr;
	DummyQAbstractButton::setSelf(ptr);
}

bool DummyQCheckBox::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQAbstractButton::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQCheckBox::stateChangedSlot(int state)
{
	if (state_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].ivalue = state;
		knh_Func_invoke(lctx, state_changed_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQCheckBox::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCheckBox::event_map->bigin();
	if ((itr = DummyQCheckBox::event_map->find(str)) == DummyQCheckBox::event_map->end()) {
		bool ret = false;
		ret = DummyQAbstractButton::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQCheckBox::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCheckBox::slot_map->bigin();
	if ((itr = DummyQCheckBox::slot_map->find(str)) == DummyQCheckBox::slot_map->end()) {
		bool ret = false;
		ret = DummyQAbstractButton::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		state_changed_func = (*slot_map)["state-changed"];
		return true;
	}
}

kObject** DummyQCheckBox::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQCheckBox::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 2;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, state_changed_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQAbstractButton::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQCheckBox::connection(QObject *o)
{
	QCheckBox *p = dynamic_cast<QCheckBox*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(stateChanged(int)), this, SLOT(stateChangedSlot(int)));
	}
	DummyQAbstractButton::connection(o);
}

KQCheckBox::KQCheckBox(QWidget* parent) : QCheckBox(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQCheckBox();
	dummy->connection((QObject*)this);
}

KQCheckBox::~KQCheckBox()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QCheckBox_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCheckBox *qp = RawPtr_to(KQCheckBox *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QCheckBox]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCheckBox]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QCheckBox_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCheckBox *qp = RawPtr_to(KQCheckBox *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QCheckBox]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCheckBox]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QCheckBox_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQCheckBox *qp = (KQCheckBox *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QCheckBox*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QCheckBox_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQCheckBox *qp = (KQCheckBox *)p->rawptr;
		KQCheckBox *qp = static_cast<KQCheckBox*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QCheckBox_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQCheckBox::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQCheckBox::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QCheckBox::event(event);
		return false;
	}
//	QCheckBox::event(event);
	return true;
}



DEFAPI(void) defQCheckBox(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QCheckBox";
	cdef->free = QCheckBox_free;
	cdef->reftrace = QCheckBox_reftrace;
	cdef->compareTo = QCheckBox_compareTo;
}


//QChildEvent QChildEvent.new(int type, QObject child);
KMETHOD QChildEvent_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChildEvent::Type type = Int_to(QChildEvent::Type, sfp[1]);
	QObject*  child = RawPtr_to(QObject*, sfp[2]);
	KQChildEvent *ret_v = new KQChildEvent(type, child);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

//boolean QChildEvent.added();
KMETHOD QChildEvent_added(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChildEvent *  qp = RawPtr_to(QChildEvent *, sfp[0]);
	if (qp) {
		bool ret_v = qp->added();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//QObject QChildEvent.child();
KMETHOD QChildEvent_child(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChildEvent *  qp = RawPtr_to(QChildEvent *, sfp[0]);
	if (qp) {
		QObject* ret_v = qp->child();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QObject*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QChildEvent.polished();
KMETHOD QChildEvent_polished(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChildEvent *  qp = RawPtr_to(QChildEvent *, sfp[0]);
	if (qp) {
		bool ret_v = qp->polished();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QChildEvent.removed();
KMETHOD QChildEvent_removed(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QChildEvent *  qp = RawPtr_to(QChildEvent *, sfp[0]);
	if (qp) {
		bool ret_v = qp->removed();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}


DummyQChildEvent::DummyQChildEvent()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQChildEvent::~DummyQChildEvent()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQChildEvent::setSelf(kRawPtr *ptr)
{
	DummyQChildEvent::self = ptr;
	DummyQEvent::setSelf(ptr);
}

bool DummyQChildEvent::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQEvent::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQChildEvent::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQChildEvent::event_map->bigin();
	if ((itr = DummyQChildEvent::event_map->find(str)) == DummyQChildEvent::event_map->end()) {
		bool ret = false;
		ret = DummyQEvent::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQChildEvent::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQChildEvent::slot_map->bigin();
	if ((itr = DummyQChildEvent::slot_map->find(str)) == DummyQChildEvent::slot_map->end()) {
		bool ret = false;
		ret = DummyQEvent::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQChildEvent::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQChildEvent::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQEvent::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQChildEvent::connection(QObject *o)
{
	QChildEvent *p = dynamic_cast<QChildEvent*>(o);
	if (p != NULL) {
	}
	DummyQEvent::connection(o);
}

KQChildEvent::KQChildEvent(QChildEvent::Type type, QObject* child) : QChildEvent(type, child)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQChildEvent();
}

KQChildEvent::~KQChildEvent()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QChildEvent_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQChildEvent *qp = RawPtr_to(KQChildEvent *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QChildEvent]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QChildEvent]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QChildEvent_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQChildEvent *qp = RawPtr_to(KQChildEvent *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QChildEvent]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QChildEvent]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QChildEvent_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQChildEvent *qp = (KQChildEvent *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QChildEvent*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QChildEvent_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQChildEvent *qp = (KQChildEvent *)p->rawptr;
		KQChildEvent *qp = static_cast<KQChildEvent*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QChildEvent_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQChildEvent::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQChildEvent(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QChildEvent";
	cdef->free = QChildEvent_free;
	cdef->reftrace = QChildEvent_reftrace;
	cdef->compareTo = QChildEvent_compareTo;
}


//QCloseEvent QCloseEvent.new();
KMETHOD QCloseEvent_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCloseEvent *ret_v = new KQCloseEvent();
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}


DummyQCloseEvent::DummyQCloseEvent()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQCloseEvent::~DummyQCloseEvent()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQCloseEvent::setSelf(kRawPtr *ptr)
{
	DummyQCloseEvent::self = ptr;
	DummyQEvent::setSelf(ptr);
}

bool DummyQCloseEvent::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQEvent::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQCloseEvent::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCloseEvent::event_map->bigin();
	if ((itr = DummyQCloseEvent::event_map->find(str)) == DummyQCloseEvent::event_map->end()) {
		bool ret = false;
		ret = DummyQEvent::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQCloseEvent::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCloseEvent::slot_map->bigin();
	if ((itr = DummyQCloseEvent::slot_map->find(str)) == DummyQCloseEvent::slot_map->end()) {
		bool ret = false;
		ret = DummyQEvent::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQCloseEvent::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQCloseEvent::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQEvent::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQCloseEvent::connection(QObject *o)
{
	QCloseEvent *p = dynamic_cast<QCloseEvent*>(o);
	if (p != NULL) {
	}
	DummyQEvent::connection(o);
}

KQCloseEvent::KQCloseEvent() : QCloseEvent()
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQCloseEvent();
}

KQCloseEvent::~KQCloseEvent()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QCloseEvent_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCloseEvent *qp = RawPtr_to(KQCloseEvent *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QCloseEvent]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCloseEvent]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QCloseEvent_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCloseEvent *qp = RawPtr_to(KQCloseEvent *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QCloseEvent]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCloseEvent]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QCloseEvent_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQCloseEvent *qp = (KQCloseEvent *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QCloseEvent*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QCloseEvent_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQCloseEvent *qp = (KQCloseEvent *)p->rawptr;
		KQCloseEvent *qp = static_cast<KQCloseEvent*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QCloseEvent_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQCloseEvent::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQCloseEvent(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QCloseEvent";
	cdef->free = QCloseEvent_free;
	cdef->reftrace = QCloseEvent_reftrace;
	cdef->compareTo = QCloseEvent_compareTo;
}


//QColor QColor.new();
KMETHOD QColor_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQColor *ret_v = new KQColor();
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QColor QColor.new(int r, int g, int b, int a);
KMETHOD QColor_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	int r = Int_to(int, sfp[1]);
	int g = Int_to(int, sfp[2]);
	int b = Int_to(int, sfp[3]);
	int a = Int_to(int, sfp[4]);
	KQColor *ret_v = new KQColor(r, g, b, a);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QColor QColor.new(QRgb color);
KMETHOD QColor_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QRgb  color = *RawPtr_to(QRgb *, sfp[1]);
	KQColor *ret_v = new KQColor(color);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QColor QColor.new(String name);
KMETHOD QColor_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QString name = String_to(const QString, sfp[1]);
	KQColor *ret_v = new KQColor(name);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QColor QColor.new(String name);
KMETHOD QColor_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const char*  name = RawPtr_to(const char*, sfp[1]);
	KQColor *ret_v = new KQColor(name);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QColor QColor.new(QColor color);
KMETHOD QColor_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QColor  color = *RawPtr_to(const QColor *, sfp[1]);
	KQColor *ret_v = new KQColor(color);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QColor QColor.new(int color);
KMETHOD QColor_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	Qt::GlobalColor color = Int_to(Qt::GlobalColor, sfp[1]);
	KQColor *ret_v = new KQColor(color);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//int QColor.getAlpha();
KMETHOD QColor_getAlpha(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int ret_v = qp->alpha();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//float QColor.getAlphaF();
KMETHOD QColor_getAlphaF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal ret_v = qp->alphaF();
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//int QColor.black();
KMETHOD QColor_black(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int ret_v = qp->black();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//float QColor.blackF();
KMETHOD QColor_blackF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal ret_v = qp->blackF();
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//int QColor.getBlue();
KMETHOD QColor_getBlue(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int ret_v = qp->blue();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//float QColor.getBlueF();
KMETHOD QColor_getBlueF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal ret_v = qp->blueF();
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//QColor QColor.convertTo(int colorSpec);
KMETHOD QColor_convertTo(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		QColor::Spec colorSpec = Int_to(QColor::Spec, sfp[1]);
		QColor ret_v = qp->convertTo(colorSpec);
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QColor.cyan();
KMETHOD QColor_cyan(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int ret_v = qp->cyan();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//float QColor.cyanF();
KMETHOD QColor_cyanF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal ret_v = qp->cyanF();
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//QColor QColor.darker(int factor);
KMETHOD QColor_darker(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int factor = Int_to(int, sfp[1]);
		QColor ret_v = qp->darker(factor);
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QColor.getCmyk(int c, int m, int y, int k, int a);
KMETHOD QColor_getCmyk(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int* c = Int_to(int*, sfp[1]);
		int* m = Int_to(int*, sfp[2]);
		int* y = Int_to(int*, sfp[3]);
		int* k = Int_to(int*, sfp[4]);
		int* a = Int_to(int*, sfp[5]);
		qp->getCmyk(c, m, y, k, a);
	}
	RETURNvoid_();
}

//void QColor.getCmykF(float c, float m, float y, float k, float a);
KMETHOD QColor_getCmykF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal*  c = RawPtr_to(qreal*, sfp[1]);
		qreal*  m = RawPtr_to(qreal*, sfp[2]);
		qreal*  y = RawPtr_to(qreal*, sfp[3]);
		qreal*  k = RawPtr_to(qreal*, sfp[4]);
		qreal*  a = RawPtr_to(qreal*, sfp[5]);
		qp->getCmykF(c, m, y, k, a);
	}
	RETURNvoid_();
}

//void QColor.getHsl(int h, int s, int l, int a);
KMETHOD QColor_getHsl(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int* h = Int_to(int*, sfp[1]);
		int* s = Int_to(int*, sfp[2]);
		int* l = Int_to(int*, sfp[3]);
		int* a = Int_to(int*, sfp[4]);
		qp->getHsl(h, s, l, a);
	}
	RETURNvoid_();
}

//void QColor.getHslF(float h, float s, float l, float a);
KMETHOD QColor_getHslF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal*  h = RawPtr_to(qreal*, sfp[1]);
		qreal*  s = RawPtr_to(qreal*, sfp[2]);
		qreal*  l = RawPtr_to(qreal*, sfp[3]);
		qreal*  a = RawPtr_to(qreal*, sfp[4]);
		qp->getHslF(h, s, l, a);
	}
	RETURNvoid_();
}

//void QColor.getHsv(int h, int s, int v, int a);
KMETHOD QColor_getHsv(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int* h = Int_to(int*, sfp[1]);
		int* s = Int_to(int*, sfp[2]);
		int* v = Int_to(int*, sfp[3]);
		int* a = Int_to(int*, sfp[4]);
		qp->getHsv(h, s, v, a);
	}
	RETURNvoid_();
}

//void QColor.getHsvF(float h, float s, float v, float a);
KMETHOD QColor_getHsvF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal*  h = RawPtr_to(qreal*, sfp[1]);
		qreal*  s = RawPtr_to(qreal*, sfp[2]);
		qreal*  v = RawPtr_to(qreal*, sfp[3]);
		qreal*  a = RawPtr_to(qreal*, sfp[4]);
		qp->getHsvF(h, s, v, a);
	}
	RETURNvoid_();
}

//void QColor.getRgb(int r, int g, int b, int a);
KMETHOD QColor_getRgb(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int* r = Int_to(int*, sfp[1]);
		int* g = Int_to(int*, sfp[2]);
		int* b = Int_to(int*, sfp[3]);
		int* a = Int_to(int*, sfp[4]);
		qp->getRgb(r, g, b, a);
	}
	RETURNvoid_();
}

//void QColor.getRgbF(float r, float g, float b, float a);
KMETHOD QColor_getRgbF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal*  r = RawPtr_to(qreal*, sfp[1]);
		qreal*  g = RawPtr_to(qreal*, sfp[2]);
		qreal*  b = RawPtr_to(qreal*, sfp[3]);
		qreal*  a = RawPtr_to(qreal*, sfp[4]);
		qp->getRgbF(r, g, b, a);
	}
	RETURNvoid_();
}

//int QColor.getGreen();
KMETHOD QColor_getGreen(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int ret_v = qp->green();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//float QColor.getGreenF();
KMETHOD QColor_getGreenF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal ret_v = qp->greenF();
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//int QColor.hslHue();
KMETHOD QColor_hslHue(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int ret_v = qp->hslHue();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//float QColor.hslHueF();
KMETHOD QColor_hslHueF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal ret_v = qp->hslHueF();
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//int QColor.hslSaturation();
KMETHOD QColor_hslSaturation(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int ret_v = qp->hslSaturation();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//float QColor.hslSaturationF();
KMETHOD QColor_hslSaturationF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal ret_v = qp->hslSaturationF();
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//int QColor.hsvHue();
KMETHOD QColor_hsvHue(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int ret_v = qp->hsvHue();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//float QColor.hsvHueF();
KMETHOD QColor_hsvHueF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal ret_v = qp->hsvHueF();
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//int QColor.hsvSaturation();
KMETHOD QColor_hsvSaturation(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int ret_v = qp->hsvSaturation();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//float QColor.hsvSaturationF();
KMETHOD QColor_hsvSaturationF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal ret_v = qp->hsvSaturationF();
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//int QColor.hue();
KMETHOD QColor_hue(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int ret_v = qp->hue();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//float QColor.hueF();
KMETHOD QColor_hueF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal ret_v = qp->hueF();
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//QColor QColor.lighter(int factor);
KMETHOD QColor_lighter(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int factor = Int_to(int, sfp[1]);
		QColor ret_v = qp->lighter(factor);
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QColor.lightness();
KMETHOD QColor_lightness(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int ret_v = qp->lightness();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//float QColor.lightnessF();
KMETHOD QColor_lightnessF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal ret_v = qp->lightnessF();
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//int QColor.magenta();
KMETHOD QColor_magenta(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int ret_v = qp->magenta();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//float QColor.magentaF();
KMETHOD QColor_magentaF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal ret_v = qp->magentaF();
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//String QColor.name();
KMETHOD QColor_name(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		QString ret_v = qp->name();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QColor.getRed();
KMETHOD QColor_getRed(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int ret_v = qp->red();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//float QColor.getRedF();
KMETHOD QColor_getRedF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal ret_v = qp->redF();
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//QRgb QColor.rgb();
KMETHOD QColor_rgb(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		QRgb ret_v = qp->rgb();
		QRgb *ret_v_ = new QRgb(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QRgb QColor.getRgba();
KMETHOD QColor_getRgba(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		QRgb ret_v = qp->rgba();
		QRgb *ret_v_ = new QRgb(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QColor.saturation();
KMETHOD QColor_saturation(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int ret_v = qp->saturation();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//float QColor.saturationF();
KMETHOD QColor_saturationF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal ret_v = qp->saturationF();
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//void QColor.setAlpha(int alpha);
KMETHOD QColor_setAlpha(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int alpha = Int_to(int, sfp[1]);
		qp->setAlpha(alpha);
	}
	RETURNvoid_();
}

//void QColor.setAlphaF(float alpha);
KMETHOD QColor_setAlphaF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal alpha = Float_to(qreal, sfp[1]);
		qp->setAlphaF(alpha);
	}
	RETURNvoid_();
}

//void QColor.setBlue(int blue);
KMETHOD QColor_setBlue(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int blue = Int_to(int, sfp[1]);
		qp->setBlue(blue);
	}
	RETURNvoid_();
}

//void QColor.setBlueF(float blue);
KMETHOD QColor_setBlueF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal blue = Float_to(qreal, sfp[1]);
		qp->setBlueF(blue);
	}
	RETURNvoid_();
}

//void QColor.setCmyk(int c, int m, int y, int k, int a);
KMETHOD QColor_setCmyk(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int c = Int_to(int, sfp[1]);
		int m = Int_to(int, sfp[2]);
		int y = Int_to(int, sfp[3]);
		int k = Int_to(int, sfp[4]);
		int a = Int_to(int, sfp[5]);
		qp->setCmyk(c, m, y, k, a);
	}
	RETURNvoid_();
}

//void QColor.setCmykF(float c, float m, float y, float k, float a);
KMETHOD QColor_setCmykF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal c = Float_to(qreal, sfp[1]);
		qreal m = Float_to(qreal, sfp[2]);
		qreal y = Float_to(qreal, sfp[3]);
		qreal k = Float_to(qreal, sfp[4]);
		qreal a = Float_to(qreal, sfp[5]);
		qp->setCmykF(c, m, y, k, a);
	}
	RETURNvoid_();
}

//void QColor.setGreen(int green);
KMETHOD QColor_setGreen(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int green = Int_to(int, sfp[1]);
		qp->setGreen(green);
	}
	RETURNvoid_();
}

//void QColor.setGreenF(float green);
KMETHOD QColor_setGreenF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal green = Float_to(qreal, sfp[1]);
		qp->setGreenF(green);
	}
	RETURNvoid_();
}

//void QColor.setHsl(int h, int s, int l, int a);
KMETHOD QColor_setHsl(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int h = Int_to(int, sfp[1]);
		int s = Int_to(int, sfp[2]);
		int l = Int_to(int, sfp[3]);
		int a = Int_to(int, sfp[4]);
		qp->setHsl(h, s, l, a);
	}
	RETURNvoid_();
}

//void QColor.setHslF(float h, float s, float l, float a);
KMETHOD QColor_setHslF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal h = Float_to(qreal, sfp[1]);
		qreal s = Float_to(qreal, sfp[2]);
		qreal l = Float_to(qreal, sfp[3]);
		qreal a = Float_to(qreal, sfp[4]);
		qp->setHslF(h, s, l, a);
	}
	RETURNvoid_();
}

//void QColor.setHsv(int h, int s, int v, int a);
KMETHOD QColor_setHsv(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int h = Int_to(int, sfp[1]);
		int s = Int_to(int, sfp[2]);
		int v = Int_to(int, sfp[3]);
		int a = Int_to(int, sfp[4]);
		qp->setHsv(h, s, v, a);
	}
	RETURNvoid_();
}

//void QColor.setHsvF(float h, float s, float v, float a);
KMETHOD QColor_setHsvF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal h = Float_to(qreal, sfp[1]);
		qreal s = Float_to(qreal, sfp[2]);
		qreal v = Float_to(qreal, sfp[3]);
		qreal a = Float_to(qreal, sfp[4]);
		qp->setHsvF(h, s, v, a);
	}
	RETURNvoid_();
}

//void QColor.setNamedColor(String name);
KMETHOD QColor_setNamedColor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		const QString name = String_to(const QString, sfp[1]);
		qp->setNamedColor(name);
	}
	RETURNvoid_();
}

//void QColor.setRed(int red);
KMETHOD QColor_setRed(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int red = Int_to(int, sfp[1]);
		qp->setRed(red);
	}
	RETURNvoid_();
}

//void QColor.setRedF(float red);
KMETHOD QColor_setRedF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal red = Float_to(qreal, sfp[1]);
		qp->setRedF(red);
	}
	RETURNvoid_();
}

//void QColor.setRgb(int r, int g, int b, int a);
KMETHOD QColor_setRgb(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int r = Int_to(int, sfp[1]);
		int g = Int_to(int, sfp[2]);
		int b = Int_to(int, sfp[3]);
		int a = Int_to(int, sfp[4]);
		qp->setRgb(r, g, b, a);
	}
	RETURNvoid_();
}

/*
//void QColor.setRgb(QRgb rgb);
KMETHOD QColor_setRgb(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		QRgb  rgb = *RawPtr_to(QRgb *, sfp[1]);
		qp->setRgb(rgb);
	}
	RETURNvoid_();
}
*/
//void QColor.setRgbF(float r, float g, float b, float a);
KMETHOD QColor_setRgbF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal r = Float_to(qreal, sfp[1]);
		qreal g = Float_to(qreal, sfp[2]);
		qreal b = Float_to(qreal, sfp[3]);
		qreal a = Float_to(qreal, sfp[4]);
		qp->setRgbF(r, g, b, a);
	}
	RETURNvoid_();
}

//void QColor.setRgba(QRgb rgba);
KMETHOD QColor_setRgba(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		QRgb  rgba = *RawPtr_to(QRgb *, sfp[1]);
		qp->setRgba(rgba);
	}
	RETURNvoid_();
}

//int QColor.spec();
KMETHOD QColor_spec(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		QColor::Spec ret_v = qp->spec();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QColor QColor.toCmyk();
KMETHOD QColor_toCmyk(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		QColor ret_v = qp->toCmyk();
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QColor QColor.toHsl();
KMETHOD QColor_toHsl(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		QColor ret_v = qp->toHsl();
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QColor QColor.toHsv();
KMETHOD QColor_toHsv(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		QColor ret_v = qp->toHsv();
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QColor QColor.toRgb();
KMETHOD QColor_toRgb(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		QColor ret_v = qp->toRgb();
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QColor.value();
KMETHOD QColor_value(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int ret_v = qp->value();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//float QColor.valueF();
KMETHOD QColor_valueF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal ret_v = qp->valueF();
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//int QColor.yellow();
KMETHOD QColor_yellow(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		int ret_v = qp->yellow();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//float QColor.yellowF();
KMETHOD QColor_yellowF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *  qp = RawPtr_to(QColor *, sfp[0]);
	if (qp) {
		qreal ret_v = qp->yellowF();
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//QColor QColor.fromCmyk(int c, int m, int y, int k, int a);
KMETHOD QColor_fromCmyk(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int c = Int_to(int, sfp[1]);
		int m = Int_to(int, sfp[2]);
		int y = Int_to(int, sfp[3]);
		int k = Int_to(int, sfp[4]);
		int a = Int_to(int, sfp[5]);
		QColor ret_v = QColor::fromCmyk(c, m, y, k, a);
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QColor QColor.fromCmykF(float c, float m, float y, float k, float a);
KMETHOD QColor_fromCmykF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		qreal c = Float_to(qreal, sfp[1]);
		qreal m = Float_to(qreal, sfp[2]);
		qreal y = Float_to(qreal, sfp[3]);
		qreal k = Float_to(qreal, sfp[4]);
		qreal a = Float_to(qreal, sfp[5]);
		QColor ret_v = QColor::fromCmykF(c, m, y, k, a);
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QColor QColor.fromHsl(int h, int s, int l, int a);
KMETHOD QColor_fromHsl(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int h = Int_to(int, sfp[1]);
		int s = Int_to(int, sfp[2]);
		int l = Int_to(int, sfp[3]);
		int a = Int_to(int, sfp[4]);
		QColor ret_v = QColor::fromHsl(h, s, l, a);
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QColor QColor.fromHslF(float h, float s, float l, float a);
KMETHOD QColor_fromHslF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		qreal h = Float_to(qreal, sfp[1]);
		qreal s = Float_to(qreal, sfp[2]);
		qreal l = Float_to(qreal, sfp[3]);
		qreal a = Float_to(qreal, sfp[4]);
		QColor ret_v = QColor::fromHslF(h, s, l, a);
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QColor QColor.fromHsv(int h, int s, int v, int a);
KMETHOD QColor_fromHsv(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int h = Int_to(int, sfp[1]);
		int s = Int_to(int, sfp[2]);
		int v = Int_to(int, sfp[3]);
		int a = Int_to(int, sfp[4]);
		QColor ret_v = QColor::fromHsv(h, s, v, a);
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QColor QColor.fromHsvF(float h, float s, float v, float a);
KMETHOD QColor_fromHsvF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		qreal h = Float_to(qreal, sfp[1]);
		qreal s = Float_to(qreal, sfp[2]);
		qreal v = Float_to(qreal, sfp[3]);
		qreal a = Float_to(qreal, sfp[4]);
		QColor ret_v = QColor::fromHsvF(h, s, v, a);
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QColor QColor.fromRgb(QRgb rgb);
KMETHOD QColor_fromRgb(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QRgb  rgb = *RawPtr_to(QRgb *, sfp[1]);
		QColor ret_v = QColor::fromRgb(rgb);
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//QColor QColor.fromRgb(int r, int g, int b, int a);
KMETHOD QColor_fromRgb(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int r = Int_to(int, sfp[1]);
		int g = Int_to(int, sfp[2]);
		int b = Int_to(int, sfp[3]);
		int a = Int_to(int, sfp[4]);
		QColor ret_v = QColor::fromRgb(r, g, b, a);
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//QColor QColor.fromRgbF(float r, float g, float b, float a);
KMETHOD QColor_fromRgbF(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		qreal r = Float_to(qreal, sfp[1]);
		qreal g = Float_to(qreal, sfp[2]);
		qreal b = Float_to(qreal, sfp[3]);
		qreal a = Float_to(qreal, sfp[4]);
		QColor ret_v = QColor::fromRgbF(r, g, b, a);
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QColor QColor.fromRgba(QRgb rgba);
KMETHOD QColor_fromRgba(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QRgb  rgba = *RawPtr_to(QRgb *, sfp[1]);
		QColor ret_v = QColor::fromRgba(rgba);
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QColor.isValidColor(String name);
KMETHOD QColor_isValidColor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString name = String_to(const QString, sfp[1]);
		bool ret_v = QColor::isValidColor(name);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//Array<String> QColor.parents();
KMETHOD QColor_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColor *qp = RawPtr_to(QColor*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQColor::DummyQColor()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQColor::~DummyQColor()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQColor::setSelf(kRawPtr *ptr)
{
	DummyQColor::self = ptr;
}

bool DummyQColor::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQColor::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQColor::event_map->bigin();
	if ((itr = DummyQColor::event_map->find(str)) == DummyQColor::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQColor::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQColor::slot_map->bigin();
	if ((itr = DummyQColor::slot_map->find(str)) == DummyQColor::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQColor::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQColor::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQColor::connection(QObject *o)
{
	QColor *p = dynamic_cast<QColor*>(o);
	if (p != NULL) {
	}
}

KQColor::KQColor() : QColor()
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQColor();
}

KQColor::~KQColor()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QColor_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQColor *qp = RawPtr_to(KQColor *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QColor]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QColor]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QColor_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQColor *qp = RawPtr_to(KQColor *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QColor]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QColor]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QColor_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQColor *qp = (KQColor *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QColor*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QColor_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQColor *qp = (KQColor *)p->rawptr;
		KQColor *qp = static_cast<KQColor*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QColor_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (*static_cast<QColor*>(p1->rawptr) == *static_cast<QColor*>(p2->rawptr) ? 0 : 1);
}

void KQColor::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

static knh_IntData_t QColorConstInt[] = {
	{"Rgb", QColor::Rgb},
	{"Hsv", QColor::Hsv},
	{"Cmyk", QColor::Cmyk},
	{"Hsl", QColor::Hsl},
	{"Invalid", QColor::Invalid},
	{NULL, 0}
};

DEFAPI(void) constQColor(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QColorConstInt);
}


DEFAPI(void) defQColor(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QColor";
	cdef->free = QColor_free;
	cdef->reftrace = QColor_reftrace;
	cdef->compareTo = QColor_compareTo;
}


//@Virtual @Override void QColorDialog.setVisible(boolean visible);
KMETHOD QColorDialog_setVisible(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColorDialog *  qp = RawPtr_to(QColorDialog *, sfp[0]);
	if (qp) {
		bool visible = Boolean_to(bool, sfp[1]);
		qp->setVisible(visible);
	}
	RETURNvoid_();
}

//QColorDialog QColorDialog.new(QWidget parent);
KMETHOD QColorDialog_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QWidget*  parent = RawPtr_to(QWidget*, sfp[1]);
	KQColorDialog *ret_v = new KQColorDialog(parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QColorDialog QColorDialog.new(QColor initial, QWidget parent);
KMETHOD QColorDialog_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QColor  initial = *RawPtr_to(const QColor *, sfp[1]);
	QWidget*  parent = RawPtr_to(QWidget*, sfp[2]);
	KQColorDialog *ret_v = new KQColorDialog(initial, parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//QColor QColorDialog.getCurrentColor();
KMETHOD QColorDialog_getCurrentColor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColorDialog *  qp = RawPtr_to(QColorDialog *, sfp[0]);
	if (qp) {
		QColor ret_v = qp->currentColor();
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QColorDialog.open();
KMETHOD QColorDialog_open(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColorDialog *  qp = RawPtr_to(QColorDialog *, sfp[0]);
	if (qp) {
		qp->open();
	}
	RETURNvoid_();
}

/*
//void QColorDialog.open(QObject receiver, String member);
KMETHOD QColorDialog_open(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColorDialog *  qp = RawPtr_to(QColorDialog *, sfp[0]);
	if (qp) {
		QObject*  receiver = RawPtr_to(QObject*, sfp[1]);
		const char*  member = RawPtr_to(const char*, sfp[2]);
		qp->open(receiver, member);
	}
	RETURNvoid_();
}
*/
//QColorDialogColorDialogOptions QColorDialog.getOptions();
KMETHOD QColorDialog_getOptions(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColorDialog *  qp = RawPtr_to(QColorDialog *, sfp[0]);
	if (qp) {
		QColorDialog::ColorDialogOptions ret_v = qp->options();
		QColorDialog::ColorDialogOptions *ret_v_ = new QColorDialog::ColorDialogOptions(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QColor QColorDialog.selectedColor();
KMETHOD QColorDialog_selectedColor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColorDialog *  qp = RawPtr_to(QColorDialog *, sfp[0]);
	if (qp) {
		QColor ret_v = qp->selectedColor();
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QColorDialog.setCurrentColor(QColor color);
KMETHOD QColorDialog_setCurrentColor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColorDialog *  qp = RawPtr_to(QColorDialog *, sfp[0]);
	if (qp) {
		const QColor  color = *RawPtr_to(const QColor *, sfp[1]);
		qp->setCurrentColor(color);
	}
	RETURNvoid_();
}

//void QColorDialog.setOption(int option, boolean on);
KMETHOD QColorDialog_setOption(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColorDialog *  qp = RawPtr_to(QColorDialog *, sfp[0]);
	if (qp) {
		QColorDialog::ColorDialogOption option = Int_to(QColorDialog::ColorDialogOption, sfp[1]);
		bool on = Boolean_to(bool, sfp[2]);
		qp->setOption(option, on);
	}
	RETURNvoid_();
}

//void QColorDialog.setOptions(QColorDialogColorDialogOptions options);
KMETHOD QColorDialog_setOptions(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColorDialog *  qp = RawPtr_to(QColorDialog *, sfp[0]);
	if (qp) {
		initFlag(options, QColorDialog::ColorDialogOptions, sfp[1]);
		qp->setOptions(options);
	}
	RETURNvoid_();
}

//boolean QColorDialog.testOption(int option);
KMETHOD QColorDialog_testOption(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColorDialog *  qp = RawPtr_to(QColorDialog *, sfp[0]);
	if (qp) {
		QColorDialog::ColorDialogOption option = Int_to(QColorDialog::ColorDialogOption, sfp[1]);
		bool ret_v = qp->testOption(option);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//QRgb QColorDialog.getCustomColor(int index);
KMETHOD QColorDialog_getCustomColor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int index = Int_to(int, sfp[1]);
		QRgb ret_v = QColorDialog::customColor(index);
		QRgb *ret_v_ = new QRgb(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QColorDialog.customCount();
KMETHOD QColorDialog_customCount(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int ret_v = QColorDialog::customCount();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QColor QColorDialog.getColor(QColor initial, QWidget parent, String title, QColorDialogColorDialogOptions options);
KMETHOD QColorDialog_getColor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QColor  initial = *RawPtr_to(const QColor *, sfp[1]);
		QWidget*  parent = RawPtr_to(QWidget*, sfp[2]);
		const QString title = String_to(const QString, sfp[3]);
		initFlag(options, QColorDialog::ColorDialogOptions, sfp[4]);
		QColor ret_v = QColorDialog::getColor(initial, parent, title, options);
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//QColor QColorDialog.getColor(QColor initial, QWidget parent);
KMETHOD QColorDialog_getColor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QColor  initial = *RawPtr_to(const QColor *, sfp[1]);
		QWidget*  parent = RawPtr_to(QWidget*, sfp[2]);
		QColor ret_v = QColorDialog::getColor(initial, parent);
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//void QColorDialog.setCustomColor(int index, QRgb color);
KMETHOD QColorDialog_setCustomColor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int index = Int_to(int, sfp[1]);
		QRgb  color = *RawPtr_to(QRgb *, sfp[2]);
		QColorDialog::setCustomColor(index, color);
	}
	RETURNvoid_();
}

//void QColorDialog.setStandardColor(int index, QRgb color);
KMETHOD QColorDialog_setStandardColor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int index = Int_to(int, sfp[1]);
		QRgb  color = *RawPtr_to(QRgb *, sfp[2]);
		QColorDialog::setStandardColor(index, color);
	}
	RETURNvoid_();
}


DummyQColorDialog::DummyQColorDialog()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	color_selected_func = NULL;
	current_color_changed_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("color-selected", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("current-color-changed", NULL));
}
DummyQColorDialog::~DummyQColorDialog()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQColorDialog::setSelf(kRawPtr *ptr)
{
	DummyQColorDialog::self = ptr;
	DummyQDialog::setSelf(ptr);
}

bool DummyQColorDialog::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQDialog::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQColorDialog::colorSelectedSlot(const QColor color)
{
	if (color_selected_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QColor, color);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, color_selected_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQColorDialog::currentColorChangedSlot(const QColor color)
{
	if (current_color_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QColor, color);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, current_color_changed_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQColorDialog::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQColorDialog::event_map->bigin();
	if ((itr = DummyQColorDialog::event_map->find(str)) == DummyQColorDialog::event_map->end()) {
		bool ret = false;
		ret = DummyQDialog::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQColorDialog::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQColorDialog::slot_map->bigin();
	if ((itr = DummyQColorDialog::slot_map->find(str)) == DummyQColorDialog::slot_map->end()) {
		bool ret = false;
		ret = DummyQDialog::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		color_selected_func = (*slot_map)["color-selected"];
		current_color_changed_func = (*slot_map)["current-color-changed"];
		return true;
	}
}

kObject** DummyQColorDialog::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQColorDialog::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 3;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, color_selected_func);
	KNH_ADDNNREF(ctx, current_color_changed_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQDialog::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQColorDialog::connection(QObject *o)
{
	QColorDialog *p = dynamic_cast<QColorDialog*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(colorSelected(const QColor)), this, SLOT(colorSelectedSlot(const QColor)));
		connect(p, SIGNAL(currentColorChanged(const QColor)), this, SLOT(currentColorChangedSlot(const QColor)));
	}
	DummyQDialog::connection(o);
}

KQColorDialog::KQColorDialog(QWidget* parent) : QColorDialog(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQColorDialog();
	dummy->connection((QObject*)this);
}

KQColorDialog::~KQColorDialog()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QColorDialog_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQColorDialog *qp = RawPtr_to(KQColorDialog *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QColorDialog]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QColorDialog]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QColorDialog_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQColorDialog *qp = RawPtr_to(KQColorDialog *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QColorDialog]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QColorDialog]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QColorDialog_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQColorDialog *qp = (KQColorDialog *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QColorDialog*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QColorDialog_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQColorDialog *qp = (KQColorDialog *)p->rawptr;
		KQColorDialog *qp = static_cast<KQColorDialog*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QColorDialog_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQColorDialog::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQColorDialog::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QColorDialog::event(event);
		return false;
	}
//	QColorDialog::event(event);
	return true;
}

static knh_IntData_t QColorDialogConstInt[] = {
//	{"ShowAlphaChannel", QColorDialog::ShowAlphaChannel},
	{"NoButtons", QColorDialog::NoButtons},
	{"DontUseNativeDialog", QColorDialog::DontUseNativeDialog},
	{NULL, 0}
};

DEFAPI(void) constQColorDialog(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QColorDialogConstInt);
}


DEFAPI(void) defQColorDialog(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QColorDialog";
	cdef->free = QColorDialog_free;
	cdef->reftrace = QColorDialog_reftrace;
	cdef->compareTo = QColorDialog_compareTo;
}

//## QColorDialogColorDialogOptions QColorDialogColorDialogOptions.new(int value);
KMETHOD QColorDialogColorDialogOptions_new(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QColorDialog::ColorDialogOption i = Int_to(QColorDialog::ColorDialogOption, sfp[1]);
	QColorDialog::ColorDialogOptions *ret_v = new QColorDialog::ColorDialogOptions(i);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	RETURN_(rptr);
}

//## QColorDialogColorDialogOptions QColorDialogColorDialogOptions.and(int mask);
KMETHOD QColorDialogColorDialogOptions_and(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QColorDialog::ColorDialogOptions *qp = RawPtr_to(QColorDialog::ColorDialogOptions*, sfp[0]);
	if (qp != NULL) {
		int i = Int_to(int, sfp[1]);
		QColorDialog::ColorDialogOptions ret = ((*qp) & i);
		QColorDialog::ColorDialogOptions *ret_ = new QColorDialog::ColorDialogOptions(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QColorDialogColorDialogOptions QColorDialogColorDialogOptions.iand(QColorDialog::QColorDialogColorDialogOptions other);
KMETHOD QColorDialogColorDialogOptions_iand(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QColorDialog::ColorDialogOptions *qp = RawPtr_to(QColorDialog::ColorDialogOptions*, sfp[0]);
	if (qp != NULL) {
		QColorDialog::ColorDialogOptions *other = RawPtr_to(QColorDialog::ColorDialogOptions *, sfp[1]);
		*qp = ((*qp) & (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QColorDialogColorDialogOptions QColorDialogColorDialogOptions.or(QColorDialogColorDialogOptions f);
KMETHOD QColorDialogColorDialogOptions_or(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColorDialog::ColorDialogOptions *qp = RawPtr_to(QColorDialog::ColorDialogOptions*, sfp[0]);
	if (qp != NULL) {
		QColorDialog::ColorDialogOptions *f = RawPtr_to(QColorDialog::ColorDialogOptions*, sfp[1]);
		QColorDialog::ColorDialogOptions ret = ((*qp) | (*f));
		QColorDialog::ColorDialogOptions *ret_ = new QColorDialog::ColorDialogOptions(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QColorDialogColorDialogOptions QColorDialogColorDialogOptions.ior(QColorDialog::QColorDialogColorDialogOptions other);
KMETHOD QColorDialogColorDialogOptions_ior(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QColorDialog::ColorDialogOptions *qp = RawPtr_to(QColorDialog::ColorDialogOptions*, sfp[0]);
	if (qp != NULL) {
		QColorDialog::ColorDialogOptions *other = RawPtr_to(QColorDialog::ColorDialogOptions *, sfp[1]);
		*qp = ((*qp) | (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QColorDialogColorDialogOptions QColorDialogColorDialogOptions.xor(QColorDialogColorDialogOptions f);
KMETHOD QColorDialogColorDialogOptions_xor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColorDialog::ColorDialogOptions *qp = RawPtr_to(QColorDialog::ColorDialogOptions*, sfp[0]);
	if (qp != NULL) {
		QColorDialog::ColorDialogOptions *f = RawPtr_to(QColorDialog::ColorDialogOptions*, sfp[1]);
		QColorDialog::ColorDialogOptions ret = ((*qp) ^ (*f));
		QColorDialog::ColorDialogOptions *ret_ = new QColorDialog::ColorDialogOptions(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QColorDialogColorDialogOptions QColorDialogColorDialogOptions.ixor(QColorDialog::QColorDialogColorDialogOptions other);
KMETHOD QColorDialogColorDialogOptions_ixor(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QColorDialog::ColorDialogOptions *qp = RawPtr_to(QColorDialog::ColorDialogOptions*, sfp[0]);
	if (qp != NULL) {
		QColorDialog::ColorDialogOptions *other = RawPtr_to(QColorDialog::ColorDialogOptions *, sfp[1]);
		*qp = ((*qp) ^ (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## boolean QColorDialogColorDialogOptions.testFlag(int flag);
KMETHOD QColorDialogColorDialogOptions_testFlag(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QColorDialog::ColorDialogOptions *qp = RawPtr_to(QColorDialog::ColorDialogOptions *, sfp[0]);
	if (qp != NULL) {
		QColorDialog::ColorDialogOption flag = Int_to(QColorDialog::ColorDialogOption, sfp[1]);
		bool ret = qp->testFlag(flag);
		RETURNb_(ret);
	} else {
		RETURNb_(false);
	}
}

//## int QColorDialogColorDialogOptions.value();
KMETHOD QColorDialogColorDialogOptions_value(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QColorDialog::ColorDialogOptions *qp = RawPtr_to(QColorDialog::ColorDialogOptions *, sfp[0]);
	if (qp != NULL) {
		int ret = int(*qp);
		RETURNi_(ret);
	} else {
		RETURNi_(0);
	}
}

static void QColorDialogColorDialogOptions_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (p->rawptr != NULL) {
		QColorDialog::ColorDialogOptions *qp = (QColorDialog::ColorDialogOptions *)p->rawptr;
		(void)qp;
		delete qp;
		p->rawptr = NULL;
	}
}

static void QColorDialogColorDialogOptions_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
	if (p->rawptr != NULL) {
		QColorDialog::ColorDialogOptions *qp = (QColorDialog::ColorDialogOptions *)p->rawptr;
		(void)qp;
	}
}

static int QColorDialogColorDialogOptions_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	if (p1->rawptr == NULL || p2->rawptr == NULL) {
		return 1;
	} else {
//		int v1 = int(*(QColorDialog::ColorDialogOptions*)p1->rawptr);
//		int v2 = int(*(QColorDialog::ColorDialogOptions*)p2->rawptr);
//		return (v1 == v2 ? 0 : 1);
		QColorDialog::ColorDialogOptions v1 = *(QColorDialog::ColorDialogOptions*)p1->rawptr;
		QColorDialog::ColorDialogOptions v2 = *(QColorDialog::ColorDialogOptions*)p2->rawptr;
//		return (v1 == v2 ? 0 : 1);
		return (v1 == v2 ? 0 : 1);

	}
}

DEFAPI(void) defQColorDialogColorDialogOptions(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QColorDialogColorDialogOptions";
	cdef->free = QColorDialogColorDialogOptions_free;
	cdef->reftrace = QColorDialogColorDialogOptions_reftrace;
	cdef->compareTo = QColorDialogColorDialogOptions_compareTo;
}

//QColormap QColormap.new(QColormap colormap);
KMETHOD QColormap_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QColormap  colormap = *RawPtr_to(const QColormap *, sfp[1]);
	KQColormap *ret_v = new KQColormap(colormap);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

//QColor QColormap.colorAt(int pixel);
KMETHOD QColormap_colorAt(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColormap *  qp = RawPtr_to(QColormap *, sfp[0]);
	if (qp) {
		uint  pixel = *RawPtr_to(uint *, sfp[1]);
		const QColor ret_v = qp->colorAt(pixel);
		QColor *ret_v_ = new QColor(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QColormap.depth();
KMETHOD QColormap_depth(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColormap *  qp = RawPtr_to(QColormap *, sfp[0]);
	if (qp) {
		int ret_v = qp->depth();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QColormap.mode();
KMETHOD QColormap_mode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColormap *  qp = RawPtr_to(QColormap *, sfp[0]);
	if (qp) {
		QColormap::Mode ret_v = qp->mode();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QColormap.pixel(QColor color);
KMETHOD QColormap_pixel(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColormap *  qp = RawPtr_to(QColormap *, sfp[0]);
	if (qp) {
		const QColor  color = *RawPtr_to(const QColor *, sfp[1]);
		uint ret_v = qp->pixel(color);
		uint *ret_v_ = new uint(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QColormap.size();
KMETHOD QColormap_size(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColormap *  qp = RawPtr_to(QColormap *, sfp[0]);
	if (qp) {
		int ret_v = qp->size();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QColormap QColormap.instance(int screen);
KMETHOD QColormap_instance(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int screen = Int_to(int, sfp[1]);
		QColormap ret_v = QColormap::instance(screen);
		QColormap *ret_v_ = new QColormap(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//Array<String> QColormap.parents();
KMETHOD QColormap_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColormap *qp = RawPtr_to(QColormap*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQColormap::DummyQColormap()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQColormap::~DummyQColormap()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQColormap::setSelf(kRawPtr *ptr)
{
	DummyQColormap::self = ptr;
}

bool DummyQColormap::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQColormap::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQColormap::event_map->bigin();
	if ((itr = DummyQColormap::event_map->find(str)) == DummyQColormap::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQColormap::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQColormap::slot_map->bigin();
	if ((itr = DummyQColormap::slot_map->find(str)) == DummyQColormap::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQColormap::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQColormap::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQColormap::connection(QObject *o)
{
	QColormap *p = dynamic_cast<QColormap*>(o);
	if (p != NULL) {
	}
}

KQColormap::KQColormap(const QColormap colormap) : QColormap(colormap)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQColormap();
}

KQColormap::~KQColormap()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QColormap_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQColormap *qp = RawPtr_to(KQColormap *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QColormap]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QColormap]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QColormap_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQColormap *qp = RawPtr_to(KQColormap *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QColormap]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QColormap]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QColormap_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQColormap *qp = (KQColormap *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QColormap*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QColormap_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQColormap *qp = (KQColormap *)p->rawptr;
		KQColormap *qp = static_cast<KQColormap*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QColormap_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQColormap::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

static knh_IntData_t QColormapConstInt[] = {
	{"Direct", QColormap::Direct},
	{"Indexed", QColormap::Indexed},
	{"Gray", QColormap::Gray},
	{NULL, 0}
};

DEFAPI(void) constQColormap(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QColormapConstInt);
}


DEFAPI(void) defQColormap(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QColormap";
	cdef->free = QColormap_free;
	cdef->reftrace = QColormap_reftrace;
	cdef->compareTo = QColormap_compareTo;
}


//@Virtual @Override QModelIndex QColumnView.indexAt(QPoint point);
KMETHOD QColumnView_indexAt(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColumnView *  qp = RawPtr_to(QColumnView *, sfp[0]);
	if (qp) {
		const QPoint  point = *RawPtr_to(const QPoint *, sfp[1]);
		QModelIndex ret_v = qp->indexAt(point);
		QModelIndex *ret_v_ = new QModelIndex(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override void QColumnView.scrollTo(QModelIndex index, int hint);
KMETHOD QColumnView_scrollTo(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColumnView *  qp = RawPtr_to(QColumnView *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		QColumnView::ScrollHint hint = Int_to(QColumnView::ScrollHint, sfp[2]);
		qp->scrollTo(index, hint);
	}
	RETURNvoid_();
}

//@Virtual @Override void QColumnView.selectAll();
KMETHOD QColumnView_selectAll(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColumnView *  qp = RawPtr_to(QColumnView *, sfp[0]);
	if (qp) {
		qp->selectAll();
	}
	RETURNvoid_();
}

//@Virtual @Override void QColumnView.setModel(QAbstractItemModel model);
KMETHOD QColumnView_setModel(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColumnView *  qp = RawPtr_to(QColumnView *, sfp[0]);
	if (qp) {
		QAbstractItemModel*  model = RawPtr_to(QAbstractItemModel*, sfp[1]);
		qp->setModel(model);
	}
	RETURNvoid_();
}

//@Virtual @Override void QColumnView.setRootIndex(QModelIndex index);
KMETHOD QColumnView_setRootIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColumnView *  qp = RawPtr_to(QColumnView *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		qp->setRootIndex(index);
	}
	RETURNvoid_();
}

//@Virtual @Override void QColumnView.setSelectionModel(QItemSelectionModel new_SelectionModel);
KMETHOD QColumnView_setSelectionModel(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColumnView *  qp = RawPtr_to(QColumnView *, sfp[0]);
	if (qp) {
		QItemSelectionModel*  new_SelectionModel = RawPtr_to(QItemSelectionModel*, sfp[1]);
		qp->setSelectionModel(new_SelectionModel);
	}
	RETURNvoid_();
}

//@Virtual @Override QSize QColumnView.sizeHint();
KMETHOD QColumnView_sizeHint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColumnView *  qp = RawPtr_to(QColumnView *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->sizeHint();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override QRect QColumnView.visualRect(QModelIndex index);
KMETHOD QColumnView_visualRect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColumnView *  qp = RawPtr_to(QColumnView *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		QRect ret_v = qp->visualRect(index);
		QRect *ret_v_ = new QRect(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QColumnView QColumnView.new(QWidget parent);
KMETHOD QColumnView_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QWidget*  parent = RawPtr_to(QWidget*, sfp[1]);
	KQColumnView *ret_v = new KQColumnView(parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

//Array<int> QColumnView.getColumnWidths();
KMETHOD QColumnView_getColumnWidths(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColumnView *  qp = RawPtr_to(QColumnView *, sfp[0]);
	if (qp) {
		QList<int> ret_v = qp->columnWidths();
		int list_size = ret_v.size();
		kArray *a = new_Array0(ctx, list_size);
		kclass_t cid = knh_getcid(ctx, STEXT("int"));
		for (int n = 0; n < list_size; n++) {
			int *ret_v_ = new int(ret_v[n]);
			kRawPtr *p = new_RawPtr(ctx, ClassTBL(cid), ret_v_);
			knh_Array_add(ctx, a, (kObject *)p);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}
	

//QWidget QColumnView.getPreviewWidget();
KMETHOD QColumnView_getPreviewWidget(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColumnView *  qp = RawPtr_to(QColumnView *, sfp[0]);
	if (qp) {
		QWidget* ret_v = qp->previewWidget();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QWidget*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QColumnView.getResizeGripsVisible();
KMETHOD QColumnView_getResizeGripsVisible(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColumnView *  qp = RawPtr_to(QColumnView *, sfp[0]);
	if (qp) {
		bool ret_v = qp->resizeGripsVisible();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QColumnView.setColumnWidths(Array<int> list);
KMETHOD QColumnView_setColumnWidths(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColumnView *  qp = RawPtr_to(QColumnView *, sfp[0]);
	if (qp) {
		kArray *a = sfp[1].a;
		int asize = knh_Array_size(a);
		QList<int> list;
		for (int n = 0; n < asize; n++) {
			kRawPtr *p = (kRawPtr*)(a->list[n]);
			list.append(*(int*)p->rawptr);
		}
		qp->setColumnWidths(list);
	}
	RETURNvoid_();
}

//void QColumnView.setPreviewWidget(QWidget widget);
KMETHOD QColumnView_setPreviewWidget(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColumnView *  qp = RawPtr_to(QColumnView *, sfp[0]);
	if (qp) {
		QWidget*  widget = RawPtr_to(QWidget*, sfp[1]);
		qp->setPreviewWidget(widget);
	}
	RETURNvoid_();
}

//void QColumnView.setResizeGripsVisible(boolean visible);
KMETHOD QColumnView_setResizeGripsVisible(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QColumnView *  qp = RawPtr_to(QColumnView *, sfp[0]);
	if (qp) {
		bool visible = Boolean_to(bool, sfp[1]);
		qp->setResizeGripsVisible(visible);
	}
	RETURNvoid_();
}


DummyQColumnView::DummyQColumnView()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	update_preview_widget_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("update-preview-widget", NULL));
}
DummyQColumnView::~DummyQColumnView()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQColumnView::setSelf(kRawPtr *ptr)
{
	DummyQColumnView::self = ptr;
	DummyQAbstractItemView::setSelf(ptr);
}

bool DummyQColumnView::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQAbstractItemView::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQColumnView::updatePreviewWidgetSlot(const QModelIndex index)
{
	if (update_preview_widget_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QModelIndex, index);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, update_preview_widget_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQColumnView::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQColumnView::event_map->bigin();
	if ((itr = DummyQColumnView::event_map->find(str)) == DummyQColumnView::event_map->end()) {
		bool ret = false;
		ret = DummyQAbstractItemView::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQColumnView::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQColumnView::slot_map->bigin();
	if ((itr = DummyQColumnView::slot_map->find(str)) == DummyQColumnView::slot_map->end()) {
		bool ret = false;
		ret = DummyQAbstractItemView::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		update_preview_widget_func = (*slot_map)["update-preview-widget"];
		return true;
	}
}

kObject** DummyQColumnView::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQColumnView::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 2;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, update_preview_widget_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQAbstractItemView::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQColumnView::connection(QObject *o)
{
	QColumnView *p = dynamic_cast<QColumnView*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(updatePreviewWidget(const QModelIndex)), this, SLOT(updatePreviewWidgetSlot(const QModelIndex)));
	}
	DummyQAbstractItemView::connection(o);
}

KQColumnView::KQColumnView(QWidget* parent) : QColumnView(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQColumnView();
	dummy->connection((QObject*)this);
}

KQColumnView::~KQColumnView()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QColumnView_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQColumnView *qp = RawPtr_to(KQColumnView *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QColumnView]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QColumnView]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QColumnView_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQColumnView *qp = RawPtr_to(KQColumnView *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QColumnView]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QColumnView]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QColumnView_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQColumnView *qp = (KQColumnView *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QColumnView*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QColumnView_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQColumnView *qp = (KQColumnView *)p->rawptr;
		KQColumnView *qp = static_cast<KQColumnView*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QColumnView_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQColumnView::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQColumnView::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QColumnView::event(event);
		return false;
	}
//	QColumnView::event(event);
	return true;
}



DEFAPI(void) defQColumnView(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QColumnView";
	cdef->free = QColumnView_free;
	cdef->reftrace = QColumnView_reftrace;
	cdef->compareTo = QColumnView_compareTo;
}


//@Virtual @Override boolean QComboBox.event(QEvent event);
KMETHOD QComboBox_event(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QEvent*  event = RawPtr_to(QEvent*, sfp[1]);
		bool ret_v = qp->event(event);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override QSize QComboBox.minimumSizeHint();
KMETHOD QComboBox_minimumSizeHint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->minimumSizeHint();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override QSize QComboBox.sizeHint();
KMETHOD QComboBox_sizeHint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->sizeHint();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QComboBox QComboBox.new(QWidget parent);
KMETHOD QComboBox_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QWidget*  parent = RawPtr_to(QWidget*, sfp[1]);
	KQComboBox *ret_v = new KQComboBox(parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

//void QComboBox.addItem(String text, QVariant userData);
KMETHOD QComboBox_addItem(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		const QString text = String_to(const QString, sfp[1]);
		const QVariant  userData = *RawPtr_to(const QVariant *, sfp[2]);
		qp->addItem(text, userData);
	}
	RETURNvoid_();
}

/*
//void QComboBox.addItem(QIcon icon, String text, QVariant userData);
KMETHOD QComboBox_addItem(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		const QIcon  icon = *RawPtr_to(const QIcon *, sfp[1]);
		const QString text = String_to(const QString, sfp[2]);
		const QVariant  userData = *RawPtr_to(const QVariant *, sfp[3]);
		qp->addItem(icon, text, userData);
	}
	RETURNvoid_();
}
*/
//QCompleter QComboBox.getCompleter();
KMETHOD QComboBox_getCompleter(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QCompleter* ret_v = qp->completer();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QCompleter*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QComboBox.count();
KMETHOD QComboBox_count(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int ret_v = qp->count();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QComboBox.getCurrentIndex();
KMETHOD QComboBox_getCurrentIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int ret_v = qp->currentIndex();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//String QComboBox.currentText();
KMETHOD QComboBox_currentText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QString ret_v = qp->currentText();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QComboBox.getDuplicatesEnabled();
KMETHOD QComboBox_getDuplicatesEnabled(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		bool ret_v = qp->duplicatesEnabled();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//int QComboBox.findData(QVariant data, int role, QtMatchFlags flags);
KMETHOD QComboBox_findData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		const QVariant  data = *RawPtr_to(const QVariant *, sfp[1]);
		int role = Int_to(int, sfp[2]);
		initFlag(flags, Qt::MatchFlags, sfp[3]);
		int ret_v = qp->findData(data, role, flags);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QComboBox.findText(String text, QtMatchFlags flags);
KMETHOD QComboBox_findText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		const QString text = String_to(const QString, sfp[1]);
		initFlag(flags, Qt::MatchFlags, sfp[2]);
		int ret_v = qp->findText(text, flags);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//boolean QComboBox.hasFrame();
KMETHOD QComboBox_hasFrame(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		bool ret_v = qp->hasFrame();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual void QComboBox.hidePopup();
KMETHOD QComboBox_hidePopup(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		qp->hidePopup();
	}
	RETURNvoid_();
}

//QSize QComboBox.getIconSize();
KMETHOD QComboBox_getIconSize(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->iconSize();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QComboBox.insertItem(int index, String text, QVariant userData);
KMETHOD QComboBox_insertItem(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		const QString text = String_to(const QString, sfp[2]);
		const QVariant  userData = *RawPtr_to(const QVariant *, sfp[3]);
		qp->insertItem(index, text, userData);
	}
	RETURNvoid_();
}

/*
//void QComboBox.insertItem(int index, QIcon icon, String text, QVariant userData);
KMETHOD QComboBox_insertItem(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		const QIcon  icon = *RawPtr_to(const QIcon *, sfp[2]);
		const QString text = String_to(const QString, sfp[3]);
		const QVariant  userData = *RawPtr_to(const QVariant *, sfp[4]);
		qp->insertItem(index, icon, text, userData);
	}
	RETURNvoid_();
}
*/
//int QComboBox.getInsertPolicy();
KMETHOD QComboBox_getInsertPolicy(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QComboBox::InsertPolicy ret_v = qp->insertPolicy();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QComboBox.insertSeparator(int index);
KMETHOD QComboBox_insertSeparator(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		qp->insertSeparator(index);
	}
	RETURNvoid_();
}

//boolean QComboBox.isEditable();
KMETHOD QComboBox_isEditable(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isEditable();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//QVariant QComboBox.getItemData(int index, int role);
KMETHOD QComboBox_getItemData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		int role = Int_to(int, sfp[2]);
		QVariant ret_v = qp->itemData(index, role);
		QVariant *ret_v_ = new QVariant(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QAbstractItemDelegate QComboBox.getItemDelegate();
KMETHOD QComboBox_getItemDelegate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QAbstractItemDelegate* ret_v = qp->itemDelegate();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractItemDelegate*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QIcon QComboBox.getItemIcon(int index);
KMETHOD QComboBox_getItemIcon(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		QIcon ret_v = qp->itemIcon(index);
		QIcon *ret_v_ = new QIcon(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QComboBox.getItemText(int index);
KMETHOD QComboBox_getItemText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		QString ret_v = qp->itemText(index);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//QLineEdit QComboBox.getLineEdit();
KMETHOD QComboBox_getLineEdit(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QLineEdit* ret_v = qp->lineEdit();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QLineEdit*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QComboBox.getMaxCount();
KMETHOD QComboBox_getMaxCount(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int ret_v = qp->maxCount();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QComboBox.getMaxVisibleItems();
KMETHOD QComboBox_getMaxVisibleItems(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int ret_v = qp->maxVisibleItems();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QComboBox.getMinimumContentsLength();
KMETHOD QComboBox_getMinimumContentsLength(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int ret_v = qp->minimumContentsLength();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QAbstractItemModel QComboBox.getModel();
KMETHOD QComboBox_getModel(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QAbstractItemModel* ret_v = qp->model();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractItemModel*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QComboBox.getModelColumn();
KMETHOD QComboBox_getModelColumn(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int ret_v = qp->modelColumn();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QComboBox.removeItem(int index);
KMETHOD QComboBox_removeItem(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		qp->removeItem(index);
	}
	RETURNvoid_();
}

//QModelIndex QComboBox.getRootModelIndex();
KMETHOD QComboBox_getRootModelIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QModelIndex ret_v = qp->rootModelIndex();
		QModelIndex *ret_v_ = new QModelIndex(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QComboBox.setCompleter(QCompleter completer);
KMETHOD QComboBox_setCompleter(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QCompleter*  completer = RawPtr_to(QCompleter*, sfp[1]);
		qp->setCompleter(completer);
	}
	RETURNvoid_();
}

//void QComboBox.setDuplicatesEnabled(boolean enable);
KMETHOD QComboBox_setDuplicatesEnabled(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		bool enable = Boolean_to(bool, sfp[1]);
		qp->setDuplicatesEnabled(enable);
	}
	RETURNvoid_();
}

//void QComboBox.setEditable(boolean editable);
KMETHOD QComboBox_setEditable(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		bool editable = Boolean_to(bool, sfp[1]);
		qp->setEditable(editable);
	}
	RETURNvoid_();
}

//void QComboBox.setFrame(boolean arg0);
KMETHOD QComboBox_setFrame(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setFrame(arg0);
	}
	RETURNvoid_();
}

//void QComboBox.setIconSize(QSize size);
KMETHOD QComboBox_setIconSize(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		const QSize  size = *RawPtr_to(const QSize *, sfp[1]);
		qp->setIconSize(size);
	}
	RETURNvoid_();
}

//void QComboBox.setInsertPolicy(int policy);
KMETHOD QComboBox_setInsertPolicy(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QComboBox::InsertPolicy policy = Int_to(QComboBox::InsertPolicy, sfp[1]);
		qp->setInsertPolicy(policy);
	}
	RETURNvoid_();
}

//void QComboBox.setItemData(int index, QVariant value, int role);
KMETHOD QComboBox_setItemData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		const QVariant  value = *RawPtr_to(const QVariant *, sfp[2]);
		int role = Int_to(int, sfp[3]);
		qp->setItemData(index, value, role);
	}
	RETURNvoid_();
}

//void QComboBox.setItemDelegate(QAbstractItemDelegate delegate);
KMETHOD QComboBox_setItemDelegate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QAbstractItemDelegate*  delegate = RawPtr_to(QAbstractItemDelegate*, sfp[1]);
		qp->setItemDelegate(delegate);
	}
	RETURNvoid_();
}

//void QComboBox.setItemIcon(int index, QIcon icon);
KMETHOD QComboBox_setItemIcon(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		const QIcon  icon = *RawPtr_to(const QIcon *, sfp[2]);
		qp->setItemIcon(index, icon);
	}
	RETURNvoid_();
}

//void QComboBox.setItemText(int index, String text);
KMETHOD QComboBox_setItemText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		const QString text = String_to(const QString, sfp[2]);
		qp->setItemText(index, text);
	}
	RETURNvoid_();
}

//void QComboBox.setLineEdit(QLineEdit edit);
KMETHOD QComboBox_setLineEdit(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QLineEdit*  edit = RawPtr_to(QLineEdit*, sfp[1]);
		qp->setLineEdit(edit);
	}
	RETURNvoid_();
}

//void QComboBox.setMaxCount(int max);
KMETHOD QComboBox_setMaxCount(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int max = Int_to(int, sfp[1]);
		qp->setMaxCount(max);
	}
	RETURNvoid_();
}

//void QComboBox.setMaxVisibleItems(int maxItems);
KMETHOD QComboBox_setMaxVisibleItems(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int maxItems = Int_to(int, sfp[1]);
		qp->setMaxVisibleItems(maxItems);
	}
	RETURNvoid_();
}

//void QComboBox.setMinimumContentsLength(int characters);
KMETHOD QComboBox_setMinimumContentsLength(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int characters = Int_to(int, sfp[1]);
		qp->setMinimumContentsLength(characters);
	}
	RETURNvoid_();
}

//void QComboBox.setModel(QAbstractItemModel model);
KMETHOD QComboBox_setModel(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QAbstractItemModel*  model = RawPtr_to(QAbstractItemModel*, sfp[1]);
		qp->setModel(model);
	}
	RETURNvoid_();
}

//void QComboBox.setModelColumn(int visibleColumn);
KMETHOD QComboBox_setModelColumn(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int visibleColumn = Int_to(int, sfp[1]);
		qp->setModelColumn(visibleColumn);
	}
	RETURNvoid_();
}

//void QComboBox.setRootModelIndex(QModelIndex index);
KMETHOD QComboBox_setRootModelIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		qp->setRootModelIndex(index);
	}
	RETURNvoid_();
}

//void QComboBox.setSizeAdjustPolicy(int policy);
KMETHOD QComboBox_setSizeAdjustPolicy(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QComboBox::SizeAdjustPolicy policy = Int_to(QComboBox::SizeAdjustPolicy, sfp[1]);
		qp->setSizeAdjustPolicy(policy);
	}
	RETURNvoid_();
}

//void QComboBox.setValidator(QValidator validator);
KMETHOD QComboBox_setValidator(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		const QValidator*  validator = RawPtr_to(const QValidator*, sfp[1]);
		qp->setValidator(validator);
	}
	RETURNvoid_();
}

//void QComboBox.setView(QAbstractItemView itemView);
KMETHOD QComboBox_setView(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QAbstractItemView*  itemView = RawPtr_to(QAbstractItemView*, sfp[1]);
		qp->setView(itemView);
	}
	RETURNvoid_();
}

//@Virtual void QComboBox.showPopup();
KMETHOD QComboBox_showPopup(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		qp->showPopup();
	}
	RETURNvoid_();
}

//int QComboBox.getSizeAdjustPolicy();
KMETHOD QComboBox_getSizeAdjustPolicy(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QComboBox::SizeAdjustPolicy ret_v = qp->sizeAdjustPolicy();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QValidator QComboBox.getValidator();
KMETHOD QComboBox_getValidator(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		const QValidator* ret_v = qp->validator();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QValidator*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QAbstractItemView QComboBox.getView();
KMETHOD QComboBox_getView(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		QAbstractItemView* ret_v = qp->view();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractItemView*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QComboBox.clear();
KMETHOD QComboBox_clear(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		qp->clear();
	}
	RETURNvoid_();
}

//void QComboBox.clearEditText();
KMETHOD QComboBox_clearEditText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		qp->clearEditText();
	}
	RETURNvoid_();
}

//void QComboBox.setCurrentIndex(int index);
KMETHOD QComboBox_setCurrentIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		qp->setCurrentIndex(index);
	}
	RETURNvoid_();
}

//void QComboBox.setEditText(String text);
KMETHOD QComboBox_setEditText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QComboBox *  qp = RawPtr_to(QComboBox *, sfp[0]);
	if (qp) {
		const QString text = String_to(const QString, sfp[1]);
		qp->setEditText(text);
	}
	RETURNvoid_();
}


DummyQComboBox::DummyQComboBox()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	edit_text_changed_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("edit-text-changed", NULL));
}
DummyQComboBox::~DummyQComboBox()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQComboBox::setSelf(kRawPtr *ptr)
{
	DummyQComboBox::self = ptr;
	DummyQWidget::setSelf(ptr);
}

bool DummyQComboBox::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQWidget::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQComboBox::editTextChangedSlot(const QString text)
{
	if (edit_text_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QString, text);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, edit_text_changed_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQComboBox::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQComboBox::event_map->bigin();
	if ((itr = DummyQComboBox::event_map->find(str)) == DummyQComboBox::event_map->end()) {
		bool ret = false;
		ret = DummyQWidget::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQComboBox::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQComboBox::slot_map->bigin();
	if ((itr = DummyQComboBox::slot_map->find(str)) == DummyQComboBox::slot_map->end()) {
		bool ret = false;
		ret = DummyQWidget::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		edit_text_changed_func = (*slot_map)["edit-text-changed"];
		return true;
	}
}

kObject** DummyQComboBox::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQComboBox::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 2;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, edit_text_changed_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQWidget::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQComboBox::connection(QObject *o)
{
	QComboBox *p = dynamic_cast<QComboBox*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(editTextChanged(const QString)), this, SLOT(editTextChangedSlot(const QString)));
	}
	DummyQWidget::connection(o);
}

KQComboBox::KQComboBox(QWidget* parent) : QComboBox(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQComboBox();
	dummy->connection((QObject*)this);
}

KQComboBox::~KQComboBox()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QComboBox_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQComboBox *qp = RawPtr_to(KQComboBox *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QComboBox]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QComboBox]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QComboBox_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQComboBox *qp = RawPtr_to(KQComboBox *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QComboBox]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QComboBox]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QComboBox_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQComboBox *qp = (KQComboBox *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QComboBox*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QComboBox_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQComboBox *qp = (KQComboBox *)p->rawptr;
		KQComboBox *qp = static_cast<KQComboBox*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QComboBox_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQComboBox::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQComboBox::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QComboBox::event(event);
		return false;
	}
//	QComboBox::event(event);
	return true;
}

static knh_IntData_t QComboBoxConstInt[] = {
	{"NoInsert", QComboBox::NoInsert},
	{"InsertAtTop", QComboBox::InsertAtTop},
	{"InsertAtCurrent", QComboBox::InsertAtCurrent},
	{"InsertAtBottom", QComboBox::InsertAtBottom},
	{"InsertAfterCurrent", QComboBox::InsertAfterCurrent},
	{"InsertBeforeCurrent", QComboBox::InsertBeforeCurrent},
//	{"InsertAlphabetically", QComboBox::InsertAlphabetically},
	{"AdjustToContents", QComboBox::AdjustToContents},
	{"AdjustToContentsOnFirstShow", QComboBox::AdjustToContentsOnFirstShow},
	{"AdjustToMinimumContentsLength", QComboBox::AdjustToMinimumContentsLength},
	{"AdjustToMinimumContentsLengthWithIcon", QComboBox::AdjustToMinimumContentsLengthWithIcon},
	{NULL, 0}
};

DEFAPI(void) constQComboBox(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QComboBoxConstInt);
}


DEFAPI(void) defQComboBox(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QComboBox";
	cdef->free = QComboBox_free;
	cdef->reftrace = QComboBox_reftrace;
	cdef->compareTo = QComboBox_compareTo;
}


//QCommandLinkButton QCommandLinkButton.new(QWidget parent);
KMETHOD QCommandLinkButton_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QWidget*  parent = RawPtr_to(QWidget*, sfp[1]);
	KQCommandLinkButton *ret_v = new KQCommandLinkButton(parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QCommandLinkButton QCommandLinkButton.new(String text, QWidget parent);
KMETHOD QCommandLinkButton_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QString text = String_to(const QString, sfp[1]);
	QWidget*  parent = RawPtr_to(QWidget*, sfp[2]);
	KQCommandLinkButton *ret_v = new KQCommandLinkButton(text, parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QCommandLinkButton QCommandLinkButton.new(String text, String description, QWidget parent);
KMETHOD QCommandLinkButton_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QString text = String_to(const QString, sfp[1]);
	const QString description = String_to(const QString, sfp[2]);
	QWidget*  parent = RawPtr_to(QWidget*, sfp[3]);
	KQCommandLinkButton *ret_v = new KQCommandLinkButton(text, description, parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//String QCommandLinkButton.getDescription();
KMETHOD QCommandLinkButton_getDescription(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCommandLinkButton *  qp = RawPtr_to(QCommandLinkButton *, sfp[0]);
	if (qp) {
		QString ret_v = qp->description();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QCommandLinkButton.setDescription(String description);
KMETHOD QCommandLinkButton_setDescription(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCommandLinkButton *  qp = RawPtr_to(QCommandLinkButton *, sfp[0]);
	if (qp) {
		const QString description = String_to(const QString, sfp[1]);
		qp->setDescription(description);
	}
	RETURNvoid_();
}


DummyQCommandLinkButton::DummyQCommandLinkButton()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQCommandLinkButton::~DummyQCommandLinkButton()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQCommandLinkButton::setSelf(kRawPtr *ptr)
{
	DummyQCommandLinkButton::self = ptr;
	DummyQPushButton::setSelf(ptr);
}

bool DummyQCommandLinkButton::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQPushButton::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQCommandLinkButton::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCommandLinkButton::event_map->bigin();
	if ((itr = DummyQCommandLinkButton::event_map->find(str)) == DummyQCommandLinkButton::event_map->end()) {
		bool ret = false;
		ret = DummyQPushButton::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQCommandLinkButton::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCommandLinkButton::slot_map->bigin();
	if ((itr = DummyQCommandLinkButton::slot_map->find(str)) == DummyQCommandLinkButton::slot_map->end()) {
		bool ret = false;
		ret = DummyQPushButton::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQCommandLinkButton::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQCommandLinkButton::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQPushButton::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQCommandLinkButton::connection(QObject *o)
{
	QCommandLinkButton *p = dynamic_cast<QCommandLinkButton*>(o);
	if (p != NULL) {
	}
	DummyQPushButton::connection(o);
}

KQCommandLinkButton::KQCommandLinkButton(QWidget* parent) : QCommandLinkButton(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQCommandLinkButton();
	dummy->connection((QObject*)this);
}

KQCommandLinkButton::~KQCommandLinkButton()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QCommandLinkButton_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCommandLinkButton *qp = RawPtr_to(KQCommandLinkButton *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QCommandLinkButton]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCommandLinkButton]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QCommandLinkButton_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCommandLinkButton *qp = RawPtr_to(KQCommandLinkButton *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QCommandLinkButton]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCommandLinkButton]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QCommandLinkButton_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQCommandLinkButton *qp = (KQCommandLinkButton *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QCommandLinkButton*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QCommandLinkButton_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQCommandLinkButton *qp = (KQCommandLinkButton *)p->rawptr;
		KQCommandLinkButton *qp = static_cast<KQCommandLinkButton*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QCommandLinkButton_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQCommandLinkButton::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQCommandLinkButton::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QCommandLinkButton::event(event);
		return false;
	}
//	QCommandLinkButton::event(event);
	return true;
}



DEFAPI(void) defQCommandLinkButton(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QCommandLinkButton";
	cdef->free = QCommandLinkButton_free;
	cdef->reftrace = QCommandLinkButton_reftrace;
	cdef->compareTo = QCommandLinkButton_compareTo;
}


//@Virtual @Override void QCommonStyle.drawComplexControl(int cc, QStyleOptionComplex opt, QPainter p, QWidget widget);
KMETHOD QCommonStyle_drawComplexControl(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCommonStyle *  qp = RawPtr_to(QCommonStyle *, sfp[0]);
	if (qp) {
		QCommonStyle::ComplexControl cc = Int_to(QCommonStyle::ComplexControl, sfp[1]);
		const QStyleOptionComplex*  opt = RawPtr_to(const QStyleOptionComplex*, sfp[2]);
		QPainter*  p = RawPtr_to(QPainter*, sfp[3]);
		const QWidget*  widget = RawPtr_to(const QWidget*, sfp[4]);
		qp->drawComplexControl(cc, opt, p, widget);
	}
	RETURNvoid_();
}

//@Virtual @Override void QCommonStyle.drawControl(int element, QStyleOption opt, QPainter p, QWidget widget);
KMETHOD QCommonStyle_drawControl(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCommonStyle *  qp = RawPtr_to(QCommonStyle *, sfp[0]);
	if (qp) {
		QCommonStyle::ControlElement element = Int_to(QCommonStyle::ControlElement, sfp[1]);
		const QStyleOption*  opt = RawPtr_to(const QStyleOption*, sfp[2]);
		QPainter*  p = RawPtr_to(QPainter*, sfp[3]);
		const QWidget*  widget = RawPtr_to(const QWidget*, sfp[4]);
		qp->drawControl(element, opt, p, widget);
	}
	RETURNvoid_();
}

//@Virtual @Override void QCommonStyle.drawPrimitive(int pe, QStyleOption opt, QPainter p, QWidget widget);
KMETHOD QCommonStyle_drawPrimitive(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCommonStyle *  qp = RawPtr_to(QCommonStyle *, sfp[0]);
	if (qp) {
		QCommonStyle::PrimitiveElement pe = Int_to(QCommonStyle::PrimitiveElement, sfp[1]);
		const QStyleOption*  opt = RawPtr_to(const QStyleOption*, sfp[2]);
		QPainter*  p = RawPtr_to(QPainter*, sfp[3]);
		const QWidget*  widget = RawPtr_to(const QWidget*, sfp[4]);
		qp->drawPrimitive(pe, opt, p, widget);
	}
	RETURNvoid_();
}

//@Virtual @Override QPixmap QCommonStyle.generatedIconPixmap(int iconMode, QPixmap pixmap, QStyleOption opt);
KMETHOD QCommonStyle_generatedIconPixmap(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCommonStyle *  qp = RawPtr_to(QCommonStyle *, sfp[0]);
	if (qp) {
		QIcon::Mode iconMode = Int_to(QIcon::Mode, sfp[1]);
		const QPixmap  pixmap = *RawPtr_to(const QPixmap *, sfp[2]);
		const QStyleOption*  opt = RawPtr_to(const QStyleOption*, sfp[3]);
		QPixmap ret_v = qp->generatedIconPixmap(iconMode, pixmap, opt);
		QPixmap *ret_v_ = new QPixmap(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override int QCommonStyle.hitTestComplexControl(int cc, QStyleOptionComplex opt, QPoint pt, QWidget widget);
KMETHOD QCommonStyle_hitTestComplexControl(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCommonStyle *  qp = RawPtr_to(QCommonStyle *, sfp[0]);
	if (qp) {
		QCommonStyle::ComplexControl cc = Int_to(QCommonStyle::ComplexControl, sfp[1]);
		const QStyleOptionComplex*  opt = RawPtr_to(const QStyleOptionComplex*, sfp[2]);
		const QPoint  pt = *RawPtr_to(const QPoint *, sfp[3]);
		const QWidget*  widget = RawPtr_to(const QWidget*, sfp[4]);
		QCommonStyle::SubControl ret_v = qp->hitTestComplexControl(cc, opt, pt, widget);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual @Override int QCommonStyle.pixelMetric(int m, QStyleOption opt, QWidget widget);
KMETHOD QCommonStyle_pixelMetric(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCommonStyle *  qp = RawPtr_to(QCommonStyle *, sfp[0]);
	if (qp) {
		QCommonStyle::PixelMetric m = Int_to(QCommonStyle::PixelMetric, sfp[1]);
		const QStyleOption*  opt = RawPtr_to(const QStyleOption*, sfp[2]);
		const QWidget*  widget = RawPtr_to(const QWidget*, sfp[3]);
		int ret_v = qp->pixelMetric(m, opt, widget);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

/*
//@Virtual @Override void QCommonStyle.polish(QPalette pal);
KMETHOD QCommonStyle_polish(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCommonStyle *  qp = RawPtr_to(QCommonStyle *, sfp[0]);
	if (qp) {
		QPalette  pal = *RawPtr_to(QPalette *, sfp[1]);
		qp->polish(pal);
	}
	RETURNvoid_();
}
*/
/*
//@Virtual @Override void QCommonStyle.polish(QApplication app);
KMETHOD QCommonStyle_polish(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCommonStyle *  qp = RawPtr_to(QCommonStyle *, sfp[0]);
	if (qp) {
		QApplication*  app = RawPtr_to(QApplication*, sfp[1]);
		qp->polish(app);
	}
	RETURNvoid_();
}
*/
/*
//@Virtual @Override void QCommonStyle.polish(QWidget widget);
KMETHOD QCommonStyle_polish(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCommonStyle *  qp = RawPtr_to(QCommonStyle *, sfp[0]);
	if (qp) {
		QWidget*  widget = RawPtr_to(QWidget*, sfp[1]);
		qp->polish(widget);
	}
	RETURNvoid_();
}
*/
//@Virtual @Override QSize QCommonStyle.sizeFromContents(int ct, QStyleOption opt, QSize csz, QWidget widget);
KMETHOD QCommonStyle_sizeFromContents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCommonStyle *  qp = RawPtr_to(QCommonStyle *, sfp[0]);
	if (qp) {
		QCommonStyle::ContentsType ct = Int_to(QCommonStyle::ContentsType, sfp[1]);
		const QStyleOption*  opt = RawPtr_to(const QStyleOption*, sfp[2]);
		const QSize  csz = *RawPtr_to(const QSize *, sfp[3]);
		const QWidget*  widget = RawPtr_to(const QWidget*, sfp[4]);
		QSize ret_v = qp->sizeFromContents(ct, opt, csz, widget);
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override QPixmap QCommonStyle.standardPixmap(int sp, QStyleOption option, QWidget widget);
KMETHOD QCommonStyle_standardPixmap(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCommonStyle *  qp = RawPtr_to(QCommonStyle *, sfp[0]);
	if (qp) {
		QCommonStyle::StandardPixmap sp = Int_to(QCommonStyle::StandardPixmap, sfp[1]);
		const QStyleOption*  option = RawPtr_to(const QStyleOption*, sfp[2]);
		const QWidget*  widget = RawPtr_to(const QWidget*, sfp[3]);
		QPixmap ret_v = qp->standardPixmap(sp, option, widget);
		QPixmap *ret_v_ = new QPixmap(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override int QCommonStyle.styleHint(int sh, QStyleOption opt, QWidget widget, QStyleHintReturn hret);
KMETHOD QCommonStyle_styleHint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCommonStyle *  qp = RawPtr_to(QCommonStyle *, sfp[0]);
	if (qp) {
		QCommonStyle::StyleHint sh = Int_to(QCommonStyle::StyleHint, sfp[1]);
		const QStyleOption*  opt = RawPtr_to(const QStyleOption*, sfp[2]);
		const QWidget*  widget = RawPtr_to(const QWidget*, sfp[3]);
		QStyleHintReturn*  hret = RawPtr_to(QStyleHintReturn*, sfp[4]);
		int ret_v = qp->styleHint(sh, opt, widget, hret);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual @Override QRect QCommonStyle.subControlRect(int cc, QStyleOptionComplex opt, int sc, QWidget widget);
KMETHOD QCommonStyle_subControlRect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCommonStyle *  qp = RawPtr_to(QCommonStyle *, sfp[0]);
	if (qp) {
		QCommonStyle::ComplexControl cc = Int_to(QCommonStyle::ComplexControl, sfp[1]);
		const QStyleOptionComplex*  opt = RawPtr_to(const QStyleOptionComplex*, sfp[2]);
		QCommonStyle::SubControl sc = Int_to(QCommonStyle::SubControl, sfp[3]);
		const QWidget*  widget = RawPtr_to(const QWidget*, sfp[4]);
		QRect ret_v = qp->subControlRect(cc, opt, sc, widget);
		QRect *ret_v_ = new QRect(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override QRect QCommonStyle.subElementRect(int sr, QStyleOption opt, QWidget widget);
KMETHOD QCommonStyle_subElementRect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCommonStyle *  qp = RawPtr_to(QCommonStyle *, sfp[0]);
	if (qp) {
		QCommonStyle::SubElement sr = Int_to(QCommonStyle::SubElement, sfp[1]);
		const QStyleOption*  opt = RawPtr_to(const QStyleOption*, sfp[2]);
		const QWidget*  widget = RawPtr_to(const QWidget*, sfp[3]);
		QRect ret_v = qp->subElementRect(sr, opt, widget);
		QRect *ret_v_ = new QRect(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//@Virtual @Override void QCommonStyle.unpolish(QWidget widget);
KMETHOD QCommonStyle_unpolish(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCommonStyle *  qp = RawPtr_to(QCommonStyle *, sfp[0]);
	if (qp) {
		QWidget*  widget = RawPtr_to(QWidget*, sfp[1]);
		qp->unpolish(widget);
	}
	RETURNvoid_();
}
*/
/*
//@Virtual @Override void QCommonStyle.unpolish(QApplication application);
KMETHOD QCommonStyle_unpolish(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCommonStyle *  qp = RawPtr_to(QCommonStyle *, sfp[0]);
	if (qp) {
		QApplication*  application = RawPtr_to(QApplication*, sfp[1]);
		qp->unpolish(application);
	}
	RETURNvoid_();
}
*/
//QCommonStyle QCommonStyle.new();
KMETHOD QCommonStyle_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCommonStyle *ret_v = new KQCommonStyle();
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}


DummyQCommonStyle::DummyQCommonStyle()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQCommonStyle::~DummyQCommonStyle()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQCommonStyle::setSelf(kRawPtr *ptr)
{
	DummyQCommonStyle::self = ptr;
	DummyQStyle::setSelf(ptr);
}

bool DummyQCommonStyle::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQStyle::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQCommonStyle::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCommonStyle::event_map->bigin();
	if ((itr = DummyQCommonStyle::event_map->find(str)) == DummyQCommonStyle::event_map->end()) {
		bool ret = false;
		ret = DummyQStyle::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQCommonStyle::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCommonStyle::slot_map->bigin();
	if ((itr = DummyQCommonStyle::slot_map->find(str)) == DummyQCommonStyle::slot_map->end()) {
		bool ret = false;
		ret = DummyQStyle::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQCommonStyle::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQCommonStyle::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQStyle::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQCommonStyle::connection(QObject *o)
{
	QCommonStyle *p = dynamic_cast<QCommonStyle*>(o);
	if (p != NULL) {
	}
	DummyQStyle::connection(o);
}

KQCommonStyle::KQCommonStyle() : QCommonStyle()
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQCommonStyle();
	dummy->connection((QObject*)this);
}

KQCommonStyle::~KQCommonStyle()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QCommonStyle_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCommonStyle *qp = RawPtr_to(KQCommonStyle *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QCommonStyle]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCommonStyle]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QCommonStyle_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCommonStyle *qp = RawPtr_to(KQCommonStyle *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QCommonStyle]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCommonStyle]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QCommonStyle_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQCommonStyle *qp = (KQCommonStyle *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QCommonStyle*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QCommonStyle_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQCommonStyle *qp = (KQCommonStyle *)p->rawptr;
		KQCommonStyle *qp = static_cast<KQCommonStyle*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QCommonStyle_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQCommonStyle::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQCommonStyle::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QCommonStyle::event(event);
		return false;
	}
//	QCommonStyle::event(event);
	return true;
}



DEFAPI(void) defQCommonStyle(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QCommonStyle";
	cdef->free = QCommonStyle_free;
	cdef->reftrace = QCommonStyle_reftrace;
	cdef->compareTo = QCommonStyle_compareTo;
}


//QCompleter QCompleter.new(QObject parent);
KMETHOD QCompleter_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QObject*  parent = RawPtr_to(QObject*, sfp[1]);
	KQCompleter *ret_v = new KQCompleter(parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QCompleter QCompleter.new(QAbstractItemModel model, QObject parent);
KMETHOD QCompleter_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QAbstractItemModel*  model = RawPtr_to(QAbstractItemModel*, sfp[1]);
	QObject*  parent = RawPtr_to(QObject*, sfp[2]);
	KQCompleter *ret_v = new KQCompleter(model, parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//int QCompleter.getCaseSensitivity();
KMETHOD QCompleter_getCaseSensitivity(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		Qt::CaseSensitivity ret_v = qp->caseSensitivity();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QCompleter.getCompletionColumn();
KMETHOD QCompleter_getCompletionColumn(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		int ret_v = qp->completionColumn();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QCompleter.completionCount();
KMETHOD QCompleter_completionCount(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		int ret_v = qp->completionCount();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QCompleter.getCompletionMode();
KMETHOD QCompleter_getCompletionMode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		QCompleter::CompletionMode ret_v = qp->completionMode();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QAbstractItemModel QCompleter.completionModel();
KMETHOD QCompleter_completionModel(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		QAbstractItemModel* ret_v = qp->completionModel();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractItemModel*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QCompleter.getCompletionPrefix();
KMETHOD QCompleter_getCompletionPrefix(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		QString ret_v = qp->completionPrefix();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QCompleter.getCompletionRole();
KMETHOD QCompleter_getCompletionRole(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		int ret_v = qp->completionRole();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//String QCompleter.currentCompletion();
KMETHOD QCompleter_currentCompletion(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		QString ret_v = qp->currentCompletion();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//QModelIndex QCompleter.currentIndex();
KMETHOD QCompleter_currentIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		QModelIndex ret_v = qp->currentIndex();
		QModelIndex *ret_v_ = new QModelIndex(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QCompleter.getCurrentRow();
KMETHOD QCompleter_getCurrentRow(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		int ret_v = qp->currentRow();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QCompleter.getMaxVisibleItems();
KMETHOD QCompleter_getMaxVisibleItems(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		int ret_v = qp->maxVisibleItems();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QAbstractItemModel QCompleter.getModel();
KMETHOD QCompleter_getModel(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		QAbstractItemModel* ret_v = qp->model();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractItemModel*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QCompleter.getModelSorting();
KMETHOD QCompleter_getModelSorting(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		QCompleter::ModelSorting ret_v = qp->modelSorting();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//@Virtual String QCompleter.pathFromIndex(QModelIndex index);
KMETHOD QCompleter_pathFromIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		QString ret_v = qp->pathFromIndex(index);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//QAbstractItemView QCompleter.getPopup();
KMETHOD QCompleter_getPopup(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		QAbstractItemView* ret_v = qp->popup();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractItemView*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QCompleter.setCaseSensitivity(int caseSensitivity);
KMETHOD QCompleter_setCaseSensitivity(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		Qt::CaseSensitivity caseSensitivity = Int_to(Qt::CaseSensitivity, sfp[1]);
		qp->setCaseSensitivity(caseSensitivity);
	}
	RETURNvoid_();
}

//void QCompleter.setCompletionColumn(int column);
KMETHOD QCompleter_setCompletionColumn(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		int column = Int_to(int, sfp[1]);
		qp->setCompletionColumn(column);
	}
	RETURNvoid_();
}

//void QCompleter.setCompletionMode(int mode);
KMETHOD QCompleter_setCompletionMode(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		QCompleter::CompletionMode mode = Int_to(QCompleter::CompletionMode, sfp[1]);
		qp->setCompletionMode(mode);
	}
	RETURNvoid_();
}

//void QCompleter.setCompletionRole(int role);
KMETHOD QCompleter_setCompletionRole(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		int role = Int_to(int, sfp[1]);
		qp->setCompletionRole(role);
	}
	RETURNvoid_();
}

//boolean QCompleter.setCurrentRow(int row);
KMETHOD QCompleter_setCurrentRow(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		int row = Int_to(int, sfp[1]);
		bool ret_v = qp->setCurrentRow(row);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QCompleter.setMaxVisibleItems(int maxItems);
KMETHOD QCompleter_setMaxVisibleItems(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		int maxItems = Int_to(int, sfp[1]);
		qp->setMaxVisibleItems(maxItems);
	}
	RETURNvoid_();
}

//void QCompleter.setModel(QAbstractItemModel model);
KMETHOD QCompleter_setModel(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		QAbstractItemModel*  model = RawPtr_to(QAbstractItemModel*, sfp[1]);
		qp->setModel(model);
	}
	RETURNvoid_();
}

//void QCompleter.setModelSorting(int sorting);
KMETHOD QCompleter_setModelSorting(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		QCompleter::ModelSorting sorting = Int_to(QCompleter::ModelSorting, sfp[1]);
		qp->setModelSorting(sorting);
	}
	RETURNvoid_();
}

//void QCompleter.setPopup(QAbstractItemView popup);
KMETHOD QCompleter_setPopup(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		QAbstractItemView*  popup = RawPtr_to(QAbstractItemView*, sfp[1]);
		qp->setPopup(popup);
	}
	RETURNvoid_();
}

//void QCompleter.setWidget(QWidget widget);
KMETHOD QCompleter_setWidget(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		QWidget*  widget = RawPtr_to(QWidget*, sfp[1]);
		qp->setWidget(widget);
	}
	RETURNvoid_();
}

//QWidget QCompleter.getWidget();
KMETHOD QCompleter_getWidget(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		QWidget* ret_v = qp->widget();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QWidget*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QCompleter.getWrapAround();
KMETHOD QCompleter_getWrapAround(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		bool ret_v = qp->wrapAround();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QCompleter.complete(QRect rect);
KMETHOD QCompleter_complete(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		const QRect  rect = *RawPtr_to(const QRect *, sfp[1]);
		qp->complete(rect);
	}
	RETURNvoid_();
}

//void QCompleter.setCompletionPrefix(String prefix);
KMETHOD QCompleter_setCompletionPrefix(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		const QString prefix = String_to(const QString, sfp[1]);
		qp->setCompletionPrefix(prefix);
	}
	RETURNvoid_();
}

//void QCompleter.setWrapAround(boolean wrap);
KMETHOD QCompleter_setWrapAround(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCompleter *  qp = RawPtr_to(QCompleter *, sfp[0]);
	if (qp) {
		bool wrap = Boolean_to(bool, sfp[1]);
		qp->setWrapAround(wrap);
	}
	RETURNvoid_();
}


DummyQCompleter::DummyQCompleter()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQCompleter::~DummyQCompleter()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQCompleter::setSelf(kRawPtr *ptr)
{
	DummyQCompleter::self = ptr;
	DummyQObject::setSelf(ptr);
}

bool DummyQCompleter::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQObject::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQCompleter::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCompleter::event_map->bigin();
	if ((itr = DummyQCompleter::event_map->find(str)) == DummyQCompleter::event_map->end()) {
		bool ret = false;
		ret = DummyQObject::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQCompleter::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCompleter::slot_map->bigin();
	if ((itr = DummyQCompleter::slot_map->find(str)) == DummyQCompleter::slot_map->end()) {
		bool ret = false;
		ret = DummyQObject::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQCompleter::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQCompleter::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQObject::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQCompleter::connection(QObject *o)
{
	QCompleter *p = dynamic_cast<QCompleter*>(o);
	if (p != NULL) {
	}
	DummyQObject::connection(o);
}

KQCompleter::KQCompleter(QObject* parent) : QCompleter(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQCompleter();
	dummy->connection((QObject*)this);
}

KQCompleter::~KQCompleter()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QCompleter_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCompleter *qp = RawPtr_to(KQCompleter *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QCompleter]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCompleter]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QCompleter_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCompleter *qp = RawPtr_to(KQCompleter *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QCompleter]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCompleter]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QCompleter_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQCompleter *qp = (KQCompleter *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QCompleter*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QCompleter_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQCompleter *qp = (KQCompleter *)p->rawptr;
		KQCompleter *qp = static_cast<KQCompleter*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QCompleter_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQCompleter::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQCompleter::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QCompleter::event(event);
		return false;
	}
//	QCompleter::event(event);
	return true;
}

static knh_IntData_t QCompleterConstInt[] = {
	{"PopupCompletion", QCompleter::PopupCompletion},
	{"InlineCompletion", QCompleter::InlineCompletion},
	{"UnfilteredPopupCompletion", QCompleter::UnfilteredPopupCompletion},
	{"UnsortedModel", QCompleter::UnsortedModel},
	{"CaseSensitivelySortedModel", QCompleter::CaseSensitivelySortedModel},
	{"CaseInsensitivelySortedModel", QCompleter::CaseInsensitivelySortedModel},
	{NULL, 0}
};

DEFAPI(void) constQCompleter(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QCompleterConstInt);
}


DEFAPI(void) defQCompleter(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QCompleter";
	cdef->free = QCompleter_free;
	cdef->reftrace = QCompleter_reftrace;
	cdef->compareTo = QCompleter_compareTo;
}


//QConicalGradient QConicalGradient.new();
KMETHOD QConicalGradient_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQConicalGradient *ret_v = new KQConicalGradient();
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QConicalGradient QConicalGradient.new(QPointF center, float angle);
KMETHOD QConicalGradient_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QPointF  center = *RawPtr_to(const QPointF *, sfp[1]);
	qreal angle = Float_to(qreal, sfp[2]);
	KQConicalGradient *ret_v = new KQConicalGradient(center, angle);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QConicalGradient QConicalGradient.new(float cx, float cy, float angle);
KMETHOD QConicalGradient_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	qreal cx = Float_to(qreal, sfp[1]);
	qreal cy = Float_to(qreal, sfp[2]);
	qreal angle = Float_to(qreal, sfp[3]);
	KQConicalGradient *ret_v = new KQConicalGradient(cx, cy, angle);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//float QConicalGradient.getAngle();
KMETHOD QConicalGradient_getAngle(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QConicalGradient *  qp = RawPtr_to(QConicalGradient *, sfp[0]);
	if (qp) {
		qreal ret_v = qp->angle();
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//QPointF QConicalGradient.getCenter();
KMETHOD QConicalGradient_getCenter(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QConicalGradient *  qp = RawPtr_to(QConicalGradient *, sfp[0]);
	if (qp) {
		QPointF ret_v = qp->center();
		QPointF *ret_v_ = new QPointF(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QConicalGradient.setAngle(float angle);
KMETHOD QConicalGradient_setAngle(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QConicalGradient *  qp = RawPtr_to(QConicalGradient *, sfp[0]);
	if (qp) {
		qreal angle = Float_to(qreal, sfp[1]);
		qp->setAngle(angle);
	}
	RETURNvoid_();
}

//void QConicalGradient.setCenter(QPointF center);
KMETHOD QConicalGradient_setCenter(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QConicalGradient *  qp = RawPtr_to(QConicalGradient *, sfp[0]);
	if (qp) {
		const QPointF  center = *RawPtr_to(const QPointF *, sfp[1]);
		qp->setCenter(center);
	}
	RETURNvoid_();
}

/*
//void QConicalGradient.setCenter(float x, float y);
KMETHOD QConicalGradient_setCenter(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QConicalGradient *  qp = RawPtr_to(QConicalGradient *, sfp[0]);
	if (qp) {
		qreal x = Float_to(qreal, sfp[1]);
		qreal y = Float_to(qreal, sfp[2]);
		qp->setCenter(x, y);
	}
	RETURNvoid_();
}
*/

DummyQConicalGradient::DummyQConicalGradient()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQConicalGradient::~DummyQConicalGradient()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQConicalGradient::setSelf(kRawPtr *ptr)
{
	DummyQConicalGradient::self = ptr;
	DummyQGradient::setSelf(ptr);
}

bool DummyQConicalGradient::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQGradient::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQConicalGradient::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQConicalGradient::event_map->bigin();
	if ((itr = DummyQConicalGradient::event_map->find(str)) == DummyQConicalGradient::event_map->end()) {
		bool ret = false;
		ret = DummyQGradient::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQConicalGradient::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQConicalGradient::slot_map->bigin();
	if ((itr = DummyQConicalGradient::slot_map->find(str)) == DummyQConicalGradient::slot_map->end()) {
		bool ret = false;
		ret = DummyQGradient::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQConicalGradient::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQConicalGradient::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQGradient::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQConicalGradient::connection(QObject *o)
{
	QConicalGradient *p = dynamic_cast<QConicalGradient*>(o);
	if (p != NULL) {
	}
	DummyQGradient::connection(o);
}

KQConicalGradient::KQConicalGradient() : QConicalGradient()
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQConicalGradient();
}

KQConicalGradient::~KQConicalGradient()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QConicalGradient_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQConicalGradient *qp = RawPtr_to(KQConicalGradient *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QConicalGradient]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QConicalGradient]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QConicalGradient_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQConicalGradient *qp = RawPtr_to(KQConicalGradient *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QConicalGradient]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QConicalGradient]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QConicalGradient_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQConicalGradient *qp = (KQConicalGradient *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QConicalGradient*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QConicalGradient_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQConicalGradient *qp = (KQConicalGradient *)p->rawptr;
		KQConicalGradient *qp = static_cast<KQConicalGradient*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QConicalGradient_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQConicalGradient::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQConicalGradient(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QConicalGradient";
	cdef->free = QConicalGradient_free;
	cdef->reftrace = QConicalGradient_reftrace;
	cdef->compareTo = QConicalGradient_compareTo;
}


//QContextMenuEvent QContextMenuEvent.new(int reason, QPoint pos, QPoint globalPos, QtKeyboardModifiers modifiers);
KMETHOD QContextMenuEvent_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QContextMenuEvent::Reason reason = Int_to(QContextMenuEvent::Reason, sfp[1]);
	const QPoint  pos = *RawPtr_to(const QPoint *, sfp[2]);
	const QPoint  globalPos = *RawPtr_to(const QPoint *, sfp[3]);
	initFlag(modifiers, Qt::KeyboardModifiers, sfp[4]);
	KQContextMenuEvent *ret_v = new KQContextMenuEvent(reason, pos, globalPos, modifiers);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QContextMenuEvent QContextMenuEvent.new(int reason, QPoint pos, QPoint globalPos);
KMETHOD QContextMenuEvent_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QContextMenuEvent::Reason reason = Int_to(QContextMenuEvent::Reason, sfp[1]);
	const QPoint  pos = *RawPtr_to(const QPoint *, sfp[2]);
	const QPoint  globalPos = *RawPtr_to(const QPoint *, sfp[3]);
	KQContextMenuEvent *ret_v = new KQContextMenuEvent(reason, pos, globalPos);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QContextMenuEvent QContextMenuEvent.new(int reason, QPoint pos);
KMETHOD QContextMenuEvent_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QContextMenuEvent::Reason reason = Int_to(QContextMenuEvent::Reason, sfp[1]);
	const QPoint  pos = *RawPtr_to(const QPoint *, sfp[2]);
	KQContextMenuEvent *ret_v = new KQContextMenuEvent(reason, pos);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//QPoint QContextMenuEvent.globalPos();
KMETHOD QContextMenuEvent_globalPos(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QContextMenuEvent *  qp = RawPtr_to(QContextMenuEvent *, sfp[0]);
	if (qp) {
		const QPoint ret_v = qp->globalPos();
		QPoint *ret_v_ = new QPoint(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QContextMenuEvent.globalX();
KMETHOD QContextMenuEvent_globalX(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QContextMenuEvent *  qp = RawPtr_to(QContextMenuEvent *, sfp[0]);
	if (qp) {
		int ret_v = qp->globalX();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QContextMenuEvent.globalY();
KMETHOD QContextMenuEvent_globalY(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QContextMenuEvent *  qp = RawPtr_to(QContextMenuEvent *, sfp[0]);
	if (qp) {
		int ret_v = qp->globalY();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QPoint QContextMenuEvent.pos();
KMETHOD QContextMenuEvent_pos(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QContextMenuEvent *  qp = RawPtr_to(QContextMenuEvent *, sfp[0]);
	if (qp) {
		const QPoint ret_v = qp->pos();
		QPoint *ret_v_ = new QPoint(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QContextMenuEvent.reason();
KMETHOD QContextMenuEvent_reason(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QContextMenuEvent *  qp = RawPtr_to(QContextMenuEvent *, sfp[0]);
	if (qp) {
		QContextMenuEvent::Reason ret_v = qp->reason();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QContextMenuEvent.x();
KMETHOD QContextMenuEvent_x(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QContextMenuEvent *  qp = RawPtr_to(QContextMenuEvent *, sfp[0]);
	if (qp) {
		int ret_v = qp->x();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QContextMenuEvent.y();
KMETHOD QContextMenuEvent_y(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QContextMenuEvent *  qp = RawPtr_to(QContextMenuEvent *, sfp[0]);
	if (qp) {
		int ret_v = qp->y();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}


DummyQContextMenuEvent::DummyQContextMenuEvent()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQContextMenuEvent::~DummyQContextMenuEvent()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQContextMenuEvent::setSelf(kRawPtr *ptr)
{
	DummyQContextMenuEvent::self = ptr;
	DummyQInputEvent::setSelf(ptr);
}

bool DummyQContextMenuEvent::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQInputEvent::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQContextMenuEvent::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQContextMenuEvent::event_map->bigin();
	if ((itr = DummyQContextMenuEvent::event_map->find(str)) == DummyQContextMenuEvent::event_map->end()) {
		bool ret = false;
		ret = DummyQInputEvent::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQContextMenuEvent::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQContextMenuEvent::slot_map->bigin();
	if ((itr = DummyQContextMenuEvent::slot_map->find(str)) == DummyQContextMenuEvent::slot_map->end()) {
		bool ret = false;
		ret = DummyQInputEvent::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQContextMenuEvent::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQContextMenuEvent::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQInputEvent::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQContextMenuEvent::connection(QObject *o)
{
	QContextMenuEvent *p = dynamic_cast<QContextMenuEvent*>(o);
	if (p != NULL) {
	}
	DummyQInputEvent::connection(o);
}

KQContextMenuEvent::KQContextMenuEvent(QContextMenuEvent::Reason reason, const QPoint pos, const QPoint globalPos, Qt::KeyboardModifiers modifiers) : QContextMenuEvent(reason, pos, globalPos, modifiers)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQContextMenuEvent();
}

KQContextMenuEvent::~KQContextMenuEvent()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QContextMenuEvent_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQContextMenuEvent *qp = RawPtr_to(KQContextMenuEvent *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QContextMenuEvent]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QContextMenuEvent]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QContextMenuEvent_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQContextMenuEvent *qp = RawPtr_to(KQContextMenuEvent *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QContextMenuEvent]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QContextMenuEvent]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QContextMenuEvent_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQContextMenuEvent *qp = (KQContextMenuEvent *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QContextMenuEvent*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QContextMenuEvent_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQContextMenuEvent *qp = (KQContextMenuEvent *)p->rawptr;
		KQContextMenuEvent *qp = static_cast<KQContextMenuEvent*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QContextMenuEvent_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQContextMenuEvent::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

static knh_IntData_t QContextMenuEventConstInt[] = {
	{"Mouse", QContextMenuEvent::Mouse},
	{"Keyboard", QContextMenuEvent::Keyboard},
	{"Other", QContextMenuEvent::Other},
	{NULL, 0}
};

DEFAPI(void) constQContextMenuEvent(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QContextMenuEventConstInt);
}


DEFAPI(void) defQContextMenuEvent(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QContextMenuEvent";
	cdef->free = QContextMenuEvent_free;
	cdef->reftrace = QContextMenuEvent_reftrace;
	cdef->compareTo = QContextMenuEvent_compareTo;
}


//QCoreApplication QCoreApplication.new(int argc, String argv);
KMETHOD QCoreApplication_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	int argc = Int_to(int, sfp[1]);
	char**  argv = RawPtr_to(char**, sfp[2]);
	KQCoreApplication *ret_v = new KQCoreApplication(argc, argv);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

//boolean QCoreApplication.filterEvent(void message, long result);
KMETHOD QCoreApplication_filterEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCoreApplication *  qp = RawPtr_to(QCoreApplication *, sfp[0]);
	if (qp) {
		void*  message = RawPtr_to(void*, sfp[1]);
		long*  result = RawPtr_to(long*, sfp[2]);
		bool ret_v = qp->filterEvent(message, result);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual boolean QCoreApplication.notify(QObject receiver, QEvent event);
KMETHOD QCoreApplication_notify(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCoreApplication *  qp = RawPtr_to(QCoreApplication *, sfp[0]);
	if (qp) {
		QObject*  receiver = RawPtr_to(QObject*, sfp[1]);
		QEvent*  event = RawPtr_to(QEvent*, sfp[2]);
		bool ret_v = qp->notify(receiver, event);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QCoreApplication.addLibraryPath(String path);
KMETHOD QCoreApplication_addLibraryPath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString path = String_to(const QString, sfp[1]);
		QCoreApplication::addLibraryPath(path);
	}
	RETURNvoid_();
}

//String QCoreApplication.applicationDirPath();
KMETHOD QCoreApplication_applicationDirPath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QString ret_v = QCoreApplication::applicationDirPath();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QCoreApplication.applicationFilePath();
KMETHOD QCoreApplication_applicationFilePath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QString ret_v = QCoreApplication::applicationFilePath();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QCoreApplication.getApplicationName();
KMETHOD QCoreApplication_getApplicationName(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QString ret_v = QCoreApplication::applicationName();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QCoreApplication.applicationPid();
KMETHOD QCoreApplication_applicationPid(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		qint64 ret_v = QCoreApplication::applicationPid();
		qint64 *ret_v_ = new qint64(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QCoreApplication.getApplicationVersion();
KMETHOD QCoreApplication_getApplicationVersion(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QString ret_v = QCoreApplication::applicationVersion();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QCoreApplication.closingDown();
KMETHOD QCoreApplication_closingDown(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		bool ret_v = QCoreApplication::closingDown();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//int QCoreApplication.exec();
KMETHOD QCoreApplication_exec(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int ret_v = QCoreApplication::exec();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QCoreApplication.exit(int returnCode);
KMETHOD QCoreApplication_exit(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int returnCode = Int_to(int, sfp[1]);
		QCoreApplication::exit(returnCode);
	}
	RETURNvoid_();
}

//void QCoreApplication.flush();
KMETHOD QCoreApplication_flush(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QCoreApplication::flush();
	}
	RETURNvoid_();
}

//boolean QCoreApplication.hasPendingEvents();
KMETHOD QCoreApplication_hasPendingEvents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		bool ret_v = QCoreApplication::hasPendingEvents();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QCoreApplication.installTranslator(QTranslator translationFile);
KMETHOD QCoreApplication_installTranslator(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QTranslator*  translationFile = RawPtr_to(QTranslator*, sfp[1]);
		QCoreApplication::installTranslator(translationFile);
	}
	RETURNvoid_();
}

//QCoreApplication QCoreApplication.instance();
KMETHOD QCoreApplication_instance(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QCoreApplication* ret_v = QCoreApplication::instance();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QCoreApplication*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QCoreApplication.getOrganizationDomain();
KMETHOD QCoreApplication_getOrganizationDomain(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QString ret_v = QCoreApplication::organizationDomain();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QCoreApplication.getOrganizationName();
KMETHOD QCoreApplication_getOrganizationName(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QString ret_v = QCoreApplication::organizationName();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QCoreApplication.postEvent(QObject receiver, QEvent event);
KMETHOD QCoreApplication_postEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QObject*  receiver = RawPtr_to(QObject*, sfp[1]);
		QEvent*  event = RawPtr_to(QEvent*, sfp[2]);
		QCoreApplication::postEvent(receiver, event);
	}
	RETURNvoid_();
}

/*
//void QCoreApplication.postEvent(QObject receiver, QEvent event, int priority);
KMETHOD QCoreApplication_postEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QObject*  receiver = RawPtr_to(QObject*, sfp[1]);
		QEvent*  event = RawPtr_to(QEvent*, sfp[2]);
		int priority = Int_to(int, sfp[3]);
		QCoreApplication::postEvent(receiver, event, priority);
	}
	RETURNvoid_();
}
*/
//void QCoreApplication.processEvents(int flags);
KMETHOD QCoreApplication_processEvents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QEventLoop::ProcessEventsFlags flags = Int_to(QEventLoop::ProcessEventsFlags, sfp[1]);
		QCoreApplication::processEvents(flags);
	}
	RETURNvoid_();
}

/*
//void QCoreApplication.processEvents(int flags, int maxtime);
KMETHOD QCoreApplication_processEvents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QEventLoop::ProcessEventsFlags flags = Int_to(QEventLoop::ProcessEventsFlags, sfp[1]);
		int maxtime = Int_to(int, sfp[2]);
		QCoreApplication::processEvents(flags, maxtime);
	}
	RETURNvoid_();
}
*/
//void QCoreApplication.removeLibraryPath(String path);
KMETHOD QCoreApplication_removeLibraryPath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString path = String_to(const QString, sfp[1]);
		QCoreApplication::removeLibraryPath(path);
	}
	RETURNvoid_();
}

//void QCoreApplication.removePostedEvents(QObject receiver);
KMETHOD QCoreApplication_removePostedEvents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QObject*  receiver = RawPtr_to(QObject*, sfp[1]);
		QCoreApplication::removePostedEvents(receiver);
	}
	RETURNvoid_();
}

/*
//void QCoreApplication.removePostedEvents(QObject receiver, int eventType);
KMETHOD QCoreApplication_removePostedEvents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QObject*  receiver = RawPtr_to(QObject*, sfp[1]);
		int eventType = Int_to(int, sfp[2]);
		QCoreApplication::removePostedEvents(receiver, eventType);
	}
	RETURNvoid_();
}
*/
//void QCoreApplication.removeTranslator(QTranslator translationFile);
KMETHOD QCoreApplication_removeTranslator(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QTranslator*  translationFile = RawPtr_to(QTranslator*, sfp[1]);
		QCoreApplication::removeTranslator(translationFile);
	}
	RETURNvoid_();
}

//boolean QCoreApplication.sendEvent(QObject receiver, QEvent event);
KMETHOD QCoreApplication_sendEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QObject*  receiver = RawPtr_to(QObject*, sfp[1]);
		QEvent*  event = RawPtr_to(QEvent*, sfp[2]);
		bool ret_v = QCoreApplication::sendEvent(receiver, event);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QCoreApplication.sendPostedEvents(QObject receiver, int event_type);
KMETHOD QCoreApplication_sendPostedEvents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QObject*  receiver = RawPtr_to(QObject*, sfp[1]);
		int event_type = Int_to(int, sfp[2]);
		QCoreApplication::sendPostedEvents(receiver, event_type);
	}
	RETURNvoid_();
}

/*
//void QCoreApplication.sendPostedEvents();
KMETHOD QCoreApplication_sendPostedEvents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QCoreApplication::sendPostedEvents();
	}
	RETURNvoid_();
}
*/
//void QCoreApplication.setApplicationName(String application);
KMETHOD QCoreApplication_setApplicationName(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString application = String_to(const QString, sfp[1]);
		QCoreApplication::setApplicationName(application);
	}
	RETURNvoid_();
}

//void QCoreApplication.setApplicationVersion(String version);
KMETHOD QCoreApplication_setApplicationVersion(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString version = String_to(const QString, sfp[1]);
		QCoreApplication::setApplicationVersion(version);
	}
	RETURNvoid_();
}

//void QCoreApplication.setAttribute(int attribute, boolean on);
KMETHOD QCoreApplication_setAttribute(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		Qt::ApplicationAttribute attribute = Int_to(Qt::ApplicationAttribute, sfp[1]);
		bool on = Boolean_to(bool, sfp[2]);
		QCoreApplication::setAttribute(attribute, on);
	}
	RETURNvoid_();
}

//void QCoreApplication.setOrganizationDomain(String orgDomain);
KMETHOD QCoreApplication_setOrganizationDomain(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString orgDomain = String_to(const QString, sfp[1]);
		QCoreApplication::setOrganizationDomain(orgDomain);
	}
	RETURNvoid_();
}

//void QCoreApplication.setOrganizationName(String orgName);
KMETHOD QCoreApplication_setOrganizationName(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString orgName = String_to(const QString, sfp[1]);
		QCoreApplication::setOrganizationName(orgName);
	}
	RETURNvoid_();
}

//boolean QCoreApplication.startingUp();
KMETHOD QCoreApplication_startingUp(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		bool ret_v = QCoreApplication::startingUp();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QCoreApplication.testAttribute(int attribute);
KMETHOD QCoreApplication_testAttribute(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		Qt::ApplicationAttribute attribute = Int_to(Qt::ApplicationAttribute, sfp[1]);
		bool ret_v = QCoreApplication::testAttribute(attribute);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//String QCoreApplication.translate(String context, String sourceText, String disambiguation, int encoding, int n);
KMETHOD QCoreApplication_translate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const char*  context = RawPtr_to(const char*, sfp[1]);
		const char*  sourceText = RawPtr_to(const char*, sfp[2]);
		const char*  disambiguation = RawPtr_to(const char*, sfp[3]);
		QCoreApplication::Encoding encoding = Int_to(QCoreApplication::Encoding, sfp[4]);
		int n = Int_to(int, sfp[5]);
		QString ret_v = QCoreApplication::translate(context, sourceText, disambiguation, encoding, n);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//String QCoreApplication.translate(String context, String sourceText, String disambiguation, int encoding);
KMETHOD QCoreApplication_translate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const char*  context = RawPtr_to(const char*, sfp[1]);
		const char*  sourceText = RawPtr_to(const char*, sfp[2]);
		const char*  disambiguation = RawPtr_to(const char*, sfp[3]);
		QCoreApplication::Encoding encoding = Int_to(QCoreApplication::Encoding, sfp[4]);
		QString ret_v = QCoreApplication::translate(context, sourceText, disambiguation, encoding);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//void QCoreApplication.quit();
KMETHOD QCoreApplication_quit(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCoreApplication *  qp = RawPtr_to(QCoreApplication *, sfp[0]);
	if (qp) {
		qp->quit();
	}
	RETURNvoid_();
}


DummyQCoreApplication::DummyQCoreApplication()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	about_to_quit_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("about-to-quit", NULL));
}
DummyQCoreApplication::~DummyQCoreApplication()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQCoreApplication::setSelf(kRawPtr *ptr)
{
	DummyQCoreApplication::self = ptr;
	DummyQObject::setSelf(ptr);
}

bool DummyQCoreApplication::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQObject::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQCoreApplication::aboutToQuitSlot()
{
	if (about_to_quit_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, about_to_quit_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQCoreApplication::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCoreApplication::event_map->bigin();
	if ((itr = DummyQCoreApplication::event_map->find(str)) == DummyQCoreApplication::event_map->end()) {
		bool ret = false;
		ret = DummyQObject::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQCoreApplication::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCoreApplication::slot_map->bigin();
	if ((itr = DummyQCoreApplication::slot_map->find(str)) == DummyQCoreApplication::slot_map->end()) {
		bool ret = false;
		ret = DummyQObject::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		about_to_quit_func = (*slot_map)["about-to-quit"];
		return true;
	}
}

kObject** DummyQCoreApplication::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQCoreApplication::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 2;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, about_to_quit_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQObject::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQCoreApplication::connection(QObject *o)
{
	QCoreApplication *p = dynamic_cast<QCoreApplication*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(aboutToQuit()), this, SLOT(aboutToQuitSlot()));
	}
	DummyQObject::connection(o);
}

KQCoreApplication::KQCoreApplication(int argc, char** argv) : QCoreApplication(argc, argv)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQCoreApplication();
	dummy->connection((QObject*)this);
}

KQCoreApplication::~KQCoreApplication()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QCoreApplication_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCoreApplication *qp = RawPtr_to(KQCoreApplication *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QCoreApplication]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCoreApplication]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QCoreApplication_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCoreApplication *qp = RawPtr_to(KQCoreApplication *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QCoreApplication]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCoreApplication]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QCoreApplication_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQCoreApplication *qp = (KQCoreApplication *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QCoreApplication*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QCoreApplication_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQCoreApplication *qp = (KQCoreApplication *)p->rawptr;
		KQCoreApplication *qp = static_cast<KQCoreApplication*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QCoreApplication_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQCoreApplication::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQCoreApplication::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QCoreApplication::event(event);
		return false;
	}
//	QCoreApplication::event(event);
	return true;
}

static knh_IntData_t QCoreApplicationConstInt[] = {
	{"CodecForTr", QCoreApplication::CodecForTr},
	{"UnicodeUTF8", QCoreApplication::UnicodeUTF8},
	{"DefaultCodec", QCoreApplication::DefaultCodec},
	{NULL, 0}
};

DEFAPI(void) constQCoreApplication(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QCoreApplicationConstInt);
}


DEFAPI(void) defQCoreApplication(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QCoreApplication";
	cdef->free = QCoreApplication_free;
	cdef->reftrace = QCoreApplication_reftrace;
	cdef->compareTo = QCoreApplication_compareTo;
}


//QCryptographicHash QCryptographicHash.new(int method);
KMETHOD QCryptographicHash_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCryptographicHash::Algorithm method = Int_to(QCryptographicHash::Algorithm, sfp[1]);
	KQCryptographicHash *ret_v = new KQCryptographicHash(method);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

//void QCryptographicHash.addData(String data, int length);
KMETHOD QCryptographicHash_addData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCryptographicHash *  qp = RawPtr_to(QCryptographicHash *, sfp[0]);
	if (qp) {
		const char*  data = RawPtr_to(const char*, sfp[1]);
		int length = Int_to(int, sfp[2]);
		qp->addData(data, length);
	}
	RETURNvoid_();
}

/*
//void QCryptographicHash.addData(QByteArray data);
KMETHOD QCryptographicHash_addData(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCryptographicHash *  qp = RawPtr_to(QCryptographicHash *, sfp[0]);
	if (qp) {
		const QByteArray  data = *RawPtr_to(const QByteArray *, sfp[1]);
		qp->addData(data);
	}
	RETURNvoid_();
}
*/
//void QCryptographicHash.reset();
KMETHOD QCryptographicHash_reset(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCryptographicHash *  qp = RawPtr_to(QCryptographicHash *, sfp[0]);
	if (qp) {
		qp->reset();
	}
	RETURNvoid_();
}

//QByteArray QCryptographicHash.result();
KMETHOD QCryptographicHash_result(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCryptographicHash *  qp = RawPtr_to(QCryptographicHash *, sfp[0]);
	if (qp) {
		QByteArray ret_v = qp->result();
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QByteArray QCryptographicHash.hash(QByteArray data, int method);
KMETHOD QCryptographicHash_hash(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QByteArray  data = *RawPtr_to(const QByteArray *, sfp[1]);
		QCryptographicHash::Algorithm method = Int_to(QCryptographicHash::Algorithm, sfp[2]);
		QByteArray ret_v = QCryptographicHash::hash(data, method);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//Array<String> QCryptographicHash.parents();
KMETHOD QCryptographicHash_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCryptographicHash *qp = RawPtr_to(QCryptographicHash*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQCryptographicHash::DummyQCryptographicHash()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQCryptographicHash::~DummyQCryptographicHash()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQCryptographicHash::setSelf(kRawPtr *ptr)
{
	DummyQCryptographicHash::self = ptr;
}

bool DummyQCryptographicHash::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQCryptographicHash::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCryptographicHash::event_map->bigin();
	if ((itr = DummyQCryptographicHash::event_map->find(str)) == DummyQCryptographicHash::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQCryptographicHash::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCryptographicHash::slot_map->bigin();
	if ((itr = DummyQCryptographicHash::slot_map->find(str)) == DummyQCryptographicHash::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQCryptographicHash::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQCryptographicHash::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQCryptographicHash::connection(QObject *o)
{
	QCryptographicHash *p = dynamic_cast<QCryptographicHash*>(o);
	if (p != NULL) {
	}
}

KQCryptographicHash::KQCryptographicHash(QCryptographicHash::Algorithm method) : QCryptographicHash(method)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQCryptographicHash();
}

KQCryptographicHash::~KQCryptographicHash()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QCryptographicHash_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCryptographicHash *qp = RawPtr_to(KQCryptographicHash *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QCryptographicHash]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCryptographicHash]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QCryptographicHash_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCryptographicHash *qp = RawPtr_to(KQCryptographicHash *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QCryptographicHash]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCryptographicHash]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QCryptographicHash_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQCryptographicHash *qp = (KQCryptographicHash *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QCryptographicHash*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QCryptographicHash_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQCryptographicHash *qp = (KQCryptographicHash *)p->rawptr;
		KQCryptographicHash *qp = static_cast<KQCryptographicHash*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QCryptographicHash_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQCryptographicHash::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

static knh_IntData_t QCryptographicHashConstInt[] = {
	{"Md4", QCryptographicHash::Md4},
	{"Md5", QCryptographicHash::Md5},
	{"Sha1", QCryptographicHash::Sha1},
	{NULL, 0}
};

DEFAPI(void) constQCryptographicHash(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QCryptographicHashConstInt);
}


DEFAPI(void) defQCryptographicHash(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QCryptographicHash";
	cdef->free = QCryptographicHash_free;
	cdef->reftrace = QCryptographicHash_reftrace;
	cdef->compareTo = QCryptographicHash_compareTo;
}


//QCursor QCursor.new();
KMETHOD QCursor_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCursor *ret_v = new KQCursor();
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QCursor QCursor.new(int shape);
KMETHOD QCursor_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	Qt::CursorShape shape = Int_to(Qt::CursorShape, sfp[1]);
	KQCursor *ret_v = new KQCursor(shape);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QCursor QCursor.new(QBitmap bitmap, QBitmap mask, int hotX, int hotY);
KMETHOD QCursor_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QBitmap  bitmap = *RawPtr_to(const QBitmap *, sfp[1]);
	const QBitmap  mask = *RawPtr_to(const QBitmap *, sfp[2]);
	int hotX = Int_to(int, sfp[3]);
	int hotY = Int_to(int, sfp[4]);
	KQCursor *ret_v = new KQCursor(bitmap, mask, hotX, hotY);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QCursor QCursor.new(QPixmap pixmap, int hotX, int hotY);
KMETHOD QCursor_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QPixmap  pixmap = *RawPtr_to(const QPixmap *, sfp[1]);
	int hotX = Int_to(int, sfp[2]);
	int hotY = Int_to(int, sfp[3]);
	KQCursor *ret_v = new KQCursor(pixmap, hotX, hotY);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QCursor QCursor.new(QCursor c);
KMETHOD QCursor_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QCursor  c = *RawPtr_to(const QCursor *, sfp[1]);
	KQCursor *ret_v = new KQCursor(c);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QCursor QCursor.new(HCURSOR cursor);
KMETHOD QCursor_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	HCURSOR  cursor = *RawPtr_to(HCURSOR *, sfp[1]);
	KQCursor *ret_v = new KQCursor(cursor);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//QBitmap QCursor.bitmap();
KMETHOD QCursor_bitmap(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCursor *  qp = RawPtr_to(QCursor *, sfp[0]);
	if (qp) {
		const QBitmap* ret_v = qp->bitmap();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QBitmap*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QPoint QCursor.hotSpot();
KMETHOD QCursor_hotSpot(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCursor *  qp = RawPtr_to(QCursor *, sfp[0]);
	if (qp) {
		QPoint ret_v = qp->hotSpot();
		QPoint *ret_v_ = new QPoint(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QBitmap QCursor.mask();
KMETHOD QCursor_mask(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCursor *  qp = RawPtr_to(QCursor *, sfp[0]);
	if (qp) {
		const QBitmap* ret_v = qp->mask();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QBitmap*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QPixmap QCursor.pixmap();
KMETHOD QCursor_pixmap(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCursor *  qp = RawPtr_to(QCursor *, sfp[0]);
	if (qp) {
		QPixmap ret_v = qp->pixmap();
		QPixmap *ret_v_ = new QPixmap(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QCursor.setShape(int shape);
KMETHOD QCursor_setShape(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCursor *  qp = RawPtr_to(QCursor *, sfp[0]);
	if (qp) {
		Qt::CursorShape shape = Int_to(Qt::CursorShape, sfp[1]);
		qp->setShape(shape);
	}
	RETURNvoid_();
}

//int QCursor.getShape();
KMETHOD QCursor_getShape(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCursor *  qp = RawPtr_to(QCursor *, sfp[0]);
	if (qp) {
		Qt::CursorShape ret_v = qp->shape();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QPoint QCursor.getPos();
KMETHOD QCursor_getPos(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QPoint ret_v = QCursor::pos();
		QPoint *ret_v_ = new QPoint(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QCursor.setPos(int x, int y);
KMETHOD QCursor_setPos(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int x = Int_to(int, sfp[1]);
		int y = Int_to(int, sfp[2]);
		QCursor::setPos(x, y);
	}
	RETURNvoid_();
}

/*
//void QCursor.setPos(QPoint p);
KMETHOD QCursor_setPos(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QPoint  p = *RawPtr_to(const QPoint *, sfp[1]);
		QCursor::setPos(p);
	}
	RETURNvoid_();
}
*/
//Array<String> QCursor.parents();
KMETHOD QCursor_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QCursor *qp = RawPtr_to(QCursor*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQCursor::DummyQCursor()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQCursor::~DummyQCursor()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQCursor::setSelf(kRawPtr *ptr)
{
	DummyQCursor::self = ptr;
}

bool DummyQCursor::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQCursor::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCursor::event_map->bigin();
	if ((itr = DummyQCursor::event_map->find(str)) == DummyQCursor::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQCursor::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQCursor::slot_map->bigin();
	if ((itr = DummyQCursor::slot_map->find(str)) == DummyQCursor::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQCursor::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQCursor::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQCursor::connection(QObject *o)
{
	QCursor *p = dynamic_cast<QCursor*>(o);
	if (p != NULL) {
	}
}

KQCursor::KQCursor() : QCursor()
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQCursor();
}

KQCursor::~KQCursor()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QCursor_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCursor *qp = RawPtr_to(KQCursor *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QCursor]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCursor]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QCursor_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQCursor *qp = RawPtr_to(KQCursor *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QCursor]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QCursor]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QCursor_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQCursor *qp = (KQCursor *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QCursor*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QCursor_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQCursor *qp = (KQCursor *)p->rawptr;
		KQCursor *qp = static_cast<KQCursor*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QCursor_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQCursor::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQCursor(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QCursor";
	cdef->free = QCursor_free;
	cdef->reftrace = QCursor_reftrace;
	cdef->compareTo = QCursor_compareTo;
}


//QDataWidgetMapper QDataWidgetMapper.new(QObject parent);
KMETHOD QDataWidgetMapper_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QObject*  parent = RawPtr_to(QObject*, sfp[1]);
	KQDataWidgetMapper *ret_v = new KQDataWidgetMapper(parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

//void QDataWidgetMapper.addMapping(QWidget widget, int section);
KMETHOD QDataWidgetMapper_addMapping(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		QWidget*  widget = RawPtr_to(QWidget*, sfp[1]);
		int section = Int_to(int, sfp[2]);
		qp->addMapping(widget, section);
	}
	RETURNvoid_();
}

/*
//void QDataWidgetMapper.addMapping(QWidget widget, int section, QByteArray propertyName);
KMETHOD QDataWidgetMapper_addMapping(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		QWidget*  widget = RawPtr_to(QWidget*, sfp[1]);
		int section = Int_to(int, sfp[2]);
		const QByteArray  propertyName = *RawPtr_to(const QByteArray *, sfp[3]);
		qp->addMapping(widget, section, propertyName);
	}
	RETURNvoid_();
}
*/
//void QDataWidgetMapper.clearMapping();
KMETHOD QDataWidgetMapper_clearMapping(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		qp->clearMapping();
	}
	RETURNvoid_();
}

//int QDataWidgetMapper.getCurrentIndex();
KMETHOD QDataWidgetMapper_getCurrentIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		int ret_v = qp->currentIndex();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QAbstractItemDelegate QDataWidgetMapper.getItemDelegate();
KMETHOD QDataWidgetMapper_getItemDelegate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		QAbstractItemDelegate* ret_v = qp->itemDelegate();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractItemDelegate*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QByteArray QDataWidgetMapper.mappedPropertyName(QWidget widget);
KMETHOD QDataWidgetMapper_mappedPropertyName(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		QWidget*  widget = RawPtr_to(QWidget*, sfp[1]);
		QByteArray ret_v = qp->mappedPropertyName(widget);
		QByteArray *ret_v_ = new QByteArray(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QDataWidgetMapper.mappedSection(QWidget widget);
KMETHOD QDataWidgetMapper_mappedSection(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		QWidget*  widget = RawPtr_to(QWidget*, sfp[1]);
		int ret_v = qp->mappedSection(widget);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QWidget QDataWidgetMapper.mappedWidgetAt(int section);
KMETHOD QDataWidgetMapper_mappedWidgetAt(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		int section = Int_to(int, sfp[1]);
		QWidget* ret_v = qp->mappedWidgetAt(section);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QWidget*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QAbstractItemModel QDataWidgetMapper.getModel();
KMETHOD QDataWidgetMapper_getModel(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		QAbstractItemModel* ret_v = qp->model();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QAbstractItemModel*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QDataWidgetMapper.getOrientation();
KMETHOD QDataWidgetMapper_getOrientation(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		Qt::Orientation ret_v = qp->orientation();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QDataWidgetMapper.removeMapping(QWidget widget);
KMETHOD QDataWidgetMapper_removeMapping(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		QWidget*  widget = RawPtr_to(QWidget*, sfp[1]);
		qp->removeMapping(widget);
	}
	RETURNvoid_();
}

//QModelIndex QDataWidgetMapper.getRootIndex();
KMETHOD QDataWidgetMapper_getRootIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		QModelIndex ret_v = qp->rootIndex();
		QModelIndex *ret_v_ = new QModelIndex(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QDataWidgetMapper.setItemDelegate(QAbstractItemDelegate delegate);
KMETHOD QDataWidgetMapper_setItemDelegate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		QAbstractItemDelegate*  delegate = RawPtr_to(QAbstractItemDelegate*, sfp[1]);
		qp->setItemDelegate(delegate);
	}
	RETURNvoid_();
}

//void QDataWidgetMapper.setModel(QAbstractItemModel model);
KMETHOD QDataWidgetMapper_setModel(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		QAbstractItemModel*  model = RawPtr_to(QAbstractItemModel*, sfp[1]);
		qp->setModel(model);
	}
	RETURNvoid_();
}

//void QDataWidgetMapper.setOrientation(int aOrientation);
KMETHOD QDataWidgetMapper_setOrientation(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		Qt::Orientation aOrientation = Int_to(Qt::Orientation, sfp[1]);
		qp->setOrientation(aOrientation);
	}
	RETURNvoid_();
}

//void QDataWidgetMapper.setRootIndex(QModelIndex index);
KMETHOD QDataWidgetMapper_setRootIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		qp->setRootIndex(index);
	}
	RETURNvoid_();
}

//void QDataWidgetMapper.setSubmitPolicy(int policy);
KMETHOD QDataWidgetMapper_setSubmitPolicy(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		QDataWidgetMapper::SubmitPolicy policy = Int_to(QDataWidgetMapper::SubmitPolicy, sfp[1]);
		qp->setSubmitPolicy(policy);
	}
	RETURNvoid_();
}

//int QDataWidgetMapper.getSubmitPolicy();
KMETHOD QDataWidgetMapper_getSubmitPolicy(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		QDataWidgetMapper::SubmitPolicy ret_v = qp->submitPolicy();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QDataWidgetMapper.revert();
KMETHOD QDataWidgetMapper_revert(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		qp->revert();
	}
	RETURNvoid_();
}

//@Virtual void QDataWidgetMapper.setCurrentIndex(int index);
KMETHOD QDataWidgetMapper_setCurrentIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		qp->setCurrentIndex(index);
	}
	RETURNvoid_();
}

//void QDataWidgetMapper.setCurrentModelIndex(QModelIndex index);
KMETHOD QDataWidgetMapper_setCurrentModelIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		const QModelIndex  index = *RawPtr_to(const QModelIndex *, sfp[1]);
		qp->setCurrentModelIndex(index);
	}
	RETURNvoid_();
}

//boolean QDataWidgetMapper.submit();
KMETHOD QDataWidgetMapper_submit(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		bool ret_v = qp->submit();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QDataWidgetMapper.toFirst();
KMETHOD QDataWidgetMapper_toFirst(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		qp->toFirst();
	}
	RETURNvoid_();
}

//void QDataWidgetMapper.toLast();
KMETHOD QDataWidgetMapper_toLast(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		qp->toLast();
	}
	RETURNvoid_();
}

//void QDataWidgetMapper.toNext();
KMETHOD QDataWidgetMapper_toNext(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		qp->toNext();
	}
	RETURNvoid_();
}

//void QDataWidgetMapper.toPrevious();
KMETHOD QDataWidgetMapper_toPrevious(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDataWidgetMapper *  qp = RawPtr_to(QDataWidgetMapper *, sfp[0]);
	if (qp) {
		qp->toPrevious();
	}
	RETURNvoid_();
}


DummyQDataWidgetMapper::DummyQDataWidgetMapper()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	current_index_changed_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("current-index-changed", NULL));
}
DummyQDataWidgetMapper::~DummyQDataWidgetMapper()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQDataWidgetMapper::setSelf(kRawPtr *ptr)
{
	DummyQDataWidgetMapper::self = ptr;
	DummyQObject::setSelf(ptr);
}

bool DummyQDataWidgetMapper::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQObject::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQDataWidgetMapper::currentIndexChangedSlot(int index)
{
	if (current_index_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].ivalue = index;
		knh_Func_invoke(lctx, current_index_changed_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQDataWidgetMapper::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDataWidgetMapper::event_map->bigin();
	if ((itr = DummyQDataWidgetMapper::event_map->find(str)) == DummyQDataWidgetMapper::event_map->end()) {
		bool ret = false;
		ret = DummyQObject::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQDataWidgetMapper::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDataWidgetMapper::slot_map->bigin();
	if ((itr = DummyQDataWidgetMapper::slot_map->find(str)) == DummyQDataWidgetMapper::slot_map->end()) {
		bool ret = false;
		ret = DummyQObject::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		current_index_changed_func = (*slot_map)["current-index-changed"];
		return true;
	}
}

kObject** DummyQDataWidgetMapper::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQDataWidgetMapper::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 2;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, current_index_changed_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQObject::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQDataWidgetMapper::connection(QObject *o)
{
	QDataWidgetMapper *p = dynamic_cast<QDataWidgetMapper*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(currentIndexChanged(int)), this, SLOT(currentIndexChangedSlot(int)));
	}
	DummyQObject::connection(o);
}

KQDataWidgetMapper::KQDataWidgetMapper(QObject* parent) : QDataWidgetMapper(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQDataWidgetMapper();
	dummy->connection((QObject*)this);
}

KQDataWidgetMapper::~KQDataWidgetMapper()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QDataWidgetMapper_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDataWidgetMapper *qp = RawPtr_to(KQDataWidgetMapper *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QDataWidgetMapper]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDataWidgetMapper]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QDataWidgetMapper_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDataWidgetMapper *qp = RawPtr_to(KQDataWidgetMapper *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QDataWidgetMapper]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDataWidgetMapper]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QDataWidgetMapper_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQDataWidgetMapper *qp = (KQDataWidgetMapper *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QDataWidgetMapper*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QDataWidgetMapper_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQDataWidgetMapper *qp = (KQDataWidgetMapper *)p->rawptr;
		KQDataWidgetMapper *qp = static_cast<KQDataWidgetMapper*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QDataWidgetMapper_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQDataWidgetMapper::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQDataWidgetMapper::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QDataWidgetMapper::event(event);
		return false;
	}
//	QDataWidgetMapper::event(event);
	return true;
}

static knh_IntData_t QDataWidgetMapperConstInt[] = {
	{"AutoSubmit", QDataWidgetMapper::AutoSubmit},
	{"ManualSubmit", QDataWidgetMapper::ManualSubmit},
	{NULL, 0}
};

DEFAPI(void) constQDataWidgetMapper(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QDataWidgetMapperConstInt);
}


DEFAPI(void) defQDataWidgetMapper(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QDataWidgetMapper";
	cdef->free = QDataWidgetMapper_free;
	cdef->reftrace = QDataWidgetMapper_reftrace;
	cdef->compareTo = QDataWidgetMapper_compareTo;
}


//QDate QDate.new();
KMETHOD QDate_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDate *ret_v = new KQDate();
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QDate QDate.new(int y, int m, int d);
KMETHOD QDate_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	int y = Int_to(int, sfp[1]);
	int m = Int_to(int, sfp[2]);
	int d = Int_to(int, sfp[3]);
	KQDate *ret_v = new KQDate(y, m, d);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//QDate QDate.addDays(int ndays);
KMETHOD QDate_addDays(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDate *  qp = RawPtr_to(QDate *, sfp[0]);
	if (qp) {
		int ndays = Int_to(int, sfp[1]);
		QDate ret_v = qp->addDays(ndays);
		QDate *ret_v_ = new QDate(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDate QDate.addMonths(int nmonths);
KMETHOD QDate_addMonths(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDate *  qp = RawPtr_to(QDate *, sfp[0]);
	if (qp) {
		int nmonths = Int_to(int, sfp[1]);
		QDate ret_v = qp->addMonths(nmonths);
		QDate *ret_v_ = new QDate(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDate QDate.addYears(int nyears);
KMETHOD QDate_addYears(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDate *  qp = RawPtr_to(QDate *, sfp[0]);
	if (qp) {
		int nyears = Int_to(int, sfp[1]);
		QDate ret_v = qp->addYears(nyears);
		QDate *ret_v_ = new QDate(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QDate.day();
KMETHOD QDate_day(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDate *  qp = RawPtr_to(QDate *, sfp[0]);
	if (qp) {
		int ret_v = qp->day();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QDate.dayOfWeek();
KMETHOD QDate_dayOfWeek(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDate *  qp = RawPtr_to(QDate *, sfp[0]);
	if (qp) {
		int ret_v = qp->dayOfWeek();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QDate.dayOfYear();
KMETHOD QDate_dayOfYear(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDate *  qp = RawPtr_to(QDate *, sfp[0]);
	if (qp) {
		int ret_v = qp->dayOfYear();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QDate.daysInMonth();
KMETHOD QDate_daysInMonth(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDate *  qp = RawPtr_to(QDate *, sfp[0]);
	if (qp) {
		int ret_v = qp->daysInMonth();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QDate.daysInYear();
KMETHOD QDate_daysInYear(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDate *  qp = RawPtr_to(QDate *, sfp[0]);
	if (qp) {
		int ret_v = qp->daysInYear();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QDate.daysTo(QDate d);
KMETHOD QDate_daysTo(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDate *  qp = RawPtr_to(QDate *, sfp[0]);
	if (qp) {
		const QDate  d = *RawPtr_to(const QDate *, sfp[1]);
		int ret_v = qp->daysTo(d);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QDate.getDate(int year, int month, int day);
KMETHOD QDate_getDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDate *  qp = RawPtr_to(QDate *, sfp[0]);
	if (qp) {
		int* year = Int_to(int*, sfp[1]);
		int* month = Int_to(int*, sfp[2]);
		int* day = Int_to(int*, sfp[3]);
		qp->getDate(year, month, day);
	}
	RETURNvoid_();
}

//int QDate.month();
KMETHOD QDate_month(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDate *  qp = RawPtr_to(QDate *, sfp[0]);
	if (qp) {
		int ret_v = qp->month();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//boolean QDate.setDate(int year, int month, int day);
KMETHOD QDate_setDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDate *  qp = RawPtr_to(QDate *, sfp[0]);
	if (qp) {
		int year = Int_to(int, sfp[1]);
		int month = Int_to(int, sfp[2]);
		int day = Int_to(int, sfp[3]);
		bool ret_v = qp->setDate(year, month, day);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//int QDate.toJulianDay();
KMETHOD QDate_toJulianDay(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDate *  qp = RawPtr_to(QDate *, sfp[0]);
	if (qp) {
		int ret_v = qp->toJulianDay();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//String QDate.toString(String fmt);
KMETHOD QDate_toString(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDate *  qp = RawPtr_to(QDate *, sfp[0]);
	if (qp) {
		const QString format = String_to(const QString, sfp[1]);
		QString ret_v = qp->toString(format);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//String QDate.toString(int fmt);
KMETHOD QDate_toString(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDate *  qp = RawPtr_to(QDate *, sfp[0]);
	if (qp) {
		Qt::DateFormat format = Int_to(Qt::DateFormat, sfp[1]);
		QString ret_v = qp->toString(format);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//int QDate.weekNumber(int yearNumber);
KMETHOD QDate_weekNumber(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDate *  qp = RawPtr_to(QDate *, sfp[0]);
	if (qp) {
		int* yearNumber = Int_to(int*, sfp[1]);
		int ret_v = qp->weekNumber(yearNumber);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QDate.year();
KMETHOD QDate_year(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDate *  qp = RawPtr_to(QDate *, sfp[0]);
	if (qp) {
		int ret_v = qp->year();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QDate QDate.currentDate();
KMETHOD QDate_currentDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QDate ret_v = QDate::currentDate();
		QDate *ret_v_ = new QDate(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDate QDate.fromJulianDay(int jd);
KMETHOD QDate_fromJulianDay(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int jd = Int_to(int, sfp[1]);
		QDate ret_v = QDate::fromJulianDay(jd);
		QDate *ret_v_ = new QDate(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDate QDate.fromString(String str, int fmt);
KMETHOD QDate_fromString(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString string = String_to(const QString, sfp[1]);
		Qt::DateFormat format = Int_to(Qt::DateFormat, sfp[2]);
		QDate ret_v = QDate::fromString(string, format);
		QDate *ret_v_ = new QDate(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//QDate QDate.fromString(String str, String fmt);
KMETHOD QDate_fromString(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString string = String_to(const QString, sfp[1]);
		const QString format = String_to(const QString, sfp[2]);
		QDate ret_v = QDate::fromString(string, format);
		QDate *ret_v_ = new QDate(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//boolean QDate.isLeapYear(int year);
KMETHOD QDate_isLeapYear(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int year = Int_to(int, sfp[1]);
		bool ret_v = QDate::isLeapYear(year);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//String QDate.longDayName(int weekday);
KMETHOD QDate_longDayName(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int weekday = Int_to(int, sfp[1]);
		QString ret_v = QDate::longDayName(weekday);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//String QDate.longDayName(int weekday, int type);
KMETHOD QDate_longDayName(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int weekday = Int_to(int, sfp[1]);
		QDate::MonthNameType type = Int_to(QDate::MonthNameType, sfp[2]);
		QString ret_v = QDate::longDayName(weekday, type);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//String QDate.longMonthName(int month);
KMETHOD QDate_longMonthName(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int month = Int_to(int, sfp[1]);
		QString ret_v = QDate::longMonthName(month);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//String QDate.longMonthName(int month, int type);
KMETHOD QDate_longMonthName(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int month = Int_to(int, sfp[1]);
		QDate::MonthNameType type = Int_to(QDate::MonthNameType, sfp[2]);
		QString ret_v = QDate::longMonthName(month, type);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//String QDate.shortDayName(int weekday);
KMETHOD QDate_shortDayName(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int weekday = Int_to(int, sfp[1]);
		QString ret_v = QDate::shortDayName(weekday);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//String QDate.shortDayName(int weekday, int type);
KMETHOD QDate_shortDayName(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int weekday = Int_to(int, sfp[1]);
		QDate::MonthNameType type = Int_to(QDate::MonthNameType, sfp[2]);
		QString ret_v = QDate::shortDayName(weekday, type);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//String QDate.shortMonthName(int month);
KMETHOD QDate_shortMonthName(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int month = Int_to(int, sfp[1]);
		QString ret_v = QDate::shortMonthName(month);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//String QDate.shortMonthName(int month, int type);
KMETHOD QDate_shortMonthName(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		int month = Int_to(int, sfp[1]);
		QDate::MonthNameType type = Int_to(QDate::MonthNameType, sfp[2]);
		QString ret_v = QDate::shortMonthName(month, type);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//Array<String> QDate.parents();
KMETHOD QDate_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDate *qp = RawPtr_to(QDate*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQDate::DummyQDate()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQDate::~DummyQDate()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQDate::setSelf(kRawPtr *ptr)
{
	DummyQDate::self = ptr;
}

bool DummyQDate::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQDate::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDate::event_map->bigin();
	if ((itr = DummyQDate::event_map->find(str)) == DummyQDate::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQDate::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDate::slot_map->bigin();
	if ((itr = DummyQDate::slot_map->find(str)) == DummyQDate::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQDate::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQDate::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQDate::connection(QObject *o)
{
	QDate *p = dynamic_cast<QDate*>(o);
	if (p != NULL) {
	}
}

KQDate::KQDate() : QDate()
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQDate();
}

KQDate::~KQDate()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QDate_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDate *qp = RawPtr_to(KQDate *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QDate]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDate]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QDate_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDate *qp = RawPtr_to(KQDate *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QDate]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDate]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QDate_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQDate *qp = (KQDate *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QDate*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QDate_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQDate *qp = (KQDate *)p->rawptr;
		KQDate *qp = static_cast<KQDate*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QDate_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (*static_cast<QDate*>(p1->rawptr) == *static_cast<QDate*>(p2->rawptr) ? 0 : 1);
}

void KQDate::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

static knh_IntData_t QDateConstInt[] = {
	{"DateFormat", QDate::DateFormat},
	{"StandaloneFormat", QDate::StandaloneFormat},
	{NULL, 0}
};

DEFAPI(void) constQDate(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QDateConstInt);
}


DEFAPI(void) defQDate(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QDate";
	cdef->free = QDate_free;
	cdef->reftrace = QDate_reftrace;
	cdef->compareTo = QDate_compareTo;
}


//QDateEdit QDateEdit.new(QWidget parent);
KMETHOD QDateEdit_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QWidget*  parent = RawPtr_to(QWidget*, sfp[1]);
	KQDateEdit *ret_v = new KQDateEdit(parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QDateEdit QDateEdit.new(QDate date, QWidget parent);
KMETHOD QDateEdit_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QDate  date = *RawPtr_to(const QDate *, sfp[1]);
	QWidget*  parent = RawPtr_to(QWidget*, sfp[2]);
	KQDateEdit *ret_v = new KQDateEdit(date, parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/

DummyQDateEdit::DummyQDateEdit()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQDateEdit::~DummyQDateEdit()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQDateEdit::setSelf(kRawPtr *ptr)
{
	DummyQDateEdit::self = ptr;
	DummyQDateTimeEdit::setSelf(ptr);
}

bool DummyQDateEdit::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQDateTimeEdit::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQDateEdit::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDateEdit::event_map->bigin();
	if ((itr = DummyQDateEdit::event_map->find(str)) == DummyQDateEdit::event_map->end()) {
		bool ret = false;
		ret = DummyQDateTimeEdit::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQDateEdit::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDateEdit::slot_map->bigin();
	if ((itr = DummyQDateEdit::slot_map->find(str)) == DummyQDateEdit::slot_map->end()) {
		bool ret = false;
		ret = DummyQDateTimeEdit::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQDateEdit::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQDateEdit::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQDateTimeEdit::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQDateEdit::connection(QObject *o)
{
	QDateEdit *p = dynamic_cast<QDateEdit*>(o);
	if (p != NULL) {
	}
	DummyQDateTimeEdit::connection(o);
}

KQDateEdit::KQDateEdit(QWidget* parent) : QDateEdit(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQDateEdit();
	dummy->connection((QObject*)this);
}

KQDateEdit::~KQDateEdit()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QDateEdit_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDateEdit *qp = RawPtr_to(KQDateEdit *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QDateEdit]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDateEdit]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QDateEdit_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDateEdit *qp = RawPtr_to(KQDateEdit *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QDateEdit]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDateEdit]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QDateEdit_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQDateEdit *qp = (KQDateEdit *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QDateEdit*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QDateEdit_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQDateEdit *qp = (KQDateEdit *)p->rawptr;
		KQDateEdit *qp = static_cast<KQDateEdit*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QDateEdit_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQDateEdit::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQDateEdit::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QDateEdit::event(event);
		return false;
	}
//	QDateEdit::event(event);
	return true;
}



DEFAPI(void) defQDateEdit(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QDateEdit";
	cdef->free = QDateEdit_free;
	cdef->reftrace = QDateEdit_reftrace;
	cdef->compareTo = QDateEdit_compareTo;
}


//QDateTime QDateTime.new();
KMETHOD QDateTime_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDateTime *ret_v = new KQDateTime();
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QDateTime QDateTime.new(QDate date);
KMETHOD QDateTime_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QDate  date = *RawPtr_to(const QDate *, sfp[1]);
	KQDateTime *ret_v = new KQDateTime(date);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QDateTime QDateTime.new(QDate date, QTime time, int spec);
KMETHOD QDateTime_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QDate  date = *RawPtr_to(const QDate *, sfp[1]);
	const QTime  time = *RawPtr_to(const QTime *, sfp[2]);
	Qt::TimeSpec spec = Int_to(Qt::TimeSpec, sfp[3]);
	KQDateTime *ret_v = new KQDateTime(date, time, spec);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QDateTime QDateTime.new(QDateTime other);
KMETHOD QDateTime_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QDateTime  other = *RawPtr_to(const QDateTime *, sfp[1]);
	KQDateTime *ret_v = new KQDateTime(other);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//QDateTime QDateTime.addDays(int ndays);
KMETHOD QDateTime_addDays(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		int ndays = Int_to(int, sfp[1]);
		QDateTime ret_v = qp->addDays(ndays);
		QDateTime *ret_v_ = new QDateTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDateTime QDateTime.addMSecs(int msecs);
KMETHOD QDateTime_addMSecs(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		qint64 msecs = Int_to(qint64, sfp[1]);
		QDateTime ret_v = qp->addMSecs(msecs);
		QDateTime *ret_v_ = new QDateTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDateTime QDateTime.addMonths(int nmonths);
KMETHOD QDateTime_addMonths(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		int nmonths = Int_to(int, sfp[1]);
		QDateTime ret_v = qp->addMonths(nmonths);
		QDateTime *ret_v_ = new QDateTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDateTime QDateTime.addSecs(int s);
KMETHOD QDateTime_addSecs(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		int s = Int_to(int, sfp[1]);
		QDateTime ret_v = qp->addSecs(s);
		QDateTime *ret_v_ = new QDateTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDateTime QDateTime.addYears(int nyears);
KMETHOD QDateTime_addYears(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		int nyears = Int_to(int, sfp[1]);
		QDateTime ret_v = qp->addYears(nyears);
		QDateTime *ret_v_ = new QDateTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDate QDateTime.getDate();
KMETHOD QDateTime_getDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		QDate ret_v = qp->date();
		QDate *ret_v_ = new QDate(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QDateTime.daysTo(QDateTime other);
KMETHOD QDateTime_daysTo(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		const QDateTime  other = *RawPtr_to(const QDateTime *, sfp[1]);
		int ret_v = qp->daysTo(other);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QDateTime.msecsTo(QDateTime other);
KMETHOD QDateTime_msecsTo(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		const QDateTime  other = *RawPtr_to(const QDateTime *, sfp[1]);
		qint64 ret_v = qp->msecsTo(other);
		qint64 *ret_v_ = new qint64(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QDateTime.secsTo(QDateTime other);
KMETHOD QDateTime_secsTo(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		const QDateTime  other = *RawPtr_to(const QDateTime *, sfp[1]);
		int ret_v = qp->secsTo(other);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QDateTime.setDate(QDate date);
KMETHOD QDateTime_setDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		const QDate  date = *RawPtr_to(const QDate *, sfp[1]);
		qp->setDate(date);
	}
	RETURNvoid_();
}

//void QDateTime.setMSecsSinceEpoch(int msecs);
KMETHOD QDateTime_setMSecsSinceEpoch(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		qint64 msecs = Int_to(qint64, sfp[1]);
		qp->setMSecsSinceEpoch(msecs);
	}
	RETURNvoid_();
}

//void QDateTime.setTime(QTime time);
KMETHOD QDateTime_setTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		const QTime  time = *RawPtr_to(const QTime *, sfp[1]);
		qp->setTime(time);
	}
	RETURNvoid_();
}

//void QDateTime.setTimeSpec(int spec);
KMETHOD QDateTime_setTimeSpec(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		Qt::TimeSpec spec = Int_to(Qt::TimeSpec, sfp[1]);
		qp->setTimeSpec(spec);
	}
	RETURNvoid_();
}

//void QDateTime.setTime_t(int seconds);
KMETHOD QDateTime_setTime_t(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		uint  seconds = *RawPtr_to(uint *, sfp[1]);
		qp->setTime_t(seconds);
	}
	RETURNvoid_();
}

//QTime QDateTime.getTime();
KMETHOD QDateTime_getTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		QTime ret_v = qp->time();
		QTime *ret_v_ = new QTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QDateTime.getTimeSpec();
KMETHOD QDateTime_getTimeSpec(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		Qt::TimeSpec ret_v = qp->timeSpec();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QDateTime QDateTime.toLocalTime();
KMETHOD QDateTime_toLocalTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		QDateTime ret_v = qp->toLocalTime();
		QDateTime *ret_v_ = new QDateTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QDateTime.toMSecsSinceEpoch();
KMETHOD QDateTime_toMSecsSinceEpoch(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		qint64 ret_v = qp->toMSecsSinceEpoch();
		qint64 *ret_v_ = new qint64(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QDateTime.toString(String fmt);
KMETHOD QDateTime_toString(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		const QString format = String_to(const QString, sfp[1]);
		QString ret_v = qp->toString(format);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//String QDateTime.toString(int fmt);
KMETHOD QDateTime_toString(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		Qt::DateFormat format = Int_to(Qt::DateFormat, sfp[1]);
		QString ret_v = qp->toString(format);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//QDateTime QDateTime.toTimeSpec(int specification);
KMETHOD QDateTime_toTimeSpec(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		Qt::TimeSpec specification = Int_to(Qt::TimeSpec, sfp[1]);
		QDateTime ret_v = qp->toTimeSpec(specification);
		QDateTime *ret_v_ = new QDateTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QDateTime.toTime_t();
KMETHOD QDateTime_toTime_t(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		uint ret_v = qp->toTime_t();
		uint *ret_v_ = new uint(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDateTime QDateTime.toUTC();
KMETHOD QDateTime_toUTC(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *  qp = RawPtr_to(QDateTime *, sfp[0]);
	if (qp) {
		QDateTime ret_v = qp->toUTC();
		QDateTime *ret_v_ = new QDateTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDateTime QDateTime.currentDateTime();
KMETHOD QDateTime_currentDateTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QDateTime ret_v = QDateTime::currentDateTime();
		QDateTime *ret_v_ = new QDateTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDateTime QDateTime.currentDateTimeUtc();
KMETHOD QDateTime_currentDateTimeUtc(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QDateTime ret_v = QDateTime::currentDateTimeUtc();
		QDateTime *ret_v_ = new QDateTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QDateTime.currentMSecsSinceEpoch();
KMETHOD QDateTime_currentMSecsSinceEpoch(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		qint64 ret_v = QDateTime::currentMSecsSinceEpoch();
		qint64 *ret_v_ = new qint64(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDateTime QDateTime.fromMSecsSinceEpoch(int msecs);
KMETHOD QDateTime_fromMSecsSinceEpoch(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		qint64 msecs = Int_to(qint64, sfp[1]);
		QDateTime ret_v = QDateTime::fromMSecsSinceEpoch(msecs);
		QDateTime *ret_v_ = new QDateTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDateTime QDateTime.fromString(String str, int fmt);
KMETHOD QDateTime_fromString(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString string = String_to(const QString, sfp[1]);
		Qt::DateFormat format = Int_to(Qt::DateFormat, sfp[2]);
		QDateTime ret_v = QDateTime::fromString(string, format);
		QDateTime *ret_v_ = new QDateTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//QDateTime QDateTime.fromString(String str, String fmt);
KMETHOD QDateTime_fromString(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString string = String_to(const QString, sfp[1]);
		const QString format = String_to(const QString, sfp[2]);
		QDateTime ret_v = QDateTime::fromString(string, format);
		QDateTime *ret_v_ = new QDateTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//QDateTime QDateTime.fromTime_t(int seconds);
KMETHOD QDateTime_fromTime_t(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		uint  seconds = *RawPtr_to(uint *, sfp[1]);
		QDateTime ret_v = QDateTime::fromTime_t(seconds);
		QDateTime *ret_v_ = new QDateTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//Array<String> QDateTime.parents();
KMETHOD QDateTime_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTime *qp = RawPtr_to(QDateTime*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQDateTime::DummyQDateTime()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQDateTime::~DummyQDateTime()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQDateTime::setSelf(kRawPtr *ptr)
{
	DummyQDateTime::self = ptr;
}

bool DummyQDateTime::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQDateTime::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDateTime::event_map->bigin();
	if ((itr = DummyQDateTime::event_map->find(str)) == DummyQDateTime::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQDateTime::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDateTime::slot_map->bigin();
	if ((itr = DummyQDateTime::slot_map->find(str)) == DummyQDateTime::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQDateTime::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQDateTime::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQDateTime::connection(QObject *o)
{
	QDateTime *p = dynamic_cast<QDateTime*>(o);
	if (p != NULL) {
	}
}

KQDateTime::KQDateTime() : QDateTime()
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQDateTime();
}

KQDateTime::~KQDateTime()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QDateTime_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDateTime *qp = RawPtr_to(KQDateTime *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QDateTime]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDateTime]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QDateTime_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDateTime *qp = RawPtr_to(KQDateTime *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QDateTime]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDateTime]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QDateTime_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQDateTime *qp = (KQDateTime *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QDateTime*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QDateTime_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQDateTime *qp = (KQDateTime *)p->rawptr;
		KQDateTime *qp = static_cast<KQDateTime*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QDateTime_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (*static_cast<QDateTime*>(p1->rawptr) == *static_cast<QDateTime*>(p2->rawptr) ? 0 : 1);
}

void KQDateTime::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQDateTime(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QDateTime";
	cdef->free = QDateTime_free;
	cdef->reftrace = QDateTime_reftrace;
	cdef->compareTo = QDateTime_compareTo;
}


//@Virtual @Override void QDateTimeEdit.clear();
KMETHOD QDateTimeEdit_clear(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		qp->clear();
	}
	RETURNvoid_();
}

//@Virtual @Override boolean QDateTimeEdit.event(QEvent event);
KMETHOD QDateTimeEdit_event(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QEvent*  event = RawPtr_to(QEvent*, sfp[1]);
		bool ret_v = qp->event(event);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//@Virtual @Override QSize QDateTimeEdit.sizeHint();
KMETHOD QDateTimeEdit_sizeHint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->sizeHint();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override void QDateTimeEdit.stepBy(int steps);
KMETHOD QDateTimeEdit_stepBy(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		int steps = Int_to(int, sfp[1]);
		qp->stepBy(steps);
	}
	RETURNvoid_();
}

//QDateTimeEdit QDateTimeEdit.new(QWidget parent);
KMETHOD QDateTimeEdit_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QWidget*  parent = RawPtr_to(QWidget*, sfp[1]);
	KQDateTimeEdit *ret_v = new KQDateTimeEdit(parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QDateTimeEdit QDateTimeEdit.new(QDateTime datetime, QWidget parent);
KMETHOD QDateTimeEdit_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QDateTime  datetime = *RawPtr_to(const QDateTime *, sfp[1]);
	QWidget*  parent = RawPtr_to(QWidget*, sfp[2]);
	KQDateTimeEdit *ret_v = new KQDateTimeEdit(datetime, parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QDateTimeEdit QDateTimeEdit.new(QDate date, QWidget parent);
KMETHOD QDateTimeEdit_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QDate  date = *RawPtr_to(const QDate *, sfp[1]);
	QWidget*  parent = RawPtr_to(QWidget*, sfp[2]);
	KQDateTimeEdit *ret_v = new KQDateTimeEdit(date, parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QDateTimeEdit QDateTimeEdit.new(QTime time, QWidget parent);
KMETHOD QDateTimeEdit_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QTime  time = *RawPtr_to(const QTime *, sfp[1]);
	QWidget*  parent = RawPtr_to(QWidget*, sfp[2]);
	KQDateTimeEdit *ret_v = new KQDateTimeEdit(time, parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//boolean QDateTimeEdit.getCalendarPopup();
KMETHOD QDateTimeEdit_getCalendarPopup(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		bool ret_v = qp->calendarPopup();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//QCalendarWidget QDateTimeEdit.getCalendarWidget();
KMETHOD QDateTimeEdit_getCalendarWidget(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QCalendarWidget* ret_v = qp->calendarWidget();
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QCalendarWidget*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QDateTimeEdit.clearMaximumDate();
KMETHOD QDateTimeEdit_clearMaximumDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		qp->clearMaximumDate();
	}
	RETURNvoid_();
}

//void QDateTimeEdit.clearMaximumDateTime();
KMETHOD QDateTimeEdit_clearMaximumDateTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		qp->clearMaximumDateTime();
	}
	RETURNvoid_();
}

//void QDateTimeEdit.clearMaximumTime();
KMETHOD QDateTimeEdit_clearMaximumTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		qp->clearMaximumTime();
	}
	RETURNvoid_();
}

//void QDateTimeEdit.clearMinimumDate();
KMETHOD QDateTimeEdit_clearMinimumDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		qp->clearMinimumDate();
	}
	RETURNvoid_();
}

//void QDateTimeEdit.clearMinimumDateTime();
KMETHOD QDateTimeEdit_clearMinimumDateTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		qp->clearMinimumDateTime();
	}
	RETURNvoid_();
}

//void QDateTimeEdit.clearMinimumTime();
KMETHOD QDateTimeEdit_clearMinimumTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		qp->clearMinimumTime();
	}
	RETURNvoid_();
}

//int QDateTimeEdit.getCurrentSection();
KMETHOD QDateTimeEdit_getCurrentSection(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QDateTimeEdit::Section ret_v = qp->currentSection();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QDateTimeEdit.getCurrentSectionIndex();
KMETHOD QDateTimeEdit_getCurrentSectionIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		int ret_v = qp->currentSectionIndex();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QDate QDateTimeEdit.getDate();
KMETHOD QDateTimeEdit_getDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QDate ret_v = qp->date();
		QDate *ret_v_ = new QDate(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDateTime QDateTimeEdit.getDateTime();
KMETHOD QDateTimeEdit_getDateTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QDateTime ret_v = qp->dateTime();
		QDateTime *ret_v_ = new QDateTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QDateTimeEdit.getDisplayFormat();
KMETHOD QDateTimeEdit_getDisplayFormat(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QString ret_v = qp->displayFormat();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDateTimeEditSections QDateTimeEdit.displayedSections();
KMETHOD QDateTimeEdit_displayedSections(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QDateTimeEdit::Sections ret_v = qp->displayedSections();
		QDateTimeEdit::Sections *ret_v_ = new QDateTimeEdit::Sections(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDate QDateTimeEdit.getMaximumDate();
KMETHOD QDateTimeEdit_getMaximumDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QDate ret_v = qp->maximumDate();
		QDate *ret_v_ = new QDate(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDateTime QDateTimeEdit.getMaximumDateTime();
KMETHOD QDateTimeEdit_getMaximumDateTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QDateTime ret_v = qp->maximumDateTime();
		QDateTime *ret_v_ = new QDateTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QTime QDateTimeEdit.getMaximumTime();
KMETHOD QDateTimeEdit_getMaximumTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QTime ret_v = qp->maximumTime();
		QTime *ret_v_ = new QTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDate QDateTimeEdit.getMinimumDate();
KMETHOD QDateTimeEdit_getMinimumDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QDate ret_v = qp->minimumDate();
		QDate *ret_v_ = new QDate(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDateTime QDateTimeEdit.getMinimumDateTime();
KMETHOD QDateTimeEdit_getMinimumDateTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QDateTime ret_v = qp->minimumDateTime();
		QDateTime *ret_v_ = new QDateTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QTime QDateTimeEdit.getMinimumTime();
KMETHOD QDateTimeEdit_getMinimumTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QTime ret_v = qp->minimumTime();
		QTime *ret_v_ = new QTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QDateTimeEdit.sectionAt(int index);
KMETHOD QDateTimeEdit_sectionAt(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		QDateTimeEdit::Section ret_v = qp->sectionAt(index);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//int QDateTimeEdit.sectionCount();
KMETHOD QDateTimeEdit_sectionCount(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		int ret_v = qp->sectionCount();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//String QDateTimeEdit.sectionText(int section);
KMETHOD QDateTimeEdit_sectionText(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QDateTimeEdit::Section section = Int_to(QDateTimeEdit::Section, sfp[1]);
		QString ret_v = qp->sectionText(section);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QDateTimeEdit.setCalendarPopup(boolean enable);
KMETHOD QDateTimeEdit_setCalendarPopup(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		bool enable = Boolean_to(bool, sfp[1]);
		qp->setCalendarPopup(enable);
	}
	RETURNvoid_();
}

//void QDateTimeEdit.setCalendarWidget(QCalendarWidget calendarWidget);
KMETHOD QDateTimeEdit_setCalendarWidget(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QCalendarWidget*  calendarWidget = RawPtr_to(QCalendarWidget*, sfp[1]);
		qp->setCalendarWidget(calendarWidget);
	}
	RETURNvoid_();
}

//void QDateTimeEdit.setCurrentSection(int section);
KMETHOD QDateTimeEdit_setCurrentSection(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QDateTimeEdit::Section section = Int_to(QDateTimeEdit::Section, sfp[1]);
		qp->setCurrentSection(section);
	}
	RETURNvoid_();
}

//void QDateTimeEdit.setCurrentSectionIndex(int index);
KMETHOD QDateTimeEdit_setCurrentSectionIndex(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		int index = Int_to(int, sfp[1]);
		qp->setCurrentSectionIndex(index);
	}
	RETURNvoid_();
}

//void QDateTimeEdit.setDateRange(QDate min, QDate max);
KMETHOD QDateTimeEdit_setDateRange(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		const QDate  min = *RawPtr_to(const QDate *, sfp[1]);
		const QDate  max = *RawPtr_to(const QDate *, sfp[2]);
		qp->setDateRange(min, max);
	}
	RETURNvoid_();
}

//void QDateTimeEdit.setDateTimeRange(QDateTime min, QDateTime max);
KMETHOD QDateTimeEdit_setDateTimeRange(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		const QDateTime  min = *RawPtr_to(const QDateTime *, sfp[1]);
		const QDateTime  max = *RawPtr_to(const QDateTime *, sfp[2]);
		qp->setDateTimeRange(min, max);
	}
	RETURNvoid_();
}

//void QDateTimeEdit.setDisplayFormat(String fmt);
KMETHOD QDateTimeEdit_setDisplayFormat(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		const QString format = String_to(const QString, sfp[1]);
		qp->setDisplayFormat(format);
	}
	RETURNvoid_();
}

//void QDateTimeEdit.setMaximumDate(QDate max);
KMETHOD QDateTimeEdit_setMaximumDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		const QDate  max = *RawPtr_to(const QDate *, sfp[1]);
		qp->setMaximumDate(max);
	}
	RETURNvoid_();
}

//void QDateTimeEdit.setMaximumDateTime(QDateTime dt);
KMETHOD QDateTimeEdit_setMaximumDateTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		const QDateTime  dt = *RawPtr_to(const QDateTime *, sfp[1]);
		qp->setMaximumDateTime(dt);
	}
	RETURNvoid_();
}

//void QDateTimeEdit.setMaximumTime(QTime max);
KMETHOD QDateTimeEdit_setMaximumTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		const QTime  max = *RawPtr_to(const QTime *, sfp[1]);
		qp->setMaximumTime(max);
	}
	RETURNvoid_();
}

//void QDateTimeEdit.setMinimumDate(QDate min);
KMETHOD QDateTimeEdit_setMinimumDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		const QDate  min = *RawPtr_to(const QDate *, sfp[1]);
		qp->setMinimumDate(min);
	}
	RETURNvoid_();
}

//void QDateTimeEdit.setMinimumDateTime(QDateTime dt);
KMETHOD QDateTimeEdit_setMinimumDateTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		const QDateTime  dt = *RawPtr_to(const QDateTime *, sfp[1]);
		qp->setMinimumDateTime(dt);
	}
	RETURNvoid_();
}

//void QDateTimeEdit.setMinimumTime(QTime min);
KMETHOD QDateTimeEdit_setMinimumTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		const QTime  min = *RawPtr_to(const QTime *, sfp[1]);
		qp->setMinimumTime(min);
	}
	RETURNvoid_();
}

//void QDateTimeEdit.setSelectedSection(int section);
KMETHOD QDateTimeEdit_setSelectedSection(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QDateTimeEdit::Section section = Int_to(QDateTimeEdit::Section, sfp[1]);
		qp->setSelectedSection(section);
	}
	RETURNvoid_();
}

//void QDateTimeEdit.setTimeRange(QTime min, QTime max);
KMETHOD QDateTimeEdit_setTimeRange(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		const QTime  min = *RawPtr_to(const QTime *, sfp[1]);
		const QTime  max = *RawPtr_to(const QTime *, sfp[2]);
		qp->setTimeRange(min, max);
	}
	RETURNvoid_();
}

//void QDateTimeEdit.setTimeSpec(int spec);
KMETHOD QDateTimeEdit_setTimeSpec(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		Qt::TimeSpec spec = Int_to(Qt::TimeSpec, sfp[1]);
		qp->setTimeSpec(spec);
	}
	RETURNvoid_();
}

//QTime QDateTimeEdit.getTime();
KMETHOD QDateTimeEdit_getTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		QTime ret_v = qp->time();
		QTime *ret_v_ = new QTime(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QDateTimeEdit.getTimeSpec();
KMETHOD QDateTimeEdit_getTimeSpec(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		Qt::TimeSpec ret_v = qp->timeSpec();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QDateTimeEdit.setDate(QDate date);
KMETHOD QDateTimeEdit_setDate(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		const QDate  date = *RawPtr_to(const QDate *, sfp[1]);
		qp->setDate(date);
	}
	RETURNvoid_();
}

//void QDateTimeEdit.setDateTime(QDateTime dateTime);
KMETHOD QDateTimeEdit_setDateTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		const QDateTime  dateTime = *RawPtr_to(const QDateTime *, sfp[1]);
		qp->setDateTime(dateTime);
	}
	RETURNvoid_();
}

//void QDateTimeEdit.setTime(QTime time);
KMETHOD QDateTimeEdit_setTime(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit *  qp = RawPtr_to(QDateTimeEdit *, sfp[0]);
	if (qp) {
		const QTime  time = *RawPtr_to(const QTime *, sfp[1]);
		qp->setTime(time);
	}
	RETURNvoid_();
}


DummyQDateTimeEdit::DummyQDateTimeEdit()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	date_changed_func = NULL;
	date_time_changed_func = NULL;
	time_changed_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("date-changed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("date-time-changed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("time-changed", NULL));
}
DummyQDateTimeEdit::~DummyQDateTimeEdit()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQDateTimeEdit::setSelf(kRawPtr *ptr)
{
	DummyQDateTimeEdit::self = ptr;
	DummyQAbstractSpinBox::setSelf(ptr);
}

bool DummyQDateTimeEdit::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQAbstractSpinBox::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQDateTimeEdit::dateChangedSlot(const QDate date)
{
	if (date_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QDate, date);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, date_changed_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQDateTimeEdit::dateTimeChangedSlot(const QDateTime datetime)
{
	if (date_time_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QDateTime, datetime);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, date_time_changed_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQDateTimeEdit::timeChangedSlot(const QTime time)
{
	if (time_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QTime, time);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, time_changed_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQDateTimeEdit::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDateTimeEdit::event_map->bigin();
	if ((itr = DummyQDateTimeEdit::event_map->find(str)) == DummyQDateTimeEdit::event_map->end()) {
		bool ret = false;
		ret = DummyQAbstractSpinBox::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQDateTimeEdit::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDateTimeEdit::slot_map->bigin();
	if ((itr = DummyQDateTimeEdit::slot_map->find(str)) == DummyQDateTimeEdit::slot_map->end()) {
		bool ret = false;
		ret = DummyQAbstractSpinBox::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		date_changed_func = (*slot_map)["date-changed"];
		date_time_changed_func = (*slot_map)["date-time-changed"];
		time_changed_func = (*slot_map)["time-changed"];
		return true;
	}
}

kObject** DummyQDateTimeEdit::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQDateTimeEdit::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 4;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, date_changed_func);
	KNH_ADDNNREF(ctx, date_time_changed_func);
	KNH_ADDNNREF(ctx, time_changed_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQAbstractSpinBox::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQDateTimeEdit::connection(QObject *o)
{
	QDateTimeEdit *p = dynamic_cast<QDateTimeEdit*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(dateChanged(const QDate)), this, SLOT(dateChangedSlot(const QDate)));
		connect(p, SIGNAL(dateTimeChanged(const QDateTime)), this, SLOT(dateTimeChangedSlot(const QDateTime)));
		connect(p, SIGNAL(timeChanged(const QTime)), this, SLOT(timeChangedSlot(const QTime)));
	}
	DummyQAbstractSpinBox::connection(o);
}

KQDateTimeEdit::KQDateTimeEdit(QWidget* parent) : QDateTimeEdit(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQDateTimeEdit();
	dummy->connection((QObject*)this);
}

KQDateTimeEdit::~KQDateTimeEdit()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QDateTimeEdit_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDateTimeEdit *qp = RawPtr_to(KQDateTimeEdit *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QDateTimeEdit]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDateTimeEdit]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QDateTimeEdit_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDateTimeEdit *qp = RawPtr_to(KQDateTimeEdit *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QDateTimeEdit]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDateTimeEdit]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QDateTimeEdit_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQDateTimeEdit *qp = (KQDateTimeEdit *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QDateTimeEdit*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QDateTimeEdit_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQDateTimeEdit *qp = (KQDateTimeEdit *)p->rawptr;
		KQDateTimeEdit *qp = static_cast<KQDateTimeEdit*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QDateTimeEdit_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQDateTimeEdit::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQDateTimeEdit::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QDateTimeEdit::event(event);
		return false;
	}
//	QDateTimeEdit::event(event);
	return true;
}

static knh_IntData_t QDateTimeEditConstInt[] = {
	{"NoSection", QDateTimeEdit::NoSection},
	{"AmPmSection", QDateTimeEdit::AmPmSection},
	{"MSecSection", QDateTimeEdit::MSecSection},
	{"SecondSection", QDateTimeEdit::SecondSection},
	{"MinuteSection", QDateTimeEdit::MinuteSection},
	{"HourSection", QDateTimeEdit::HourSection},
	{"DaySection", QDateTimeEdit::DaySection},
	{"MonthSection", QDateTimeEdit::MonthSection},
	{"YearSection", QDateTimeEdit::YearSection},
	{NULL, 0}
};

DEFAPI(void) constQDateTimeEdit(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QDateTimeEditConstInt);
}


DEFAPI(void) defQDateTimeEdit(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QDateTimeEdit";
	cdef->free = QDateTimeEdit_free;
	cdef->reftrace = QDateTimeEdit_reftrace;
	cdef->compareTo = QDateTimeEdit_compareTo;
}

//## QDateTimeEditSections QDateTimeEditSections.new(int value);
KMETHOD QDateTimeEditSections_new(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDateTimeEdit::Section i = Int_to(QDateTimeEdit::Section, sfp[1]);
	QDateTimeEdit::Sections *ret_v = new QDateTimeEdit::Sections(i);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	RETURN_(rptr);
}

//## QDateTimeEditSections QDateTimeEditSections.and(int mask);
KMETHOD QDateTimeEditSections_and(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDateTimeEdit::Sections *qp = RawPtr_to(QDateTimeEdit::Sections*, sfp[0]);
	if (qp != NULL) {
		int i = Int_to(int, sfp[1]);
		QDateTimeEdit::Sections ret = ((*qp) & i);
		QDateTimeEdit::Sections *ret_ = new QDateTimeEdit::Sections(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QDateTimeEditSections QDateTimeEditSections.iand(QDateTimeEdit::QDateTimeEditSections other);
KMETHOD QDateTimeEditSections_iand(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDateTimeEdit::Sections *qp = RawPtr_to(QDateTimeEdit::Sections*, sfp[0]);
	if (qp != NULL) {
		QDateTimeEdit::Sections *other = RawPtr_to(QDateTimeEdit::Sections *, sfp[1]);
		*qp = ((*qp) & (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QDateTimeEditSections QDateTimeEditSections.or(QDateTimeEditSections f);
KMETHOD QDateTimeEditSections_or(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit::Sections *qp = RawPtr_to(QDateTimeEdit::Sections*, sfp[0]);
	if (qp != NULL) {
		QDateTimeEdit::Sections *f = RawPtr_to(QDateTimeEdit::Sections*, sfp[1]);
		QDateTimeEdit::Sections ret = ((*qp) | (*f));
		QDateTimeEdit::Sections *ret_ = new QDateTimeEdit::Sections(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QDateTimeEditSections QDateTimeEditSections.ior(QDateTimeEdit::QDateTimeEditSections other);
KMETHOD QDateTimeEditSections_ior(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDateTimeEdit::Sections *qp = RawPtr_to(QDateTimeEdit::Sections*, sfp[0]);
	if (qp != NULL) {
		QDateTimeEdit::Sections *other = RawPtr_to(QDateTimeEdit::Sections *, sfp[1]);
		*qp = ((*qp) | (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QDateTimeEditSections QDateTimeEditSections.xor(QDateTimeEditSections f);
KMETHOD QDateTimeEditSections_xor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDateTimeEdit::Sections *qp = RawPtr_to(QDateTimeEdit::Sections*, sfp[0]);
	if (qp != NULL) {
		QDateTimeEdit::Sections *f = RawPtr_to(QDateTimeEdit::Sections*, sfp[1]);
		QDateTimeEdit::Sections ret = ((*qp) ^ (*f));
		QDateTimeEdit::Sections *ret_ = new QDateTimeEdit::Sections(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QDateTimeEditSections QDateTimeEditSections.ixor(QDateTimeEdit::QDateTimeEditSections other);
KMETHOD QDateTimeEditSections_ixor(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDateTimeEdit::Sections *qp = RawPtr_to(QDateTimeEdit::Sections*, sfp[0]);
	if (qp != NULL) {
		QDateTimeEdit::Sections *other = RawPtr_to(QDateTimeEdit::Sections *, sfp[1]);
		*qp = ((*qp) ^ (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## boolean QDateTimeEditSections.testFlag(int flag);
KMETHOD QDateTimeEditSections_testFlag(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDateTimeEdit::Sections *qp = RawPtr_to(QDateTimeEdit::Sections *, sfp[0]);
	if (qp != NULL) {
		QDateTimeEdit::Section flag = Int_to(QDateTimeEdit::Section, sfp[1]);
		bool ret = qp->testFlag(flag);
		RETURNb_(ret);
	} else {
		RETURNb_(false);
	}
}

//## int QDateTimeEditSections.value();
KMETHOD QDateTimeEditSections_value(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDateTimeEdit::Sections *qp = RawPtr_to(QDateTimeEdit::Sections *, sfp[0]);
	if (qp != NULL) {
		int ret = int(*qp);
		RETURNi_(ret);
	} else {
		RETURNi_(0);
	}
}

static void QDateTimeEditSections_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (p->rawptr != NULL) {
		QDateTimeEdit::Sections *qp = (QDateTimeEdit::Sections *)p->rawptr;
		(void)qp;
		delete qp;
		p->rawptr = NULL;
	}
}

static void QDateTimeEditSections_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
	if (p->rawptr != NULL) {
		QDateTimeEdit::Sections *qp = (QDateTimeEdit::Sections *)p->rawptr;
		(void)qp;
	}
}

static int QDateTimeEditSections_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	if (p1->rawptr == NULL || p2->rawptr == NULL) {
		return 1;
	} else {
//		int v1 = int(*(QDateTimeEdit::Sections*)p1->rawptr);
//		int v2 = int(*(QDateTimeEdit::Sections*)p2->rawptr);
//		return (v1 == v2 ? 0 : 1);
		QDateTimeEdit::Sections v1 = *(QDateTimeEdit::Sections*)p1->rawptr;
		QDateTimeEdit::Sections v2 = *(QDateTimeEdit::Sections*)p2->rawptr;
//		return (v1 == v2 ? 0 : 1);
		return (v1 == v2 ? 0 : 1);

	}
}

DEFAPI(void) defQDateTimeEditSections(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QDateTimeEditSections";
	cdef->free = QDateTimeEditSections_free;
	cdef->reftrace = QDateTimeEditSections_reftrace;
	cdef->compareTo = QDateTimeEditSections_compareTo;
}

//QDebug QDebug.new(QIODevice device);
KMETHOD QDebug_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QIODevice*  device = RawPtr_to(QIODevice*, sfp[1]);
	KQDebug *ret_v = new KQDebug(device);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QDebug QDebug.new(String str);
KMETHOD QDebug_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QString* string = String_to(QString*, sfp[1]);
	KQDebug *ret_v = new KQDebug(string);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QDebug QDebug.new(QtMsgType type);
KMETHOD QDebug_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QtMsgType  type = *RawPtr_to(QtMsgType *, sfp[1]);
	KQDebug *ret_v = new KQDebug(type);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QDebug QDebug.new(QDebug other);
KMETHOD QDebug_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QDebug  other = *RawPtr_to(const QDebug *, sfp[1]);
	KQDebug *ret_v = new KQDebug(other);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//QDebug QDebug.maybeSpace();
KMETHOD QDebug_maybeSpace(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDebug *  qp = RawPtr_to(QDebug *, sfp[0]);
	if (qp) {
		QDebug ret_v = qp->maybeSpace();
		QDebug *ret_v_ = new QDebug(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDebug QDebug.nospace();
KMETHOD QDebug_nospace(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDebug *  qp = RawPtr_to(QDebug *, sfp[0]);
	if (qp) {
		QDebug ret_v = qp->nospace();
		QDebug *ret_v_ = new QDebug(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDebug QDebug.space();
KMETHOD QDebug_space(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDebug *  qp = RawPtr_to(QDebug *, sfp[0]);
	if (qp) {
		QDebug ret_v = qp->space();
		QDebug *ret_v_ = new QDebug(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//Array<String> QDebug.parents();
KMETHOD QDebug_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDebug *qp = RawPtr_to(QDebug*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQDebug::DummyQDebug()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQDebug::~DummyQDebug()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQDebug::setSelf(kRawPtr *ptr)
{
	DummyQDebug::self = ptr;
}

bool DummyQDebug::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQDebug::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDebug::event_map->bigin();
	if ((itr = DummyQDebug::event_map->find(str)) == DummyQDebug::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQDebug::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDebug::slot_map->bigin();
	if ((itr = DummyQDebug::slot_map->find(str)) == DummyQDebug::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQDebug::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQDebug::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQDebug::connection(QObject *o)
{
	QDebug *p = dynamic_cast<QDebug*>(o);
	if (p != NULL) {
	}
}

KQDebug::KQDebug(QIODevice* device) : QDebug(device)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQDebug();
}

KQDebug::~KQDebug()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QDebug_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDebug *qp = RawPtr_to(KQDebug *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QDebug]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDebug]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QDebug_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDebug *qp = RawPtr_to(KQDebug *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QDebug]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDebug]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QDebug_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQDebug *qp = (KQDebug *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QDebug*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QDebug_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQDebug *qp = (KQDebug *)p->rawptr;
		KQDebug *qp = static_cast<KQDebug*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QDebug_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQDebug::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}



DEFAPI(void) defQDebug(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QDebug";
	cdef->free = QDebug_free;
	cdef->reftrace = QDebug_reftrace;
	cdef->compareTo = QDebug_compareTo;
}


//String QDesktopServices.displayName(int type);
KMETHOD QDesktopServices_displayName(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QDesktopServices::StandardLocation type = Int_to(QDesktopServices::StandardLocation, sfp[1]);
		QString ret_v = QDesktopServices::displayName(type);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QDesktopServices.openUrl(QUrl url);
KMETHOD QDesktopServices_openUrl(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QUrl  url = *RawPtr_to(const QUrl *, sfp[1]);
		bool ret_v = QDesktopServices::openUrl(url);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QDesktopServices.setUrlHandler(String scheme, QObject receiver, String method);
KMETHOD QDesktopServices_setUrlHandler(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString scheme = String_to(const QString, sfp[1]);
		QObject*  receiver = RawPtr_to(QObject*, sfp[2]);
		const char*  method = RawPtr_to(const char*, sfp[3]);
		QDesktopServices::setUrlHandler(scheme, receiver, method);
	}
	RETURNvoid_();
}

//String QDesktopServices.storageLocation(int type);
KMETHOD QDesktopServices_storageLocation(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QDesktopServices::StandardLocation type = Int_to(QDesktopServices::StandardLocation, sfp[1]);
		QString ret_v = QDesktopServices::storageLocation(type);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QDesktopServices.unsetUrlHandler(String scheme);
KMETHOD QDesktopServices_unsetUrlHandler(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString scheme = String_to(const QString, sfp[1]);
		QDesktopServices::unsetUrlHandler(scheme);
	}
	RETURNvoid_();
}

//Array<String> QDesktopServices.parents();
KMETHOD QDesktopServices_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDesktopServices *qp = RawPtr_to(QDesktopServices*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQDesktopServices::DummyQDesktopServices()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQDesktopServices::~DummyQDesktopServices()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQDesktopServices::setSelf(kRawPtr *ptr)
{
	DummyQDesktopServices::self = ptr;
}

bool DummyQDesktopServices::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQDesktopServices::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDesktopServices::event_map->bigin();
	if ((itr = DummyQDesktopServices::event_map->find(str)) == DummyQDesktopServices::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQDesktopServices::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDesktopServices::slot_map->bigin();
	if ((itr = DummyQDesktopServices::slot_map->find(str)) == DummyQDesktopServices::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQDesktopServices::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQDesktopServices::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQDesktopServices::connection(QObject *o)
{
	QDesktopServices *p = dynamic_cast<QDesktopServices*>(o);
	if (p != NULL) {
	}
}

KQDesktopServices::~KQDesktopServices()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QDesktopServices_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDesktopServices *qp = RawPtr_to(KQDesktopServices *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QDesktopServices]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDesktopServices]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QDesktopServices_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDesktopServices *qp = RawPtr_to(KQDesktopServices *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QDesktopServices]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDesktopServices]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QDesktopServices_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQDesktopServices *qp = (KQDesktopServices *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QDesktopServices*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QDesktopServices_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQDesktopServices *qp = (KQDesktopServices *)p->rawptr;
		KQDesktopServices *qp = static_cast<KQDesktopServices*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QDesktopServices_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQDesktopServices::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

static knh_IntData_t QDesktopServicesConstInt[] = {
	{"DesktopLocation", QDesktopServices::DesktopLocation},
	{"DocumentsLocation", QDesktopServices::DocumentsLocation},
	{"FontsLocation", QDesktopServices::FontsLocation},
	{"ApplicationsLocation", QDesktopServices::ApplicationsLocation},
	{"MusicLocation", QDesktopServices::MusicLocation},
	{"MoviesLocation", QDesktopServices::MoviesLocation},
	{"PicturesLocation", QDesktopServices::PicturesLocation},
	{"TempLocation", QDesktopServices::TempLocation},
	{"HomeLocation", QDesktopServices::HomeLocation},
	{"DataLocation", QDesktopServices::DataLocation},
	{"CacheLocation", QDesktopServices::CacheLocation},
	{NULL, 0}
};

DEFAPI(void) constQDesktopServices(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QDesktopServicesConstInt);
}


DEFAPI(void) defQDesktopServices(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QDesktopServices";
	cdef->free = QDesktopServices_free;
	cdef->reftrace = QDesktopServices_reftrace;
	cdef->compareTo = QDesktopServices_compareTo;
}


//QRect QDesktopWidget.availableGeometry(int screen);
KMETHOD QDesktopWidget_availableGeometry(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDesktopWidget *  qp = RawPtr_to(QDesktopWidget *, sfp[0]);
	if (qp) {
		int screen = Int_to(int, sfp[1]);
		const QRect ret_v = qp->availableGeometry(screen);
		QRect *ret_v_ = new QRect(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//QRect QDesktopWidget.availableGeometry(QWidget widget);
KMETHOD QDesktopWidget_availableGeometry(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDesktopWidget *  qp = RawPtr_to(QDesktopWidget *, sfp[0]);
	if (qp) {
		const QWidget*  widget = RawPtr_to(const QWidget*, sfp[1]);
		const QRect ret_v = qp->availableGeometry(widget);
		QRect *ret_v_ = new QRect(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QRect QDesktopWidget.availableGeometry(QPoint p);
KMETHOD QDesktopWidget_availableGeometry(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDesktopWidget *  qp = RawPtr_to(QDesktopWidget *, sfp[0]);
	if (qp) {
		const QPoint  p = *RawPtr_to(const QPoint *, sfp[1]);
		const QRect ret_v = qp->availableGeometry(p);
		QRect *ret_v_ = new QRect(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//boolean QDesktopWidget.isVirtualDesktop();
KMETHOD QDesktopWidget_isVirtualDesktop(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDesktopWidget *  qp = RawPtr_to(QDesktopWidget *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isVirtualDesktop();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//int QDesktopWidget.primaryScreen();
KMETHOD QDesktopWidget_primaryScreen(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDesktopWidget *  qp = RawPtr_to(QDesktopWidget *, sfp[0]);
	if (qp) {
		int ret_v = qp->primaryScreen();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QWidget QDesktopWidget.screen(int screen);
KMETHOD QDesktopWidget_screen(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDesktopWidget *  qp = RawPtr_to(QDesktopWidget *, sfp[0]);
	if (qp) {
		int screen = Int_to(int, sfp[1]);
		QWidget* ret_v = qp->screen(screen);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QWidget*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QDesktopWidget.screenCount();
KMETHOD QDesktopWidget_screenCount(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDesktopWidget *  qp = RawPtr_to(QDesktopWidget *, sfp[0]);
	if (qp) {
		int ret_v = qp->screenCount();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QRect QDesktopWidget.screenGeometry(int screen);
KMETHOD QDesktopWidget_screenGeometry(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDesktopWidget *  qp = RawPtr_to(QDesktopWidget *, sfp[0]);
	if (qp) {
		int screen = Int_to(int, sfp[1]);
		const QRect ret_v = qp->screenGeometry(screen);
		QRect *ret_v_ = new QRect(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

/*
//QRect QDesktopWidget.screenGeometry(QWidget widget);
KMETHOD QDesktopWidget_screenGeometry(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDesktopWidget *  qp = RawPtr_to(QDesktopWidget *, sfp[0]);
	if (qp) {
		const QWidget*  widget = RawPtr_to(const QWidget*, sfp[1]);
		const QRect ret_v = qp->screenGeometry(widget);
		QRect *ret_v_ = new QRect(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QRect QDesktopWidget.screenGeometry(QPoint p);
KMETHOD QDesktopWidget_screenGeometry(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDesktopWidget *  qp = RawPtr_to(QDesktopWidget *, sfp[0]);
	if (qp) {
		const QPoint  p = *RawPtr_to(const QPoint *, sfp[1]);
		const QRect ret_v = qp->screenGeometry(p);
		QRect *ret_v_ = new QRect(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//int QDesktopWidget.screenNumber(QWidget widget);
KMETHOD QDesktopWidget_screenNumber(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDesktopWidget *  qp = RawPtr_to(QDesktopWidget *, sfp[0]);
	if (qp) {
		const QWidget*  widget = RawPtr_to(const QWidget*, sfp[1]);
		int ret_v = qp->screenNumber(widget);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

/*
//int QDesktopWidget.screenNumber(QPoint point);
KMETHOD QDesktopWidget_screenNumber(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDesktopWidget *  qp = RawPtr_to(QDesktopWidget *, sfp[0]);
	if (qp) {
		const QPoint  point = *RawPtr_to(const QPoint *, sfp[1]);
		int ret_v = qp->screenNumber(point);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}
*/

DummyQDesktopWidget::DummyQDesktopWidget()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	resized_func = NULL;
	screen_count_changed_func = NULL;
	work_area_resized_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("resized", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("screen-count-changed", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("work-area-resized", NULL));
}
DummyQDesktopWidget::~DummyQDesktopWidget()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQDesktopWidget::setSelf(kRawPtr *ptr)
{
	DummyQDesktopWidget::self = ptr;
	DummyQWidget::setSelf(ptr);
}

bool DummyQDesktopWidget::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQWidget::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQDesktopWidget::resizedSlot(int screen)
{
	if (resized_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].ivalue = screen;
		knh_Func_invoke(lctx, resized_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQDesktopWidget::screenCountChangedSlot(int new_Count)
{
	if (screen_count_changed_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].ivalue = new_Count;
		knh_Func_invoke(lctx, screen_count_changed_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQDesktopWidget::workAreaResizedSlot(int screen)
{
	if (work_area_resized_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].ivalue = screen;
		knh_Func_invoke(lctx, work_area_resized_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQDesktopWidget::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDesktopWidget::event_map->bigin();
	if ((itr = DummyQDesktopWidget::event_map->find(str)) == DummyQDesktopWidget::event_map->end()) {
		bool ret = false;
		ret = DummyQWidget::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQDesktopWidget::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDesktopWidget::slot_map->bigin();
	if ((itr = DummyQDesktopWidget::slot_map->find(str)) == DummyQDesktopWidget::slot_map->end()) {
		bool ret = false;
		ret = DummyQWidget::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		resized_func = (*slot_map)["resized"];
		screen_count_changed_func = (*slot_map)["screen-count-changed"];
		work_area_resized_func = (*slot_map)["work-area-resized"];
		return true;
	}
}

kObject** DummyQDesktopWidget::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQDesktopWidget::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 4;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, resized_func);
	KNH_ADDNNREF(ctx, screen_count_changed_func);
	KNH_ADDNNREF(ctx, work_area_resized_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQWidget::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQDesktopWidget::connection(QObject *o)
{
	QDesktopWidget *p = dynamic_cast<QDesktopWidget*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(resized(int)), this, SLOT(resizedSlot(int)));
		connect(p, SIGNAL(screenCountChanged(int)), this, SLOT(screenCountChangedSlot(int)));
		connect(p, SIGNAL(workAreaResized(int)), this, SLOT(workAreaResizedSlot(int)));
	}
	DummyQWidget::connection(o);
}

KQDesktopWidget::~KQDesktopWidget()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QDesktopWidget_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDesktopWidget *qp = RawPtr_to(KQDesktopWidget *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QDesktopWidget]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDesktopWidget]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QDesktopWidget_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDesktopWidget *qp = RawPtr_to(KQDesktopWidget *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QDesktopWidget]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDesktopWidget]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QDesktopWidget_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQDesktopWidget *qp = (KQDesktopWidget *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QDesktopWidget*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QDesktopWidget_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQDesktopWidget *qp = (KQDesktopWidget *)p->rawptr;
		KQDesktopWidget *qp = static_cast<KQDesktopWidget*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QDesktopWidget_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQDesktopWidget::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQDesktopWidget::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QDesktopWidget::event(event);
		return false;
	}
//	QDesktopWidget::event(event);
	return true;
}



DEFAPI(void) defQDesktopWidget(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QDesktopWidget";
	cdef->free = QDesktopWidget_free;
	cdef->reftrace = QDesktopWidget_reftrace;
	cdef->compareTo = QDesktopWidget_compareTo;
}


//@Virtual @Override QSize QDial.minimumSizeHint();
KMETHOD QDial_minimumSizeHint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDial *  qp = RawPtr_to(QDial *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->minimumSizeHint();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override QSize QDial.sizeHint();
KMETHOD QDial_sizeHint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDial *  qp = RawPtr_to(QDial *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->sizeHint();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDial QDial.new(QWidget parent);
KMETHOD QDial_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QWidget*  parent = RawPtr_to(QWidget*, sfp[1]);
	KQDial *ret_v = new KQDial(parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

//int QDial.notchSize();
KMETHOD QDial_notchSize(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDial *  qp = RawPtr_to(QDial *, sfp[0]);
	if (qp) {
		int ret_v = qp->notchSize();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//float QDial.getNotchTarget();
KMETHOD QDial_getNotchTarget(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDial *  qp = RawPtr_to(QDial *, sfp[0]);
	if (qp) {
		qreal ret_v = qp->notchTarget();
		RETURNf_(ret_v);
	} else {
		RETURNf_(0.0f);
	}
}

//boolean QDial.getNotchesVisible();
KMETHOD QDial_getNotchesVisible(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDial *  qp = RawPtr_to(QDial *, sfp[0]);
	if (qp) {
		bool ret_v = qp->notchesVisible();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QDial.setNotchTarget(double target);
KMETHOD QDial_setNotchTarget(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDial *  qp = RawPtr_to(QDial *, sfp[0]);
	if (qp) {
		double  target = *RawPtr_to(double *, sfp[1]);
		qp->setNotchTarget(target);
	}
	RETURNvoid_();
}

//boolean QDial.getWrapping();
KMETHOD QDial_getWrapping(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDial *  qp = RawPtr_to(QDial *, sfp[0]);
	if (qp) {
		bool ret_v = qp->wrapping();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QDial.setNotchesVisible(boolean visible);
KMETHOD QDial_setNotchesVisible(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDial *  qp = RawPtr_to(QDial *, sfp[0]);
	if (qp) {
		bool visible = Boolean_to(bool, sfp[1]);
		qp->setNotchesVisible(visible);
	}
	RETURNvoid_();
}

//void QDial.setWrapping(boolean on);
KMETHOD QDial_setWrapping(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDial *  qp = RawPtr_to(QDial *, sfp[0]);
	if (qp) {
		bool on = Boolean_to(bool, sfp[1]);
		qp->setWrapping(on);
	}
	RETURNvoid_();
}


DummyQDial::DummyQDial()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQDial::~DummyQDial()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQDial::setSelf(kRawPtr *ptr)
{
	DummyQDial::self = ptr;
	DummyQAbstractSlider::setSelf(ptr);
}

bool DummyQDial::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQAbstractSlider::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQDial::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDial::event_map->bigin();
	if ((itr = DummyQDial::event_map->find(str)) == DummyQDial::event_map->end()) {
		bool ret = false;
		ret = DummyQAbstractSlider::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQDial::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDial::slot_map->bigin();
	if ((itr = DummyQDial::slot_map->find(str)) == DummyQDial::slot_map->end()) {
		bool ret = false;
		ret = DummyQAbstractSlider::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQDial::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQDial::reftrace p->rawptr=[%p]\n", p->rawptr);

	tail_ = DummyQAbstractSlider::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQDial::connection(QObject *o)
{
	QDial *p = dynamic_cast<QDial*>(o);
	if (p != NULL) {
	}
	DummyQAbstractSlider::connection(o);
}

KQDial::KQDial(QWidget* parent) : QDial(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQDial();
	dummy->connection((QObject*)this);
}

KQDial::~KQDial()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QDial_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDial *qp = RawPtr_to(KQDial *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QDial]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDial]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QDial_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDial *qp = RawPtr_to(KQDial *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QDial]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDial]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QDial_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQDial *qp = (KQDial *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QDial*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QDial_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQDial *qp = (KQDial *)p->rawptr;
		KQDial *qp = static_cast<KQDial*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QDial_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQDial::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQDial::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QDial::event(event);
		return false;
	}
//	QDial::event(event);
	return true;
}



DEFAPI(void) defQDial(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QDial";
	cdef->free = QDial_free;
	cdef->reftrace = QDial_reftrace;
	cdef->compareTo = QDial_compareTo;
}


//@Virtual @Override QSize QDialog.minimumSizeHint();
KMETHOD QDialog_minimumSizeHint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialog *  qp = RawPtr_to(QDialog *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->minimumSizeHint();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//@Virtual @Override void QDialog.setVisible(boolean visible);
KMETHOD QDialog_setVisible(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialog *  qp = RawPtr_to(QDialog *, sfp[0]);
	if (qp) {
		bool visible = Boolean_to(bool, sfp[1]);
		qp->setVisible(visible);
	}
	RETURNvoid_();
}

//@Virtual @Override QSize QDialog.sizeHint();
KMETHOD QDialog_sizeHint(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialog *  qp = RawPtr_to(QDialog *, sfp[0]);
	if (qp) {
		QSize ret_v = qp->sizeHint();
		QSize *ret_v_ = new QSize(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDialog QDialog.new(QWidget parent, QtWindowFlags f);
KMETHOD QDialog_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QWidget*  parent = RawPtr_to(QWidget*, sfp[1]);
	initFlag(f, Qt::WindowFlags, sfp[2]);
	KQDialog *ret_v = new KQDialog(parent, f);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

//boolean QDialog.isSizeGripEnabled();
KMETHOD QDialog_isSizeGripEnabled(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialog *  qp = RawPtr_to(QDialog *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isSizeGripEnabled();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//int QDialog.getResult();
KMETHOD QDialog_getResult(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialog *  qp = RawPtr_to(QDialog *, sfp[0]);
	if (qp) {
		int ret_v = qp->result();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QDialog.setModal(boolean modal);
KMETHOD QDialog_setModal(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialog *  qp = RawPtr_to(QDialog *, sfp[0]);
	if (qp) {
		bool modal = Boolean_to(bool, sfp[1]);
		qp->setModal(modal);
	}
	RETURNvoid_();
}

//void QDialog.setResult(int i);
KMETHOD QDialog_setResult(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialog *  qp = RawPtr_to(QDialog *, sfp[0]);
	if (qp) {
		int i = Int_to(int, sfp[1]);
		qp->setResult(i);
	}
	RETURNvoid_();
}

//void QDialog.setSizeGripEnabled(boolean arg0);
KMETHOD QDialog_setSizeGripEnabled(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialog *  qp = RawPtr_to(QDialog *, sfp[0]);
	if (qp) {
		bool arg0 = Boolean_to(bool, sfp[1]);
		qp->setSizeGripEnabled(arg0);
	}
	RETURNvoid_();
}

//@Virtual void QDialog.done(int r);
KMETHOD QDialog_done(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialog *  qp = RawPtr_to(QDialog *, sfp[0]);
	if (qp) {
		int r = Int_to(int, sfp[1]);
		qp->done(r);
	}
	RETURNvoid_();
}

//int QDialog.exec();
KMETHOD QDialog_exec(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialog *  qp = RawPtr_to(QDialog *, sfp[0]);
	if (qp) {
		int ret_v = qp->exec();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QDialog.open();
KMETHOD QDialog_open(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialog *  qp = RawPtr_to(QDialog *, sfp[0]);
	if (qp) {
		qp->open();
	}
	RETURNvoid_();
}

//@Virtual void QDialog.reject();
KMETHOD QDialog_reject(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialog *  qp = RawPtr_to(QDialog *, sfp[0]);
	if (qp) {
		qp->reject();
	}
	RETURNvoid_();
}


DummyQDialog::DummyQDialog()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	accepted_func = NULL;
	finished_func = NULL;
	rejected_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("accepted", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("finished", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("rejected", NULL));
}
DummyQDialog::~DummyQDialog()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQDialog::setSelf(kRawPtr *ptr)
{
	DummyQDialog::self = ptr;
	DummyQWidget::setSelf(ptr);
}

bool DummyQDialog::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQWidget::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQDialog::acceptedSlot()
{
	if (accepted_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, accepted_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQDialog::finishedSlot(int result)
{
	if (finished_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		lsfp[K_CALLDELTA+2].ivalue = result;
		knh_Func_invoke(lctx, finished_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQDialog::rejectedSlot()
{
	if (rejected_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, rejected_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQDialog::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDialog::event_map->bigin();
	if ((itr = DummyQDialog::event_map->find(str)) == DummyQDialog::event_map->end()) {
		bool ret = false;
		ret = DummyQWidget::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQDialog::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDialog::slot_map->bigin();
	if ((itr = DummyQDialog::slot_map->find(str)) == DummyQDialog::slot_map->end()) {
		bool ret = false;
		ret = DummyQWidget::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		accepted_func = (*slot_map)["accepted"];
		finished_func = (*slot_map)["finished"];
		rejected_func = (*slot_map)["rejected"];
		return true;
	}
}

kObject** DummyQDialog::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQDialog::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 4;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, accepted_func);
	KNH_ADDNNREF(ctx, finished_func);
	KNH_ADDNNREF(ctx, rejected_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQWidget::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQDialog::connection(QObject *o)
{
	QDialog *p = dynamic_cast<QDialog*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(accepted()), this, SLOT(acceptedSlot()));
		connect(p, SIGNAL(finished(int)), this, SLOT(finishedSlot(int)));
		connect(p, SIGNAL(rejected()), this, SLOT(rejectedSlot()));
	}
	DummyQWidget::connection(o);
}

KQDialog::KQDialog(QWidget* parent, Qt::WindowFlags f) : QDialog(parent, f)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQDialog();
	dummy->connection((QObject*)this);
}

KQDialog::~KQDialog()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QDialog_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDialog *qp = RawPtr_to(KQDialog *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QDialog]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDialog]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QDialog_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDialog *qp = RawPtr_to(KQDialog *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QDialog]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDialog]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QDialog_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQDialog *qp = (KQDialog *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QDialog*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QDialog_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQDialog *qp = (KQDialog *)p->rawptr;
		KQDialog *qp = static_cast<KQDialog*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QDialog_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQDialog::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQDialog::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QDialog::event(event);
		return false;
	}
//	QDialog::event(event);
	return true;
}

static knh_IntData_t QDialogConstInt[] = {
	{"Accepted", QDialog::Accepted},
	{"Rejected", QDialog::Rejected},
	{NULL, 0}
};

DEFAPI(void) constQDialog(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QDialogConstInt);
}


DEFAPI(void) defQDialog(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QDialog";
	cdef->free = QDialog_free;
	cdef->reftrace = QDialog_reftrace;
	cdef->compareTo = QDialog_compareTo;
}


//QDialogButtonBox QDialogButtonBox.new(QWidget parent);
KMETHOD QDialogButtonBox_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QWidget*  parent = RawPtr_to(QWidget*, sfp[1]);
	KQDialogButtonBox *ret_v = new KQDialogButtonBox(parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QDialogButtonBox QDialogButtonBox.new(int orientation, QWidget parent);
KMETHOD QDialogButtonBox_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	Qt::Orientation orientation = Int_to(Qt::Orientation, sfp[1]);
	QWidget*  parent = RawPtr_to(QWidget*, sfp[2]);
	KQDialogButtonBox *ret_v = new KQDialogButtonBox(orientation, parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QDialogButtonBox QDialogButtonBox.new(QDialogButtonBoxStandardButtons buttons, int orientation, QWidget parent);
KMETHOD QDialogButtonBox_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	initFlag(buttons, QDialogButtonBox::StandardButtons, sfp[1]);
	Qt::Orientation orientation = Int_to(Qt::Orientation, sfp[2]);
	QWidget*  parent = RawPtr_to(QWidget*, sfp[3]);
	KQDialogButtonBox *ret_v = new KQDialogButtonBox(buttons, orientation, parent);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//void QDialogButtonBox.addButton(QAbstractButton button, int role);
KMETHOD QDialogButtonBox_addButton(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialogButtonBox *  qp = RawPtr_to(QDialogButtonBox *, sfp[0]);
	if (qp) {
		QAbstractButton*  button = RawPtr_to(QAbstractButton*, sfp[1]);
		QDialogButtonBox::ButtonRole role = Int_to(QDialogButtonBox::ButtonRole, sfp[2]);
		qp->addButton(button, role);
	}
	RETURNvoid_();
}

/*
//QPushButton QDialogButtonBox.addButton(String text, int role);
KMETHOD QDialogButtonBox_addButton(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialogButtonBox *  qp = RawPtr_to(QDialogButtonBox *, sfp[0]);
	if (qp) {
		const QString text = String_to(const QString, sfp[1]);
		QDialogButtonBox::ButtonRole role = Int_to(QDialogButtonBox::ButtonRole, sfp[2]);
		QPushButton* ret_v = qp->addButton(text, role);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QPushButton*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
/*
//QPushButton QDialogButtonBox.addButton(int button);
KMETHOD QDialogButtonBox_addButton(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialogButtonBox *  qp = RawPtr_to(QDialogButtonBox *, sfp[0]);
	if (qp) {
		QDialogButtonBox::StandardButton button = Int_to(QDialogButtonBox::StandardButton, sfp[1]);
		QPushButton* ret_v = qp->addButton(button);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QPushButton*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}
*/
//QPushButton QDialogButtonBox.button(int which);
KMETHOD QDialogButtonBox_button(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialogButtonBox *  qp = RawPtr_to(QDialogButtonBox *, sfp[0]);
	if (qp) {
		QDialogButtonBox::StandardButton which = Int_to(QDialogButtonBox::StandardButton, sfp[1]);
		QPushButton* ret_v = qp->button(which);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, (QPushButton*)ret_v, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//int QDialogButtonBox.buttonRole(QAbstractButton button);
KMETHOD QDialogButtonBox_buttonRole(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialogButtonBox *  qp = RawPtr_to(QDialogButtonBox *, sfp[0]);
	if (qp) {
		QAbstractButton*  button = RawPtr_to(QAbstractButton*, sfp[1]);
		QDialogButtonBox::ButtonRole ret_v = qp->buttonRole(button);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//Array<QAbstractButton> QDialogButtonBox.buttons();
KMETHOD QDialogButtonBox_buttons(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialogButtonBox *  qp = RawPtr_to(QDialogButtonBox *, sfp[0]);
	if (qp) {
		QList<QAbstractButton*> ret_v = qp->buttons();
		int list_size = ret_v.size();
		kArray *a = new_Array0(ctx, list_size);
		kclass_t cid = knh_getcid(ctx, STEXT("QAbstractButton"));
		for (int n = 0; n < list_size; n++) {
			kRawPtr *p = new_RawPtr(ctx, ClassTBL(cid), ret_v[n]);
			knh_Array_add(ctx, a, (kObject *)p);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}
	

//boolean QDialogButtonBox.getCenterButtons();
KMETHOD QDialogButtonBox_getCenterButtons(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialogButtonBox *  qp = RawPtr_to(QDialogButtonBox *, sfp[0]);
	if (qp) {
		bool ret_v = qp->centerButtons();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QDialogButtonBox.clear();
KMETHOD QDialogButtonBox_clear(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialogButtonBox *  qp = RawPtr_to(QDialogButtonBox *, sfp[0]);
	if (qp) {
		qp->clear();
	}
	RETURNvoid_();
}

//int QDialogButtonBox.getOrientation();
KMETHOD QDialogButtonBox_getOrientation(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialogButtonBox *  qp = RawPtr_to(QDialogButtonBox *, sfp[0]);
	if (qp) {
		Qt::Orientation ret_v = qp->orientation();
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//void QDialogButtonBox.removeButton(QAbstractButton button);
KMETHOD QDialogButtonBox_removeButton(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialogButtonBox *  qp = RawPtr_to(QDialogButtonBox *, sfp[0]);
	if (qp) {
		QAbstractButton*  button = RawPtr_to(QAbstractButton*, sfp[1]);
		qp->removeButton(button);
	}
	RETURNvoid_();
}

//void QDialogButtonBox.setCenterButtons(boolean center);
KMETHOD QDialogButtonBox_setCenterButtons(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialogButtonBox *  qp = RawPtr_to(QDialogButtonBox *, sfp[0]);
	if (qp) {
		bool center = Boolean_to(bool, sfp[1]);
		qp->setCenterButtons(center);
	}
	RETURNvoid_();
}

//void QDialogButtonBox.setOrientation(int orientation);
KMETHOD QDialogButtonBox_setOrientation(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialogButtonBox *  qp = RawPtr_to(QDialogButtonBox *, sfp[0]);
	if (qp) {
		Qt::Orientation orientation = Int_to(Qt::Orientation, sfp[1]);
		qp->setOrientation(orientation);
	}
	RETURNvoid_();
}

//void QDialogButtonBox.setStandardButtons(QDialogButtonBoxStandardButtons buttons);
KMETHOD QDialogButtonBox_setStandardButtons(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialogButtonBox *  qp = RawPtr_to(QDialogButtonBox *, sfp[0]);
	if (qp) {
		initFlag(buttons, QDialogButtonBox::StandardButtons, sfp[1]);
		qp->setStandardButtons(buttons);
	}
	RETURNvoid_();
}

//int QDialogButtonBox.standardButton(QAbstractButton button);
KMETHOD QDialogButtonBox_standardButton(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialogButtonBox *  qp = RawPtr_to(QDialogButtonBox *, sfp[0]);
	if (qp) {
		QAbstractButton*  button = RawPtr_to(QAbstractButton*, sfp[1]);
		QDialogButtonBox::StandardButton ret_v = qp->standardButton(button);
		RETURNi_(ret_v);
	} else {
		RETURNi_(0);
	}
}

//QDialogButtonBoxStandardButtons QDialogButtonBox.getStandardButtons();
KMETHOD QDialogButtonBox_getStandardButtons(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialogButtonBox *  qp = RawPtr_to(QDialogButtonBox *, sfp[0]);
	if (qp) {
		QDialogButtonBox::StandardButtons ret_v = qp->standardButtons();
		QDialogButtonBox::StandardButtons *ret_v_ = new QDialogButtonBox::StandardButtons(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}


DummyQDialogButtonBox::DummyQDialogButtonBox()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	accepted_func = NULL;
	clicked_func = NULL;
	help_requested_func = NULL;
	rejected_func = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
	slot_map->insert(map<string, kFunc *>::value_type("accepted", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("clicked", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("help-requested", NULL));
	slot_map->insert(map<string, kFunc *>::value_type("rejected", NULL));
}
DummyQDialogButtonBox::~DummyQDialogButtonBox()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQDialogButtonBox::setSelf(kRawPtr *ptr)
{
	DummyQDialogButtonBox::self = ptr;
	DummyQWidget::setSelf(ptr);
}

bool DummyQDialogButtonBox::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = DummyQWidget::eventDispatcher(event);
		break;
	}
	return ret;
}

bool DummyQDialogButtonBox::acceptedSlot()
{
	if (accepted_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, accepted_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQDialogButtonBox::clickedSlot(QAbstractButton* button)
{
	if (clicked_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		kRawPtr *p1 = new_QRawPtr(lctx, QAbstractButton, button);
		KNH_SETv(lctx, lsfp[K_CALLDELTA+2].o, UPCAST(p1));
		knh_Func_invoke(lctx, clicked_func, lsfp, 2);
		return true;
	}
	return false;
}

bool DummyQDialogButtonBox::helpRequestedSlot()
{
	if (help_requested_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, help_requested_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQDialogButtonBox::rejectedSlot()
{
	if (rejected_func != NULL) {
		CTX lctx = knh_getCurrentContext();
		ksfp_t *lsfp = lctx->esp;
		KNH_SETv(lctx, lsfp[K_CALLDELTA+1].o, UPCAST(self));
		knh_Func_invoke(lctx, rejected_func, lsfp, 1);
		return true;
	}
	return false;
}

bool DummyQDialogButtonBox::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDialogButtonBox::event_map->bigin();
	if ((itr = DummyQDialogButtonBox::event_map->find(str)) == DummyQDialogButtonBox::event_map->end()) {
		bool ret = false;
		ret = DummyQWidget::addEvent(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQDialogButtonBox::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDialogButtonBox::slot_map->bigin();
	if ((itr = DummyQDialogButtonBox::slot_map->find(str)) == DummyQDialogButtonBox::slot_map->end()) {
		bool ret = false;
		ret = DummyQWidget::signalConnect(callback_func, str);
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		accepted_func = (*slot_map)["accepted"];
		clicked_func = (*slot_map)["clicked"];
		help_requested_func = (*slot_map)["help-requested"];
		rejected_func = (*slot_map)["rejected"];
		return true;
	}
}

kObject** DummyQDialogButtonBox::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
//	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQDialogButtonBox::reftrace p->rawptr=[%p]\n", p->rawptr);

	int list_size = 5;
	KNH_ENSUREREF(ctx, list_size);

	KNH_ADDNNREF(ctx, accepted_func);
	KNH_ADDNNREF(ctx, clicked_func);
	KNH_ADDNNREF(ctx, help_requested_func);
	KNH_ADDNNREF(ctx, rejected_func);

	KNH_SIZEREF(ctx);

	tail_ = DummyQWidget::reftrace(ctx, p, tail_);

	return tail_;
}

void DummyQDialogButtonBox::connection(QObject *o)
{
	QDialogButtonBox *p = dynamic_cast<QDialogButtonBox*>(o);
	if (p != NULL) {
		connect(p, SIGNAL(accepted()), this, SLOT(acceptedSlot()));
		connect(p, SIGNAL(clicked(QAbstractButton*)), this, SLOT(clickedSlot(QAbstractButton*)));
		connect(p, SIGNAL(helpRequested()), this, SLOT(helpRequestedSlot()));
		connect(p, SIGNAL(rejected()), this, SLOT(rejectedSlot()));
	}
	DummyQWidget::connection(o);
}

KQDialogButtonBox::KQDialogButtonBox(QWidget* parent) : QDialogButtonBox(parent)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQDialogButtonBox();
	dummy->connection((QObject*)this);
}

KQDialogButtonBox::~KQDialogButtonBox()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QDialogButtonBox_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDialogButtonBox *qp = RawPtr_to(KQDialogButtonBox *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QDialogButtonBox]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDialogButtonBox]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QDialogButtonBox_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDialogButtonBox *qp = RawPtr_to(KQDialogButtonBox *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QDialogButtonBox]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDialogButtonBox]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QDialogButtonBox_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQDialogButtonBox *qp = (KQDialogButtonBox *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QDialogButtonBox*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QDialogButtonBox_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQDialogButtonBox *qp = (KQDialogButtonBox *)p->rawptr;
		KQDialogButtonBox *qp = static_cast<KQDialogButtonBox*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QDialogButtonBox_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (p1->rawptr == p2->rawptr ? 0 : 1);
}

void KQDialogButtonBox::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

bool KQDialogButtonBox::event(QEvent *event)
{
	if (!dummy->eventDispatcher(event)) {
		QDialogButtonBox::event(event);
		return false;
	}
//	QDialogButtonBox::event(event);
	return true;
}

static knh_IntData_t QDialogButtonBoxConstInt[] = {
	{"WinLayout", QDialogButtonBox::WinLayout},
	{"MacLayout", QDialogButtonBox::MacLayout},
	{"KdeLayout", QDialogButtonBox::KdeLayout},
	{"GnomeLayout", QDialogButtonBox::GnomeLayout},
	{"InvalidRole", QDialogButtonBox::InvalidRole},
	{"AcceptRole", QDialogButtonBox::AcceptRole},
	{"RejectRole", QDialogButtonBox::RejectRole},
	{"DestructiveRole", QDialogButtonBox::DestructiveRole},
	{"ActionRole", QDialogButtonBox::ActionRole},
	{"HelpRole", QDialogButtonBox::HelpRole},
	{"YesRole", QDialogButtonBox::YesRole},
	{"NoRole", QDialogButtonBox::NoRole},
	{"ApplyRole", QDialogButtonBox::ApplyRole},
	{"ResetRole", QDialogButtonBox::ResetRole},
	{"Ok", QDialogButtonBox::Ok},
	{"Open", QDialogButtonBox::Open},
	{"Save", QDialogButtonBox::Save},
	{"Cancel", QDialogButtonBox::Cancel},
	{"Close", QDialogButtonBox::Close},
	{"Discard", QDialogButtonBox::Discard},
	{"Apply", QDialogButtonBox::Apply},
	{"Reset", QDialogButtonBox::Reset},
	{"RestoreDefaults", QDialogButtonBox::RestoreDefaults},
	{"Help", QDialogButtonBox::Help},
	{"SaveAll", QDialogButtonBox::SaveAll},
	{"Yes", QDialogButtonBox::Yes},
	{"YesToAll", QDialogButtonBox::YesToAll},
	{"No", QDialogButtonBox::No},
	{"NoToAll", QDialogButtonBox::NoToAll},
	{"Abort", QDialogButtonBox::Abort},
	{"Retry", QDialogButtonBox::Retry},
	{"Ignore", QDialogButtonBox::Ignore},
	{"NoButton", QDialogButtonBox::NoButton},
	{NULL, 0}
};

DEFAPI(void) constQDialogButtonBox(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QDialogButtonBoxConstInt);
}


DEFAPI(void) defQDialogButtonBox(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QDialogButtonBox";
	cdef->free = QDialogButtonBox_free;
	cdef->reftrace = QDialogButtonBox_reftrace;
	cdef->compareTo = QDialogButtonBox_compareTo;
}

//## QDialogButtonBoxStandardButtons QDialogButtonBoxStandardButtons.new(int value);
KMETHOD QDialogButtonBoxStandardButtons_new(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDialogButtonBox::StandardButton i = Int_to(QDialogButtonBox::StandardButton, sfp[1]);
	QDialogButtonBox::StandardButtons *ret_v = new QDialogButtonBox::StandardButtons(i);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	RETURN_(rptr);
}

//## QDialogButtonBoxStandardButtons QDialogButtonBoxStandardButtons.and(int mask);
KMETHOD QDialogButtonBoxStandardButtons_and(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDialogButtonBox::StandardButtons *qp = RawPtr_to(QDialogButtonBox::StandardButtons*, sfp[0]);
	if (qp != NULL) {
		int i = Int_to(int, sfp[1]);
		QDialogButtonBox::StandardButtons ret = ((*qp) & i);
		QDialogButtonBox::StandardButtons *ret_ = new QDialogButtonBox::StandardButtons(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QDialogButtonBoxStandardButtons QDialogButtonBoxStandardButtons.iand(QDialogButtonBox::QDialogButtonBoxStandardButtons other);
KMETHOD QDialogButtonBoxStandardButtons_iand(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDialogButtonBox::StandardButtons *qp = RawPtr_to(QDialogButtonBox::StandardButtons*, sfp[0]);
	if (qp != NULL) {
		QDialogButtonBox::StandardButtons *other = RawPtr_to(QDialogButtonBox::StandardButtons *, sfp[1]);
		*qp = ((*qp) & (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QDialogButtonBoxStandardButtons QDialogButtonBoxStandardButtons.or(QDialogButtonBoxStandardButtons f);
KMETHOD QDialogButtonBoxStandardButtons_or(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialogButtonBox::StandardButtons *qp = RawPtr_to(QDialogButtonBox::StandardButtons*, sfp[0]);
	if (qp != NULL) {
		QDialogButtonBox::StandardButtons *f = RawPtr_to(QDialogButtonBox::StandardButtons*, sfp[1]);
		QDialogButtonBox::StandardButtons ret = ((*qp) | (*f));
		QDialogButtonBox::StandardButtons *ret_ = new QDialogButtonBox::StandardButtons(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QDialogButtonBoxStandardButtons QDialogButtonBoxStandardButtons.ior(QDialogButtonBox::QDialogButtonBoxStandardButtons other);
KMETHOD QDialogButtonBoxStandardButtons_ior(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDialogButtonBox::StandardButtons *qp = RawPtr_to(QDialogButtonBox::StandardButtons*, sfp[0]);
	if (qp != NULL) {
		QDialogButtonBox::StandardButtons *other = RawPtr_to(QDialogButtonBox::StandardButtons *, sfp[1]);
		*qp = ((*qp) | (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QDialogButtonBoxStandardButtons QDialogButtonBoxStandardButtons.xor(QDialogButtonBoxStandardButtons f);
KMETHOD QDialogButtonBoxStandardButtons_xor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDialogButtonBox::StandardButtons *qp = RawPtr_to(QDialogButtonBox::StandardButtons*, sfp[0]);
	if (qp != NULL) {
		QDialogButtonBox::StandardButtons *f = RawPtr_to(QDialogButtonBox::StandardButtons*, sfp[1]);
		QDialogButtonBox::StandardButtons ret = ((*qp) ^ (*f));
		QDialogButtonBox::StandardButtons *ret_ = new QDialogButtonBox::StandardButtons(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QDialogButtonBoxStandardButtons QDialogButtonBoxStandardButtons.ixor(QDialogButtonBox::QDialogButtonBoxStandardButtons other);
KMETHOD QDialogButtonBoxStandardButtons_ixor(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDialogButtonBox::StandardButtons *qp = RawPtr_to(QDialogButtonBox::StandardButtons*, sfp[0]);
	if (qp != NULL) {
		QDialogButtonBox::StandardButtons *other = RawPtr_to(QDialogButtonBox::StandardButtons *, sfp[1]);
		*qp = ((*qp) ^ (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## boolean QDialogButtonBoxStandardButtons.testFlag(int flag);
KMETHOD QDialogButtonBoxStandardButtons_testFlag(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDialogButtonBox::StandardButtons *qp = RawPtr_to(QDialogButtonBox::StandardButtons *, sfp[0]);
	if (qp != NULL) {
		QDialogButtonBox::StandardButton flag = Int_to(QDialogButtonBox::StandardButton, sfp[1]);
		bool ret = qp->testFlag(flag);
		RETURNb_(ret);
	} else {
		RETURNb_(false);
	}
}

//## int QDialogButtonBoxStandardButtons.value();
KMETHOD QDialogButtonBoxStandardButtons_value(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDialogButtonBox::StandardButtons *qp = RawPtr_to(QDialogButtonBox::StandardButtons *, sfp[0]);
	if (qp != NULL) {
		int ret = int(*qp);
		RETURNi_(ret);
	} else {
		RETURNi_(0);
	}
}

static void QDialogButtonBoxStandardButtons_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (p->rawptr != NULL) {
		QDialogButtonBox::StandardButtons *qp = (QDialogButtonBox::StandardButtons *)p->rawptr;
		(void)qp;
		delete qp;
		p->rawptr = NULL;
	}
}

static void QDialogButtonBoxStandardButtons_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
	if (p->rawptr != NULL) {
		QDialogButtonBox::StandardButtons *qp = (QDialogButtonBox::StandardButtons *)p->rawptr;
		(void)qp;
	}
}

static int QDialogButtonBoxStandardButtons_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	if (p1->rawptr == NULL || p2->rawptr == NULL) {
		return 1;
	} else {
//		int v1 = int(*(QDialogButtonBox::StandardButtons*)p1->rawptr);
//		int v2 = int(*(QDialogButtonBox::StandardButtons*)p2->rawptr);
//		return (v1 == v2 ? 0 : 1);
		QDialogButtonBox::StandardButtons v1 = *(QDialogButtonBox::StandardButtons*)p1->rawptr;
		QDialogButtonBox::StandardButtons v2 = *(QDialogButtonBox::StandardButtons*)p2->rawptr;
//		return (v1 == v2 ? 0 : 1);
		return (v1 == v2 ? 0 : 1);

	}
}

DEFAPI(void) defQDialogButtonBoxStandardButtons(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QDialogButtonBoxStandardButtons";
	cdef->free = QDialogButtonBoxStandardButtons_free;
	cdef->reftrace = QDialogButtonBoxStandardButtons_reftrace;
	cdef->compareTo = QDialogButtonBoxStandardButtons_compareTo;
}

//QDir QDir.new(QDir dir);
KMETHOD QDir_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QDir  dir = *RawPtr_to(const QDir *, sfp[1]);
	KQDir *ret_v = new KQDir(dir);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}

/*
//QDir QDir.new(String path);
KMETHOD QDir_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QString path = String_to(const QString, sfp[1]);
	KQDir *ret_v = new KQDir(path);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
/*
//QDir QDir.new(String path, String nameFilter, QDirSortFlags sort);
KMETHOD QDir_new(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	const QString path = String_to(const QString, sfp[1]);
	const QString nameFilter = String_to(const QString, sfp[2]);
	initFlag(sort, QDir::SortFlags, sfp[3]);
	KQDir *ret_v = new KQDir(path, nameFilter, sort);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	ret_v->setSelf(rptr);
	RETURN_(rptr);
}
*/
//String QDir.absoluteFilePath(String fileName);
KMETHOD QDir_absoluteFilePath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		const QString fileName = String_to(const QString, sfp[1]);
		QString ret_v = qp->absoluteFilePath(fileName);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QDir.absolutePath();
KMETHOD QDir_absolutePath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		QString ret_v = qp->absolutePath();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QDir.canonicalPath();
KMETHOD QDir_canonicalPath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		QString ret_v = qp->canonicalPath();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QDir.cd(String dirName);
KMETHOD QDir_cd(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		const QString dirName = String_to(const QString, sfp[1]);
		bool ret_v = qp->cd(dirName);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QDir.cdUp();
KMETHOD QDir_cdUp(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		bool ret_v = qp->cdUp();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//int QDir.count();
KMETHOD QDir_count(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		uint ret_v = qp->count();
		uint *ret_v_ = new uint(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QDir.dirName();
KMETHOD QDir_dirName(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		QString ret_v = qp->dirName();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QDir.exists(String name);
KMETHOD QDir_exists(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		const QString name = String_to(const QString, sfp[1]);
		bool ret_v = qp->exists(name);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

/*
//boolean QDir.exists();
KMETHOD QDir_exists(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		bool ret_v = qp->exists();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}
*/
//String QDir.filePath(String fileName);
KMETHOD QDir_filePath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		const QString fileName = String_to(const QString, sfp[1]);
		QString ret_v = qp->filePath(fileName);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDirFilters QDir.getFilter();
KMETHOD QDir_getFilter(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		QDir::Filters ret_v = qp->filter();
		QDir::Filters *ret_v_ = new QDir::Filters(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QDir.isAbsolute();
KMETHOD QDir_isAbsolute(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isAbsolute();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QDir.isReadable();
KMETHOD QDir_isReadable(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isReadable();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QDir.isRelative();
KMETHOD QDir_isRelative(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isRelative();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QDir.isRoot();
KMETHOD QDir_isRoot(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		bool ret_v = qp->isRoot();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QDir.makeAbsolute();
KMETHOD QDir_makeAbsolute(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		bool ret_v = qp->makeAbsolute();
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QDir.mkdir(String dirName);
KMETHOD QDir_mkdir(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		const QString dirName = String_to(const QString, sfp[1]);
		bool ret_v = qp->mkdir(dirName);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QDir.mkpath(String dirPath);
KMETHOD QDir_mkpath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		const QString dirPath = String_to(const QString, sfp[1]);
		bool ret_v = qp->mkpath(dirPath);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//String QDir.getPath();
KMETHOD QDir_getPath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		QString ret_v = qp->path();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QDir.refresh();
KMETHOD QDir_refresh(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		qp->refresh();
	}
	RETURNvoid_();
}

//String QDir.relativeFilePath(String fileName);
KMETHOD QDir_relativeFilePath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		const QString fileName = String_to(const QString, sfp[1]);
		QString ret_v = qp->relativeFilePath(fileName);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QDir.remove(String fileName);
KMETHOD QDir_remove(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		const QString fileName = String_to(const QString, sfp[1]);
		bool ret_v = qp->remove(fileName);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QDir.rename(String oldName, String new_Name);
KMETHOD QDir_rename(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		const QString oldName = String_to(const QString, sfp[1]);
		const QString new_Name = String_to(const QString, sfp[2]);
		bool ret_v = qp->rename(oldName, new_Name);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QDir.rmdir(String dirName);
KMETHOD QDir_rmdir(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		const QString dirName = String_to(const QString, sfp[1]);
		bool ret_v = qp->rmdir(dirName);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QDir.rmpath(String dirPath);
KMETHOD QDir_rmpath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		const QString dirPath = String_to(const QString, sfp[1]);
		bool ret_v = qp->rmpath(dirPath);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//void QDir.setFilter(QDirFilters filters);
KMETHOD QDir_setFilter(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		initFlag(filters, QDir::Filters, sfp[1]);
		qp->setFilter(filters);
	}
	RETURNvoid_();
}

//void QDir.setPath(String path);
KMETHOD QDir_setPath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		const QString path = String_to(const QString, sfp[1]);
		qp->setPath(path);
	}
	RETURNvoid_();
}

//void QDir.setSorting(QDirSortFlags sort);
KMETHOD QDir_setSorting(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		initFlag(sort, QDir::SortFlags, sfp[1]);
		qp->setSorting(sort);
	}
	RETURNvoid_();
}

//QDirSortFlags QDir.getSorting();
KMETHOD QDir_getSorting(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *  qp = RawPtr_to(QDir *, sfp[0]);
	if (qp) {
		QDir::SortFlags ret_v = qp->sorting();
		QDir::SortFlags *ret_v_ = new QDir::SortFlags(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//void QDir.addSearchPath(String prefix, String path);
KMETHOD QDir_addSearchPath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString prefix = String_to(const QString, sfp[1]);
		const QString path = String_to(const QString, sfp[2]);
		QDir::addSearchPath(prefix, path);
	}
	RETURNvoid_();
}

//String QDir.cleanPath(String path);
KMETHOD QDir_cleanPath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString path = String_to(const QString, sfp[1]);
		QString ret_v = QDir::cleanPath(path);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDir QDir.getCurrent();
KMETHOD QDir_getCurrent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QDir ret_v = QDir::current();
		QDir *ret_v_ = new QDir(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QDir.currentPath();
KMETHOD QDir_currentPath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QString ret_v = QDir::currentPath();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QDir.fromNativeSeparators(String pathName);
KMETHOD QDir_fromNativeSeparators(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString pathName = String_to(const QString, sfp[1]);
		QString ret_v = QDir::fromNativeSeparators(pathName);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//QDir QDir.home();
KMETHOD QDir_home(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QDir ret_v = QDir::home();
		QDir *ret_v_ = new QDir(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QDir.homePath();
KMETHOD QDir_homePath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QString ret_v = QDir::homePath();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QDir.isAbsolutePath(String path);
KMETHOD QDir_isAbsolutePath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString path = String_to(const QString, sfp[1]);
		bool ret_v = QDir::isAbsolutePath(path);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QDir.isRelativePath(String path);
KMETHOD QDir_isRelativePath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString path = String_to(const QString, sfp[1]);
		bool ret_v = QDir::isRelativePath(path);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//boolean QDir.match(String filter, String fileName);
KMETHOD QDir_match(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString filter = String_to(const QString, sfp[1]);
		const QString fileName = String_to(const QString, sfp[2]);
		bool ret_v = QDir::match(filter, fileName);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//QDir QDir.root();
KMETHOD QDir_root(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QDir ret_v = QDir::root();
		QDir *ret_v_ = new QDir(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QDir.rootPath();
KMETHOD QDir_rootPath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QString ret_v = QDir::rootPath();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//QChar QDir.separator();
KMETHOD QDir_separator(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QChar ret_v = QDir::separator();
		QChar *ret_v_ = new QChar(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//boolean QDir.setCurrent(String path);
KMETHOD QDir_setCurrent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString path = String_to(const QString, sfp[1]);
		bool ret_v = QDir::setCurrent(path);
		RETURNb_(ret_v);
	} else {
		RETURNb_(false);
	}
}

//QDir QDir.temp();
KMETHOD QDir_temp(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QDir ret_v = QDir::temp();
		QDir *ret_v_ = new QDir(ret_v);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QDir.tempPath();
KMETHOD QDir_tempPath(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		QString ret_v = QDir::tempPath();
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//String QDir.toNativeSeparators(String pathName);
KMETHOD QDir_toNativeSeparators(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	if (true) {
		const QString pathName = String_to(const QString, sfp[1]);
		QString ret_v = QDir::toNativeSeparators(pathName);
		const char *ret_c = ret_v.toLocal8Bit().data();
		RETURN_(new_String(ctx, ret_c));
	} else {
		RETURN_(KNH_NULL);
	}
}

//Array<String> QDir.parents();
KMETHOD QDir_parents(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir *qp = RawPtr_to(QDir*, sfp[0]);
	if (qp != NULL) {
		int size = 10;
		kArray *a = new_Array0(ctx, size);
		const knh_ClassTBL_t *ct = sfp[0].p->h.cTBL;
		while(ct->supcid != CLASS_Object) {
			ct = ct->supTBL;
			knh_Array_add(ctx, a, (kObject *)ct->lname);
		}
		RETURN_(a);
	} else {
		RETURN_(KNH_NULL);
	}
}

DummyQDir::DummyQDir()
{
	CTX lctx = knh_getCurrentContext();
	(void)lctx;
	self = NULL;
	event_map = new map<string, kFunc *>();
	slot_map = new map<string, kFunc *>();
}
DummyQDir::~DummyQDir()
{
	delete event_map;
	delete slot_map;
	event_map = NULL;
	slot_map = NULL;
}

void DummyQDir::setSelf(kRawPtr *ptr)
{
	DummyQDir::self = ptr;
}

bool DummyQDir::eventDispatcher(QEvent *event)
{
	bool ret = true;
	switch (event->type()) {
	default:
		ret = false;
		break;
	}
	return ret;
}

bool DummyQDir::addEvent(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDir::event_map->bigin();
	if ((itr = DummyQDir::event_map->find(str)) == DummyQDir::event_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*event_map)[str], callback_func);
		return true;
	}
}

bool DummyQDir::signalConnect(kFunc *callback_func, string str)
{
	std::map<string, kFunc*>::iterator itr;// = DummyQDir::slot_map->bigin();
	if ((itr = DummyQDir::slot_map->find(str)) == DummyQDir::slot_map->end()) {
		bool ret = false;
		return ret;
	} else {
		KNH_INITv((*slot_map)[str], callback_func);
		return true;
	}
}

kObject** DummyQDir::reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
//	fprintf(stderr, "DummyQDir::reftrace p->rawptr=[%p]\n", p->rawptr);


	return tail_;
}

void DummyQDir::connection(QObject *o)
{
	QDir *p = dynamic_cast<QDir*>(o);
	if (p != NULL) {
	}
}

KQDir::KQDir(const QDir dir) : QDir(dir)
{
	magic_num = G_MAGIC_NUM;
	self = NULL;
	dummy = new DummyQDir();
}

KQDir::~KQDir()
{
	delete dummy;
	dummy = NULL;
}
KMETHOD QDir_addEvent(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDir *qp = RawPtr_to(KQDir *, sfp[0]);
	const char *event_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->event_map->find(event_name) == qp->event_map->end()) {
//			fprintf(stderr, "WARNING:[QDir]unknown event name [%s]\n", event_name);
//			return;
//		}
		string str = string(event_name);
//		KNH_INITv((*(qp->event_map))[event_name], callback_func);
		if (!qp->dummy->addEvent(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDir]unknown event name [%s]\n", event_name);
			return;
		}
	}
	RETURNvoid_();
}
KMETHOD QDir_signalConnect(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	KQDir *qp = RawPtr_to(KQDir *, sfp[0]);
	const char *signal_name = String_to(const char *, sfp[1]);
	kFunc *callback_func = sfp[2].fo;
	if (qp != NULL) {
//		if (qp->slot_map->find(signal_name) == qp->slot_map->end()) {
//			fprintf(stderr, "WARNING:[QDir]unknown signal name [%s]\n", signal_name);
//			return;
//		}
		string str = string(signal_name);
//		KNH_INITv((*(qp->slot_map))[signal_name], callback_func);
		if (!qp->dummy->signalConnect(callback_func, str)) {
			fprintf(stderr, "WARNING:[QDir]unknown signal name [%s]\n", signal_name);
			return;
		}
	}
	RETURNvoid_();
}

static void QDir_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (!exec_flag) return;
	if (p->rawptr != NULL) {
		KQDir *qp = (KQDir *)p->rawptr;
		if (qp->magic_num == G_MAGIC_NUM) {
			delete qp;
			p->rawptr = NULL;
		} else {
			delete (QDir*)qp;
			p->rawptr = NULL;
		}
	}
}
static void QDir_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	if (p->rawptr != NULL) {
//		KQDir *qp = (KQDir *)p->rawptr;
		KQDir *qp = static_cast<KQDir*>(p->rawptr);
		qp->dummy->reftrace(ctx, p, tail_);
	}
}

static int QDir_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	return (*static_cast<QDir*>(p1->rawptr) == *static_cast<QDir*>(p2->rawptr) ? 0 : 1);
}

void KQDir::setSelf(kRawPtr *ptr)
{
	self = ptr;
	dummy->setSelf(ptr);
}

static knh_IntData_t QDirConstInt[] = {
	{"Dirs", QDir::Dirs},
	{"AllDirs", QDir::AllDirs},
	{"Files", QDir::Files},
	{"Drives", QDir::Drives},
	{"NoSymLinks", QDir::NoSymLinks},
	{"NoDotAndDotDot", QDir::NoDotAndDotDot},
	{"NoDot", QDir::NoDot},
	{"NoDotDot", QDir::NoDotDot},
	{"AllEntries", QDir::AllEntries},
	{"Readable", QDir::Readable},
	{"Writable", QDir::Writable},
	{"Executable", QDir::Executable},
	{"Modified", QDir::Modified},
	{"Hidden", QDir::Hidden},
	{"System", QDir::System},
	{"CaseSensitive", QDir::CaseSensitive},
	{"Name", QDir::Name},
	{"Time", QDir::Time},
	{"Size", QDir::Size},
	{"Type", QDir::Type},
	{"Unsorted", QDir::Unsorted},
	{"NoSort", QDir::NoSort},
	{"DirsFirst", QDir::DirsFirst},
	{"DirsLast", QDir::DirsLast},
	{"Reversed", QDir::Reversed},
	{"IgnoreCase", QDir::IgnoreCase},
	{"LocaleAware", QDir::LocaleAware},
	{NULL, 0}
};

DEFAPI(void) constQDir(CTX ctx, kclass_t cid, const knh_LoaderAPI_t *kapi) {
	kapi->loadClassIntConst(ctx, cid, QDirConstInt);
}


DEFAPI(void) defQDir(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QDir";
	cdef->free = QDir_free;
	cdef->reftrace = QDir_reftrace;
	cdef->compareTo = QDir_compareTo;
}

//## QDirFilters QDirFilters.new(int value);
KMETHOD QDirFilters_new(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDir::Filter i = Int_to(QDir::Filter, sfp[1]);
	QDir::Filters *ret_v = new QDir::Filters(i);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	RETURN_(rptr);
}

//## QDirFilters QDirFilters.and(int mask);
KMETHOD QDirFilters_and(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDir::Filters *qp = RawPtr_to(QDir::Filters*, sfp[0]);
	if (qp != NULL) {
		int i = Int_to(int, sfp[1]);
		QDir::Filters ret = ((*qp) & i);
		QDir::Filters *ret_ = new QDir::Filters(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QDirFilters QDirFilters.iand(QDir::QDirFilters other);
KMETHOD QDirFilters_iand(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDir::Filters *qp = RawPtr_to(QDir::Filters*, sfp[0]);
	if (qp != NULL) {
		QDir::Filters *other = RawPtr_to(QDir::Filters *, sfp[1]);
		*qp = ((*qp) & (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QDirFilters QDirFilters.or(QDirFilters f);
KMETHOD QDirFilters_or(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir::Filters *qp = RawPtr_to(QDir::Filters*, sfp[0]);
	if (qp != NULL) {
		QDir::Filters *f = RawPtr_to(QDir::Filters*, sfp[1]);
		QDir::Filters ret = ((*qp) | (*f));
		QDir::Filters *ret_ = new QDir::Filters(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QDirFilters QDirFilters.ior(QDir::QDirFilters other);
KMETHOD QDirFilters_ior(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDir::Filters *qp = RawPtr_to(QDir::Filters*, sfp[0]);
	if (qp != NULL) {
		QDir::Filters *other = RawPtr_to(QDir::Filters *, sfp[1]);
		*qp = ((*qp) | (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QDirFilters QDirFilters.xor(QDirFilters f);
KMETHOD QDirFilters_xor(CTX ctx, ksfp_t *sfp _RIX)
{
	(void)ctx;
	QDir::Filters *qp = RawPtr_to(QDir::Filters*, sfp[0]);
	if (qp != NULL) {
		QDir::Filters *f = RawPtr_to(QDir::Filters*, sfp[1]);
		QDir::Filters ret = ((*qp) ^ (*f));
		QDir::Filters *ret_ = new QDir::Filters(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QDirFilters QDirFilters.ixor(QDir::QDirFilters other);
KMETHOD QDirFilters_ixor(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDir::Filters *qp = RawPtr_to(QDir::Filters*, sfp[0]);
	if (qp != NULL) {
		QDir::Filters *other = RawPtr_to(QDir::Filters *, sfp[1]);
		*qp = ((*qp) ^ (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## boolean QDirFilters.testFlag(int flag);
KMETHOD QDirFilters_testFlag(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDir::Filters *qp = RawPtr_to(QDir::Filters *, sfp[0]);
	if (qp != NULL) {
		QDir::Filter flag = Int_to(QDir::Filter, sfp[1]);
		bool ret = qp->testFlag(flag);
		RETURNb_(ret);
	} else {
		RETURNb_(false);
	}
}

//## int QDirFilters.value();
KMETHOD QDirFilters_value(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDir::Filters *qp = RawPtr_to(QDir::Filters *, sfp[0]);
	if (qp != NULL) {
		int ret = int(*qp);
		RETURNi_(ret);
	} else {
		RETURNi_(0);
	}
}

static void QDirFilters_free(CTX ctx, kRawPtr *p)
{
	(void)ctx;
	if (p->rawptr != NULL) {
		QDir::Filters *qp = (QDir::Filters *)p->rawptr;
		(void)qp;
		delete qp;
		p->rawptr = NULL;
	}
}

static void QDirFilters_reftrace(CTX ctx, kRawPtr *p FTRARG)
{
	(void)ctx; (void)p; (void)tail_;
	if (p->rawptr != NULL) {
		QDir::Filters *qp = (QDir::Filters *)p->rawptr;
		(void)qp;
	}
}

static int QDirFilters_compareTo(kRawPtr *p1, kRawPtr *p2)
{
	if (p1->rawptr == NULL || p2->rawptr == NULL) {
		return 1;
	} else {
//		int v1 = int(*(QDir::Filters*)p1->rawptr);
//		int v2 = int(*(QDir::Filters*)p2->rawptr);
//		return (v1 == v2 ? 0 : 1);
		QDir::Filters v1 = *(QDir::Filters*)p1->rawptr;
		QDir::Filters v2 = *(QDir::Filters*)p2->rawptr;
//		return (v1 == v2 ? 0 : 1);
		return (v1 == v2 ? 0 : 1);

	}
}

DEFAPI(void) defQDirFilters(CTX ctx, kclass_t cid, kclassdef_t *cdef)
{
	(void)ctx; (void) cid;
	cdef->name = "QDirFilters";
	cdef->free = QDirFilters_free;
	cdef->reftrace = QDirFilters_reftrace;
	cdef->compareTo = QDirFilters_compareTo;
}
//## QDirSortFlags QDirSortFlags.new(int value);
KMETHOD QDirSortFlags_new(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDir::SortFlag i = Int_to(QDir::SortFlag, sfp[1]);
	QDir::SortFlags *ret_v = new QDir::SortFlags(i);
	kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_v, NULL);
	RETURN_(rptr);
}

//## QDirSortFlags QDirSortFlags.and(int mask);
KMETHOD QDirSortFlags_and(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDir::SortFlags *qp = RawPtr_to(QDir::SortFlags*, sfp[0]);
	if (qp != NULL) {
		int i = Int_to(int, sfp[1]);
		QDir::SortFlags ret = ((*qp) & i);
		QDir::SortFlags *ret_ = new QDir::SortFlags(ret);
		kRawPtr *rptr = new_ReturnCppObject(ctx, sfp, ret_, NULL);
		RETURN_(rptr);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QDirSortFlags QDirSortFlags.iand(QDir::QDirSortFlags other);
KMETHOD QDirSortFlags_iand(CTX ctx, ksfp_t *sfp _RIX) {
	(void)ctx;
	QDir::SortFlags *qp = RawPtr_to(QDir::SortFlags*, sfp[0]);
	if (qp != NULL) {
		QDir::SortFlags *other = RawPtr_to(QDir::SortFlags *, sfp[1]);
		*qp = ((*qp) & (*other));
		RETURN_(qp);
	} else {
		RETURN_(KNH_NULL);
	}
}

//## QDirSortFlags QDirSortFlags.or(QDirS