'\"-
'\" Copyright (c)1997-2005 Hartmut Brandt.
'\" All rights reserved.
'\"
'\" Author: Harti Brandt <harti@freebsd.org>
'\"
'\" Redistribution and use in source and binary forms, with or without
'\" modification, are permitted provided that the following conditions
'\" are met:
'\" 1. Redistributions of source code must retain the above copyright
'\"    notice, this list of conditions and the following disclaimer.
'\" 2. Redistributions in binary form must reproduce the above copyright
'\"    notice, this list of conditions and the following disclaimer in the
'\"    documentation and/or other materials provided with the distribution.
'\"
'\" THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND
'\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
'\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
'\" ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
'\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
'\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
'\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
'\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
'\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
'\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
'\" SUCH DAMAGE.
'\"
'\" $Begemot: libbegemot/cstrc.man,v 1.5 2005/06/01 07:50:35 brandt_h Exp $
'\"
.TH cstrc l "9 Oct 1996" "BEGEMOT" "BEGEMOT Library"
.SH NAME
cstrc, cstrd \- convert between ANSI C-strings and strings
.SH SYNOPSIS
.LP
.B "# include <begemot.h>"
.LP
.BI "char * cstrc(char **" "pstr" ", char " "delim" ", size_t"
.BI "*" "plen" ");"
.LP
.BI "char * cstrd(const char *" "str" ", char " "delim" ", size_t"
.IB "len" ");"
.LP
.B "int cstrwarn;"
.SH DESCRIPTION
The
.B cstrc
function converts a string as specified in the ANSI C-standard to the usual internal
representation. All escape sequences are (hopefully) recognized. Setting
.B cstrwarn
to any non-zero value enables some warning messages, which are emitted via
.BR warn (l).
.I Pstr
is the address of a pointer to the string to be parsed.
.I Delim
is the character at which the parsing should stop. It should be
a single or a double quote character. Parsing stops also if a NUL character
is found. *
.I pstr
is left pointing to the terminating character. At entry to the function *
.I pstr
should point behind the initial delimiter.
*
.I plen
will hold the number of bytes in the output string. The string
will be NUL termninated, but note, that it may contain embedded NULs.
.P
.B Cstrd
prints a string with non-printable characters converted to escape sequences.
.I delim
is escaped in the output string (usually '\\'' or '"').
.P
The user is responsible the deallocate the memory returned by
.B cstrc
and
.BR cstrd .
Both functions call
.BR xalloc (l)
and
.BR xrealloc (l)
and therefor end in
.BR panic (l)
if not enough memory is available.
.SH "RETURN VALUE"
Both functions return allocated memory that must be freed by the caller. They may
never return NULL.
.SH "SEE ALSO"
.BR panic (l),
.BR xalloc (l),
.BR xrealloc (3b)
.SH BUGS
Certainly.
