'\"-
'\" Copyright (c)1997-2005 Hartmut Brandt.
'\" All rights reserved.
'\"
'\" Author: Harti Brandt <harti@freebsd.org>
'\"
'\" Redistribution and use in source and binary forms, with or without
'\" modification, are permitted provided that the following conditions
'\" are met:
'\" 1. Redistributions of source code must retain the above copyright
'\"    notice, this list of conditions and the following disclaimer.
'\" 2. Redistributions in binary form must reproduce the above copyright
'\"    notice, this list of conditions and the following disclaimer in the
'\"    documentation and/or other materials provided with the distribution.
'\"
'\" THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND
'\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
'\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
'\" ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
'\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
'\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
'\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
'\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
'\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
'\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
'\" SUCH DAMAGE.
'\"
'\" $Begemot: libbegemot/strsave.man,v 1.3 2005/06/01 07:51:12 brandt_h Exp $
'\"
.TH strsave l "5 June 1996" "BEGEMOT" "BEGEMOT Library"
.SH NAME
strsave, xstrsave - return a fresh copy of a string
.SH SYNOPSIS
.nf
.LP
.B "# include <begemot.h>"
.LP
.BR "char * strsave(const char *" "str" ");"
.LP
.BR "char * xstrsave(const char *" "str" ");"
.fi
.SH DESCRIPTION
These functions copy the argument string
.I str
into a new memory area obtained from
.BR malloc (3C).
.BR xstrsave (l)
calls
.BR xalloc (l),
so the program exits with a fatal error message if
.BR malloc (3C)
fails.
.SH "RETURN VALUE"
.BR strsave (l)
returns a pointer to the new string or
.B NULL
if
.BR malloc (3C)
has failed.
.BR xstrsave (l)
never returns
.BR NULL .
.SH "SEE ALSO"
.BR malloc (3C),
.BR xalloc (l)
