'\"-
'\" Copyright (c)1997-2005 Hartmut Brandt.
'\" All rights reserved.
'\"
'\" Author: Harti Brandt <harti@freebsd.org>
'\"
'\" Redistribution and use in source and binary forms, with or without
'\" modification, are permitted provided that the following conditions
'\" are met:
'\" 1. Redistributions of source code must retain the above copyright
'\"    notice, this list of conditions and the following disclaimer.
'\" 2. Redistributions in binary form must reproduce the above copyright
'\"    notice, this list of conditions and the following disclaimer in the
'\"    documentation and/or other materials provided with the distribution.
'\"
'\" THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND
'\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
'\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
'\" ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
'\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
'\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
'\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
'\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
'\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
'\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
'\" SUCH DAMAGE.
'\"
'\" $Begemot: libbegemot/strtrimsp.man,v 1.3 2005/06/01 07:51:13 brandt_h Exp $
'\"
.TH strtrimsp l "23 August 1997" "BEGEMOT" "BEGEMOT Library"
.SH NAME
strtrimsp - trim leading and/or trailing whitespace from a string
.SH SYNOPSIS
.nf
.LP
.B "# include <begemot.h>"
.LP
.BR "void strtrimsp(char **" "pstr" ", int " "which" ");"
.fi
.SH DESCRIPTION
This function trims whitespace from the string pointed to by
.IR "*pstr" .
.I "pstr"
is a pointer to the string pointer. The string pointer may be
changed by the function, if leading whitespace is removed.
If
.I which
is 0, only leading whitespace is removed, if
.I which
is 1, only trailing whitespace is removed. For all
other values of
.I which
both ends are trimmed.
Whitespaceness is determined by
.BR isspace (3).
.SH "SEE ALSO"
.BR ctype (3),
