/**
 * @file
 * @brief     Generated functions to emit code for assembler ir nodes.
 * @note      DO NOT EDIT THIS FILE, your changes will be lost.
 *            Edit libfirm/ir/be/TEMPLATE/TEMPLATE_spec.pl instead.
 *            created by: libfirm/ir/be/scripts/generate_emitter.pl libfirm/ir/be/TEMPLATE/TEMPLATE_spec.pl libfirm/ir/be/TEMPLATE
 * @date      Tue Jan 20 10:58:00 2009
 */
#include "config.h"

#include <stdio.h>

#include "irnode.h"
#include "irop_t.h"
#include "irprog_t.h"

#include "gen_TEMPLATE_emitter.h"
#include "TEMPLATE_new_nodes.h"
#include "TEMPLATE_emitter.h"

static void emit_TEMPLATE_fConst(const ir_node *node) {
	be_emit_cstring("\tfmov ");
	TEMPLATE_emit_immediate(node);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_fMul(const ir_node *node) {
	be_emit_cstring("\tfmul ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_source_register(node, 1);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Or(const ir_node *node) {
	be_emit_cstring("\tor ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_source_register(node, 1);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Inc(const ir_node *node) {
	be_emit_cstring("\tinc ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_And_i(const ir_node *node) {
	be_emit_cstring("\tand ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_immediate(node);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_fAdd(const ir_node *node) {
	be_emit_cstring("\tfadd ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_source_register(node, 1);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Shl(const ir_node *node) {
	be_emit_cstring("\tshl ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_source_register(node, 1);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Add_i(const ir_node *node) {
	be_emit_cstring("\tadd ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_immediate(node);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Add(const ir_node *node) {
	be_emit_cstring("\tadd ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_source_register(node, 1);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_RotL(const ir_node *node) {
	be_emit_cstring("\trol ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_source_register(node, 1);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_fLoad(const ir_node *node) {
	be_emit_cstring("\tfmov (");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring("), ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_fMin(const ir_node *node) {
	be_emit_cstring("\tfmin ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_source_register(node, 1);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Or_i(const ir_node *node) {
	be_emit_cstring("\tor ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_immediate(node);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_fDiv(const ir_node *node) {
	be_emit_cstring("\tfdiv ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_source_register(node, 1);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Sub(const ir_node *node) {
	be_emit_cstring("\tsub ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_source_register(node, 1);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Mul(const ir_node *node) {
	be_emit_cstring("\tmul ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_source_register(node, 1);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Sub_i(const ir_node *node) {
	be_emit_cstring("\tsubl ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_immediate(node);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Shr(const ir_node *node) {
	be_emit_cstring("\tshr ");
	TEMPLATE_emit_source_register(node, 1);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_RotR(const ir_node *node) {
	be_emit_cstring("\tror ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_source_register(node, 1);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_RotL_i(const ir_node *node) {
	be_emit_cstring("\trol ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_immediate(node);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Mul_i(const ir_node *node) {
	be_emit_cstring("\tmul ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_immediate(node);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Eor_i(const ir_node *node) {
	be_emit_cstring("\txor ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_immediate(node);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Dec(const ir_node *node) {
	be_emit_cstring("\tdec ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Shl_i(const ir_node *node) {
	be_emit_cstring("\tshl ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_immediate(node);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Not(const ir_node *node) {
	be_emit_cstring("\tnot ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_fMinus(const ir_node *node) {
	be_emit_cstring("\tfneg ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_fMax(const ir_node *node) {
	be_emit_cstring("\tfmax ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_source_register(node, 1);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Store(const ir_node *node) {
	be_emit_cstring("\tmovl ");
	TEMPLATE_emit_source_register(node, 1);
	be_emit_cstring(", (");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_char(')');
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_And(const ir_node *node) {
	be_emit_cstring("\tand ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_source_register(node, 1);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_fStore(const ir_node *node) {
	be_emit_cstring("\tfmov ");
	TEMPLATE_emit_source_register(node, 1);
	be_emit_cstring(", (");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_char(')');
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_fSub(const ir_node *node) {
	be_emit_cstring("\tfsub ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_source_register(node, 1);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Minus(const ir_node *node) {
	be_emit_cstring("\tneg ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Eor(const ir_node *node) {
	be_emit_cstring("\txor ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_source_register(node, 1);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Const(const ir_node *node) {
	be_emit_cstring("\tmov ");
	TEMPLATE_emit_immediate(node);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Load(const ir_node *node) {
	be_emit_cstring("\tmov (");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring("), ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_TEMPLATE_Shr_i(const ir_node *node) {
	be_emit_cstring("\tshr ");
	TEMPLATE_emit_source_register(node, 0);
	be_emit_cstring(", ");
	TEMPLATE_emit_immediate(node);
	be_emit_cstring(", ");
	TEMPLATE_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

/**
 * Enters the emitter functions for handled nodes into the generic
 * pointer of an opcode.
 */
void TEMPLATE_register_spec_emitters(void) {

#define BE_EMIT(a) op_TEMPLATE_##a->ops.generic = (op_func)emit_TEMPLATE_##a

  /* generated emitter functions */
  BE_EMIT(fConst);
  BE_EMIT(fMul);
  BE_EMIT(Or);
  BE_EMIT(Inc);
  BE_EMIT(And_i);
  BE_EMIT(fAdd);
  BE_EMIT(Shl);
  BE_EMIT(Add_i);
  BE_EMIT(Add);
  BE_EMIT(RotL);
  BE_EMIT(fLoad);
  BE_EMIT(fMin);
  BE_EMIT(Or_i);
  BE_EMIT(fDiv);
  BE_EMIT(Sub);
  BE_EMIT(Mul);
  BE_EMIT(Sub_i);
  BE_EMIT(Shr);
  BE_EMIT(RotR);
  BE_EMIT(RotL_i);
  BE_EMIT(Mul_i);
  BE_EMIT(Eor_i);
  BE_EMIT(Dec);
  BE_EMIT(Shl_i);
  BE_EMIT(Not);
  BE_EMIT(fMinus);
  BE_EMIT(fMax);
  BE_EMIT(Store);
  BE_EMIT(And);
  BE_EMIT(fStore);
  BE_EMIT(fSub);
  BE_EMIT(Minus);
  BE_EMIT(Eor);
  BE_EMIT(Const);
  BE_EMIT(Load);
  BE_EMIT(Shr_i);

#undef BE_EMIT
}

