#include "gen_TEMPLATE_regalloc_if.h"

static int cmp_attr_TEMPLATE_fConst(ir_node *a, ir_node *b) {
	(void) a;
	(void) b;
	
	/* TODO: compare fConst attributes */
	return 1;

}

static int cmp_attr_TEMPLATE_Const(ir_node *a, ir_node *b) {
	(void) a;
	(void) b;
	
	/* TODO: compare Const attributes */
    return 1;

}


ir_op *op_TEMPLATE_fConst = NULL;
ir_op *op_TEMPLATE_fMul = NULL;
ir_op *op_TEMPLATE_Or = NULL;
ir_op *op_TEMPLATE_Inc = NULL;
ir_op *op_TEMPLATE_And_i = NULL;
ir_op *op_TEMPLATE_fAdd = NULL;
ir_op *op_TEMPLATE_Shl = NULL;
ir_op *op_TEMPLATE_Add_i = NULL;
ir_op *op_TEMPLATE_Add = NULL;
ir_op *op_TEMPLATE_RotL = NULL;
ir_op *op_TEMPLATE_fLoad = NULL;
ir_op *op_TEMPLATE_fMin = NULL;
ir_op *op_TEMPLATE_Or_i = NULL;
ir_op *op_TEMPLATE_fDiv = NULL;
ir_op *op_TEMPLATE_Sub = NULL;
ir_op *op_TEMPLATE_Mul = NULL;
ir_op *op_TEMPLATE_Sub_i = NULL;
ir_op *op_TEMPLATE_Shr = NULL;
ir_op *op_TEMPLATE_RotR = NULL;
ir_op *op_TEMPLATE_RotL_i = NULL;
ir_op *op_TEMPLATE_Mul_i = NULL;
ir_op *op_TEMPLATE_Eor_i = NULL;
ir_op *op_TEMPLATE_Dec = NULL;
ir_op *op_TEMPLATE_Shl_i = NULL;
ir_op *op_TEMPLATE_Not = NULL;
ir_op *op_TEMPLATE_fMinus = NULL;
ir_op *op_TEMPLATE_fMax = NULL;
ir_op *op_TEMPLATE_Store = NULL;
ir_op *op_TEMPLATE_And = NULL;
ir_op *op_TEMPLATE_fStore = NULL;
ir_op *op_TEMPLATE_fSub = NULL;
ir_op *op_TEMPLATE_Minus = NULL;
ir_op *op_TEMPLATE_Eor = NULL;
ir_op *op_TEMPLATE_Const = NULL;
ir_op *op_TEMPLATE_Load = NULL;
ir_op *op_TEMPLATE_Shr_i = NULL;

ir_op *get_op_TEMPLATE_fConst(void)         { return op_TEMPLATE_fConst; }
int    is_TEMPLATE_fConst(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_fConst; }

ir_op *get_op_TEMPLATE_fMul(void)         { return op_TEMPLATE_fMul; }
int    is_TEMPLATE_fMul(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_fMul; }

ir_op *get_op_TEMPLATE_Or(void)         { return op_TEMPLATE_Or; }
int    is_TEMPLATE_Or(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Or; }

ir_op *get_op_TEMPLATE_Inc(void)         { return op_TEMPLATE_Inc; }
int    is_TEMPLATE_Inc(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Inc; }

ir_op *get_op_TEMPLATE_And_i(void)         { return op_TEMPLATE_And_i; }
int    is_TEMPLATE_And_i(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_And_i; }

ir_op *get_op_TEMPLATE_fAdd(void)         { return op_TEMPLATE_fAdd; }
int    is_TEMPLATE_fAdd(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_fAdd; }

ir_op *get_op_TEMPLATE_Shl(void)         { return op_TEMPLATE_Shl; }
int    is_TEMPLATE_Shl(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Shl; }

ir_op *get_op_TEMPLATE_Add_i(void)         { return op_TEMPLATE_Add_i; }
int    is_TEMPLATE_Add_i(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Add_i; }

ir_op *get_op_TEMPLATE_Add(void)         { return op_TEMPLATE_Add; }
int    is_TEMPLATE_Add(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Add; }

ir_op *get_op_TEMPLATE_RotL(void)         { return op_TEMPLATE_RotL; }
int    is_TEMPLATE_RotL(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_RotL; }

ir_op *get_op_TEMPLATE_fLoad(void)         { return op_TEMPLATE_fLoad; }
int    is_TEMPLATE_fLoad(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_fLoad; }

ir_op *get_op_TEMPLATE_fMin(void)         { return op_TEMPLATE_fMin; }
int    is_TEMPLATE_fMin(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_fMin; }

ir_op *get_op_TEMPLATE_Or_i(void)         { return op_TEMPLATE_Or_i; }
int    is_TEMPLATE_Or_i(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Or_i; }

ir_op *get_op_TEMPLATE_fDiv(void)         { return op_TEMPLATE_fDiv; }
int    is_TEMPLATE_fDiv(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_fDiv; }

ir_op *get_op_TEMPLATE_Sub(void)         { return op_TEMPLATE_Sub; }
int    is_TEMPLATE_Sub(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Sub; }

ir_op *get_op_TEMPLATE_Mul(void)         { return op_TEMPLATE_Mul; }
int    is_TEMPLATE_Mul(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Mul; }

ir_op *get_op_TEMPLATE_Sub_i(void)         { return op_TEMPLATE_Sub_i; }
int    is_TEMPLATE_Sub_i(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Sub_i; }

ir_op *get_op_TEMPLATE_Shr(void)         { return op_TEMPLATE_Shr; }
int    is_TEMPLATE_Shr(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Shr; }

ir_op *get_op_TEMPLATE_RotR(void)         { return op_TEMPLATE_RotR; }
int    is_TEMPLATE_RotR(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_RotR; }

ir_op *get_op_TEMPLATE_RotL_i(void)         { return op_TEMPLATE_RotL_i; }
int    is_TEMPLATE_RotL_i(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_RotL_i; }

ir_op *get_op_TEMPLATE_Mul_i(void)         { return op_TEMPLATE_Mul_i; }
int    is_TEMPLATE_Mul_i(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Mul_i; }

ir_op *get_op_TEMPLATE_Eor_i(void)         { return op_TEMPLATE_Eor_i; }
int    is_TEMPLATE_Eor_i(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Eor_i; }

ir_op *get_op_TEMPLATE_Dec(void)         { return op_TEMPLATE_Dec; }
int    is_TEMPLATE_Dec(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Dec; }

ir_op *get_op_TEMPLATE_Shl_i(void)         { return op_TEMPLATE_Shl_i; }
int    is_TEMPLATE_Shl_i(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Shl_i; }

ir_op *get_op_TEMPLATE_Not(void)         { return op_TEMPLATE_Not; }
int    is_TEMPLATE_Not(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Not; }

ir_op *get_op_TEMPLATE_fMinus(void)         { return op_TEMPLATE_fMinus; }
int    is_TEMPLATE_fMinus(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_fMinus; }

ir_op *get_op_TEMPLATE_fMax(void)         { return op_TEMPLATE_fMax; }
int    is_TEMPLATE_fMax(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_fMax; }

ir_op *get_op_TEMPLATE_Store(void)         { return op_TEMPLATE_Store; }
int    is_TEMPLATE_Store(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Store; }

ir_op *get_op_TEMPLATE_And(void)         { return op_TEMPLATE_And; }
int    is_TEMPLATE_And(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_And; }

ir_op *get_op_TEMPLATE_fStore(void)         { return op_TEMPLATE_fStore; }
int    is_TEMPLATE_fStore(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_fStore; }

ir_op *get_op_TEMPLATE_fSub(void)         { return op_TEMPLATE_fSub; }
int    is_TEMPLATE_fSub(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_fSub; }

ir_op *get_op_TEMPLATE_Minus(void)         { return op_TEMPLATE_Minus; }
int    is_TEMPLATE_Minus(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Minus; }

ir_op *get_op_TEMPLATE_Eor(void)         { return op_TEMPLATE_Eor; }
int    is_TEMPLATE_Eor(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Eor; }

ir_op *get_op_TEMPLATE_Const(void)         { return op_TEMPLATE_Const; }
int    is_TEMPLATE_Const(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Const; }

ir_op *get_op_TEMPLATE_Load(void)         { return op_TEMPLATE_Load; }
int    is_TEMPLATE_Load(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Load; }

ir_op *get_op_TEMPLATE_Shr_i(void)         { return op_TEMPLATE_Shr_i; }
int    is_TEMPLATE_Shr_i(const ir_node *n) { return get_TEMPLATE_irn_opcode(n) == iro_TEMPLATE_Shr_i; }



static int TEMPLATE_opcode_start = -1;
static int TEMPLATE_opcode_end   = -1;


/** A tag for the TEMPLATE opcodes. Note that the address is used as a tag value, NOT the FOURCC code. */
#define TEMPLATE_op_tag FOURCC('T', 'E', 'M', 'P')

/** Return the opcode number of the first TEMPLATE opcode. */
int get_TEMPLATE_opcode_first(void) {
	return TEMPLATE_opcode_start;
}

/** Return the opcode number of the last TEMPLATE opcode + 1. */
int get_TEMPLATE_opcode_last(void) {
	return TEMPLATE_opcode_end;
}

/** Return 1 if the given opcode is a TEMPLATE machine op, 0 otherwise */
int is_TEMPLATE_op(const ir_op *op) {
	return get_op_tag(op) == TEMPLATE_op_tag;
}

/** Return 1 if the given node is a TEMPLATE machine node, 0 otherwise */
int is_TEMPLATE_irn(const ir_node *node) {
	return is_TEMPLATE_op(get_irn_op(node));
}

int get_TEMPLATE_irn_opcode(const ir_node *node) {
	if (is_TEMPLATE_irn(node))
		return get_irn_opcode(node) - TEMPLATE_opcode_start;
	return -1;
}

#ifdef BIT
#undef BIT
#endif
#define BIT(x)  (1 << (x % 32))


static const arch_register_req_t TEMPLATE_requirements_floating_point_floating_point = {
	arch_register_req_type_normal,
	& TEMPLATE_reg_classes[CLASS_TEMPLATE_floating_point],
	NULL,        /* limit bitset */
	0,           /* same pos */
	0            /* different pos */
};


static const arch_register_req_t TEMPLATE_requirements_general_purpose_general_purpose = {
	arch_register_req_type_normal,
	& TEMPLATE_reg_classes[CLASS_TEMPLATE_general_purpose],
	NULL,        /* limit bitset */
	0,           /* same pos */
	0            /* different pos */
};


static const arch_register_req_t TEMPLATE_requirements__none = {
	arch_register_req_type_none,
	NULL,                         /* regclass */
	NULL,                         /* limit bitset */
	0,                            /* same pos */
	0                             /* different pos */
};


static const arch_register_req_t TEMPLATE_requirements_general_purpose_in_r1 = {
	arch_register_req_type_should_be_same,
	& TEMPLATE_reg_classes[CLASS_TEMPLATE_general_purpose],
	NULL,
	1,        /* same pos */
	0        /* different pos */
};



/**
 * represents a FP constant
 */
ir_node *new_bd_TEMPLATE_fConst(dbg_info *db, ir_node *block, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_fConst;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_floating_point_floating_point,
	};

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Mul: Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_TEMPLATE_fMul(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_fMul;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_floating_point_floating_point,
		& TEMPLATE_requirements_floating_point_floating_point,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_floating_point_floating_point,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Or: Or(a, b) = Or(b, a) = a OR b
 */
ir_node *new_bd_TEMPLATE_Or(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Or;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Increment: Inc(a) = a++
 */
ir_node *new_bd_TEMPLATE_Inc(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Inc;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct And: And(a, const) = And(const, a) = a AND const
 */
ir_node *new_bd_TEMPLATE_And_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_And_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Add: Add(a, b) = Add(b, a) = a + b
 */
ir_node *new_bd_TEMPLATE_fAdd(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_fAdd;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_floating_point_floating_point,
		& TEMPLATE_requirements_floating_point_floating_point,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_floating_point_floating_point,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Shl: Shl(a, b) = a << b
 */
ir_node *new_bd_TEMPLATE_Shl(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Shl;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Add: Add(a, const) = Add(const, a) = a + const
 */
ir_node *new_bd_TEMPLATE_Add_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Add_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Add: Add(a, b) = Add(b, a) = a + b
 */
ir_node *new_bd_TEMPLATE_Add(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Add;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct RotL: RotL(a, b) = a ROTL b
 */
ir_node *new_bd_TEMPLATE_RotL(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_RotL;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Load: Load(ptr, mem) = LD ptr
 */
ir_node *new_bd_TEMPLATE_fLoad(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_fLoad;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
		& TEMPLATE_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_floating_point_floating_point,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Min: Min(a, b) = Min(b, a) = a < b ? a : b
 */
ir_node *new_bd_TEMPLATE_fMin(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_fMin;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_floating_point_floating_point,
		& TEMPLATE_requirements_floating_point_floating_point,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_floating_point_floating_point,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Or: Or(a, const) = Or(const, a) = a OR const
 */
ir_node *new_bd_TEMPLATE_Or_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Or_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Div: Div(a, b) = a / b
 */
ir_node *new_bd_TEMPLATE_fDiv(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_fDiv;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_floating_point_floating_point,
		& TEMPLATE_requirements_floating_point_floating_point,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_floating_point_floating_point,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Sub: Sub(a, b) = a - b
 */
ir_node *new_bd_TEMPLATE_Sub(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Sub;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Mul: Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_TEMPLATE_Mul(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Mul;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Sub: Sub(a, const) = a - const
 */
ir_node *new_bd_TEMPLATE_Sub_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Sub_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Shr: Shr(a, b) = a >> b
 */
ir_node *new_bd_TEMPLATE_Shr(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Shr;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_in_r1,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct RotR: RotR(a, b) = a ROTR b
 */
ir_node *new_bd_TEMPLATE_RotR(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_RotR;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct RotL: RotL(a, const) = a ROTL const
 */
ir_node *new_bd_TEMPLATE_RotL_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_RotL_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Mul: Mul(a, const) = Mul(const, a) = a * const
 */
ir_node *new_bd_TEMPLATE_Mul_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Mul_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Eor: Eor(a, const) = Eor(const, a) = a EOR const
 */
ir_node *new_bd_TEMPLATE_Eor_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Eor_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Decrement: Dec(a) = a--
 */
ir_node *new_bd_TEMPLATE_Dec(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Dec;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Shl: Shl(a, const) = a << const
 */
ir_node *new_bd_TEMPLATE_Shl_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Shl_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Not: Not(a) = !a
 */
ir_node *new_bd_TEMPLATE_Not(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Not;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Minus: Minus(a) = -a
 */
ir_node *new_bd_TEMPLATE_fMinus(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_fMinus;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_floating_point_floating_point,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_floating_point_floating_point,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Max: Max(a, b) = Max(b, a) = a > b ? a : b
 */
ir_node *new_bd_TEMPLATE_fMax(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_fMax;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_floating_point_floating_point,
		& TEMPLATE_requirements_floating_point_floating_point,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_floating_point_floating_point,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Store: Store(ptr, val, mem) = ST ptr,val
 */
ir_node *new_bd_TEMPLATE_Store(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Store;
	int       flags   = 0;
	int       arity   = 3;
	ir_node  *in[3];
	int       n_res   = 0;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
		& TEMPLATE_requirements_general_purpose_general_purpose,
		& TEMPLATE_requirements__none,
	};
	static const arch_register_req_t **out_reqs = NULL;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct And: And(a, b) = And(b, a) = a AND b
 */
ir_node *new_bd_TEMPLATE_And(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_And;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Store: Store(ptr, val, mem) = ST ptr,val
 */
ir_node *new_bd_TEMPLATE_fStore(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_fStore;
	int       flags   = 0;
	int       arity   = 3;
	ir_node  *in[3];
	int       n_res   = 0;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
		& TEMPLATE_requirements_floating_point_floating_point,
		& TEMPLATE_requirements__none,
	};
	static const arch_register_req_t **out_reqs = NULL;

	/* construct in array */
	in[0] = op0;
	in[1] = op1;
	in[2] = op2;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct FP Sub: Sub(a, b) = a - b
 */
ir_node *new_bd_TEMPLATE_fSub(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_fSub;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_floating_point_floating_point,
		& TEMPLATE_requirements_floating_point_floating_point,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_floating_point_floating_point,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Minus: Minus(a) = -a
 */
ir_node *new_bd_TEMPLATE_Minus(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Minus;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Eor: Eor(a, b) = Eor(b, a) = a EOR b
 */
ir_node *new_bd_TEMPLATE_Eor(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Eor;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * represents an integer constant
 */
ir_node *new_bd_TEMPLATE_Const(dbg_info *db, ir_node *block, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Const;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Load: Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_TEMPLATE_Load(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Load;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
		& TEMPLATE_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Shr: Shr(a, const) = a >> const
 */
ir_node *new_bd_TEMPLATE_Shr_i(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_TEMPLATE_Shr_i;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& TEMPLATE_requirements_general_purpose_general_purpose,
	};

	/* construct in array */
	in[0] = op0;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_TEMPLATE_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * Creates the TEMPLATE specific Firm machine operations
 * needed for the assembler irgs.
 */
void TEMPLATE_create_opcodes(const arch_irn_ops_t *be_ops) {
#define N   irop_flag_none
#define L   irop_flag_labeled
#define C   irop_flag_commutative
#define X   irop_flag_cfopcode
#define I   irop_flag_ip_cfopcode
#define F   irop_flag_fragile
#define Y   irop_flag_forking
#define H   irop_flag_highlevel
#define c   irop_flag_constlike
#define K   irop_flag_keep
#define M   irop_flag_machine
#define O   irop_flag_machine_op
#define NB  irop_flag_dump_noblock
#define NI  irop_flag_dump_noinput
#define R   (irop_flag_user << 0)

	ir_op_ops  ops;
	int        cur_opcode;
	static int run_once = 0;
	int        i;

	if (run_once)
		return;
	run_once = 1;
	
	/* we handle all middleend nodes as well that have no other handler */
	for (i = 0; i <= iro_Last; ++i) {
		ir_op *op      = get_irp_opcode(i);
		if (op->ops.be_ops == NULL)
			op->ops.be_ops = be_ops;
	}

	cur_opcode = get_next_ir_opcodes(iro_TEMPLATE_last);
  
	TEMPLATE_opcode_start = cur_opcode;

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = cmp_attr_TEMPLATE_fConst;
	op_TEMPLATE_fConst = new_ir_op(cur_opcode + iro_TEMPLATE_fConst, "TEMPLATE_fConst", op_pin_state_floats, c|M, oparity_zero, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_fConst, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_fMul = new_ir_op(cur_opcode + iro_TEMPLATE_fMul, "TEMPLATE_fMul", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_fMul, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Or = new_ir_op(cur_opcode + iro_TEMPLATE_Or, "TEMPLATE_Or", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Or, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Inc = new_ir_op(cur_opcode + iro_TEMPLATE_Inc, "TEMPLATE_Inc", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Inc, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_And_i = new_ir_op(cur_opcode + iro_TEMPLATE_And_i, "TEMPLATE_And_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_And_i, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_fAdd = new_ir_op(cur_opcode + iro_TEMPLATE_fAdd, "TEMPLATE_fAdd", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_fAdd, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Shl = new_ir_op(cur_opcode + iro_TEMPLATE_Shl, "TEMPLATE_Shl", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Shl, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Add_i = new_ir_op(cur_opcode + iro_TEMPLATE_Add_i, "TEMPLATE_Add_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Add_i, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Add = new_ir_op(cur_opcode + iro_TEMPLATE_Add, "TEMPLATE_Add", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Add, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_RotL = new_ir_op(cur_opcode + iro_TEMPLATE_RotL, "TEMPLATE_RotL", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_RotL, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_fLoad = new_ir_op(cur_opcode + iro_TEMPLATE_fLoad, "TEMPLATE_fLoad", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_fLoad, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_fMin = new_ir_op(cur_opcode + iro_TEMPLATE_fMin, "TEMPLATE_fMin", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_fMin, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Or_i = new_ir_op(cur_opcode + iro_TEMPLATE_Or_i, "TEMPLATE_Or_i", op_pin_state_floats, C|M, oparity_unary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Or_i, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_fDiv = new_ir_op(cur_opcode + iro_TEMPLATE_fDiv, "TEMPLATE_fDiv", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_fDiv, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Sub = new_ir_op(cur_opcode + iro_TEMPLATE_Sub, "TEMPLATE_Sub", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Sub, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Mul = new_ir_op(cur_opcode + iro_TEMPLATE_Mul, "TEMPLATE_Mul", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Mul, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Sub_i = new_ir_op(cur_opcode + iro_TEMPLATE_Sub_i, "TEMPLATE_Sub_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Sub_i, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Shr = new_ir_op(cur_opcode + iro_TEMPLATE_Shr, "TEMPLATE_Shr", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Shr, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_RotR = new_ir_op(cur_opcode + iro_TEMPLATE_RotR, "TEMPLATE_RotR", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_RotR, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_RotL_i = new_ir_op(cur_opcode + iro_TEMPLATE_RotL_i, "TEMPLATE_RotL_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_RotL_i, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Mul_i = new_ir_op(cur_opcode + iro_TEMPLATE_Mul_i, "TEMPLATE_Mul_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Mul_i, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Eor_i = new_ir_op(cur_opcode + iro_TEMPLATE_Eor_i, "TEMPLATE_Eor_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Eor_i, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Dec = new_ir_op(cur_opcode + iro_TEMPLATE_Dec, "TEMPLATE_Dec", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Dec, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Shl_i = new_ir_op(cur_opcode + iro_TEMPLATE_Shl_i, "TEMPLATE_Shl_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Shl_i, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Not = new_ir_op(cur_opcode + iro_TEMPLATE_Not, "TEMPLATE_Not", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Not, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_fMinus = new_ir_op(cur_opcode + iro_TEMPLATE_fMinus, "TEMPLATE_fMinus", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_fMinus, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_fMax = new_ir_op(cur_opcode + iro_TEMPLATE_fMax, "TEMPLATE_fMax", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_fMax, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Store = new_ir_op(cur_opcode + iro_TEMPLATE_Store, "TEMPLATE_Store", op_pin_state_exc_pinned, L|F|M, oparity_trinary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Store, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_And = new_ir_op(cur_opcode + iro_TEMPLATE_And, "TEMPLATE_And", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_And, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_fStore = new_ir_op(cur_opcode + iro_TEMPLATE_fStore, "TEMPLATE_fStore", op_pin_state_exc_pinned, L|F|M, oparity_trinary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_fStore, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_fSub = new_ir_op(cur_opcode + iro_TEMPLATE_fSub, "TEMPLATE_fSub", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_fSub, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Minus = new_ir_op(cur_opcode + iro_TEMPLATE_Minus, "TEMPLATE_Minus", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Minus, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Eor = new_ir_op(cur_opcode + iro_TEMPLATE_Eor, "TEMPLATE_Eor", op_pin_state_floats, C|M, oparity_binary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Eor, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = cmp_attr_TEMPLATE_Const;
	op_TEMPLATE_Const = new_ir_op(cur_opcode + iro_TEMPLATE_Const, "TEMPLATE_Const", op_pin_state_floats, c|M, oparity_zero, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Const, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Load = new_ir_op(cur_opcode + iro_TEMPLATE_Load, "TEMPLATE_Load", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Load, TEMPLATE_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = TEMPLATE_dump_node;
	ops.node_cmp_attr = TEMPLATE_compare_attr;
	op_TEMPLATE_Shr_i = new_ir_op(cur_opcode + iro_TEMPLATE_Shr_i, "TEMPLATE_Shr_i", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(TEMPLATE_attr_t), &ops);
	set_op_tag(op_TEMPLATE_Shr_i, TEMPLATE_op_tag);

	TEMPLATE_opcode_end = cur_opcode + iro_TEMPLATE_last;
}
