# Creation: 2006/02/13
# $Id: arm_spec.pl 25133 2009-01-09 14:20:15Z matze $
# This is a template specification for the Firm-Backend

# the cpu architecture (ia32, ia64, mips, sparc, ppc, ...)

$arch = "arm";
$new_emit_syntax = 1;

# the number of additional opcodes you want to register
#$additional_opcodes = 0;

#
# Modes
#
$mode_gp      = "mode_Iu";
$mode_fpa     = "mode_E";

# register types:
$normal      =  0; # no special type
$caller_save =  1; # caller save (register must be saved by the caller of a function)
$callee_save =  2; # callee save (register must be saved by the called function)
$ignore      =  4; # ignore (do not assign this register)
$arbitrary   =  8; # emitter can choose an arbitrary register of this class
$virtual     = 16; # the register is a virtual one
$state       = 32; # register represents a state
# NOTE: Last entry of each class is the largest Firm-Mode a register can hold
%reg_classes = (
	gp => [
		{ "name" => "r0", "type"  => $caller_save },
		{ "name" => "r1", "type"  => $caller_save },
		{ "name" => "r2", "type"  => $caller_save },
		{ "name" => "r3", "type"  => $caller_save },
		{ "name" => "r4", "type"  => $callee_save },
		{ "name" => "r5", "type"  => $callee_save },
		{ "name" => "r6", "type"  => $callee_save },
		{ "name" => "r7", "type"  => $callee_save },
		{ "name" => "r8", "type"  => $callee_save },
		{ "name" => "r9", "type"  => $callee_save },
		{ "name" => "r10", "type" => $callee_save },
		{ "name" => "r11", "type" => $callee_save },
		{ "name" => "r12", "type" => $ignore | $callee_save }, # reserved for linker
		{ "name" => "sp", "type"  => $ignore | $callee_save }, # this is our stack pointer
		{ "name" => "lr", "type"  => $callee_save | $caller_save }, # this is our return address
		{ "name" => "pc", "type"  => $ignore | $callee_save }, # this is our program counter
		{ name => "gp_UKNWN", type => $ignore | $arbitrary | $virtual },  # we need a dummy register for Unknown nodes
		{ "mode" => $mode_gp }
	],
	fpa  => [
		{ "name" => "f0", "type" => 1 },
		{ "name" => "f1", "type" => 1 },
		{ "name" => "f2", "type" => 1 },
		{ "name" => "f3", "type" => 1 },
		{ "name" => "f4", "type" => 1 },
		{ "name" => "f5", "type" => 1 },
		{ "name" => "f6", "type" => 1 },
		{ "name" => "f7", "type" => 1 },
		{ name => "fpa_UKNWN", type => 4 | 8 | 16 },  # we need a dummy register for Unknown nodes
		{ "mode" => $mode_fpa }
	]
); # %reg_classes

%emit_templates = (
	M  => "${arch}_emit_mode(node);",
	X  => "${arch}_emit_shift(node);",
	S0 => "${arch}_emit_source_register(node, 0);",
	S1 => "${arch}_emit_source_register(node, 1);",
	S2 => "${arch}_emit_source_register(node, 2);",
	S3 => "${arch}_emit_source_register(node, 3);",
	S4 => "${arch}_emit_source_register(node, 4);",
	D0 => "${arch}_emit_dest_register(node, 0);",
	D1 => "${arch}_emit_dest_register(node, 1);",
	D2 => "${arch}_emit_dest_register(node, 2);",
	C  => "${arch}_emit_immediate(node);",
	O  => "${arch}_emit_offset(mode);",
);

#--------------------------------------------------#
#                        _                         #
#                       (_)                        #
#  _ __   _____      __  _ _ __    ___  _ __  ___  #
# | '_ \ / _ \ \ /\ / / | | '__|  / _ \| '_ \/ __| #
# | | | |  __/\ V  V /  | | |    | (_) | |_) \__ \ #
# |_| |_|\___| \_/\_/   |_|_|     \___/| .__/|___/ #
#                                      | |         #
#                                      |_|         #
#--------------------------------------------------#

$default_attr_type = "arm_attr_t";
$default_copy_attr = "arm_copy_attr";

%init_attr = (
	arm_attr_t           => "\tinit_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);",
	arm_SymConst_attr_t  => "\tinit_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);",
	arm_CondJmp_attr_t   => "\tinit_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);",
	arm_SwitchJmp_attr_t => "\tinit_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);",
	arm_fpaConst_attr_t  => "\tinit_arm_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);",
);

%compare_attr = (
	arm_attr_t           => "cmp_attr_arm",
	arm_SymConst_attr_t  => "cmp_attr_arm_SymConst",
	arm_CondJmp_attr_t   => "cmp_attr_arm_CondJmp",
	arm_SwitchJmp_attr_t => "cmp_attr_arm_SwitchJmp",
	arm_fpaConst_attr_t  => "cmp_attr_arm_fpaConst",
);

#%operands = (
#
#Immediate => {
#	comment   => "blup di dup",
#	irn_flags => "R",
#	emit      => ". [%S0]-10",
#	reg_req   => { },
#	attr      => "tarval *tv",
#	init_attr => "(void) attri;",
#	# op_flags => O
#	# cmp => "return 1;"
#},
#
#ShfOp_I => {
#	irn_flags => "R",
#	emit      => ". ...",
#	reg_req   => { in => [ "gp" ] },
#	attr      => "tarval *tv",
#	init_attr => "(void) tv;",
#},
#
#ShfOp => {
#	irn_flags => "R",
#	emit      => ". ...",
#	reg_req   => { in => [ "gp", "gp" ] },
#},
#
#);

%nodes = (

Unknown_GP => {
	state     => "pinned",
	op_flags  => "c",
	reg_req   => { out => [ "gp_UKNWN:I" ] },
	emit      => "",
	mode      => $mode_gp,
},

Unknown_FPA => {
	state     => "pinned",
	op_flags  => "c",
	reg_req   => { out => [ "fpa_UKNWN:I" ] },
	emit      => "",
	mode      => $mode_fpa,
},

#-----------------------------------------------------------------#
#  _       _                                         _            #
# (_)     | |                                       | |           #
#  _ _ __ | |_ ___  __ _  ___ _ __   _ __   ___   __| | ___  ___  #
# | | '_ \| __/ _ \/ _` |/ _ \ '__| | '_ \ / _ \ / _` |/ _ \/ __| #
# | | | | | ||  __/ (_| |  __/ |    | | | | (_) | (_| |  __/\__ \ #
# |_|_| |_|\__\___|\__, |\___|_|    |_| |_|\___/ \__,_|\___||___/ #
#                   __/ |                                         #
#                  |___/                                          #
#-----------------------------------------------------------------#

# commutative operations

Add => {
	op_flags  => "C",
	irn_flags => "R",
	comment   => "construct Add: Add(a, b) = Add(b, a) = a + b",
	attr      => "arm_shift_modifier mod, long shf",
	init_attr => 'ARM_SET_SHF_MOD(attr, mod); attr->imm_value = shf;',
	cmp_attr  => 'return (attr_a->instr_fl != attr_b->instr_fl) || (attr_a->imm_value != attr_b->imm_value);',
	reg_req   => { "in" => [ "gp", "gp" ], "out" => [ "gp" ] },
	emit      => '. add %D0, %S0, %S1%X'
},

Add_i => {
	irn_flags => "R",
	comment   => "construct Add: Add(a, const) = Add(const, a) = a + const",
	attr      => "long imm",
	init_attr => 'ARM_SET_SHF_MOD(attr, ARM_SHF_IMM); attr->imm_value = imm;',
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;',
	reg_req   => { "in" => [ "gp" ], "out" => [ "gp" ] },
	emit      => '. add %D0, %S0, %C'
},

Mul => {
	#op_flags  => "C",
	irn_flags => "R",
	comment   => "construct Mul: Mul(a, b) = Mul(b, a) = a * b",
	reg_req   => { "in" => [ "gp", "gp" ], "out" => [ "!in_r1" ] },
	emit      =>'. mul %D0, %S0, %S1'
},

Smull => {
	#op_flags  => "C",
	irn_flags => "R",
	comment   => "construct signed 64bit Mul: Mul(a, b) = Mul(b, a) = a * b",
	reg_req   => { "in" => [ "gp", "gp" ], "out" => [ "gp", "gp" ] },
	emit      =>'. smull %D0, %D1, %S0, %S1',
	outs      => [ "low", "high" ],
},

Umull => {
	#op_flags  => "C",
	irn_flags => "R",
	comment   => "construct unsigned 64bit Mul: Mul(a, b) = Mul(b, a) = a * b",
	reg_req   => { "in" => [ "gp", "gp" ], "out" => [ "gp", "gp" ] },
	emit      =>'. umull %D0, %D1, %S0, %S1',
	outs      => [ "low", "high" ],
},

Mla => {
	#op_flags  => "C",
	irn_flags => "R",
	comment   => "construct Mla: Mla(a, b, c) = a * b + c",
	reg_req   => { "in" => [ "gp", "gp", "gp" ], "out" => [ "!in_r1" ] },
	emit      =>'. mla %D0, %S0, %S1, %S2'
},

And => {
	op_flags  => "C",
	irn_flags => "R",
	comment   => "construct And: And(a, b) = And(b, a) = a AND b",
	attr      => "arm_shift_modifier mod, long shf",
	init_attr => 'ARM_SET_SHF_MOD(attr, mod); attr->imm_value = shf;',
	cmp_attr  => 'return (attr_a->instr_fl != attr_b->instr_fl) || (attr_a->imm_value != attr_b->imm_value);',
	reg_req   => { "in" => [ "gp", "gp" ], "out" => [ "gp" ] },
	emit      => '. and %D0, %S0, %S1%X'
},

And_i => {
	irn_flags => "R",
	comment   => "construct And: And(a, const) = And(const, a) = a AND const",
	attr      => "long imm",
	init_attr => 'ARM_SET_SHF_MOD(attr, ARM_SHF_IMM); attr->imm_value = imm;',
	reg_req   => { "in" => [ "gp" ], "out" => [ "gp" ] },
	emit      => '. and %D0, %S0, %C',
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;'
},

Or => {
	op_flags  => "C",
	irn_flags => "R",
	comment   => "construct Or: Or(a, b) = Or(b, a) = a OR b",
	attr      => "arm_shift_modifier mod, long shf",
	init_attr => 'ARM_SET_SHF_MOD(attr, mod); attr->imm_value = shf;',
	cmp_attr  => 'return (attr_a->instr_fl != attr_b->instr_fl) || (attr_a->imm_value != attr_b->imm_value);',
	reg_req   => { "in" => [ "gp", "gp" ], "out" => [ "gp" ] },
	emit      => '. orr %D0, %S0, %S1%X'
},

Or_i => {
	irn_flags => "R",
	comment   => "construct Or: Or(a, const) = Or(const, a) = a OR const",
	attr      => "long imm",
	init_attr => 'ARM_SET_SHF_MOD(attr, ARM_SHF_IMM); attr->imm_value = imm;',
	reg_req   => { "in" => [ "gp" ], "out" => [ "gp" ] },
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;',
	emit      => '. orr %D0, %S0, %C'
},

Eor => {
	op_flags  => "C",
	irn_flags => "R",
	comment   => "construct Eor: Eor(a, b) = Eor(b, a) = a EOR b",
	attr      => "arm_shift_modifier mod, long shf",
	init_attr => 'ARM_SET_SHF_MOD(attr, mod); attr->imm_value = shf;',
	cmp_attr  => 'return (attr_a->instr_fl != attr_b->instr_fl) || (attr_a->imm_value != attr_b->imm_value);',
	reg_req   => { "in" => [ "gp", "gp" ], "out" => [ "gp" ] },
	emit      => '. eor %D0, %S0, %S1%X'
},

Eor_i => {
	irn_flags => "R",
	comment   => "construct Eor: Eor(a, const) = Eor(const, a) = a EOR const",
	attr      => "long imm",
	init_attr => 'ARM_SET_SHF_MOD(attr, ARM_SHF_IMM); attr->imm_value = imm;',
	reg_req   => { "in" => [ "gp" ], "out" => [ "gp" ] },
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;',
	emit      => '. eor %D0, %S0, %C'
},

# not commutative operations

Bic => {
	irn_flags => "R",
	comment   => "construct Bic: Bic(a, b) = a AND ~b",
	attr      => "arm_shift_modifier mod, long shf",
	init_attr => 'ARM_SET_SHF_MOD(attr, mod); attr->imm_value = shf;',
	cmp_attr  => 'return (attr_a->instr_fl != attr_b->instr_fl) || (attr_a->imm_value != attr_b->imm_value);',
	reg_req   => { "in" => [ "gp", "gp" ], "out" => [ "gp" ] },
	emit      => '. bic %D0, %S0, %S1%X'
},

Bic_i => {
	irn_flags => "R",
	comment   => "construct Bic: Bic(a, const) = a AND ~const",
	attr      => "long imm",
	init_attr => 'ARM_SET_SHF_MOD(attr, ARM_SHF_IMM); attr->imm_value = imm;',
	reg_req   => { "in" => [ "gp" ], "out" => [ "gp" ] },
	emit      => '. bic %D0, %S0, %C',
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;'
},

Sub => {
	irn_flags => "R",
	comment   => "construct Sub: Sub(a, b) = a - b",
	attr      => "arm_shift_modifier mod, long shf",
	init_attr => 'ARM_SET_SHF_MOD(attr, mod); attr->imm_value = shf;',
	cmp_attr  => 'return (attr_a->instr_fl != attr_b->instr_fl) || (attr_a->imm_value != attr_b->imm_value);',
	reg_req   => { "in" => [ "gp", "gp" ], "out" => [ "gp" ] },
	emit      => '. sub %D0, %S0, %S1%X'
},

Sub_i => {
	irn_flags => "R",
	comment   => "construct Sub: Sub(a, const) = a - const",
	attr      => "long imm",
	init_attr => 'ARM_SET_SHF_MOD(attr, ARM_SHF_IMM); attr->imm_value = imm;',
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;',
	reg_req   => { "in" => [ "gp" ], "out" => [ "gp" ] },
	emit      => '. sub %D0, %S0, %C',
},

Rsb => {
	irn_flags => "R",
	comment   => "construct Rsb: Rsb(a, b) = b - a",
	attr      => "arm_shift_modifier mod, long shf",
	init_attr => 'ARM_SET_SHF_MOD(attr, mod); attr->imm_value = shf;',
	cmp_attr  => 'return (attr_a->instr_fl != attr_b->instr_fl) || (attr_a->imm_value != attr_b->imm_value);',
	reg_req   => { "in" => [ "gp", "gp" ], "out" => [ "gp" ] },
	emit      => '. rsb %D0, %S0, %S1%X'
},

Rsb_i => {
	irn_flags => "R",
	comment   => "construct Rsb: Rsb(a, const) = const - a",
	attr      => "long imm",
	init_attr => 'ARM_SET_SHF_MOD(attr, ARM_SHF_IMM); attr->imm_value = imm;',
	reg_req   => { "in" => [ "gp" ], "out" => [ "gp" ] },
	emit      => '. rsb %D0, %S0, %C',
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;'
},

Shl => {
	irn_flags => "R",
	comment   => "construct Shl: Shl(a, b) = a << b",
	reg_req   => { "in" => [ "gp", "gp" ], "out" => [ "gp" ] },
	emit      => '. mov %D0, %S0, lsl %S1'
},

Shr => {
	irn_flags => "R",
	comment   => "construct Shr: Shr(a, b) = a >>u b",
	reg_req   => { "in" => [ "gp", "gp" ], "out" => [ "gp" ] },
	emit      => '. mov %D0, %S0, lsr %S1'
},

Shrs => {
	irn_flags => "R",
	comment   => "construct Shrs: Shrs(a, b) = a >>s b",
	reg_req   => { "in" => [ "gp", "gp" ], "out" => [ "gp" ] },
	emit      => '. mov %D0, %S0, asr %S1'
},

Ror => {
	irn_flags => "R",
	comment   => "construct Ror: Ror(a, b) = a <<r>> b",
	reg_req   => { "in" => [ "gp", "gp" ], "out" => [ "gp" ] },
	emit      => '. mov %D0, %S0, ror %S1'
},

#RotL => {
#  irn_flags => "R",
#  comment   => "construct RotL: RotL(a, b) = a ROTL b",
#  reg_req   => { "in" => [ "gp", "gp" ], "out" => [ "gp" ] },
#  emit      => '. rol %S0, %S1, %D0'
#},

#RotL_i => {
#	irn_flags => "R",
#	comment   => "construct RotL: RotL(a, const) = a ROTL const",
#	reg_req   => { "in" => [ "gp" ], "out" => [ "gp" ] },
#	emit      => '. rol %S0, %C, %D0'
#},

Mov => {
	irn_flags => "R",
	comment   => "construct Mov: a = b",
	attr      => "arm_shift_modifier mod, long shf",
	init_attr => 'ARM_SET_SHF_MOD(attr, mod); attr->imm_value = shf;',
	cmp_attr  => 'return (attr_a->instr_fl != attr_b->instr_fl) || (attr_a->imm_value != attr_b->imm_value);',
	reg_req   => { "in" => [ "gp" ], "out" => [ "gp" ] },
	emit      => '. mov %D0, %S0%X'
},

Mov_i => {
	irn_flags => "R",
	comment   => "represents an integer constant",
	attr      => "long imm",
	init_attr => 'ARM_SET_SHF_MOD(attr, ARM_SHF_IMM); attr->imm_value = imm;',
	reg_req   => { "out" => [ "gp" ] },
	emit      => '. mov %D0, %C',
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;'
},

Mvn => {
	irn_flags => "R",
	comment   => "construct Not: Not(a) = !a",
	attr      => "arm_shift_modifier mod, long shf",
	init_attr => 'ARM_SET_SHF_MOD(attr, mod); attr->imm_value = shf;',
	cmp_attr  => 'return (attr_a->instr_fl != attr_b->instr_fl) || (attr_a->imm_value != attr_b->imm_value);',
	reg_req   => { "in" => [ "gp" ], "out" => [ "gp" ] },
	emit      => '. mvn %D0, %S0%X'
},

Mvn_i => {
	irn_flags => "R",
	comment   => "represents a negated integer constant",
	attr      => "long imm",
	init_attr => 'ARM_SET_SHF_MOD(attr, ARM_SHF_IMM); attr->imm_value = imm;',
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;',
	reg_req   => { "out" => [ "gp" ] },
	emit      => '. mvn %D0, %C',
},

Abs => {
	irn_flags => "R",
	comment   => "construct Abs: Abs(a) = |a|",
	reg_req   => { "in" => [ "gp" ], "out" => [ "gp" ] },
	emit      =>
'. movs %S0, %S0, #0
. rsbmi %D0, %S0, #0'
},

# other operations

#
# this node produces ALWAYS an empty (tempary) gp reg and cannot be CSE'd
#
EmptyReg => {
	op_flags  => "c",
	irn_flags => "R",
	comment   => "allocate an empty register for calculations",
	reg_req   => { "out" => [ "gp" ] },
	emit      => '. /* %D0 now available for calculations */',
	cmp_attr  => 'return 1;'
},

Copy => {
	comment  => "implements a register copy",
	reg_req  => { "in" => [ "gp" ], "out" => [ "gp" ] },
},

CopyB => {
	op_flags  => "F|H",
	state     => "pinned",
	comment   => "implements a memcopy: CopyB(dst, src, size, mem) == memcpy(dst, src, size)",
	attr      => "long imm",
	init_attr => 'attr->imm_value = imm;',
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;',
	reg_req   => { "in" => [ "!sp", "!sp", "gp", "gp", "gp", "none" ], "out" => [ "none" ] },
	outs      => [ "M" ],
},

SymConst => {
	op_flags  => "c",
	irn_flags => "R",
	comment   => "represents a symbolic constant",
	attr      => "ident *id",
	init_attr => "\tset_arm_symconst_id(res, id);",
	reg_req   => { "out" => [ "gp" ] },
	attr_type   => "arm_SymConst_attr_t",
},

CmpBra => {
	op_flags  => "L|X|Y",
	state     => "pinned",
	comment   => "construct conditional branch: CMP A, B && JMPxx LABEL",
	mode      => "mode_T",
	attr      => "int proj_num",
	init_attr => "\tset_arm_CondJmp_proj_num(res, proj_num);",
	reg_req   => { "in" => [ "gp", "gp" ], "out" => [ "none", "none"] },
	attr_type => "arm_CondJmp_attr_t",
},

TstBra => {
	op_flags  => "L|X|Y",
	state     => "pinned",
	comment   => "construct conditional branch: TST A, B && JMPxx LABEL",
	mode      => "mode_T",
	attr      => "int proj_num",
	init_attr => "\tset_arm_CondJmp_proj_num(res, proj_num);",
	reg_req   => { "in" => [ "gp", "gp" ], "out" => [ "none", "none"] },
	attr_type => "arm_CondJmp_attr_t",
},

SwitchJmp => {
	op_flags  => "L|X|Y",
	state     => "pinned",
	comment   => "construct switch",
	mode      => "mode_T",
	attr      => "int n_projs, long def_proj_num",
	init_attr => "\tset_arm_SwitchJmp_n_projs(res, n_projs);\n".
	             "\tset_arm_SwitchJmp_default_proj_num(res, def_proj_num);",
	reg_req   => { "in" => [ "gp" ], "out" => [ "none" ] },
	attr_type => "arm_SwitchJmp_attr_t",
},

# Load / Store

Load => {
	op_flags  => "L|F",
	irn_flags => "R",
	state     => "exc_pinned",
	comment   => "construct Load: Load(ptr, mem) = LD ptr -> reg",
	reg_req   => { "in" => [ "gp", "none" ], "out" => [ "gp", "none" ] },
	emit      => '. ldr %D0, [%S0, #0]',
	outs      => [ "res", "M" ],
},

Loadb => {
	op_flags  => "L|F",
	irn_flags => "R",
	state     => "exc_pinned",
	comment   => "construct Load: Load(ptr, mem) = LD ptr -> reg",
	reg_req   => { "in" => [ "gp", "none" ], "out" => [ "gp", "none" ] },
	emit      => '. ldrb %D0, [%S0, #0]',
	outs      => [ "res", "M" ],
},

Loadbs => {
	op_flags  => "L|F",
	irn_flags => "R",
	state     => "exc_pinned",
	comment   => "construct Load: Load(ptr, mem) = LD ptr -> reg",
	reg_req   => { "in" => [ "gp", "none" ], "out" => [ "gp", "none" ] },
	emit      => '. ldrsb %D0, [%S0, #0]',
	outs      => [ "res", "M" ],
},

Loadh => {
	op_flags  => "L|F",
	irn_flags => "R",
	state     => "exc_pinned",
	comment   => "construct Load: Load(ptr, mem) = LD ptr -> reg",
	reg_req   => { "in" => [ "gp", "none" ], "out" => [ "gp", "none" ] },
	emit      => '. ldrh %D0, [%S0, #0]',
	outs      => [ "res", "M" ],
},

Loadhs => {
	op_flags  => "L|F",
	irn_flags => "R",
	state     => "exc_pinned",
	comment   => "construct Load: Load(ptr, mem) = LD ptr -> reg",
	reg_req   => { "in" => [ "gp", "none" ], "out" => [ "gp", "none" ] },
	emit      => '. ldrsh %D0, [%S0, #0]',
	outs      => [ "res", "M" ],
},

Storeb => {
	op_flags  => "L|F",
	irn_flags => "R",
	state     => "exc_pinned",
	comment   => "construct Store: Store(ptr, val, mem) = ST ptr,val",
	reg_req   => { "in" => [ "gp", "gp", "none" ], "out" => [ "none" ] },
	emit      => '. strb %S1, [%S0, #0]',
	mode      => "mode_M",
},

Storeh => {
	op_flags  => "L|F",
	irn_flags => "R",
	state     => "exc_pinned",
	comment   => "construct Store: Store(ptr, val, mem) = ST ptr,val",
	reg_req   => { "in" => [ "gp", "gp", "none" ], out => [ "none" ] },
	emit      => '. strh %S1, [%S0, #0]',
	mode      => "mode_M",
},

Store => {
	op_flags  => "L|F",
	irn_flags => "R",
	state     => "exc_pinned",
	comment   => "construct Store: Store(ptr, val, mem) = ST ptr,val",
	reg_req   => { "in" => [ "gp", "gp", "none" ], out => [ "none" ] },
	emit      => '. str %S1, [%S0, #0]',
	mode      => "mode_M",
},

StoreStackM4Inc => {
	op_flags  => "L|F",
	irn_flags => "R",
	state     => "exc_pinned",
	comment   => "construct Store: Push 4 Registers = ST ptr,val",
	reg_req   => { "in" => [ "sp", "gp", "gp", "gp", "gp", "none" ], "out" => [ "sp:I|S", "none" ] },
	emit      => '. stmfd %S0!, {%S1, %S2, %S3, %S4}',
	outs      => [ "ptr", "M" ],
},

LoadStackM3Epilogue => {
	op_flags  => "L|F",
	irn_flags => "R",
	state     => "exc_pinned",
	comment   => "construct Load: Load(ptr, mem) = LD ptr -> reg",
	reg_req   => { "in" => [ "sp", "none" ], "out" => [ "r11:I", "sp:I|S", "pc:I", "none" ] },
	emit      => '. ldmfd %S0, {%D0, %D1, %D2}',
	outs      => [ "res0", "res1", "res2", "M" ],
},


#---------------------------------------------------#
#    __                               _             #
#   / _|                             | |            #
#  | |_ _ __   __ _   _ __   ___   __| | ___  ___   #
#  |  _| '_ \ / _` | | '_ \ / _ \ / _` |/ _ \/ __|  #
#  | | | |_) | (_| | | | | | (_) | (_| |  __/\__ \  #
#  |_| | .__/ \__,_| |_| |_|\___/ \__,_|\___||___/  #
#      | |                                          #
#      |_|                                          #
#---------------------------------------------------#

# commutative operations

fpaAdf => {
	op_flags  => "C",
	irn_flags => "R",
	comment   => "construct FPA Add: Add(a, b) = Add(b, a) = a + b",
	reg_req   => { "in" => [ "fpa", "fpa" ], "out" => [ "fpa" ] },
	emit      => '. adf%M %D0, %S0, %S1',
},

fpaAdf_i => {
	irn_flags => "R",
	comment   => "construct FPA Add: Add(a, b) = Add(b, a) = a + b",
	attr      => "long imm",
	init_attr => 'ARM_SET_FPA_IMM(attr); attr->imm_value = imm;',
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;',
	reg_req   => { "in" => [ "fpa" ], "out" => [ "fpa" ] },
	emit      => '. adf%M %D0, %S0, %C',
},

fpaMuf => {
	op_flags  => "C",
	irn_flags => "R",
	comment   => "construct FPA Mul: Mul(a, b) = Mul(b, a) = a * b",
	reg_req   => { "in" => [ "fpa", "fpa" ], "out" => [ "fpa" ] },
	emit      =>'. muf%M %D0, %S0, %S1',
},

fpaMuf_i => {
	irn_flags => "R",
	comment   => "construct FPA Mul: Mul(a, b) = Mul(b, a) = a * b",
	attr      => "long imm",
	init_attr => 'ARM_SET_FPA_IMM(attr); attr->imm_value = imm;',
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;',
	reg_req   => { "in" => [ "fpa" ], "out" => [ "fpa" ] },
	emit      => '. muf%M %D0, %S0, %C',
},

fpaFml => {
	op_flags  => "C",
	irn_flags => "R",
	comment   => "construct FPA Fast Mul: Mul(a, b) = Mul(b, a) = a * b",
	reg_req   => { "in" => [ "fpa", "fpa" ], "out" => [ "fpa" ] },
	emit      =>'. fml%M %D0, %S0, %S1',
},

fpaMax => {
	op_flags  => "C",
	irn_flags => "R",
	comment   => "construct FPA Max: Max(a, b) = Max(b, a) = a > b ? a : b",
	reg_req   => { "in" => [ "fpa", "fpa" ], "out" => [ "fpa" ] },
	emit      =>'. fmax %S0, %S1, %D0',
},

fpaMin => {
	op_flags  => "C",
	irn_flags => "R",
	comment   => "construct FPA Min: Min(a, b) = Min(b, a) = a < b ? a : b",
	reg_req   => { "in" => [ "fpa", "fpa" ], "out" => [ "fpa" ] },
	emit      =>'. fmin %S0, %S1, %D0',
},

# not commutative operations

fpaSuf => {
	irn_flags => "R",
	comment   => "construct FPA Sub: Sub(a, b) = a - b",
	reg_req   => { "in" => [ "fpa", "fpa" ], "out" => [ "fpa" ] },
	emit      => '. suf%M %D0, %S0, %S1'
},

fpaSuf_i => {
	irn_flags => "R",
	comment   => "construct FPA Sub: Sub(a, b) = a - b",
	attr      => "long imm",
	init_attr => 'ARM_SET_FPA_IMM(attr); attr->imm_value = imm;',
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;',
	reg_req   => { "in" => [ "fpa" ], "out" => [ "fpa" ] },
	emit      => '. suf%M %D0, %S0, %C'
},

fpaRsf => {
	irn_flags => "R",
	comment   => "construct FPA reverse Sub: Sub(a, b) = b - a",
	reg_req   => { "in" => [ "fpa", "fpa" ], "out" => [ "fpa" ] },
	emit      => '. rsf%M %D0, %S0, %S1'
},

fpaRsf_i => {
	irn_flags => "R",
	comment   => "construct FPA reverse Sub: Sub(a, b) = b - a",
	attr      => "long imm",
	init_attr => 'ARM_SET_FPA_IMM(attr); attr->imm_value = imm;',
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;',
	reg_req   => { "in" => [ "fpa" ], "out" => [ "fpa" ] },
	emit      => '. rsf%M %D0, %S0, %C'
},

fpaDvf => {
	comment   => "construct FPA Div: Div(a, b) = a / b",
	attr      => "ir_mode *op_mode",
	init_attr => "attr->op_mode = op_mode;",
	reg_req   => { "in" => [ "fpa", "fpa" ], "out" => [ "fpa", "none" ] },
	emit      =>'. dvf%M %D0, %S0, %S1',
	outs      => [ "res", "M" ],
},

fpaDvf_i => {
	comment   => "construct FPA Div: Div(a, b) = a / b",
	attr      => "ir_mode *op_mode, long imm",
	init_attr => 'attr->op_mode = op_mode; ARM_SET_FPA_IMM(attr); attr->imm_value = imm;',
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;',
	reg_req   => { "in" => [ "fpa" ], "out" => [ "fpa", "none" ] },
	emit      =>'. dvf%M %D0, %S0, %C',
	outs      => [ "res", "M" ],
},

fpaRdf => {
	comment   => "construct FPA reverse Div: Div(a, b) = b / a",
	attr      => "ir_mode *op_mode",
	init_attr => "attr->op_mode = op_mode;",
	reg_req   => { "in" => [ "fpa", "fpa" ], "out" => [ "fpa", "none" ] },
	emit      =>'. rdf%M %D0, %S0, %S1',
	outs      => [ "res", "M" ],
},

fpaRdf_i => {
	comment   => "construct FPA reverse Div: Div(a, b) = b / a",
	attr      => "ir_mode *op_mode, long imm",
	init_attr => 'attr->op_mode = op_mode; ARM_SET_FPA_IMM(attr); attr->imm_value = imm;',
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;',
	reg_req   => { "in" => [ "fpa" ], "out" => [ "fpa", "none" ] },
	emit      =>'. rdf%M %D0, %S0, %S1',
	outs      => [ "res", "M" ],
},

fpaFdv => {
	comment   => "construct FPA Fast Div: Div(a, b) = a / b",
	attr      => "ir_mode *op_mode",
	init_attr => "attr->op_mode = op_mode;",
	reg_req   => { "in" => [ "fpa", "fpa" ], "out" => [ "fpa", "none" ] },
	emit      =>'. fdv%M %D0, %S0, %S1',
	outs      => [ "res", "M" ],
},

fpaFdv_i => {
	comment   => "construct FPA Fast Div: Div(a, b) = a / b",
	attr      => "ir_mode *op_mode, long imm",
	init_attr => 'attr->op_mode = op_mode; ARM_SET_FPA_IMM(attr); attr->imm_value = imm;',
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;',
	reg_req   => { "in" => [ "fpa" ], "out" => [ "fpa", "none" ] },
	emit      =>'. fdv%M %D0, %S0, %C',
	outs      => [ "res", "M" ],
},

fpaFrd => {
	comment   => "construct FPA Fast reverse Div: Div(a, b) = b / a",
	attr      => "ir_mode *op_mode",
	init_attr => "attr->op_mode = op_mode;",
	reg_req   => { "in" => [ "fpa", "fpa" ], "out" => [ "fpa", "none" ] },
	emit      =>'. frd%M %D0, %S0, %S1',
	outs      => [ "res", "M" ],
},

fpaFrd_i => {
	comment   => "construct FPA Fast reverse Div: Div(a, b) = b / a",
	attr      => "ir_mode *op_mode, long imm",
	init_attr => 'attr->op_mode = op_mode; ARM_SET_FPA_IMM(attr); attr->imm_value = imm;',
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;',
	reg_req   => { "in" => [ "fpa" ], "out" => [ "fpa", "none" ] },
	emit      =>'. frd%M %D0, %S0, %C',
	outs      => [ "res", "M" ],
},

fpaMvf => {
	irn_flags => "R",
	comment   => "construct FPA Move: b = a",
	reg_req   => { "in" => [ "fpa" ], "out" => [ "fpa" ] },
	emit      => '. mvf%M %S0, %D0',
},

fpaMvf_i => {
	irn_flags => "R",
	comment   => "represents a float constant",
	attr      => "long imm",
	init_attr => 'ARM_SET_FPA_IMM(attr); attr->imm_value = imm;',
	reg_req   => { "out" => [ "fpa" ] },
	emit      => '. mvf%M %D0, %C',
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;'
},

fpaMnf => {
	irn_flags => "R",
	comment   => "construct FPA Move Negated: b = -a",
	reg_req   => { "in" => [ "fpa" ], "out" => [ "fpa" ] },
	emit      => '. mnf%M %S0, %D0',
},

fpaMnf_i => {
	irn_flags => "R",
	comment   => "represents a float constant",
	attr      => "long imm",
	init_attr => 'ARM_SET_FPA_IMM(attr); attr->imm_value = imm;',
	reg_req   => { "out" => [ "fpa" ] },
	emit      => '. mnf%M %D0, %C',
	cmp_attr  => 'return attr_a->imm_value != attr_b->imm_value;'
},

fpaAbs => {
	irn_flags => "R",
	comment   => "construct FPA Absolute value: fAbsd(a) = |a|",
	reg_req   => { "in" => [ "fpa" ], "out" => [ "fpa" ] },
	emit      => '. abs%M %D0, %S0',
},

# other operations

fpaFlt => {
	irn_flags => "R",
	comment   => "construct a FPA integer->float conversion",
	reg_req   => { "in" => ["gp"], "out" => [ "fpa" ] },
	emit      => '. flt%M %D0, %S0',
},

fpaFix => {
	irn_flags => "R",
	comment   => "construct a FPA float->integer conversion",
	reg_req   => { "in" => ["fpa"], "out" => [ "gp" ] },
	emit      => '. fix %D0, %S0',
},

fpaCmfBra => {
	op_flags  => "L|X|Y",
	state     => "pinned",
	comment   => "construct floating point Compare and Branch: CMF A, B && JMPxx LABEL",
	mode      => "mode_T",
	attr      => "int proj_num",
	init_attr => "\tset_arm_CondJmp_proj_num(res, proj_num);",
	reg_req   => { "in" => [ "fpa", "fpa" ], "out" => [ "none", "none"] },
	attr_type => "arm_CondJmp_attr_t",
},

fpaCnfBra => {
	op_flags  => "L|X|Y",
	state     => "pinned",
	comment   => "construct floating point Compare negative and Branch: CMF A, -B && JMPxx LABEL",
	mode      => "mode_T",
	attr      => "int proj_num",
	init_attr => "\tset_arm_CondJmp_proj_num(res, proj_num);",
	reg_req   => { "in" => [ "fpa", "fpa" ], "out" => [ "none", "none"] },
	attr_type => "arm_CondJmp_attr_t",
},

fpaCmfeBra => {
	op_flags  => "L|X|Y",
	state     => "pinned",
	comment   => "construct floating point Compare and Branch: CMF A, -B && JMPxx LABEL",
	mode      => "mode_T",
	attr      => "int proj_num",
	init_attr => "\tset_arm_CondJmp_proj_num(res, proj_num);",
	reg_req   => { "in" => [ "fpa", "fpa" ], "out" => [ "none", "none"] },
	attr_type => "arm_CondJmp_attr_t",
},

fpaCnfeBra => {
	op_flags  => "L|X|Y",
	state     => "pinned",
	comment   => "construct floating point Compare and Branch: CMF A, -B && JMPxx LABEL",
	mode      => "mode_T",
	attr      => "int proj_num",
	init_attr => "\tset_arm_CondJmp_proj_num(res, proj_num);",
	reg_req   => { "in" => [ "fpa", "fpa" ], "out" => [ "none", "none"] },
	attr_type => "arm_CondJmp_attr_t",
},

# Load / Store

fpaLdf => {
	op_flags  => "L|F",
	irn_flags => "R",
	state     => "exc_pinned",
	comment   => "construct FPA Load: Load(ptr, mem) = LD ptr",
	attr      => "ir_mode *op_mode",
	init_attr => "attr->op_mode = op_mode;",
	reg_req   => { "in" => [ "gp", "none" ], "out" => [ "fpa", "none" ] },
	emit      => '. ldf%M %D0, [%S0]',
	outs      => [ "res", "M" ],
},

fpaStf => {
	op_flags  => "L|F",
	irn_flags => "R",
	state     => "exc_pinned",
	comment   => "construct Store: Store(ptr, val, mem) = ST ptr,val",
	attr      => "ir_mode *op_mode",
	init_attr => "attr->op_mode = op_mode;",
	reg_req   => { "in" => [ "gp", "fpa", "none" ], "out" => [ "none" ] },
	emit      => '. stf%M %S1, [%S0]',
	mode      => "mode_M",
},

fpaDbl2GP => {
	op_flags  => "L|F",
	irn_flags => "R",
	comment   => "construct fp double to 2 gp register transfer",
	reg_req   => { "in" => [ "fpa", "none" ], "out" => [ "gp", "gp", "none" ] },
	outs      => [ "low", "high", "M" ],
},

AddSP => {
	comment   => "construct Add to stack pointer",
	reg_req   => { in => [ "sp", "gp", "none" ], out => [ "sp:I|S", "none" ] },
	emit      => '. add %D0, %S0, %S1',
	outs      => [ "stack", "M" ],
},

SubSPandCopy => {
	comment   => "construct Sub from stack pointer and copy to Register",
	reg_req   => { in => [ "sp", "gp", "none" ], out => [ "sp:I|S", "gp", "none" ] },
	ins       => [ "stack", "size", "mem" ],
	emit      => ". sub %D0, %S0, %S1\n".
	             ". mov sp, %D1",
	outs      => [ "stack", "addr", "M" ],
},

LdTls => {
	irn_flags => "R",
	comment   => "load the TLS address",
	reg_req   => { out => [ "gp" ] },
},


#
# floating point constants
#
fpaConst => {
	op_flags  => "c",
	irn_flags => "R",
	comment   => "construct a floating point constant",
	attr      => "tarval *tv",
	init_attr => "attr->tv = tv;",
	mode      => "get_tarval_mode(tv)",
	reg_req   => { "out" => [ "fpa" ] },
	attr_type => "arm_fpaConst_attr_t",
}

#---------------------------------------------------#
#          __                         _             #
#         / _|                       | |            #
#  __   _| |_ _ __    _ __   ___   __| | ___  ___   #
#  \ \ / /  _| '_ \  | '_ \ / _ \ / _` |/ _ \/ __|  #
#   \ V /| | | |_) | | | | | (_) | (_| |  __/\__ \  #
#    \_/ |_| | .__/  |_| |_|\___/ \__,_|\___||___/  #
#            | |                                    #
#            |_|                                    #
#---------------------------------------------------#

); # end of %nodes
