/**
 * @file
 * @brief Contains additional external requirements defs for external includes.
 * @note   DO NOT EDIT THIS FILE, your changes will be lost.
 *         Edit libfirm/ir/be/arm/arm_spec.pl instead.
 *         created by: libfirm/ir/be/scripts/generate_regalloc_if.pl libfirm/ir/be/arm/arm_spec.pl libfirm/ir/be/arm
 * @date   Tue Jan 20 10:57:58 2009
 */
#ifndef FIRM_BE_ARM_GEN_ARM_REGALLOC_IF_H
#define FIRM_BE_ARM_GEN_ARM_REGALLOC_IF_H

#include "../bearch.h"
#include "arm_nodes_attr.h"

enum reg_arm_gp_indices {
	REG_R0,
	REG_R1,
	REG_R2,
	REG_R3,
	REG_R4,
	REG_R5,
	REG_R6,
	REG_R7,
	REG_R8,
	REG_R9,
	REG_R10,
	REG_R11,
	REG_R12,
	REG_SP,
	REG_LR,
	REG_PC,
	REG_GP_UKNWN,
	N_arm_gp_REGS = 17
};

enum reg_arm_fpa_indices {
	REG_F0,
	REG_F1,
	REG_F2,
	REG_F3,
	REG_F4,
	REG_F5,
	REG_F6,
	REG_F7,
	REG_FPA_UKNWN,
	N_arm_fpa_REGS = 9
};


enum reg_classes {
	CLASS_arm_gp = 0,
	CLASS_arm_fpa = 1,
	N_CLASSES = 2
};


extern const arch_register_t arm_gp_regs[N_arm_gp_REGS];
extern const arch_register_t arm_fpa_regs[N_arm_fpa_REGS];

extern arch_register_class_t arm_reg_classes[N_CLASSES];

void arm_register_init(void);



#endif
