/**
 * @file
 * @brief     Function prototypes for the machine description.
 * @note      DO NOT EDIT THIS FILE, your changes will be lost.
 *            Edit libfirm/ir/be/ia32/ia32_spec.pl instead.
 *            created by: libfirm/ir/be/scripts/generate_machine.pl libfirm/ir/be/ia32/ia32_spec.pl libfirm/ir/be/ia32
 * @date      Mon Mar  2 12:22:14 2009
 */
#ifndef FIRM_BE_IA32_GEN_IA32_MACHINE_H
#define FIRM_BE_IA32_GEN_IA32_MACHINE_H

#include "../bemachine.h"

/**
 * Returns the ia32 machine description.
 */
const be_machine_t *ia32_init_machine_description(void);

extern be_execution_unit_t ia32_execution_units_BRANCH[2];
extern be_execution_unit_t ia32_execution_units_VFP[8];
extern be_execution_unit_t ia32_execution_units_SSE[8];
extern be_execution_unit_t ia32_execution_units_GP[7];

/* enum for execution unit types */
enum ia32_execunit_tp_vals {
	IA32_EXECUNIT_TP_BRANCH,
	IA32_EXECUNIT_TP_VFP,
	IA32_EXECUNIT_TP_SSE,
	IA32_EXECUNIT_TP_GP,
};

/* enum for execution units of type BRANCH */
enum ia32_execunit_tp_BRANCH_vals {
	IA32_EXECUNIT_TP_BRANCH_BRANCH1,
	IA32_EXECUNIT_TP_BRANCH_BRANCH2,
};

/* enum for execution units of type VFP */
enum ia32_execunit_tp_VFP_vals {
	IA32_EXECUNIT_TP_VFP_VFP_VF0,
	IA32_EXECUNIT_TP_VFP_VFP_VF1,
	IA32_EXECUNIT_TP_VFP_VFP_VF2,
	IA32_EXECUNIT_TP_VFP_VFP_VF3,
	IA32_EXECUNIT_TP_VFP_VFP_VF4,
	IA32_EXECUNIT_TP_VFP_VFP_VF5,
	IA32_EXECUNIT_TP_VFP_VFP_VF6,
	IA32_EXECUNIT_TP_VFP_VFP_VF7,
};

/* enum for execution units of type SSE */
enum ia32_execunit_tp_SSE_vals {
	IA32_EXECUNIT_TP_SSE_SSE_XMM0,
	IA32_EXECUNIT_TP_SSE_SSE_XMM1,
	IA32_EXECUNIT_TP_SSE_SSE_XMM2,
	IA32_EXECUNIT_TP_SSE_SSE_XMM3,
	IA32_EXECUNIT_TP_SSE_SSE_XMM4,
	IA32_EXECUNIT_TP_SSE_SSE_XMM5,
	IA32_EXECUNIT_TP_SSE_SSE_XMM6,
	IA32_EXECUNIT_TP_SSE_SSE_XMM7,
};

/* enum for execution units of type GP */
enum ia32_execunit_tp_GP_vals {
	IA32_EXECUNIT_TP_GP_GP_EAX,
	IA32_EXECUNIT_TP_GP_GP_EBX,
	IA32_EXECUNIT_TP_GP_GP_ECX,
	IA32_EXECUNIT_TP_GP_GP_EDX,
	IA32_EXECUNIT_TP_GP_GP_ESI,
	IA32_EXECUNIT_TP_GP_GP_EDI,
	IA32_EXECUNIT_TP_GP_GP_EBP,
};


#endif

