/**
 * @file
 * @brief Contains additional external requirements defs for external includes.
 * @note   DO NOT EDIT THIS FILE, your changes will be lost.
 *         Edit libfirm/ir/be/ia32/ia32_spec.pl instead.
 *         created by: libfirm/ir/be/scripts/generate_regalloc_if.pl libfirm/ir/be/ia32/ia32_spec.pl libfirm/ir/be/ia32
 * @date   Mon Mar  2 12:22:14 2009
 */
#ifndef FIRM_BE_IA32_GEN_IA32_REGALLOC_IF_H
#define FIRM_BE_IA32_GEN_IA32_REGALLOC_IF_H

#include "../bearch.h"
#include "ia32_nodes_attr.h"

enum reg_ia32_xmm_indices {
	REG_XMM0,
	REG_XMM1,
	REG_XMM2,
	REG_XMM3,
	REG_XMM4,
	REG_XMM5,
	REG_XMM6,
	REG_XMM7,
	REG_XMM_NOREG,
	REG_XMM_UKNWN,
	N_ia32_xmm_REGS = 10
};

enum reg_ia32_flags_indices {
	REG_EFLAGS,
	N_ia32_flags_REGS = 1
};

enum reg_ia32_gp_indices {
	REG_EDX,
	REG_ECX,
	REG_EAX,
	REG_EBX,
	REG_ESI,
	REG_EDI,
	REG_EBP,
	REG_ESP,
	REG_GP_NOREG,
	REG_GP_UKNWN,
	N_ia32_gp_REGS = 10
};

enum reg_ia32_st_indices {
	REG_ST0,
	REG_ST1,
	REG_ST2,
	REG_ST3,
	REG_ST4,
	REG_ST5,
	REG_ST6,
	REG_ST7,
	N_ia32_st_REGS = 8
};

enum reg_ia32_mmx_indices {
	REG_MM0,
	REG_MM1,
	REG_MM2,
	REG_MM3,
	REG_MM4,
	REG_MM5,
	REG_MM6,
	REG_MM7,
	N_ia32_mmx_REGS = 8
};

enum reg_ia32_fp_cw_indices {
	REG_FPCW,
	N_ia32_fp_cw_REGS = 1
};

enum reg_ia32_vfp_indices {
	REG_VF0,
	REG_VF1,
	REG_VF2,
	REG_VF3,
	REG_VF4,
	REG_VF5,
	REG_VF6,
	REG_VF7,
	REG_VFP_NOREG,
	REG_VFP_UKNWN,
	N_ia32_vfp_REGS = 10
};


enum reg_classes {
	CLASS_ia32_xmm = 0,
	CLASS_ia32_flags = 1,
	CLASS_ia32_gp = 2,
	CLASS_ia32_st = 3,
	CLASS_ia32_mmx = 4,
	CLASS_ia32_fp_cw = 5,
	CLASS_ia32_vfp = 6,
	N_CLASSES = 7
};


extern const arch_register_t ia32_xmm_regs[N_ia32_xmm_REGS];
extern const arch_register_t ia32_flags_regs[N_ia32_flags_REGS];
extern const arch_register_t ia32_gp_regs[N_ia32_gp_REGS];
extern const arch_register_t ia32_st_regs[N_ia32_st_REGS];
extern const arch_register_t ia32_mmx_regs[N_ia32_mmx_REGS];
extern const arch_register_t ia32_fp_cw_regs[N_ia32_fp_cw_REGS];
extern const arch_register_t ia32_vfp_regs[N_ia32_vfp_REGS];

extern arch_register_class_t ia32_reg_classes[N_CLASSES];

void ia32_register_init(void);



#endif
