#include "gen_mips_regalloc_if.h"


ir_op *op_mips_sw = NULL;
ir_op *op_mips_lbu = NULL;
ir_op *op_mips_SwitchJump = NULL;
ir_op *op_mips_Immediate = NULL;
ir_op *op_mips_seb = NULL;
ir_op *op_mips_lhu = NULL;
ir_op *op_mips_or = NULL;
ir_op *op_mips_mfhi = NULL;
ir_op *op_mips_srl = NULL;
ir_op *op_mips_sh = NULL;
ir_op *op_mips_lb = NULL;
ir_op *op_mips_sra = NULL;
ir_op *op_mips_beq = NULL;
ir_op *op_mips_b = NULL;
ir_op *op_mips_sll = NULL;
ir_op *op_mips_lw = NULL;
ir_op *op_mips_jr = NULL;
ir_op *op_mips_mult = NULL;
ir_op *op_mips_and = NULL;
ir_op *op_mips_seh = NULL;
ir_op *op_mips_lh = NULL;
ir_op *op_mips_div = NULL;
ir_op *op_mips_nop = NULL;
ir_op *op_mips_sltu = NULL;
ir_op *op_mips_bne = NULL;
ir_op *op_mips_subu = NULL;
ir_op *op_mips_nor = NULL;
ir_op *op_mips_multu = NULL;
ir_op *op_mips_blez = NULL;
ir_op *op_mips_addu = NULL;
ir_op *op_mips_mflo = NULL;
ir_op *op_mips_zero = NULL;
ir_op *op_mips_sb = NULL;
ir_op *op_mips_slt = NULL;
ir_op *op_mips_bgtz = NULL;
ir_op *op_mips_xor = NULL;
ir_op *op_mips_lui = NULL;
ir_op *op_mips_divu = NULL;

ir_op *get_op_mips_sw(void)         { return op_mips_sw; }
int    is_mips_sw(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_sw; }

ir_op *get_op_mips_lbu(void)         { return op_mips_lbu; }
int    is_mips_lbu(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_lbu; }

ir_op *get_op_mips_SwitchJump(void)         { return op_mips_SwitchJump; }
int    is_mips_SwitchJump(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_SwitchJump; }

ir_op *get_op_mips_Immediate(void)         { return op_mips_Immediate; }
int    is_mips_Immediate(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_Immediate; }

ir_op *get_op_mips_seb(void)         { return op_mips_seb; }
int    is_mips_seb(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_seb; }

ir_op *get_op_mips_lhu(void)         { return op_mips_lhu; }
int    is_mips_lhu(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_lhu; }

ir_op *get_op_mips_or(void)         { return op_mips_or; }
int    is_mips_or(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_or; }

ir_op *get_op_mips_mfhi(void)         { return op_mips_mfhi; }
int    is_mips_mfhi(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_mfhi; }

ir_op *get_op_mips_srl(void)         { return op_mips_srl; }
int    is_mips_srl(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_srl; }

ir_op *get_op_mips_sh(void)         { return op_mips_sh; }
int    is_mips_sh(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_sh; }

ir_op *get_op_mips_lb(void)         { return op_mips_lb; }
int    is_mips_lb(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_lb; }

ir_op *get_op_mips_sra(void)         { return op_mips_sra; }
int    is_mips_sra(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_sra; }

ir_op *get_op_mips_beq(void)         { return op_mips_beq; }
int    is_mips_beq(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_beq; }

ir_op *get_op_mips_b(void)         { return op_mips_b; }
int    is_mips_b(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_b; }

ir_op *get_op_mips_sll(void)         { return op_mips_sll; }
int    is_mips_sll(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_sll; }

ir_op *get_op_mips_lw(void)         { return op_mips_lw; }
int    is_mips_lw(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_lw; }

ir_op *get_op_mips_jr(void)         { return op_mips_jr; }
int    is_mips_jr(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_jr; }

ir_op *get_op_mips_mult(void)         { return op_mips_mult; }
int    is_mips_mult(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_mult; }

ir_op *get_op_mips_and(void)         { return op_mips_and; }
int    is_mips_and(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_and; }

ir_op *get_op_mips_seh(void)         { return op_mips_seh; }
int    is_mips_seh(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_seh; }

ir_op *get_op_mips_lh(void)         { return op_mips_lh; }
int    is_mips_lh(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_lh; }

ir_op *get_op_mips_div(void)         { return op_mips_div; }
int    is_mips_div(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_div; }

ir_op *get_op_mips_nop(void)         { return op_mips_nop; }
int    is_mips_nop(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_nop; }

ir_op *get_op_mips_sltu(void)         { return op_mips_sltu; }
int    is_mips_sltu(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_sltu; }

ir_op *get_op_mips_bne(void)         { return op_mips_bne; }
int    is_mips_bne(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_bne; }

ir_op *get_op_mips_subu(void)         { return op_mips_subu; }
int    is_mips_subu(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_subu; }

ir_op *get_op_mips_nor(void)         { return op_mips_nor; }
int    is_mips_nor(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_nor; }

ir_op *get_op_mips_multu(void)         { return op_mips_multu; }
int    is_mips_multu(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_multu; }

ir_op *get_op_mips_blez(void)         { return op_mips_blez; }
int    is_mips_blez(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_blez; }

ir_op *get_op_mips_addu(void)         { return op_mips_addu; }
int    is_mips_addu(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_addu; }

ir_op *get_op_mips_mflo(void)         { return op_mips_mflo; }
int    is_mips_mflo(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_mflo; }

ir_op *get_op_mips_zero(void)         { return op_mips_zero; }
int    is_mips_zero(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_zero; }

ir_op *get_op_mips_sb(void)         { return op_mips_sb; }
int    is_mips_sb(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_sb; }

ir_op *get_op_mips_slt(void)         { return op_mips_slt; }
int    is_mips_slt(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_slt; }

ir_op *get_op_mips_bgtz(void)         { return op_mips_bgtz; }
int    is_mips_bgtz(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_bgtz; }

ir_op *get_op_mips_xor(void)         { return op_mips_xor; }
int    is_mips_xor(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_xor; }

ir_op *get_op_mips_lui(void)         { return op_mips_lui; }
int    is_mips_lui(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_lui; }

ir_op *get_op_mips_divu(void)         { return op_mips_divu; }
int    is_mips_divu(const ir_node *n) { return get_mips_irn_opcode(n) == iro_mips_divu; }



static int mips_opcode_start = -1;
static int mips_opcode_end   = -1;


/** A tag for the mips opcodes. Note that the address is used as a tag value, NOT the FOURCC code. */
#define mips_op_tag FOURCC('M', 'I', 'P', 'S')

/** Return the opcode number of the first mips opcode. */
int get_mips_opcode_first(void) {
	return mips_opcode_start;
}

/** Return the opcode number of the last mips opcode + 1. */
int get_mips_opcode_last(void) {
	return mips_opcode_end;
}

/** Return 1 if the given opcode is a mips machine op, 0 otherwise */
int is_mips_op(const ir_op *op) {
	return get_op_tag(op) == mips_op_tag;
}

/** Return 1 if the given node is a mips machine node, 0 otherwise */
int is_mips_irn(const ir_node *node) {
	return is_mips_op(get_irn_op(node));
}

int get_mips_irn_opcode(const ir_node *node) {
	if (is_mips_irn(node))
		return get_irn_opcode(node) - mips_opcode_start;
	return -1;
}

#ifdef BIT
#undef BIT
#endif
#define BIT(x)  (1 << (x % 32))

static const unsigned mips_limit_gp_gp_NOREG[] = { 0, BIT(REG_GP_NOREG), 0 };
static const unsigned mips_limit_gp_zero[] = { BIT(REG_ZERO), 0, 0 };

static const arch_register_req_t mips_requirements_gp_gp = {
	arch_register_req_type_normal,
	& mips_reg_classes[CLASS_mips_gp],
	NULL,        /* limit bitset */
	0,           /* same pos */
	0            /* different pos */
};


static const arch_register_req_t mips_requirements__none = {
	arch_register_req_type_none,
	NULL,                         /* regclass */
	NULL,                         /* limit bitset */
	0,                            /* same pos */
	0                             /* different pos */
};


static const arch_register_req_t mips_requirements_gp_gp_NOREG_I = {
	arch_register_req_type_ignore | arch_register_req_type_limited,
	& mips_reg_classes[CLASS_mips_gp],
	mips_limit_gp_gp_NOREG,
	0,        /* same pos */
	0        /* different pos */
};


static const arch_register_req_t mips_requirements_gp_zero_I = {
	arch_register_req_type_ignore | arch_register_req_type_limited,
	& mips_reg_classes[CLASS_mips_gp],
	mips_limit_gp_zero,
	0,        /* same pos */
	0        /* different pos */
};



/**
 * construct sw node
 */
ir_node *new_bd_mips_sw(dbg_info *db, ir_node *block, ir_node *ptr, ir_node *val, ir_node *mem, ir_entity *entity, long offset)
{
	ir_node  *res;
	ir_op    *op      = op_mips_sw;
	int       flags   = 0;
	int       arity   = 3;
	ir_node  *in[3];
	int       n_res   = 1;
	ir_mode  *mode    = mode_M;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
		& mips_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements__none,
	};

	/* construct in array */
	in[0] = ptr;
	in[1] = val;
	in[2] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);
	init_mips_load_store_attributes(res, entity, offset);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct lbu node
 */
ir_node *new_bd_mips_lbu(dbg_info *db, ir_node *block, ir_node *ptr, ir_node *mem, ir_entity *entity, long offset)
{
	ir_node  *res;
	ir_op    *op      = op_mips_lbu;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements__none,
	};

	/* construct in array */
	in[0] = ptr;
	in[1] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);
	init_mips_load_store_attributes(res, entity, offset);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct SwitchJump node
 */
ir_node *new_bd_mips_SwitchJump(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_mips_SwitchJump;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements__none,
	};

	/* construct in array */
	in[0] = op0;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct Immediate node
 */
ir_node *new_bd_mips_Immediate(dbg_info *db, ir_node *block, mips_immediate_type_t imm_type, ir_entity *entity, long val)
{
	ir_node  *res;
	ir_op    *op      = op_mips_Immediate;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp_NOREG_I,
	};

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);
	init_mips_immediate_attributes(res, imm_type, entity, val);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct seb node
 */
ir_node *new_bd_mips_seb(dbg_info *db, ir_node *block, ir_node *val)
{
	ir_node  *res;
	ir_op    *op      = op_mips_seb;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = val;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct lhu node
 */
ir_node *new_bd_mips_lhu(dbg_info *db, ir_node *block, ir_node *ptr, ir_node *mem, ir_entity *entity, long offset)
{
	ir_node  *res;
	ir_op    *op      = op_mips_lhu;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements__none,
	};

	/* construct in array */
	in[0] = ptr;
	in[1] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);
	init_mips_load_store_attributes(res, entity, offset);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct or node
 */
ir_node *new_bd_mips_or(dbg_info *db, ir_node *block, ir_node *left, ir_node *right)
{
	ir_node  *res;
	ir_op    *op      = op_mips_or;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct mfhi node
 */
ir_node *new_bd_mips_mfhi(dbg_info *db, ir_node *block, ir_node *lohi)
{
	ir_node  *res;
	ir_op    *op      = op_mips_mfhi;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = lohi;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct srl node
 */
ir_node *new_bd_mips_srl(dbg_info *db, ir_node *block, ir_node *left, ir_node *right)
{
	ir_node  *res;
	ir_op    *op      = op_mips_srl;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct sh node
 */
ir_node *new_bd_mips_sh(dbg_info *db, ir_node *block, ir_node *ptr, ir_node *val, ir_node *mem, ir_entity *entity, long offset)
{
	ir_node  *res;
	ir_op    *op      = op_mips_sh;
	int       flags   = 0;
	int       arity   = 3;
	ir_node  *in[3];
	int       n_res   = 1;
	ir_mode  *mode    = mode_M;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
		& mips_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements__none,
	};

	/* construct in array */
	in[0] = ptr;
	in[1] = val;
	in[2] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);
	init_mips_load_store_attributes(res, entity, offset);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct lb node
 */
ir_node *new_bd_mips_lb(dbg_info *db, ir_node *block, ir_node *ptr, ir_node *mem, ir_entity *entity, long offset)
{
	ir_node  *res;
	ir_op    *op      = op_mips_lb;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements__none,
	};

	/* construct in array */
	in[0] = ptr;
	in[1] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);
	init_mips_load_store_attributes(res, entity, offset);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct sra node
 */
ir_node *new_bd_mips_sra(dbg_info *db, ir_node *block, ir_node *left, ir_node *right)
{
	ir_node  *res;
	ir_op    *op      = op_mips_sra;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct beq node
 */
ir_node *new_bd_mips_beq(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_mips_beq;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements__none,
		& mips_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct b node
 */
ir_node *new_bd_mips_b(dbg_info *db, ir_node *block)
{
	ir_node  *res;
	ir_op    *op      = op_mips_b;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	ir_mode  *mode    = mode_X;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements__none,
	};

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct sll node
 */
ir_node *new_bd_mips_sll(dbg_info *db, ir_node *block, ir_node *left, ir_node *right)
{
	ir_node  *res;
	ir_op    *op      = op_mips_sll;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct lw node
 */
ir_node *new_bd_mips_lw(dbg_info *db, ir_node *block, ir_node *ptr, ir_node *mem, ir_entity *entity, long offset)
{
	ir_node  *res;
	ir_op    *op      = op_mips_lw;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements__none,
	};

	/* construct in array */
	in[0] = ptr;
	in[1] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);
	init_mips_load_store_attributes(res, entity, offset);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct jr node
 */
ir_node *new_bd_mips_jr(dbg_info *db, ir_node *block, ir_node *op0)
{
	ir_node  *res;
	ir_op    *op      = op_mips_jr;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	ir_mode  *mode    = mode_X;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements__none,
	};

	/* construct in array */
	in[0] = op0;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct mult node
 */
ir_node *new_bd_mips_mult(dbg_info *db, ir_node *block, ir_node *left, ir_node *right)
{
	ir_node  *res;
	ir_op    *op      = op_mips_mult;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	ir_mode  *mode    = mode_M;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements__none,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct and node
 */
ir_node *new_bd_mips_and(dbg_info *db, ir_node *block, ir_node *left, ir_node *right)
{
	ir_node  *res;
	ir_op    *op      = op_mips_and;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct seh node
 */
ir_node *new_bd_mips_seh(dbg_info *db, ir_node *block, ir_node *val)
{
	ir_node  *res;
	ir_op    *op      = op_mips_seh;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = val;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct lh node
 */
ir_node *new_bd_mips_lh(dbg_info *db, ir_node *block, ir_node *ptr, ir_node *mem, ir_entity *entity, long offset)
{
	ir_node  *res;
	ir_op    *op      = op_mips_lh;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements__none,
	};

	/* construct in array */
	in[0] = ptr;
	in[1] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);
	init_mips_load_store_attributes(res, entity, offset);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct div node
 */
ir_node *new_bd_mips_div(dbg_info *db, ir_node *block, ir_node *left, ir_node *right)
{
	ir_node  *res;
	ir_op    *op      = op_mips_div;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_M;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements__none,
		& mips_requirements__none,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct nop node
 */
ir_node *new_bd_mips_nop(dbg_info *db, ir_node *block, ir_mode *mode)
{
	ir_node  *res;
	ir_op    *op      = op_mips_nop;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements__none,
	};

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct sltu node
 */
ir_node *new_bd_mips_sltu(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_mips_sltu;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct bne node
 */
ir_node *new_bd_mips_bne(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_mips_bne;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements__none,
		& mips_requirements__none,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct subu node
 */
ir_node *new_bd_mips_subu(dbg_info *db, ir_node *block, ir_node *left, ir_node *right)
{
	ir_node  *res;
	ir_op    *op      = op_mips_subu;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct nor node
 */
ir_node *new_bd_mips_nor(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_mips_nor;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct multu node
 */
ir_node *new_bd_mips_multu(dbg_info *db, ir_node *block, ir_node *left, ir_node *right)
{
	ir_node  *res;
	ir_op    *op      = op_mips_multu;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	ir_mode  *mode    = mode_M;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements__none,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct blez node
 */
ir_node *new_bd_mips_blez(dbg_info *db, ir_node *block, ir_node *op0)
{
	ir_node  *res;
	ir_op    *op      = op_mips_blez;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements__none,
		& mips_requirements__none,
	};

	/* construct in array */
	in[0] = op0;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct addu node
 */
ir_node *new_bd_mips_addu(dbg_info *db, ir_node *block, ir_node *left, ir_node *right)
{
	ir_node  *res;
	ir_op    *op      = op_mips_addu;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct mflo node
 */
ir_node *new_bd_mips_mflo(dbg_info *db, ir_node *block, ir_node *lohi)
{
	ir_node  *res;
	ir_op    *op      = op_mips_mflo;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = lohi;

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct zero node
 */
ir_node *new_bd_mips_zero(dbg_info *db, ir_node *block)
{
	ir_node  *res;
	ir_op    *op      = op_mips_zero;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_zero_I,
	};

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct sb node
 */
ir_node *new_bd_mips_sb(dbg_info *db, ir_node *block, ir_node *ptr, ir_node *val, ir_node *mem, ir_entity *entity, long offset)
{
	ir_node  *res;
	ir_op    *op      = op_mips_sb;
	int       flags   = 0;
	int       arity   = 3;
	ir_node  *in[3];
	int       n_res   = 1;
	ir_mode  *mode    = mode_M;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
		& mips_requirements__none,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements__none,
	};

	/* construct in array */
	in[0] = ptr;
	in[1] = val;
	in[2] = mem;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);
	init_mips_load_store_attributes(res, entity, offset);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct slt node
 */
ir_node *new_bd_mips_slt(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1)
{
	ir_node  *res;
	ir_op    *op      = op_mips_slt;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = op0;
	in[1] = op1;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct bgtz node
 */
ir_node *new_bd_mips_bgtz(dbg_info *db, ir_node *block, ir_node *op0)
{
	ir_node  *res;
	ir_op    *op      = op_mips_bgtz;
	int       flags   = 0;
	int       arity   = 1;
	ir_node  *in[1];
	int       n_res   = 2;
	ir_mode  *mode    = mode_T;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements__none,
		& mips_requirements__none,
	};

	/* construct in array */
	in[0] = op0;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct xor node
 */
ir_node *new_bd_mips_xor(dbg_info *db, ir_node *block, ir_node *left, ir_node *right)
{
	ir_node  *res;
	ir_op    *op      = op_mips_xor;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct lui node
 */
ir_node *new_bd_mips_lui(dbg_info *db, ir_node *block, mips_immediate_type_t imm_type, ir_entity *entity, long val)
{
	ir_node  *res;
	ir_op    *op      = op_mips_lui;
	int       flags   = 0;
	int       arity   = 0;
	ir_node **in    = NULL;
	int       n_res   = 1;
	ir_mode  *mode    = mode_Iu;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t **in_reqs = NULL;
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements_gp_gp,
	};

	/* flags */
	flags |= arch_irn_flags_rematerializable;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);
	init_mips_immediate_attributes(res, imm_type, entity, val);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * construct divu node
 */
ir_node *new_bd_mips_divu(dbg_info *db, ir_node *block, ir_node *left, ir_node *right)
{
	ir_node  *res;
	ir_op    *op      = op_mips_divu;
	int       flags   = 0;
	int       arity   = 2;
	ir_node  *in[2];
	int       n_res   = 2;
	ir_mode  *mode    = mode_M;
	static const be_execution_unit_t ***exec_units = NULL;
	static const arch_register_req_t *in_reqs[] =
	{
		& mips_requirements_gp_gp,
		& mips_requirements_gp_gp,
	};
	static const arch_register_req_t *out_reqs[] =
	{
		& mips_requirements__none,
		& mips_requirements__none,
	};

	/* construct in array */
	in[0] = left;
	in[1] = right;

	/* create node */
	assert(op != NULL);
	res = new_ir_node(db, current_ir_graph, block, op, mode, arity, in);

	/* init node attributes */
	init_mips_attributes(res, flags, in_reqs, out_reqs, exec_units, n_res);

	/* optimize node */
	res = optimize_node(res);
	irn_vrfy_irg(res, current_ir_graph);

	return res;
}

/**
 * Creates the mips specific Firm machine operations
 * needed for the assembler irgs.
 */
void mips_create_opcodes(const arch_irn_ops_t *be_ops) {
#define N   irop_flag_none
#define L   irop_flag_labeled
#define C   irop_flag_commutative
#define X   irop_flag_cfopcode
#define I   irop_flag_ip_cfopcode
#define F   irop_flag_fragile
#define Y   irop_flag_forking
#define H   irop_flag_highlevel
#define c   irop_flag_constlike
#define K   irop_flag_keep
#define M   irop_flag_machine
#define O   irop_flag_machine_op
#define NB  irop_flag_dump_noblock
#define NI  irop_flag_dump_noinput
#define R   (irop_flag_user << 0)

	ir_op_ops  ops;
	int        cur_opcode;
	static int run_once = 0;
	int        i;

	if (run_once)
		return;
	run_once = 1;
	
	/* we handle all middleend nodes as well that have no other handler */
	for (i = 0; i <= iro_Last; ++i) {
		ir_op *op      = get_irp_opcode(i);
		if (op->ops.be_ops == NULL)
			op->ops.be_ops = be_ops;
	}

	cur_opcode = get_next_ir_opcodes(iro_mips_last);
  
	mips_opcode_start = cur_opcode;

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_load_store_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_sw = new_ir_op(cur_opcode + iro_mips_sw, "mips_sw", op_pin_state_exc_pinned, L|F|M, oparity_trinary, 0, sizeof(mips_load_store_attr_t), &ops);
	set_op_tag(op_mips_sw, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_load_store_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_lbu = new_ir_op(cur_opcode + iro_mips_lbu, "mips_lbu", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(mips_load_store_attr_t), &ops);
	set_op_tag(op_mips_lbu, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_SwitchJump = new_ir_op(cur_opcode + iro_mips_SwitchJump, "mips_SwitchJump", op_pin_state_floats, X|M, oparity_unary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_SwitchJump, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_immediate_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_Immediate = new_ir_op(cur_opcode + iro_mips_Immediate, "mips_Immediate", op_pin_state_pinned, c|M, oparity_zero, 0, sizeof(mips_immediate_attr_t), &ops);
	set_op_tag(op_mips_Immediate, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_seb = new_ir_op(cur_opcode + iro_mips_seb, "mips_seb", op_pin_state_floats, R|M, oparity_unary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_seb, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_load_store_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_lhu = new_ir_op(cur_opcode + iro_mips_lhu, "mips_lhu", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(mips_load_store_attr_t), &ops);
	set_op_tag(op_mips_lhu, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_or = new_ir_op(cur_opcode + iro_mips_or, "mips_or", op_pin_state_floats, R|M, oparity_binary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_or, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_mfhi = new_ir_op(cur_opcode + iro_mips_mfhi, "mips_mfhi", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_mfhi, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_srl = new_ir_op(cur_opcode + iro_mips_srl, "mips_srl", op_pin_state_floats, R|M, oparity_binary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_srl, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_load_store_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_sh = new_ir_op(cur_opcode + iro_mips_sh, "mips_sh", op_pin_state_exc_pinned, L|F|M, oparity_trinary, 0, sizeof(mips_load_store_attr_t), &ops);
	set_op_tag(op_mips_sh, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_load_store_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_lb = new_ir_op(cur_opcode + iro_mips_lb, "mips_lb", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(mips_load_store_attr_t), &ops);
	set_op_tag(op_mips_lb, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_sra = new_ir_op(cur_opcode + iro_mips_sra, "mips_sra", op_pin_state_floats, R|M, oparity_binary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_sra, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_beq = new_ir_op(cur_opcode + iro_mips_beq, "mips_beq", op_pin_state_floats, X|Y|M, oparity_binary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_beq, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_b = new_ir_op(cur_opcode + iro_mips_b, "mips_b", op_pin_state_floats, X|M, oparity_zero, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_b, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_sll = new_ir_op(cur_opcode + iro_mips_sll, "mips_sll", op_pin_state_floats, R|M, oparity_binary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_sll, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_load_store_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_lw = new_ir_op(cur_opcode + iro_mips_lw, "mips_lw", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(mips_load_store_attr_t), &ops);
	set_op_tag(op_mips_lw, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_jr = new_ir_op(cur_opcode + iro_mips_jr, "mips_jr", op_pin_state_floats, X|M, oparity_unary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_jr, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_mult = new_ir_op(cur_opcode + iro_mips_mult, "mips_mult", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_mult, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_and = new_ir_op(cur_opcode + iro_mips_and, "mips_and", op_pin_state_floats, R|M, oparity_binary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_and, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_seh = new_ir_op(cur_opcode + iro_mips_seh, "mips_seh", op_pin_state_floats, R|M, oparity_unary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_seh, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_load_store_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_lh = new_ir_op(cur_opcode + iro_mips_lh, "mips_lh", op_pin_state_exc_pinned, L|F|M, oparity_binary, 0, sizeof(mips_load_store_attr_t), &ops);
	set_op_tag(op_mips_lh, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_div = new_ir_op(cur_opcode + iro_mips_div, "mips_div", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_div, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_nop = new_ir_op(cur_opcode + iro_mips_nop, "mips_nop", op_pin_state_floats, K|M, oparity_zero, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_nop, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_sltu = new_ir_op(cur_opcode + iro_mips_sltu, "mips_sltu", op_pin_state_floats, R|M, oparity_binary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_sltu, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_bne = new_ir_op(cur_opcode + iro_mips_bne, "mips_bne", op_pin_state_floats, X|Y|M, oparity_binary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_bne, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_subu = new_ir_op(cur_opcode + iro_mips_subu, "mips_subu", op_pin_state_floats, R|M, oparity_binary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_subu, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_nor = new_ir_op(cur_opcode + iro_mips_nor, "mips_nor", op_pin_state_floats, R|M, oparity_binary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_nor, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_multu = new_ir_op(cur_opcode + iro_mips_multu, "mips_multu", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_multu, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_blez = new_ir_op(cur_opcode + iro_mips_blez, "mips_blez", op_pin_state_floats, X|Y|M, oparity_unary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_blez, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_addu = new_ir_op(cur_opcode + iro_mips_addu, "mips_addu", op_pin_state_floats, R|M, oparity_binary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_addu, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_mflo = new_ir_op(cur_opcode + iro_mips_mflo, "mips_mflo", op_pin_state_floats, N|M, oparity_unary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_mflo, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_zero = new_ir_op(cur_opcode + iro_mips_zero, "mips_zero", op_pin_state_pinned, c|M, oparity_zero, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_zero, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_load_store_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_sb = new_ir_op(cur_opcode + iro_mips_sb, "mips_sb", op_pin_state_exc_pinned, L|F|M, oparity_trinary, 0, sizeof(mips_load_store_attr_t), &ops);
	set_op_tag(op_mips_sb, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_slt = new_ir_op(cur_opcode + iro_mips_slt, "mips_slt", op_pin_state_floats, R|M, oparity_binary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_slt, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_bgtz = new_ir_op(cur_opcode + iro_mips_bgtz, "mips_bgtz", op_pin_state_floats, X|Y|M, oparity_unary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_bgtz, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_xor = new_ir_op(cur_opcode + iro_mips_xor, "mips_xor", op_pin_state_floats, R|M, oparity_binary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_xor, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_immediate_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_lui = new_ir_op(cur_opcode + iro_mips_lui, "mips_lui", op_pin_state_floats, c|M, oparity_zero, 0, sizeof(mips_immediate_attr_t), &ops);
	set_op_tag(op_mips_lui, mips_op_tag);

	memset(&ops, 0, sizeof(ops));
	ops.be_ops        = be_ops;
	ops.dump_node     = mips_dump_node;
	ops.node_cmp_attr = mips_compare_nodes_attr;
	ops.copy_attr = mips_copy_attr;
	op_mips_divu = new_ir_op(cur_opcode + iro_mips_divu, "mips_divu", op_pin_state_floats, N|M, oparity_binary, 0, sizeof(mips_attr_t), &ops);
	set_op_tag(op_mips_divu, mips_op_tag);

	mips_opcode_end = cur_opcode + iro_mips_last;
}
