/**
 * @file
 * @brief Function prototypes for the new opcode functions.
 * @note  DO NOT EDIT THIS FILE, your changes will be lost.
 *        Edit libfirm/ir/be/ppc32/ppc32_spec.pl instead.
 *        created by: libfirm/ir/be/scripts/generate_new_opcodes.pl libfirm/ir/be/ppc32/ppc32_spec.pl libfirm/ir/be/ppc32
 * @date  Tue Jan 20 10:57:59 2009
 */
#ifndef FIRM_BE_PPC32_GEN_PPC32_NEW_NODES_H
#define FIRM_BE_PPC32_GEN_PPC32_NEW_NODES_H

typedef enum _ppc32_opcodes {
	iro_ppc32_fConst,
	iro_ppc32_fMul,
	iro_ppc32_fDivs,
	iro_ppc32_fSubs,
	iro_ppc32_Addis_zero,
	iro_ppc32_Cmpli,
	iro_ppc32_Cmp,
	iro_ppc32_Sraw,
	iro_ppc32_Slw,
	iro_ppc32_Lfd,
	iro_ppc32_Addi,
	iro_ppc32_cUnknown,
	iro_ppc32_Stb,
	iro_ppc32_Switch,
	iro_ppc32_Branch,
	iro_ppc32_Mullw,
	iro_ppc32_Lfs,
	iro_ppc32_Sth,
	iro_ppc32_fDiv,
	iro_ppc32_Divw,
	iro_ppc32_Rlwnm,
	iro_ppc32_Sub,
	iro_ppc32_fCmpu,
	iro_ppc32_Srawi,
	iro_ppc32_Cmpi,
	iro_ppc32_Lhz,
	iro_ppc32_Stw,
	iro_ppc32_Cmpl,
	iro_ppc32_fMinus,
	iro_ppc32_fMax,
	iro_ppc32_Lwz,
	iro_ppc32_Stfs,
	iro_ppc32_Andi_dot,
	iro_ppc32_fSub,
	iro_ppc32_Lha,
	iro_ppc32_fAdds,
	iro_ppc32_Const,
	iro_ppc32_Lbz,
	iro_ppc32_Xor,
	iro_ppc32_Or,
	iro_ppc32_Rlwinm,
	iro_ppc32_fAdd,
	iro_ppc32_Lwzu,
	iro_ppc32_Add,
	iro_ppc32_Mulhwu,
	iro_ppc32_LoopCopy,
	iro_ppc32_Addi_zero,
	iro_ppc32_fMin,
	iro_ppc32_Unknown,
	iro_ppc32_Ori,
	iro_ppc32_fMuls,
	iro_ppc32_fAbs,
	iro_ppc32_Extsh,
	iro_ppc32_Extsb,
	iro_ppc32_fRsp,
	iro_ppc32_Srw,
	iro_ppc32_Neg,
	iro_ppc32_fCtiw,
	iro_ppc32_Divwu,
	iro_ppc32_fNeg,
	iro_ppc32_Not,
	iro_ppc32_Mtctr,
	iro_ppc32_fUnknown,
	iro_ppc32_And,
	iro_ppc32_Mulhw,
	iro_ppc32_Stfd,
	iro_ppc32_SymConst,
	iro_ppc32_last_generated,
	iro_ppc32_last = iro_ppc32_last_generated
} ppc32_opcodes;

int is_ppc32_irn(const ir_node *node);

int get_ppc32_opcode_first(void);
int get_ppc32_opcode_last(void);
int get_ppc32_irn_opcode(const ir_node *node);
void ppc32_create_opcodes(const arch_irn_ops_t *be_ops);
extern ir_op *op_ppc32_fConst;
ir_op *get_op_ppc32_fConst(void);
int is_ppc32_fConst(const ir_node *n);
/**
 * float Const (high-level node)
 */
ir_node *new_bd_ppc32_fConst(dbg_info *db, ir_node *block, ir_mode *mode);

extern ir_op *op_ppc32_fMul;
ir_op *get_op_ppc32_fMul(void);
int is_ppc32_fMul(const ir_node *n);
/**
 * construct FP Mul: Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_ppc32_fMul(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_fDivs;
ir_op *get_op_ppc32_fDivs(void);
int is_ppc32_fDivs(const ir_node *n);
/**
 * construct FP Div (single): Div(a, b) = a / b
 */
ir_node *new_bd_ppc32_fDivs(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_fSubs;
ir_op *get_op_ppc32_fSubs(void);
int is_ppc32_fSubs(const ir_node *n);
/**
 * construct FP Sub (single): Sub(a, b) = a - b
 */
ir_node *new_bd_ppc32_fSubs(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Addis_zero;
ir_op *get_op_ppc32_Addis_zero(void);
int is_ppc32_Addis_zero(const ir_node *n);
/**
 * load the constant to higher 16 bit of register
 */
ir_node *new_bd_ppc32_Addis_zero(dbg_info *db, ir_node *block, ir_mode *mode, ppc32_attr_offset_mode om, tarval *tv, ident *id);

extern ir_op *op_ppc32_Cmpli;
ir_op *get_op_ppc32_Cmpli(void);
int is_ppc32_Cmpli(const ir_node *n);
/**
 * construct Cmp logical immediate: Cmpli(a, const) = Flags in crX
 */
ir_node *new_bd_ppc32_Cmpli(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ppc32_Cmp;
ir_op *get_op_ppc32_Cmp(void);
int is_ppc32_Cmp(const ir_node *n);
/**
 * construct Cmp: Cmp(a, b) = Flags in crX
 */
ir_node *new_bd_ppc32_Cmp(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Sraw;
ir_op *get_op_ppc32_Sraw(void);
int is_ppc32_Sraw(const ir_node *n);
/**
 * construct Shrs: Sraw(a, b): c = a >> b
 */
ir_node *new_bd_ppc32_Sraw(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Slw;
ir_op *get_op_ppc32_Slw(void);
int is_ppc32_Slw(const ir_node *n);
/**
 * construct Shl: Shl(a, b) = a << b
 */
ir_node *new_bd_ppc32_Slw(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Lfd;
ir_op *get_op_ppc32_Lfd(void);
int is_ppc32_Lfd(const ir_node *n);
/**
 * construct FP Load (double): Load(ptr, mem) = LD ptr
 */
ir_node *new_bd_ppc32_Lfd(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_ppc32_Addi;
ir_op *get_op_ppc32_Addi(void);
int is_ppc32_Addi(const ir_node *n);
/**
 * construct Add: Addi(a, const) = Addi(const, a) = a + const
 */
ir_node *new_bd_ppc32_Addi(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ppc32_cUnknown;
ir_op *get_op_ppc32_cUnknown(void);
int is_ppc32_cUnknown(const ir_node *n);
/**
 * construct unknown condition register
 */
ir_node *new_bd_ppc32_cUnknown(dbg_info *db, ir_node *block, ir_mode *mode);

extern ir_op *op_ppc32_Stb;
ir_op *get_op_ppc32_Stb(void);
int is_ppc32_Stb(const ir_node *n);
/**
 * construct Store: Store (byte) (ptr, val, mem) = ST ptr,val
 */
ir_node *new_bd_ppc32_Stb(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2);

extern ir_op *op_ppc32_Switch;
ir_op *get_op_ppc32_Switch(void);
int is_ppc32_Switch(const ir_node *n);
/**
 * construct Switch(selector): Jump to whatever
 */
ir_node *new_bd_ppc32_Switch(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_mode *mode);

extern ir_op *op_ppc32_Branch;
ir_op *get_op_ppc32_Branch(void);
int is_ppc32_Branch(const ir_node *n);
/**
 * branch somewhere
 */
ir_node *new_bd_ppc32_Branch(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ppc32_Mullw;
ir_op *get_op_ppc32_Mullw(void);
int is_ppc32_Mullw(const ir_node *n);
/**
 * construct Mul: Mullw(a, b) = Mullw(b, a) = lo32(a * b)
 */
ir_node *new_bd_ppc32_Mullw(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Lfs;
ir_op *get_op_ppc32_Lfs(void);
int is_ppc32_Lfs(const ir_node *n);
/**
 * construct FP Load (single): Load(ptr, mem) = LD ptr
 */
ir_node *new_bd_ppc32_Lfs(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_ppc32_Sth;
ir_op *get_op_ppc32_Sth(void);
int is_ppc32_Sth(const ir_node *n);
/**
 * construct Store: Store (halfword) (ptr, val, mem) = ST ptr,val
 */
ir_node *new_bd_ppc32_Sth(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2);

extern ir_op *op_ppc32_fDiv;
ir_op *get_op_ppc32_fDiv(void);
int is_ppc32_fDiv(const ir_node *n);
/**
 * construct FP Div: Div(a, b) = a / b
 */
ir_node *new_bd_ppc32_fDiv(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Divw;
ir_op *get_op_ppc32_Divw(void);
int is_ppc32_Divw(const ir_node *n);
/**
 * construct Div (signed): Div(a, b) = a div b
 */
ir_node *new_bd_ppc32_Divw(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Rlwnm;
ir_op *get_op_ppc32_Rlwnm(void);
int is_ppc32_Rlwnm(const ir_node *n);
/**
 * construct ???: Rlwnm(a, b): c = a ROTL b
 */
ir_node *new_bd_ppc32_Rlwnm(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Sub;
ir_op *get_op_ppc32_Sub(void);
int is_ppc32_Sub(const ir_node *n);
/**
 * construct Sub: Sub(a, b) = a - b
 */
ir_node *new_bd_ppc32_Sub(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_fCmpu;
ir_op *get_op_ppc32_fCmpu(void);
int is_ppc32_fCmpu(const ir_node *n);
/**
 * construct FP Cmp unordered: fCmpu(a, b) = a ? b
 */
ir_node *new_bd_ppc32_fCmpu(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Srawi;
ir_op *get_op_ppc32_Srawi(void);
int is_ppc32_Srawi(const ir_node *n);
/**
 * construct Shrs: Srawi(a, const): c = a >> const
 */
ir_node *new_bd_ppc32_Srawi(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ppc32_Cmpi;
ir_op *get_op_ppc32_Cmpi(void);
int is_ppc32_Cmpi(const ir_node *n);
/**
 * construct Cmp immediate: Cmpi(a, const) = Flags in crX
 */
ir_node *new_bd_ppc32_Cmpi(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ppc32_Lhz;
ir_op *get_op_ppc32_Lhz(void);
int is_ppc32_Lhz(const ir_node *n);
/**
 * construct Load (halfword unsigned): Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_ppc32_Lhz(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_ppc32_Stw;
ir_op *get_op_ppc32_Stw(void);
int is_ppc32_Stw(const ir_node *n);
/**
 * construct Store: Store (word) (ptr, val, mem) = ST ptr,val
 */
ir_node *new_bd_ppc32_Stw(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2);

extern ir_op *op_ppc32_Cmpl;
ir_op *get_op_ppc32_Cmpl(void);
int is_ppc32_Cmpl(const ir_node *n);
/**
 * construct Cmp logical: Cmpl(a, b) = Flags in crX
 */
ir_node *new_bd_ppc32_Cmpl(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_fMinus;
ir_op *get_op_ppc32_fMinus(void);
int is_ppc32_fMinus(const ir_node *n);
/**
 * construct FP Minus: fMinus(a) = -a
 */
ir_node *new_bd_ppc32_fMinus(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ppc32_fMax;
ir_op *get_op_ppc32_fMax(void);
int is_ppc32_fMax(const ir_node *n);
/**
 * construct FP Max: Max(a, b) = Max(b, a) = a > b ? a : b
 */
ir_node *new_bd_ppc32_fMax(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Lwz;
ir_op *get_op_ppc32_Lwz(void);
int is_ppc32_Lwz(const ir_node *n);
/**
 * construct Load (word): Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_ppc32_Lwz(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_ppc32_Stfs;
ir_op *get_op_ppc32_Stfs(void);
int is_ppc32_Stfs(const ir_node *n);
/**
 * construct Store (single): Store(ptr, val, mem)  = ST ptr,val
 */
ir_node *new_bd_ppc32_Stfs(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2);

extern ir_op *op_ppc32_Andi_dot;
ir_op *get_op_ppc32_Andi_dot(void);
int is_ppc32_Andi_dot(const ir_node *n);
/**
 * ands constant with register with cr0 update
 */
ir_node *new_bd_ppc32_Andi_dot(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ppc32_fSub;
ir_op *get_op_ppc32_fSub(void);
int is_ppc32_fSub(const ir_node *n);
/**
 * construct FP Sub: Sub(a, b) = a - b
 */
ir_node *new_bd_ppc32_fSub(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Lha;
ir_op *get_op_ppc32_Lha(void);
int is_ppc32_Lha(const ir_node *n);
/**
 * construct Load (halfword signed): Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_ppc32_Lha(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_ppc32_fAdds;
ir_op *get_op_ppc32_fAdds(void);
int is_ppc32_fAdds(const ir_node *n);
/**
 * construct FP Add (single): Add(a, b) = Add(b, a) = a + b
 */
ir_node *new_bd_ppc32_fAdds(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Const;
ir_op *get_op_ppc32_Const(void);
int is_ppc32_Const(const ir_node *n);
/**
 * Const (high-level node)
 */
ir_node *new_bd_ppc32_Const(dbg_info *db, ir_node *block, ir_mode *mode);

extern ir_op *op_ppc32_Lbz;
ir_op *get_op_ppc32_Lbz(void);
int is_ppc32_Lbz(const ir_node *n);
/**
 * construct Load (byte unsigned): Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_ppc32_Lbz(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_ppc32_Xor;
ir_op *get_op_ppc32_Xor(void);
int is_ppc32_Xor(const ir_node *n);
/**
 * construct Xor: Xor(a, b) = Xor(b, a) = a XOR b
 */
ir_node *new_bd_ppc32_Xor(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Or;
ir_op *get_op_ppc32_Or(void);
int is_ppc32_Or(const ir_node *n);
/**
 * construct Or: Or(a, b) = Or(b, a) = a OR b
 */
ir_node *new_bd_ppc32_Or(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Rlwinm;
ir_op *get_op_ppc32_Rlwinm(void);
int is_ppc32_Rlwinm(const ir_node *n);
/**
 * construct ???: Rlwinm(a, b_const, c_const, d_const): (m = MASK(c, d)) e = (a ROTL b) & m
 */
ir_node *new_bd_ppc32_Rlwinm(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ppc32_fAdd;
ir_op *get_op_ppc32_fAdd(void);
int is_ppc32_fAdd(const ir_node *n);
/**
 * construct FP Add: Add(a, b) = Add(b, a) = a + b
 */
ir_node *new_bd_ppc32_fAdd(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Lwzu;
ir_op *get_op_ppc32_Lwzu(void);
int is_ppc32_Lwzu(const ir_node *n);
/**
 * construct Load with update (word): Load(ptr, mem) = LD ptr -> reg
 */
ir_node *new_bd_ppc32_Lwzu(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_ppc32_Add;
ir_op *get_op_ppc32_Add(void);
int is_ppc32_Add(const ir_node *n);
/**
 * construct Add: Add(a, b) = Add(b, a) = a + b
 */
ir_node *new_bd_ppc32_Add(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Mulhwu;
ir_op *get_op_ppc32_Mulhwu(void);
int is_ppc32_Mulhwu(const ir_node *n);
/**
 * construct Mul: Mulhwu(a, b) = Mulhwu(b, a) = hi32(a * b)
 */
ir_node *new_bd_ppc32_Mulhwu(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_LoopCopy;
ir_op *get_op_ppc32_LoopCopy(void);
int is_ppc32_LoopCopy(const ir_node *n);
/**
 * construct LoopCopy(src, dest, count, mem): Copy count words from src to dest
 */
ir_node *new_bd_ppc32_LoopCopy(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2, ir_node *op3, ir_mode *mode);

extern ir_op *op_ppc32_Addi_zero;
ir_op *get_op_ppc32_Addi_zero(void);
int is_ppc32_Addi_zero(const ir_node *n);
/**
 * load constant (16bit with sign extension)
 */
ir_node *new_bd_ppc32_Addi_zero(dbg_info *db, ir_node *block, ir_mode *mode);

extern ir_op *op_ppc32_fMin;
ir_op *get_op_ppc32_fMin(void);
int is_ppc32_fMin(const ir_node *n);
/**
 * construct FP Min: Min(a, b) = Min(b, a) = a < b ? a : b
 */
ir_node *new_bd_ppc32_fMin(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Unknown;
ir_op *get_op_ppc32_Unknown(void);
int is_ppc32_Unknown(const ir_node *n);
/**
 * construct unknown register
 */
ir_node *new_bd_ppc32_Unknown(dbg_info *db, ir_node *block, ir_mode *mode);

extern ir_op *op_ppc32_Ori;
ir_op *get_op_ppc32_Ori(void);
int is_ppc32_Ori(const ir_node *n);
/**
 * ors constant with register
 */
ir_node *new_bd_ppc32_Ori(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ppc32_fMuls;
ir_op *get_op_ppc32_fMuls(void);
int is_ppc32_fMuls(const ir_node *n);
/**
 * construct FP Mul (single): Mul(a, b) = Mul(b, a) = a * b
 */
ir_node *new_bd_ppc32_fMuls(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_fAbs;
ir_op *get_op_ppc32_fAbs(void);
int is_ppc32_fAbs(const ir_node *n);
/**
 * construct FP Abs: fAbs(a) = |a|
 */
ir_node *new_bd_ppc32_fAbs(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ppc32_Extsh;
ir_op *get_op_ppc32_Extsh(void);
int is_ppc32_Extsh(const ir_node *n);
/**
 * construct Sign extension of halfword: Extsh(char a) = (short) a
 */
ir_node *new_bd_ppc32_Extsh(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ppc32_Extsb;
ir_op *get_op_ppc32_Extsb(void);
int is_ppc32_Extsb(const ir_node *n);
/**
 * construct Sign extension of byte: Extsb(char a) = (int) a
 */
ir_node *new_bd_ppc32_Extsb(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ppc32_fRsp;
ir_op *get_op_ppc32_fRsp(void);
int is_ppc32_fRsp(const ir_node *n);
/**
 * construct FP Round to single: fRsp(a) = (float) a
 */
ir_node *new_bd_ppc32_fRsp(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ppc32_Srw;
ir_op *get_op_ppc32_Srw(void);
int is_ppc32_Srw(const ir_node *n);
/**
 * construct Shr: Srw(a, b): c = a >> b
 */
ir_node *new_bd_ppc32_Srw(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Neg;
ir_op *get_op_ppc32_Neg(void);
int is_ppc32_Neg(const ir_node *n);
/**
 * construct Minus: Neg(a) = -a
 */
ir_node *new_bd_ppc32_Neg(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ppc32_fCtiw;
ir_op *get_op_ppc32_fCtiw(void);
int is_ppc32_fCtiw(const ir_node *n);
/**
 * construct FP Convert to integer word: fCtiw(a) = (int) a
 */
ir_node *new_bd_ppc32_fCtiw(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ppc32_Divwu;
ir_op *get_op_ppc32_Divwu(void);
int is_ppc32_Divwu(const ir_node *n);
/**
 * construct Div (unsigned): Div(a, b) = a div b
 */
ir_node *new_bd_ppc32_Divwu(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_fNeg;
ir_op *get_op_ppc32_fNeg(void);
int is_ppc32_fNeg(const ir_node *n);
/**
 * construct FP Negation: fNeg(a) = -a
 */
ir_node *new_bd_ppc32_fNeg(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ppc32_Not;
ir_op *get_op_ppc32_Not(void);
int is_ppc32_Not(const ir_node *n);
/**
 * construct Not: Not(a) = !a
 */
ir_node *new_bd_ppc32_Not(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ppc32_Mtctr;
ir_op *get_op_ppc32_Mtctr(void);
int is_ppc32_Mtctr(const ir_node *n);
/**
 * construct Mtctr: Ctr = a
 */
ir_node *new_bd_ppc32_Mtctr(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_ppc32_fUnknown;
ir_op *get_op_ppc32_fUnknown(void);
int is_ppc32_fUnknown(const ir_node *n);
/**
 * construct unknown floating point register
 */
ir_node *new_bd_ppc32_fUnknown(dbg_info *db, ir_node *block, ir_mode *mode);

extern ir_op *op_ppc32_And;
ir_op *get_op_ppc32_And(void);
int is_ppc32_And(const ir_node *n);
/**
 * construct And: And(a, b) = And(b, a) = a AND b
 */
ir_node *new_bd_ppc32_And(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Mulhw;
ir_op *get_op_ppc32_Mulhw(void);
int is_ppc32_Mulhw(const ir_node *n);
/**
 * construct Mul: Mulhw(a, b) = Mulhw(b, a) = hi32(a * b)
 */
ir_node *new_bd_ppc32_Mulhw(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *mode);

extern ir_op *op_ppc32_Stfd;
ir_op *get_op_ppc32_Stfd(void);
int is_ppc32_Stfd(const ir_node *n);
/**
 * construct Store (double): Store(ptr, val, mem)  = ST ptr,val
 */
ir_node *new_bd_ppc32_Stfd(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1, ir_node *op2);

extern ir_op *op_ppc32_SymConst;
ir_op *get_op_ppc32_SymConst(void);
int is_ppc32_SymConst(const ir_node *n);
/**
 * SymConst (high-level node)
 */
ir_node *new_bd_ppc32_SymConst(dbg_info *db, ir_node *block, ir_mode *mode);


enum pn_ppc32_Lfd {
	pn_ppc32_Lfd_res = 0,
	pn_ppc32_Lfd_M = 1,
};

enum pn_ppc32_Stb {
	pn_ppc32_Stb_M = 0,
};

enum pn_ppc32_Lfs {
	pn_ppc32_Lfs_res = 0,
	pn_ppc32_Lfs_M = 1,
};

enum pn_ppc32_Sth {
	pn_ppc32_Sth_M = 0,
};

enum pn_ppc32_Lhz {
	pn_ppc32_Lhz_res = 0,
	pn_ppc32_Lhz_M = 1,
};

enum pn_ppc32_Stw {
	pn_ppc32_Stw_M = 0,
};

enum pn_ppc32_Lwz {
	pn_ppc32_Lwz_res = 0,
	pn_ppc32_Lwz_M = 1,
};

enum pn_ppc32_Stfs {
	pn_ppc32_Stfs_M = 0,
};

enum pn_ppc32_Lha {
	pn_ppc32_Lha_res = 0,
	pn_ppc32_Lha_M = 1,
};

enum pn_ppc32_Lbz {
	pn_ppc32_Lbz_res = 0,
	pn_ppc32_Lbz_M = 1,
};

enum pn_ppc32_Lwzu {
	pn_ppc32_Lwzu_res = 0,
	pn_ppc32_Lwzu_ptr = 1,
	pn_ppc32_Lwzu_M = 2,
};

enum pn_ppc32_Stfd {
	pn_ppc32_Stfd_M = 0,
};
#endif
