/**
 * @file
 * @brief  The generated interface for the register allocator.
 *          Contains register classes and types and register constraints
 *          for all nodes where constraints were given in spec.
 * @note    DO NOT EDIT THIS FILE, your changes will be lost.
 *          Edit libfirm/ir/be/ppc32/ppc32_spec.pl instead.
 *          created by: libfirm/ir/be/scripts/generate_regalloc_if.pl libfirm/ir/be/ppc32/ppc32_spec.pl libfirm/ir/be/ppc32
 * $date    Tue Jan 20 10:57:59 2009
 */
#include "config.h"

#include "gen_ppc32_regalloc_if.h"
#include "gen_ppc32_machine.h"
#include "bearch_ppc32_t.h"
#include "ppc32_map_regs.h"
#include "irmode.h"

arch_register_class_t ppc32_reg_classes[] = {
	{ 0, "ppc32_link", N_ppc32_link_REGS, NULL, ppc32_link_regs, 0 },
	{ 1, "ppc32_count", N_ppc32_count_REGS, NULL, ppc32_count_regs, 0 },
	{ 2, "ppc32_gp", N_ppc32_gp_REGS, NULL, ppc32_gp_regs, 0 },
	{ 3, "ppc32_fp", N_ppc32_fp_REGS, NULL, ppc32_fp_regs, 0 },
	{ 4, "ppc32_condition", N_ppc32_condition_REGS, NULL, ppc32_condition_regs, 0 }
};

const arch_register_t ppc32_link_regs[N_ppc32_link_REGS] = {
	{
		"lr",
		&ppc32_reg_classes[CLASS_ppc32_link],
		REG_LR,
		arch_register_type_ignore
	},
};
const arch_register_t ppc32_count_regs[N_ppc32_count_REGS] = {
	{
		"ctr",
		&ppc32_reg_classes[CLASS_ppc32_count],
		REG_CTR,
		arch_register_type_caller_save
	},
};
const arch_register_t ppc32_gp_regs[N_ppc32_gp_REGS] = {
	{
		"r0",
		&ppc32_reg_classes[CLASS_ppc32_gp],
		REG_R0,
		arch_register_type_caller_save
	},
	{
		"r2",
		&ppc32_reg_classes[CLASS_ppc32_gp],
		REG_R2,
		arch_register_type_caller_save
	},
	{
		"r3",
		&ppc32_reg_classes[CLASS_ppc32_gp],
		REG_R3,
		arch_register_type_caller_save
	},
	{
		"r4",
		&ppc32_reg_classes[CLASS_ppc32_gp],
		REG_R4,
		arch_register_type_caller_save
	},
	{
		"r5",
		&ppc32_reg_classes[CLASS_ppc32_gp],
		REG_R5,
		arch_register_type_caller_save
	},
	{
		"r6",
		&ppc32_reg_classes[CLASS_ppc32_gp],
		REG_R6,
		arch_register_type_caller_save
	},
	{
		"r7",
		&ppc32_reg_classes[CLASS_ppc32_gp],
		REG_R7,
		arch_register_type_caller_save
	},
	{
		"r8",
		&ppc32_reg_classes[CLASS_ppc32_gp],
		REG_R8,
		arch_register_type_caller_save
	},
	{
		"r9",
		&ppc32_reg_classes[CLASS_ppc32_gp],
		REG_R9,
		arch_register_type_caller_save
	},
	{
		"r10",
		&ppc32_reg_classes[CLASS_ppc32_gp],
		REG_R10,
		arch_register_type_caller_save
	},
	{
		"r13",
		&ppc32_reg_classes[CLASS_ppc32_gp],
		REG_R13,
		arch_register_type_callee_save
	},
	{
		"r14",
		&ppc32_reg_classes[CLASS_ppc32_gp],
		REG_R14,
		arch_register_type_callee_save
	},
	{
		"r15",
		&ppc32_reg_classes[CLASS_ppc32_gp],
		REG_R15,
		arch_register_type_callee_save
	},
	{
		"r31",
		&ppc32_reg_classes[CLASS_ppc32_gp],
		REG_R31,
		arch_register_type_callee_save
	},
	{
		"r1",
		&ppc32_reg_classes[CLASS_ppc32_gp],
		REG_R1,
		arch_register_type_callee_save | arch_register_type_ignore
	},
};
const arch_register_t ppc32_fp_regs[N_ppc32_fp_REGS] = {
	{
		"f1",
		&ppc32_reg_classes[CLASS_ppc32_fp],
		REG_F1,
		arch_register_type_caller_save
	},
	{
		"f2",
		&ppc32_reg_classes[CLASS_ppc32_fp],
		REG_F2,
		arch_register_type_caller_save
	},
	{
		"f3",
		&ppc32_reg_classes[CLASS_ppc32_fp],
		REG_F3,
		arch_register_type_caller_save
	},
	{
		"f4",
		&ppc32_reg_classes[CLASS_ppc32_fp],
		REG_F4,
		arch_register_type_caller_save
	},
	{
		"f5",
		&ppc32_reg_classes[CLASS_ppc32_fp],
		REG_F5,
		arch_register_type_caller_save
	},
	{
		"f6",
		&ppc32_reg_classes[CLASS_ppc32_fp],
		REG_F6,
		arch_register_type_caller_save
	},
	{
		"f7",
		&ppc32_reg_classes[CLASS_ppc32_fp],
		REG_F7,
		arch_register_type_caller_save
	},
	{
		"f8",
		&ppc32_reg_classes[CLASS_ppc32_fp],
		REG_F8,
		arch_register_type_caller_save
	},
	{
		"f9",
		&ppc32_reg_classes[CLASS_ppc32_fp],
		REG_F9,
		arch_register_type_caller_save
	},
	{
		"f10",
		&ppc32_reg_classes[CLASS_ppc32_fp],
		REG_F10,
		arch_register_type_caller_save
	},
	{
		"f11",
		&ppc32_reg_classes[CLASS_ppc32_fp],
		REG_F11,
		arch_register_type_caller_save
	},
	{
		"f12",
		&ppc32_reg_classes[CLASS_ppc32_fp],
		REG_F12,
		arch_register_type_caller_save
	},
	{
		"f13",
		&ppc32_reg_classes[CLASS_ppc32_fp],
		REG_F13,
		arch_register_type_caller_save
	},
	{
		"f14",
		&ppc32_reg_classes[CLASS_ppc32_fp],
		REG_F14,
		arch_register_type_callee_save
	},
	{
		"f15",
		&ppc32_reg_classes[CLASS_ppc32_fp],
		REG_F15,
		arch_register_type_callee_save
	},
	{
		"f16",
		&ppc32_reg_classes[CLASS_ppc32_fp],
		REG_F16,
		arch_register_type_callee_save
	},
};
const arch_register_t ppc32_condition_regs[N_ppc32_condition_REGS] = {
	{
		"cr0",
		&ppc32_reg_classes[CLASS_ppc32_condition],
		REG_CR0,
		arch_register_type_caller_save
	},
	{
		"cr1",
		&ppc32_reg_classes[CLASS_ppc32_condition],
		REG_CR1,
		arch_register_type_caller_save
	},
	{
		"cr2",
		&ppc32_reg_classes[CLASS_ppc32_condition],
		REG_CR2,
		arch_register_type_callee_save
	},
	{
		"cr3",
		&ppc32_reg_classes[CLASS_ppc32_condition],
		REG_CR3,
		arch_register_type_callee_save
	},
	{
		"cr4",
		&ppc32_reg_classes[CLASS_ppc32_condition],
		REG_CR4,
		arch_register_type_callee_save
	},
	{
		"cr5",
		&ppc32_reg_classes[CLASS_ppc32_condition],
		REG_CR5,
		arch_register_type_caller_save
	},
	{
		"cr6",
		&ppc32_reg_classes[CLASS_ppc32_condition],
		REG_CR6,
		arch_register_type_caller_save
	},
};

void ppc32_register_init(void) {
	/* set largest possible mode for 'ppc32_link' */
	ppc32_reg_classes[CLASS_ppc32_link].mode = mode_P;

	/* set largest possible mode for 'ppc32_count' */
	ppc32_reg_classes[CLASS_ppc32_count].mode = mode_P;

	/* set largest possible mode for 'ppc32_gp' */
	ppc32_reg_classes[CLASS_ppc32_gp].mode = mode_P;

	/* set largest possible mode for 'ppc32_fp' */
	ppc32_reg_classes[CLASS_ppc32_fp].mode = mode_D;

	/* set largest possible mode for 'ppc32_condition' */
	ppc32_reg_classes[CLASS_ppc32_condition].mode = mode_P;

}

