
	case iro_Abs:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Abs(current_ir_graph, get_node(env, preds[0]), prednodes[0], mode);
		
		break;
	}
	case iro_Add:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Add(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], mode);
		
		break;
	}
	case iro_Alloc:
	{
		
		ir_type *type = read_type(env);
		ir_where_alloc where = (ir_where_alloc) read_long(env);
		
		
		
		newnode = new_r_Alloc(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], type, where);
		
		break;
	}
	case iro_And:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_And(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], mode);
		
		break;
	}
	case iro_Bad:
	{
		
		
		
		
		newnode = new_r_Bad(current_ir_graph);
		
		break;
	}
	case iro_Borrow:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Borrow(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], mode);
		
		break;
	}
	case iro_Bound:
	{
		
		op_pin_state state = read_pin_state(env);
		
		
		
		newnode = new_r_Bound(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], prednodes[2], prednodes[3]);
		set_irn_pinned(newnode, state);
		
		break;
	}
	case iro_Break:
	{
		
		
		
		
		newnode = new_r_Break(current_ir_graph, get_node(env, preds[0]));
		
		break;
	}
	case iro_Builtin:
	{
		
		ir_builtin_kind kind = read_builtin_kind(env);
		ir_type *type = read_type(env);
		op_pin_state state = read_pin_state(env);
		
		
		
		newnode = new_r_Builtin(current_ir_graph, get_node(env, preds[0]), prednodes[0], numpreds - 2, prednodes + 1, kind, type);
		set_irn_pinned(newnode, state);
		
		break;
	}
	case iro_Call:
	{
		
		ir_type *type = read_type(env);
		op_pin_state state = read_pin_state(env);
		
		
		
		newnode = new_r_Call(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], numpreds - 3, prednodes + 2, type);
		set_irn_pinned(newnode, state);
		
		break;
	}
	case iro_CallBegin:
	{
		
		// BAD: ir_node* call
			ir_node* call = (ir_node*) 0;
		
		
		
		newnode = new_r_CallBegin(current_ir_graph, get_node(env, preds[0]), prednodes[0], call);
		
		break;
	}
	case iro_Carry:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Carry(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], mode);
		
		break;
	}
	case iro_Cast:
	{
		
		ir_type *type = read_type(env);
		
		
		
		newnode = new_r_Cast(current_ir_graph, get_node(env, preds[0]), prednodes[0], type);
		
		break;
	}
	case iro_Cmp:
	{
		
		
		
		
		newnode = new_r_Cmp(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1]);
		
		break;
	}
	case iro_Cond:
	{
		
		cond_kind kind = read_cond_kind(env);
		long default_proj = read_long(env);
		cond_jmp_predicate jmp_pred = read_cond_jmp_predicate(env);
		
		
		
		newnode = new_r_Cond(current_ir_graph, get_node(env, preds[0]), prednodes[0]);
		set_Cond_kind(newnode, kind);
		set_Cond_default_proj(newnode, default_proj);
		set_Cond_jmp_pred(newnode, jmp_pred);
		
		break;
	}
	case iro_Confirm:
	{
		
		pn_Cmp cmp = (pn_Cmp) read_long(env);
		
		
		
		newnode = new_r_Confirm(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], cmp);
		
		break;
	}
	case iro_Const:
	{
		
		tarval *tarval = read_tv(env);
		
		
		
		newnode = new_r_Const(current_ir_graph, tarval);
		
		break;
	}
	case iro_Conv:
	{
		ir_mode *mode = read_mode(env);
		int strict = (int) read_long(env);
		
		
		if(strict == 1)
			newnode = new_r_strictConv(current_ir_graph, get_node(env, preds[0]), prednodes[0], mode);
		else
		newnode = new_r_Conv(current_ir_graph, get_node(env, preds[0]), prednodes[0], mode);
		
		break;
	}
	case iro_CopyB:
	{
		
		ir_type *type = read_type(env);
		op_pin_state state = read_pin_state(env);
		
		
		
		newnode = new_r_CopyB(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], prednodes[2], type);
		set_irn_pinned(newnode, state);
		
		break;
	}
	case iro_Div:
	{
		
		ir_mode *resmode = read_mode(env);
		int no_remainder = (int) read_long(env);
		op_pin_state state = read_pin_state(env);
		
		
		if(no_remainder == 1)
			newnode = new_r_DivRL(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], prednodes[2], resmode, state);
		else
		newnode = new_r_Div(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], prednodes[2], resmode, state);
		
		break;
	}
	case iro_DivMod:
	{
		
		ir_mode *resmode = read_mode(env);
		op_pin_state state = read_pin_state(env);
		
		
		
		newnode = new_r_DivMod(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], prednodes[2], resmode, state);
		
		break;
	}
	case iro_Dummy:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Dummy(current_ir_graph, mode);
		
		break;
	}
	case iro_Eor:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Eor(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], mode);
		
		break;
	}
	case iro_Filter:
	{
		ir_mode *mode = read_mode(env);
		long proj = read_long(env);
		
		
		
		newnode = new_r_Filter(current_ir_graph, get_node(env, preds[0]), prednodes[0], mode, proj);
		
		break;
	}
	case iro_Free:
	{
		
		ir_type *type = read_type(env);
		ir_where_alloc where = (ir_where_alloc) read_long(env);
		
		
		
		newnode = new_r_Free(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], prednodes[2], type, where);
		
		break;
	}
	case iro_Id:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Id(current_ir_graph, get_node(env, preds[0]), prednodes[0], mode);
		
		break;
	}
	case iro_IJmp:
	{
		
		
		
		
		newnode = new_r_IJmp(current_ir_graph, get_node(env, preds[0]), prednodes[0]);
		
		break;
	}
	case iro_InstOf:
	{
		
		ir_type *type = read_type(env);
		op_pin_state state = read_pin_state(env);
		
		
		
		newnode = new_r_InstOf(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], type);
		set_irn_pinned(newnode, state);
		
		break;
	}
	case iro_Jmp:
	{
		
		
		
		
		newnode = new_r_Jmp(current_ir_graph, get_node(env, preds[0]));
		
		break;
	}
	case iro_Load:
	{
		
		ir_mode *mode = read_mode(env);
		op_pin_state state = read_pin_state(env);
		
		ir_cons_flags flags = get_cons_flags(env);
		
		
		newnode = new_r_Load(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], mode, flags);
		set_irn_pinned(newnode, state);
		
		break;
	}
	case iro_Minus:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Minus(current_ir_graph, get_node(env, preds[0]), prednodes[0], mode);
		
		break;
	}
	case iro_Mod:
	{
		
		ir_mode *resmode = read_mode(env);
		op_pin_state state = read_pin_state(env);
		
		
		
		newnode = new_r_Mod(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], prednodes[2], resmode, state);
		
		break;
	}
	case iro_Mul:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Mul(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], mode);
		
		break;
	}
	case iro_Mulh:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Mulh(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], mode);
		
		break;
	}
	case iro_Mux:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Mux(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], prednodes[2], mode);
		
		break;
	}
	case iro_NoMem:
	{
		
		
		
		
		newnode = new_r_NoMem(current_ir_graph);
		
		break;
	}
	case iro_Not:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Not(current_ir_graph, get_node(env, preds[0]), prednodes[0], mode);
		
		break;
	}
	case iro_Or:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Or(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], mode);
		
		break;
	}
	case iro_Phi:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Phi(current_ir_graph, get_node(env, preds[0]), numpreds - 1, prednodes + 0, mode);
		
		break;
	}
	case iro_Pin:
	{
		
		
		
		
		newnode = new_r_Pin(current_ir_graph, get_node(env, preds[0]), prednodes[0]);
		
		break;
	}
	case iro_Proj:
	{
		ir_mode *mode = read_mode(env);
		long proj = read_long(env);
		
		
		
		newnode = new_r_Proj(current_ir_graph, get_node(env, preds[0]), prednodes[0], mode, proj);
		
		break;
	}
	case iro_Quot:
	{
		
		ir_mode *resmode = read_mode(env);
		op_pin_state state = read_pin_state(env);
		
		
		
		newnode = new_r_Quot(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], prednodes[2], resmode, state);
		
		break;
	}
	case iro_Raise:
	{
		
		
		
		
		newnode = new_r_Raise(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1]);
		
		break;
	}
	case iro_Return:
	{
		
		
		
		
		newnode = new_r_Return(current_ir_graph, get_node(env, preds[0]), prednodes[0], numpreds - 2, prednodes + 1);
		
		break;
	}
	case iro_Rotl:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Rotl(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], mode);
		
		break;
	}
	case iro_Sel:
	{
		
		ir_entity *entity = read_entity(env);
		
		
		
		newnode = new_r_Sel(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], numpreds - 3, prednodes + 2, entity);
		
		break;
	}
	case iro_Shl:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Shl(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], mode);
		
		break;
	}
	case iro_Shr:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Shr(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], mode);
		
		break;
	}
	case iro_Shrs:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Shrs(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], mode);
		
		break;
	}
	case iro_Store:
	{
		
		op_pin_state state = read_pin_state(env);
		
		ir_cons_flags flags = get_cons_flags(env);
		
		
		newnode = new_r_Store(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], prednodes[2], flags);
		set_irn_pinned(newnode, state);
		
		break;
	}
	case iro_Sub:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Sub(current_ir_graph, get_node(env, preds[0]), prednodes[0], prednodes[1], mode);
		
		break;
	}
	case iro_Sync:
	{
		
		
		
		
		newnode = new_r_Sync(current_ir_graph, get_node(env, preds[0]), numpreds - 1, prednodes + 0);
		
		break;
	}
	case iro_Tuple:
	{
		
		
		
		
		newnode = new_r_Tuple(current_ir_graph, get_node(env, preds[0]), numpreds - 1, prednodes + 0);
		
		break;
	}
	case iro_Unknown:
	{
		ir_mode *mode = read_mode(env);
		
		
		
		newnode = new_r_Unknown(current_ir_graph, mode);
		
		break;
	}
