/*  Programmable IRC function library 
    Copyright (C) 1999-2000 Jorgen Sigvardsson <jorgen@cs.kau.se>
    $Id: irc_core.h,v 1.4 2000/01/06 14:18:18 jorgen Exp $
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __IRC_CORE_H__
#define __IRC_CORE_H__

#include <glib.h>
#include <sys/select.h>
#include <btypes.h>

/* Macros and constants */
#define CALLBACK(x) void x( srv_h srv,		\
                            gcstring prefix,	\
                            gcstring cmd,	\
                            gstring* params,	\
			    guint numparams)
#define ERRORHANDLER(x) void x( srv_h srv,		\
                                gint errcode,   )

typedef struct _srv* srv_h;
/* Types */
typedef void (*callback_t)(srv_h, gcstring, gcstring, gstring*, guint);
typedef void (*errhandler_t)(srv_h, gint);

/* Structures */
struct _srv
{
    int fd;
};

/* Function prototypes - low level functions */
srv_h irc_connect(	gcstring server, 
			gushort port, 
			gcstring nick, 
			gcstring user, 
			gcstring fullname	);
void irc_disconnect(	srv_h server		);
void irc_set_callback(	callback_t cb, 
			gcstring cmd		);
void irc_set_errhandler(errhandler_t errh	);
void irc_main(		void			);
gint irc_getfdset(	fd_set* set		);
gint irc_handle_server(	srv_h server		);
srv_h irc_nextsrv(	fd_set* set		);
void irc_write_raw(	srv_h server, 
			gcstring rawtext	);
void irc_write_cmd(	srv_h server, 
			gcstring cmd, 
			gcstring params	);
void irc_add_server_listener(srv_h server	);
void irc_remove_server_listener(srv_h server	);

/* Function prototypes - high level IRC functions */
/* Before you start to use these functions, look them up
   in the RFC 1459 for more information about their parameters
   and such. 
   
   irc_do_XXXX corresponds to message XXXX.
   
*/
/* Messaging operations */
void irc_do_privmsg(	srv_h srv, 
			gcstring to, 
			gcstring msg		);
void irc_do_notice(	srv_h srv, 
			gcstring to, 
			gcstring msg		);
/* Channel operations */
void irc_do_join(	srv_h srv, 
			gcstring channel,
			gcstring key		);
void irc_do_part(	srv_h srv, 
			gcstring channel	);
void irc_do_chan_mode(	srv_h srv,
			gcstring channel,
			gcstring mode,
			gcstring limit,
			gcstring user,
			gcstring banmask	);
void irc_do_user_mode(	srv_h srv,
			gcstring user,
			gcstring mode		);
void irc_do_topic(	srv_h srv,
			gcstring channel,
			gcstring topic		);
void irc_do_names(	srv_h srv,
			gcstring channellist	);

void irc_do_list(	srv_h srv,
			gcstring channellist,
			gcstring server		);
void irc_do_invite(	srv_h srv,
			gcstring nick,
			gcstring channel	);
void irc_do_kick(	srv_h srv,
			gcstring channel,
			gcstring nick,
			gcstring reason		);
/* Server operations */
void irc_do_version(	srv_h srv,
			gcstring server		);
void irc_do_stats(	srv_h srv,
			gcstring query,
			gcstring server		);
void irc_do_links(	srv_h srv,
			gcstring remote_server,
			gcstring server_mask	);
void irc_do_time(	srv_h srv,
			gcstring server		);
void irc_do_connect(	srv_h srv,
			gcstring targ_server,
			gcstring port,
			gcstring remote_server	);
void irc_do_trace(	srv_h srv,
			gcstring server		);
void irc_do_admin(	srv_h srv,
			gcstring server		);
void irc_do_info(	srv_h srv,
			gcstring server		);

/* User based queries */
void irc_do_who(	srv_h srv,
			gcstring name,
			gboolean opersOnly	);
void irc_do_whois(	srv_h srv,
			gcstring server,
			gcstring nickmasklist	);
void irc_do_whowas(	srv_h srv,
			gcstring nick,
			gcstring count,
			gcstring server		);
/* Misc operations */
void irc_do_ping(	srv_h srv,
			gcstring arg		);
void irc_do_pong(	srv_h srv,
			gcstring arg		);
void irc_do_quit(	srv_h srv,
			gcstring reason		);
void irc_do_oper(	srv_h srv,
			gcstring user,
			gcstring password	);
void irc_do_kill(	srv_h srv,
			gcstring nick,
			gcstring reason		);

/* Optional operations */
void irc_do_away(	srv_h srv,
			gcstring message	);
void irc_do_rehash(	srv_h srv		);
void irc_do_restart(	srv_h srv		);
void irc_do_summon(	srv_h srv, 
			gcstring user,
			gcstring server		);
void irc_do_users(	srv_h srv,
			gcstring server		);
void irc_do_wallops(	srv_h srv,
			gcstring message	);
void irc_do_userhost(	srv_h srv,
			gcstring nicklist	);
void irc_do_ison(	srv_h srv,
			gcstring nicklist	);

#endif /* __IRC_CORE_H__ */
