/*  Programmable IRC function library 
    Copyright (C) 1999-2000 Jorgen Sigvardsson <jorgen@cs.kau.se>
    $Id: main.c,v 1.5 2000/01/06 14:18:21 jorgen Exp $
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <stdio.h>
#include <errno.h>

#include <irc_core.h>
#include <cmd.h>
#include <ctcp.h>

CALLBACK(ping) {
    printf("I got a ping...\n");
    irc_do_pong(srv, params[0]);
}

CALLBACK(general) {
    guint i;

    fprintf(stderr, "Start---------------\n");
    fprintf(stderr, "Prefix = '%s'\n", prefix);
    fprintf(stderr, "Cmd = '%s'\n", cmd);
    for(i = 0; i < numparams; i++) {
	fprintf(stderr, "Param[%d] = '%s'\n", i, params[i]);
    }
    fprintf(stderr, "End-----------------\n");
}

CTCP_CALLBACK(action)
{
    fprintf(stderr, "* %s %s\n", from, params);
}

CTCP_CALLBACK(version) 
{
    gchar* i;
    if(isRequest) {
	fprintf(stderr, "[CTCP VERSION REQ] from %s\n", from);
	/* find the '!' in the 'from' field and strip it out.
	   from is on the form nick!user@host while IRC uses 
	   nick as recipients */
	i = (gchar*)from; while(*i != '!' && *i != '\0') i++; *i = '\0';
	ctcp_resp_version(srv, from, 
			  "testIRC 0.1 based on libirc 0.1 - "
			  "Debian GNU/Linux - "
			  "jorgen@cs.kau.se");
    } else {
	fprintf(stderr, "[CTCP VERSION RESP] from %s - %s\n",
		from, params);
    }
}

CALLBACK(privmsg) {
    
    if(*params[1] == '\001')  /* CTCP! - reroute to ctcp layer  */
	ctcp_dispatch_msg(srv, prefix, TRUE, params[1]);
    else 
	fprintf(stderr, "<(%s)>/%s %s\n", prefix, params[0], params[1]);
}
CALLBACK(notice) {
    if(*params[1] == '\001')  /* CTCP! - reroute to ctcp layer */
	ctcp_dispatch_msg(srv, prefix, FALSE, params[1]);
    else
	fprintf(stderr, "[NOTICE] <(%s)>/%s %s\n", prefix, params[0], params[1]);
}

CALLBACK(act_now) {
    /*
    irc_do_join(srv, "#channel", "");
    irc_do_privmsg(srv, "#channel", "Yooooo hoooo!");
    ctcp_do_action(srv, "#channel", "rular!");
    ctcp_do_action(srv, "#channel", "is using libirc.");
    ctcp_req_version(srv, "#channel");
    */
    irc_do_join(srv, "#karlstad", "");
    irc_do_privmsg(srv, "#karlstad", "Affe zu Affe und Stork zu Stork.");
}

void my_main(srv_h srv)
{
    fd_set set;
    int maxfd;
    gchar buf[100];
    srv_h i;

    printf("Prompt> ");
    while(1) {
	
	maxfd = irc_getfdset(&set);
	if(maxfd < 0) { /* No more servers to keep track of... */
	    break;  
	}
	FD_SET(0, &set);
	while(1) {
	    if(select(maxfd + 1, &set, 0, 0, 0) < 0) {
		if(errno != EINTR) {
		    perror("select");
		    return;
		}
	    }
	    else break;
	}

	if(FD_ISSET(0, &set)) {
	    irc_write_raw(srv, gets(buf));
	    printf("Prompt> ");
	}

	while((i = irc_nextsrv(&set))) {
	    if(irc_handle_server(i) < 0) {
		irc_remove_server_listener(i);
		irc_disconnect(i);
	    }
	}
    }
}

int main(void) 
{
    srv_h srv;
    
    srv = irc_connect("irc.ludd.luth.se", 6668,
		      "kr4x", "jorgen", "jorgen");
    irc_add_server_listener(srv);
    irc_set_callback(ping, CMD_PING);
/*  irc_set_callback(general, "001");
    irc_set_callback(general, "002");
    irc_set_callback(general, "003");
    irc_set_callback(general, "004"); */
    irc_set_callback(privmsg, CMD_PRIVMSG);
    irc_set_callback(notice, CMD_NOTICE);
    irc_set_callback(act_now, "376");
    ctcp_set_callback(action, CMD_CTCP_ACTION);
    ctcp_set_callback(version, CMD_CTCP_VERSION);
    my_main(srv);
    /* irc_main(); */
    return 0;
}
