/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 * <<< Description >>>
 *
 * Private buf, bufel, and bufc interfaces.
 *
 ****************************************************************************/

#ifdef _LIBSTASH_DBG
#  define _CW_BUF_MAGIC 0xb00f0001
#  define _CW_BUFEL_MAGIC 0xb00f0002
#  define _CW_BUFC_MAGIC 0xb00f0003
#endif

static cw_buf_t *
buf_p_new(cw_buf_t * a_buf, cw_bool_t a_is_threadsafe);

static void
buf_p_rebuild_cumulative_index(cw_buf_t * a_buf);

static void
buf_p_get_data_position(cw_buf_t * a_buf,
			cw_uint32_t a_offset,
			cw_uint32_t * a_array_element,
			cw_uint32_t * a_bufel_offset);

static cw_bool_t
buf_p_fit_array(cw_buf_t * a_buf, cw_uint32_t a_min_array_size);

static cw_bool_t
buf_p_catenate_buf(cw_buf_t * a_a, cw_buf_t * a_b, cw_bool_t a_preserve);

#if (defined(_LIBSTASH_DBG) || defined(_LIBSTASH_DEBUG))
static void
buf_p_copy_array(cw_buf_t * a_a, cw_buf_t * a_b,
		 cw_uint32_t a_num_elements,
		 cw_uint32_t a_a_start, cw_uint32_t a_b_start,
		 cw_bool_t a_is_destructive);
#else
static void
buf_p_copy_array(cw_buf_t * a_a, cw_buf_t * a_b,
		 cw_uint32_t a_num_elements,
		 cw_uint32_t a_a_start, cw_uint32_t a_b_start);
#endif

static cw_bool_t
buf_p_make_range_writeable(cw_buf_t * a_buf, cw_uint32_t a_offset,
			   cw_uint32_t a_length);

static void
bufc_p_dump(cw_bufc_t * a_bufc, const char * a_prefix);

static cw_bool_t
bufc_p_get_is_writeable(cw_bufc_t * a_bufc);

static cw_uint32_t
bufc_p_get_ref_count(cw_bufc_t * a_bufc);

static void
bufc_p_ref_increment(cw_bufc_t * a_bufc);
