/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 * <<< Description >>>
 *
 * jtl test.
 *
 ****************************************************************************/

#include <libstash/libstash_r.h>

#define _LIBSTASH_TEST_NUM_THREADS 100

struct foo_var_s
{
  cw_bool_t is_tlock;
  cw_uint32_t thd_num;
  cw_jtl_t * lock;
  cw_jtl_tq_el_t * tq_el;
};

void * 
thread_entry_func(void * a_arg)
{
  struct foo_var_s * foo_var = (struct foo_var_s *) a_arg;

  if (foo_var->is_tlock == TRUE)
  {
    /* Grab tlock. */
    jtl_tlock(foo_var->lock, foo_var->tq_el);
    usleep(1);
    out_put_e(cw_g_out, NULL, 0, "thread_entry_func",
	      "Thread [i] has tlock\n", foo_var->thd_num);
    jtl_tunlock(foo_var->lock);
  }
  else
  {
    /* Grab slock. */
    jtl_slock(foo_var->lock);
/*      out_put_e(cw_g_out, NULL, 0, "thread_entry_func", */
/*  		"Thread [i] has slock\n", foo_var->thd_num); */

    jtl_2qlock(foo_var->lock);
/*      out_put_e(cw_g_out, NULL, 0, "thread_entry_func", */
/*  		"Thread [i] has qlock\n", foo_var->thd_num); */
    jtl_qunlock(foo_var->lock);

    jtl_2rlock(foo_var->lock);
/*      out_put_e(cw_g_out, NULL, 0, "thread_entry_func", */
/*  		"Thread [i] has rlock\n", foo_var->thd_num); */
    jtl_runlock(foo_var->lock);

    jtl_2wlock(foo_var->lock);
/*      out_put_e(cw_g_out, NULL, 0, "thread_entry_func", */
/*  		"Thread [i] has wlock\n", foo_var->thd_num); */
    jtl_wunlock(foo_var->lock);

    jtl_2xlock(foo_var->lock);
/*      out_put_e(cw_g_out, NULL, 0, "thread_entry_func", */
/*  		"Thread [i] has xlock\n", foo_var->thd_num); */
    jtl_xunlock(foo_var->lock);
  } 
/*    out_put_e(cw_g_out, NULL, 0, "thread_entry_func", */
/*  	     "Thread [i] is done\n", foo_var->thd_num); */
  _cw_free(foo_var);
    
  return NULL;
}

int
main()
{
  cw_thd_t tl_threads[_LIBSTASH_TEST_NUM_THREADS],
    sl_threads[_LIBSTASH_TEST_NUM_THREADS];
  cw_jtl_tq_el_t * tq_els[_LIBSTASH_TEST_NUM_THREADS];
  cw_jtl_t jtl_a, * jtl_b;
  cw_jtl_tq_el_t * tq_el;
  struct foo_var_s * foo_var;
  cw_uint32_t i;
  
  libstash_init();
  out_put(cw_g_out, "Test begin\n");

  _cw_assert(&jtl_a == jtl_new(&jtl_a));

  jtl_slock(&jtl_a);
  jtl_2qlock(&jtl_a);
  jtl_2rlock(&jtl_a);
  jtl_2qlock(&jtl_a);
  jtl_slock(&jtl_a);
  jtl_2rlock(&jtl_a);
  jtl_qunlock(&jtl_a);
  jtl_qunlock(&jtl_a);
  jtl_2wlock(&jtl_a);
  jtl_2rlock(&jtl_a);
  jtl_wunlock(&jtl_a);
  jtl_runlock(&jtl_a);
  jtl_runlock(&jtl_a);
  jtl_runlock(&jtl_a);
  jtl_2xlock(&jtl_a);
  jtl_sunlock(&jtl_a);
  jtl_xunlock(&jtl_a);
  jtl_sunlock(&jtl_a);
  tq_el = jtl_get_tq_el(&jtl_a);
  jtl_tlock(&jtl_a, tq_el);
  jtl_tunlock(&jtl_a);
  jtl_delete(&jtl_a);

  jtl_b = jtl_new(NULL);

  for (i = 0; i < _LIBSTASH_TEST_NUM_THREADS; i++)
  {
    tq_els[i] = jtl_get_tq_el(jtl_b);
  }
  
  for (i = 0; i < _LIBSTASH_TEST_NUM_THREADS; i++)
  {
    foo_var = (struct foo_var_s *) _cw_malloc(sizeof(struct foo_var_s));
    foo_var->is_tlock = TRUE;
    foo_var->thd_num = i;
    foo_var->tq_el = tq_els[i];
    foo_var->lock = jtl_b;
    thd_new(&tl_threads[i], thread_entry_func, (void *) foo_var);
    
    foo_var = (struct foo_var_s *) _cw_malloc(sizeof(struct foo_var_s));
    foo_var->is_tlock = FALSE;
    foo_var->thd_num = i;
    foo_var->lock = jtl_b;
    thd_new(&sl_threads[i], thread_entry_func, (void *) foo_var);
  }

  for (i = 0; i < _LIBSTASH_TEST_NUM_THREADS; i++)
  {
    thd_join(&tl_threads[i]);
    thd_join(&sl_threads[i]);
  }

  jtl_delete(jtl_b);
  
  out_put(cw_g_out, "Test end\n");
  libstash_shutdown();
  return 0;
}
