/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 * <<< Description >>>
 *
 * mtx test.
 *
 ****************************************************************************/

#include <libstash/libstash_r.h>

#define _LIBSTASH_TEST_COUNT 50

cw_uint32_t g_count = 0;

void *
thread_entry_func(void * a_arg)
{
  cw_uint32_t i, temp;
  cw_mtx_t * mutex = (cw_mtx_t *) a_arg;

  for (i = 0; i < _LIBSTASH_TEST_COUNT; i++)
  {
    mtx_lock(mutex);
    temp = g_count;
    usleep(1);
    temp++;
    g_count = temp;
    mtx_unlock(mutex);
  }

  return NULL;
}

int
main()
{
  cw_thd_t thread_a, thread_b;
  cw_mtx_t mutex_a, * mutex_b;
  
  libstash_init();
  out_put(cw_g_out, "Test begin\n");

  _cw_assert(&mutex_a == mtx_new(&mutex_a));
  /* Unlocked. */
  mtx_lock(&mutex_a);
  /* Locked. */
  mtx_unlock(&mutex_a);
  /* Unlocked. */
  _cw_assert(FALSE == mtx_trylock(&mutex_a));
  /* Locked. */
  _cw_assert(TRUE == mtx_trylock(&mutex_a));
  mtx_unlock(&mutex_a);
  /* Unlocked. */
  _cw_assert(FALSE == mtx_trylock(&mutex_a));
  /* Locked. */
  mtx_unlock(&mutex_a);
  /* Unlocked. */
  mtx_delete(&mutex_a);

  mutex_b = mtx_new(NULL);
  mtx_lock(mutex_b);
  _cw_assert(TRUE == mtx_trylock(mutex_b));
  mtx_unlock(mutex_b);
  mtx_delete(mutex_b);

  /* See if the mutex actually locks other threads out of critical
   * sections. */
  mtx_new(&mutex_a);

  thd_new(&thread_a, thread_entry_func, (void *) &mutex_a);
  thd_new(&thread_b, thread_entry_func, (void *) &mutex_a);

  thd_join(&thread_a);
  thd_join(&thread_b);
  mtx_delete(&mutex_a);

  out_put(cw_g_out, "g_count: [i]\n", g_count);
  
  out_put(cw_g_out, "Test end\n");
  libstash_shutdown();
  return 0;
}
