/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 * <<< Description >>>
 *
 * rwl test.
 *
 ****************************************************************************/

#include <libstash/libstash_r.h>

#define _LIBSTASH_TEST_NUM_THREADS 20

void *
thread_entry_func(void * a_arg)
{
  cw_rwl_t * lock = (cw_rwl_t *) a_arg;

  rwl_wlock(lock);
  out_put_e(cw_g_out, NULL, 0, "thread_entry_func",
	    "Got wlock\n");
  rwl_wunlock(lock);

  return NULL;
}

int
main()
{
  cw_thd_t threads[_LIBSTASH_TEST_NUM_THREADS];
  cw_rwl_t lock_a, * lock_b;
  cw_uint32_t i;
  
  libstash_init();
  out_put(cw_g_out, "Test begin\n");

  lock_b = rwl_new(NULL);
  _cw_check_ptr(lock_b);
  rwl_rlock(lock_b);
  rwl_rlock(lock_b);
  rwl_runlock(lock_b);
  rwl_runlock(lock_b);
  rwl_wlock(lock_b);
  rwl_wunlock(lock_b);
  rwl_delete(lock_b);
  
  _cw_assert(&lock_a == rwl_new(&lock_a));
  rwl_rlock(&lock_a);
  rwl_rlock(&lock_a);
  rwl_rlock(&lock_a);
  for (i = 0; i < _LIBSTASH_TEST_NUM_THREADS; i++)
  {
    thd_new(&threads[i], thread_entry_func, (void *) &lock_a);
  }
  out_put_e(cw_g_out, NULL, 0, "main", "About to release rlock\n");
  rwl_runlock(&lock_a);
  usleep(1);
  out_put_e(cw_g_out, NULL, 0, "main", "About to release rlock\n");
  rwl_runlock(&lock_a);
  usleep(1);
  out_put_e(cw_g_out, NULL, 0, "main", "About to release rlock\n");
  rwl_runlock(&lock_a);
  
  for (i = 0; i < _LIBSTASH_TEST_NUM_THREADS; i++)
  {
    thd_join(&threads[i]);
  }

  rwl_wlock(&lock_a);
  for (i = 0; i < _LIBSTASH_TEST_NUM_THREADS; i++)
  {
    thd_new(&threads[i], thread_entry_func, (void *) &lock_a);
  }
  out_put_e(cw_g_out, NULL, 0, "main", "About to release wlock\n");
  usleep(1);
  rwl_wunlock(&lock_a);

  for (i = 0; i < _LIBSTASH_TEST_NUM_THREADS; i++)
  {
    thd_join(&threads[i]);
  }
  
  rwl_delete(&lock_a);

  out_put(cw_g_out, "Test end\n");
  libstash_shutdown();
  return 0;
}
