/*
 * Copyright (c) 2010 Citrix Systems, Inc.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * This sample program demonstrates how to translate error strings into
 * enum_xen_api_failure, and vice versa.
 *
 */


#include <assert.h>
#include <stdio.h>
#include <string.h>

#include <xen/api/xen_api_failure.h>


static void print_code(enum xen_api_failure code, const char * str)
{
    printf("Code %d is string %s.\n", code, str);
}


int main()
{
    enum xen_api_failure internal_error =
        xen_api_failure_from_string("INTERNAL_ERROR");
    const char * handle_invalid =
        xen_api_failure_to_string(XEN_API_FAILURE_HANDLE_INVALID);

    assert(internal_error == XEN_API_FAILURE_INTERNAL_ERROR);
    assert(strcmp(handle_invalid, "HANDLE_INVALID") == 0);

    print_code(XEN_API_FAILURE_INTERNAL_ERROR, "INTERNAL_ERROR");
    print_code(XEN_API_FAILURE_HANDLE_INVALID, handle_invalid);

    return 0;
}
