.\" zip_dir_add.mdoc \-- add directory to zip archive
.\" Copyright (C) 2006-2012 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_DIR_ADD 3 "June 23, 2012" NiH
.SH "NAME"
zip_dir_add \- add directory to zip archive
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
zip_int64_t
zip_dir_add(struct zip *archive, const char *name); \
"zip_flags_t flags"
.SH "DESCRIPTION"
The function
zip_dir_add
adds a directory to a zip archive.
The argument
\fBarchive\fR
specifies the zip archive to which the directory should be added.
\fBname\fR
is the directory's name in the zip archive.
The
\fBflags\fR
argument can be any of:
.RS
.TP 22
\fBZIP_FL_ENC_GUESS\fR
Guess encoding of
\fBname\fR
(default).
.TP 22
\fBZIP_FL_ENC_UTF_8\fR
Interpret
\fBname\fR
as UTF-8.
.TP 22
\fBZIP_FL_ENC_CP437\fR
Interpret
\fBname\fR
as code page 437 (CP-437).
.RE
.SH "RETURN VALUES"
Upon successful completion, the index of the new entry in the archive
is returned.
Otherwise, \-1 is returned and the error code in
\fBarchive\fR
is set to indicate the error.
.SH "ERRORS"
zip_dir_add
fails if:
.RS
.TP 4
[ZIP_ER_EXISTS]
There is already an entry called
\fBname\fR
in the archive.
.TP 4
[ZIP_ER_INVAL]
\fBarchive\fR
or
\fBname\fR
are
\fBNULL,\fR
or invalid UTF-8 encoded file names.
.TP 4
[ZIP_ER_MEMORY]
Required memory could not be allocated.
.RE
.SH "SEE ALSO"
libzip(3),
zip_add(3)
.SH "AUTHORS"

Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
