/*
 * lat_mmap.c - time how fast a mapping can be made and broken down
 *
 * Usage: mmap size file
 *
 * XXX - If an implementation did lazy address space mapping, this test
 * will make that system look very good.  I haven't heard of such a system.
 *
 * Copyright (c) 1994 Larry McVoy.  Distributed under the FSF GPL with
 * additional restriction that results may published only if
 * (1) the benchmark is unmodified, and
 * (2) the version in the sccsid below is included in the report.
 * Support for this development by Sun Microsystems is gratefully acknowledged.
 */
char	*id = "$Id: lat_mmap.c,v 1.5 1996/05/30 07:33:07 lm Exp $\n";

#include "timing.h"
#include "bench.h"
#include <sys/stat.h>
#include <sys/mman.h>

#define	CHK(x)	if ((x) == -1) { perror("x"); exit(1); }

main(ac, av)
	char **av;
{
	int fd;
	int i;
	char *where;
	char *copy;
	int size;
	struct stat sbuf;
	int	N;

	if (ac != 3) {
		fprintf(stderr, "usage: %s size file\n", av[0]);
		exit(1);
	}
	size = atoi(av[1]);
	if ((last(av[1]) == 'k') || (last(av[1]) == 'K'))
		size *= 1024;
	if ((last(av[1]) == 'm') || (last(av[1]) == 'M'))
		size *= (1024 * 1024);
	CHK(fd = open(av[2], 0));
	CHK(fstat(fd, &sbuf));
	if (sbuf.st_size < size) {
		fprintf(stderr, "%s: file %s is not as big as size %d\n",
		    av[0], av[2], size);
		exit(1);
	}
	copy = valloc(size);
	bzero(copy, size);
	/*
	 * Do all the work, mmap & unmap for each I/O.
	 */
	N = 1;
	do {
		N <<= 2;
		start();
		for (i = 0; i < N; ++i) {
#ifdef	MAP_FILE
			where = mmap(0, size, PROT_READ, MAP_FILE|MAP_SHARED, fd, 0);
#else
			where = mmap(0, size, PROT_READ, MAP_SHARED, fd, 0);
#endif
			if ((int)where == -1) {
				perror("mmap");
				exit(1);
			}
			bcopy(where, copy, size);
			munmap(where, size);
		}
		i = stop();
	} while (i < ENOUGH);
	fprintf(stderr, "%.02f\t%d\t", size/1024., i / N);
	/*
	 * Pretend we have a cache, so you pay for the mapping only once.
	 */
	N = 1;
	do {
		N <<= 2;
		start();
#ifdef	MAP_FILE
		where = mmap(0, size, PROT_READ, MAP_FILE|MAP_SHARED, fd, 0);
#else
		where = mmap(0, size, PROT_READ, MAP_SHARED, fd, 0);
#endif
		if ((int)where == -1) {
			perror("mmap");
			exit(1);
		}
		for (i = 0; i < N; ++i) {
			bcopy(where, copy, size);
		}
		i = stop();
		munmap(where, size);
	} while (i < ENOUGH);
	fprintf(stderr, "%d\t", i / N);
	/*
	 * Do the work via read().
	 * I credit 3 usecs for the lseek.
	 */
	N = 1;
	do {
		N <<= 2;
		start();
		for (i = 0; i < N; ++i) {
			lseek(fd, 0, 0);
			read(fd, copy, size);
		}
		i = stop();
	} while (i < ENOUGH);
	fprintf(stderr, "%d\n", (i / N) - 3);
	exit(0);
}

last(s)
	char	*s;
{
	while (*s++)
		;
	return (s[-2]);
}
